;$Id: ppJdot_save.pro,v 1.3 2020/11/21 18:50:52 brandenb Exp $
if !d.name eq 'PS' then begin
  device,xsize=18,ysize=17.6,yoffset=3
  !p.charthick=3 & !p.thick=3 & !x.thick=3 & !y.thick=3
  col0=0
endif else begin
  col0=255
end
;
;  Fig.10 of the paper (Nov 2020)
;
@parameters
nuT=8e-5
;
ivar1=1 & ivar2=473 & ivar3=1
for ivar=ivar1,ivar2,ivar3 do begin
;
file='VAR'+str(ivar)+'.sav'
restore,'sav/'+file
;
nx=n_elements(xx)
ny=n_elements(yy)
dy=yy[1]-yy[0]
;
;  compute radial Omega gradient, r*dOm/dr = r*d(uphi/r)/dr
;
dom=fltarr(nx,ny)
for iy=0,ny-1 do dom[*,iy]=xx*deriv(xx,reform(uuu[*,iy,2]/xx))
;
JdotD=-4*!pi*(xx^3#sin(yy))*rrr*nuT       *dom[*,*  ]
JdotK=+4*!pi*(xx^3#sin(yy))*rrr*uuu[*,*,0]*uuu[*,*,2]
JdotM=-4*!pi*(xx^3#sin(yy))    *bbb[*,*,0]*bbb[*,*,2]
;
JdotDm=total(JdotD,2)*dy
JdotKm=total(JdotK,2)*dy
JdotMm=total(JdotM,2)*dy
;
yr=[1e-6,.5]
if ivar eq ivar1 then begin
  JdotDmt=JdotDm
  JdotKmt=JdotKm
  JdotMmt=JdotMm
  tt=t
  icount=1
endif else begin
  JdotDmt=[JdotDmt,JdotDm]
  JdotKmt=[JdotKmt,JdotKm]
  JdotMmt=[JdotMmt,JdotMm]
  tt=[tt,t]
  icount=icount+1
endelse
;
endfor
;
JdotDmt=reform(JdotDmt,nx,icount)
JdotKmt=reform(JdotKmt,nx,icount)
JdotMmt=reform(JdotMmt,nx,icount)
;
save,file='ppJdot_save.sav',JdotDmt,JdotKmt,JdotMmt,tt,xx
END
