;$Id: ppJdot.pro,v 1.6 2020/11/19 18:05:20 brandenb Exp $
if !d.name eq 'PS' then begin
  device,xsize=18,ysize=17.6,yoffset=3
  !p.charthick=3 & !p.thick=3 & !x.thick=3 & !y.thick=3
  col0=0
endif else begin
  col0=255
end
;
;  Fig.10 of the paper (Nov 2020)
;
siz=1.7
si2=1.5
!p.charsize=1.7
!x.margin=[7.4,1.3]
!y.margin=[3.2,0.2]
dot='!s!9!A .!n!6!r'
;
!x.range=[0,2.]
!y.range=[0,2.]
;
!p.multi=0
!p.multi=[0,1,2]
@parameters
nuT=8e-5
lat_crit=70.
;
;  panel (a)
;
iy=0
!x.title='!6'
!y.title=dot+'!6J!6/'+dot+'!6J!6!d0!n'
for lat_range=0,1 do begin
if lat_range eq 1 then !x.title='!8r!6/!8r!6!dc!n'
;
ivar1=406 & ivar2=428 & ivar3=2
for ivar=ivar1,ivar2,ivar3 do begin
;
yr_Jdot=[2.4e-7,8e-1]
file='VAR'+str(ivar)+'.sav'
restore,'sav/'+file
;
nx=n_elements(xx)
ny=n_elements(yy)
dy=yy[1]-yy[0]
;
;  compute radial Omega gradient, r*dOm/dr = r*d(uphi/r)/dr
;
dom=fltarr(nx,ny)
for iy=0,ny-1 do dom[*,iy]=xx*deriv(xx,reform(uuu[*,iy,2]/xx))
;
JdotD=-4*!pi*(xx^3#sin(yy))*rrr*nuT       *dom[*,*  ]
JdotK=+4*!pi*(xx^3#sin(yy))*rrr*uuu[*,*,0]*uuu[*,*,2]
JdotM=-4*!pi*(xx^3#sin(yy))    *bbb[*,*,0]*bbb[*,*,2]
;
;  select range in latitudes, generate 2-D array
;
yyy_degr=spread(yy/!dtor,[0],[nx])
if lat_range eq 0 then begin
  good=where(yyy_degr lt lat_crit)
endif else begin
  good=where(yyy_degr gt lat_crit)
endelse
nygood=n_elements(good)/nx
;
JdotDm=total(reform(JdotD(good),nx,nygood),2)*dy
JdotKm=total(reform(JdotK(good),nx,nygood),2)*dy
JdotMm=total(reform(JdotM(good),nx,nygood),2)*dy
;
yr=[1e-6,.5]
if ivar eq ivar1 then begin
  plot_io,xx,JdotKm,yr=yr,/nodata
  loadct,0
  polyfill,[.0,.2,.2,.0,.0],[yr[0],yr[0],yr[1],yr[1],yr[0]],col=220
  loadct,5
  JdotDmt=JdotDm
  JdotKmt=JdotKm
  JdotMmt=JdotMm
  icount=1
endif else begin
  JdotDmt=JdotDmt+JdotDm
  JdotKmt=JdotKmt+JdotKm
  JdotMmt=JdotMmt+JdotMm
  icount=icount+1
endelse
print,'ivar,uphi=',ivar,uuu[500,100,2],JdotK[500,100]
if lat_range eq 0 then begin
  xyouts,.35,.06,'!7h!6 < 70!uo!n' ;(if lat_crit=70)
  xyouts,.22,1.4e-6,'!8r=R!6',siz=si2
  xyouts,1.00,3e-6,siz=si2,dot+'!8J!7!dm!6!n'
  xyouts,0.43,1e-4,siz=si2,dot+'!8J!6!dK!n',col=55
  xyouts,1.00,4e-4,siz=si2,dot+'!8J!6!dM!n',col=122
endif else begin
  xyouts,.35,.06,'!7h!6 > 70!uo!n' ;(if lat_crit=70)
endelse
;plot,yy/!dtor,JdotK[500,*],yr=[-1,1]*.4,xr=[0,90]
;wait,1
;print,'ivar,uphi=',ivar,JdotKm[500],JdotKmt[500]/icount,JdotK[500,120]
;
dny=5
ny1=ny/3
ny2=ny/3*2
;
loadct,0 & col=180
thick1=1
;oplot,xx,JdotDm,thick=thick1
oplot,xx,JdotKm,thick=thick1,col=col
;oplot,xx,JdotMm,thick=thick1,col=122
;
;oplot,xx,-JdotDm,thick=thick1,li=2
oplot,xx,-JdotKm,thick=thick1,li=2,col=col
;oplot,xx,-JdotMm,thick=thick1,li=2,col=122
loadct,5
;
endfor
;
JdotDmt=JdotDmt/icount
JdotKmt=JdotKmt/icount
JdotMmt=JdotMmt/icount
;
thick1=3
oplot,xx,JdotDmt,thick=thick1
oplot,xx,JdotKmt,thick=thick1,col=55
oplot,xx,JdotMmt,thick=thick1,col=122
;
oplot,xx,-JdotDmt,thick=thick1,li=2
oplot,xx,-JdotKmt,thick=thick1,li=2,col=55
oplot,xx,-JdotMmt,thick=thick1,li=2,col=122
;
endfor
!p.multi=0
;
cwd,run
print,"$mv idl.ps ~/tex/jakab/wind/fig/ppJdot_"+run+".ps
END
