nr=200
r=grange(.2d0,2d0,nr)
unit=r*0+1.
;
phi0=-1.5d0+alog(4d0)
print,phi0
niter=100
u1=2*r
u2=2.*unit
;
inner=where(r le .5)
outer=where(r gt .5)
u2(inner)=r(inner)
;
u=2*r
u(outer)=2.*unit(outer)
for iter=0,niter-1 do begin
  lnu=.5*u1^2-2.*alog(r)-1./r-phi0
  u1=exp(lnu)
  ;
  half_u2=alog(u2*r^2)+1./r+phi0
  good=where(half_u2 ge 0.)
  u2(good)=sqrt(2.*half_u2(good))
  ;
  ;  combined
  ;
  lnu(inner)=.5*u(inner)^2-2.*alog(r(inner))-1./r(inner)-phi0
  u(inner)=exp(lnu(inner))
  ;
  half_u2(outer)=alog(u(outer)*r(outer)^2)+1./r(outer)+phi0
  u(outer)=sqrt(2.*half_u2(outer))
  ;
  plot,r,u1,yr=[0,3.]
  oplot,r,u2,col=122
  oplot,r,u,col=55,thick=5
  print,iter,u1[nr-6],u2[nr-6]
  wait,1.5
endfor
END
