#! /usr/bin/env bash

DIR="$( cd "$( dirname "${BASH_SOURCE[0]}" )" >/dev/null 2>&1 && pwd )"

# install gmp required by solvers.
sudo apt-get install $DIR/FairFind_apt_debs/*

mv $DIR/FairFind $HOME/

# create python virtual env for FairFind
python3 -m venv $HOME/FairFind/venv
mv $DIR/pysmt-install $HOME/FairFind/venv/bin/
source $HOME/FairFind/venv/bin/activate

# install python dependencies
pip install $DIR/FairFind_pip_packages/*

# install pysmt
mv $DIR/pysmt $HOME/FairFind/venv/lib/python3.8/site-packages/

# install solvers mathsat and z3 for pysmt.
mkdir -p $HOME/.smt_solvers/z3/
mv $DIR/pysmt-solvers/z3* $HOME/.smt_solvers/z3/
pysmt-install --z3
mkdir -p $HOME/.smt_solvers/msat/
mv $DIR/pysmt-solvers/mathsat* $HOME/.smt_solvers/msat/
pysmt-install --msat
rmdir $DIR/pysmt-solvers

# move nuXmv binary
mv $DIR/nuXmv $HOME/.local/bin/
