#! /bin/bash +x

DIR="$( cd "$( dirname "${BASH_SOURCE[0]}" )" >/dev/null 2>&1 && pwd )"

nuxmv=$HOME/.local/bin/nuXmv
timeout=600  # timeout in seconds
finite_cmd=$DIR/check_ltl_finite.cmd
infinite_cmd=$DIR/check_ltl.cmd
timed_cmd=$DIR/check_ltl_kzeno.cmd

outdir=$DIR/output_$(date +"%Y_%m_%d_%H_%M_%S")
mkdir $outdir
for filename in $DIR/*.fsmv; do
    name=$(basename $filename .fsmv)
    name=$outdir/$name.out
    echo $filename
    runlim --kill --time-limit=$timeout $nuxmv -source $finite_cmd $filename &> $name
done

for filename in $DIR/*.smv; do
    name=$(basename $filename .smv)
    name=$outdir/$name.out
    echo $filename
    runlim --kill --time-limit=$timeout $nuxmv -source $infinite_cmd $filename &> $name
done

for filename in $DIR/*.tsmv; do
    name=$(basename $filename .tsmv)
    name=$outdir/$name.out
    echo $filename
    runlim --kill --time-limit=$timeout $nuxmv -source $timed_cmd $filename &> $name
done
