#! /bin/bash

export T2_PATH=$HOME/AProVE/T2/src/bin/Release/

DIR="$( cd "$( dirname "${BASH_SOURCE[0]}" )" >/dev/null 2>&1 && pwd )"

aprove=$HOME/AProVE/aprove.jar
timeout=600  # timeout in seconds
threads=1   # number of thread to be used.

outdir=$DIR/output_$(date +"%Y_%m_%d_%H_%M_%S")
mkdir $outdir
for filename in $DIR/*.c; do
    name=$(basename $filename .c)
    name=$outdir/$name.out
    echo $filename
    runlim --kill taskset --cpu-list 0 java -ea -jar $aprove -t $timeout -w $threads -m wst $filename &> $name
done
