#! /bin/bash

DIR="$( cd "$( dirname "${BASH_SOURCE[0]}" )" >/dev/null 2>&1 && pwd )"

pushd $HOME/anant/tool
source ../venv/bin/activate
anant=./runAnant.sh
timeout=600  # timeout in seconds

outdir=$DIR/output_$(date +"%Y_%m_%d_%H_%M_%S")
mkdir $outdir
for filename in $DIR/*.t2; do
    name=$(basename $filename .t2)
    name=$outdir/$name.out
    echo $filename
    runlim --time-limit=$timeout $anant $filename &> $name
done

popd
