#! /usr/bin/env python

import logging
# from random import choice
import re
import subprocess
import t2lassoParser
import sys
import os
# sys.path.append(os.getcwd() + '/z3/python')
sys.path.append(os.getcwd())


# import signal

# class Alarm(Exception):
#   pass
#
# def alarm_handler(signum, frame):
#   raise Alarm
#
# signal.signal(signal.SIGALRM, alarm_handler)

stemFound = False
cycleFound = False
header = -1
numCycles = 0
numStems = 0
numNonTermChecks = 0

path = []


class numStemsExceeded(Exception):
    def __init__(self, value):
        self.value = value

    def __str__(self):
        return repr(self.value)


def dfs(n, lastNode, edgeNumber):
    global stemStack
    global cycleStack
    loopFound = False
    ind = 0
    for i in range(0, len(path)):
        if n == path[i][0]:
            loopFound = True
            ind = i
            break
    if loopFound is True:
        path.append((n, Graph[lastNode][edgeNumber][1]))
        stemStack = path[0:ind + 1]
        pathLen = len(path)
        cycleStack = path[ind:pathLen]
        nontermCheck()
        path.pop()
    else:
        if n in Graph.keys():
            if n != start:
                path.append((n, Graph[lastNode][edgeNumber][1]))
            for i in range(0, len(Graph[n])):
                dfs((Graph[n][i])[0], n, i)
            if n != start:
                path.pop()
    return


def nontermCheck():
    global numNonTermChecks
    numNonTermChecks = numNonTermChecks + 1
    if numNonTermChecks == 10:
        print("Result : Unknown")
        sys.exit()
    stemStr = ''
    cycleStr = ''
    for i in range(0, len(stemStack)):
        cmds = stemStack[i][1]
        stemStr = stemStr + '\n' + '\n'.join(cmds)
    stemStr = stemStr + '\n' + 'skip;'
    for i in range(1, len(cycleStack)):
        cmds = cycleStack[i][1]
        cycleStr = cycleStr + '\n' + '\n'.join(cmds)
    cycleStr = cycleStr + '\n' + 'skip;'
    lassoStr = 'stemis\n' + stemStr + '\ncycleis\n' + cycleStr
    for runCount in range(1, 3):
        try:
            if runCount == 1:
                extractInv = True
            else:
                extractInv = False
            # print "extractInv:"
            # print extractInv
            # pdb.set_trace()
            t2lassoParser.main_func(lassoStr, extractInv)
        except t2lassoParser.MyError:
            continue
        except Exception:
            logging.exception("")
            continue

        exec_file = os.path.join(os.getcwd(), "build/exec.sh")
        exec_file = os.path.abspath(exec_file)
        try:
            # p = subprocess.Popen(os.getcwd() + "/build/exec.sh",
            #                      stdout=subprocess.PIPE,
            #                      stderr=subprocess.PIPE,
            #                      executable='/bin/bash',
            #                      shell=True)
            # t = p.communicate()
            out = subprocess.check_output(exec_file, shell=True,
                                          stderr=subprocess.STDOUT)
            out = out.decode("utf-8")
        except Exception:
            logging.exception("Error in nontermCheck")
            continue
            # return
        lines = out.split("\n")  # t[0].split("\n")
        ntResultFound = False
        for line in lines:
            if ntResultFound is True:
                print(line)
                if line == lines[-1]:
                    sys.exit()
            if line == "Result : Non-Terminating":
                print("Result : Non-Terminating")
                ntResultFound = True
            elif line == "Result : Unknown":
                # return
                break
            elif line == "Result : Terminating":
                print("ERROR:ERROR:ERROR:")
                print("Result : Terminating")
                sys.exit()
    return


Graph = {}
preNodeFound = False
entryEdge = False
stemStack = []
cycleStack = []
edgeCommandList = []
stemCommandList = ''

filename = sys.argv[-1]
regexp = r"(?P<keyword>(START)|(FROM)|(TO))" \
         r"\s*:\s*(?P<num>\d+)\s*;"
regexp = re.compile(regexp)
f = open(filename, "r")
for line in f.readlines():
    line = line.strip()
    match = regexp.match(line)

    if match and "keyword" in match.groupdict() and "num" in match.groupdict():
        keyword = match.group("keyword")
        num = int(match.group("num"))
        if keyword == "START":
            start = num
            Graph[start] = []

        elif keyword == "FROM":
            edgeCommandList = []
            preNode = num
            if preNode not in Graph.keys():
                Graph[preNode] = []
            preNodeFound = True

        elif keyword == "TO":
            assert preNodeFound is True, \
                'Post Node Found without a Pre Node: `{}`'.format(line.strip())
            postNode = num
            edge = (postNode, edgeCommandList)
            Graph[preNode].append(edge)
            preNodeFound = False
    else:
        if 'CUTPOINT' in line:
            pass
        elif "//" in line:
            pass
        else:
            cleanLine = line
            if 'AT' in cleanLine:
                inde = cleanLine.index(')')
                cleanLine = cleanLine[inde + 1:]
            cleanLine = cleanLine.strip()

            varList = re.findall('[a-zA-Z_][a-zA-Z0-9_]*', cleanLine)
            for v in varList:
                if v != 'assume' and v != 'nondet':
                    t2lassoParser.names.add(v)
            if cleanLine:
                edgeCommandList.append(cleanLine)

dfs(start, -1, -1)

print("Result : Unknown")
