#include<stdio.h>
#include<stdlib.h>
#include<stdarg.h>
#include<memory.h>
#include<setjmp.h>
#include<z3.h>
#include<z3++.h>
#include<assert.h>
#include<stdarg.h>
#include<string.h>

using namespace z3;

//#define LOG_Z3_CALLS
#define STRBOUND 500
#define MAX_INV_TEMPLATE_COUNT 3
#define MAX_RECURRENT_TEMPLATE_COUNT 8
#define TIMEOUT_TIME_TERMINATION_PROOF 20000
#define TIMEOUT_TIME_NON_TERMINATION_PROOF 20000

Z3_context mk_context();
Z3_context mk_context_custom(Z3_config cfg, Z3_error_handler err);
void error_handler(Z3_context c, Z3_error_code e);

Z3_ast mk_int_var(Z3_context, const char*);
void display_model(Z3_context, FILE *, Z3_model);
Z3_ast mk_int(Z3_context, int);
void check2(Z3_context, Z3_lbool);

int myPrintf(const char* format, ...);

bool p_arg = false;
bool only_non_term_proof = false;
bool rs_arg = false;
bool crs_arg = false;
int tsize = 1;
unsigned timeout = 20000;

struct nonTerminationContext{
   public:
      int guardCommandIndex;
      int updateCommandIndex;
      int** G_Int;
      int* g_Int;
      int** U_Int;
      int** UP_Int;
      int* u_Int;

      int**U_rs_Int;//Update Matrix for TnT style rs finding.
      int* u_rs_Int;//
      
      int** initialCondition_Int;
      int numRecurrentSetEqs;
      int numVars;
      int numEq;
      int numEqIC;
      char** variableNames;

      Z3_ast** T;
      Z3_ast* t;

      Z3_ast** A;
      Z3_ast** AP;
      Z3_ast* b;

      Z3_ast** lnt;
      Z3_ast** initialCondition;

      //Z3_config cfg;
      Z3_params params;
      Z3_context ctx;
      Z3_solver s;
      Z3_model m;

      Z3_ast args[2];
      Z3_ast addTerm;
      Z3_ast equationTerm;
      Z3_ast assertTerm;
      Z3_ast zero;
      Z3_ast** G;
      Z3_ast* g;

      //Needed for finding rs as in TnT.
      Z3_ast** U_rs;
      Z3_ast* u_rs;
      Z3_ast** TU;
      Z3_ast* Tu;
      //
      Z3_ast* vars;
      
      Z3_sort       int_sort;

      int** TModel;
      int* tModel;

   nonTerminationContext(){
      guardCommandIndex = 0;
      updateCommandIndex = 0;
      numRecurrentSetEqs = 1;
   }
};

struct terminationContext{
   public:
   int **A_Int;
   int **AP_Int;
   int* b_Int;

   int** invModel;
   int** initialCondition_Int;

   int numVars;
   char** variableNames;

   int numEq;
   int numEqIC;
   int numInvariants;
   int* l2Model;
   int** APModel;
   int* rankFunctionModel;

   int numGuardVars;
   int* guardVarsIndices;

   int varsNotInInvariantsIndex;
   int* varsNotInInvariants;

   Z3_ast** A;
   Z3_ast** AP;
   Z3_ast* b;

   Z3_ast** inv;
   Z3_ast** initialCondition;
   Z3_ast** vars;
   
   //Z3_config cfg;
   Z3_params params;
   Z3_context ctx;
   Z3_solver s;

   Z3_ast* l1;
   Z3_ast* l2;
   Z3_ast** l4;//Required for Stem Implies Invariant.
   Z3_ast** l3;//Required for inductive invariant proving.

   Z3_ast args[2];
   Z3_ast addTerm;
   Z3_ast equationTerm;
   Z3_ast assertTerm;
   Z3_ast zero;

   Z3_sort       int_sort;

   Z3_model m;
   terminationContext(){
      m = 0;
      varsNotInInvariantsIndex = 0;
      numGuardVars = 0;
   }
};

void terminationInvariant()
{
   void takeInput(terminationContext& tc);
   void initializeASTVars(terminationContext& tc);
   void addMainTerminationConstraints(terminationContext& tc);
   void addInitialConditionImpliesInvariant(terminationContext& tc);
   void addRankFunctionContainsVarsFromGuards(terminationContext& tc);
   void addVarsNotPresentInInvariantConstraints(terminationContext& tc);
   void addNonLinearConstraintsForInvariants(terminationContext& tc);
   void addNewIdeaConstraint(terminationContext& tc);
   void getModel(terminationContext& tc);
   void displayInvariant(terminationContext& tc);
   void displayRankingFunction(terminationContext& tc);
   void addHeuristics(terminationContext& tc);
   int myPrintf(const char* format, ...);

   void takeInputForNonTermination_CRS(nonTerminationContext& ntc, terminationContext& tc);
   void takeInputForNonTermination_RS(nonTerminationContext& ntc, terminationContext& tc);
   void initializeASTVarsForNonTermination_CRS(nonTerminationContext& ntc);
   void initializeASTVarsForNonTermination_RS(nonTerminationContext& ntc);
   void addNonLinearConstraintsFor_CRS(nonTerminationContext& ntc);
   void addNonLinearConstraintsFor_RS(nonTerminationContext& ntc);
   void addStemHasStateForNonTerminationConstraint(nonTerminationContext& ntc);

   void nonTerminationFunction(nonTerminationContext& ntc);
   void getNTCModel(nonTerminationContext& ntc);
   void displayRecurrentSet(nonTerminationContext& ntc);

   void deleteDynamicMemoryOfTC(terminationContext& tc);
   void deleteDynamicMemoryOfNTC_CRS(nonTerminationContext& ntc);
   void deleteDynamicMemoryOfNTC_RS(nonTerminationContext& ntc);

   terminationContext tc;
   nonTerminationContext ntc;

   //This option is worth trying.
   //Z3_set_logic(tc.ctx, "QF_NIA");


   takeInput(tc);

   if(tsize != 1){
      tc.numInvariants = tsize;
   }
   else{
      tc.numInvariants = 1;
   }

   while(tc.numInvariants <= MAX_INV_TEMPLATE_COUNT && only_non_term_proof == false){

      Z3_config cfg = Z3_mk_config();
      tc.ctx = mk_context_custom(cfg, error_handler);
      //tc.ctx = Z3_mk_context(cfg);
      tc.s = Z3_mk_solver(tc.ctx);
      Z3_solver_inc_ref(tc.ctx, tc.s);

      tc.params = Z3_mk_params(tc.ctx);
      Z3_params_inc_ref(tc.ctx, tc.params);
      Z3_symbol r = Z3_mk_string_symbol(tc.ctx, ":timeout");
      Z3_params_set_uint(tc.ctx, tc.params, r, static_cast<unsigned>(TIMEOUT_TIME_TERMINATION_PROOF));
      Z3_solver_set_params(tc.ctx, tc.s, tc.params);
      //Z3_params_dec_ref(tc.ctx, tc.params);

      //Z3_solver_dec_ref(tc.ctx, tc.s);
      //Z3_del_config(cfg);

      tc.int_sort    = Z3_mk_int_sort(tc.ctx);
      tc.zero = mk_int(tc.ctx, 0);


      initializeASTVars(tc);

      addMainTerminationConstraints(tc);
      addInitialConditionImpliesInvariant(tc);
      addRankFunctionContainsVarsFromGuards(tc);
      addVarsNotPresentInInvariantConstraints(tc);
      addNonLinearConstraintsForInvariants(tc);
      //addNewIdeaConstraint(tc);

      //addHeuristics(tc);

      myPrintf( "(check-sat)\n");
      myPrintf( "(get-model)\n");
      myPrintf( "(exit)\n");

      if(p_arg == true){
         deleteDynamicMemoryOfTC(tc);
         exit(0);
      }
      Z3_lbool result;
      result = Z3_solver_check(tc.ctx, tc.s);

      for(int i = 0; i < tc.numInvariants; i++){
         for(int j = 0; j <= tc.numVars; j++){
            tc.invModel[i][j] = 9999;
         }
      }

      switch (result){
         case Z3_L_FALSE:
            printf("\nunsat for numInvariants = %d", tc.numInvariants);
            tc.numInvariants++;

            Z3_params_dec_ref(tc.ctx, tc.params);
            Z3_solver_dec_ref(tc.ctx, tc.s);
            Z3_del_config(cfg);
            Z3_del_context(tc.ctx);

            break;
            //exit(0);
         case Z3_L_UNDEF:
            printf("\nunknown for numInvariants  = %d", tc.numInvariants);
            tc.numInvariants++;

            Z3_params_dec_ref(tc.ctx, tc.params);
            Z3_solver_dec_ref(tc.ctx, tc.s);
            Z3_del_config(cfg);
            Z3_del_context(tc.ctx);

            break;

            //tc.m = Z3_solver_get_model(tc.ctx, tc.s);
            //printf("potential model:\n");
            //display_model(tc.ctx, stdout, tc.m);
            //exit(0);
         case Z3_L_TRUE:
            printf("\nResult : Terminating");
            printf("\nsat for numInvariants = %d", tc.numInvariants);
            tc.m = Z3_solver_get_model(tc.ctx, tc.s);
            getModel(tc);
            displayInvariant(tc);
            displayRankingFunction(tc);
            deleteDynamicMemoryOfTC(tc);
            exit(0);
      }
   }

   if(only_non_term_proof == false){
      assert(tc.numInvariants > MAX_INV_TEMPLATE_COUNT);
   }

   assert((rs_arg == true && crs_arg == false )|| 
         (crs_arg == true && rs_arg == false));

   if(crs_arg){
      takeInputForNonTermination_CRS(ntc, tc);
   }
   else if(rs_arg){
      takeInputForNonTermination_RS(ntc, tc);
   }
   deleteDynamicMemoryOfTC(tc);

   while(ntc.numRecurrentSetEqs <= tsize){
      Z3_config cfg = Z3_mk_config();
      ntc.ctx = mk_context_custom(cfg, error_handler);
      //ntc.ctx = Z3_mk_context(cfg);
      ntc.s = Z3_mk_solver(ntc.ctx);
      Z3_solver_inc_ref(ntc.ctx, ntc.s);

      ntc.params = Z3_mk_params(ntc.ctx);
      Z3_params_inc_ref(ntc.ctx, ntc.params);
      Z3_symbol r = Z3_mk_string_symbol(ntc.ctx, ":timeout");
      //Z3_params_set_uint(ntc.ctx, ntc.params, r, static_cast<unsigned>(TIMEOUT_TIME_NON_TERMINATION_PROOF));
      //Z3_params_set_uint(ntc.ctx, ntc.params, r, static_cast<unsigned>(timeout));
      Z3_params_set_uint(ntc.ctx, ntc.params, r, timeout);
      Z3_solver_set_params(ntc.ctx, ntc.s, ntc.params);

      ntc.int_sort    = Z3_mk_int_sort(ntc.ctx);
      ntc.zero = mk_int(ntc.ctx, 0);

      if(crs_arg){
         initializeASTVarsForNonTermination_CRS(ntc);
         addStemHasStateForNonTerminationConstraint(ntc);
         addNonLinearConstraintsFor_CRS(ntc);
      }
      else if(rs_arg){
         initializeASTVarsForNonTermination_RS(ntc);
         addStemHasStateForNonTerminationConstraint(ntc);
         addNonLinearConstraintsFor_RS(ntc);
      }

      myPrintf( "(check-sat)\n");
      myPrintf( "(get-model)\n");
      myPrintf( "(exit)\n");

      if(p_arg == true){
         //deleteDynamicMemoryOfTC(tc);
         if(crs_arg){
            deleteDynamicMemoryOfNTC_CRS(ntc);
         }
         else if(rs_arg){
            deleteDynamicMemoryOfNTC_RS(ntc);
         }
         exit(0);
      }
      Z3_lbool result;
      result = Z3_solver_check(ntc.ctx, ntc.s);
      switch (result){
         case Z3_L_FALSE:
            printf("\nunsat for numRecurrentSetEqs = %d \n", ntc.numRecurrentSetEqs);

            Z3_params_dec_ref(ntc.ctx, ntc.params);
            Z3_solver_dec_ref(ntc.ctx, ntc.s);
            Z3_del_config(cfg);
            Z3_del_context(ntc.ctx);

            ntc.numRecurrentSetEqs++;
            break;
            //exit(0);
         case Z3_L_UNDEF:
            printf("\nunknown for numRecurrentSetEqs = %d \n", ntc.numRecurrentSetEqs);

            Z3_params_dec_ref(ntc.ctx, ntc.params);
            Z3_solver_dec_ref(ntc.ctx, ntc.s);
            Z3_del_config(cfg);
            Z3_del_context(ntc.ctx);

            ntc.numRecurrentSetEqs++;
            break;
            //ntc.m = Z3_solver_get_model(ntc.ctx, ntc.s);
            //printf("potential model:\n");
            //display_model(ntc.ctx, stdout, ntc.m);
            //exit(0);
         case Z3_L_TRUE:
            printf("\nResult : Non-Terminating");
            printf("\nsat for numRecurrentSetEqs = %d", ntc.numRecurrentSetEqs);
            ntc.m = Z3_solver_get_model(ntc.ctx, ntc.s);
            getNTCModel(ntc);
            displayRecurrentSet(ntc);
            //deleteDynamicMemoryOfTC(tc);
            if(crs_arg){
               deleteDynamicMemoryOfNTC_CRS(ntc);
            }
            else if(rs_arg){
               deleteDynamicMemoryOfNTC_RS(ntc);
            }
            exit(0);
      }
   }
   printf("\nResult : Unknown");
   //deleteDynamicMemoryOfTC(tc);
   if(crs_arg){
      deleteDynamicMemoryOfNTC_CRS(ntc);
   }
   else if(rs_arg){
      deleteDynamicMemoryOfNTC_RS(ntc);
   }
   exit(0);
}

void takeInput(terminationContext& tc){
   /*printf("Enter the number of Program Variables");*/
   scanf("%d", &(tc.numVars));

   tc.variableNames = new char* [tc.numVars];
   for(int i = 0; i < tc.numVars; i++){
      tc.variableNames[i] = new char[STRBOUND];
   }

   for(int i = 0; i < tc.numVars; i++){
      scanf("%s", tc.variableNames[i]);
   }


   tc.guardVarsIndices = new int[tc.numVars];
   tc.varsNotInInvariants = new int[tc.numVars];

   tc.rankFunctionModel = new int[tc.numVars];

   tc.inv = new Z3_ast* [MAX_INV_TEMPLATE_COUNT];
   tc.invModel = new int* [MAX_INV_TEMPLATE_COUNT];
   for(int i = 0; i < MAX_INV_TEMPLATE_COUNT; i++){
      tc.inv[i] = new Z3_ast[tc.numVars + 1];
      tc.invModel[i] = new int[tc.numVars + 1];
   }

   tc.vars = new Z3_ast*[MAX_INV_TEMPLATE_COUNT];
   for(int i = 0; i < MAX_INV_TEMPLATE_COUNT; i++){
      tc.vars[i] = new Z3_ast[2 * tc.numVars];
   }

   /* myPrintf("Enter the number of equations");*/

   scanf("%d", &(tc.numEq));

   tc.A_Int = new int* [tc.numEq];
   tc.AP_Int = new int* [tc.numEq];
   tc.b_Int = new int[tc.numEq];
   tc.A = new Z3_ast* [tc.numEq + MAX_INV_TEMPLATE_COUNT];
   tc.AP = new Z3_ast* [tc.numEq + MAX_INV_TEMPLATE_COUNT];
   tc.APModel = new int* [tc.numEq + MAX_INV_TEMPLATE_COUNT];
   tc.b = new Z3_ast[tc.numEq + MAX_INV_TEMPLATE_COUNT];

   tc.l1 = new Z3_ast[tc.numEq + MAX_INV_TEMPLATE_COUNT];
   tc.l2 = new Z3_ast[tc.numEq + MAX_INV_TEMPLATE_COUNT];
   tc.l2Model = new int[tc.numEq + MAX_INV_TEMPLATE_COUNT];
   tc.l3 = new Z3_ast*[MAX_INV_TEMPLATE_COUNT];

   for(int i = 0; i < tc.numEq; i++){
      tc.A_Int[i] = new int[tc.numVars];
      tc.AP_Int[i] = new int[tc.numVars];
   }

   for(int i = 0; i < tc.numEq + MAX_INV_TEMPLATE_COUNT; i++){
      tc.A[i] = new Z3_ast[tc.numVars];
      tc.AP[i] = new Z3_ast[tc.numVars];
      tc.APModel[i] = new int[tc.numVars];
   }
   for(int i = 0; i < MAX_INV_TEMPLATE_COUNT; i++){
      tc.l3[i] = new Z3_ast[tc.numEq + MAX_INV_TEMPLATE_COUNT];
   }


   /* myPrintf("Enter Matrix A"); */

   for(int i = 0; i < tc.numEq; i++){
      for(int j = 0; j < tc.numVars; j++){
         scanf("%d", &tc.A_Int[i][j]);
      }
   }

   /* myPrintf("Enter Matrix AP"); */

   for(int i = 0; i < tc.numEq; i++){
      for(int j = 0; j < tc.numVars; j++){
         scanf("%d", &tc.AP_Int[i][j]);
      }
   }

   /* myPrintf("Enter matrix b"); */

   for(int i = 0; i < tc.numEq; i++){
      scanf("%d", &tc.b_Int[i]);
   }

   /*printf("\nEnter the number of equations in initial condition.");*/

   scanf("%d", &tc.numEqIC);

   tc.initialCondition_Int = new int* [tc.numEqIC];
   tc.initialCondition =  new Z3_ast* [tc.numEqIC];

   tc.l4 = new Z3_ast* [MAX_INV_TEMPLATE_COUNT];

   for(int i = 0; i < tc.numEqIC; i++){
      tc.initialCondition_Int[i] = new int [2 * tc.numVars + 1];
      tc.initialCondition[i] = new Z3_ast[2 * tc.numVars + 1];
   }

   for(int i = 0; i < MAX_INV_TEMPLATE_COUNT; i++){
      tc.l4[i] = new Z3_ast[tc.numEqIC];
   }

   /*printf("\nEnter the matrix for initial Condition.\n"); */

   for(int i = 0; i < tc.numEqIC; i++){
      for(int j = 0; j <= 2 * tc.numVars; j++){  // 2 * tc.numVars  from Symbolic Simulation.
                                                 // For stem, columns 0 to numVars-1 are for post vars which
                                                 // occur in invariants and columns numVars to 2*numVars-1 are pre vars.
                                                 // which can't occur in invariants. Last column 2*numVars is for constants.
                                                 // For cycle it's opposite.
                                                 // For cycle, columns 0 to numVars-1 are pre vars that create matix A.
                                                 // Columns numVars to 2*numVars-1 are post vars that create matix AP.
                                                 // Last column 2*numVars is for constants that represents column matrix b.

         scanf("%d", &tc.initialCondition_Int[i][j]);
      }
   }

   /*printf("\nEnter number of Guard variables\n");*/
   scanf("%d", &tc.numGuardVars);
   /*printf("\nEnter variable Indices from Guards\n");*/


   for(int i = 0; i < tc.numGuardVars; i++){
      scanf("%d", &tc.guardVarsIndices[i]);
   }

   scanf("%d", &tc.varsNotInInvariantsIndex);
   for(int i = 0; i < tc.varsNotInInvariantsIndex; i++){
      scanf("%d", &tc.varsNotInInvariants[i]);
   }
}

void initializeASTVars(terminationContext& tc){
   char name[256];

   myPrintf( "(set-option :produce-models true)\n");

   for(int i = 0; i < tc.numEq; i++){
      for(int j = 0; j < tc.numVars; j++){
         tc.A[i][j] = mk_int(tc.ctx, tc.A_Int[i][j]);
      }
   }

   for(int i = 0; i < tc.numEq; i++){
      for(int j = 0; j < tc.numVars; j++){
         tc.AP[i][j] = mk_int(tc.ctx, tc.AP_Int[i][j]);
      }
   }

   for(int i = 0; i < tc.numEq; i++){
      tc.b[i] = mk_int(tc.ctx, tc.b_Int[i]);
   }

   for(int i = 0; i < tc.numEqIC; i++){
      for(int j = 0; j <= 2 * tc.numVars; j++){
         tc.initialCondition[i][j] = mk_int(tc.ctx, tc.initialCondition_Int[i][j]);
      }
   }

   for(int i = 0; i < tc.numInvariants; i++){
      for(int j = 0; j <= tc.numVars; j++){
         sprintf(name, "i_%d_%d", i + 1, j + 1);
         tc.inv[i][j] = Z3_mk_const(tc.ctx, Z3_mk_string_symbol(tc.ctx, name), tc.int_sort);
         myPrintf("(declare-const %s Int)\n", name);
      }
   }

   for(int i = 0; i < tc.numInvariants; i++){
      for(int j = 0; j < tc.numVars; j++){
         sprintf(name, "%s_%d", tc.variableNames[j], i);
         tc.vars[i][j] = Z3_mk_const(tc.ctx, Z3_mk_string_symbol(tc.ctx, name), tc.int_sort);
         myPrintf("(declare-const %s Int)", name);
      }
   }

   for(int i = 0; i < tc.numInvariants; i++){
      for(int j = 0; j < tc.numVars; j++){
         sprintf(name, "%s_post_%d", tc.variableNames[j], i);
         tc.vars[i][tc.numVars + j] = Z3_mk_const(tc.ctx, Z3_mk_string_symbol(tc.ctx, name), tc.int_sort);
         myPrintf("(declare-const %s Int)", name);
      }
   }

   for(int i = 0; i < tc.numEq + tc.numInvariants; i++){
      sprintf(name, "l1_%d", i + 1);
      tc.l1[i] = Z3_mk_const(tc.ctx, Z3_mk_string_symbol(tc.ctx, name), tc.int_sort);
      myPrintf("(declare-const %s Int)\n", name);

      //lambda_1 >= 0
      tc.assertTerm = Z3_mk_ge(tc.ctx, tc.l1[i], tc.zero);
      Z3_solver_assert(tc.ctx, tc.s, tc.assertTerm);
      myPrintf("\n(assert %s )\n", Z3_ast_to_string(tc.ctx, tc.assertTerm));

      sprintf(name, "l2_%d", i + 1);
      tc.l2[i] = Z3_mk_const(tc.ctx, Z3_mk_string_symbol(tc.ctx, name), tc.int_sort);
      myPrintf("(declare-const %s Int)\n", name);

      //lambda_2 >= 0
      tc.assertTerm = Z3_mk_ge(tc.ctx, tc.l2[i], tc.zero);
      Z3_solver_assert(tc.ctx, tc.s, tc.assertTerm);
      myPrintf("\n(assert %s )\n", Z3_ast_to_string(tc.ctx, tc.assertTerm));
   }

   for(int i = 0; i < tc.numInvariants; i++){
      for(int j = 0; j < tc.numVars; j++){
         tc.A[tc.numEq + i][j] = tc.inv[i][j];
      }
   }

   for(int i = 0; i < tc.numInvariants; i ++){
      for(int j = 0; j < tc.numVars; j++){
         tc.AP[tc.numEq + i][j] = tc.zero;
      }
   }

   for(int i = 0; i < tc.numInvariants; i++){
      tc.b[tc.numEq + i] = tc.inv[i][tc.numVars];
   }

   for(int i = 0; i < tc.numInvariants; i++){
      for(int j = 0; j < tc.numEqIC; j++){
         sprintf(name, "l4_%d_%d", i + 1, j + 1);
         tc.l4[i][j] = Z3_mk_const(tc.ctx, Z3_mk_string_symbol(tc.ctx, name), tc.int_sort);
         myPrintf("(declare-const %s Int)", name);
         //lambda_4 >= 0
         tc.assertTerm = Z3_mk_ge(tc.ctx, tc.l4[i][j], tc.zero);
         Z3_solver_assert(tc.ctx, tc.s, tc.assertTerm);
         myPrintf("\n (assert %s )\n", Z3_ast_to_string(tc.ctx, tc.assertTerm));
      }
   }

   for(int l = 0; l < tc.numInvariants; l++){
      for(int i = 0; i < tc.numEq + tc.numInvariants; i++){
         sprintf(name, "l3_%d_%d", l + 1, i + 1);
         tc.l3[l][i] = Z3_mk_const(tc.ctx, Z3_mk_string_symbol(tc.ctx, name), tc.int_sort);
         myPrintf("(declare-const %s Int)", name);

         //lambda_3 >= 0
         tc.assertTerm = Z3_mk_ge(tc.ctx, tc.l3[l][i], tc.zero);
         Z3_solver_assert(tc.ctx, tc.s, tc.assertTerm);
         myPrintf("\n(assert %s )\n", Z3_ast_to_string(tc.ctx, tc.assertTerm));
      }
   }
}

void addMainTerminationConstraints(terminationContext& tc){
   //\lambda_1 A' = 0
   for(int j = 0; j < tc.numVars; j++){
      tc.equationTerm = tc.zero;
      for(int i = 0; i < tc.numEq + tc.numInvariants; i++){
         tc.args[0] = tc.l1[i];
         tc.args[1] = tc.AP[i][j];
         tc.addTerm = Z3_mk_mul(tc.ctx, 2, tc.args);
         tc.args[0] = tc.equationTerm;
         tc.args[1] = tc.addTerm;
         tc.equationTerm = Z3_mk_add(tc.ctx, 2, tc.args);
      }
      tc.assertTerm = Z3_mk_eq(tc.ctx, tc.equationTerm, tc.zero);
      Z3_solver_assert(tc.ctx, tc.s, tc.assertTerm);
      myPrintf("\n (assert %s )\n", Z3_ast_to_string(tc.ctx, tc.assertTerm));
   }

   //(\lambda_1 - \lambda_2) A = 0
   for(int j = 0; j < tc.numVars; j++){
      tc.equationTerm = tc.zero;
      for(int i = 0; i < tc.numEq + tc.numInvariants; i++){
         tc.args[0] = tc.l1[i];
         tc.args[1] = tc.l2[i];
         tc.args[0] = Z3_mk_sub(tc.ctx, 2, tc.args);
         tc.args[1] = tc.A[i][j];
         tc.addTerm = Z3_mk_mul(tc.ctx, 2, tc.args);
         tc.args[0] = tc.equationTerm;
         tc.args[1] = tc.addTerm;
         tc.equationTerm = Z3_mk_add(tc.ctx, 2, tc.args);
      }
      tc.assertTerm = Z3_mk_eq(tc.ctx, tc.equationTerm, tc.zero);
      Z3_solver_assert(tc.ctx, tc.s, tc.assertTerm);
      myPrintf("\n (assert %s )\n", Z3_ast_to_string(tc.ctx, tc.assertTerm));
   }

   //\lambda_2 (A + A') = 0
   for(int j = 0; j < tc.numVars; j++){
      tc.equationTerm = tc.zero;
      for(int i = 0; i < tc.numEq + tc.numInvariants; i++){
         tc.args[0] = tc.A[i][j];
         tc.args[1] = tc.AP[i][j];
         tc.args[0] = Z3_mk_add(tc.ctx, 2, tc.args);
         tc.args[1] = tc.l2[i];
         tc.addTerm = Z3_mk_mul(tc.ctx, 2, tc.args);
         tc.args[0] = tc.equationTerm;
         tc.args[1] = tc.addTerm;
         tc.equationTerm = Z3_mk_add(tc.ctx, 2, tc.args);
      }
      tc.assertTerm = Z3_mk_eq(tc.ctx, tc.equationTerm, tc.zero);
      Z3_solver_assert(tc.ctx, tc.s, tc.assertTerm);
      myPrintf("\n (assert %s )\n", Z3_ast_to_string(tc.ctx, tc.assertTerm));
   }

   //\lambda_2 b < 0
   tc.equationTerm = tc.zero;
   for(int i = 0; i < tc.numEq + tc.numInvariants; i++){
      tc.args[0] = tc.l2[i];
      tc.args[1] = tc.b[i];
      tc.addTerm = Z3_mk_mul(tc.ctx, 2, tc.args);
      tc.args[0] = tc.equationTerm;
      tc.args[1] = tc.addTerm;
      tc.equationTerm = Z3_mk_add(tc.ctx, 2, tc.args);
   }
   tc.assertTerm = Z3_mk_lt(tc.ctx, tc.equationTerm, tc.zero);
   Z3_solver_assert(tc.ctx, tc.s, tc.assertTerm);
   myPrintf("\n (assert %s )\n", Z3_ast_to_string(tc.ctx, tc.assertTerm));
}

void addInitialConditionImpliesInvariant(terminationContext& tc){
   ////Initial Condition should Imply Invariant.

   for(int l = 0; l < tc.numInvariants; l++){
      for(int j = 0; j < tc.numVars; j++){
         tc.equationTerm = tc.zero;
         for(int i = 0; i < tc.numEqIC; i++){
            tc.args[0] = tc.l4[l][i];
            tc.args[1] = tc.initialCondition[i][j];
            tc.addTerm = Z3_mk_mul(tc.ctx, 2, tc.args);
            tc.args[0] = tc.equationTerm;
            tc.args[1] = tc.addTerm;
            tc.equationTerm = Z3_mk_add(tc.ctx, 2, tc.args);
         }
         tc.assertTerm = Z3_mk_eq(tc.ctx, tc.equationTerm, tc.inv[l][j]);
         Z3_solver_assert(tc.ctx, tc.s, tc.assertTerm);
         myPrintf("\n (assert %s)\n", Z3_ast_to_string(tc.ctx, tc.assertTerm));
      }
   }

   for(int l = 0; l < tc.numInvariants; l++){
      tc.equationTerm = tc.zero;
      for(int i = 0; i < tc.numEqIC; i++){
         tc.args[0] = tc.l4[l][i];
         tc.args[1] = tc.initialCondition[i][2 * tc.numVars];
         tc.addTerm = Z3_mk_mul(tc.ctx, 2, tc.args);
         tc.args[0] = tc.equationTerm;
         tc.args[1] = tc.addTerm;
         tc.equationTerm = Z3_mk_add(tc.ctx, 2, tc.args);
      }
      tc.assertTerm = Z3_mk_le(tc.ctx, tc.equationTerm, tc.inv[l][tc.numVars]); // Last column for inv is at index tc.numVars and not at 2 * tc.numVars.
      Z3_solver_assert(tc.ctx, tc.s, tc.assertTerm);
      myPrintf("\n (assert %s)\n", Z3_ast_to_string(tc.ctx, tc.assertTerm));
   }

   // Vars representing columns from tc.numVars to 2 * tc.numVars - 1
   // cant appear in invariants as these are just pre vars for stem.

   for(int l = 0; l < tc.numInvariants; l++){
      for(int j = tc.numVars; j < 2 * tc.numVars; j++){
         tc.equationTerm = tc.zero;
         for(int i = 0; i < tc.numEqIC; i++){
            tc.args[0] = tc.l4[l][i];
            tc.args[1] = tc.initialCondition[i][j];
            tc.addTerm = Z3_mk_mul(tc.ctx, 2, tc.args);
            tc.args[0] = tc.equationTerm;
            tc.args[1] = tc.addTerm;
            tc.equationTerm = Z3_mk_add(tc.ctx, 2, tc.args);
         }
         tc.assertTerm = Z3_mk_eq(tc.ctx, tc.equationTerm, tc.zero);
         Z3_solver_assert(tc.ctx, tc.s, tc.assertTerm);
         myPrintf("\n (assert %s)\n", Z3_ast_to_string(tc.ctx, tc.assertTerm));
      }
   }
   ////Initial Condition should Imply Invariant- Ends.
}

void addRankFunctionContainsVarsFromGuards(terminationContext& tc){
   //Ranking function should only contain variables from Guards.

   for(int j = 0; j < tc.numVars; j++){
      bool found = false;
      for(int k = 0; k < tc.numGuardVars; k++){
         if(tc.guardVarsIndices[k] == j){
            found = true;
         }
      }
      if(found == false){
         tc.equationTerm = tc.zero;
         for(int i = 0; i < tc.numEq + tc.numInvariants; i++){
            tc.args[0] = tc.l2[i];
            tc.args[1] = tc.AP[i][j];
            tc.addTerm = Z3_mk_mul(tc.ctx, 2, tc.args);
            tc.args[0] = tc.equationTerm;
            tc.args[1] = tc.addTerm;
            tc.equationTerm = Z3_mk_add(tc.ctx, 2, tc.args);
         }
         tc.assertTerm = Z3_mk_eq(tc.ctx, tc.equationTerm, tc.zero);
         Z3_solver_assert(tc.ctx, tc.s, tc.assertTerm);
         myPrintf("\n (assert %s ) \n", Z3_ast_to_string(tc.ctx, tc.assertTerm));
      }
   }
   //Ranking function should only contain variables from Guards. : Ends.
}

void addVarsNotPresentInInvariantConstraints(terminationContext& tc){
   //Variables that don't affect variables in Guards can't be present in invariants.

   for(int k = 0; k < tc.varsNotInInvariantsIndex; k++){
      int j = tc.varsNotInInvariants[k];
      for(int l = 0; l < tc.numInvariants; l++){
         tc.assertTerm = Z3_mk_eq(tc.ctx, tc.inv[l][j], tc.zero);
         Z3_solver_assert(tc.ctx, tc.s, tc.assertTerm);
         myPrintf("\n (assert %s ) \n", Z3_ast_to_string(tc.ctx, tc.assertTerm));
      }
   }
   //Variables that don't affect variables in Guards can't be present in invariants. : Ends.
}
void addNonLinearConstraintsForInvariants(terminationContext& tc){
   /* Nonlinear Constraint Solving for Invariant */
   //Adding invariant constraint directly in the original system.

   for(int l = 0; l < tc.numInvariants; l++){
      for(int j = 0; j < tc.numVars; j++){
         tc.equationTerm = tc.zero;
         for(int i = 0; i < tc.numEq + tc.numInvariants; i++){
            tc.args[0] = tc.l3[l][i];
            tc.args[1] = tc.A[i][j];
            tc.addTerm = Z3_mk_mul(tc.ctx, 2, tc.args);
            tc.args[0] = tc.equationTerm;
            tc.args[1] = tc.addTerm;
            tc.equationTerm = Z3_mk_add(tc.ctx, 2, tc.args);
         }
         tc.assertTerm = Z3_mk_eq(tc.ctx, tc.equationTerm, tc.zero);
         Z3_solver_assert(tc.ctx, tc.s, tc.assertTerm);
         myPrintf("\n (assert %s )\n", Z3_ast_to_string(tc.ctx, tc.assertTerm));
      }
   }

   for(int l = 0; l < tc.numInvariants; l++){
      for(int j = 0; j < tc.numVars; j++){
         tc.equationTerm = tc.zero;
         for(int i = 0; i < tc.numEq + tc.numInvariants; i++){
            tc.args[0] = tc.l3[l][i];
            tc.args[1] = tc.AP[i][j];
            tc.addTerm = Z3_mk_mul(tc.ctx, 2, tc.args);
            tc.args[0] = tc.equationTerm;
            tc.args[1] = tc.addTerm;
            tc.equationTerm = Z3_mk_add(tc.ctx, 2, tc.args);
         }
         tc.assertTerm = Z3_mk_eq(tc.ctx, tc.equationTerm, tc.inv[l][j]);
         Z3_solver_assert(tc.ctx, tc.s, tc.assertTerm);
         myPrintf("\n (assert %s )\n", Z3_ast_to_string(tc.ctx, tc.assertTerm));
      }
   }

   for(int l = 0; l < tc.numInvariants; l++){
      tc.equationTerm = tc.zero;
      for(int i = 0; i < tc.numEq + tc.numInvariants; i++){
         tc.args[0] = tc.l3[l][i];
         tc.args[1] = tc.b[i];
         tc.addTerm = Z3_mk_mul(tc.ctx, 2, tc.args);
         tc.args[0] = tc.equationTerm;
         tc.args[1] = tc.addTerm;
         tc.equationTerm = Z3_mk_add(tc.ctx, 2, tc.args);
      }
      tc.assertTerm = Z3_mk_le(tc.ctx, tc.equationTerm, tc.inv[l][tc.numVars]);
      Z3_solver_assert(tc.ctx, tc.s, tc.assertTerm);
      myPrintf("\n (assert %s )\n", Z3_ast_to_string(tc.ctx, tc.assertTerm));
   }
}

void addNewIdeaConstraint(terminationContext& tc){
   for(int l = 0; l < tc.numInvariants; l++){
      for(int i = 0; i < tc.numEq; i++){
         tc.equationTerm = tc.zero;
         for(int j = 0; j < 2 * tc.numVars; j++){
            if(j < tc.numVars){
               tc.args[0] = tc.A[i][j];
               tc.args[1] = tc.vars[l][j];
               tc.addTerm = Z3_mk_mul(tc.ctx, 2, tc.args);
               tc.args[0] = tc.equationTerm;
               tc.args[1] = tc.addTerm;
               tc.equationTerm = Z3_mk_add(tc.ctx, 2, tc.args);
            }
            else{
               int jIndex = j - tc.numVars;
               tc.args[0] = tc.AP[i][jIndex];
               tc.args[1] = tc.vars[l][j];
               tc.addTerm = Z3_mk_mul(tc.ctx, 2, tc.args);
               tc.args[0] = tc.equationTerm;
               tc.args[1] = tc.addTerm;
               tc.equationTerm = Z3_mk_add(tc.ctx, 2, tc.args);
            }
         }
         tc.assertTerm = Z3_mk_le(tc.ctx, tc.equationTerm, tc.b[i]);
         Z3_solver_assert(tc.ctx, tc.s, tc.assertTerm);
         myPrintf("\n (assert %s )\n", Z3_ast_to_string(tc.ctx, tc.assertTerm));
      }
      tc.equationTerm = tc.zero;
      for(int j = 0; j < tc.numVars; j++){
         tc.args[0] = tc.inv[l][j];
         tc.args[1] = tc.vars[l][j];
         tc.addTerm = Z3_mk_mul(tc.ctx, 2, tc.args);
         tc.args[0] = tc.equationTerm;
         tc.args[1] = tc.addTerm;
         tc.equationTerm = Z3_mk_add(tc.ctx, 2, tc.args);
      }
      tc.assertTerm = Z3_mk_gt(tc.ctx, tc.equationTerm, tc.inv[l][tc.numVars]);
      Z3_solver_assert(tc.ctx, tc.s, tc.assertTerm);
      myPrintf("\n (assert %s )\n", Z3_ast_to_string(tc.ctx, tc.assertTerm));
   }
}

void addHeuristics(terminationContext& tc){
   for(int i = 0; i < tc.numInvariants; i++){
      for(int j = 0; j < tc.numVars; j++){
         tc.assertTerm = Z3_mk_le(tc.ctx, tc.inv[i][j], mk_int(tc.ctx, 10));
         Z3_solver_assert(tc.ctx, tc.s, tc.assertTerm);
         myPrintf("\n (assert %s )\n", Z3_ast_to_string(tc.ctx, tc.assertTerm));
         tc.assertTerm = Z3_mk_ge(tc.ctx, tc.inv[i][j], mk_int(tc.ctx, -10));
         Z3_solver_assert(tc.ctx, tc.s, tc.assertTerm);
         myPrintf("\n (assert %s )\n", Z3_ast_to_string(tc.ctx, tc.assertTerm));
      }
   }
}

void  getModel(terminationContext& tc){
   unsigned num_constants;
   unsigned k;
   num_constants = Z3_model_get_num_consts(tc.ctx, tc.m);
   for (k = 0; k < num_constants; k++){
      Z3_symbol name;
      Z3_func_decl cnst = Z3_model_get_const_decl(tc.ctx, tc.m, k);
      Z3_ast a, v;
      Z3_bool ok;
      name = Z3_get_decl_name(tc.ctx, cnst);
      if(Z3_get_symbol_kind(tc.ctx, name) != Z3_STRING_SYMBOL){
         myPrintf(" Problem :: Different Symbol Found. ");
         exit(0);
      }
      char strName[STRBOUND];
      strcpy(strName, Z3_get_symbol_string(tc.ctx, name));
      bool found = false;
      for(int i = 0; i < tc.numInvariants; i++){
         for(int j = 0; j <= tc.numVars; j++){
            if(strcmp(Z3_ast_to_string(tc.ctx, tc.inv[i][j]), strName) == 0){
               found = true;
               a = Z3_mk_app(tc.ctx, cnst, 0, 0);
               v = a;
               ok = Z3_eval(tc.ctx, tc.m, a, &v);
               tc.invModel[i][j] = atoi(Z3_get_numeral_string(tc.ctx, v));
               break;
            }
         }
         if(found == true){
            break;
         }
      }
      if(found == true){
         continue;
      }
      for(int z = 0; z < tc.numEq + tc.numInvariants; z++){
         if(strcmp(Z3_ast_to_string(tc.ctx, tc.l2[z]), strName ) == 0){
            found = true;
            a = Z3_mk_app(tc.ctx, cnst, 0, 0);
            v = a;
            ok = Z3_eval(tc.ctx, tc.m, a, &v);
            tc.l2Model[z] = atoi(Z3_get_numeral_string(tc.ctx, v));
            break;
         }
      }
   }
}

void displayInvariant(terminationContext& tc){
   printf("\nInvariant is");
   for(int i = 0; i < tc.numInvariants; i++){
      printf("\n");
      for(int j = 0; j < tc.numVars; j++){
         if(tc.invModel[i][j] == 0){
            continue;
         }
         printf("%d * %s + ", tc.invModel[i][j], tc.variableNames[j]);
      }
      printf(" <= %d", tc.invModel[i][tc.numVars]);
   }
}

void displayRankingFunction(terminationContext& tc){
   for(int j = 0; j < tc.numVars; j++){
      tc.rankFunctionModel[j] = 0;
      for(int i = 0; i < tc.numEq; i++){  // Only till tc.numEq. The rest of the entries in matrix AP are zero
                                          // as they correspond to the invariants.
            tc.rankFunctionModel[j] += tc.AP_Int[i][j] * tc.l2Model[i];
      }
   }
   printf("\n Ranking Function is");
   printf("\n");
   for(int j = 0; j < tc.numVars; j++){
      if(tc.rankFunctionModel[j] == 0){
         continue;
      }
      printf("%d * %s + ", tc.rankFunctionModel[j], tc.variableNames[j]);
   }
}

//void nonTerminationFunction(nonTerminationContext& ntc){
//   void takeInputForNonTermination(nonTerminationContext& ntc, terminationContext& tc);
//   void initializeASTVarsForNonTermination(nonTerminationContext& ntc);
//   void addNonLinearConstraintsForRecurrentSet(nonTerminationContext& ntc);
//   void addStemHasStateForNonTerminationConstraint(nonTerminationContext& ntc);
//
//}

//void takeInputForNonTermination(nonTerminationContext& ntc, terminationContext& tc){
//   bool updateCommand = false;
//   ntc.numVars = tc.numVars;
//   ntc.numEqIC = tc.numEqIC;
//   for(int i = 0; i < tc.numVars; i++){
//      strcpy(ntc.variableNames[i], tc.variableNames[i]);
//   }
//   for(int i = 0; i < tc.numEq; i++){
//      bool updateCommand = false;
//      bool toNeglect = false;
//      for(int j = 0; j < tc.numVars; j++){
//         if(tc.AP_Int[i][j] != 0){
//            updateCommand = true;
//            if(tc.AP_Int[i][j] == -1){
//               toNeglect = true;
//            }
//            break;
//         }
//      }
//      if(updateCommand == true && toNeglect == true){
//         continue;
//      }
//      if(updateCommand == false){
//         for(int j = 0; j < tc.numVars; j++){
//            ntc.G_Int[ntc.guardCommandIndex][j] = tc.A_Int[i][j];
//         }
//         ntc.g_Int[ntc.guardCommandIndex] = tc.b_Int[i];
//         ntc.guardCommandIndex++;
//      }
//      else{
//         assert(tc.AP_Int[i][ntc.updateCommandIndex] == 1);
//         for(int j = 0; j < tc.numVars; j++){
//            ntc.U_Int[ntc.updateCommandIndex][j] = tc.A_Int[i][j] * -1;
//         }
//         ntc.u_Int[ntc.updateCommandIndex] = tc.b_Int[i];
//         ntc.updateCommandIndex++;
//      }
//   }
//   assert(ntc.updateCommandIndex == ntc.numVars);
//   for(int i = 0; i < tc.numEqIC; i++){
//      for(int j = 0; j <= 2 * tc.numVars; j++){
//         ntc.initialCondition_Int[i][j] = tc.initialCondition_Int[i][j];
//      }
//   }
//
//   /*
//   printf("\nG Matrix is\n");
//   for(int i = 0; i < ntc.guardCommandIndex; i++){
//      for(int j = 0; j < ntc.numVars; j++)
//         printf(" %d ", ntc.G_Int[i][j]);
//      printf(" %d\n", ntc.g_Int[i]);
//   }
//   printf("\nU Matrix is\n");
//   for(int i = 0; i < ntc.updateCommandIndex; i++){
//      for(int j = 0; j < ntc.numVars; j++)
//         printf(" %d ", ntc.U_Int[i][j]);
//      printf(" %d\n", ntc.u_Int[i]);
//   }
//   exit(0);
//   */
//}
//
//void initializeASTVarsForNonTermination(nonTerminationContext& ntc){
//   void calculateTU(nonTerminationContext& ntc);
//   char name[256];
//
//   for(int i = 0; i < ntc.guardCommandIndex; i++){
//      for(int j = 0; j < ntc.numVars; j++){
//         ntc.G[i][j] = mk_int(ntc.ctx, ntc.G_Int[i][j]);
//      }
//      ntc.g[i] = mk_int(ntc.ctx, ntc.g_Int[i]);
//   }
//   for(int i = 0; i < ntc.updateCommandIndex; i++){
//      for(int j = 0; j < ntc.numVars; j++){
//         ntc.U[i][j] = mk_int(ntc.ctx, ntc.U_Int[i][j]);
//      }
//      ntc.u[i] = mk_int(ntc.ctx, ntc.u_Int[i]);
//   }
//
//   for(int i = 0; i < ntc.numRecurrentSetEqs; i++){
//      for(int j = 0; j < ntc.numVars; j++){
//         sprintf(name, "T_rs_%d_%d", i + 1, j + 1);
//         ntc.T[i][j] = Z3_mk_const(ntc.ctx, Z3_mk_string_symbol(ntc.ctx, name), ntc.int_sort);
//         myPrintf("(declare-const %s Int)", name);
//      }
//   }
//   for(int i = 0; i < ntc.numRecurrentSetEqs; i++){
//         sprintf(name, "t_%d", i + 1);
//         ntc.t[i] = Z3_mk_const(ntc.ctx, Z3_mk_string_symbol(ntc.ctx, name), ntc.int_sort);
//         myPrintf("(declare-const %s Int)", name);
//   }
//
//   for(int i = 0; i < ntc.guardCommandIndex + ntc.numRecurrentSetEqs; i++){
//      for(int j = 0; j < ntc.numRecurrentSetEqs; j++){
//         sprintf(name, "lnt_%d_%d", i + 1, j + 1);
//         ntc.lnt[i][j] = Z3_mk_const(ntc.ctx, Z3_mk_string_symbol(ntc.ctx, name), ntc.int_sort);
//         myPrintf("(declare-const %s Int)", name);
//         //lambda_1 >= 0
//         ntc.assertTerm = Z3_mk_ge(ntc.ctx, ntc.lnt[i][j], ntc.zero);
//         Z3_solver_assert(ntc.ctx, ntc.s, ntc.assertTerm);
//         myPrintf("\n(assert %s )\n", Z3_ast_to_string(ntc.ctx, ntc.assertTerm));
//      }
//   }
//
//   for(int l = 0; l < ntc.numRecurrentSetEqs; l++){
//      for(int j = 0; j < ntc.numVars; j++){
//         ntc.equationTerm = ntc.zero;
//         for(int i = 0; i < ntc.updateCommandIndex; i++){
//            ntc.args[0] = ntc.T[l][i];
//            ntc.args[1] = ntc.U[i][j];
//            ntc.addTerm = Z3_mk_mul(ntc.ctx, 2, ntc.args);
//            ntc.args[0] = ntc.equationTerm;
//            ntc.args[1] = ntc.addTerm;
//            ntc.equationTerm = Z3_mk_add(ntc.ctx, 2, ntc.args);
//         }
//         ntc.TU[l][j] = ntc.equationTerm;
//      }
//   }
//
//   for(int l = 0; l < ntc.numRecurrentSetEqs; l++){
//      ntc.equationTerm = ntc.zero;
//      for(int i = 0; i < ntc.updateCommandIndex; i++){
//         ntc.args[0] = ntc.T[l][i];
//         ntc.args[1] = ntc.u[i];
//         ntc.addTerm = Z3_mk_mul(ntc.ctx, 2, ntc.args);
//         ntc.args[0] = ntc.equationTerm;
//         ntc.args[1] = ntc.addTerm;
//         ntc.equationTerm = Z3_mk_add(ntc.ctx, 2, ntc.args);
//      }
//      ntc.Tu[l] = ntc.equationTerm;
//   }
//
//   for(int i = 0; i < ntc.numVars; i++){
//      sprintf(name, "%s", ntc.variableNames[i]);
//      ntc.vars[i] = Z3_mk_const(ntc.ctx, Z3_mk_string_symbol(ntc.ctx, name), ntc.int_sort);
//      myPrintf("(declare-const %s Int)", name);
//   }
//
//   for(int i = 0; i < ntc.numVars; i++){
//      sprintf(name, "%s_p", ntc.variableNames[i]);
//      ntc.vars[ntc.numVars + i] = Z3_mk_const(ntc.ctx, Z3_mk_string_symbol(ntc.ctx, name), ntc.int_sort);
//      myPrintf("(declare-const %s Int)", name);
//   }
//   for(int i = 0; i < ntc.numEqIC; i++){
//      for(int j = 0; j <= 2 * ntc.numVars; j++){
//         ntc.initialCondition[i][j] = mk_int(ntc.ctx, ntc.initialCondition_Int[i][j]);
//
//      }
//   }
//}
//
//void addStemHasStateForNonTerminationConstraint(nonTerminationContext& ntc){
//   for(int i = 0; i < ntc.numEqIC; i++){
//      ntc.equationTerm = ntc.zero;
//      for(int j = 0; j < 2 * ntc.numVars; j++){
//         ntc.args[0] = ntc.initialCondition[i][j];
//         ntc.args[1] = ntc.vars[j];
//         ntc.addTerm = Z3_mk_mul(ntc.ctx, 2, ntc.args);
//         ntc.args[0] = ntc.equationTerm;
//         ntc.args[1] = ntc.addTerm;
//         ntc.equationTerm = Z3_mk_add(ntc.ctx, 2, ntc.args);
//      }
//      ntc.assertTerm = Z3_mk_le(ntc.ctx, ntc.equationTerm, ntc.initialCondition[i][2 * ntc.numVars]);
//      Z3_solver_assert(ntc.ctx, ntc.s, ntc.assertTerm);
//      myPrintf("\n (assert %s )\n", Z3_ast_to_string(ntc.ctx, ntc.assertTerm));
//   }
//
//   for(int i = 0; i < ntc.numRecurrentSetEqs; i++){
//      ntc.equationTerm = ntc.zero;
//      for(int j = 0; j < ntc.numVars; j++){
//         ntc.args[0] = ntc.T[i][j];
//         ntc.args[1] = ntc.vars[j];
//         ntc.addTerm = Z3_mk_mul(ntc.ctx, 2, ntc.args);
//         ntc.args[0] = ntc.equationTerm;
//         ntc.args[1] = ntc.addTerm;
//         ntc.equationTerm = Z3_mk_add(ntc.ctx, 2, ntc.args);
//      }
//      ntc.assertTerm = Z3_mk_le(ntc.ctx, ntc.equationTerm, ntc.t[i]);
//      Z3_solver_assert(ntc.ctx, ntc.s, ntc.assertTerm);
//      myPrintf("\n (assert %s )\n", Z3_ast_to_string(ntc.ctx, ntc.assertTerm));
//   }
//}
//
//void addNonLinearConstraintsForRecurrentSet(nonTerminationContext& ntc){
//   void getNTCModel(nonTerminationContext& ntc);
//   void displayRecurrentSet(nonTerminationContext& ntc);
//
//   for(int l = 0; l < ntc.guardCommandIndex; l++){
//      for(int j = 0; j < ntc.numVars; j++){
//         ntc.equationTerm = ntc.zero;
//         for(int i = 0; i < ntc.numRecurrentSetEqs; i++){
//            ntc.args[0] = ntc.lnt[l][i];
//            ntc.args[1] = ntc.T[i][j];
//            ntc.addTerm = Z3_mk_mul(ntc.ctx, 2, ntc.args);
//            ntc.args[0] = ntc.equationTerm;
//            ntc.args[1] = ntc.addTerm;
//            ntc.equationTerm = Z3_mk_add(ntc.ctx, 2, ntc.args);
//         }
//         ntc.assertTerm = Z3_mk_eq(ntc.ctx, ntc.equationTerm, ntc.G[l][j]);
//         Z3_solver_assert(ntc.ctx, ntc.s, ntc.assertTerm);
//         myPrintf("\n (assert %s )\n", Z3_ast_to_string(ntc.ctx, ntc.assertTerm));
//      }
//   }
//
//   for(int l = 0; l < ntc.guardCommandIndex; l++){
//      ntc.equationTerm = ntc.zero;
//      for(int i = 0; i < ntc.numRecurrentSetEqs; i++){
//            ntc.args[0] = ntc.lnt[l][i];
//            ntc.args[1] = ntc.t[i];
//            ntc.addTerm = Z3_mk_mul(ntc.ctx, 2, ntc.args);
//            ntc.args[0] = ntc.equationTerm;
//            ntc.args[1] = ntc.addTerm;
//            ntc.equationTerm = Z3_mk_add(ntc.ctx, 2, ntc.args);
//      }
//      ntc.assertTerm = Z3_mk_le(ntc.ctx, ntc.equationTerm, ntc.g[l]);
//      Z3_solver_assert(ntc.ctx, ntc.s, ntc.assertTerm);
//      myPrintf("\n (assert %s )\n", Z3_ast_to_string(ntc.ctx, ntc.assertTerm));
//   }
//
//   for(int l = 0; l < ntc.numRecurrentSetEqs; l++){
//      for(int j = 0; j < ntc.numVars; j++){
//         ntc.equationTerm = ntc.zero;
//         for(int i = 0; i < ntc.numRecurrentSetEqs; i++){
//            ntc.args[0] = ntc.lnt[l + ntc.guardCommandIndex][i];
//            ntc.args[1] = ntc.T[i][j];
//            ntc.addTerm = Z3_mk_mul(ntc.ctx, 2, ntc.args);
//            ntc.args[0] = ntc.equationTerm;
//            ntc.args[1] = ntc.addTerm;
//            ntc.equationTerm = Z3_mk_add(ntc.ctx, 2, ntc.args);
//         }
//         ntc.assertTerm = Z3_mk_eq(ntc.ctx, ntc.equationTerm, ntc.TU[l][j]);
//         Z3_solver_assert(ntc.ctx, ntc.s, ntc.assertTerm);
//         myPrintf("\n (assert %s )\n", Z3_ast_to_string(ntc.ctx, ntc.assertTerm));
//      }
//   }
//   for(int l = 0; l < ntc.numRecurrentSetEqs; l++){
//      ntc.equationTerm = ntc.zero;
//      for(int i = 0; i < ntc.numRecurrentSetEqs; i++){
//         ntc.args[0] = ntc.lnt[l + ntc.guardCommandIndex][i];
//         ntc.args[1] = ntc.t[i];
//         ntc.addTerm = Z3_mk_mul(ntc.ctx, 2, ntc.args);
//         ntc.args[0] = ntc.equationTerm;
//         ntc.args[1] = ntc.addTerm;
//         ntc.equationTerm = Z3_mk_add(ntc.ctx, 2, ntc.args);
//      }
//      ntc.args[0] = ntc.t[l];
//      ntc.args[1] = ntc.Tu[l];
//
//      ntc.assertTerm = Z3_mk_le(ntc.ctx, ntc.equationTerm, Z3_mk_sub(ntc.ctx, 2, ntc.args));
//      Z3_solver_assert(ntc.ctx, ntc.s, ntc.assertTerm);
//      myPrintf("\n (assert %s )\n", Z3_ast_to_string(ntc.ctx, ntc.assertTerm));
//   }
//   myPrintf( "(check-sat)\n");
//   myPrintf( "(get-model)\n");
//   myPrintf( "(exit)\n");
//
//   if(p_arg == true){
//      exit(0);
//   }
//   Z3_lbool result;
//   result = Z3_solver_check(ntc.ctx, ntc.s);
//   switch (result){
//      case Z3_L_FALSE:
//         printf("\nunsat for numRecurrentSetEqs = %d \n", ntc.numRecurrentSetEqs);
//         //tc.numInvariants++;
//         Z3_del_context(ntc.ctx);
//         //break;
//         exit(0);
//      case Z3_L_UNDEF:
//         printf("\nunknown\n");
//         ntc.m = Z3_solver_get_model(ntc.ctx, ntc.s);
//         printf("potential model:\n");
//         display_model(ntc.ctx, stdout, ntc.m);
//         //if (tc.m){
//         //Z3_del_model(tc.ctx, tc.m);
//         //}
//         exit(0);
//      case Z3_L_TRUE:
//         printf("\nsat for numRecurrentSetEqs = %d \n", ntc.numRecurrentSetEqs);
//         ntc.m = Z3_solver_get_model(ntc.ctx, ntc.s);
//         getNTCModel(ntc);
//         displayRecurrentSet(ntc);
//         //if (tc.m){
//         //Z3_del_model(tc.ctx, tc.m);
//         //}
//         exit(0);
//   }
//}

void takeInputForNonTermination_CRS(nonTerminationContext& ntc, terminationContext& tc){

   bool updateCommand = false;
   ntc.numVars = tc.numVars;
   ntc.numEq = tc.numEq;
   ntc.numEqIC = tc.numEqIC;

   ntc.variableNames = new char* [ntc.numVars];
   for(int i = 0; i < ntc.numVars; i++){
      ntc.variableNames[i] = new char[STRBOUND];
   }

   for(int i = 0; i < tc.numVars; i++){
      strcpy(ntc.variableNames[i], tc.variableNames[i]);
   }

   ntc.vars = new Z3_ast[2 * ntc.numVars];

   ntc.G_Int = new int*[ntc.numEq];
   ntc.G = new Z3_ast*[ntc.numEq];
   ntc.g_Int = new int[ntc.numEq];
   ntc.g = new Z3_ast[ntc.numEq];
   ntc.U_Int = new int*[ntc.numEq];
   ntc.UP_Int = new int*[ntc.numEq];
   ntc.u_Int = new int[ntc.numEq];

   for(int i = 0; i < ntc.numEq; i++){
      ntc.G_Int[i] = new int[ntc.numVars];
      ntc.G[i] = new Z3_ast[ntc.numVars];
      ntc.U_Int[i] = new int[ntc.numVars];
      ntc.UP_Int[i] = new int[ntc.numVars];
   }

   ntc.initialCondition_Int = new int* [ntc.numEqIC];
   ntc.initialCondition = new Z3_ast* [ntc.numEqIC];
   for(int i = 0; i < ntc.numEqIC; i++){
      ntc.initialCondition_Int[i] = new int[2 * ntc.numVars + 1];
      ntc.initialCondition[i] = new Z3_ast[2 * ntc.numVars + 1];
   }

   ntc.T = new Z3_ast* [MAX_RECURRENT_TEMPLATE_COUNT];
   ntc.TModel = new int*[MAX_RECURRENT_TEMPLATE_COUNT];
   ntc.t = new Z3_ast[MAX_RECURRENT_TEMPLATE_COUNT];
   ntc.tModel = new int[MAX_RECURRENT_TEMPLATE_COUNT];
   for(int i = 0; i < MAX_RECURRENT_TEMPLATE_COUNT; i++){
      ntc.T[i] = new Z3_ast[ntc.numVars];
      ntc.TModel[i] = new int[ntc.numVars];
   }
   
   ntc.A = new Z3_ast* [MAX_RECURRENT_TEMPLATE_COUNT + ntc.numEq];
   ntc.AP = new Z3_ast* [MAX_RECURRENT_TEMPLATE_COUNT + ntc.numEq];
   ntc.b = new Z3_ast [MAX_RECURRENT_TEMPLATE_COUNT + ntc.numEq];

   for(int i = 0; i < MAX_RECURRENT_TEMPLATE_COUNT + ntc.numEq; i++){
      ntc.A[i] = new Z3_ast[ntc.numVars];
      ntc.AP[i] = new Z3_ast[ntc.numVars];
   }

   ntc.lnt = new Z3_ast* [ntc.numEq + MAX_RECURRENT_TEMPLATE_COUNT];
   for(int i = 0; i < ntc.numEq + MAX_RECURRENT_TEMPLATE_COUNT; i++){
      ntc.lnt[i] = new Z3_ast[MAX_RECURRENT_TEMPLATE_COUNT + ntc.numEq];
   }


   for(int i = 0; i < tc.numEq; i++){
      bool updateCommand = false;
      for(int j = 0; j < tc.numVars; j++){
         if(tc.AP_Int[i][j] != 0){
            updateCommand = true;
            break;
         }
      }
      if(updateCommand == false){
         for(int j = 0; j < tc.numVars; j++){
            ntc.G_Int[ntc.guardCommandIndex][j] = tc.A_Int[i][j];
         }
         ntc.g_Int[ntc.guardCommandIndex] = tc.b_Int[i];
         ntc.guardCommandIndex++;
      }
      else{
         for(int j = 0; j < tc.numVars; j++){
            ntc.U_Int[ntc.updateCommandIndex][j] = tc.A_Int[i][j];
            ntc.UP_Int[ntc.updateCommandIndex][j] = tc.AP_Int[i][j];
         }
         ntc.u_Int[ntc.updateCommandIndex] = tc.b_Int[i];
         ntc.updateCommandIndex++;
      }
   }

   for(int i = 0; i < tc.numEqIC; i++){
      for(int j = 0; j <= 2 * tc.numVars; j++){
         ntc.initialCondition_Int[i][j] = tc.initialCondition_Int[i][j];
      }
   }
}

void takeInputForNonTermination_RS(nonTerminationContext& ntc, terminationContext& tc){

   bool updateCommand = false;
   ntc.numVars = tc.numVars;
   ntc.numEq = tc.numEq;
   ntc.numEqIC = tc.numEqIC;

   ntc.variableNames = new char* [ntc.numVars];
   for(int i = 0; i < ntc.numVars; i++){
      ntc.variableNames[i] = new char[STRBOUND];
   }

   for(int i = 0; i < tc.numVars; i++){
      strcpy(ntc.variableNames[i], tc.variableNames[i]);
   }

   ntc.vars = new Z3_ast[2 * ntc.numVars];

   ntc.G_Int = new int*[ntc.numEq];
   ntc.G = new Z3_ast*[ntc.numEq];
   ntc.g_Int = new int[ntc.numEq];
   ntc.g = new Z3_ast[ntc.numEq];

   ntc.U_rs_Int = new int*[ntc.numVars];
   ntc.u_rs_Int = new int[ntc.numVars];

   for(int i = 0; i < ntc.numEq; i++){
      ntc.G_Int[i] = new int[ntc.numVars];
      ntc.G[i] = new Z3_ast[ntc.numVars];
   }
   for(int i = 0; i < ntc.numVars; i++){
      ntc.U_rs_Int[i] = new int[ntc.numVars];
   }

   ntc.initialCondition_Int = new int* [ntc.numEqIC];
   ntc.initialCondition = new Z3_ast* [ntc.numEqIC];
   for(int i = 0; i < ntc.numEqIC; i++){
      ntc.initialCondition_Int[i] = new int[2 * ntc.numVars + 1];
      ntc.initialCondition[i] = new Z3_ast[2 * ntc.numVars + 1];
   }

   ntc.T = new Z3_ast* [MAX_RECURRENT_TEMPLATE_COUNT];
   ntc.TModel = new int*[MAX_RECURRENT_TEMPLATE_COUNT];
   ntc.t = new Z3_ast[MAX_RECURRENT_TEMPLATE_COUNT];
   ntc.tModel = new int[MAX_RECURRENT_TEMPLATE_COUNT];
   for(int i = 0; i < MAX_RECURRENT_TEMPLATE_COUNT; i++){
      ntc.T[i] = new Z3_ast[ntc.numVars];
      ntc.TModel[i] = new int[ntc.numVars];
   }
   
   ntc.U_rs = new Z3_ast*[ntc.numVars];
   ntc.u_rs = new Z3_ast[ntc.numVars];
   for(int i = 0; i < ntc.numVars; i++){
      ntc.U_rs[i] = new Z3_ast[ntc.numVars];
   }

   ntc.TU = new Z3_ast*[MAX_RECURRENT_TEMPLATE_COUNT];
   for(int i = 0; i < MAX_RECURRENT_TEMPLATE_COUNT; i++){
      ntc.TU[i] = new Z3_ast[ntc.numVars];
   }
   ntc.Tu = new Z3_ast[MAX_RECURRENT_TEMPLATE_COUNT];

   ntc.lnt = new Z3_ast* [ntc.numEq + MAX_RECURRENT_TEMPLATE_COUNT];
   for(int i = 0; i < ntc.numEq + MAX_RECURRENT_TEMPLATE_COUNT; i++){
      ntc.lnt[i] = new Z3_ast[MAX_RECURRENT_TEMPLATE_COUNT];
   }

   int updateCommandNumber = 0;
   for(int i = 0; i < tc.numEq; i++){
      bool updateCommand = false;
      int updateVarIndex = -1;
      for(int j = 0; j < tc.numVars; j++){
         if(tc.AP_Int[i][j] != 0){
            assert(tc.AP_Int[i][j] == 1 ||tc.AP_Int[i][j] == -1 );
            updateCommand = true;
            if(updateVarIndex == -1){
               updateVarIndex = j;
            }
            else{
               //Two primed variables in one row.
               printf("Input not according to TnT.");
               exit(0);
            }
         }
      }
      if(updateCommand == false){
         for(int j = 0; j < tc.numVars; j++){
            ntc.G_Int[ntc.guardCommandIndex][j] = tc.A_Int[i][j];
         }
         ntc.g_Int[ntc.guardCommandIndex] = tc.b_Int[i];
         ntc.guardCommandIndex++;
      }
      else{
         updateCommandNumber++;
         for(int j = 0; j < tc.numVars; j++){
            assert(tc.A_Int[i][j] == -1*tc.A_Int[i+1][j]);
            assert(tc.AP_Int[i][j] == -1 * tc.AP_Int[i+1][j]);
         }
         if(tc.AP_Int[i][updateVarIndex] == -1){
            i = i + 1;//choose next row.
            for(int j = 0; j < tc.numVars; j++){
               ntc.U_rs_Int[updateVarIndex][j] = -1 * tc.A_Int[i][j];
            }
            ntc.u_rs_Int[updateVarIndex] = tc.b_Int[i];
         }
         else if(tc.AP_Int[i][updateVarIndex] == 1){
            for(int j = 0; j < tc.numVars; j++){
               ntc.U_rs_Int[updateVarIndex][j] = -1 * tc.A_Int[i][j];
            }
            ntc.u_rs_Int[updateVarIndex] = tc.b_Int[i];
            i = i + 1;//discard next row
         }
      }
   }
   assert(updateCommandNumber == ntc.numVars);

   for(int i = 0; i < tc.numEqIC; i++){
      for(int j = 0; j <= 2 * tc.numVars; j++){
         ntc.initialCondition_Int[i][j] = tc.initialCondition_Int[i][j];
      }
   }
}

void initializeASTVarsForNonTermination_CRS(nonTerminationContext& ntc){
   char name[256];
   for(int i = 0; i < ntc.guardCommandIndex; i++){
      for(int j = 0; j < ntc.numVars; j++){
         ntc.G[i][j] = mk_int(ntc.ctx, ntc.G_Int[i][j]);
      }
      ntc.g[i] = mk_int(ntc.ctx, ntc.g_Int[i]);
   }

   for(int i = 0; i < ntc.numRecurrentSetEqs; i++){
      for(int j = 0; j < ntc.numVars; j++){
         sprintf(name, "T_rs_%d_%d", i + 1, j + 1);
         ntc.T[i][j] = Z3_mk_const(ntc.ctx, Z3_mk_string_symbol(ntc.ctx, name), ntc.int_sort);
         myPrintf("(declare-const %s Int)", name);
      }
   }

   for(int i = 0; i < ntc.numRecurrentSetEqs; i++){
         sprintf(name, "t_%d", i + 1);
         ntc.t[i] = Z3_mk_const(ntc.ctx, Z3_mk_string_symbol(ntc.ctx, name), ntc.int_sort);
         myPrintf("(declare-const %s Int)", name);
   }

   for(int i = 0; i < ntc.guardCommandIndex + ntc.numRecurrentSetEqs; i++){
      for(int j = 0; j < ntc.numRecurrentSetEqs + ntc.updateCommandIndex; j++){
         sprintf(name, "lnt_%d_%d", i + 1, j + 1);
         ntc.lnt[i][j] = Z3_mk_const(ntc.ctx, Z3_mk_string_symbol(ntc.ctx, name), ntc.int_sort);
         myPrintf("(declare-const %s Int)", name);
         //lambda_1 >= 0
         ntc.assertTerm = Z3_mk_ge(ntc.ctx, ntc.lnt[i][j], ntc.zero);
         Z3_solver_assert(ntc.ctx, ntc.s, ntc.assertTerm);
         myPrintf("\n(assert %s )\n", Z3_ast_to_string(ntc.ctx, ntc.assertTerm));
      }
   }

   for(int i = 0; i < ntc.numRecurrentSetEqs; i++){
      for(int j = 0; j < ntc.numVars; j++){
         ntc.A[i][j] = ntc.T[i][j];
         ntc.AP[i][j] = ntc.zero;
      }
      ntc.b[i] = ntc.t[i];
   }

   for(int i = 0; i < ntc.updateCommandIndex; i++){
      for(int j = 0; j < ntc.numVars; j++){
         ntc.A[ntc.numRecurrentSetEqs + i][j] = mk_int(ntc.ctx, ntc.U_Int[i][j]);
         ntc.AP[ntc.numRecurrentSetEqs + i][j] = mk_int(ntc.ctx, ntc.UP_Int[i][j]);
      }
      ntc.b[ntc.numRecurrentSetEqs + i] = mk_int(ntc.ctx, ntc.u_Int[i]);
   }

   for(int i = 0; i < ntc.numVars; i++){
      sprintf(name, "%s", ntc.variableNames[i]);
      ntc.vars[i] = Z3_mk_const(ntc.ctx, Z3_mk_string_symbol(ntc.ctx, name), ntc.int_sort);
      myPrintf("(declare-const %s Int)", name);
   }

   for(int i = 0; i < ntc.numVars; i++){
      sprintf(name, "%s_p", ntc.variableNames[i]);
      ntc.vars[ntc.numVars + i] = Z3_mk_const(ntc.ctx, Z3_mk_string_symbol(ntc.ctx, name), ntc.int_sort);
      myPrintf("(declare-const %s Int)", name);
   }
   for(int i = 0; i < ntc.numEqIC; i++){
      for(int j = 0; j <= 2 * ntc.numVars; j++){
         ntc.initialCondition[i][j] = mk_int(ntc.ctx, ntc.initialCondition_Int[i][j]);
      }
   }
}

void initializeASTVarsForNonTermination_RS(nonTerminationContext& ntc){
   char name[256];
   for(int i = 0; i < ntc.guardCommandIndex; i++){
      for(int j = 0; j < ntc.numVars; j++){
         ntc.G[i][j] = mk_int(ntc.ctx, ntc.G_Int[i][j]);
      }
      ntc.g[i] = mk_int(ntc.ctx, ntc.g_Int[i]);
   }

   for(int i = 0; i < ntc.numRecurrentSetEqs; i++){
      for(int j = 0; j < ntc.numVars; j++){
         sprintf(name, "T_rs_%d_%d", i + 1, j + 1);
         ntc.T[i][j] = Z3_mk_const(ntc.ctx, Z3_mk_string_symbol(ntc.ctx, name), ntc.int_sort);
         myPrintf("(declare-const %s Int)", name);
      }
   }

   for(int i = 0; i < ntc.numRecurrentSetEqs; i++){
         sprintf(name, "t_%d", i + 1);
         ntc.t[i] = Z3_mk_const(ntc.ctx, Z3_mk_string_symbol(ntc.ctx, name), ntc.int_sort);
         myPrintf("(declare-const %s Int)", name);
   }

   for(int i = 0; i < ntc.guardCommandIndex + ntc.numRecurrentSetEqs; i++){
      for(int j = 0; j < ntc.numRecurrentSetEqs; j++){
         sprintf(name, "lnt_%d_%d", i + 1, j + 1);
         ntc.lnt[i][j] = Z3_mk_const(ntc.ctx, Z3_mk_string_symbol(ntc.ctx, name), ntc.int_sort);
         myPrintf("(declare-const %s Int)", name);
         //lambda_1 >= 0
         ntc.assertTerm = Z3_mk_ge(ntc.ctx, ntc.lnt[i][j], ntc.zero);
         Z3_solver_assert(ntc.ctx, ntc.s, ntc.assertTerm);
         myPrintf("\n(assert %s )\n", Z3_ast_to_string(ntc.ctx, ntc.assertTerm));
      }
   }

   for(int i = 0; i < ntc.numVars; i++){
      for(int j = 0; j < ntc.numVars; j++){
         ntc.U_rs[i][j] = mk_int(ntc.ctx, ntc.U_rs_Int[i][j]);
      }
      ntc.u_rs[i] = mk_int(ntc.ctx, ntc.u_rs_Int[i]);
   }

   for(int i = 0; i < ntc.numVars; i++){
      sprintf(name, "%s", ntc.variableNames[i]);
      ntc.vars[i] = Z3_mk_const(ntc.ctx, Z3_mk_string_symbol(ntc.ctx, name), ntc.int_sort);
      myPrintf("(declare-const %s Int)", name);
   }

   for(int i = 0; i < ntc.numVars; i++){
      sprintf(name, "%s_p", ntc.variableNames[i]);
      ntc.vars[ntc.numVars + i] = Z3_mk_const(ntc.ctx, Z3_mk_string_symbol(ntc.ctx, name), ntc.int_sort);
      myPrintf("(declare-const %s Int)", name);
   }
   for(int i = 0; i < ntc.numEqIC; i++){
      for(int j = 0; j <= 2 * ntc.numVars; j++){
         ntc.initialCondition[i][j] = mk_int(ntc.ctx, ntc.initialCondition_Int[i][j]);
      }
   }
}

void addStemHasStateForNonTerminationConstraint(nonTerminationContext& ntc){
   for(int i = 0; i < ntc.numEqIC; i++){
      ntc.equationTerm = ntc.zero;
      for(int j = 0; j < 2 * ntc.numVars; j++){
         ntc.args[0] = ntc.initialCondition[i][j];
         ntc.args[1] = ntc.vars[j];
         ntc.addTerm = Z3_mk_mul(ntc.ctx, 2, ntc.args);
         ntc.args[0] = ntc.equationTerm;
         ntc.args[1] = ntc.addTerm;
         ntc.equationTerm = Z3_mk_add(ntc.ctx, 2, ntc.args);
      }
      ntc.assertTerm = Z3_mk_le(ntc.ctx, ntc.equationTerm, ntc.initialCondition[i][2 * ntc.numVars]);
      Z3_solver_assert(ntc.ctx, ntc.s, ntc.assertTerm);
      myPrintf("\n (assert %s )\n", Z3_ast_to_string(ntc.ctx, ntc.assertTerm));
   }

   for(int i = 0; i < ntc.numRecurrentSetEqs; i++){
      ntc.equationTerm = ntc.zero;
      for(int j = 0; j < ntc.numVars; j++){
         ntc.args[0] = ntc.T[i][j];
         ntc.args[1] = ntc.vars[j];
         ntc.addTerm = Z3_mk_mul(ntc.ctx, 2, ntc.args);
         ntc.args[0] = ntc.equationTerm;
         ntc.args[1] = ntc.addTerm;
         ntc.equationTerm = Z3_mk_add(ntc.ctx, 2, ntc.args);
      }
      ntc.assertTerm = Z3_mk_le(ntc.ctx, ntc.equationTerm, ntc.t[i]);
      Z3_solver_assert(ntc.ctx, ntc.s, ntc.assertTerm);
      myPrintf("\n (assert %s )\n", Z3_ast_to_string(ntc.ctx, ntc.assertTerm));
   }
}

void addNonLinearConstraintsFor_CRS(nonTerminationContext& ntc){


   //Although Tx <= t /\ UU'(x x')^t <= u ---> Gx <= g.
   //Updates shouldn't matter.
   // Thus Only Tx <= t --> Gx <= g
   // Also note that all entries of AP matrix for first numRecurrentSetEqs rows are zero. No need to add corresponding constraint. 

   for(int l = 0; l < ntc.guardCommandIndex; l++){
      for(int j = 0; j < ntc.numVars; j++){
         ntc.equationTerm = ntc.zero;
         for(int i = 0; i < ntc.numRecurrentSetEqs; i++){
            ntc.args[0] = ntc.lnt[l][i];
            ntc.args[1] = ntc.A[i][j];
            ntc.addTerm = Z3_mk_mul(ntc.ctx, 2, ntc.args);
            ntc.args[0] = ntc.equationTerm;
            ntc.args[1] = ntc.addTerm;
            ntc.equationTerm = Z3_mk_add(ntc.ctx, 2, ntc.args);
         }
         ntc.assertTerm = Z3_mk_eq(ntc.ctx, ntc.equationTerm, ntc.G[l][j]);
         Z3_solver_assert(ntc.ctx, ntc.s, ntc.assertTerm);
         myPrintf("\n (assert %s )\n", Z3_ast_to_string(ntc.ctx, ntc.assertTerm));
      }
   }

   for(int l = 0; l < ntc.guardCommandIndex; l++){
      ntc.equationTerm = ntc.zero;
      for(int i = 0; i < ntc.numRecurrentSetEqs; i++){
            ntc.args[0] = ntc.lnt[l][i];
            ntc.args[1] = ntc.b[i];
            ntc.addTerm = Z3_mk_mul(ntc.ctx, 2, ntc.args);
            ntc.args[0] = ntc.equationTerm;
            ntc.args[1] = ntc.addTerm;
            ntc.equationTerm = Z3_mk_add(ntc.ctx, 2, ntc.args);
      }
      ntc.assertTerm = Z3_mk_le(ntc.ctx, ntc.equationTerm, ntc.g[l]);
      Z3_solver_assert(ntc.ctx, ntc.s, ntc.assertTerm);
      myPrintf("\n (assert %s )\n", Z3_ast_to_string(ntc.ctx, ntc.assertTerm));
   }

   for(int l = 0; l < ntc.numRecurrentSetEqs; l++){
      for(int j = 0; j < ntc.numVars; j++){
         ntc.equationTerm = ntc.zero;
         for(int i = 0; i < ntc.numRecurrentSetEqs + ntc.updateCommandIndex; i++){
            ntc.args[0] = ntc.lnt[l + ntc.guardCommandIndex][i];
            ntc.args[1] = ntc.A[i][j];
            ntc.addTerm = Z3_mk_mul(ntc.ctx, 2, ntc.args);
            ntc.args[0] = ntc.equationTerm;
            ntc.args[1] = ntc.addTerm;
            ntc.equationTerm = Z3_mk_add(ntc.ctx, 2, ntc.args);
         }
         ntc.assertTerm = Z3_mk_eq(ntc.ctx, ntc.equationTerm, ntc.zero);
         Z3_solver_assert(ntc.ctx, ntc.s, ntc.assertTerm);
         myPrintf("\n (assert %s )\n", Z3_ast_to_string(ntc.ctx, ntc.assertTerm));
      }
   }

   for(int l = 0; l < ntc.numRecurrentSetEqs; l++){
      for(int j = 0; j < ntc.numVars; j++){
         ntc.equationTerm = ntc.zero;
         for(int i = 0; i < ntc.numRecurrentSetEqs + ntc.updateCommandIndex; i++){
            ntc.args[0] = ntc.lnt[l + ntc.guardCommandIndex][i];
            ntc.args[1] = ntc.AP[i][j];
            ntc.addTerm = Z3_mk_mul(ntc.ctx, 2, ntc.args);
            ntc.args[0] = ntc.equationTerm;
            ntc.args[1] = ntc.addTerm;
            ntc.equationTerm = Z3_mk_add(ntc.ctx, 2, ntc.args);
         }
         ntc.assertTerm = Z3_mk_eq(ntc.ctx, ntc.equationTerm, ntc.T[l][j]);
         Z3_solver_assert(ntc.ctx, ntc.s, ntc.assertTerm);
         myPrintf("\n (assert %s )\n", Z3_ast_to_string(ntc.ctx, ntc.assertTerm));
      }
   }

   for(int l = 0; l < ntc.numRecurrentSetEqs; l++){
      ntc.equationTerm = ntc.zero;
      for(int i = 0; i < ntc.numRecurrentSetEqs + ntc.updateCommandIndex; i++){
         ntc.args[0] = ntc.lnt[l + ntc.guardCommandIndex][i];
         ntc.args[1] = ntc.b[i];
         ntc.addTerm = Z3_mk_mul(ntc.ctx, 2, ntc.args);
         ntc.args[0] = ntc.equationTerm;
         ntc.args[1] = ntc.addTerm;
         ntc.equationTerm = Z3_mk_add(ntc.ctx, 2, ntc.args);
      }
      ntc.assertTerm = Z3_mk_le(ntc.ctx, ntc.equationTerm, ntc.t[l]);
      Z3_solver_assert(ntc.ctx, ntc.s, ntc.assertTerm);
      myPrintf("\n (assert %s )\n", Z3_ast_to_string(ntc.ctx, ntc.assertTerm));
   }
}

void addNonLinearConstraintsFor_RS(nonTerminationContext& ntc){

   for(int l = 0; l < ntc.guardCommandIndex; l++){
      for(int j = 0; j < ntc.numVars; j++){
         ntc.equationTerm = ntc.zero;
         for(int i = 0; i < ntc.numRecurrentSetEqs; i++){
            ntc.args[0] = ntc.lnt[l][i];
            ntc.args[1] = ntc.T[i][j];
            ntc.addTerm = Z3_mk_mul(ntc.ctx, 2, ntc.args);
            ntc.args[0] = ntc.equationTerm;
            ntc.args[1] = ntc.addTerm;
            ntc.equationTerm = Z3_mk_add(ntc.ctx, 2, ntc.args);
         }
         ntc.assertTerm = Z3_mk_eq(ntc.ctx, ntc.equationTerm, ntc.G[l][j]);
         Z3_solver_assert(ntc.ctx, ntc.s, ntc.assertTerm);
         myPrintf("\n (assert %s )\n", Z3_ast_to_string(ntc.ctx, ntc.assertTerm));
      }
   }

   for(int l = 0; l < ntc.guardCommandIndex; l++){
      ntc.equationTerm = ntc.zero;
      for(int i = 0; i < ntc.numRecurrentSetEqs; i++){
            ntc.args[0] = ntc.lnt[l][i];
            ntc.args[1] = ntc.t[i];
            ntc.addTerm = Z3_mk_mul(ntc.ctx, 2, ntc.args);
            ntc.args[0] = ntc.equationTerm;
            ntc.args[1] = ntc.addTerm;
            ntc.equationTerm = Z3_mk_add(ntc.ctx, 2, ntc.args);
      }
      ntc.assertTerm = Z3_mk_le(ntc.ctx, ntc.equationTerm, ntc.g[l]);
      Z3_solver_assert(ntc.ctx, ntc.s, ntc.assertTerm);
      myPrintf("\n (assert %s )\n", Z3_ast_to_string(ntc.ctx, ntc.assertTerm));
   }

   for(int l = 0; l < ntc.numRecurrentSetEqs; l++){
      for(int j = 0; j < ntc.numVars; j++){
         ntc.equationTerm = ntc.zero;
         for(int i = 0; i < ntc.numVars; i++){
            ntc.args[0] = ntc.T[l][i];
            ntc.args[1] = ntc.U_rs[i][j];
            ntc.addTerm = Z3_mk_mul(ntc.ctx, 2, ntc.args);
            ntc.args[0] = ntc.equationTerm;
            ntc.args[1] = ntc.addTerm;
            ntc.equationTerm = Z3_mk_add(ntc.ctx, 2, ntc.args);
         }
         ntc.TU[l][j] = ntc.equationTerm;
      }
   }

   for(int l = 0; l < ntc.numRecurrentSetEqs; l++){
      ntc.equationTerm = ntc.zero;
      for(int i = 0; i < ntc.numVars; i++){
         ntc.args[0] = ntc.T[l][i];
         ntc.args[1] = ntc.u_rs[i];
         ntc.addTerm = Z3_mk_mul(ntc.ctx, 2, ntc.args);
         ntc.args[0] = ntc.equationTerm;
         ntc.args[1] = ntc.addTerm;
         ntc.equationTerm = Z3_mk_add(ntc.ctx, 2, ntc.args);
      }
      ntc.Tu[l] = ntc.equationTerm;
   }

   for(int l = 0; l < ntc.numRecurrentSetEqs; l++){
      for(int j = 0; j < ntc.numVars; j++){
         ntc.equationTerm = ntc.zero;
         for(int i = 0; i < ntc.numRecurrentSetEqs; i++){
            ntc.args[0] = ntc.lnt[l+ntc.guardCommandIndex][i];
            ntc.args[1] = ntc.T[i][j];
            ntc.addTerm = Z3_mk_mul(ntc.ctx, 2, ntc.args);
            ntc.args[0] = ntc.equationTerm;
            ntc.args[1] = ntc.addTerm;
            ntc.equationTerm = Z3_mk_add(ntc.ctx, 2, ntc.args);
         }
         ntc.assertTerm = Z3_mk_eq(ntc.ctx, ntc.equationTerm, ntc.TU[l][j]);
         Z3_solver_assert(ntc.ctx, ntc.s, ntc.assertTerm);
         myPrintf("\n (assert %s )\n", Z3_ast_to_string(ntc.ctx, ntc.assertTerm));
      }
   }

   for(int l = 0; l < ntc.numRecurrentSetEqs; l++){
      ntc.equationTerm = ntc.zero;
      for(int i = 0; i < ntc.numRecurrentSetEqs; i++){
            ntc.args[0] = ntc.lnt[l+ntc.guardCommandIndex][i];
            ntc.args[1] = ntc.t[i];
            ntc.addTerm = Z3_mk_mul(ntc.ctx, 2, ntc.args);
            ntc.args[0] = ntc.equationTerm;
            ntc.args[1] = ntc.addTerm;
            ntc.equationTerm = Z3_mk_add(ntc.ctx, 2, ntc.args);
      }
      Z3_ast subtractTerm;
      ntc.args[0] = ntc.t[l];
      ntc.args[1] = ntc.Tu[l];
      subtractTerm = Z3_mk_sub(ntc.ctx, 2, ntc.args);
      ntc.assertTerm = Z3_mk_le(ntc.ctx, ntc.equationTerm, subtractTerm);
      Z3_solver_assert(ntc.ctx, ntc.s, ntc.assertTerm);
      myPrintf("\n (assert %s )\n", Z3_ast_to_string(ntc.ctx, ntc.assertTerm));
   }
}

void getNTCModel(nonTerminationContext& ntc){
   unsigned num_constants;
   unsigned k;
   num_constants = Z3_model_get_num_consts(ntc.ctx, ntc.m);
   for (k = 0; k < num_constants; k++){
      Z3_symbol name;
      Z3_func_decl cnst = Z3_model_get_const_decl(ntc.ctx, ntc.m, k);
      Z3_ast a, v;
      Z3_bool ok;
      name = Z3_get_decl_name(ntc.ctx, cnst);
      if(Z3_get_symbol_kind(ntc.ctx, name) != Z3_STRING_SYMBOL){
         myPrintf(" Problem :: Different Symbol Found. ");
         exit(0);
      }
      char strName[STRBOUND];
      strcpy(strName, Z3_get_symbol_string(ntc.ctx, name));
      bool found = false;
      for(int i = 0; i < ntc.numRecurrentSetEqs; i++){
         for(int j = 0; j < ntc.numVars; j++){
            if(strcmp(Z3_ast_to_string(ntc.ctx, ntc.T[i][j]), strName) == 0){
               found = true;
               a = Z3_mk_app(ntc.ctx, cnst, 0, 0);
               v = a;
               ok = Z3_eval(ntc.ctx, ntc.m, a, &v);
               ntc.TModel[i][j] = atoi(Z3_get_numeral_string(ntc.ctx, v));
               break;
            }
         }
         if(found == true){
            break;
         }
      }
      if(found == true){
         continue;
      }
      for(int i = 0; i < ntc.numRecurrentSetEqs; i++){
         if(strcmp(Z3_ast_to_string(ntc.ctx, ntc.t[i]), strName) == 0){
            found = true;
            a = Z3_mk_app(ntc.ctx, cnst, 0, 0);
            v = a;
            ok = Z3_eval(ntc.ctx, ntc.m, a, &v);
            ntc.tModel[i] = atoi(Z3_get_numeral_string(ntc.ctx, v));
            break;
         }
      }
   }
}

void displayRecurrentSet(nonTerminationContext& ntc){
   if(crs_arg){
      printf("\nClosed Recurrent Set is");
   }
   else if(rs_arg){
      printf("\nRecurrent Set is");
   }
   for(int i = 0; i < ntc.numRecurrentSetEqs; i++){
      printf("\n");
      for(int j = 0; j < ntc.numVars; j++){
         if(ntc.TModel[i][j] == 0){
            continue;
         }
         printf("%d * %s + ", ntc.TModel[i][j], ntc.variableNames[j]);
      }
      printf(" <= %d", ntc.tModel[i]);
   }
   printf("\n");
}

int myPrintf(const char* format, ...){
   int i;
   if(p_arg){
      va_list args;
      va_start(args, format);
      i = vprintf(format, args);
      va_end(args);
   }
   return i;
}

void deleteDynamicMemoryOfTC(terminationContext& tc){
   for(int i = 0; i < tc.numVars; i++){
      delete[] tc.variableNames[i];
   }
   delete[] tc.variableNames;
   delete[] tc.guardVarsIndices;
   delete[] tc.varsNotInInvariants;
   delete[] tc.rankFunctionModel;
   for(int i = 0; i < MAX_INV_TEMPLATE_COUNT; i++){
      delete[] tc.inv[i];
      delete[] tc.invModel[i];
   }
   delete[] tc.inv;
   delete[] tc.invModel;

   for(int i = 0; i < tc.numEq; i++){
      delete[] tc.A_Int[i];
      delete[] tc.AP_Int[i];
   }
   delete[] tc.A_Int;
   delete[] tc.AP_Int;
   delete[] tc.b_Int;

   for(int i = 0; i < tc.numEq + MAX_INV_TEMPLATE_COUNT; i++){
      delete[] tc.A[i];
      delete[] tc.AP[i];
      delete[] tc.APModel[i];
   }
   delete[] tc.A;
   delete[] tc.AP;
   delete[] tc.APModel;
   delete[] tc.b;

   delete[] tc.l1;
   delete[] tc.l2;
   delete[] tc.l2Model;

   for(int i = 0; i < MAX_INV_TEMPLATE_COUNT; i++){
      delete[] tc.l3[i];
   }
   delete[] tc.l3;

   for(int i = 0; i < tc.numEqIC; i++){
      delete[] tc.initialCondition_Int[i];
      delete[] tc.initialCondition[i];
   }
   delete[] tc.initialCondition_Int;
   delete[] tc.initialCondition;

   for(int i = 0; i < MAX_INV_TEMPLATE_COUNT; i++){
      delete[] tc.l4[i];
   }
   delete[] tc.l4;
}

void deleteDynamicMemoryOfNTC_CRS(nonTerminationContext& ntc){
   for(int i = 0; i < ntc.numVars; i++){
      delete[] ntc.variableNames[i];
   }
   delete[] ntc.variableNames;
   
   delete[] ntc.vars;

   for(int i = 0; i < ntc.numEq; i++){
      delete[] ntc.G_Int[i];
      delete[] ntc.G[i];
      delete[] ntc.U_Int[i];
      delete[] ntc.UP_Int[i];
   }
   delete[] ntc.G_Int;
   delete[] ntc.G;
   delete[] ntc.g_Int;
   delete[] ntc.g;
   delete[] ntc.U_Int;
   delete[] ntc.UP_Int;
   delete[] ntc.u_Int;

   for(int i = 0; i < ntc.numEqIC; i++){
      delete[] ntc.initialCondition_Int[i];
      delete[] ntc.initialCondition[i];
   }
   delete[] ntc.initialCondition_Int;
   delete[] ntc.initialCondition;

   for(int i = 0; i < MAX_RECURRENT_TEMPLATE_COUNT; i++){
      delete[] ntc.T[i];
      delete[] ntc.TModel[i];
   }
   delete[] ntc.T;
   delete[] ntc.TModel;
   delete[] ntc.t;
   delete[] ntc.tModel;

   for(int i = 0; i < MAX_RECURRENT_TEMPLATE_COUNT + ntc.numEq; i++){
      delete[] ntc.A[i];
      delete[] ntc.AP[i];
   }
   delete[] ntc.A;
   delete[] ntc.AP;
   delete[] ntc.b;

   for(int i = 0; i < ntc.numEq + MAX_RECURRENT_TEMPLATE_COUNT; i++){
      delete[] ntc.lnt[i];
   }
   delete[] ntc.lnt;
}

void deleteDynamicMemoryOfNTC_RS(nonTerminationContext& ntc){
   for(int i = 0; i < ntc.numVars; i++){
      delete[] ntc.variableNames[i];
   }
   delete[] ntc.variableNames;
   
   delete[] ntc.vars;

   for(int i = 0; i < ntc.numEq; i++){
      delete[] ntc.G_Int[i];
      delete[] ntc.G[i];
   }

   delete[] ntc.G_Int;
   delete[] ntc.G;
   delete[] ntc.g_Int;
   delete[] ntc.g;

   for(int i = 0; i < ntc.numVars; i++){
      delete[] ntc.U_rs_Int[i];
      delete[] ntc.U_rs[i];
   }
   delete[] ntc.U_rs_Int;
   delete[] ntc.u_rs_Int;
   delete[] ntc.U_rs;
   delete[] ntc.u_rs;

   for(int i = 0; i < ntc.numEqIC; i++){
      delete[] ntc.initialCondition_Int[i];
      delete[] ntc.initialCondition[i];
   }
   delete[] ntc.initialCondition_Int;
   delete[] ntc.initialCondition;

   for(int i = 0; i < MAX_RECURRENT_TEMPLATE_COUNT; i++){
      delete[] ntc.T[i];
      delete[] ntc.TModel[i];
   }
   delete[] ntc.T;
   delete[] ntc.TModel;
   delete[] ntc.t;
   delete[] ntc.tModel;

   for(int i = 0; i < MAX_RECURRENT_TEMPLATE_COUNT; i++){
      delete[] ntc.TU[i];
   }
   delete[] ntc.TU;
   delete[] ntc.Tu;

   for(int i = 0; i < ntc.numEq + MAX_RECURRENT_TEMPLATE_COUNT; i++){
      delete[] ntc.lnt[i];
   }
   delete[] ntc.lnt;
}

void mytest(){
   Z3_ast a;
   Z3_ast b;
   Z3_context ctx;
   Z3_ast zero;

   ctx = mk_context();
   zero = mk_int(ctx, 0);
   Z3_ast one = mk_int(ctx, 1);

   Z3_sort int_sort    = Z3_mk_int_sort(ctx);
   a = Z3_mk_const(ctx, Z3_mk_string_symbol(ctx, "a_name"), int_sort);
   //b = Z3_mk_const(ctx, Z3_mk_string_symbol(ctx, "b_name"), int_sort);
   b = a;
   Z3_ast assertTerm1 = Z3_mk_eq(ctx, a, zero);
   Z3_assert_cnstr(ctx, assertTerm1);
   myPrintf("\n adding constraint %s\n", Z3_ast_to_string(ctx, assertTerm1));
   Z3_ast assertTerm2 = Z3_mk_eq(ctx, b, one);
   Z3_assert_cnstr(ctx, assertTerm2);
   myPrintf("\n adding constraint %s\n", Z3_ast_to_string(ctx, assertTerm2));
   check2(ctx, Z3_L_TRUE);
}

void tst_quantifier2() {
   context ctx;
   expr x1 = ctx.int_const("x1"); 
   expr y1 = ctx.int_const("y1"); 
   expr z = ctx.int_const("z"); 
   expr sub_expr = (z == x1 + 1) && (x1 == y1 + 1) && (y1 >= 1);
   Z3_app vars[] = {(Z3_app) x1, (Z3_app) y1};

   expr qf = to_expr(ctx, Z3_mk_exists_const(ctx, 0, 2, vars,
            0, 0, // patterns don't seem to make sense here.
            sub_expr)); //No C++ API for quantifiers :(
   tactic qe(ctx, "qe");
   goal g(ctx);
   g.add(qf);
   std::cout << qe.apply(g);
}

void tst_quantifier3() {
   context ctx;
   expr x1 = ctx.int_const("x1"); 
   expr y1 = ctx.int_const("y1"); 
   expr x2 = ctx.int_const("x2"); 
   expr sub_expr = (x2 == x1 + 3) && (2 * x1 >= y1);
   Z3_app vars[] = {(Z3_app) x1};

   expr qf = to_expr(ctx, Z3_mk_exists_const(ctx, 0, 1, vars,
            0, 0, // patterns don't seem to make sense here.
            sub_expr)); //No C++ API for quantifiers :(
   tactic qe(ctx, "qe");
   goal g(ctx);
   g.add(qf);
   std::cout << qe.apply(g);
}

int main(int argc, char* argv[]){
   std::cout<<"\nRunning Anant:\n";
   for(int i = 1; i < argc; i++){
      if(strcmp(argv[i], "-p") == 0){
         p_arg = true;
      }
      else if(strcmp(argv[i], "-tsize") == 0){
         tsize = atoi(argv[i+1]);
         assert(tsize >= 0);
         assert(tsize <= MAX_RECURRENT_TEMPLATE_COUNT);
         i++;
      }
      else if(strcmp(argv[i], "-nt") == 0){
         only_non_term_proof = true;
      }
      else if(strcmp(argv[i], "-rs") == 0){
         rs_arg = true;
      }
      else if(strcmp(argv[i], "-crs") == 0){
         crs_arg = true;
      }
      else if(strcmp(argv[i], "-timeout") == 0){
         timeout = unsigned(atoi(argv[i+1]));
         assert(timeout > 0);
         i++;
      }
   }
#ifdef LOG_Z3_CALLS
    Z3_open_log("z3.log");
#endif
    terminationInvariant();
    //tst_quantifier3();
    //mytest();
    return 0;
}
