import sys
from lexerFormula import lexer_main
from lexerFormula import *


def p_bool_expression_EQconstraint(p):
    '''boolexpression : EQconstraint'''
    p[0] = p[1]


def p_bool_expression_constraint(p):
    '''boolexpression : constraint'''
    p[0] = [p[1]]


def p_bool_expression_notconstraint(p):
    '''boolexpression : NOT constraint'''
    constraint = {}
    for key in p[2].keys():
        if key == 'rhsConstant':
            constraint[key] = -p[2][key] - 1
        else:
            constraint[key] = -p[2][key]
    p[0] = [constraint]


def p_constraint_1(p):
    '''EQconstraint : expression EQ expression '''
    constraint = {}
    rhsConstantFound = False
    constraint['rhsConstant'] = 0
    for key in p[1].keys():
        if key == 'rhsConstant':
            rhsConstantFound = True
            constraint[key] = -p[1][key]
        else:
            constraint[key] = p[1][key]
    for key in p[3].keys():
        if key == 'rhsConstant':
            assert (rhsConstantFound is False)
            constraint[key] = p[3][key]
            rhsConstantFound = True
        else:
            constraint[key] = -p[3][key]
    constraint2 = constraint.copy()
    for key in constraint2.keys():
        constraint2[key] = -constraint2[key]
    p[0] = [constraint, constraint2]


def p_constraint_2(p):
    '''constraint : expression LE expression '''
    constraint = {}
    rhsConstantFound = False
    constraint['rhsConstant'] = 0
    for key in p[1].keys():
        if key == 'rhsConstant':
            rhsConstantFound = True
            constraint[key] = -p[1][key]
        else:
            constraint[key] = p[1][key]
    for key in p[3].keys():
        if key == 'rhsConstant':
            assert (rhsConstantFound is False)
            constraint[key] = p[3][key]
            rhsConstantFound = True
        else:
            constraint[key] = -p[3][key]

    p[0] = constraint


def p_constraint_3(p):
    '''constraint : expression GE expression '''
    constraint = {}
    rhsConstantFound = False
    constraint['rhsConstant'] = 0
    for key in p[1].keys():
        if key == 'rhsConstant':
            rhsConstantFound = True
            constraint[key] = p[1][key]
        else:
            constraint[key] = -p[1][key]
    for key in p[3].keys():
        if key == 'rhsConstant':
            assert (rhsConstantFound is False)
            constraint[key] = -p[3][key]
            rhsConstantFound = True
        else:
            constraint[key] = p[3][key]

    p[0] = constraint


def p_constraint_4(p):
    '''constraint : expression LT expression '''
    constraint = {}
    rhsConstantFound = False
    constraint['rhsConstant'] = -1
    for key in p[1].keys():
        if key == 'rhsConstant':
            rhsConstantFound = True
            constraint[key] = -p[1][key] - 1
        else:
            constraint[key] = p[1][key]
    for key in p[3].keys():
        if key == 'rhsConstant':
            assert (rhsConstantFound is False)
            constraint[key] = p[3][key] - 1
            rhsConstantFound = True
        else:
            constraint[key] = -p[3][key]

    p[0] = constraint


def p_constraint_5(p):
    '''constraint : expression GT expression '''
    constraint = {}
    rhsConstantFound = False
    constraint['rhsConstant'] = -1
    for key in p[1].keys():
        if key == 'rhsConstant':
            rhsConstantFound = True
            constraint[key] = p[1][key] - 1
        else:
            constraint[key] = -p[1][key]
    for key in p[3].keys():
        if key == 'rhsConstant':
            assert (rhsConstantFound is False)
            constraint[key] = -p[3][key] - 1
            rhsConstantFound = True
        else:
            constraint[key] = p[3][key]

    p[0] = constraint


def p_constraint_6(p):
    "constraint : '(' constraint ')'"
    p[0] = p[2]


def p_constraint_true(p):
    '''constraint : TRUE '''
    p[0] = {}


def p_expression_binop(p):
    "expression : expression '+' expression"
    # With simplify() in Z3 we do not have x - y, we always have x + -1*y

    exp = {}
    for key in p[1].keys():
        exp[key] = p[1][key]
    for key in p[3].keys():
        if key in exp.keys():
            print("key already present in the expression")
            sys.exit()
        exp[key] = p[3][key]
    p[0] = exp


def p_expression_coef_var(p):
    "expression : NUMBER '*' NAME"
    exp = {}
    exp[p[3]] = p[1]
    p[0] = exp


def p_expression_var_mul_var(p):
    "expression : NAME '*' NAME"
    exp = {}
    e_key = p[1] + '*' + p[3]
    exp[e_key] = 1
    p[0] = exp


def p_expression_num_mul_var_mul_var(p):
    "expression : NUMBER '*' NAME '*' NAME"
    exp = {}
    e_key = p[3] + '*' + p[5]
    exp[e_key] = p[1]
    p[0] = exp


def p_expression_var_div_var(p):
    "expression : NAME '/' NAME"
    exp = {}
    e_key = p[1] + '/' + p[3]
    exp[e_key] = 1
    p[0] = exp


def p_expression_num_mul_var_div_var(p):
    "expression : NUMBER '*' NAME '/' NAME"
    exp = {}
    e_key = p[3] + '/' + p[5]
    exp[e_key] = p[1]
    p[0] = exp


def p_expression_num_mul_var_div_var_paranthesis(p):
    "expression : NUMBER '*' '(' NAME '/' NAME ')' "
    exp = {}
    e_key = p[4] + '/' + p[6]
    exp[e_key] = p[1]
    p[0] = exp


def p_expression_var(p):
    "expression : NAME"
    exp = {}
    exp[p[1]] = 1
    p[0] = exp


def p_expression_constant(p):
    "expression : NUMBER"
    exp = {}
    exp['rhsConstant'] = p[1]
    p[0] = exp


def p_expression_uminus(p):
    "expression : '-' expression %prec UMINUS"
    exp = {}
    assert (len(p[2]) == 1)
    for key in p[2].keys():
        exp[key] = -p[2][key]
    p[0] = exp
    # print("Invoked UNaryMINUS")


def p_expression_group(p):
    "expression : '(' expression ')'"
    p[0] = p[2]


def p_error(p):
    import pdb
    pdb.set_trace()
    print("Error while Parsing Formula")
    if p:
        print("Syntax error at '%s': line= %d" % (p.value, p.lineno))
    else:
        print("Syntax error at EOF")
    sys.exit()


def parserFormula_main():
    import ply.yacc as yacc
    fLexer = lexer_main()
    fParser = yacc.yacc(debug=0, write_tables=0)
    return fParser
