reserved = {'Not': 'NOT', 'True': 'TRUE'}

tokens = [
    'NAME',
    'NUMBER',
    'EQ',
    'LE',
    'GE',
    'LT',
    'GT',
    # 'ASSIGN'
] + list(reserved.values())

# literals = ['+','-','*','/', '(',')', ';', ',', ':', '=']
literals = ['+', '-', '*', '/', '(', ')', ';', ',', ':', '=']

# Tokens


def t_NAME(t):
    r'[a-zA-Z_][a-zA-Z0-9_]*'
    t.type = reserved.get(t.value, 'NAME')
    return t


t_EQ = r'=='
t_LE = r'<='
t_GE = r'>='
t_LT = r'<'
t_GT = r'>'
# t_ASSIGN = r':='


def t_NUMBER(t):
    r'\d+'
    t.value = int(t.value)
    return t


t_ignore = " \t"


def t_newline(t):
    r'\n+'
    t.lexer.lineno += t.value.count("\n")


def t_error(t):
    print("Illegal character '%s'" % t.value[0])
    t.lexer.skip(1)


# Parsing rules

precedence = (
    ('left', '+', '-'),
    ('left', '*'),
    ('right', 'UMINUS'),
)


def lexer_main():
    import ply.lex as lex
    lexer = lex.lex()
    return lexer
