from find_composition import find_composition
from automata_composition import AGAutomaton
from utils import symb_next

from pysmt.shortcuts import Symbol, TRUE, Int, Real, ToReal
from pysmt.shortcuts import And
from pysmt.shortcuts import GT, GE, Equals, LE, LT
from pysmt.shortcuts import Plus, Minus, Times, Div
from pysmt.typing import INT, REAL


def test(nuxmv_path: str, model_file: str, trace_file: str, cmd_file: str,
         output_file: str) -> bool:
    # example 3 of document.
    c = Symbol("c", REAL)
    d = Symbol("d", INT)
    x_c = Symbol(symb_next("c"), REAL)
    x_d = Symbol(symb_next("d"), INT)
    symbols = [c, d]

    # constant
    d_r = ToReal(d)
    x_d_r = ToReal(x_d)
    zero_i = Int(0)
    zero_r = Real(0)
    one_r = Real(1)
    two_r = Real(2)
    one_div_eight = Div(one_r, Real(8))
    one_div_ten = Div(one_r, Real(10))
    dot_0251 = Div(Real(251), Real(10000))

    # initial condition
    init = And(GT(c, zero_r), GT(d, zero_i))

    # transition relation
    c_low = Plus(Minus(Times(two_r, c, c, c, c), c), one_div_eight)
    d_low = Minus(Times(d_r, d_r), c)
    d_up = Minus(Times(d_r, d_r, d_r), c)
    trans = And(GE(x_c, c_low), GT(x_d_r, d_low), LE(x_d_r, d_up))

    # fairness
    fairness = LE(c, d_r)

    # define automata to be composed
    aut_C = AGAutomaton(symbols, [c], "Aut_C", 1)
    aut_C.set_invar(0, And(GT(c, dot_0251), LT(c, one_div_ten)))
    aut_C.set_assume(0, TRUE())
    aut_C.set_transitions(0, [(0, [Equals(x_c, c_low), Equals(x_c, c)])])

    aut_D = AGAutomaton(symbols, [d], "Aut_D", 1)
    aut_D.set_invar(0, GE(d, Int(2)))
    aut_D.set_assume(0, And(LT(dot_0251, c), LT(c, one_div_ten)))
    aut_D.set_transitions(0, [(0, [Equals(x_d, d), GT(x_d_r, d_up),
                                   And(GT(x_d_r, d_low),
                                       LE(x_d_r, d_up))])])

    comp, undefs = find_composition([aut_C, aut_D], init, trans, fairness,
                                    nuxmv_path, model_file, trace_file,
                                    cmd_file)
    if comp is not None:
        with open(output_file, 'w') as out:
            out.write(str(comp))

    if comp and not undefs:
        res = True
    elif not comp:
        res = False
    else:
        assert comp and undefs, "{}, {}".format(comp, undefs)
        res = None
    return res
