from find_composition import find_composition
from automata_composition import AGAutomaton
from utils import symb_next

from pysmt.shortcuts import Symbol, TRUE, Int
from pysmt.shortcuts import Not, And, Or, Implies
from pysmt.shortcuts import GE, Equals, LT
from pysmt.shortcuts import Minus, Times, Div
from pysmt.typing import INT


def test(nuxmv_path: str, model_file: str, trace_file: str, cmd_file: str,
         output_file: str) -> bool:
    """Test corresponding to benchmarks/nCr_combinations.smv"""
    # symbols.
    den = Symbol("den", INT)
    dmul = Symbol("dmul", INT)
    nCr = Symbol("nCr", INT)
    n_num = Symbol("n_num", INT)
    nmul = Symbol("nmul", INT)
    num = Symbol("num", INT)
    pc = Symbol("pc", INT)
    r_num = Symbol("r_num", INT)
    x_den = Symbol(symb_next("den"), INT)
    x_dmul = Symbol(symb_next("dmul"), INT)
    x_nCr = Symbol(symb_next("nCr"), INT)
    x_n_num = Symbol(symb_next("n_num"), INT)
    x_nmul = Symbol(symb_next("nmul"), INT)
    x_num = Symbol(symb_next("num"), INT)
    x_pc = Symbol(symb_next("pc"), INT)
    x_r_num = Symbol(symb_next("r_num"), INT)
    symbols = [den, dmul, nCr, n_num, nmul, num, pc, r_num]

    # initial location.
    init = Equals(pc, Int(0))

    # control flow graph.
    cfg = And(
        # pc = -1 : -1,
        Implies(Equals(pc, Int(-1)), Equals(x_pc, Int(-1))),
        # pc = 0 & !(n_num >= 1) : -1,
        Implies(And(Equals(pc, Int(0)), Not(GE(n_num, Int(1)))),
                Equals(x_pc, Int(-1))),
        # pc = 0 & n_num >= 1 : 1,
        Implies(And(Equals(pc, Int(0)), GE(n_num, Int(1))),
                Equals(x_pc, Int(1))),
        # pc = 1 : 2,
        Implies(Equals(pc, Int(1)), Equals(x_pc, Int(2))),
        # pc = 2 : 3,
        Implies(Equals(pc, Int(2)), Equals(x_pc, Int(3))),
        # pc = 3 : 4,
        Implies(Equals(pc, Int(3)), Equals(x_pc, Int(4))),
        # pc = 4 : 5,
        Implies(Equals(pc, Int(4)), Equals(x_pc, Int(5))),
        # pc = 5 : 6,
        Implies(Equals(pc, Int(5)), Equals(x_pc, Int(6))),
        # pc = 6 & n_num >= r_num : 7,
        Implies(And(Equals(pc, Int(6)), GE(n_num, r_num)),
                Equals(x_pc, Int(7))),
        # pc = 6 & !(n_num >= r_num) : 24,
        Implies(And(Equals(pc, Int(6)), Not(GE(n_num, r_num))),
                Equals(x_pc, Int(24))),
        # pc = 7 : {8, 11},
        Implies(Equals(pc, Int(7)),
                Or(Equals(x_pc, Int(8)), Equals(x_pc, Int(11)))),
        # pc = 8 & !(num < 1) : -1,
        Implies(And(Equals(pc, Int(8)), Not(LT(num, Int(1)))),
                Equals(x_pc, Int(-1))),
        # pc = 8 & num < 1 : 9,
        Implies(And(Equals(pc, Int(8)), LT(num, Int(1))),
                Equals(x_pc, Int(9))),
        # pc = 9 : 10,
        Implies(Equals(pc, Int(9)), Equals(x_pc, Int(10))),
        # pc = 10 : -1,
        Implies(Equals(pc, Int(10)), Equals(x_pc, Int(-1))),
        # pc = 11 & !(nCr >= 1) : 20,
        Implies(And(Equals(pc, Int(11)), Not(GE(nCr, Int(1)))),
                Equals(x_pc, Int(20))),
        # pc = 11 & nCr >= 1 : 12,
        Implies(And(Equals(pc, Int(11)), GE(nCr, Int(1))),
                Equals(x_pc, Int(12))),
        # pc = 12 : {13, 16},
        Implies(Equals(pc, Int(12)),
                Or(Equals(x_pc, Int(13)), Equals(x_pc, Int(16)))),
        # pc = 13 & !(num < 1) : -1,
        Implies(And(Equals(pc, Int(13)), Not(LT(num, Int(1)))),
                Equals(x_pc, Int(-1))),
        # pc = 13 & num < 1 : 14,
        Implies(And(Equals(pc, Int(13)), LT(num, Int(1))),
                Equals(x_pc, Int(14))),
        # pc = 14 : 15,
        Implies(Equals(pc, Int(14)), Equals(x_pc, Int(15))),
        # pc = 15 : -1,
        Implies(Equals(pc, Int(15)), Equals(x_pc, Int(-1))),
        # pc = 16 : 17,
        Implies(Equals(pc, Int(16)), Equals(x_pc, Int(17))),
        # pc = 17 : 18,
        Implies(Equals(pc, Int(17)), Equals(x_pc, Int(18))),
        # pc = 18 : 19,
        Implies(Equals(pc, Int(18)), Equals(x_pc, Int(19))),
        # pc = 19 : 11,
        Implies(Equals(pc, Int(19)), Equals(x_pc, Int(11))),
        # pc = 20 : {-1, 21},
        Implies(Equals(pc, Int(20)),
                Or(Equals(x_pc, Int(-1)), Equals(x_pc, Int(21)))),
        # pc = 21 & !(num < 1) : -1,
        Implies(And(Equals(pc, Int(21)), Not(LT(num, Int(1)))),
                Equals(x_pc, Int(-1))),
        # pc = 21 & num < 1 : 22,
        Implies(And(Equals(pc, Int(21)), LT(num, Int(1))),
                Equals(x_pc, Int(22))),
        # pc = 22 : 23,
        Implies(Equals(pc, Int(22)), Equals(x_pc, Int(23))),
        # pc = 23 : -1,
        Implies(Equals(pc, Int(23)), Equals(x_pc, Int(-1))),
        # pc = 24 : -1,
        Implies(Equals(pc, Int(24)), Equals(x_pc, Int(-1)))
    )

    # transition labels.
    labels = And(
        # (pc = -1 & pc' = -1) -> (n_num' = n_num & num' = num & den' = den & nmul' = nmul & dmul' = dmul & r_num' = r_num & nCr' = nCr),
        Implies(And(Equals(pc, Int(-1)), Equals(x_pc, Int(-1))),
                And(Equals(x_n_num, n_num), Equals(x_num, num),
                    Equals(x_den, den), Equals(x_nmul, nmul),
                    Equals(x_dmul, dmul), Equals(x_r_num, r_num),
                    Equals(x_nCr, nCr))),
        # (pc = 0 & pc' = -1)  -> (n_num' = n_num & num' = num & den' = den & nmul' = nmul & dmul' = dmul & r_num' = r_num & nCr' = nCr),
        Implies(And(Equals(pc, Int(0)), Equals(x_pc, Int(-1))),
                And(Equals(x_n_num, n_num), Equals(x_num, num),
                    Equals(x_den, den), Equals(x_nmul, nmul),
                    Equals(x_dmul, dmul), Equals(x_r_num, r_num),
                    Equals(x_nCr, nCr))),
        # (pc = 0 & pc' = 1)   -> (n_num' = n_num & num' = num & den' = den & nmul' = nmul & dmul' = dmul & r_num' = r_num & nCr' = nCr),
        Implies(And(Equals(pc, Int(0)), Equals(x_pc, Int(1))),
                And(Equals(x_n_num, n_num), Equals(x_num, num),
                    Equals(x_den, den), Equals(x_nmul, nmul),
                    Equals(x_dmul, dmul), Equals(x_r_num, r_num),
                    Equals(x_nCr, nCr))),
        # (pc = 1 & pc' = 2)   -> (n_num' = n_num & num' = 1 & den' = den & nmul' = nmul & dmul' = dmul & r_num' = r_num & nCr' = nCr),
        Implies(And(Equals(pc, Int(1)), Equals(x_pc, Int(2))),
                And(Equals(x_n_num, n_num), Equals(x_num, Int(1)),
                    Equals(x_den, den), Equals(x_nmul, nmul),
                    Equals(x_dmul, dmul), Equals(x_r_num, r_num),
                    Equals(x_nCr, nCr))),
        # (pc = 2 & pc' = 3)   -> (n_num' = n_num & num' = num & den' = 1 & nmul' = nmul & dmul' = dmul & r_num' = r_num & nCr' = nCr),
        Implies(And(Equals(pc, Int(2)), Equals(x_pc, Int(3))),
                And(Equals(x_n_num, n_num), Equals(x_num, num),
                    Equals(x_den, Int(1)), Equals(x_nmul, nmul),
                    Equals(x_dmul, dmul), Equals(x_r_num, r_num),
                    Equals(x_nCr, nCr))),
        # (pc = 3 & pc' = 4)   -> (n_num' = n_num & num' = num & den' = den & nmul' = n_num & dmul' = dmul & r_num' = r_num & nCr' = nCr),
        Implies(And(Equals(pc, Int(3)), Equals(x_pc, Int(4))),
                And(Equals(x_n_num, n_num), Equals(x_num, num),
                    Equals(x_den, den), Equals(x_nmul, n_num),
                    Equals(x_dmul, dmul), Equals(x_r_num, r_num),
                    Equals(x_nCr, nCr))),
        # (pc = 4 & pc' = 5)   -> (n_num' = n_num & num' = num & den' = den & nmul' = nmul & dmul' = r_num & r_num' = r_num & nCr' = nCr),
        Implies(And(Equals(pc, Int(4)), Equals(x_pc, Int(5))),
                And(Equals(x_n_num, n_num), Equals(x_num, num),
                    Equals(x_den, den), Equals(x_nmul, nmul),
                    Equals(x_dmul, r_num), Equals(x_r_num, r_num),
                    Equals(x_nCr, nCr))),
        # (pc = 5 & pc' = 6)   -> (n_num' = n_num & num' = num & den' = den & nmul' = nmul & dmul' = dmul & r_num' = r_num & nCr' = 1),
        Implies(And(Equals(pc, Int(5)), Equals(x_pc, Int(6))),
                And(Equals(x_n_num, n_num), Equals(x_num, num),
                    Equals(x_den, den), Equals(x_nmul, nmul),
                    Equals(x_dmul, dmul), Equals(x_r_num, r_num),
                    Equals(x_nCr, Int(1)))),
        # (pc = 6 & pc' = 7)   -> (n_num' = n_num & num' = num & den' = den & nmul' = nmul & dmul' = dmul & r_num' = r_num & nCr' = nCr),
        Implies(And(Equals(pc, Int(6)), Equals(x_pc, Int(7))),
                And(Equals(x_n_num, n_num), Equals(x_num, num),
                    Equals(x_den, den), Equals(x_nmul, nmul),
                    Equals(x_dmul, dmul), Equals(x_r_num, r_num),
                    Equals(x_nCr, nCr))),
        # (pc = 6 & pc' = 24)  -> (n_num' = n_num & num' = num & den' = den & nmul' = nmul & dmul' = dmul & r_num' = r_num & nCr' = nCr),
        Implies(And(Equals(pc, Int(6)), Equals(x_pc, Int(24))),
                And(Equals(x_n_num, n_num), Equals(x_num, num),
                    Equals(x_den, den), Equals(x_nmul, nmul),
                    Equals(x_dmul, dmul), Equals(x_r_num, r_num),
                    Equals(x_nCr, nCr))),
        # (pc = 7 & pc' = 8)   -> (n_num' = n_num & num' = num & den' = den & nmul' = nmul & dmul' = dmul & r_num' = r_num & nCr' = nCr),
        Implies(And(Equals(pc, Int(7)), Equals(x_pc, Int(8))),
                And(Equals(x_n_num, n_num), Equals(x_num, num),
                    Equals(x_den, den), Equals(x_nmul, nmul),
                    Equals(x_dmul, dmul), Equals(x_r_num, r_num),
                    Equals(x_nCr, nCr))),
        # (pc = 7 & pc' = 11)  -> (n_num' = n_num & num' = num & den' = den & nmul' = nmul & dmul' = dmul & r_num' = r_num & nCr' = nCr),
        Implies(And(Equals(pc, Int(7)), Equals(x_pc, Int(11))),
                And(Equals(x_n_num, n_num), Equals(x_num, num),
                    Equals(x_den, den), Equals(x_nmul, nmul),
                    Equals(x_dmul, dmul), Equals(x_r_num, r_num),
                    Equals(x_nCr, nCr))),
        # (pc = 8 & pc' = -1)  -> (n_num' = n_num & num' = num & den' = den & nmul' = nmul & dmul' = dmul & r_num' = r_num & nCr' = nCr),
        Implies(And(Equals(pc, Int(8)), Equals(x_pc, Int(-1))),
                And(Equals(x_n_num, n_num), Equals(x_num, num),
                    Equals(x_den, den), Equals(x_nmul, nmul),
                    Equals(x_dmul, dmul), Equals(x_r_num, r_num),
                    Equals(x_nCr, nCr))),
        # (pc = 8 & pc' = 9)   -> (n_num' = n_num & num' = num & den' = den & nmul' = nmul & dmul' = dmul & r_num' = r_num & nCr' = nCr),
        Implies(And(Equals(pc, Int(8)), Equals(x_pc, Int(9))),
                And(Equals(x_n_num, n_num), Equals(x_num, num),
                    Equals(x_den, den), Equals(x_nmul, nmul),
                    Equals(x_dmul, dmul), Equals(x_r_num, r_num),
                    Equals(x_nCr, nCr))),
        # (pc = 9 & pc' = 10)  -> (n_num' = n_num & num' = num & den' = den & nmul' = nmul & dmul' = dmul & r_num' = r_num & nCr' = num/den),
        Implies(And(Equals(pc, Int(9)), Equals(x_pc, Int(10))),
                And(Equals(x_n_num, n_num), Equals(x_num, num),
                    Equals(x_den, den), Equals(x_nmul, nmul),
                    Equals(x_dmul, dmul), Equals(x_r_num, r_num),
                    Equals(x_nCr, Div(num, den)))),
        # (pc = 10 & pc' = -1) -> (n_num' = n_num & num' = num & den' = den & nmul' = nmul & dmul' = dmul & r_num' = r_num & nCr' = nCr),
        Implies(And(Equals(pc, Int(10)), Equals(x_pc, Int(-1))),
                And(Equals(x_n_num, n_num), Equals(x_num, num),
                    Equals(x_den, den), Equals(x_nmul, nmul),
                    Equals(x_dmul, dmul), Equals(x_r_num, r_num),
                    Equals(x_nCr, nCr))),
        # (pc = 11 & pc' = 20) -> (n_num' = n_num & num' = num & den' = den & nmul' = nmul & dmul' = dmul & r_num' = r_num & nCr' = nCr),
        Implies(And(Equals(pc, Int(11)), Equals(x_pc, Int(20))),
                And(Equals(x_n_num, n_num), Equals(x_num, num),
                    Equals(x_den, den), Equals(x_nmul, nmul),
                    Equals(x_dmul, dmul), Equals(x_r_num, r_num),
                    Equals(x_nCr, nCr))),
        # (pc = 11 & pc' = 12) -> (n_num' = n_num & num' = num & den' = den & nmul' = nmul & dmul' = dmul & r_num' = r_num & nCr' = nCr),
        Implies(And(Equals(pc, Int(11)), Equals(x_pc, Int(12))),
                And(Equals(x_n_num, n_num), Equals(x_num, num),
                    Equals(x_den, den), Equals(x_nmul, nmul),
                    Equals(x_dmul, dmul), Equals(x_r_num, r_num),
                    Equals(x_nCr, nCr))),
        # (pc = 12 & pc' = 13) -> (n_num' = n_num & num' = num & den' = den & nmul' = nmul & dmul' = dmul & r_num' = r_num & nCr' = nCr),
        Implies(And(Equals(pc, Int(12)), Equals(x_pc, Int(13))),
                And(Equals(x_n_num, n_num), Equals(x_num, num),
                    Equals(x_den, den), Equals(x_nmul, nmul),
                    Equals(x_dmul, dmul), Equals(x_r_num, r_num),
                    Equals(x_nCr, nCr))),
        # (pc = 12 & pc' = 16) -> (n_num' = n_num & num' = num & den' = den & nmul' = nmul & dmul' = dmul & r_num' = r_num & nCr' = nCr),
        Implies(And(Equals(pc, Int(12)), Equals(x_pc, Int(16))),
                And(Equals(x_n_num, n_num), Equals(x_num, num),
                    Equals(x_den, den), Equals(x_nmul, nmul),
                    Equals(x_dmul, dmul), Equals(x_r_num, r_num),
                    Equals(x_nCr, nCr))),
        # (pc = 13 & pc' = -1) -> (n_num' = n_num & num' = num & den' = den & nmul' = nmul & dmul' = dmul & r_num' = r_num & nCr' = nCr),
        Implies(And(Equals(pc, Int(13)), Equals(x_pc, Int(-1))),
                And(Equals(x_n_num, n_num), Equals(x_num, num),
                    Equals(x_den, den), Equals(x_nmul, nmul),
                    Equals(x_dmul, dmul), Equals(x_r_num, r_num),
                    Equals(x_nCr, nCr))),
        # (pc = 13 & pc' = 14) -> (n_num' = n_num & num' = num & den' = den & nmul' = nmul & dmul' = dmul & r_num' = r_num & nCr' = nCr),
        Implies(And(Equals(pc, Int(13)), Equals(x_pc, Int(14))),
                And(Equals(x_n_num, n_num), Equals(x_num, num),
                    Equals(x_den, den), Equals(x_nmul, nmul),
                    Equals(x_dmul, dmul), Equals(x_r_num, r_num),
                    Equals(x_nCr, nCr))),
        # (pc = 14 & pc' = 15) -> (n_num' = n_num & num' = num & den' = den & nmul' = nmul & dmul' = dmul & r_num' = r_num & nCr' = num/den),
        Implies(And(Equals(pc, Int(14)), Equals(x_pc, Int(15))),
                And(Equals(x_n_num, n_num), Equals(x_num, num),
                    Equals(x_den, den), Equals(x_nmul, nmul),
                    Equals(x_dmul, dmul), Equals(x_r_num, r_num),
                    Equals(x_nCr, Div(num, den)))),
        # (pc = 15 & pc' = -1) -> (n_num' = n_num & num' = num & den' = den & nmul' = nmul & dmul' = dmul & r_num' = r_num & nCr' = nCr),
        Implies(And(Equals(pc, Int(15)), Equals(x_pc, Int(-1))),
                And(Equals(x_n_num, n_num), Equals(x_num, num),
                    Equals(x_den, den), Equals(x_nmul, nmul),
                    Equals(x_dmul, dmul), Equals(x_r_num, r_num),
                    Equals(x_nCr, nCr))),
        # (pc = 16 & pc' = 17) -> (n_num' = n_num & num' = num*nmul & den' = den & nmul' = nmul & dmul' = dmul & r_num' = r_num & nCr' = nCr),
        Implies(And(Equals(pc, Int(16)), Equals(x_pc, Int(17))),
                And(Equals(x_n_num, n_num), Equals(x_num, Times(num, nmul)),
                    Equals(x_den, den), Equals(x_nmul, nmul),
                    Equals(x_dmul, dmul), Equals(x_r_num, r_num),
                    Equals(x_nCr, nCr))),
        # (pc = 17 & pc' = 18) -> (n_num' = n_num & num' = num & den' = den & nmul' = nmul-1 & dmul' = dmul & r_num' = r_num & nCr' = nCr),
        Implies(And(Equals(pc, Int(17)), Equals(x_pc, Int(18))),
                And(Equals(x_n_num, n_num), Equals(x_num, num),
                    Equals(x_den, den),
                    Equals(x_nmul, Minus(nmul, Int(1))),
                    Equals(x_dmul, dmul), Equals(x_r_num, r_num),
                    Equals(x_nCr, nCr))),
        # (pc = 18 & pc' = 19) -> (n_num' = n_num & num' = num & den' = den*dmul & nmul' = nmul & dmul' = dmul & r_num' = r_num & nCr' = nCr),
        Implies(And(Equals(pc, Int(18)), Equals(x_pc, Int(19))),
                And(Equals(x_n_num, n_num), Equals(x_num, num),
                    Equals(x_den, Times(den, dmul)), Equals(x_nmul, nmul),
                    Equals(x_dmul, dmul), Equals(x_r_num, r_num),
                    Equals(x_nCr, nCr))),
        # (pc = 19 & pc' = 11) -> (n_num' = n_num & num' = num & den' = den & nmul' = nmul & dmul' = dmul-1 & r_num' = r_num & nCr' = nCr),
        Implies(And(Equals(pc, Int(19)), Equals(x_pc, Int(11))),
                And(Equals(x_n_num, n_num), Equals(x_num, num),
                    Equals(x_den, den), Equals(x_nmul, nmul),
                    Equals(x_dmul, Minus(dmul, Int(1))),
                    Equals(x_r_num, r_num), Equals(x_nCr, nCr))),
        # (pc = 20 & pc' = -1) -> (n_num' = n_num & num' = num & den' = den & nmul' = nmul & dmul' = dmul & r_num' = r_num & nCr' = nCr),
        Implies(And(Equals(pc, Int(20)), Equals(x_pc, Int(-1))),
                And(Equals(x_n_num, n_num), Equals(x_num, num),
                    Equals(x_den, den), Equals(x_nmul, nmul),
                    Equals(x_dmul, dmul), Equals(x_r_num, r_num),
                    Equals(x_nCr, nCr))),
        # (pc = 20 & pc' = 21) -> (n_num' = n_num & num' = num & den' = den & nmul' = nmul & dmul' = dmul & r_num' = r_num & nCr' = nCr),
        Implies(And(Equals(pc, Int(20)), Equals(x_pc, Int(21))),
                And(Equals(x_n_num, n_num), Equals(x_num, num),
                    Equals(x_den, den), Equals(x_nmul, nmul),
                    Equals(x_dmul, dmul), Equals(x_r_num, r_num),
                    Equals(x_nCr, nCr))),
        # (pc = 21 & pc' = -1) -> (n_num' = n_num & num' = num & den' = den & nmul' = nmul & dmul' = dmul & r_num' = r_num & nCr' = nCr),
        Implies(And(Equals(pc, Int(21)), Equals(x_pc, Int(-1))),
                And(Equals(x_n_num, n_num), Equals(x_num, num),
                    Equals(x_den, den), Equals(x_nmul, nmul),
                    Equals(x_dmul, dmul), Equals(x_r_num, r_num),
                    Equals(x_nCr, nCr))),
        # (pc = 21 & pc' = 22) -> (n_num' = n_num & num' = num & den' = den & nmul' = nmul & dmul' = dmul & r_num' = r_num & nCr' = nCr),
        Implies(And(Equals(pc, Int(21)), Equals(x_pc, Int(22))),
                And(Equals(x_n_num, n_num), Equals(x_num, num),
                    Equals(x_den, den), Equals(x_nmul, nmul),
                    Equals(x_dmul, dmul), Equals(x_r_num, r_num),
                    Equals(x_nCr, nCr))),
        # (pc = 22 & pc' = 23) -> (n_num' = n_num & num' = num & den' = den & nmul' = nmul & dmul' = dmul & r_num' = r_num & nCr' = num/den),
        Implies(And(Equals(pc, Int(22)), Equals(x_pc, Int(23))),
                And(Equals(x_n_num, n_num), Equals(x_num, num),
                    Equals(x_den, den), Equals(x_nmul, nmul),
                    Equals(x_dmul, dmul), Equals(x_r_num, r_num),
                    Equals(x_nCr, Div(num, den)))),
        # (pc = 23 & pc' = -1) -> (n_num' = n_num & num' = num & den' = den & nmul' = nmul & dmul' = dmul & r_num' = r_num & nCr' = nCr),
        Implies(And(Equals(pc, Int(23)), Equals(x_pc, Int(-1))),
                And(Equals(x_n_num, n_num), Equals(x_num, num),
                    Equals(x_den, den), Equals(x_nmul, nmul),
                    Equals(x_dmul, dmul), Equals(x_r_num, r_num),
                    Equals(x_nCr, nCr))),
        # (pc = 24 & pc' = -1) -> (n_num' = n_num & num' = num & den' = den & nmul' = nmul & dmul' = dmul & r_num' = r_num & nCr' = nCr),
        Implies(And(Equals(pc, Int(24)), Equals(x_pc, Int(-1))),
                And(Equals(x_n_num, n_num), Equals(x_num, num),
                    Equals(x_den, den), Equals(x_nmul, nmul),
                    Equals(x_dmul, dmul), Equals(x_r_num, r_num),
                    Equals(x_nCr, nCr)))
    )

    # transition relation.
    trans = And(cfg, labels)

    # fairness.
    fairness = Not(Equals(pc, Int(-1)))

    # define automata to be composed.
    aut_den = AGAutomaton(symbols, [den], "aut_den", 1)
    aut_den.set_assume(0, TRUE())
    aut_den.set_invar(0, TRUE())
    aut_den.set_transitions(0, [(0, [Equals(x_den, den),
                                     Equals(x_den, Times(den, dmul))])])

    aut_dmul = AGAutomaton(symbols, [dmul], "aut_dmul", 1)
    aut_dmul.set_assume(0, TRUE())
    aut_dmul.set_invar(0, TRUE())
    aut_dmul.set_transitions(0, [(0, [Equals(x_dmul, dmul),
                                      Equals(x_dmul, Minus(dmul, Int(1)))])])

    aut_nCr = AGAutomaton(symbols, [nCr], "aut_nCr", 1)
    aut_nCr.set_assume(0, TRUE())
    aut_nCr.set_invar(0, GE(nCr, Int(1)))
    aut_nCr.set_transitions(0, [(0, [Equals(x_nCr, nCr)])])

    aut_n_num = AGAutomaton(symbols, [n_num], "aut_n_num", 1)
    aut_n_num.set_assume(0, TRUE())
    aut_n_num.set_invar(0, TRUE())
    aut_n_num.set_transitions(0, [(0, [Equals(x_n_num, n_num)])])

    aut_nmul = AGAutomaton(symbols, [nmul], "aut_nmul", 1)
    aut_nmul.set_assume(0, TRUE())
    aut_nmul.set_invar(0, TRUE())
    aut_nmul.set_transitions(0, [(0, [Equals(x_nmul, nmul),
                                      Equals(x_nmul, Minus(nmul, Int(1)))])])

    aut_num = AGAutomaton(symbols, [num], "aut_num", 1)
    aut_num.set_assume(0, TRUE())
    aut_num.set_invar(0, TRUE())
    aut_num.set_transitions(0, [(0, [Equals(x_num, num),
                                     Equals(x_num, Times(num, nmul))])])

    loc2pc = [Int(11), Int(12), Int(16), Int(17), Int(18), Int(19)]
    aut_pc = AGAutomaton(symbols, [pc], "aut_pc", len(loc2pc))
    for loc in range(aut_pc.num_locations):
        n_loc = (loc + 1) % aut_pc.num_locations
        aut_pc.set_assume(loc, TRUE())
        aut_pc.set_invar(loc, Equals(pc, loc2pc[loc]))
        aut_pc.set_transitions(loc, [(n_loc, [Equals(x_pc, loc2pc[n_loc])])])

    aut_r_num = AGAutomaton(symbols, [r_num], "aut_r_num", 1)
    aut_r_num.set_assume(0, TRUE())
    aut_r_num.set_invar(0, TRUE())
    aut_r_num.set_transitions(0, [(0, [Equals(x_r_num, r_num)])])

    automata = [aut_den, aut_dmul, aut_nCr, aut_n_num, aut_nmul, aut_num,
                aut_pc, aut_r_num]

    # search composition.
    comp, undefs = find_composition(automata, init, trans, fairness,
                                    nuxmv_path, model_file, trace_file,
                                    cmd_file)
    if comp is not None:
        with open(output_file, 'w') as out:
            out.write(str(comp))

    if comp and not undefs:
        res = True
    elif not comp:
        res = False
    else:
        assert not comp and undefs
        res = None
    return res
