from find_composition import find_composition
from automata_composition import AGAutomaton
from utils import symb_next

from pysmt.shortcuts import Symbol, TRUE, Int
from pysmt.shortcuts import Not, And, Or, Implies
from pysmt.shortcuts import GT, GE, Equals, LT
from pysmt.shortcuts import Plus, Times, Div
from pysmt.typing import INT


def test(nuxmv_path: str, model_file: str, trace_file: str, cmd_file: str,
         output_file: str) -> bool:
    """Test corresponding to benchmarks/7.smv"""
    # symbols.
    pc = Symbol("pc", INT)
    w = Symbol("w", INT)
    x = Symbol("x", INT)
    y = Symbol("y", INT)
    z = Symbol("z", INT)
    x_pc = Symbol(symb_next("pc"), INT)
    x_w = Symbol(symb_next("w"), INT)
    x_x = Symbol(symb_next("x"), INT)
    x_y = Symbol(symb_next("y"), INT)
    x_z = Symbol(symb_next("z"), INT)
    symbols = [pc, w, x, y, z]

    # initial location.
    init = Equals(pc, Int(0))

    # control flow graph.
    cfg = And(
        # pc = -1 : -1,
        Implies(Equals(pc, Int(-1)), Equals(x_pc, Int(-1))),
        # pc = 0 & !(z >= 3) : -1,
        Implies(And(Equals(pc, Int(0)), Not(GE(z, Int(3)))),
                Equals(x_pc, Int(-1))),
        # pc = 0 & z >= 3 : 1,
        Implies(And(Equals(pc, Int(0)), GE(z, Int(3))), Equals(x_pc, Int(1))),
        # pc = 1 & !( y >= 2) : -1,
        Implies(And(Equals(pc, Int(1)), Not(GE(y, Int(2)))),
                Equals(x_pc, Int(-1))),
        # pc = 1 & y >= 2 : 2,
        Implies(And(Equals(pc, Int(1)), GE(y, Int(2))), Equals(x_pc, Int(2))),
        # pc = 2 : {3, 5},
        Implies(Equals(pc, Int(2)),
                Or(Equals(x_pc, Int(3)), Equals(x_pc, Int(5)))),
        # pc = 3 & !(z < -5) : -1,
        Implies(And(Equals(pc, Int(3)), Not(LT(z, Int(-5)))),
                Equals(x_pc, Int(-1))),
        # pc = 3 & z < -5 : 4,
        Implies(And(Equals(pc, Int(3)), LT(z, Int(-5))), Equals(x_pc, Int(4))),
        # pc = 4 : -1,
        Implies(Equals(pc, Int(4)), Equals(x_pc, Int(-1))),
        # pc = 5 & !(w >= 2) : 13,
        Implies(And(Equals(pc, Int(5)), Not(GE(w, Int(2)))),
                Equals(x_pc, Int(13))),
        # pc = 5 & w >= 2 : 6,
        Implies(And(Equals(pc, Int(5)), GE(w, Int(2))), Equals(x_pc, Int(6))),
        # pc = 6 : {7, 9},
        Implies(Equals(pc, Int(6)),
                Or(Equals(x_pc, Int(7)), Equals(x_pc, Int(9)))),
        # pc = 7 & !(z < -5) : -1,
        Implies(And(Equals(pc, Int(7)), Not(LT(z, Int(-5)))),
                Equals(x_pc, Int(-1))),
        # pc = 7 & z < -5 : 8,
        Implies(And(Equals(pc, Int(7)), LT(z, Int(-5))), Equals(x_pc, Int(8))),
        # pc = 8 : -1,
        Implies(Equals(pc, Int(8)), Equals(x_pc, Int(-1))),
        # pc = 9 & !(x >= 0) : 5,
        Implies(And(Equals(pc, Int(9)), Not(GE(x, Int(0)))),
                Equals(x_pc, Int(5))),
        # pc = 9 & x >= 0 : 10,
        Implies(And(Equals(pc, Int(9)), GE(x, Int(0))), Equals(x_pc, Int(10))),
        # pc = 10 : 11,
        Implies(Equals(pc, Int(10)), Equals(x_pc, Int(11))),
        # pc = 11 : 12,
        Implies(Equals(pc, Int(11)), Equals(x_pc, Int(12))),
        # pc = 12 : 9,
        Implies(Equals(pc, Int(12)), Equals(x_pc, Int(9))),
        # pc = 13 : {-1, 14},
        Implies(Equals(pc, Int(13)),
                Or(Equals(x_pc, Int(-1)), Equals(x_pc, Int(14)))),
        # pc = 14 & !(z < -5) : -1,
        Implies(And(Equals(pc, Int(14)), Not(LT(z, Int(-5)))),
                Equals(x_pc, Int(-1))),
        # pc = 14 & (z < -5) : 15,
        Implies(And(Equals(pc, Int(14)), LT(z, Int(-5))),
                Equals(x_pc, Int(15))),
        # pc = 15 : -1,
        Implies(Equals(pc, Int(15)), Equals(x_pc, Int(-1)))
    )

    # transition labels.
    labels = And(
        # (pc = -1 & pc' = -1) -> (w' = w & x' = x & y' = y & z' = z),
        Implies(And(Equals(pc, Int(-1)), Equals(x_pc, Int(-1))),
                And(Equals(x_w, w), Equals(x_x, x), Equals(x_y, y),
                    Equals(x_z, z))),
        # (pc = 0 & pc' = -1)  -> (w' = w & x' = x & y' = y & z' = z),
        Implies(And(Equals(pc, Int(0)), Equals(x_pc, Int(-1))),
                And(Equals(x_w, w), Equals(x_x, x), Equals(x_y, y),
                    Equals(x_z, z))),
        # (pc = 0 & pc' = 1)   -> (w' = w & x' = x & y' = y & z' = z),
        Implies(And(Equals(pc, Int(0)), Equals(x_pc, Int(1))),
                And(Equals(x_w, w), Equals(x_x, x), Equals(x_y, y),
                    Equals(x_z, z))),
        # (pc = 1 & pc' = -1)  -> (w' = w & x' = x & y' = y & z' = z),
        Implies(And(Equals(pc, Int(1)), Equals(x_pc, Int(-1))),
                And(Equals(x_w, w), Equals(x_x, x), Equals(x_y, y),
                    Equals(x_z, z))),
        # (pc = 1 & pc' = 2)   -> (w' = w & x' = x & y' = y & z' = z),
        Implies(And(Equals(pc, Int(1)), Equals(x_pc, Int(2))),
                And(Equals(x_w, w), Equals(x_x, x), Equals(x_y, y),
                    Equals(x_z, z))),
        # (pc = 2 & pc' = 3)   -> (w' = w & x' = x & y' = y & z' = z),
        Implies(And(Equals(pc, Int(2)), Equals(x_pc, Int(3))),
                And(Equals(x_w, w), Equals(x_x, x), Equals(x_y, y),
                    Equals(x_z, z))),
        # (pc = 2 & pc' = 5)   -> (w' = w & x' = x & y' = y & z' = z),
        Implies(And(Equals(pc, Int(2)), Equals(x_pc, Int(5))),
                And(Equals(x_w, w), Equals(x_x, x), Equals(x_y, y),
                    Equals(x_z, z))),
        # (pc = 3 & pc' = -1)  -> (w' = w & x' = x & y' = y & z' = z),
        Implies(And(Equals(pc, Int(3)), Equals(x_pc, Int(-1))),
                And(Equals(x_w, w), Equals(x_x, x), Equals(x_y, y),
                    Equals(x_z, z))),
        # (pc = 3 & pc' = 4)   -> (w' = w & x' = x & y' = y & z' = z),
        Implies(And(Equals(pc, Int(3)), Equals(x_pc, Int(4))),
                And(Equals(x_w, w), Equals(x_x, x), Equals(x_y, y),
                    Equals(x_z, z))),
        # (pc = 4 & pc' = -1)  -> (w' = w & x' = x & y' = y & z' = z),
        Implies(And(Equals(pc, Int(4)), Equals(x_pc, Int(-1))),
                And(Equals(x_w, w), Equals(x_x, x), Equals(x_y, y),
                    Equals(x_z, z))),
        # (pc = 5 & pc' = 13)  -> (w' = w & x' = x & y' = y & z' = z),
        Implies(And(Equals(pc, Int(5)), Equals(x_pc, Int(13))),
                And(Equals(x_w, w), Equals(x_x, x), Equals(x_y, y),
                    Equals(x_z, z))),
        # (pc = 5 & pc' = 6)   -> (w' = w & x' = x & y' = y & z' = z),
        Implies(And(Equals(pc, Int(5)), Equals(x_pc, Int(6))),
                And(Equals(x_w, w), Equals(x_x, x), Equals(x_y, y),
                    Equals(x_z, z))),
        # (pc = 6 & pc' = 7)   -> (w' = w & x' = x & y' = y & z' = z),
        Implies(And(Equals(pc, Int(6)), Equals(x_pc, Int(7))),
                And(Equals(x_w, w), Equals(x_x, x), Equals(x_y, y),
                    Equals(x_z, z))),
        # (pc = 6 & pc' = 9)   -> (w' = w & x' = x & y' = y & z' = z),
        Implies(And(Equals(pc, Int(6)), Equals(x_pc, Int(9))),
                And(Equals(x_w, w), Equals(x_x, x), Equals(x_y, y),
                    Equals(x_z, z))),
        # (pc = 7 & pc' = -1)  -> (w' = w & x' = x & y' = y & z' = z),
        Implies(And(Equals(pc, Int(7)), Equals(x_pc, Int(-1))),
                And(Equals(x_w, w), Equals(x_x, x), Equals(x_y, y),
                    Equals(x_z, z))),
        # (pc = 7 & pc' = 8)   -> (w' = w & x' = x & y' = y & z' = z),
        Implies(And(Equals(pc, Int(7)), Equals(x_pc, Int(8))),
                And(Equals(x_w, w), Equals(x_x, x), Equals(x_y, y),
                    Equals(x_z, z))),
        # (pc = 8 & pc' = -1)  -> (w' = w & x' = x & y' = y & z' = z),
        Implies(And(Equals(pc, Int(8)), Equals(x_pc, Int(-1))),
                And(Equals(x_w, w), Equals(x_x, x), Equals(x_y, y),
                    Equals(x_z, z))),
        # (pc = 9 & pc' = 5)   -> (w' = w & x' = x & y' = y & z' = z),
        Implies(And(Equals(pc, Int(9)), Equals(x_pc, Int(5))),
                And(Equals(x_w, w), Equals(x_x, x), Equals(x_y, y),
                    Equals(x_z, z))),
        # (pc = 9 & pc' = 10)  -> (w' = w & x' = x & y' = y & z' = z),
        Implies(And(Equals(pc, Int(9)), Equals(x_pc, Int(10))),
                And(Equals(x_w, w), Equals(x_x, x), Equals(x_y, y),
                    Equals(x_z, z))),
        # (pc = 10 & pc' = 11) -> (w' = w & x' = z*y + w/y & y' = y & z' = z),
        Implies(And(Equals(pc, Int(10)), Equals(x_pc, Int(11))),
                And(Equals(x_w, w), Equals(x_x, Plus(Times(z, y), Div(w, y))),
                    Equals(x_y, y), Equals(x_z, z))),
        # (pc = 11 & pc' = 12) -> (w' = w & x' = x & y' = y+1 & z' = z),
        Implies(And(Equals(pc, Int(11)), Equals(x_pc, Int(12))),
                And(Equals(x_w, w), Equals(x_x, x),
                    Equals(x_y, Plus(y, Int(1))), Equals(x_z, z))),
        # (pc = 12 & pc' = 9)  -> (w' = w & x' = x & y' = y & z' = z+1),
        Implies(And(Equals(pc, Int(12)), Equals(x_pc, Int(9))),
                And(Equals(x_w, w), Equals(x_x, x), Equals(x_y, y),
                    Equals(x_z, Plus(z, Int(1))))),
        # (pc = 13 & pc' = -1) -> (w' = w & x' = x & y' = y & z' = z),
        Implies(And(Equals(pc, Int(13)), Equals(x_pc, Int(-1))),
                And(Equals(x_w, w), Equals(x_x, x), Equals(x_y, y),
                    Equals(x_z, z))),
        # (pc = 13 & pc' = 14) -> (w' = w & x' = x & y' = y & z' = z),
        Implies(And(Equals(pc, Int(13)), Equals(x_pc, Int(14))),
                And(Equals(x_w, w), Equals(x_x, x), Equals(x_y, y),
                    Equals(x_z, z))),
        # (pc = 14 & pc' = -1) -> (w' = w & x' = x & y' = y & z' = z),
        Implies(And(Equals(pc, Int(14)), Equals(x_pc, Int(-1))),
                And(Equals(x_w, w), Equals(x_x, x), Equals(x_y, y),
                    Equals(x_z, z))),
        # (pc = 14 & pc' = 15) -> (w' = w & x' = x & y' = y & z' = z),
        Implies(And(Equals(pc, Int(14)), Equals(x_pc, Int(15))),
                And(Equals(x_w, w), Equals(x_x, x), Equals(x_y, y),
                    Equals(x_z, z))),
        # (pc = 15 & pc' = -1) -> (w' = w & x' = x & y' = y & z' = z),
        Implies(And(Equals(pc, Int(15)), Equals(x_pc, Int(-1))),
                And(Equals(x_w, w), Equals(x_x, x), Equals(x_y, y),
                    Equals(x_z, z)))
    )

    # transition relation.
    trans = And(cfg, labels)

    # fairness.
    fairness = Not(Equals(pc, Int(-1)))

    # define automata to be composed.
    aut_pc = AGAutomaton(symbols, [pc], "aut_pc", 3)
    loc2pc = [5, 6, 9]
    for loc in range(3):
        n_loc = (loc + 1) % 3
        c_pc = Int(loc2pc[loc])
        n_pc = Int(loc2pc[n_loc])
        aut_pc.set_assume(loc, TRUE())
        aut_pc.set_invar(loc, Equals(pc, c_pc))
        aut_pc.set_transitions(loc, [(n_loc, [Equals(x_pc, n_pc)])])

    aut_w = AGAutomaton(symbols, [w], "aut_w", 1)
    aut_w.set_assume(0, TRUE())
    aut_w.set_invar(0, GE(w, Int(2)))
    aut_w.set_transitions(0, [(0, [Equals(x_w, w)])])

    aut_x = AGAutomaton(symbols, [x], "aut_x", 1)
    aut_x.set_assume(0, TRUE())
    aut_x.set_invar(0, LT(x, Int(0)))
    aut_x.set_transitions(0, [(0, [Equals(x_x, x)])])

    aut_y = AGAutomaton(symbols, [y], "aut_y", 1)
    aut_y.set_assume(0, TRUE())
    aut_y.set_invar(0, TRUE())
    aut_y.set_transitions(0, [(0, [Equals(x_y, y)])])

    aut_z = AGAutomaton(symbols, [z], "aut_z", 1)
    aut_z.set_assume(0, TRUE())
    aut_z.set_invar(0, TRUE())
    aut_z.set_transitions(0, [(0, [Equals(x_z, z)])])

    # aut_pc = AGAutomaton(symbols, [pc], "aut_pc", 4)
    # for loc in range(aut_pc.num_locations):
    #     n_loc = (loc + 1) % aut_pc.num_locations
    #     c_pc = Int(loc + 9)
    #     n_pc = Int(n_loc + 9)
    #     aut_pc.set_assume(loc, TRUE())
    #     aut_pc.set_invar(loc, Equals(pc, c_pc))
    #     aut_pc.set_transitions(loc, [(n_loc, [Equals(x_pc, n_pc)])])

    # aut_w = AGAutomaton(symbols, [w], "aut_w", 1)
    # aut_w.set_assume(0, TRUE())
    # aut_w.set_invar(0, GE(w, Int(0)))
    # aut_w.set_transitions(0, [(0, [Equals(x_w, w)])])

    # aut_x = AGAutomaton(symbols, [x], "aut_x", 1)
    # aut_x.set_assume(0, And(GE(w, Int(0)), GT(y, Int(0)), GE(z, Int(0))))
    # aut_x.set_invar(0, GE(x, Int(0)))
    # aut_x.set_transitions(0, [(0, [Equals(x_x, x),
    #                                Equals(x_x, Plus(Times(z, y),
    #                                                 Div(w, y)))])])

    # aut_y = AGAutomaton(symbols, [y], "aut_y", 1)
    # aut_y.set_assume(0, TRUE())
    # aut_y.set_invar(0, GE(y, Int(0)))
    # aut_y.set_transitions(0, [(0, [Equals(x_y, y),
    #                                Equals(x_y, Plus(y, Int(1)))])])

    # aut_z = AGAutomaton(symbols, [z], "aut_z", 1)
    # aut_z.set_assume(0, TRUE())
    # aut_z.set_invar(0, GE(z, Int(0)))
    # aut_z.set_transitions(0, [(0, [Equals(x_z, z),
    #                                Equals(x_z, Plus(z, Int(1)))])])

    automata = [aut_pc, aut_w, aut_x, aut_y, aut_z]

    # search composition.
    comp, undefs = find_composition(automata, init, trans, fairness,
                                    nuxmv_path, model_file, trace_file,
                                    cmd_file)
    if comp is not None:
        with open(output_file, 'w') as out:
            out.write(str(comp))

    if comp and not undefs:
        res = True
    elif not comp:
        res = False
    else:
        assert not comp and undefs
        res = None
    return res
