#! /bin/bash +x

nuxmv=/home/en/Programs/nuXmv
timeout=600  # timeout in seconds
finite_cmd=./check_ltl_finite.cmd
infinite_cmd=./check_ltl.cmd
timed_cmd=./check_ltl_kzeno.cmd

outdir=output_$(date +"%Y_%m_%d_%H_%M_%S")
mkdir $outdir
for filename in ./*.fsmv; do
    name=$(basename $filename .fsmv)
    name=$outdir/$name.out
    echo $filename
    runlim --kill --time-limit=$timeout $nuxmv -source $finite_cmd $filename &> $name
done

for filename in ./*.smv; do
    name=$(basename $filename .smv)
    name=$outdir/$name.out
    echo $filename
    runlim --kill --time-limit=$timeout $nuxmv -source $infinite_cmd $filename &> $name
done

for filename in ./*.tsmv; do
    name=$(basename $filename .tsmv)
    name=$outdir/$name.out
    echo $filename
    runlim --kill --time-limit=$timeout $nuxmv -source $timed_cmd $filename &> $name
done
