// Implementation file for parser generated by fsyacc
module Microsoft.Research.T2.Absparse
#nowarn "64";; // turn off warnings that type variables used in production annotations are instantiated to concrete type
open Microsoft.FSharp.Text.Lexing
open Microsoft.FSharp.Text.Parsing.ParseHelpers
# 1 "absparse.fsy"

// Copyright (c) Microsoft Corporation
//
// All rights reserved. 
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the ""Software""), to 
// deal in the Software without restriction, including without limitation the
// rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
// sell copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included 
// in all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED *AS IS*, WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
// THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
// FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
// DEALINGS IN THE SOFTWARE.

module E = ParseError

///
/// Location in a T2 file (either numerical or a name)
///
type parsedLoc =
    | NumLoc of int
    | NameLoc of string

let annotate = ref false
let incomplete_abstraction = ref false

let normalize_var (v : string) =
  if v.StartsWith Formula.instrumentation_prefix then
    Var.var ("_" + v)
  else
    Var.var v


# 49 "absparse.fs"
// This type is the type of tokens accepted by the parser
type token = 
  | F
  | G
  | X
  | W
  | U
  | A
  | E
  | AF
  | AG
  | AW
  | AX
  | EF
  | EG
  | EU
  | EX
  | TO
  | FROM
  | CUTPOINT
  | START
  | ASSUME
  | ASSIGN
  | NONDET
  | SHADOW
  | AND_OP
  | OR_OP
  | EQ
  | GE
  | GT
  | LE
  | LT
  | NE
  | NOT
  | DIV
  | REM
  | STAR
  | PLUS
  | MINUS
  | LPAREN
  | RPAREN
  | EOF
  | SEMICOLON
  | COLON
  | COMMA
  | AT
  | Num of (bigint)
  | Id of (string)
  | Const of (string)
  | String of (string)
// This type is used to give symbolic names to token indexes, useful for error messages
type tokenId = 
    | TOKEN_F
    | TOKEN_G
    | TOKEN_X
    | TOKEN_W
    | TOKEN_U
    | TOKEN_A
    | TOKEN_E
    | TOKEN_AF
    | TOKEN_AG
    | TOKEN_AW
    | TOKEN_AX
    | TOKEN_EF
    | TOKEN_EG
    | TOKEN_EU
    | TOKEN_EX
    | TOKEN_TO
    | TOKEN_FROM
    | TOKEN_CUTPOINT
    | TOKEN_START
    | TOKEN_ASSUME
    | TOKEN_ASSIGN
    | TOKEN_NONDET
    | TOKEN_SHADOW
    | TOKEN_AND_OP
    | TOKEN_OR_OP
    | TOKEN_EQ
    | TOKEN_GE
    | TOKEN_GT
    | TOKEN_LE
    | TOKEN_LT
    | TOKEN_NE
    | TOKEN_NOT
    | TOKEN_DIV
    | TOKEN_REM
    | TOKEN_STAR
    | TOKEN_PLUS
    | TOKEN_MINUS
    | TOKEN_LPAREN
    | TOKEN_RPAREN
    | TOKEN_EOF
    | TOKEN_SEMICOLON
    | TOKEN_COLON
    | TOKEN_COMMA
    | TOKEN_AT
    | TOKEN_Num
    | TOKEN_Id
    | TOKEN_Const
    | TOKEN_String
    | TOKEN_end_of_input
    | TOKEN_error
// This type is used to give symbolic names to token indexes, useful for error messages
type nonTerminalId = 
    | NONTERM__startFairness_constraint
    | NONTERM__startPath_formula
    | NONTERM__startState_formula
    | NONTERM__startCTLStar_formula
    | NONTERM__startCTL_formula
    | NONTERM__startprogram
    | NONTERM_program
    | NONTERM_blocks
    | NONTERM_block
    | NONTERM_shadows
    | NONTERM_shadow
    | NONTERM_commands
    | NONTERM_loc
    | NONTERM_command
    | NONTERM_term
    | NONTERM_formula
    | NONTERM_ATOM
    | NONTERM_State_formula
    | NONTERM_Path_formula
    | NONTERM_CTLStar_formula
    | NONTERM_CTL_formula
    | NONTERM_Fairness_constraint
    | NONTERM_num

// This function maps tokens to integer indexes
let tagOfToken (t:token) = 
  match t with
  | F  -> 0 
  | G  -> 1 
  | X  -> 2 
  | W  -> 3 
  | U  -> 4 
  | A  -> 5 
  | E  -> 6 
  | AF  -> 7 
  | AG  -> 8 
  | AW  -> 9 
  | AX  -> 10 
  | EF  -> 11 
  | EG  -> 12 
  | EU  -> 13 
  | EX  -> 14 
  | TO  -> 15 
  | FROM  -> 16 
  | CUTPOINT  -> 17 
  | START  -> 18 
  | ASSUME  -> 19 
  | ASSIGN  -> 20 
  | NONDET  -> 21 
  | SHADOW  -> 22 
  | AND_OP  -> 23 
  | OR_OP  -> 24 
  | EQ  -> 25 
  | GE  -> 26 
  | GT  -> 27 
  | LE  -> 28 
  | LT  -> 29 
  | NE  -> 30 
  | NOT  -> 31 
  | DIV  -> 32 
  | REM  -> 33 
  | STAR  -> 34 
  | PLUS  -> 35 
  | MINUS  -> 36 
  | LPAREN  -> 37 
  | RPAREN  -> 38 
  | EOF  -> 39 
  | SEMICOLON  -> 40 
  | COLON  -> 41 
  | COMMA  -> 42 
  | AT  -> 43 
  | Num _ -> 44 
  | Id _ -> 45 
  | Const _ -> 46 
  | String _ -> 47 

// This function maps integer indexes to symbolic token ids
let tokenTagToTokenId (tokenIdx:int) = 
  match tokenIdx with
  | 0 -> TOKEN_F 
  | 1 -> TOKEN_G 
  | 2 -> TOKEN_X 
  | 3 -> TOKEN_W 
  | 4 -> TOKEN_U 
  | 5 -> TOKEN_A 
  | 6 -> TOKEN_E 
  | 7 -> TOKEN_AF 
  | 8 -> TOKEN_AG 
  | 9 -> TOKEN_AW 
  | 10 -> TOKEN_AX 
  | 11 -> TOKEN_EF 
  | 12 -> TOKEN_EG 
  | 13 -> TOKEN_EU 
  | 14 -> TOKEN_EX 
  | 15 -> TOKEN_TO 
  | 16 -> TOKEN_FROM 
  | 17 -> TOKEN_CUTPOINT 
  | 18 -> TOKEN_START 
  | 19 -> TOKEN_ASSUME 
  | 20 -> TOKEN_ASSIGN 
  | 21 -> TOKEN_NONDET 
  | 22 -> TOKEN_SHADOW 
  | 23 -> TOKEN_AND_OP 
  | 24 -> TOKEN_OR_OP 
  | 25 -> TOKEN_EQ 
  | 26 -> TOKEN_GE 
  | 27 -> TOKEN_GT 
  | 28 -> TOKEN_LE 
  | 29 -> TOKEN_LT 
  | 30 -> TOKEN_NE 
  | 31 -> TOKEN_NOT 
  | 32 -> TOKEN_DIV 
  | 33 -> TOKEN_REM 
  | 34 -> TOKEN_STAR 
  | 35 -> TOKEN_PLUS 
  | 36 -> TOKEN_MINUS 
  | 37 -> TOKEN_LPAREN 
  | 38 -> TOKEN_RPAREN 
  | 39 -> TOKEN_EOF 
  | 40 -> TOKEN_SEMICOLON 
  | 41 -> TOKEN_COLON 
  | 42 -> TOKEN_COMMA 
  | 43 -> TOKEN_AT 
  | 44 -> TOKEN_Num 
  | 45 -> TOKEN_Id 
  | 46 -> TOKEN_Const 
  | 47 -> TOKEN_String 
  | 50 -> TOKEN_end_of_input
  | 48 -> TOKEN_error
  | _ -> failwith "tokenTagToTokenId: bad token"

/// This function maps production indexes returned in syntax errors to strings representing the non terminal that would be produced by that production
let prodIdxToNonTerminal (prodIdx:int) = 
  match prodIdx with
    | 0 -> NONTERM__startFairness_constraint 
    | 1 -> NONTERM__startPath_formula 
    | 2 -> NONTERM__startState_formula 
    | 3 -> NONTERM__startCTLStar_formula 
    | 4 -> NONTERM__startCTL_formula 
    | 5 -> NONTERM__startprogram 
    | 6 -> NONTERM_program 
    | 7 -> NONTERM_program 
    | 8 -> NONTERM_blocks 
    | 9 -> NONTERM_blocks 
    | 10 -> NONTERM_block 
    | 11 -> NONTERM_shadows 
    | 12 -> NONTERM_shadows 
    | 13 -> NONTERM_shadow 
    | 14 -> NONTERM_commands 
    | 15 -> NONTERM_commands 
    | 16 -> NONTERM_loc 
    | 17 -> NONTERM_loc 
    | 18 -> NONTERM_command 
    | 19 -> NONTERM_command 
    | 20 -> NONTERM_command 
    | 21 -> NONTERM_command 
    | 22 -> NONTERM_command 
    | 23 -> NONTERM_command 
    | 24 -> NONTERM_term 
    | 25 -> NONTERM_term 
    | 26 -> NONTERM_term 
    | 27 -> NONTERM_term 
    | 28 -> NONTERM_term 
    | 29 -> NONTERM_term 
    | 30 -> NONTERM_term 
    | 31 -> NONTERM_term 
    | 32 -> NONTERM_term 
    | 33 -> NONTERM_term 
    | 34 -> NONTERM_formula 
    | 35 -> NONTERM_formula 
    | 36 -> NONTERM_formula 
    | 37 -> NONTERM_formula 
    | 38 -> NONTERM_formula 
    | 39 -> NONTERM_formula 
    | 40 -> NONTERM_formula 
    | 41 -> NONTERM_formula 
    | 42 -> NONTERM_formula 
    | 43 -> NONTERM_formula 
    | 44 -> NONTERM_ATOM 
    | 45 -> NONTERM_ATOM 
    | 46 -> NONTERM_ATOM 
    | 47 -> NONTERM_ATOM 
    | 48 -> NONTERM_ATOM 
    | 49 -> NONTERM_ATOM 
    | 50 -> NONTERM_State_formula 
    | 51 -> NONTERM_State_formula 
    | 52 -> NONTERM_State_formula 
    | 53 -> NONTERM_State_formula 
    | 54 -> NONTERM_State_formula 
    | 55 -> NONTERM_State_formula 
    | 56 -> NONTERM_Path_formula 
    | 57 -> NONTERM_Path_formula 
    | 58 -> NONTERM_Path_formula 
    | 59 -> NONTERM_Path_formula 
    | 60 -> NONTERM_Path_formula 
    | 61 -> NONTERM_Path_formula 
    | 62 -> NONTERM_CTLStar_formula 
    | 63 -> NONTERM_CTLStar_formula 
    | 64 -> NONTERM_CTL_formula 
    | 65 -> NONTERM_CTL_formula 
    | 66 -> NONTERM_CTL_formula 
    | 67 -> NONTERM_CTL_formula 
    | 68 -> NONTERM_CTL_formula 
    | 69 -> NONTERM_CTL_formula 
    | 70 -> NONTERM_CTL_formula 
    | 71 -> NONTERM_CTL_formula 
    | 72 -> NONTERM_CTL_formula 
    | 73 -> NONTERM_CTL_formula 
    | 74 -> NONTERM_CTL_formula 
    | 75 -> NONTERM_CTL_formula 
    | 76 -> NONTERM_CTL_formula 
    | 77 -> NONTERM_Fairness_constraint 
    | 78 -> NONTERM_num 
    | 79 -> NONTERM_num 
    | _ -> failwith "prodIdxToNonTerminal: bad production index"

let _fsyacc_endOfInputTag = 50 
let _fsyacc_tagOfErrorTerminal = 48

// This function gets the name of a token as a string
let token_to_string (t:token) = 
  match t with 
  | F  -> "F" 
  | G  -> "G" 
  | X  -> "X" 
  | W  -> "W" 
  | U  -> "U" 
  | A  -> "A" 
  | E  -> "E" 
  | AF  -> "AF" 
  | AG  -> "AG" 
  | AW  -> "AW" 
  | AX  -> "AX" 
  | EF  -> "EF" 
  | EG  -> "EG" 
  | EU  -> "EU" 
  | EX  -> "EX" 
  | TO  -> "TO" 
  | FROM  -> "FROM" 
  | CUTPOINT  -> "CUTPOINT" 
  | START  -> "START" 
  | ASSUME  -> "ASSUME" 
  | ASSIGN  -> "ASSIGN" 
  | NONDET  -> "NONDET" 
  | SHADOW  -> "SHADOW" 
  | AND_OP  -> "AND_OP" 
  | OR_OP  -> "OR_OP" 
  | EQ  -> "EQ" 
  | GE  -> "GE" 
  | GT  -> "GT" 
  | LE  -> "LE" 
  | LT  -> "LT" 
  | NE  -> "NE" 
  | NOT  -> "NOT" 
  | DIV  -> "DIV" 
  | REM  -> "REM" 
  | STAR  -> "STAR" 
  | PLUS  -> "PLUS" 
  | MINUS  -> "MINUS" 
  | LPAREN  -> "LPAREN" 
  | RPAREN  -> "RPAREN" 
  | EOF  -> "EOF" 
  | SEMICOLON  -> "SEMICOLON" 
  | COLON  -> "COLON" 
  | COMMA  -> "COMMA" 
  | AT  -> "AT" 
  | Num _ -> "Num" 
  | Id _ -> "Id" 
  | Const _ -> "Const" 
  | String _ -> "String" 

// This function gets the data carried by a token as an object
let _fsyacc_dataOfToken (t:token) = 
  match t with 
  | F  -> (null : System.Object) 
  | G  -> (null : System.Object) 
  | X  -> (null : System.Object) 
  | W  -> (null : System.Object) 
  | U  -> (null : System.Object) 
  | A  -> (null : System.Object) 
  | E  -> (null : System.Object) 
  | AF  -> (null : System.Object) 
  | AG  -> (null : System.Object) 
  | AW  -> (null : System.Object) 
  | AX  -> (null : System.Object) 
  | EF  -> (null : System.Object) 
  | EG  -> (null : System.Object) 
  | EU  -> (null : System.Object) 
  | EX  -> (null : System.Object) 
  | TO  -> (null : System.Object) 
  | FROM  -> (null : System.Object) 
  | CUTPOINT  -> (null : System.Object) 
  | START  -> (null : System.Object) 
  | ASSUME  -> (null : System.Object) 
  | ASSIGN  -> (null : System.Object) 
  | NONDET  -> (null : System.Object) 
  | SHADOW  -> (null : System.Object) 
  | AND_OP  -> (null : System.Object) 
  | OR_OP  -> (null : System.Object) 
  | EQ  -> (null : System.Object) 
  | GE  -> (null : System.Object) 
  | GT  -> (null : System.Object) 
  | LE  -> (null : System.Object) 
  | LT  -> (null : System.Object) 
  | NE  -> (null : System.Object) 
  | NOT  -> (null : System.Object) 
  | DIV  -> (null : System.Object) 
  | REM  -> (null : System.Object) 
  | STAR  -> (null : System.Object) 
  | PLUS  -> (null : System.Object) 
  | MINUS  -> (null : System.Object) 
  | LPAREN  -> (null : System.Object) 
  | RPAREN  -> (null : System.Object) 
  | EOF  -> (null : System.Object) 
  | SEMICOLON  -> (null : System.Object) 
  | COLON  -> (null : System.Object) 
  | COMMA  -> (null : System.Object) 
  | AT  -> (null : System.Object) 
  | Num _fsyacc_x -> Microsoft.FSharp.Core.Operators.box _fsyacc_x 
  | Id _fsyacc_x -> Microsoft.FSharp.Core.Operators.box _fsyacc_x 
  | Const _fsyacc_x -> Microsoft.FSharp.Core.Operators.box _fsyacc_x 
  | String _fsyacc_x -> Microsoft.FSharp.Core.Operators.box _fsyacc_x 
let _fsyacc_gotos = [| 0us; 65535us; 0us; 65535us; 0us; 65535us; 0us; 65535us; 0us; 65535us; 0us; 65535us; 1us; 65535us; 10us; 11us; 3us; 65535us; 20us; 21us; 22us; 23us; 25us; 26us; 3us; 65535us; 20us; 24us; 22us; 24us; 25us; 24us; 3us; 65535us; 15us; 22us; 19us; 20us; 36us; 37us; 3us; 65535us; 15us; 35us; 19us; 35us; 36us; 35us; 2us; 65535us; 30us; 31us; 45us; 46us; 4us; 65535us; 13us; 14us; 17us; 18us; 28us; 29us; 33us; 34us; 2us; 65535us; 30us; 44us; 45us; 44us; 56us; 65535us; 4us; 97us; 6us; 97us; 8us; 97us; 56us; 57us; 59us; 62us; 65us; 66us; 68us; 71us; 74us; 75us; 77us; 81us; 78us; 82us; 79us; 83us; 80us; 83us; 104us; 85us; 105us; 86us; 106us; 87us; 107us; 88us; 108us; 89us; 112us; 91us; 113us; 92us; 114us; 93us; 115us; 94us; 116us; 95us; 117us; 96us; 118us; 90us; 125us; 90us; 126us; 90us; 128us; 98us; 129us; 99us; 130us; 100us; 131us; 101us; 132us; 102us; 133us; 103us; 149us; 97us; 150us; 97us; 154us; 97us; 157us; 97us; 160us; 97us; 163us; 97us; 166us; 97us; 169us; 97us; 172us; 97us; 195us; 97us; 196us; 97us; 198us; 97us; 201us; 97us; 204us; 97us; 207us; 97us; 210us; 97us; 213us; 97us; 216us; 97us; 219us; 97us; 222us; 97us; 225us; 97us; 228us; 97us; 229us; 90us; 230us; 90us; 8us; 65535us; 59us; 60us; 68us; 69us; 78us; 122us; 118us; 119us; 125us; 120us; 126us; 121us; 229us; 123us; 230us; 124us; 27us; 65535us; 4us; 134us; 6us; 134us; 8us; 180us; 79us; 134us; 80us; 180us; 149us; 134us; 150us; 134us; 154us; 134us; 157us; 134us; 160us; 134us; 163us; 134us; 166us; 134us; 169us; 134us; 172us; 134us; 195us; 180us; 196us; 180us; 198us; 180us; 201us; 180us; 204us; 180us; 207us; 180us; 210us; 180us; 213us; 180us; 216us; 180us; 219us; 180us; 222us; 180us; 225us; 180us; 228us; 180us; 12us; 65535us; 4us; 5us; 6us; 179us; 79us; 151us; 149us; 179us; 150us; 179us; 154us; 179us; 157us; 179us; 160us; 179us; 163us; 179us; 166us; 179us; 169us; 179us; 172us; 179us; 16us; 65535us; 2us; 3us; 4us; 178us; 6us; 178us; 79us; 176us; 135us; 136us; 137us; 138us; 149us; 178us; 150us; 178us; 154us; 178us; 157us; 178us; 160us; 178us; 163us; 178us; 166us; 178us; 169us; 178us; 172us; 178us; 174us; 175us; 12us; 65535us; 4us; 140us; 6us; 7us; 79us; 140us; 149us; 139us; 150us; 141us; 154us; 142us; 157us; 143us; 160us; 144us; 163us; 145us; 166us; 146us; 169us; 147us; 172us; 148us; 15us; 65535us; 8us; 9us; 80us; 193us; 195us; 181us; 196us; 182us; 198us; 183us; 201us; 184us; 204us; 185us; 207us; 186us; 210us; 187us; 213us; 188us; 216us; 189us; 219us; 190us; 222us; 191us; 225us; 192us; 228us; 194us; 1us; 65535us; 0us; 1us; 0us; 65535us; |]
let _fsyacc_sparseGotoTableRowOffsets = [|0us; 1us; 2us; 3us; 4us; 5us; 6us; 8us; 12us; 16us; 20us; 24us; 27us; 32us; 35us; 92us; 101us; 129us; 142us; 159us; 172us; 188us; 190us; |]
let _fsyacc_stateToProdIdxsTableElements = [| 1us; 0us; 1us; 0us; 1us; 1us; 1us; 1us; 1us; 2us; 2us; 2us; 63us; 1us; 3us; 3us; 3us; 53us; 54us; 1us; 4us; 3us; 4us; 65us; 66us; 1us; 5us; 1us; 5us; 2us; 6us; 7us; 2us; 6us; 7us; 2us; 6us; 7us; 2us; 6us; 7us; 1us; 6us; 1us; 6us; 1us; 6us; 1us; 6us; 1us; 6us; 1us; 6us; 1us; 7us; 1us; 7us; 1us; 9us; 1us; 9us; 1us; 9us; 1us; 10us; 1us; 10us; 1us; 10us; 1us; 10us; 1us; 10us; 1us; 10us; 1us; 10us; 1us; 10us; 1us; 12us; 1us; 12us; 1us; 12us; 1us; 13us; 1us; 13us; 1us; 13us; 1us; 13us; 1us; 13us; 1us; 13us; 1us; 15us; 1us; 15us; 1us; 15us; 1us; 16us; 1us; 17us; 3us; 18us; 19us; 20us; 3us; 18us; 19us; 20us; 3us; 18us; 19us; 20us; 3us; 18us; 19us; 20us; 3us; 18us; 19us; 20us; 3us; 18us; 19us; 20us; 1us; 18us; 1us; 18us; 6us; 18us; 28us; 29us; 30us; 31us; 32us; 2us; 19us; 20us; 2us; 19us; 20us; 3us; 19us; 41us; 42us; 1us; 19us; 12us; 20us; 28us; 29us; 30us; 31us; 32us; 34us; 35us; 36us; 37us; 38us; 39us; 1us; 20us; 1us; 21us; 1us; 21us; 6us; 21us; 28us; 29us; 30us; 31us; 32us; 2us; 22us; 23us; 2us; 22us; 23us; 3us; 22us; 41us; 42us; 1us; 22us; 12us; 23us; 28us; 29us; 30us; 31us; 32us; 34us; 35us; 36us; 37us; 38us; 39us; 1us; 23us; 1us; 24us; 1us; 25us; 6us; 25us; 28us; 29us; 30us; 31us; 32us; 1us; 26us; 1us; 27us; 2us; 27us; 43us; 3us; 27us; 55us; 61us; 2us; 27us; 75us; 6us; 27us; 28us; 29us; 30us; 31us; 32us; 12us; 27us; 28us; 29us; 30us; 31us; 32us; 34us; 35us; 36us; 37us; 38us; 39us; 12us; 27us; 28us; 29us; 30us; 31us; 32us; 44us; 45us; 46us; 47us; 48us; 49us; 1us; 27us; 6us; 28us; 28us; 29us; 30us; 31us; 32us; 6us; 28us; 29us; 29us; 30us; 31us; 32us; 6us; 28us; 29us; 30us; 30us; 31us; 32us; 6us; 28us; 29us; 30us; 31us; 31us; 32us; 6us; 28us; 29us; 30us; 31us; 32us; 32us; 11us; 28us; 29us; 30us; 31us; 32us; 34us; 35us; 36us; 37us; 38us; 39us; 6us; 28us; 29us; 30us; 31us; 32us; 34us; 6us; 28us; 29us; 30us; 31us; 32us; 35us; 6us; 28us; 29us; 30us; 31us; 32us; 36us; 6us; 28us; 29us; 30us; 31us; 32us; 37us; 6us; 28us; 29us; 30us; 31us; 32us; 38us; 6us; 28us; 29us; 30us; 31us; 32us; 39us; 11us; 28us; 29us; 30us; 31us; 32us; 44us; 45us; 46us; 47us; 48us; 49us; 6us; 28us; 29us; 30us; 31us; 32us; 44us; 6us; 28us; 29us; 30us; 31us; 32us; 45us; 6us; 28us; 29us; 30us; 31us; 32us; 46us; 6us; 28us; 29us; 30us; 31us; 32us; 47us; 6us; 28us; 29us; 30us; 31us; 32us; 48us; 6us; 28us; 29us; 30us; 31us; 32us; 49us; 1us; 28us; 1us; 29us; 1us; 30us; 1us; 31us; 1us; 32us; 1us; 33us; 1us; 33us; 1us; 33us; 1us; 34us; 1us; 35us; 1us; 36us; 1us; 37us; 1us; 38us; 1us; 39us; 1us; 40us; 3us; 40us; 41us; 42us; 3us; 41us; 41us; 42us; 3us; 41us; 42us; 42us; 3us; 41us; 42us; 43us; 3us; 41us; 42us; 77us; 3us; 41us; 42us; 77us; 1us; 41us; 1us; 42us; 1us; 43us; 1us; 44us; 1us; 45us; 1us; 46us; 1us; 47us; 1us; 48us; 1us; 49us; 1us; 50us; 1us; 51us; 1us; 51us; 1us; 52us; 1us; 52us; 3us; 53us; 53us; 54us; 2us; 53us; 54us; 3us; 53us; 54us; 54us; 3us; 53us; 54us; 56us; 3us; 53us; 54us; 57us; 3us; 53us; 54us; 58us; 3us; 53us; 54us; 59us; 3us; 53us; 54us; 59us; 3us; 53us; 54us; 60us; 3us; 53us; 54us; 60us; 1us; 53us; 1us; 54us; 2us; 55us; 63us; 1us; 55us; 1us; 56us; 1us; 56us; 1us; 56us; 1us; 57us; 1us; 57us; 1us; 57us; 1us; 58us; 1us; 58us; 1us; 58us; 1us; 59us; 1us; 59us; 1us; 59us; 1us; 59us; 1us; 59us; 1us; 59us; 1us; 60us; 1us; 60us; 1us; 60us; 1us; 60us; 1us; 60us; 1us; 60us; 1us; 61us; 1us; 61us; 2us; 61us; 62us; 1us; 61us; 1us; 62us; 1us; 63us; 1us; 64us; 3us; 65us; 65us; 66us; 3us; 65us; 66us; 66us; 3us; 65us; 66us; 67us; 3us; 65us; 66us; 68us; 3us; 65us; 66us; 69us; 3us; 65us; 66us; 69us; 3us; 65us; 66us; 70us; 3us; 65us; 66us; 71us; 3us; 65us; 66us; 72us; 3us; 65us; 66us; 73us; 3us; 65us; 66us; 73us; 3us; 65us; 66us; 74us; 3us; 65us; 66us; 75us; 3us; 65us; 66us; 76us; 1us; 65us; 1us; 66us; 1us; 67us; 1us; 67us; 1us; 67us; 1us; 68us; 1us; 68us; 1us; 68us; 1us; 69us; 1us; 69us; 1us; 69us; 1us; 69us; 1us; 69us; 1us; 69us; 1us; 70us; 1us; 70us; 1us; 70us; 1us; 71us; 1us; 71us; 1us; 71us; 1us; 72us; 1us; 72us; 1us; 72us; 1us; 73us; 1us; 73us; 1us; 73us; 1us; 73us; 1us; 73us; 1us; 73us; 1us; 74us; 1us; 74us; 1us; 74us; 1us; 75us; 1us; 76us; 1us; 77us; 1us; 77us; 1us; 77us; |]
let _fsyacc_stateToProdIdxsTableRowOffsets = [|0us; 2us; 4us; 6us; 8us; 10us; 13us; 15us; 19us; 21us; 25us; 27us; 29us; 32us; 35us; 38us; 41us; 43us; 45us; 47us; 49us; 51us; 53us; 55us; 57us; 59us; 61us; 63us; 65us; 67us; 69us; 71us; 73us; 75us; 77us; 79us; 81us; 83us; 85us; 87us; 89us; 91us; 93us; 95us; 97us; 99us; 101us; 103us; 105us; 107us; 111us; 115us; 119us; 123us; 127us; 131us; 133us; 135us; 142us; 145us; 148us; 152us; 154us; 167us; 169us; 171us; 173us; 180us; 183us; 186us; 190us; 192us; 205us; 207us; 209us; 211us; 218us; 220us; 222us; 225us; 229us; 232us; 239us; 252us; 265us; 267us; 274us; 281us; 288us; 295us; 302us; 314us; 321us; 328us; 335us; 342us; 349us; 356us; 368us; 375us; 382us; 389us; 396us; 403us; 410us; 412us; 414us; 416us; 418us; 420us; 422us; 424us; 426us; 428us; 430us; 432us; 434us; 436us; 438us; 440us; 444us; 448us; 452us; 456us; 460us; 464us; 466us; 468us; 470us; 472us; 474us; 476us; 478us; 480us; 482us; 484us; 486us; 488us; 490us; 492us; 496us; 499us; 503us; 507us; 511us; 515us; 519us; 523us; 527us; 531us; 533us; 535us; 538us; 540us; 542us; 544us; 546us; 548us; 550us; 552us; 554us; 556us; 558us; 560us; 562us; 564us; 566us; 568us; 570us; 572us; 574us; 576us; 578us; 580us; 582us; 584us; 586us; 589us; 591us; 593us; 595us; 597us; 601us; 605us; 609us; 613us; 617us; 621us; 625us; 629us; 633us; 637us; 641us; 645us; 649us; 653us; 655us; 657us; 659us; 661us; 663us; 665us; 667us; 669us; 671us; 673us; 675us; 677us; 679us; 681us; 683us; 685us; 687us; 689us; 691us; 693us; 695us; 697us; 699us; 701us; 703us; 705us; 707us; 709us; 711us; 713us; 715us; 717us; 719us; 721us; 723us; 725us; |]
let _fsyacc_action_rows = 232
let _fsyacc_actionTableElements = [|1us; 32768us; 37us; 229us; 0us; 49152us; 6us; 32768us; 0us; 153us; 1us; 156us; 2us; 159us; 3us; 162us; 4us; 168us; 37us; 174us; 0us; 49152us; 12us; 32768us; 0us; 153us; 1us; 156us; 2us; 159us; 3us; 162us; 4us; 168us; 5us; 135us; 6us; 137us; 21us; 109us; 36us; 74us; 37us; 79us; 44us; 73us; 45us; 76us; 2us; 49152us; 23us; 16447us; 24us; 16447us; 12us; 32768us; 0us; 153us; 1us; 156us; 2us; 159us; 3us; 162us; 4us; 168us; 5us; 135us; 6us; 137us; 21us; 109us; 36us; 74us; 37us; 79us; 44us; 73us; 45us; 76us; 2us; 49152us; 23us; 149us; 24us; 150us; 14us; 32768us; 7us; 197us; 8us; 200us; 9us; 203us; 10us; 209us; 11us; 212us; 12us; 215us; 13us; 218us; 14us; 224us; 21us; 109us; 31us; 228us; 36us; 74us; 37us; 80us; 44us; 73us; 45us; 76us; 2us; 49152us; 23us; 195us; 24us; 196us; 1us; 32768us; 18us; 12us; 0us; 49152us; 1us; 32768us; 41us; 13us; 2us; 32768us; 44us; 47us; 45us; 48us; 1us; 32768us; 40us; 15us; 2us; 16395us; 17us; 16us; 22us; 38us; 1us; 32768us; 41us; 17us; 2us; 32768us; 44us; 47us; 45us; 48us; 1us; 32768us; 40us; 19us; 1us; 16395us; 22us; 38us; 1us; 16392us; 16us; 27us; 0us; 16390us; 1us; 16392us; 16us; 27us; 0us; 16391us; 1us; 32768us; 40us; 25us; 1us; 16392us; 16us; 27us; 0us; 16393us; 1us; 32768us; 41us; 28us; 2us; 32768us; 44us; 47us; 45us; 48us; 1us; 32768us; 40us; 30us; 3us; 16398us; 19us; 67us; 43us; 49us; 45us; 64us; 1us; 32768us; 15us; 32us; 1us; 32768us; 41us; 33us; 2us; 32768us; 44us; 47us; 45us; 48us; 0us; 16394us; 1us; 32768us; 40us; 36us; 1us; 16395us; 22us; 38us; 0us; 16396us; 1us; 32768us; 37us; 39us; 1us; 32768us; 45us; 40us; 1us; 32768us; 42us; 41us; 1us; 32768us; 45us; 42us; 1us; 32768us; 38us; 43us; 0us; 16397us; 1us; 32768us; 40us; 45us; 3us; 16398us; 19us; 67us; 43us; 49us; 45us; 64us; 0us; 16399us; 0us; 16400us; 0us; 16401us; 1us; 32768us; 37us; 50us; 1us; 32768us; 44us; 51us; 1us; 32768us; 42us; 52us; 1us; 32768us; 47us; 53us; 1us; 32768us; 38us; 54us; 2us; 32768us; 19us; 58us; 45us; 55us; 1us; 32768us; 20us; 56us; 5us; 32768us; 21us; 109us; 36us; 74us; 37us; 77us; 44us; 73us; 45us; 76us; 5us; 16402us; 32us; 108us; 33us; 107us; 34us; 106us; 35us; 104us; 36us; 105us; 1us; 32768us; 37us; 59us; 6us; 32768us; 21us; 109us; 31us; 118us; 36us; 74us; 37us; 78us; 44us; 73us; 45us; 76us; 3us; 32768us; 23us; 125us; 24us; 126us; 38us; 61us; 0us; 16403us; 12us; 32768us; 25us; 116us; 26us; 115us; 27us; 113us; 28us; 114us; 29us; 112us; 30us; 117us; 32us; 108us; 33us; 107us; 34us; 106us; 35us; 104us; 36us; 105us; 38us; 63us; 0us; 16404us; 1us; 32768us; 20us; 65us; 5us; 32768us; 21us; 109us; 36us; 74us; 37us; 77us; 44us; 73us; 45us; 76us; 5us; 16405us; 32us; 108us; 33us; 107us; 34us; 106us; 35us; 104us; 36us; 105us; 1us; 32768us; 37us; 68us; 6us; 32768us; 21us; 109us; 31us; 118us; 36us; 74us; 37us; 78us; 44us; 73us; 45us; 76us; 3us; 32768us; 23us; 125us; 24us; 126us; 38us; 70us; 0us; 16406us; 12us; 32768us; 25us; 116us; 26us; 115us; 27us; 113us; 28us; 114us; 29us; 112us; 30us; 117us; 32us; 108us; 33us; 107us; 34us; 106us; 35us; 104us; 36us; 105us; 38us; 72us; 0us; 16407us; 0us; 16408us; 5us; 32768us; 21us; 109us; 36us; 74us; 37us; 77us; 44us; 73us; 45us; 76us; 0us; 16409us; 0us; 16410us; 5us; 32768us; 21us; 109us; 36us; 74us; 37us; 77us; 44us; 73us; 45us; 76us; 6us; 32768us; 21us; 109us; 31us; 118us; 36us; 74us; 37us; 78us; 44us; 73us; 45us; 76us; 12us; 32768us; 0us; 153us; 1us; 156us; 2us; 159us; 3us; 162us; 4us; 168us; 5us; 135us; 6us; 137us; 21us; 109us; 36us; 74us; 37us; 79us; 44us; 73us; 45us; 76us; 14us; 32768us; 7us; 197us; 8us; 200us; 9us; 203us; 10us; 209us; 11us; 212us; 12us; 215us; 13us; 218us; 14us; 224us; 21us; 109us; 31us; 228us; 36us; 74us; 37us; 80us; 44us; 73us; 45us; 76us; 6us; 32768us; 32us; 108us; 33us; 107us; 34us; 106us; 35us; 104us; 36us; 105us; 38us; 84us; 12us; 32768us; 25us; 116us; 26us; 115us; 27us; 113us; 28us; 114us; 29us; 112us; 30us; 117us; 32us; 108us; 33us; 107us; 34us; 106us; 35us; 104us; 36us; 105us; 38us; 84us; 12us; 32768us; 25us; 132us; 26us; 131us; 27us; 129us; 28us; 130us; 29us; 128us; 30us; 133us; 32us; 108us; 33us; 107us; 34us; 106us; 35us; 104us; 36us; 105us; 38us; 84us; 0us; 16411us; 3us; 16412us; 32us; 108us; 33us; 107us; 34us; 106us; 3us; 16413us; 32us; 108us; 33us; 107us; 34us; 106us; 0us; 16414us; 0us; 16415us; 0us; 16416us; 11us; 32768us; 25us; 116us; 26us; 115us; 27us; 113us; 28us; 114us; 29us; 112us; 30us; 117us; 32us; 108us; 33us; 107us; 34us; 106us; 35us; 104us; 36us; 105us; 5us; 16418us; 32us; 108us; 33us; 107us; 34us; 106us; 35us; 104us; 36us; 105us; 5us; 16419us; 32us; 108us; 33us; 107us; 34us; 106us; 35us; 104us; 36us; 105us; 5us; 16420us; 32us; 108us; 33us; 107us; 34us; 106us; 35us; 104us; 36us; 105us; 5us; 16421us; 32us; 108us; 33us; 107us; 34us; 106us; 35us; 104us; 36us; 105us; 5us; 16422us; 32us; 108us; 33us; 107us; 34us; 106us; 35us; 104us; 36us; 105us; 5us; 16423us; 32us; 108us; 33us; 107us; 34us; 106us; 35us; 104us; 36us; 105us; 11us; 32768us; 25us; 132us; 26us; 131us; 27us; 129us; 28us; 130us; 29us; 128us; 30us; 133us; 32us; 108us; 33us; 107us; 34us; 106us; 35us; 104us; 36us; 105us; 5us; 16428us; 32us; 108us; 33us; 107us; 34us; 106us; 35us; 104us; 36us; 105us; 5us; 16429us; 32us; 108us; 33us; 107us; 34us; 106us; 35us; 104us; 36us; 105us; 5us; 16430us; 32us; 108us; 33us; 107us; 34us; 106us; 35us; 104us; 36us; 105us; 5us; 16431us; 32us; 108us; 33us; 107us; 34us; 106us; 35us; 104us; 36us; 105us; 5us; 16432us; 32us; 108us; 33us; 107us; 34us; 106us; 35us; 104us; 36us; 105us; 5us; 16433us; 32us; 108us; 33us; 107us; 34us; 106us; 35us; 104us; 36us; 105us; 5us; 32768us; 21us; 109us; 36us; 74us; 37us; 77us; 44us; 73us; 45us; 76us; 5us; 32768us; 21us; 109us; 36us; 74us; 37us; 77us; 44us; 73us; 45us; 76us; 5us; 32768us; 21us; 109us; 36us; 74us; 37us; 77us; 44us; 73us; 45us; 76us; 5us; 32768us; 21us; 109us; 36us; 74us; 37us; 77us; 44us; 73us; 45us; 76us; 5us; 32768us; 21us; 109us; 36us; 74us; 37us; 77us; 44us; 73us; 45us; 76us; 1us; 32768us; 37us; 110us; 1us; 32768us; 38us; 111us; 0us; 16417us; 5us; 32768us; 21us; 109us; 36us; 74us; 37us; 77us; 44us; 73us; 45us; 76us; 5us; 32768us; 21us; 109us; 36us; 74us; 37us; 77us; 44us; 73us; 45us; 76us; 5us; 32768us; 21us; 109us; 36us; 74us; 37us; 77us; 44us; 73us; 45us; 76us; 5us; 32768us; 21us; 109us; 36us; 74us; 37us; 77us; 44us; 73us; 45us; 76us; 5us; 32768us; 21us; 109us; 36us; 74us; 37us; 77us; 44us; 73us; 45us; 76us; 5us; 32768us; 21us; 109us; 36us; 74us; 37us; 77us; 44us; 73us; 45us; 76us; 6us; 32768us; 21us; 109us; 31us; 118us; 36us; 74us; 37us; 78us; 44us; 73us; 45us; 76us; 0us; 16424us; 0us; 16425us; 1us; 16426us; 23us; 125us; 3us; 32768us; 23us; 125us; 24us; 126us; 38us; 127us; 3us; 32768us; 23us; 125us; 24us; 126us; 42us; 230us; 3us; 32768us; 23us; 125us; 24us; 126us; 38us; 231us; 6us; 32768us; 21us; 109us; 31us; 118us; 36us; 74us; 37us; 78us; 44us; 73us; 45us; 76us; 6us; 32768us; 21us; 109us; 31us; 118us; 36us; 74us; 37us; 78us; 44us; 73us; 45us; 76us; 0us; 16427us; 5us; 32768us; 21us; 109us; 36us; 74us; 37us; 77us; 44us; 73us; 45us; 76us; 5us; 32768us; 21us; 109us; 36us; 74us; 37us; 77us; 44us; 73us; 45us; 76us; 5us; 32768us; 21us; 109us; 36us; 74us; 37us; 77us; 44us; 73us; 45us; 76us; 5us; 32768us; 21us; 109us; 36us; 74us; 37us; 77us; 44us; 73us; 45us; 76us; 5us; 32768us; 21us; 109us; 36us; 74us; 37us; 77us; 44us; 73us; 45us; 76us; 5us; 32768us; 21us; 109us; 36us; 74us; 37us; 77us; 44us; 73us; 45us; 76us; 0us; 16434us; 6us; 32768us; 0us; 153us; 1us; 156us; 2us; 159us; 3us; 162us; 4us; 168us; 37us; 174us; 0us; 16435us; 6us; 32768us; 0us; 153us; 1us; 156us; 2us; 159us; 3us; 162us; 4us; 168us; 37us; 174us; 0us; 16436us; 0us; 16437us; 2us; 32768us; 23us; 149us; 24us; 150us; 1us; 16438us; 23us; 149us; 3us; 32768us; 23us; 149us; 24us; 150us; 38us; 155us; 3us; 32768us; 23us; 149us; 24us; 150us; 38us; 158us; 3us; 32768us; 23us; 149us; 24us; 150us; 38us; 161us; 3us; 32768us; 23us; 149us; 24us; 150us; 38us; 164us; 3us; 32768us; 23us; 149us; 24us; 150us; 38us; 167us; 3us; 32768us; 23us; 149us; 24us; 150us; 38us; 170us; 3us; 32768us; 23us; 149us; 24us; 150us; 38us; 173us; 12us; 32768us; 0us; 153us; 1us; 156us; 2us; 159us; 3us; 162us; 4us; 168us; 5us; 135us; 6us; 137us; 21us; 109us; 36us; 74us; 37us; 79us; 44us; 73us; 45us; 76us; 12us; 32768us; 0us; 153us; 1us; 156us; 2us; 159us; 3us; 162us; 4us; 168us; 5us; 135us; 6us; 137us; 21us; 109us; 36us; 74us; 37us; 79us; 44us; 73us; 45us; 76us; 1us; 16447us; 38us; 152us; 0us; 16439us; 1us; 32768us; 37us; 154us; 12us; 32768us; 0us; 153us; 1us; 156us; 2us; 159us; 3us; 162us; 4us; 168us; 5us; 135us; 6us; 137us; 21us; 109us; 36us; 74us; 37us; 79us; 44us; 73us; 45us; 76us; 0us; 16440us; 1us; 32768us; 37us; 157us; 12us; 32768us; 0us; 153us; 1us; 156us; 2us; 159us; 3us; 162us; 4us; 168us; 5us; 135us; 6us; 137us; 21us; 109us; 36us; 74us; 37us; 79us; 44us; 73us; 45us; 76us; 0us; 16441us; 1us; 32768us; 37us; 160us; 12us; 32768us; 0us; 153us; 1us; 156us; 2us; 159us; 3us; 162us; 4us; 168us; 5us; 135us; 6us; 137us; 21us; 109us; 36us; 74us; 37us; 79us; 44us; 73us; 45us; 76us; 0us; 16442us; 1us; 32768us; 37us; 163us; 12us; 32768us; 0us; 153us; 1us; 156us; 2us; 159us; 3us; 162us; 4us; 168us; 5us; 135us; 6us; 137us; 21us; 109us; 36us; 74us; 37us; 79us; 44us; 73us; 45us; 76us; 1us; 32768us; 42us; 165us; 1us; 32768us; 37us; 166us; 12us; 32768us; 0us; 153us; 1us; 156us; 2us; 159us; 3us; 162us; 4us; 168us; 5us; 135us; 6us; 137us; 21us; 109us; 36us; 74us; 37us; 79us; 44us; 73us; 45us; 76us; 0us; 16443us; 1us; 32768us; 37us; 169us; 12us; 32768us; 0us; 153us; 1us; 156us; 2us; 159us; 3us; 162us; 4us; 168us; 5us; 135us; 6us; 137us; 21us; 109us; 36us; 74us; 37us; 79us; 44us; 73us; 45us; 76us; 1us; 32768us; 42us; 171us; 1us; 32768us; 37us; 172us; 12us; 32768us; 0us; 153us; 1us; 156us; 2us; 159us; 3us; 162us; 4us; 168us; 5us; 135us; 6us; 137us; 21us; 109us; 36us; 74us; 37us; 79us; 44us; 73us; 45us; 76us; 0us; 16444us; 6us; 32768us; 0us; 153us; 1us; 156us; 2us; 159us; 3us; 162us; 4us; 168us; 37us; 174us; 1us; 32768us; 38us; 177us; 1us; 16446us; 38us; 177us; 0us; 16445us; 0us; 16446us; 0us; 16447us; 0us; 16448us; 0us; 16449us; 1us; 16450us; 23us; 195us; 3us; 32768us; 23us; 195us; 24us; 196us; 38us; 199us; 3us; 32768us; 23us; 195us; 24us; 196us; 38us; 202us; 3us; 32768us; 23us; 195us; 24us; 196us; 38us; 205us; 3us; 32768us; 23us; 195us; 24us; 196us; 38us; 208us; 3us; 32768us; 23us; 195us; 24us; 196us; 38us; 211us; 3us; 32768us; 23us; 195us; 24us; 196us; 38us; 214us; 3us; 32768us; 23us; 195us; 24us; 196us; 38us; 217us; 3us; 32768us; 23us; 195us; 24us; 196us; 38us; 220us; 3us; 32768us; 23us; 195us; 24us; 196us; 38us; 223us; 3us; 32768us; 23us; 195us; 24us; 196us; 38us; 226us; 3us; 32768us; 23us; 195us; 24us; 196us; 38us; 227us; 0us; 16460us; 14us; 32768us; 7us; 197us; 8us; 200us; 9us; 203us; 10us; 209us; 11us; 212us; 12us; 215us; 13us; 218us; 14us; 224us; 21us; 109us; 31us; 228us; 36us; 74us; 37us; 80us; 44us; 73us; 45us; 76us; 14us; 32768us; 7us; 197us; 8us; 200us; 9us; 203us; 10us; 209us; 11us; 212us; 12us; 215us; 13us; 218us; 14us; 224us; 21us; 109us; 31us; 228us; 36us; 74us; 37us; 80us; 44us; 73us; 45us; 76us; 1us; 32768us; 37us; 198us; 14us; 32768us; 7us; 197us; 8us; 200us; 9us; 203us; 10us; 209us; 11us; 212us; 12us; 215us; 13us; 218us; 14us; 224us; 21us; 109us; 31us; 228us; 36us; 74us; 37us; 80us; 44us; 73us; 45us; 76us; 0us; 16451us; 1us; 32768us; 37us; 201us; 14us; 32768us; 7us; 197us; 8us; 200us; 9us; 203us; 10us; 209us; 11us; 212us; 12us; 215us; 13us; 218us; 14us; 224us; 21us; 109us; 31us; 228us; 36us; 74us; 37us; 80us; 44us; 73us; 45us; 76us; 0us; 16452us; 1us; 32768us; 37us; 204us; 14us; 32768us; 7us; 197us; 8us; 200us; 9us; 203us; 10us; 209us; 11us; 212us; 12us; 215us; 13us; 218us; 14us; 224us; 21us; 109us; 31us; 228us; 36us; 74us; 37us; 80us; 44us; 73us; 45us; 76us; 1us; 32768us; 42us; 206us; 1us; 32768us; 37us; 207us; 14us; 32768us; 7us; 197us; 8us; 200us; 9us; 203us; 10us; 209us; 11us; 212us; 12us; 215us; 13us; 218us; 14us; 224us; 21us; 109us; 31us; 228us; 36us; 74us; 37us; 80us; 44us; 73us; 45us; 76us; 0us; 16453us; 1us; 32768us; 37us; 210us; 14us; 32768us; 7us; 197us; 8us; 200us; 9us; 203us; 10us; 209us; 11us; 212us; 12us; 215us; 13us; 218us; 14us; 224us; 21us; 109us; 31us; 228us; 36us; 74us; 37us; 80us; 44us; 73us; 45us; 76us; 0us; 16454us; 1us; 32768us; 37us; 213us; 14us; 32768us; 7us; 197us; 8us; 200us; 9us; 203us; 10us; 209us; 11us; 212us; 12us; 215us; 13us; 218us; 14us; 224us; 21us; 109us; 31us; 228us; 36us; 74us; 37us; 80us; 44us; 73us; 45us; 76us; 0us; 16455us; 1us; 32768us; 37us; 216us; 14us; 32768us; 7us; 197us; 8us; 200us; 9us; 203us; 10us; 209us; 11us; 212us; 12us; 215us; 13us; 218us; 14us; 224us; 21us; 109us; 31us; 228us; 36us; 74us; 37us; 80us; 44us; 73us; 45us; 76us; 0us; 16456us; 1us; 32768us; 37us; 219us; 14us; 32768us; 7us; 197us; 8us; 200us; 9us; 203us; 10us; 209us; 11us; 212us; 12us; 215us; 13us; 218us; 14us; 224us; 21us; 109us; 31us; 228us; 36us; 74us; 37us; 80us; 44us; 73us; 45us; 76us; 1us; 32768us; 42us; 221us; 1us; 32768us; 37us; 222us; 14us; 32768us; 7us; 197us; 8us; 200us; 9us; 203us; 10us; 209us; 11us; 212us; 12us; 215us; 13us; 218us; 14us; 224us; 21us; 109us; 31us; 228us; 36us; 74us; 37us; 80us; 44us; 73us; 45us; 76us; 0us; 16457us; 1us; 32768us; 37us; 225us; 14us; 32768us; 7us; 197us; 8us; 200us; 9us; 203us; 10us; 209us; 11us; 212us; 12us; 215us; 13us; 218us; 14us; 224us; 21us; 109us; 31us; 228us; 36us; 74us; 37us; 80us; 44us; 73us; 45us; 76us; 0us; 16458us; 0us; 16459us; 14us; 32768us; 7us; 197us; 8us; 200us; 9us; 203us; 10us; 209us; 11us; 212us; 12us; 215us; 13us; 218us; 14us; 224us; 21us; 109us; 31us; 228us; 36us; 74us; 37us; 80us; 44us; 73us; 45us; 76us; 6us; 32768us; 21us; 109us; 31us; 118us; 36us; 74us; 37us; 78us; 44us; 73us; 45us; 76us; 6us; 32768us; 21us; 109us; 31us; 118us; 36us; 74us; 37us; 78us; 44us; 73us; 45us; 76us; 0us; 16461us; |]
let _fsyacc_actionTableRowOffsets = [|0us; 2us; 3us; 10us; 11us; 24us; 27us; 40us; 43us; 58us; 61us; 63us; 64us; 66us; 69us; 71us; 74us; 76us; 79us; 81us; 83us; 85us; 86us; 88us; 89us; 91us; 93us; 94us; 96us; 99us; 101us; 105us; 107us; 109us; 112us; 113us; 115us; 117us; 118us; 120us; 122us; 124us; 126us; 128us; 129us; 131us; 135us; 136us; 137us; 138us; 140us; 142us; 144us; 146us; 148us; 151us; 153us; 159us; 165us; 167us; 174us; 178us; 179us; 192us; 193us; 195us; 201us; 207us; 209us; 216us; 220us; 221us; 234us; 235us; 236us; 242us; 243us; 244us; 250us; 257us; 270us; 285us; 292us; 305us; 318us; 319us; 323us; 327us; 328us; 329us; 330us; 342us; 348us; 354us; 360us; 366us; 372us; 378us; 390us; 396us; 402us; 408us; 414us; 420us; 426us; 432us; 438us; 444us; 450us; 456us; 458us; 460us; 461us; 467us; 473us; 479us; 485us; 491us; 497us; 504us; 505us; 506us; 508us; 512us; 516us; 520us; 527us; 534us; 535us; 541us; 547us; 553us; 559us; 565us; 571us; 572us; 579us; 580us; 587us; 588us; 589us; 592us; 594us; 598us; 602us; 606us; 610us; 614us; 618us; 622us; 635us; 648us; 650us; 651us; 653us; 666us; 667us; 669us; 682us; 683us; 685us; 698us; 699us; 701us; 714us; 716us; 718us; 731us; 732us; 734us; 747us; 749us; 751us; 764us; 765us; 772us; 774us; 776us; 777us; 778us; 779us; 780us; 781us; 783us; 787us; 791us; 795us; 799us; 803us; 807us; 811us; 815us; 819us; 823us; 827us; 828us; 843us; 858us; 860us; 875us; 876us; 878us; 893us; 894us; 896us; 911us; 913us; 915us; 930us; 931us; 933us; 948us; 949us; 951us; 966us; 967us; 969us; 984us; 985us; 987us; 1002us; 1004us; 1006us; 1021us; 1022us; 1024us; 1039us; 1040us; 1041us; 1056us; 1063us; 1070us; |]
let _fsyacc_reductionSymbolCounts = [|1us; 1us; 1us; 1us; 1us; 1us; 10us; 6us; 0us; 3us; 8us; 0us; 3us; 6us; 0us; 3us; 1us; 1us; 9us; 10us; 10us; 3us; 4us; 4us; 1us; 2us; 1us; 3us; 3us; 3us; 3us; 3us; 3us; 3us; 3us; 3us; 3us; 3us; 3us; 3us; 2us; 3us; 3us; 3us; 3us; 3us; 3us; 3us; 3us; 3us; 1us; 2us; 2us; 3us; 3us; 3us; 4us; 4us; 4us; 8us; 8us; 3us; 1us; 1us; 1us; 3us; 3us; 4us; 4us; 8us; 4us; 4us; 4us; 8us; 4us; 3us; 2us; 5us; 1us; 2us; |]
let _fsyacc_productionToNonTerminalTable = [|0us; 1us; 2us; 3us; 4us; 5us; 6us; 6us; 7us; 7us; 8us; 9us; 9us; 10us; 11us; 11us; 12us; 12us; 13us; 13us; 13us; 13us; 13us; 13us; 14us; 14us; 14us; 14us; 14us; 14us; 14us; 14us; 14us; 14us; 15us; 15us; 15us; 15us; 15us; 15us; 15us; 15us; 15us; 15us; 16us; 16us; 16us; 16us; 16us; 16us; 17us; 17us; 17us; 17us; 17us; 17us; 18us; 18us; 18us; 18us; 18us; 18us; 19us; 19us; 20us; 20us; 20us; 20us; 20us; 20us; 20us; 20us; 20us; 20us; 20us; 20us; 20us; 21us; 22us; 22us; |]
let _fsyacc_immediateActions = [|65535us; 49152us; 65535us; 49152us; 65535us; 65535us; 65535us; 65535us; 65535us; 65535us; 65535us; 49152us; 65535us; 65535us; 65535us; 65535us; 65535us; 65535us; 65535us; 65535us; 65535us; 16390us; 65535us; 16391us; 65535us; 65535us; 16393us; 65535us; 65535us; 65535us; 65535us; 65535us; 65535us; 65535us; 16394us; 65535us; 65535us; 16396us; 65535us; 65535us; 65535us; 65535us; 65535us; 16397us; 65535us; 65535us; 16399us; 16400us; 16401us; 65535us; 65535us; 65535us; 65535us; 65535us; 65535us; 65535us; 65535us; 65535us; 65535us; 65535us; 65535us; 16403us; 65535us; 16404us; 65535us; 65535us; 65535us; 65535us; 65535us; 65535us; 16406us; 65535us; 16407us; 16408us; 65535us; 65535us; 16410us; 65535us; 65535us; 65535us; 65535us; 65535us; 65535us; 65535us; 16411us; 65535us; 65535us; 65535us; 65535us; 65535us; 65535us; 65535us; 65535us; 65535us; 65535us; 65535us; 65535us; 65535us; 65535us; 65535us; 65535us; 65535us; 65535us; 65535us; 65535us; 65535us; 65535us; 65535us; 65535us; 65535us; 65535us; 16417us; 65535us; 65535us; 65535us; 65535us; 65535us; 65535us; 65535us; 65535us; 65535us; 65535us; 65535us; 65535us; 65535us; 65535us; 65535us; 16427us; 65535us; 65535us; 65535us; 65535us; 65535us; 65535us; 16434us; 65535us; 16435us; 65535us; 16436us; 65535us; 65535us; 65535us; 65535us; 65535us; 65535us; 65535us; 65535us; 65535us; 65535us; 65535us; 65535us; 65535us; 16439us; 65535us; 65535us; 16440us; 65535us; 65535us; 16441us; 65535us; 65535us; 16442us; 65535us; 65535us; 65535us; 65535us; 65535us; 16443us; 65535us; 65535us; 65535us; 65535us; 65535us; 16444us; 65535us; 65535us; 65535us; 16445us; 16446us; 16447us; 16448us; 65535us; 65535us; 65535us; 65535us; 65535us; 65535us; 65535us; 65535us; 65535us; 65535us; 65535us; 65535us; 65535us; 65535us; 65535us; 65535us; 65535us; 65535us; 16451us; 65535us; 65535us; 16452us; 65535us; 65535us; 65535us; 65535us; 65535us; 16453us; 65535us; 65535us; 16454us; 65535us; 65535us; 16455us; 65535us; 65535us; 16456us; 65535us; 65535us; 65535us; 65535us; 65535us; 16457us; 65535us; 65535us; 16458us; 16459us; 65535us; 65535us; 65535us; 16461us; |]
let _fsyacc_reductions ()  =    [| 
# 487 "absparse.fs"
        (fun (parseState : Microsoft.FSharp.Text.Parsing.IParseState) ->
            let _1 = (let data = parseState.GetInput(1) in (Microsoft.FSharp.Core.Operators.unbox data : Formula.formula * Formula.formula)) in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
                      raise (Microsoft.FSharp.Text.Parsing.Accept(Microsoft.FSharp.Core.Operators.box _1))
                   )
                 : '_startFairness_constraint));
# 496 "absparse.fs"
        (fun (parseState : Microsoft.FSharp.Text.Parsing.IParseState) ->
            let _1 = (let data = parseState.GetInput(1) in (Microsoft.FSharp.Core.Operators.unbox data : CTL.Path_Formula)) in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
                      raise (Microsoft.FSharp.Text.Parsing.Accept(Microsoft.FSharp.Core.Operators.box _1))
                   )
                 : '_startPath_formula));
# 505 "absparse.fs"
        (fun (parseState : Microsoft.FSharp.Text.Parsing.IParseState) ->
            let _1 = (let data = parseState.GetInput(1) in (Microsoft.FSharp.Core.Operators.unbox data : CTL.State_Formula)) in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
                      raise (Microsoft.FSharp.Text.Parsing.Accept(Microsoft.FSharp.Core.Operators.box _1))
                   )
                 : '_startState_formula));
# 514 "absparse.fs"
        (fun (parseState : Microsoft.FSharp.Text.Parsing.IParseState) ->
            let _1 = (let data = parseState.GetInput(1) in (Microsoft.FSharp.Core.Operators.unbox data : CTL.CTLStar_Formula)) in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
                      raise (Microsoft.FSharp.Text.Parsing.Accept(Microsoft.FSharp.Core.Operators.box _1))
                   )
                 : '_startCTLStar_formula));
# 523 "absparse.fs"
        (fun (parseState : Microsoft.FSharp.Text.Parsing.IParseState) ->
            let _1 = (let data = parseState.GetInput(1) in (Microsoft.FSharp.Core.Operators.unbox data : CTL.CTL_Formula)) in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
                      raise (Microsoft.FSharp.Text.Parsing.Accept(Microsoft.FSharp.Core.Operators.box _1))
                   )
                 : '_startCTL_formula));
# 532 "absparse.fs"
        (fun (parseState : Microsoft.FSharp.Text.Parsing.IParseState) ->
            let _1 = (let data = parseState.GetInput(1) in (Microsoft.FSharp.Core.Operators.unbox data : parsedLoc * parsedLoc * (parsedLoc * Programs.Command list * parsedLoc) list * (Var.var * Var.var) list * bool)) in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
                      raise (Microsoft.FSharp.Text.Parsing.Accept(Microsoft.FSharp.Core.Operators.box _1))
                   )
                 : '_startprogram));
# 541 "absparse.fs"
        (fun (parseState : Microsoft.FSharp.Text.Parsing.IParseState) ->
            let _3 = (let data = parseState.GetInput(3) in (Microsoft.FSharp.Core.Operators.unbox data : parsedLoc)) in
            let _7 = (let data = parseState.GetInput(7) in (Microsoft.FSharp.Core.Operators.unbox data : parsedLoc)) in
            let _9 = (let data = parseState.GetInput(9) in (Microsoft.FSharp.Core.Operators.unbox data : 'shadows)) in
            let _10 = (let data = parseState.GetInput(10) in (Microsoft.FSharp.Core.Operators.unbox data : (parsedLoc * Programs.Command list * parsedLoc) list)) in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
# 93 "absparse.fsy"
                               (_3,_7,_10,_9,!incomplete_abstraction) 
                   )
# 93 "absparse.fsy"
                 : parsedLoc * parsedLoc * (parsedLoc * Programs.Command list * parsedLoc) list * (Var.var * Var.var) list * bool));
# 555 "absparse.fs"
        (fun (parseState : Microsoft.FSharp.Text.Parsing.IParseState) ->
            let _3 = (let data = parseState.GetInput(3) in (Microsoft.FSharp.Core.Operators.unbox data : parsedLoc)) in
            let _5 = (let data = parseState.GetInput(5) in (Microsoft.FSharp.Core.Operators.unbox data : 'shadows)) in
            let _6 = (let data = parseState.GetInput(6) in (Microsoft.FSharp.Core.Operators.unbox data : (parsedLoc * Programs.Command list * parsedLoc) list)) in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
# 95 "absparse.fsy"
                               (_3,NumLoc -1,_6,_5,!incomplete_abstraction) 
                   )
# 95 "absparse.fsy"
                 : parsedLoc * parsedLoc * (parsedLoc * Programs.Command list * parsedLoc) list * (Var.var * Var.var) list * bool));
# 568 "absparse.fs"
        (fun (parseState : Microsoft.FSharp.Text.Parsing.IParseState) ->
            Microsoft.FSharp.Core.Operators.box
                (
                   (
# 99 "absparse.fsy"
                                 [] 
                   )
# 99 "absparse.fsy"
                 : (parsedLoc * Programs.Command list * parsedLoc) list));
# 578 "absparse.fs"
        (fun (parseState : Microsoft.FSharp.Text.Parsing.IParseState) ->
            let _1 = (let data = parseState.GetInput(1) in (Microsoft.FSharp.Core.Operators.unbox data : parsedLoc * Programs.Command list * parsedLoc)) in
            let _3 = (let data = parseState.GetInput(3) in (Microsoft.FSharp.Core.Operators.unbox data : (parsedLoc * Programs.Command list * parsedLoc) list)) in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
# 101 "absparse.fsy"
                                 _1::_3 
                   )
# 101 "absparse.fsy"
                 : (parsedLoc * Programs.Command list * parsedLoc) list));
# 590 "absparse.fs"
        (fun (parseState : Microsoft.FSharp.Text.Parsing.IParseState) ->
            let _3 = (let data = parseState.GetInput(3) in (Microsoft.FSharp.Core.Operators.unbox data : parsedLoc)) in
            let _5 = (let data = parseState.GetInput(5) in (Microsoft.FSharp.Core.Operators.unbox data : Programs.Command list)) in
            let _8 = (let data = parseState.GetInput(8) in (Microsoft.FSharp.Core.Operators.unbox data : parsedLoc)) in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
# 104 "absparse.fsy"
                               (_3,_5,_8) 
                   )
# 104 "absparse.fsy"
                 : parsedLoc * Programs.Command list * parsedLoc));
# 603 "absparse.fs"
        (fun (parseState : Microsoft.FSharp.Text.Parsing.IParseState) ->
            Microsoft.FSharp.Core.Operators.box
                (
                   (
# 107 "absparse.fsy"
                                 [] 
                   )
# 107 "absparse.fsy"
                 : 'shadows));
# 613 "absparse.fs"
        (fun (parseState : Microsoft.FSharp.Text.Parsing.IParseState) ->
            let _1 = (let data = parseState.GetInput(1) in (Microsoft.FSharp.Core.Operators.unbox data : 'shadow)) in
            let _3 = (let data = parseState.GetInput(3) in (Microsoft.FSharp.Core.Operators.unbox data : 'shadows)) in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
# 109 "absparse.fsy"
                                 _1::_3 
                   )
# 109 "absparse.fsy"
                 : 'shadows));
# 625 "absparse.fs"
        (fun (parseState : Microsoft.FSharp.Text.Parsing.IParseState) ->
            let _3 = (let data = parseState.GetInput(3) in (Microsoft.FSharp.Core.Operators.unbox data : string)) in
            let _5 = (let data = parseState.GetInput(5) in (Microsoft.FSharp.Core.Operators.unbox data : string)) in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
# 112 "absparse.fsy"
                               (normalize_var _3, normalize_var _5) 
                   )
# 112 "absparse.fsy"
                 : 'shadow));
# 637 "absparse.fs"
        (fun (parseState : Microsoft.FSharp.Text.Parsing.IParseState) ->
            Microsoft.FSharp.Core.Operators.box
                (
                   (
# 115 "absparse.fsy"
                                 [] 
                   )
# 115 "absparse.fsy"
                 : Programs.Command list));
# 647 "absparse.fs"
        (fun (parseState : Microsoft.FSharp.Text.Parsing.IParseState) ->
            let _1 = (let data = parseState.GetInput(1) in (Microsoft.FSharp.Core.Operators.unbox data : Programs.Command)) in
            let _3 = (let data = parseState.GetInput(3) in (Microsoft.FSharp.Core.Operators.unbox data : Programs.Command list)) in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
# 117 "absparse.fsy"
                                 _1::_3 
                   )
# 117 "absparse.fsy"
                 : Programs.Command list));
# 659 "absparse.fs"
        (fun (parseState : Microsoft.FSharp.Text.Parsing.IParseState) ->
            let _1 = (let data = parseState.GetInput(1) in (Microsoft.FSharp.Core.Operators.unbox data : bigint)) in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
# 121 "absparse.fsy"
                         NumLoc(int _1) 
                   )
# 121 "absparse.fsy"
                 : parsedLoc));
# 670 "absparse.fs"
        (fun (parseState : Microsoft.FSharp.Text.Parsing.IParseState) ->
            let _1 = (let data = parseState.GetInput(1) in (Microsoft.FSharp.Core.Operators.unbox data : string)) in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
# 123 "absparse.fsy"
                         NameLoc(_1) 
                   )
# 123 "absparse.fsy"
                 : parsedLoc));
# 681 "absparse.fs"
        (fun (parseState : Microsoft.FSharp.Text.Parsing.IParseState) ->
            let _3 = (let data = parseState.GetInput(3) in (Microsoft.FSharp.Core.Operators.unbox data : bigint)) in
            let _5 = (let data = parseState.GetInput(5) in (Microsoft.FSharp.Core.Operators.unbox data : string)) in
            let _7 = (let data = parseState.GetInput(7) in (Microsoft.FSharp.Core.Operators.unbox data : string)) in
            let _9 = (let data = parseState.GetInput(9) in (Microsoft.FSharp.Core.Operators.unbox data : Term.term)) in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
# 127 "absparse.fsy"
                                   if Term.contains_nondet _9 then 
                                       Programs.Assign(Some(int _3,_5),normalize_var (_7),Term.Nondet)
                                   else 
                                       Programs.Assign(Some(int _3,_5),normalize_var (_7),_9) 
                                 
                   )
# 127 "absparse.fsy"
                 : Programs.Command));
# 699 "absparse.fs"
        (fun (parseState : Microsoft.FSharp.Text.Parsing.IParseState) ->
            let _3 = (let data = parseState.GetInput(3) in (Microsoft.FSharp.Core.Operators.unbox data : bigint)) in
            let _5 = (let data = parseState.GetInput(5) in (Microsoft.FSharp.Core.Operators.unbox data : string)) in
            let _9 = (let data = parseState.GetInput(9) in (Microsoft.FSharp.Core.Operators.unbox data : Formula.formula)) in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
# 133 "absparse.fsy"
                                   Programs.Assume(Some(int _3,_5),_9) 
                   )
# 133 "absparse.fsy"
                 : Programs.Command));
# 712 "absparse.fs"
        (fun (parseState : Microsoft.FSharp.Text.Parsing.IParseState) ->
            let _3 = (let data = parseState.GetInput(3) in (Microsoft.FSharp.Core.Operators.unbox data : bigint)) in
            let _5 = (let data = parseState.GetInput(5) in (Microsoft.FSharp.Core.Operators.unbox data : string)) in
            let _9 = (let data = parseState.GetInput(9) in (Microsoft.FSharp.Core.Operators.unbox data : Term.term)) in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
# 135 "absparse.fsy"
                                   if Term.contains_nondet _9 then
                                     Programs.Assume(Some(int _3,_5),Formula.Not(Formula.Eq(Term.Nondet,Term.constant 0))) 
                                   else
                                     Programs.Assume(Some(int _3,_5),Formula.Not(Formula.Eq(_9,Term.constant 0))) 
                                 
                   )
# 135 "absparse.fsy"
                 : Programs.Command));
# 729 "absparse.fs"
        (fun (parseState : Microsoft.FSharp.Text.Parsing.IParseState) ->
            let _1 = (let data = parseState.GetInput(1) in (Microsoft.FSharp.Core.Operators.unbox data : string)) in
            let _3 = (let data = parseState.GetInput(3) in (Microsoft.FSharp.Core.Operators.unbox data : Term.term)) in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
# 141 "absparse.fsy"
                                   if !annotate then
                                       Programs.Assign(Some(E.getLine(),E.getFilename()),normalize_var (_1),_3) 
                                   else 
                                       Programs.Assign(None,normalize_var (_1),_3) 
                                 
                   )
# 141 "absparse.fsy"
                 : Programs.Command));
# 745 "absparse.fs"
        (fun (parseState : Microsoft.FSharp.Text.Parsing.IParseState) ->
            let _3 = (let data = parseState.GetInput(3) in (Microsoft.FSharp.Core.Operators.unbox data : Formula.formula)) in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
# 147 "absparse.fsy"
                                   let pos = if !annotate then Some(E.getLine(),E.getFilename()) 
                                             else None
                                   in Programs.Assume(pos,_3) 
                                 
                   )
# 147 "absparse.fsy"
                 : Programs.Command));
# 759 "absparse.fs"
        (fun (parseState : Microsoft.FSharp.Text.Parsing.IParseState) ->
            let _3 = (let data = parseState.GetInput(3) in (Microsoft.FSharp.Core.Operators.unbox data : Term.term)) in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
# 152 "absparse.fsy"
                                   let pos = if !annotate then Some(E.getLine(),E.getFilename()) 
                                             else None
                                   in Programs.Assume(pos,Formula.Not(Formula.Eq(_3,Term.constant 0))) 
                                 
                   )
# 152 "absparse.fsy"
                 : Programs.Command));
# 773 "absparse.fs"
        (fun (parseState : Microsoft.FSharp.Text.Parsing.IParseState) ->
            let _1 = (let data = parseState.GetInput(1) in (Microsoft.FSharp.Core.Operators.unbox data : bigint)) in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
# 161 "absparse.fsy"
                                                       Term.Const(_1) 
                   )
# 161 "absparse.fsy"
                 : Term.term));
# 784 "absparse.fs"
        (fun (parseState : Microsoft.FSharp.Text.Parsing.IParseState) ->
            let _2 = (let data = parseState.GetInput(2) in (Microsoft.FSharp.Core.Operators.unbox data : Term.term)) in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
# 162 "absparse.fsy"
                                                          Term.Sub(Term.constant 0,_2) 
                   )
# 162 "absparse.fsy"
                 : Term.term));
# 795 "absparse.fs"
        (fun (parseState : Microsoft.FSharp.Text.Parsing.IParseState) ->
            let _1 = (let data = parseState.GetInput(1) in (Microsoft.FSharp.Core.Operators.unbox data : string)) in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
# 163 "absparse.fsy"
                                                       Term.Var(normalize_var  _1) 
                   )
# 163 "absparse.fsy"
                 : Term.term));
# 806 "absparse.fs"
        (fun (parseState : Microsoft.FSharp.Text.Parsing.IParseState) ->
            let _2 = (let data = parseState.GetInput(2) in (Microsoft.FSharp.Core.Operators.unbox data : Term.term)) in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
# 164 "absparse.fsy"
                                                       _2 
                   )
# 164 "absparse.fsy"
                 : Term.term));
# 817 "absparse.fs"
        (fun (parseState : Microsoft.FSharp.Text.Parsing.IParseState) ->
            let _1 = (let data = parseState.GetInput(1) in (Microsoft.FSharp.Core.Operators.unbox data : Term.term)) in
            let _3 = (let data = parseState.GetInput(3) in (Microsoft.FSharp.Core.Operators.unbox data : Term.term)) in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
# 165 "absparse.fsy"
                                                       Term.Add(_1,_3) 
                   )
# 165 "absparse.fsy"
                 : Term.term));
# 829 "absparse.fs"
        (fun (parseState : Microsoft.FSharp.Text.Parsing.IParseState) ->
            let _1 = (let data = parseState.GetInput(1) in (Microsoft.FSharp.Core.Operators.unbox data : Term.term)) in
            let _3 = (let data = parseState.GetInput(3) in (Microsoft.FSharp.Core.Operators.unbox data : Term.term)) in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
# 166 "absparse.fsy"
                                                   Term.Sub(_1,_3) 
                   )
# 166 "absparse.fsy"
                 : Term.term));
# 841 "absparse.fs"
        (fun (parseState : Microsoft.FSharp.Text.Parsing.IParseState) ->
            let _1 = (let data = parseState.GetInput(1) in (Microsoft.FSharp.Core.Operators.unbox data : Term.term)) in
            let _3 = (let data = parseState.GetInput(3) in (Microsoft.FSharp.Core.Operators.unbox data : Term.term)) in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
# 167 "absparse.fsy"
                                                   Term.Mul(_1,_3) 
                   )
# 167 "absparse.fsy"
                 : Term.term));
# 853 "absparse.fs"
        (fun (parseState : Microsoft.FSharp.Text.Parsing.IParseState) ->
            let _1 = (let data = parseState.GetInput(1) in (Microsoft.FSharp.Core.Operators.unbox data : Term.term)) in
            let _3 = (let data = parseState.GetInput(3) in (Microsoft.FSharp.Core.Operators.unbox data : Term.term)) in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
# 168 "absparse.fsy"
                                                   incomplete_abstraction := true; Term.Nondet 
                   )
# 168 "absparse.fsy"
                 : Term.term));
# 865 "absparse.fs"
        (fun (parseState : Microsoft.FSharp.Text.Parsing.IParseState) ->
            let _1 = (let data = parseState.GetInput(1) in (Microsoft.FSharp.Core.Operators.unbox data : Term.term)) in
            let _3 = (let data = parseState.GetInput(3) in (Microsoft.FSharp.Core.Operators.unbox data : Term.term)) in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
# 169 "absparse.fsy"
                                                   incomplete_abstraction := true; Term.Nondet 
                   )
# 169 "absparse.fsy"
                 : Term.term));
# 877 "absparse.fs"
        (fun (parseState : Microsoft.FSharp.Text.Parsing.IParseState) ->
            Microsoft.FSharp.Core.Operators.box
                (
                   (
# 170 "absparse.fsy"
                                                   Term.Nondet 
                   )
# 170 "absparse.fsy"
                 : Term.term));
# 887 "absparse.fs"
        (fun (parseState : Microsoft.FSharp.Text.Parsing.IParseState) ->
            let _1 = (let data = parseState.GetInput(1) in (Microsoft.FSharp.Core.Operators.unbox data : Term.term)) in
            let _3 = (let data = parseState.GetInput(3) in (Microsoft.FSharp.Core.Operators.unbox data : Term.term)) in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
# 174 "absparse.fsy"
                                          Formula.Lt(_1,_3) 
                   )
# 174 "absparse.fsy"
                 : Formula.formula));
# 899 "absparse.fs"
        (fun (parseState : Microsoft.FSharp.Text.Parsing.IParseState) ->
            let _1 = (let data = parseState.GetInput(1) in (Microsoft.FSharp.Core.Operators.unbox data : Term.term)) in
            let _3 = (let data = parseState.GetInput(3) in (Microsoft.FSharp.Core.Operators.unbox data : Term.term)) in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
# 175 "absparse.fsy"
                                          Formula.Gt(_1,_3) 
                   )
# 175 "absparse.fsy"
                 : Formula.formula));
# 911 "absparse.fs"
        (fun (parseState : Microsoft.FSharp.Text.Parsing.IParseState) ->
            let _1 = (let data = parseState.GetInput(1) in (Microsoft.FSharp.Core.Operators.unbox data : Term.term)) in
            let _3 = (let data = parseState.GetInput(3) in (Microsoft.FSharp.Core.Operators.unbox data : Term.term)) in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
# 176 "absparse.fsy"
                                          Formula.Le(_1,_3) 
                   )
# 176 "absparse.fsy"
                 : Formula.formula));
# 923 "absparse.fs"
        (fun (parseState : Microsoft.FSharp.Text.Parsing.IParseState) ->
            let _1 = (let data = parseState.GetInput(1) in (Microsoft.FSharp.Core.Operators.unbox data : Term.term)) in
            let _3 = (let data = parseState.GetInput(3) in (Microsoft.FSharp.Core.Operators.unbox data : Term.term)) in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
# 177 "absparse.fsy"
                                          Formula.Ge(_1,_3) 
                   )
# 177 "absparse.fsy"
                 : Formula.formula));
# 935 "absparse.fs"
        (fun (parseState : Microsoft.FSharp.Text.Parsing.IParseState) ->
            let _1 = (let data = parseState.GetInput(1) in (Microsoft.FSharp.Core.Operators.unbox data : Term.term)) in
            let _3 = (let data = parseState.GetInput(3) in (Microsoft.FSharp.Core.Operators.unbox data : Term.term)) in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
# 178 "absparse.fsy"
                                          Formula.Eq(_1,_3) 
                   )
# 178 "absparse.fsy"
                 : Formula.formula));
# 947 "absparse.fs"
        (fun (parseState : Microsoft.FSharp.Text.Parsing.IParseState) ->
            let _1 = (let data = parseState.GetInput(1) in (Microsoft.FSharp.Core.Operators.unbox data : Term.term)) in
            let _3 = (let data = parseState.GetInput(3) in (Microsoft.FSharp.Core.Operators.unbox data : Term.term)) in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
# 179 "absparse.fsy"
                                          Formula.Not(Formula.Eq(_1,_3)) 
                   )
# 179 "absparse.fsy"
                 : Formula.formula));
# 959 "absparse.fs"
        (fun (parseState : Microsoft.FSharp.Text.Parsing.IParseState) ->
            let _2 = (let data = parseState.GetInput(2) in (Microsoft.FSharp.Core.Operators.unbox data : Formula.formula)) in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
# 180 "absparse.fsy"
                                        Formula.Not _2
                   )
# 180 "absparse.fsy"
                 : Formula.formula));
# 970 "absparse.fs"
        (fun (parseState : Microsoft.FSharp.Text.Parsing.IParseState) ->
            let _1 = (let data = parseState.GetInput(1) in (Microsoft.FSharp.Core.Operators.unbox data : Formula.formula)) in
            let _3 = (let data = parseState.GetInput(3) in (Microsoft.FSharp.Core.Operators.unbox data : Formula.formula)) in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
# 181 "absparse.fsy"
                                                    Formula.And(_1,_3) 
                   )
# 181 "absparse.fsy"
                 : Formula.formula));
# 982 "absparse.fs"
        (fun (parseState : Microsoft.FSharp.Text.Parsing.IParseState) ->
            let _1 = (let data = parseState.GetInput(1) in (Microsoft.FSharp.Core.Operators.unbox data : Formula.formula)) in
            let _3 = (let data = parseState.GetInput(3) in (Microsoft.FSharp.Core.Operators.unbox data : Formula.formula)) in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
# 182 "absparse.fsy"
                                                       Formula.Or(_1,_3) 
                   )
# 182 "absparse.fsy"
                 : Formula.formula));
# 994 "absparse.fs"
        (fun (parseState : Microsoft.FSharp.Text.Parsing.IParseState) ->
            let _2 = (let data = parseState.GetInput(2) in (Microsoft.FSharp.Core.Operators.unbox data : Formula.formula)) in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
# 183 "absparse.fsy"
                                                   _2 
                   )
# 183 "absparse.fsy"
                 : Formula.formula));
# 1005 "absparse.fs"
        (fun (parseState : Microsoft.FSharp.Text.Parsing.IParseState) ->
            let _1 = (let data = parseState.GetInput(1) in (Microsoft.FSharp.Core.Operators.unbox data : Term.term)) in
            let _3 = (let data = parseState.GetInput(3) in (Microsoft.FSharp.Core.Operators.unbox data : Term.term)) in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
# 187 "absparse.fsy"
                                       Formula.Lt(_1,_3) 
                   )
# 187 "absparse.fsy"
                 : 'ATOM));
# 1017 "absparse.fs"
        (fun (parseState : Microsoft.FSharp.Text.Parsing.IParseState) ->
            let _1 = (let data = parseState.GetInput(1) in (Microsoft.FSharp.Core.Operators.unbox data : Term.term)) in
            let _3 = (let data = parseState.GetInput(3) in (Microsoft.FSharp.Core.Operators.unbox data : Term.term)) in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
# 188 "absparse.fsy"
                                          Formula.Gt(_1,_3) 
                   )
# 188 "absparse.fsy"
                 : 'ATOM));
# 1029 "absparse.fs"
        (fun (parseState : Microsoft.FSharp.Text.Parsing.IParseState) ->
            let _1 = (let data = parseState.GetInput(1) in (Microsoft.FSharp.Core.Operators.unbox data : Term.term)) in
            let _3 = (let data = parseState.GetInput(3) in (Microsoft.FSharp.Core.Operators.unbox data : Term.term)) in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
# 189 "absparse.fsy"
                                          Formula.Le(_1,_3) 
                   )
# 189 "absparse.fsy"
                 : 'ATOM));
# 1041 "absparse.fs"
        (fun (parseState : Microsoft.FSharp.Text.Parsing.IParseState) ->
            let _1 = (let data = parseState.GetInput(1) in (Microsoft.FSharp.Core.Operators.unbox data : Term.term)) in
            let _3 = (let data = parseState.GetInput(3) in (Microsoft.FSharp.Core.Operators.unbox data : Term.term)) in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
# 190 "absparse.fsy"
                                          Formula.Ge(_1,_3) 
                   )
# 190 "absparse.fsy"
                 : 'ATOM));
# 1053 "absparse.fs"
        (fun (parseState : Microsoft.FSharp.Text.Parsing.IParseState) ->
            let _1 = (let data = parseState.GetInput(1) in (Microsoft.FSharp.Core.Operators.unbox data : Term.term)) in
            let _3 = (let data = parseState.GetInput(3) in (Microsoft.FSharp.Core.Operators.unbox data : Term.term)) in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
# 191 "absparse.fsy"
                                          Formula.Eq(_1,_3) 
                   )
# 191 "absparse.fsy"
                 : 'ATOM));
# 1065 "absparse.fs"
        (fun (parseState : Microsoft.FSharp.Text.Parsing.IParseState) ->
            let _1 = (let data = parseState.GetInput(1) in (Microsoft.FSharp.Core.Operators.unbox data : Term.term)) in
            let _3 = (let data = parseState.GetInput(3) in (Microsoft.FSharp.Core.Operators.unbox data : Term.term)) in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
# 192 "absparse.fsy"
                                          Formula.Not(Formula.Eq(_1,_3)) 
                   )
# 192 "absparse.fsy"
                 : 'ATOM));
# 1077 "absparse.fs"
        (fun (parseState : Microsoft.FSharp.Text.Parsing.IParseState) ->
            let _1 = (let data = parseState.GetInput(1) in (Microsoft.FSharp.Core.Operators.unbox data : 'ATOM)) in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
# 196 "absparse.fsy"
                                  CTL.State_Formula.Atm _1
                   )
# 196 "absparse.fsy"
                 : CTL.State_Formula));
# 1088 "absparse.fs"
        (fun (parseState : Microsoft.FSharp.Text.Parsing.IParseState) ->
            let _2 = (let data = parseState.GetInput(2) in (Microsoft.FSharp.Core.Operators.unbox data : CTL.Path_Formula)) in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
# 197 "absparse.fsy"
                                            CTL.State_Formula.A _2
                   )
# 197 "absparse.fsy"
                 : CTL.State_Formula));
# 1099 "absparse.fs"
        (fun (parseState : Microsoft.FSharp.Text.Parsing.IParseState) ->
            let _2 = (let data = parseState.GetInput(2) in (Microsoft.FSharp.Core.Operators.unbox data : CTL.Path_Formula)) in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
# 198 "absparse.fsy"
                                            CTL.State_Formula.E _2
                   )
# 198 "absparse.fsy"
                 : CTL.State_Formula));
# 1110 "absparse.fs"
        (fun (parseState : Microsoft.FSharp.Text.Parsing.IParseState) ->
            let _1 = (let data = parseState.GetInput(1) in (Microsoft.FSharp.Core.Operators.unbox data : CTL.CTLStar_Formula)) in
            let _3 = (let data = parseState.GetInput(3) in (Microsoft.FSharp.Core.Operators.unbox data : CTL.CTLStar_Formula)) in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
# 199 "absparse.fsy"
                                                                 CTL.State_Formula.And(_1, _3) 
                   )
# 199 "absparse.fsy"
                 : CTL.State_Formula));
# 1122 "absparse.fs"
        (fun (parseState : Microsoft.FSharp.Text.Parsing.IParseState) ->
            let _1 = (let data = parseState.GetInput(1) in (Microsoft.FSharp.Core.Operators.unbox data : CTL.CTLStar_Formula)) in
            let _3 = (let data = parseState.GetInput(3) in (Microsoft.FSharp.Core.Operators.unbox data : CTL.CTLStar_Formula)) in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
# 200 "absparse.fsy"
                                                                   CTL.State_Formula.Or(_1, _3) 
                   )
# 200 "absparse.fsy"
                 : CTL.State_Formula));
# 1134 "absparse.fs"
        (fun (parseState : Microsoft.FSharp.Text.Parsing.IParseState) ->
            let _2 = (let data = parseState.GetInput(2) in (Microsoft.FSharp.Core.Operators.unbox data : CTL.State_Formula)) in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
# 201 "absparse.fsy"
                                                      _2 
                   )
# 201 "absparse.fsy"
                 : CTL.State_Formula));
# 1145 "absparse.fs"
        (fun (parseState : Microsoft.FSharp.Text.Parsing.IParseState) ->
            let _3 = (let data = parseState.GetInput(3) in (Microsoft.FSharp.Core.Operators.unbox data : CTL.CTLStar_Formula)) in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
# 205 "absparse.fsy"
                                                             CTL.Path_Formula.F _3
                   )
# 205 "absparse.fsy"
                 : CTL.Path_Formula));
# 1156 "absparse.fs"
        (fun (parseState : Microsoft.FSharp.Text.Parsing.IParseState) ->
            let _3 = (let data = parseState.GetInput(3) in (Microsoft.FSharp.Core.Operators.unbox data : CTL.CTLStar_Formula)) in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
# 206 "absparse.fsy"
                                                          CTL.Path_Formula.G _3
                   )
# 206 "absparse.fsy"
                 : CTL.Path_Formula));
# 1167 "absparse.fs"
        (fun (parseState : Microsoft.FSharp.Text.Parsing.IParseState) ->
            let _3 = (let data = parseState.GetInput(3) in (Microsoft.FSharp.Core.Operators.unbox data : CTL.CTLStar_Formula)) in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
# 207 "absparse.fsy"
                                                          CTL.Path_Formula.X _3
                   )
# 207 "absparse.fsy"
                 : CTL.Path_Formula));
# 1178 "absparse.fs"
        (fun (parseState : Microsoft.FSharp.Text.Parsing.IParseState) ->
            let _3 = (let data = parseState.GetInput(3) in (Microsoft.FSharp.Core.Operators.unbox data : CTL.CTLStar_Formula)) in
            let _7 = (let data = parseState.GetInput(7) in (Microsoft.FSharp.Core.Operators.unbox data : CTL.CTLStar_Formula)) in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
# 208 "absparse.fsy"
                                                                                                 CTL.Path_Formula.W(_3, _7) 
                   )
# 208 "absparse.fsy"
                 : CTL.Path_Formula));
# 1190 "absparse.fs"
        (fun (parseState : Microsoft.FSharp.Text.Parsing.IParseState) ->
            let _3 = (let data = parseState.GetInput(3) in (Microsoft.FSharp.Core.Operators.unbox data : CTL.CTLStar_Formula)) in
            let _7 = (let data = parseState.GetInput(7) in (Microsoft.FSharp.Core.Operators.unbox data : CTL.CTLStar_Formula)) in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
# 209 "absparse.fsy"
                                                                                              CTL.Path_Formula.U(_3, _7) 
                   )
# 209 "absparse.fsy"
                 : CTL.Path_Formula));
# 1202 "absparse.fs"
        (fun (parseState : Microsoft.FSharp.Text.Parsing.IParseState) ->
            let _2 = (let data = parseState.GetInput(2) in (Microsoft.FSharp.Core.Operators.unbox data : CTL.Path_Formula)) in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
# 210 "absparse.fsy"
                                                     _2 
                   )
# 210 "absparse.fsy"
                 : CTL.Path_Formula));
# 1213 "absparse.fs"
        (fun (parseState : Microsoft.FSharp.Text.Parsing.IParseState) ->
            let _1 = (let data = parseState.GetInput(1) in (Microsoft.FSharp.Core.Operators.unbox data : CTL.Path_Formula)) in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
# 214 "absparse.fsy"
                                      CTL.CTLStar_Formula.Path _1
                   )
# 214 "absparse.fsy"
                 : CTL.CTLStar_Formula));
# 1224 "absparse.fs"
        (fun (parseState : Microsoft.FSharp.Text.Parsing.IParseState) ->
            let _1 = (let data = parseState.GetInput(1) in (Microsoft.FSharp.Core.Operators.unbox data : CTL.State_Formula)) in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
# 215 "absparse.fsy"
                                       CTL.CTLStar_Formula.State _1
                   )
# 215 "absparse.fsy"
                 : CTL.CTLStar_Formula));
# 1235 "absparse.fs"
        (fun (parseState : Microsoft.FSharp.Text.Parsing.IParseState) ->
            let _1 = (let data = parseState.GetInput(1) in (Microsoft.FSharp.Core.Operators.unbox data : 'ATOM)) in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
# 219 "absparse.fsy"
                               CTL.CTL_Formula.Atom _1
                   )
# 219 "absparse.fsy"
                 : CTL.CTL_Formula));
# 1246 "absparse.fs"
        (fun (parseState : Microsoft.FSharp.Text.Parsing.IParseState) ->
            let _1 = (let data = parseState.GetInput(1) in (Microsoft.FSharp.Core.Operators.unbox data : CTL.CTL_Formula)) in
            let _3 = (let data = parseState.GetInput(3) in (Microsoft.FSharp.Core.Operators.unbox data : CTL.CTL_Formula)) in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
# 220 "absparse.fsy"
                                                         CTL.CTL_Formula.CTL_And(_1, _3) 
                   )
# 220 "absparse.fsy"
                 : CTL.CTL_Formula));
# 1258 "absparse.fs"
        (fun (parseState : Microsoft.FSharp.Text.Parsing.IParseState) ->
            let _1 = (let data = parseState.GetInput(1) in (Microsoft.FSharp.Core.Operators.unbox data : CTL.CTL_Formula)) in
            let _3 = (let data = parseState.GetInput(3) in (Microsoft.FSharp.Core.Operators.unbox data : CTL.CTL_Formula)) in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
# 221 "absparse.fsy"
                                                           CTL.CTL_Formula.CTL_Or(_1, _3) 
                   )
# 221 "absparse.fsy"
                 : CTL.CTL_Formula));
# 1270 "absparse.fs"
        (fun (parseState : Microsoft.FSharp.Text.Parsing.IParseState) ->
            let _3 = (let data = parseState.GetInput(3) in (Microsoft.FSharp.Core.Operators.unbox data : CTL.CTL_Formula)) in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
# 222 "absparse.fsy"
                                                        CTL.CTL_Formula.AF _3
                   )
# 222 "absparse.fsy"
                 : CTL.CTL_Formula));
# 1281 "absparse.fs"
        (fun (parseState : Microsoft.FSharp.Text.Parsing.IParseState) ->
            let _3 = (let data = parseState.GetInput(3) in (Microsoft.FSharp.Core.Operators.unbox data : CTL.CTL_Formula)) in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
# 223 "absparse.fsy"
                                                          CTL.CTL_Formula.AG _3
                   )
# 223 "absparse.fsy"
                 : CTL.CTL_Formula));
# 1292 "absparse.fs"
        (fun (parseState : Microsoft.FSharp.Text.Parsing.IParseState) ->
            let _3 = (let data = parseState.GetInput(3) in (Microsoft.FSharp.Core.Operators.unbox data : CTL.CTL_Formula)) in
            let _7 = (let data = parseState.GetInput(7) in (Microsoft.FSharp.Core.Operators.unbox data : CTL.CTL_Formula)) in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
# 224 "absparse.fsy"
                                                                                       CTL.CTL_Formula.AW(_3, _7) 
                   )
# 224 "absparse.fsy"
                 : CTL.CTL_Formula));
# 1304 "absparse.fs"
        (fun (parseState : Microsoft.FSharp.Text.Parsing.IParseState) ->
            let _3 = (let data = parseState.GetInput(3) in (Microsoft.FSharp.Core.Operators.unbox data : CTL.CTL_Formula)) in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
# 225 "absparse.fsy"
                                                          CTL.CTL_Formula.AX _3
                   )
# 225 "absparse.fsy"
                 : CTL.CTL_Formula));
# 1315 "absparse.fs"
        (fun (parseState : Microsoft.FSharp.Text.Parsing.IParseState) ->
            let _3 = (let data = parseState.GetInput(3) in (Microsoft.FSharp.Core.Operators.unbox data : CTL.CTL_Formula)) in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
# 226 "absparse.fsy"
                                                        CTL.CTL_Formula.EF _3
                   )
# 226 "absparse.fsy"
                 : CTL.CTL_Formula));
# 1326 "absparse.fs"
        (fun (parseState : Microsoft.FSharp.Text.Parsing.IParseState) ->
            let _3 = (let data = parseState.GetInput(3) in (Microsoft.FSharp.Core.Operators.unbox data : CTL.CTL_Formula)) in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
# 227 "absparse.fsy"
                                                          CTL.CTL_Formula.EG _3
                   )
# 227 "absparse.fsy"
                 : CTL.CTL_Formula));
# 1337 "absparse.fs"
        (fun (parseState : Microsoft.FSharp.Text.Parsing.IParseState) ->
            let _3 = (let data = parseState.GetInput(3) in (Microsoft.FSharp.Core.Operators.unbox data : CTL.CTL_Formula)) in
            let _7 = (let data = parseState.GetInput(7) in (Microsoft.FSharp.Core.Operators.unbox data : CTL.CTL_Formula)) in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
# 228 "absparse.fsy"
                                                                                       CTL.CTL_Formula.EU(_3, _7) 
                   )
# 228 "absparse.fsy"
                 : CTL.CTL_Formula));
# 1349 "absparse.fs"
        (fun (parseState : Microsoft.FSharp.Text.Parsing.IParseState) ->
            let _3 = (let data = parseState.GetInput(3) in (Microsoft.FSharp.Core.Operators.unbox data : CTL.CTL_Formula)) in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
# 229 "absparse.fsy"
                                                          CTL.CTL_Formula.EX _3
                   )
# 229 "absparse.fsy"
                 : CTL.CTL_Formula));
# 1360 "absparse.fs"
        (fun (parseState : Microsoft.FSharp.Text.Parsing.IParseState) ->
            let _2 = (let data = parseState.GetInput(2) in (Microsoft.FSharp.Core.Operators.unbox data : CTL.CTL_Formula)) in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
# 230 "absparse.fsy"
                                                    _2 
                   )
# 230 "absparse.fsy"
                 : CTL.CTL_Formula));
# 1371 "absparse.fs"
        (fun (parseState : Microsoft.FSharp.Text.Parsing.IParseState) ->
            let _2 = (let data = parseState.GetInput(2) in (Microsoft.FSharp.Core.Operators.unbox data : CTL.CTL_Formula)) in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
# 231 "absparse.fsy"
                                             CTL.CTL_Formula.negate _2 
                   )
# 231 "absparse.fsy"
                 : CTL.CTL_Formula));
# 1382 "absparse.fs"
        (fun (parseState : Microsoft.FSharp.Text.Parsing.IParseState) ->
            let _2 = (let data = parseState.GetInput(2) in (Microsoft.FSharp.Core.Operators.unbox data : Formula.formula)) in
            let _4 = (let data = parseState.GetInput(4) in (Microsoft.FSharp.Core.Operators.unbox data : Formula.formula)) in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
# 235 "absparse.fsy"
                                                              (_2, _4) 
                   )
# 235 "absparse.fsy"
                 : Formula.formula * Formula.formula));
# 1394 "absparse.fs"
        (fun (parseState : Microsoft.FSharp.Text.Parsing.IParseState) ->
            let _1 = (let data = parseState.GetInput(1) in (Microsoft.FSharp.Core.Operators.unbox data : bigint)) in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
# 239 "absparse.fsy"
                                 _1 
                   )
# 239 "absparse.fsy"
                 : bigint));
# 1405 "absparse.fs"
        (fun (parseState : Microsoft.FSharp.Text.Parsing.IParseState) ->
            let _2 = (let data = parseState.GetInput(2) in (Microsoft.FSharp.Core.Operators.unbox data : bigint)) in
            Microsoft.FSharp.Core.Operators.box
                (
                   (
# 240 "absparse.fsy"
                                            -_2 
                   )
# 240 "absparse.fsy"
                 : bigint));
|]
# 1417 "absparse.fs"
let tables () : Microsoft.FSharp.Text.Parsing.Tables<_> = 
  { reductions= _fsyacc_reductions ();
    endOfInputTag = _fsyacc_endOfInputTag;
    tagOfToken = tagOfToken;
    dataOfToken = _fsyacc_dataOfToken; 
    actionTableElements = _fsyacc_actionTableElements;
    actionTableRowOffsets = _fsyacc_actionTableRowOffsets;
    stateToProdIdxsTableElements = _fsyacc_stateToProdIdxsTableElements;
    stateToProdIdxsTableRowOffsets = _fsyacc_stateToProdIdxsTableRowOffsets;
    reductionSymbolCounts = _fsyacc_reductionSymbolCounts;
    immediateActions = _fsyacc_immediateActions;
    gotos = _fsyacc_gotos;
    sparseGotoTableRowOffsets = _fsyacc_sparseGotoTableRowOffsets;
    tagOfErrorTerminal = _fsyacc_tagOfErrorTerminal;
    parseError = (fun (ctxt:Microsoft.FSharp.Text.Parsing.ParseErrorContext<_>) -> 
                              match parse_error_rich with 
                              | Some f -> f ctxt
                              | None -> parse_error ctxt.Message);
    numTerminals = 51;
    productionToNonTerminalTable = _fsyacc_productionToNonTerminalTable  }
let engine lexer lexbuf startState = (tables ()).Interpret(lexer, lexbuf, startState)
let Fairness_constraint lexer lexbuf : Formula.formula * Formula.formula =
    Microsoft.FSharp.Core.Operators.unbox ((tables ()).Interpret(lexer, lexbuf, 0))
let Path_formula lexer lexbuf : CTL.Path_Formula =
    Microsoft.FSharp.Core.Operators.unbox ((tables ()).Interpret(lexer, lexbuf, 2))
let State_formula lexer lexbuf : CTL.State_Formula =
    Microsoft.FSharp.Core.Operators.unbox ((tables ()).Interpret(lexer, lexbuf, 4))
let CTLStar_formula lexer lexbuf : CTL.CTLStar_Formula =
    Microsoft.FSharp.Core.Operators.unbox ((tables ()).Interpret(lexer, lexbuf, 6))
let CTL_formula lexer lexbuf : CTL.CTL_Formula =
    Microsoft.FSharp.Core.Operators.unbox ((tables ()).Interpret(lexer, lexbuf, 8))
let program lexer lexbuf : parsedLoc * parsedLoc * (parsedLoc * Programs.Command list * parsedLoc) list * (Var.var * Var.var) list * bool =
    Microsoft.FSharp.Core.Operators.unbox ((tables ()).Interpret(lexer, lexbuf, 10))
