%% make volcano plot %%
%st human structur
%clus1 first cluster
%treat1 type of treatment for cluster 1
%clus2 second cluster
%treat2 type of treatment for cluster 2
%provid up/down regulated genes. If no output defined make a plot
%keep clus2 empty to comare clus1 to all

function [up,dw,ratio,qval,filtGenes] = volcano(st,clus1,treat1,cell1,ratio1,clus2,treat2,cell2,fcThr,qThr,logGenes,expThr,prnt,txt,tblin)
 
%control input
    load inputData -regexp ^(?!hint$|tbl$|lr).*

    if nargin<9
        fcThr=2;
    end

    if nargin<10
        qThr=0.01;
    end

    if nargin<11
        selGenes=true(length(st.all_genes),1);
    elseif isempty(logGenes)
        selGenes=true(length(st.all_genes),1);
    else    
        selGenes=ismember(st.all_genes,logGenes);
    end
    
    if nargin<12
        expThr=10^-6;
    end
        
    if nargin<14
        txt='true';
    end    
    
    if ~isempty(tblin)
        tbl=tblin;
    end
    
    %min number of cell allowed per cluster
    absCellNum=10;
    
    %filter genes based on the logical vector
    fGenes=st.all_genes(selGenes);
    
    %%%% CLUS %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
    %clus1 find index 
    clus1Ind=ismember(st.metadata.seurat_clusters,clus1);
    
    %clus2 - if enpty and find index
    if ~isempty(clus2)
        clus2Ind=ismember(st.metadata.seurat_clusters,clus2);
    else
        clus2Ind=~clus1Ind;
    end

    
    %%% TREAT %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
    %treat1 - if empty and find index
    if isempty(treat1)
        treat1={'Tumor','Far'};
    end
    treat1Ind=ismember(upper(st.metadata.treatment),upper(treat1)); %extra

    %treat2 - if empty and find index 
    if isempty(treat2)
        treat2={'Tumor','Far'};
    end
    treat2Ind=ismember(upper(st.metadata.treatment),upper(treat2)); %extra
    
    
    %%% CELL %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
    if isempty(cell1)
        cell1Logical=ones(size(st.metadata.seurat_clusters,1),1);
    else
        cell1Logical=cell1;
    end
    
    if isempty(cell2)
        cell2Logical=ones(size(st.metadata.seurat_clusters,1),1);
    else
        cell2Logical=cell2;
    end

    
    %%% RATIO1 - ratio of positive cells from the TRUE cells %%%%%%%%%%%%%%
    if isempty(ratio1)
        ratio1=0;
    end
    temp=sum(st.mat(selGenes,clus1Ind & treat1Ind & cell1Logical)>0,2) ./ sum(clus1Ind & treat1Ind & cell1Logical);
    ratio1Ind=temp>=ratio1;
    
    %%% MAKE MAT1 and MAT2 %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
    mat1=st.mat_norm(selGenes,clus1Ind & treat1Ind & cell1Logical);
    mat2=st.mat_norm(selGenes,clus2Ind & treat2Ind & cell2Logical);
  
    %filter genes based on exp (at least for one group!)
    filtGenesExp=mean(mat1,2)>expThr | mean(mat2,2)>expThr;
    
    %filter for the min number of POSITIVE cells and above  the requested
    %ratio 
    ratioFilt1=sum(mat1>0,2)>=absCellNum;
    ratioFilt2=sum(mat2>0,2)>=absCellNum;
    filtAll=(ratioFilt1 | ratioFilt2) & filtGenesExp & ratio1Ind;
    
    %calc the ratio and the qval
    mmean1=mean(mat1(filtAll,:),2);
    mmean2=mean(mat2(filtAll,:),2);
    mmean1(mmean1==0)=min(mmean1(mmean1>0));
    mmean2(mmean2==0)=min(mmean2(mmean2>0));
    ratio=mmean1./mmean2;
    pval=zeros(sum(filtAll),1);
    for i=1:sum(filtAll)
        iind=find(filtAll);
        pval(i)=ranksum(mat1(iind(i),:),mat2(iind(i),:));
    end
    qval=mafdr(pval,'BHFDR',true);

    %find genes based on threshold
    indinUp=find(log2(ratio)>log2(fcThr)   & -log10(qval)>-log10(qThr));
    indinDw=find(log2(ratio)<log2(1/fcThr) & -log10(qval)>-log10(qThr));
    
    %retrun list of genes of output arg found
    filtGenes=fGenes(filtAll);
    if nargout > 2
        [~,ord1]=sort(ratio(indinUp),'descend');
        up=filtGenes(indinUp(ord1));
        [~,ord2]=sort(ratio(indinDw),'descend');
        dw=filtGenes(indinDw(ord2));
    elseif nargout ==2
        [~,ord1]=sort(ratio(indinUp),'descend');
        up=filtGenes(indinUp(ord1));
        [~,ord2]=sort(ratio(indinDw),'descend');
        dw=filtGenes(indinDw(ord2));
        return;
    end
    
    if (prnt==1) &&  strcmpi({txt},'true')
        %print plot if output arg not found
        figure;
        plot(log2(ratio),-log10(qval),'.','color',[.7 .7 .7],'MarkerSize',10)
        %adj. the limits of the figure
        axis tight
        ap=axis;
        xMin=-(max(abs(ap(1:2))))-volDelta;
        xMax=+(max(abs(ap(1:2))))+volDelta;
        yMin=ap(3);
        yMax=ap(4)+volDelta;
        set(gca,'Xlim',[xMin xMax],'YLim',[yMin yMax])
        %plot dashed lines
        line([xMin xMax], [-log10(qThr) -log10(qThr)],'color','k','linestyle','--');
        line([log2(fcThr) log2(fcThr)],[yMin yMax],'color','k','linestyle','--');
        line([log2(1/fcThr) log2(1/fcThr)],[yMin yMax],'color','k','linestyle','--');
        indin=find(((log2(ratio)>log2(fcThr)) | (log2(ratio)<log2(1/fcThr)))  & (-log10(qval)>-log10(qThr)));
        for i=1:length(indin)
            text(log2(ratio(indin(i))),-log10(qval(indin(i))),filtGenes{indin(i)});
        end
        ylabel('-log10(qval)');
    end
    
    if (prnt==1) &&  ~isempty(txt)
        %print plot if output arg not found
        figure;
        hold all
        plot(log2(ratio),-log10(qval),'.','color',[.7 .7 .7],'MarkerSize',10)
        %adj. the limits of the figure
        axis tight
        ap=axis;
        xMin=-(max(abs(ap(1:2))))-volDelta;
        xMax=+(max(abs(ap(1:2))))+volDelta;
        yMin=ap(3);
        yMax=ap(4)+volDelta;
        set(gca,'Xlim',[xMin xMax],'YLim',[yMin yMax])
        %plot dashed lines
        line([xMin xMax], [-log10(qThr) -log10(qThr)],'color','k','linestyle','--');
        line([log2(fcThr) log2(fcThr)],[yMin yMax],'color','k','linestyle','--');
        line([log2(1/fcThr) log2(1/fcThr)],[yMin yMax],'color','k','linestyle','--');
        indin=find(ismember(filtGenes,txt));
        for i=1:length(indin)
            plot(log2(ratio(indin(i))),-log10(qval(indin(i))),'.','color',[1 0 0],'MarkerSize',10)
            text(log2(ratio(indin(i))),-log10(qval(indin(i))),filtGenes{indin(i)},'FontSize',txtFontSize);
        end
        hold off
        ylabel('-log10(qval)');
    end
    
end

    
    