function h=scattera(x,y,size,color,alpha)
%SCATTER
%   this function add a dynamic transperency to scatter plot markers.
%   input values are:
%   x - x corr (1xn vector)
%   y - y corr (1xn vector)
%   size - marker size (shape)
%   color - marker color (3x1 vector of values between 0 and 1)
%   alpha - marker alpha (1xn vector of values between 0 and 1)

trans=uint8(255*alpha);
transData=[repmat(color'*255,1,length(trans)); trans];

h=scatter(gca,x,y,size,color,'filled');
drawnow;
hMarkers = h.MarkerHandle;
hMarkers.FaceColorType = 'truecoloralpha';
% hMarkers.FaceColorData=transData;
set(hMarkers,'FaceColorBinding','interpolated', 'FaceColorData',transData);

end