function [zone_struct,Z,ZSE,pval,qval,x,y,eta,pval_perm]=produce_zonation_matrix(hint,pc_lm,pp_lm,cell_type,MAX_THRESH,NUM_ZONES)

% [Z,ZSE,pval,qval]=produce_zonation_matrix(hint,pc_lm,pp_lm,cells2analyze)
% pc_lm and pp_lm are obtained from extract_lm_genes.m
% insert the indices of the cells to use for reconstruction in
% cells2analyze. For each of these cells we will produce a spatial
% coordinate, then average the cells in each zone
% cell_type='Hepatocytes', cell_type='Kupffer cells', cell_type='LSEC', cell_type='LVEC', cell_type='Stellate cells', cell_type='T cells', cell_type='B cells'


% For example to run on Kupffer cells:
% [marker_genes,marker_indices_lcm,marker_indices_sc]=find_markers(E,2,5*10^-6,hint,hlz);
% [pp_lm, pc_lm, pp_lm_ind,pc_lm_ind] = extract_lm_genes(hlz,marker_indices_lcm,find(strcmpi(cnms,'Kupffer cells')),3,4,10^-5)
% [Z,ZSE,pval,qval,x,y,eta]=produce_zonation_matrix(hint,pc_lm,pp_lm,'Kupffer cells')

% Renormalize to remove pseudonumber artefact
if nargin<5
    MAX_THRESH=10^-5;
end
if ~isfield(hint,'mat_norm'),
    hint.mat_norm=hint.mat./sum(hint.mat);
end
% also normalize by max so that any lm will contribute equally
%hint.mat_norm=hint.mat_norm./max(hint.mat_norm,[],2);

if nargin<6
    NUM_ZONES=6;
end

Z=zeros(length(hint.all_genes),NUM_ZONES);
ZSE=zeros(length(hint.all_genes),NUM_ZONES);
pval_perm=NaN*ones(length(hint.all_genes),1);
pval=NaN*ones(length(hint.all_genes),1);
qval=NaN*ones(length(hint.all_genes),1);
qval_perm=NaN*ones(length(hint.all_genes),1);
if isfield(hint,'metadata')
    cells2analyze=intersect(find(strcmpi(hint.clusterNames,cell_type)),find(strcmpi(hint.metadata.treatment,'far')));
else
    cells2analyze=find(strcmpi(hint.clusterNames,cell_type));
end
% find indices of lm genes in SC data
ind_pc=[];
for i=1:length(pc_lm)
    indd=find(strcmpi(hint.all_genes,pc_lm{i}));
    if ~isempty(indd)
        ind_pc=[ind_pc,indd];
    end
end
ind_pp=[];
for i=1:length(pp_lm)
    indd=find(strcmpi(hint.all_genes,pp_lm{i}));
    if ~isempty(indd)
        ind_pp=[ind_pp,indd];
    end
end

x=NaN*ones(size(hint.mat_norm,2),1);
y=NaN*ones(size(hint.mat_norm,2),1);
zone=NaN*ones(size(hint.mat_norm,2),1);
x(cells2analyze)=sum(hint.mat_norm(ind_pc,cells2analyze));
y(cells2analyze)=sum(hint.mat_norm(ind_pp,cells2analyze));
eta=y./(x+y);
figure;
subplot(2,2,1);
scatter(hint.xy(:,1),hint.xy(:,2),25,x,'filled');
title('x');
subplot(2,2,2);
scatter(hint.xy(:,1),hint.xy(:,2),25,y,'filled');
title('y');
subplot(2,2,3);
scatter(hint.xy(:,1),hint.xy(:,2),25,eta,'filled');
title('eta');
subplot(2,2,4);
hist(eta);
xlabel('eta');

% produce zonation table
lims=prctile(eta,linspace(0,100,NUM_ZONES+1));

for i=1:NUM_ZONES
    ind=find(eta>=lims(i) & eta<lims(i+1));
    zone(ind)=i;
    Z(:,i)=mean(hint.mat_norm(:,ind),2);
    ZSE(:,i)=std(hint.mat_norm(:,ind),[],2)/sqrt(length(ind));
end

% generate p-value
for i=1:length(pval)
    pval(i)=kruskalwallis(hint.mat_norm(i,cells2analyze),zone(cells2analyze),'off');
end

% Generate perm_pval - permute zone assignments of cells 100 times,
% recompute zonation profiles, then for each gene determine the fraction of
% randomized iterations with higher dynamic range
stat_real=(max(Z,[],2)-min(Z,[],2))./mean(Z,2);
ITER=100;
stat_rand=zeros(size(Z,1),ITER);
for j=1:ITER
    for i=1:NUM_ZONES
        ind_no_nan=find(~isnan(zone));
        ind_no_nanr=ind_no_nan(randperm(length(ind_no_nan)));
        zoner=zone;
        zoner(ind_no_nanr)=zone(ind_no_nan);
        ind=find(zoner==i);
        Zr(:,i)=mean(hint.mat_norm(:,ind),2);        
    end
    stat_rand(:,j)=(max(Zr,[],2)-min(Zr,[],2))./mean(Zr,2);
%     if isnan(stat_rand(11295,j))
%         display('bug');
%     end      
end
Zscore=(stat_real-mean(stat_rand,2))./std(stat_rand,[],2);
pval_perm=1-normcdf(Zscore);

%%
com=zeros(size(Z,1),1);
for i=1:length(Z),
    com(i)=sum((1:size(Z,2)).*Z(i,:))/sum(Z(i,:));
end

[mx,mxind]=max(Z,[],2);
indin=find(mx>MAX_THRESH);
qval(indin)=mafdr(pval(indin),'bhfdr','true');
qval_perm(indin)=mafdr(pval_perm(indin),'bhfdr','true');

zone_struct.cell_type=cell_type;
zone_struct.Z=Z;
zone_struct.ZSE=ZSE;
zone_struct.pval=pval;
zone_struct.pval_perm=pval_perm;
zone_struct.qval=qval;
zone_struct.qval_perm=qval_perm;
zone_struct.cells2analyze=cells2analyze;
zone_struct.pc_lm=pc_lm;
zone_struct.pp_lm=pp_lm;
zone_struct.com=com;
zone_struct.zone=zone;
zone_struct.eta=eta;
zone_struct.x=x;
zone_struct.y=y;
zone_struct.gene_name=hint.all_genes;







