function [tab]=lineplot(DE_genes,markers_lcm,mat_norm_lcm,zone1,zone2,tz)

gene_names=markers_lcm;
mat_norm=mat_norm_lcm;
human=tz.meta.human;
block=tz.meta.block;
zone=tz.meta.zone;

[~,gplot]=ismember(DE_genes,gene_names);
gplot(gplot==0)=[];

figure('Units','centimeters','position',[62.2035    3         21         18]);
uhuman=unique(human);
ll={'-','-.','--',':'};
cc={'r','k','b'};
mx=[];
for g=1:length(gplot)
    tab{g}=[];
    gg=gplot(g);
    subplot(4,4,g);
    hold on;
    for i=1:length(uhuman)
        ublock=unique(block(strcmpi(human,uhuman(i)),:));
        for j=1:length(ublock)
            if (strcmpi(uhuman(i),'H7') & strcmpi(ublock(j),'3')) ~= 1
                p2=mat_norm(gg,strcmpi(human,uhuman(i)) & strcmpi(block,ublock(j)) & strcmpi(zone,zone1));
                p3=mat_norm(gg,strcmpi(human,uhuman(i)) & strcmpi(block,ublock(j)) & strcmpi(zone,zone2));
                plot(1:2,[p2 p3],'LineStyle',ll{j},'Marker','o','Color',cc{i},'linewidth',1.5);
                tab{g}=[tab{g};p2 p3];
            end
        end
        
    end
    %axis square
    box on;
    set(gca,'FontSize',8);
    axisDeltaX=0.1;
    xlim([0.8 2.2])
    ylim([0 max(ylim)])
    axis tight
    ap=axis;
    set(gca,'Xlim',[ap(1)-axisDeltaX ap(2)+axisDeltaX],'YLim',[ap(3) ap(4)])
    
    hold off;
    title(gene_names(gplot(g)));
    set(gca,'XTick',1:2);
    set(gca,'XTickLabel',{zone1,zone2})
end

if nnz(strcmpi(who,'tab'))==0, tab=[]; end

end