function [marker_genes,marker_indices_lcm,marker_indices_sc]=find_markers(E,FACTOR,MIN_EXP,hint,lcm)

% find marker genes by scRNAseq by comapring the max mean expression of
% each gene to the max mean expression of the remainnig clusters * FACTOR. 
% return the indices in the LCM struct and sc

if nargin<3
    FACTOR=1;
end

if nargin<4
    MIN_EXP=5*10^-6;
end

for cluster=1:size(E,2)
    m1=E(:,cluster); % average expression in hep cluster
    m2=max(E(:,setdiff(1:size(E,2),cluster)),[],2); % max expression in any other cluster
    indin=intersect(find(m1>MIN_EXP),find(m1>FACTOR*m2));
    marker_indices_sc{cluster}=indin;
    marker_genes{cluster}=hint.all_genes(indin);
    ind=[];
    for i=1:length(marker_genes{cluster})
       indd=find(strcmpi(lcm.all_genes,marker_genes{cluster}{i}));
       if ~isempty(indd)
           ind=[ind indd];
       end
    end
    
    marker_indices_lcm{cluster}=ind;
    PLOT_FLAG=0;
    if PLOT_FLAG
        figure
        scatter(log10(m1),log10(m2),25,'b','filled');        
        indin2=intersect(find(m1>10^-4),find(m1>1*FACTOR*m2));
        for i=1:length(indin2)
            text(log10(m1(indin2(i))),log10(m2(indin2(i))),hint.all_genes{indin2(i)},'fontsize',10);
        end
        hold on;scatter(log10(m1(indin)),log10(m2(indin)),25,'r','filled');        
        xlabel('Hepatocyte gene expression');ylabel('Maximal gene expression other cell types');
        xlim([-6 max(xlim)]);
        ylim([-6 max(ylim)]);
        axis square
        set(gca,'fontsize',15)
        set(gcf,'position',[957   375   776   525]);
        box on;
        grid on;
    end
end
