function [DE_markers,gene_names,mat_norm,tab1,tab2]=find_DE_markers(markers,tz,zone1,zone2,Q_THRESH)

    [~,gplot]=ismember(markers,tz.all_genes);
    gplot(gplot==0)=[];
    
    if isempty(gplot)
        DE_markers={};
        return;
    end
    
    mat_norm=bsxfun(@rdivide,tz.mat_norm(gplot,:),sum(tz.mat_norm(gplot,:)));
    gene_names=tz.all_genes(gplot);

    cnames=cellfun(@(x) strsplit(x,'_'),tz.mat_norm_colnames,'UniformOutput',false);
    cnames=vertcat(cnames{:});
    human=cnames(:,1);
    zone=cnames(:,2);
    block=cnames(:,3);

    uhuman=unique(human);
    clear pval
    tab1=[];
    tab2=[];
    ind2include=[];
    for g=1:length(gplot)
        p1=[];
        p2=[];
        for i=1:length(uhuman)
            ublock=unique(block(strcmpi(human,uhuman(i)),:));
            for j=1:length(ublock)
                if (strcmpi(uhuman(i),'H7') & strcmpi(ublock(j),'3')) ~= 1
                    p11=mat_norm(g,strcmpi(human,uhuman(i)) & strcmpi(block,ublock(j)) & strcmpi(zone,zone1));
                    p22=mat_norm(g,strcmpi(human,uhuman(i)) & strcmpi(block,ublock(j)) & strcmpi(zone,zone2));
                    p1=[p1 p11];
                    p2=[p2 p22];
                end
            end
        end
        tab1(g,:)=[p1 p11];
        tab2(g,:)=[p2 p22];
        pval(g) = signrank(p1,p2);
    end
    [~,q]=mafdr(pval);
    DE_markers=gene_names(q<Q_THRESH);
end