function interactionTable=findInteractions(st,selectTreat,selectClus,minExp,cellRatio,minCells,tbl)

% control input
if nargin<2 || isempty(selectTreat)
    selectTreat=unique(st.metadata.treatment);
end

if nargin<3 || isempty(selectClus)
    selectClus=unique(st.metadata.seurat_clusters);
end

if nargin<4 || isempty(minExp)
    minExp=10^-6;
end

if nargin<5 || isempty(cellRatio)
    cellRatio=0.1;
end

if nargin<6 || isempty(minCells)
    minCells=10;
end

indout=isnan(st.metadata.mergedCarcinoma);
st.xy(indout,:)=[];
st.mat(:,indout)=[];
st.mat_norm(:,indout)=[];
st.metadata(indout,:)=[];

MIN_UMI=min(st.mat_norm(st.mat_norm~=0));
st.mat_norm(st.mat_norm==0)=MIN_UMI;
st.mat_norm=bsxfun(@rdivide,st.mat_norm,sum(st.mat_norm));

%calc. mean exp per st clusters 
[G0,ident0,treat0]=findgroups(st.metadata.seurat_clusters,st.metadata.treatment);
meanMat=splitapply(@(x) nanmean(x,1), st.mat_norm',G0)';
sizeMat=splitapply(@size,st.mat_norm',G0);

%filter clusters based on input and total cell count more than C
C=15;
tInd=ismember(lower(treat0),lower(selectTreat));
cInd=ismember(lower(ident0),lower(selectClus));
clusInd=tInd & cInd & sizeMat(:,1)>=C;

%returen in case 0 results
if sum(clusInd) <= 1
    varNames={'Ligand' 'Receptor' 'L_Clus' 'R_Clus' 'Zscore' 'L_Zscore' 'R_Zscore' 'L_MeanExp' 'R_MeanExp' 'L_CellRatio' 'R_CellRatio','L_CellNum','R_CellNum','Direction'};
    Tt = array2table(zeros(0,size(varNames,2)));
    Tt.Properties.VariableNames = varNames;
    interactionTable=Tt;
    return;
end

%filter genes based on expression
EXP_THRESH=minExp;
geneInd=find(max(meanMat(:,clusInd),[],2)>=EXP_THRESH);    %by thresh
filtGenes=st.all_genes(geneInd);

%load genes list
load inputData.mat lr_ramilowski
lr=lr_ramilowski;
intTable=[table(lr(:,1),lr(:,2),repmat({'-'},length(lr),1),'VariableNames',{'Gene1' 'Gene2' 'Direction'})];

[~,ia,~]=unique(intTable(:,1:2),'rows','stable'); %find unique interactions from two datasets
intTable=intTable(ia,:); %update intTable to include only unique rows
[l1,~]=ismember(intTable.Gene1,st.all_genes); 
[r1,~]=ismember(intTable.Gene2,st.all_genes); 
lrInd=l1 & r1; %present both columns and has hih THRESH
intTable=intTable(lrInd,:); %update interaction table
[~,lind]=ismember(intTable.Gene1,st.all_genes); %st.all_genes indices
[~,rind]=ismember(intTable.Gene2,st.all_genes); %st.all_genes indices
highTHRESH=ismember(lind,geneInd) & ismember(rind,geneInd);
lind=lind(highTHRESH);
rind=rind(highTHRESH);

%abs number and the avg number of the pos cells
lNumPosCells=splitapply(@(x) sum(x,1),st.mat(lind,:)'>MIN_UMI,G0)';     lNumPosCells=lNumPosCells(:,clusInd);
rNumPosCells=splitapply(@(x) sum(x,1),st.mat(rind,:)'>MIN_UMI,G0)';     rNumPosCells=rNumPosCells(:,clusInd);
lAvgPosCells=splitapply(@(x) mean(x,1),st.mat(lind,:)'>MIN_UMI,G0)';    lAvgPosCells=lAvgPosCells(:,clusInd); 
rAvgPosCells=splitapply(@(x) mean(x,1),st.mat(rind,:)'>MIN_UMI,G0)';    rAvgPosCells=rAvgPosCells(:,clusInd);

%clac. mean and zscore for the selected treatment
meanExpL=meanMat(lind,clusInd);  
meanExpR=meanMat(rind,clusInd);   

meanExpLlog=log10(meanExpL);
meanExpRlog=log10(meanExpR);

zScoreL=zeros(size(meanExpL)); zScoreR=zeros(size(meanExpR)); %#ok<PREALL>
zScoreL=bsxfun(@rdivide,bsxfun(@minus,meanExpLlog,mean(meanExpLlog,2)),std(meanExpLlog,[],2));
zScoreR=bsxfun(@rdivide,bsxfun(@minus,meanExpRlog,mean(meanExpRlog,2)),std(meanExpRlog,[],2));
zScoreL(zScoreL<0)=0;   
zScoreR(zScoreR<0)=0;

% make new nms
treatFirstLet = cellfun(@(x) x(1), treat0(clusInd), 'un', 0); %take the first letter of the treat
[~,locb]=ismember(ident0(clusInd),tbl.cellNumber);
nms=strcat(tbl.cellName(locb),'_',lower(treatFirstLet));

% %make the final table
subPlotDim=arrayfun(@(i) sqrt(bsxfun(@plus,zScoreL(i,:).^2',zScoreR(i,:).^2)),1:size(zScoreL,1),'UniformOutput',0);
all=reshape(cat(3,subPlotDim{:}),size(subPlotDim{1},1),size(subPlotDim{1},1),[]);
K=squeeze(reshape(all,[],1,size(all,3)));
[Zscore,ind]=sort(K,1);
[LclusInd,RclusInd]=ind2sub([size(all,1),size(all,2)],ind); 
Ligand=repelem(st.all_genes(lind),size(K,1)); 
Receptor=repelem(st.all_genes(rind),size(K,1));
L_Clus=reshape(LclusInd,[],1);
R_Clus=reshape(RclusInd,[],1);
Zscore=reshape(Zscore,[],1);
L_Zscore=arrayfun(@(x) zScoreL(x,LclusInd(:,x)),find(lind),'UniformOutput',0); L_Zscore=cat(2,L_Zscore{:})';
R_Zscore=arrayfun(@(x) zScoreR(x,RclusInd(:,x)),find(rind),'UniformOutput',0); R_Zscore=cat(2,R_Zscore{:})';
L_MeanExp=arrayfun(@(x) meanExpL(x,LclusInd(:,x)),find(lind),'UniformOutput',0); L_MeanExp=cat(2,L_MeanExp{:})';
R_MeanExp=arrayfun(@(x) meanExpR(x,RclusInd(:,x)),find(rind),'UniformOutput',0); R_MeanExp=cat(2,R_MeanExp{:})';
L_CellRatio=arrayfun(@(x) lAvgPosCells(x,LclusInd(:,x)),find(lind),'UniformOutput',0); L_CellRatio=cat(2,L_CellRatio{:})';
R_CellRatio=arrayfun(@(x) rAvgPosCells(x,RclusInd(:,x)),find(rind),'UniformOutput',0); R_CellRatio=cat(2,R_CellRatio{:})';
L_CellNum=arrayfun(@(x) lNumPosCells(x,LclusInd(:,x)),find(lind),'UniformOutput',0); L_CellNum=cat(2,L_CellNum{:})';
R_CellNum=arrayfun(@(x) rNumPosCells(x,RclusInd(:,x)),find(rind),'UniformOutput',0); R_CellNum=cat(2,R_CellNum{:})';

%filter the final table
Tt=table(Ligand,Receptor,L_Clus,R_Clus,Zscore,L_Zscore,R_Zscore,L_MeanExp,R_MeanExp,L_CellRatio,R_CellRatio,L_CellNum,R_CellNum);
Tt.Properties.VariableNames = {'Ligand' 'Receptor' 'L_Clus' 'R_Clus' 'Zscore' 'L_Zscore' 'R_Zscore' 'L_MeanExp' 'R_MeanExp' 'L_CellRatio' 'R_CellRatio','L_CellNum','R_CellNum'};
Tt(Tt.Zscore==0 | Tt.L_Zscore==0 | Tt.R_Zscore==0 | Tt.L_MeanExp==0 | Tt.R_MeanExp==0 | Tt.L_CellRatio==0 | Tt.R_CellRatio==0 | Tt.L_CellNum==0 | Tt.R_CellNum==0,:)=[]; T1=Tt; T1.L_Clus=nms(Tt.L_Clus); T1.R_Clus=nms(Tt.R_Clus);
Tt(Tt.L_MeanExp<minExp | Tt.R_MeanExp<minExp | Tt.L_CellRatio<cellRatio | Tt.R_CellRatio<cellRatio | Tt.L_CellNum<minCells | Tt.R_CellNum<minCells,:)=[]; T2=Tt; T2.L_Clus=nms(Tt.L_Clus); T2.R_Clus=nms(Tt.R_Clus);
Tt=Tt(Tt.Zscore>=1.5,:); T3=Tt; T3.L_Clus=nms(Tt.L_Clus); T3.R_Clus=nms(Tt.R_Clus);

%add more T3 table 
T3=sortrows(T3,'Zscore','descend');
[iind1,iind2]=ismember(strcat(intTable.Gene1,intTable.Gene2),strcat(T3.Ligand,T3.Receptor)); iind2(iind2==0)=[];
T3.Direction=repmat({'-'},size(T3,1),1);
T3.Direction(iind2)=intTable.Direction(iind1);

%save the filtered table
interactionTable=T3;
end

