function [pp_lm, pc_lm, pp_lm_ind,pc_lm_ind]=extract_lm_genes(hlz,marker_indices_lcm,cluster,PC_THRESH,PP_THRESH,EXP_THRESH)

% [pp_lm, pc_lm, pp_lm_ind,pc_lm_ind]=extract_lm_genes(hlz,marker_indices_lcm,cluster,PC_THRESH,PP_THRESH,EXP_THRESH)
% extracts landmark genes
% marker_indices_lcm are obtained from find_markers.m



if nargin<4
    PC_THRESH=3;
end
if nargin<5
    PP_THRESH=4;
end
if nargin<6
    EXP_THRESH=10^-4;
end
% compute com
com=zeros(length(hlz.all_genes),1);
for i=1:length(hlz.all_genes)
    com(i)=sum((1:size(hlz.mean,2)).*hlz.mean(i,:))/sum(hlz.mean(i,:));
end
[mx,mxind]=max(hlz.mean,[],2);
figure;
hold on;
plot(com(marker_indices_lcm{cluster}),log10(mx(marker_indices_lcm{cluster})),'.');
x=com(marker_indices_lcm{cluster});
y=log10(mx(marker_indices_lcm{cluster}));
indout=find(isnan(x));
x(indout)=[];
y(indout)=[];
[n,c] = hist3([x,y]);
contour(c{1},c{2},n')
plot([PC_THRESH PC_THRESH],[min(ylim) max(ylim)],'--r');
plot([PP_THRESH PP_THRESH],[min(ylim) max(ylim)],'--r');
for i=1:length(marker_indices_lcm{cluster})
    text(com((marker_indices_lcm{cluster}(i))),log10(mx(marker_indices_lcm{cluster}(i))),hlz.all_genes{marker_indices_lcm{cluster}(i)},'FontSize',8);
end
xlabel('zonation COM');
ylabel('log10(max mean expression)');
pc_lm_ind=find(com((marker_indices_lcm{cluster}))<=PC_THRESH & mx((marker_indices_lcm{cluster}))>EXP_THRESH);
pc_lm_ind=marker_indices_lcm{cluster}(pc_lm_ind);
pc_lm=hlz.all_genes(pc_lm_ind);
pp_lm_ind=find(com((marker_indices_lcm{cluster}))>=PP_THRESH & mx((marker_indices_lcm{cluster}))>EXP_THRESH);
pp_lm_ind=marker_indices_lcm{cluster}(pp_lm_ind);
pp_lm=hlz.all_genes(pp_lm_ind);
%%
figure('units','centimeters','Position',[30.6388   12.5413  12.7516    5.4478]);
subplot(1,2,1);
imagesc(hlz.mean(pc_lm_ind,:)./max(hlz.mean(pc_lm_ind,:),[],2));
hcb=colorbar;
ylabel(hcb,{'relative expression'});
set(gca,'ytick',1:length(pc_lm_ind));
set(gca,'YTickLabel',pc_lm);
title('pericentral LM');
xlabel('lobule layers')
for i=1:length(pc_lm_ind),
    line(xlim,[i-0.5 i-0.5],'color','k');
end
for i=1:size(hlz.mean,2)
    line([i-0.5 i-0.5],ylim,'color','k');
end
set(gca,'XTick',1:size(hlz.mean,2));
set(gca,'XTickLabel',{'L1','L2','L3','L4','L5','L6'});
set(gca,'FontSize',8);

subplot(1,2,2);
imagesc(hlz.mean(pp_lm_ind,:)./max(hlz.mean(pp_lm_ind,:),[],2));
hcb=colorbar;
ylabel(hcb,{'relative expression'});
set(gca,'ytick',1:length(pp_lm_ind));
set(gca,'YTickLabel',pp_lm);
title('periportal LM');
xlabel('lobule layers')
for i=1:length(pp_lm_ind),
    line(xlim,[i-0.5 i-0.5],'color','k');
end
for i=1:size(hlz.mean,2)
    line([i-0.5 i-0.5],ylim,'color','k');
end
set(gca,'XTick',1:size(hlz.mean,2));
set(gca,'XTickLabel',{'L1','L2','L3','L4','L5','L6'});
set(gca,'FontSize',8);
