function [h]=GSEA_plot(NES,SZ,nms,MIN_SIZE,MAX_SIZE,colr,txtSZ)

% Visual plots of GSEA results.
% Usage: GSEA_plot(NES,SZ,nms,MIN_SIZE,MAX_SIZE,colr)
% NES is a vector of normalized enrichment scores of N gene sets from GSEA
% SZ is a vector of length N of the number of genes in each set
% nms is a cell array of the gene set names
% MIN_SIZE and MAX_SIZE control the size of the circles
% colr is the color of the circle
% txtSZ control the size of text, defualt=14
% Example usage: 
% NES=logspace(log10(3),log10(5),20);SZ=round(50*rand(1,20));for i=1:length(SZ), nms{i}=['group ' num2str(i)];end
% figure;GSEA_plot(NES,SZ,nms,2,300,'b')


if nargin<4
    MIN_SIZE=2;
end
if nargin<5
    MAX_SIZE=100;
end
if nargin<6
    colr='r';
end
if nargin<7
    txtSZ=14;
end


sz=MIN_SIZE+((SZ-min(SZ))/(max(SZ)-min(SZ)))*(MAX_SIZE-MIN_SIZE);
[~,edges,bins]=histcounts(sz,5);
newSZ=edges(bins+1);
hold on;
for i=1:length(NES)
    if size(colr,2)==3
        %h=scatter(NES(i),length(NES)+1-i,sz,'filled','MarkerFaceColor',colr(i,:),'MarkerEdgeColor',[.7 .7 .7]);
        h=scatter(NES(i),length(NES)+1-i,newSZ(i),'filled','MarkerFaceColor',colr(i,:),'MarkerEdgeColor',[.7 .7 .7]);
    else
        %h=scatter(NES(i),length(NES)+1-i,sz,'filled','MarkerFaceColor',colr,'MarkerEdgeColor',[.7 .7 .7]);
        h=scatter(NES(i),length(NES)+1-i,newSZ(i),'filled','MarkerFaceColor',colr,'MarkerEdgeColor',[.7 .7 .7]);
    end
end

% % make legends 
% clear txt
% for i=1:length(edges)-1
%     txt(i)={[num2str(edges(i)),'-',num2str(edges(i+1))]};
% end
% [hLg, icons]=legend(txt);
% icons = findobj(icons,'Type','patch');
% icons = findobj(icons,'Marker','none','-xor');
% for i=1:length(icons)
%     icons(i).MarkerSize=sqrt(edges(i+1));
%     icons(i).MarkerFaceColor=[.3 .3 .3];
% end
% hLg.Color = 'none';
% hLg.Box = 'off';

% reverse order of names
nms2 = [];
for i = 1:length(NES)
    nms2 = [nms2; nms(length(NES)+1-i)];
end
nms2=strrep(nms2,'_',' ');
set(gca,'ytick',1:length(nms2));
set(gca,'yticklabel',nms2);
ylim([0, length(NES)+1]);
xlabel('Normalized enrichment score');
set(gca,'fontsize',txtSZ);
box on;
grid on;


