%% Create_Interactions_Network %%
%this script create data used in figure 3

addpath(genpath('./helperFunctions'));
load ./inputData.mat hint tbl param
outputDir='interaction_output';
mkdir(outputDir);

%% merge the malignant stellate cells with CAFs
cellNum=tbl.cellNumber(ismember(tbl.cellName,'Stellate cells'));
ind=find(ismember(hint.metadata.treatment,'tumor') & ismember(hint.metadata.seurat_clusters,cellNum));
hint.metadata.seurat_clusters(ind)=tbl.cellNumber(ismember(tbl.cellName,'CAFs'));

%% find interactions between cells types of 'Tumor' origin per patient
MIN_EXP=10^-5;
cellRatio=0;
minCells=7;

ind=find(strcmpi(hint.metadata.human,'p1'));
P1=subStruct(hint,ind);
p1=findInteractions(P1,{'Tumor'},{},MIN_EXP,cellRatio,minCells,tbl);
[~,iind]=unique(p1(:,1:4),'rows','stable'); p1=p1(iind,:);
p1.h=repmat({'p1'},size(p1,1),1);

ind=find(strcmpi(hint.metadata.human,'p2'));
P2=subStruct(hint,ind);
p2=findInteractions(P2,{'Tumor'},{},MIN_EXP,cellRatio,minCells,tbl);
[~,iind]=unique(p2(:,1:4),'rows','stable'); p2=p2(iind,:);
p2.h=repmat({'p2'},size(p2,1),1);

ind=find(strcmpi(hint.metadata.human,'p3'));
P3=subStruct(hint,ind);
p3=findInteractions(P3,{'Tumor'},{},MIN_EXP,cellRatio,minCells,tbl);
[~,iind]=unique(p3(:,1:4),'rows','stable'); p3=p3(iind,:);
p3.h=repmat({'p3'},size(p3,1),1);

ind=find(strcmpi(hint.metadata.human,'p4'));
P4=subStruct(hint,ind);
p4=findInteractions(P4,{'Tumor'},{},MIN_EXP,cellRatio,minCells,tbl);
[~,iind]=unique(p4(:,1:4),'rows','stable'); p4=p4(iind,:);
p4.h=repmat({'p4'},size(p4,1),1);

ind=find(strcmpi(hint.metadata.human,'p5'));
P5=subStruct(hint,ind);
p5=findInteractions(P5,{'Tumor'},{},MIN_EXP,cellRatio,minCells,tbl);
[~,iind]=unique(p5(:,1:4),'rows','stable'); p5=p5(iind,:);
p5.h=repmat({'p5'},size(p5,1),1);

ind=find(strcmpi(hint.metadata.human,'p6'));
P6=subStruct(hint,ind);
p6=findInteractions(P6,{'Tumor'},{},MIN_EXP,cellRatio,minCells,tbl);
[~,iind]=unique(p6(:,1:4),'rows','stable'); p6=p6(iind,:);
p6.h=repmat({'p6'},size(p6,1),1);

%% define tumor clusters 
[~,locb]=ismember(hint.metadata.seurat_clusters,tbl.cellNumber);
hint.clusterNames=tbl.cellName(locb);
[G0,ident0,treat0]=findgroups(hint.clusterNames,hint.metadata.treatment);
sizeMat=splitapply(@size,hint.mat_norm',G0);
uident=unique(ident0);
sizeRatio=zeros(length(uident),1);
for i=1:length(uident)
    sizeAll=sum(sizeMat(ismember(ident0,uident(i)),1));
    if isempty(sizeMat(ismember(ident0,uident(i)) & ismember(treat0,'tumor'),1))
        continue;
    end
    sizeTumor=sizeMat(ismember(ident0,uident(i)) & ismember(treat0,'tumor'),1);
    sizeRatio(i)=sizeTumor./sizeAll;
end
t=table(uident,sizeRatio,'VariableNames',{'uident','ratio'});
indin=(sizeRatio>0.20); 
t=t(indin,:);
t = sortrows(t,'ratio','ascend');
tumorClusters=strcat(t.uident,'_t');

%% plot number of interactions on heatmap (Figure 3a)
% make adjacency matrix
hall2=[p1;p2;p3;p4;p5];
subHall2=hall2(ismember(hall2.L_Clus,tumorClusters) & ismember(hall2.R_Clus,tumorClusters),:);
[uniqReMat,~,~]=unique(subHall2(:,{'Ligand','Receptor','L_Clus','R_Clus'}),'rows','stable'); 

TT = table2cell(uniqReMat);
unms = unique([TT(:,3);TT(:,4)]);
[~,locbL]=ismember(TT(:,3),unms);
[~,locbR]=ismember(TT(:,4),unms);
nodePairs = [locbL,locbR];
adj = accumarray(nodePairs, 1);

% remove Pro cluster
short_nms=strtok(unms, '_');

cg = clustergram(adj,'RowLabels',short_nms,'ColumnLabels',short_nms,'Colormap',redbluecmap,'showDendrogram','off');
cgAxes = plot(cg);
set(cgAxes, 'Clim', [min(adj(:)),max(adj(:))])
set(cgAxes, 'XTickLabelRotation',0);
set(cgAxes, 'XAxisLocation','top');
set(cgAxes, 'YAxisLocation','left');
set(cgAxes, 'YDir','reverse');
colormap(hot(max(adj(:))));
cbh = colorbar; 
caxis([0 max(adj(:))+1])

ordering = get(cg, 'RowLabels');
[~, ind] = ismember(get(cg, 'RowLabels'), short_nms);
close all hidden

ADJ=adj(ind, ind);
SN=short_nms(ind);
mincolor = min(ADJ(:));
maxcolor = max(ADJ(:));
clabel = arrayfun(@(x){sprintf('%0.f',x)}, ADJ);

figure; 
set(gcf, 'Units','centimeters', 'Position',[62.2035 3 8 8])
h = heatmap(ADJ, SN, SN, clabel,'ShowAllTicks', true,...
    'TickFontSize', param.axisFontSize,'TickAngle', 45,'FontSize', 5.5,...
    'MinColorValue', mincolor, 'MaxColorValue', maxcolor);
ylabel('Sender cell type','FontSize',param.titleFontSize)
xlabel('Acceptor cell type','FontSize',param.titleFontSize)  
set(gca,'xaxisLocation','top')
axis tight 
axis square
hold all
[rows, columns] = size(ADJ);
spacing = 1;
for row = 0.5 : spacing : rows
  line([1-spacing./2, columns+spacing./2], [row, row],'LineWidth',0.5,'Color',[0 0 0]);
end
for column = 0.5 : spacing  : columns
  line([column, column], [1-spacing./2, rows+spacing./2],'LineWidth',0.5,'Color',[0 0 0]);
end
for i=1:length(SN)
    plot([1+0.5],[max(ylim) 0.5],'LineWidth',1,'Color',[0 0 0])
end
hold off

%% filter in recurring interactions for 3 patients and more
patiants_NUMBER=3;
hall=[p1;p2;p3;p4;p5;p6];

% remove proliferation 
tumorClustersNoPro=setdiff(tumorClusters,'Proliferation_t');
hall=hall(ismember(hall.L_Clus,tumorClustersNoPro) & ismember(hall.R_Clus,tumorClustersNoPro),:);
LL_Clus=hall.L_Clus; LL_Clus(~ismember(hall.L_Clus,'Carcinoma_t'))={'nonCarcinoma_t'};
RR_Clus=hall.R_Clus; RR_Clus(~ismember(hall.R_Clus,'Carcinoma_t'))={'nonCarcinoma_t'};
hall=[hall,table(LL_Clus),table(RR_Clus)];
hall_tum=hall(ismember(hall.LL_Clus,'Carcinoma_t') | ismember(hall.RR_Clus,'Carcinoma_t'),:); 
hall_tum(ismember(hall_tum.LL_Clus,'Carcinoma_t') & ismember(hall_tum.RR_Clus,'Carcinoma_t'),:)=[]; 
[~,ia,ic]=unique(hall_tum(:,{'Ligand','Receptor','h','LL_Clus','RR_Clus'}),'rows','stable'); 
c=hall_tum(ia,{'Ligand','Receptor','L_Clus','R_Clus','Zscore','L_Zscore','R_Zscore','h','LL_Clus','RR_Clus'});
[~,iaa,icc]=unique(c(:,{'Ligand','Receptor','LL_Clus','RR_Clus'}),'rows','stable'); 
a_counts = accumarray(icc,1); 
maph = a_counts(icc);        
mergeTable = [c, table(maph)];
reMat=mergeTable(mergeTable.maph>=patiants_NUMBER,:); 

% rewrite the max zscore for all similar interactions
[z,za,iz]=unique(reMat(:,{'Ligand','Receptor'}),'rows','stable'); 
for i=1:height(z)
    locl=find(za(i)==iz);
    mx=max(table2array(reMat(locl,'Zscore')));
    reMat(locl,'Zscore')=table(repmat(mx,length(locl),1),'VariableNames',{'Zscore'});
end

% find number of cell types for ligand
[l,la,il]=unique(reMat(:,{'Ligand','L_Clus'}),'rows','stable'); 
[ll,laa,ill]=unique(l(:,{'Ligand'}),'rows','stable'); 
    l_counts = accumarray(ill,1); 
    luc = l_counts(ill(il));      
    luc = array2table(luc);
    reMat0 = [reMat, luc];
    
% find number of cell types for receptor
[r,ra,ir]=unique(reMat(:,{'Receptor','R_Clus'}),'rows','stable'); 
[rr,raa,irr]=unique(r(:,'Receptor'),'rows','stable'); 
    r_counts = accumarray(irr,1); 
    ruc = r_counts(irr(ir));      
    ruc = array2table(ruc);
    reMat0 = [reMat0, ruc];

[~,iaaa,iccc]=unique(reMat0(:,{'Ligand','Receptor'}),'rows','stable');
uniqReMat=reMat0(iaaa,{'Ligand','Receptor','Zscore','LL_Clus','RR_Clus','maph','luc','ruc'});

% map cell type to L R based on the final table 
clear lucName rucName lucCol rucCol
for i=1:height(uniqReMat)
    locl=find(strcmpi(uniqReMat.Ligand(i),reMat0.Ligand));
    lc=strtok(unique(reMat0.L_Clus(locl)),'_');
    lucName(i)={strjoin(lc,'|')};
    lucCol(i)={tbl.cellColor(ismember(tbl.cellName,lc))};
    
    locr=find(strcmpi(uniqReMat.Receptor(i),reMat0.Receptor));
    rc=strtok(unique(reMat0.R_Clus(locr)),'_');
    rucName(i)={strjoin(rc,'|')};
    rucCol(i)={tbl.cellColor(ismember(tbl.cellName,rc))};
end
lucName=cell2table(lucName'); lucName.Properties.VariableNames{'Var1'}='lucName';
rucName=cell2table(rucName'); rucName.Properties.VariableNames{'Var1'}='rucName';
lucCol=cell2table(lucCol'); lucCol.Properties.VariableNames{'Var1'}='lucCol';
rucCol=cell2table(rucCol'); rucCol.Properties.VariableNames{'Var1'}='rucCol';
uniqReMat = [uniqReMat,lucName,rucName];

%% examples of double or more interactions
% make dot plot, extract clusters from uniqReMat
ordNames={'CAFs','Pericytes','SAMs','cDC2','TM1','B cells','T cells','LVECm','Carcinoma'};
data=[uniqReMat.lucName,uniqReMat.rucName];
sdata=[];
for i=1:length(data)
   tmp=strsplit(data{i},'|');
   sdata=[sdata,tmp];
end
udata=unique(sdata);
[~,ord]=ismember(ordNames,udata);
udata=udata(ord);

% norm. gene expression for the selected genes
mm=hint.mat_norm;
MIN_UMI=min(hint.mat_norm(hint.mat_norm~=0)); 
mm(mm==0)=MIN_UMI;
mm=bsxfun(@rdivide,mm,sum(mm));

% calc. mean expression for selected genes across selected clusters
genes={'WNT5A','FZD5','CTHRC1','HGF','MET','DCN'};
[~,indGenes]=ismember(genes,hint.all_genes);
MIN_POS_CELLS=10;
MIN_RATIO=0.1;
clear meanMat numPosCells
for i=1:length(udata)
    ind1=find(ismember(hint.clusterNames,udata(i)) & ismember(hint.metadata.treatment,'tumor'));
    numPosCells(:,i)=sum(mm(indGenes,ind1)>MIN_UMI,2);
    m1=mean(mm(indGenes,ind1),2);
    m1(numPosCells(:,i)<MIN_POS_CELLS)=0;
    meanMat(:,i)=m1;
end
meanMatMax=bsxfun(@rdivide,meanMat,max(meanMat,[],2));
numPosCellsMax=bsxfun(@rdivide,numPosCells,max(numPosCells,[],2));

% calc mesh
y=1:size(meanMatMax,1);
x=1:size(meanMatMax,2);
[xx,yy]=meshgrid(x,y);

% make figure
fig1=figure('Units','centimeters', 'Position',[62.2035 3 7 7]);
hold on
factor=100; 
dotSzie=factor*numPosCellsMax(:);
dotSzie(dotSzie==0)=1;

s1=scatter(xx(:),yy(:),dotSzie,meanMatMax(:),'filled','MarkerEdgeColor',[.8 .8 .8]);

colormap(cbrewer('seq','GnBu',length(meanMatMax(:)),'PCHIP'));
set(gca,'YTick',y);
set(gca,'YTickLabel',genes,'FontSize',param.axisFontSize);
set(gca,'XTick',x);
set(gca,'XTickLabel',udata,'FontSize',param.axisFontSize);
set(gca,'XTickLabelRotation',45);
set(gca,'XaxisLocation','top');
set(gca,'TickLength',[0 0]);

box on
grid on
ax = gca;
ax.GridColor = [.7 .7 .7];
ax.GridLineStyle = ':';
ax.GridAlpha = .7;
ax.Layer = 'bottom';

axis tight
ap=axis;
axisDelta=0.5; 
set(gca,'Xlim',[ap(1)-axisDelta ap(2)+axisDelta],'YLim',[ap(3)-axisDelta ap(4)+axisDelta])

fig_pos=get(gcf,'Position');
ax=gca;
ax.Units='centimeters';
axes_pos=ax.Position;
set(gcf,'Position',[fig_pos(1) fig_pos(2) fig_pos(3)+2 fig_pos(4)+2]);

hcb=colorbar;
hcb.TickLength=0.03;
a = hcb.Position;
ylabel(hcb,'relative expression','FontSize',param.axisFontSize);
set(hcb,'Position',[a(1)+0.15 a(2) 0.02 0.1])

% add dot legends 
[~,edges,bins]=histcounts(numPosCellsMax(:),5);
clear txt
for i=1:length(edges)-1
    txt(i)={[num2str(edges(i)*100),'-',num2str(edges(i+1)*100),'%']};
    ax2=axes;
    s(i)=scatter(0,0,1,'parent',ax2);
    set(ax2,'visible','off')
end

[hLg, icons]=legend(s,txt);
icons = findobj(icons,'Type','patch');
icons = findobj(icons,'Marker','none','-xor');
for i=1:length(icons)
    icons(i).MarkerSize=sqrt(edges(i+1)*factor);
    icons(i).MarkerFaceColor=[.7 .7 .7];
    icons(i).MarkerEdgeColor=[.3 .3 .3];
end
delete(s);

%% export table for Cytoscape
filename='recurring_interactions_for_Cytoscape.xlsx';
writetable(uniqReMat,fullfile(outputDir,filename),'WriteVariableNames',true);

%% creat Table_S5 %%
% modify col names before exporting
clear T1 T2 T3

tmp=hall_tum;
tmp=removevars(tmp,{'L_CellRatio','R_CellRatio','L_CellNum','R_CellNum','Direction','LL_Clus','RR_Clus'});
tmp.L_Clus=strtok(tmp.L_Clus,'_');    
tmp.R_Clus=strtok(tmp.R_Clus,'_');
tmp.Properties.VariableNames={'ligand' 'receptor' 'ligand_cluster' 'receptor_cluster' 'interaction_zscore'...
    'ligand_zscore' 'receptor_zscore' 'ligand_Mean_expression' 'receptor_Mean_expression' 'patient'};
T1=tmp;

clear tmp;
tmp=reMat0;
tmp=removevars(tmp,{'LL_Clus','RR_Clus','luc','ruc','maph'});
tmp.L_Clus=strtok(tmp.L_Clus,'_');    
tmp.R_Clus=strtok(tmp.R_Clus,'_');
tmp.Properties.VariableNames={'ligand' 'receptor' 'ligand_cluster' 'receptor_cluster' 'interaction_zscore'...
    'ligand_zscore' 'receptor_zscore' 'patient'};
T2=tmp;

clear tmp;
tmp=uniqReMat;
tmp=removevars(tmp,{'LL_Clus','RR_Clus','luc','ruc'});
tmp.Properties.VariableNames={'ligand' 'receptor' 'interaction_zscore'...
    'recurring_patients_number' 'ligand_clusters' 'receptor_clusters'};
T3=tmp;

%creat and save table_S5
fileName = 'Table_S5.xlsx';
sheetName = {'carcinoma_stroma_interactions','recurring_interactions','unique_recurring_interactions'};
vars = {'T1','T2','T3'};
headerLine={'Table S5 - interactions between carcinoma cells and malignant stromal cells per pateint',...
            'Table S5 - recurring carcinoma-stroma interactions in three pateint or more',...
            'Table S5 - unique recurring carcinoma-stroma interactions in three pateint or more'};

for i=1:numel(sheetName)
    writecell(headerLine(i), fullfile(outputDir,fileName),'Sheet' ,sheetName{i}, 'Range', 'A1');
    writetable(eval(vars{i}),fullfile(outputDir,fileName),'Sheet' ,sheetName{i}, 'WriteVariableNames',true, 'Range', 'A3');
end

%%% end of 'creat_interaction_network.m' %%%