}q (K}q(X   libqX   libsshqX
   utterancesq}q(K }q(X
   message_idqX   1qX   textq	X+   how do I create a new ssh_session in libsshq
X   speakerqX
   ProgrammerqX   linkq
NX   backward-facingqNX
   illocutionaryqX   ELICIT-OFFER-OR-SUGGESTIONqX   apiq]qX   patternsqaX   traceabilityqNuK}q(hX   2qh	X$   Are you looking for ssh_new(void )? qhX   Apizaqh
X   0qhX   POSqhX   SUGGESTqh]qX   patternsqah]qX   ssh_newqauK}q (hhh	X1   Returns A new ssh_session pointer, NULL on error.q!hX   Apizaq"h
hhX   CONTq#hX   INFORMq$h]q%(X   basicq&X
   functionalityq'eh]q(X   ssh_newq)auK}q*(hX   3q+h	X)   What is in ssh_session_struct for libssh?q,hX
   Programmerq-h
hhX   FOLq.hX
   ELICIT-INFORMq/h]q0X	   structureq1ah]q2X   ssh_sessionq3auK}q4(hX   4q5h	X'   How do I connect to localhost in libsshq6hX
   Programmerq7h
NhNhX   ELICIT-OFFER-OR-SUGGESTIONq8h]q9X   patternsq:ahNuK}q;(hX   5q<h	X>   The ssh::Session class contains the state of a SSH connection.q=hX   Apizaq>h
h+hX   POSq?hX   INFORMq@h]qAX   conceptsqBah]qCX   ssh::SessionqDauK}qE(hX   6qFh	Xb   I found the following similar to "connect" and "localhost": ssh_connect() and ssh_options_getopt()qGhX   ApizaqHh
h5hX   PARTqIhX   INFORMqJh]qKX   patternsqLah]qM(X   ssh_connectqNX   ssh_options_getoptqOeuK}qP(hX   7qQh	X9   Show me an example of connecting to localhost with libsshqRhX
   ProgrammerqSh
NhNhX
   ELICIT-INFORMqTh]qUX   examplesqVahNuK}qW(hX   8qXh	X   To connect to a particular host, you may use ssh_options_set(ssh_session session, enum ssh_options_e type, const void * value ) using the parameter SSH_OPTIONS_HOST: The hostname or ip address to connect to (const char *).qYhX   ApizaqZh
hQhX   POSq[hX   SUGGESTq\h]q](X   patternsq^X   basicq_eh]q`X   ssh_options_setqaauK	}qb(hX   9qch	XH   For example: ssh_options_set(my_session, SSH_OPTIONS_HOST, "localhost");qdhX   Apizaqeh
hXhX   CONTqfhX   INFORMqgh]qhX   examplesqiah]qjX   ssh_options_setqkauK
}ql(hX   10qmh	X   What does ssh_connect return?qnhX
   Programmerqoh
hFhX   FOLqphX
   ELICIT-INFORMqqh]qrX
   functionalityqsah]qtX   ssh_connectquauK}qv(hX   11qwh	X}   Returns SSH_OK on success, SSH_ERROR on error. SSH_AGAIN, if the session is in nonblocking mode, and call must be done again.qxhX   Apizaqyh
X   10qzhX   POSq{hX   INFORMq|h]q}X
   functionalityq~ah]qX   ssh_connectqauK}q(hX   12qh	X#   Please list the functions in libsshqhX
   Programmerqh
NhNhX
   ELICIT-INFORMqh]qX	   structureqahNuK
}q(hX   13qh	X$   There are many functions in libssh. qhX   Apizaqh
X   12qhX   PARTqhX   INFORMqh]qX	   structureqahNuK}q(hX   13qh	X:   Can you specify what kind of function you are looking for?qhX   Apizaqh
X   12qhX   FOLqhX   SUGGESTqhNhNuK}q(hX   14qh	X+   How do I authenticate the server in libssh?qhX
   Programmerqh
NhNhX   ELICIT-OFFER-OR-SUGGESTIONqh]qX   patternsqahNuK}q(hX   15qh	X9   How do I disconnect from the server and free the session?qhX
   Programmerqh
NhNhX   ELICIT-OFFER-OR-SUGGESTIONqh]qX   patternsqahNuK}q(hX   16qh	X$   How do I disconnect from the server?qhX
   Programmerqh
NhNhX   ELICIT-OFFER-OR-SUGGESTIONqh]qX   patternsqahNuK}q(hX   17qh	X$   How do I free the session in libssh?qhX
   Programmerqh
NhNhX   ELICIT-OFFER-OR-SUGGESTIONqh]qX   patternsqahNuK}q(hX   18qh	X+   Are you looking for ssh_is_server_known()? qhX   Apizaqh
X   15qhX   POSqhX   SUGGESTqh]qX   patternsqah]qX   ssh_is_server_knownqauK}q(hX   18qh	XR   Checks the user's known host file for a previous connection to the current server.qhX   Apizaqh
X   19qhX   CONTqhX   INFORMqh]qX
   functionalityqah]qX   ssh_is_server_knownqauK}q(hX   19qh	XM   Are you looking for ssh_disconnect(), ssh_silent_disconnect(), or ssh_free()?qhX   Apizaqh
X   16qhX   POSqhX
   ELICIT-INFORMqh]qX   patternsqah]q(X   ssh_disconnectqX   ssh_silent_disconnectqX   ssh_freeqeuK}q(hX   20qh	X>   You may ask for more information about any of these functions.qhX   Apizaqh
X   21qhX   FOLqhX   SUGGESTqhNh]q(X   ssh_disconnectqX   ssh_freeqeuK}q(hX   21qh	X/   What does ssh_is_server_known return in libssh?qhX
   Programmerqh
X   19qhX   FOLqhX
   ELICIT-INFORMqh]q(X
   functionalityqX   basicqeh]qX   ssh_is_server_knownqauK}q(hX   22qh	X)   What does ssh_disconnect return in libsshqhX
   Programmerqh
X   21qhX   FOLqhX
   ELICIT-INFORMqh]q(X
   functionalityqX   basicqeh]qX   ssh_disconnectqauK}q(hX   23qh	X$   What does ssh_free return in libssh?qhX
   Programmerqh
X   21qhX   FOLqhX
   ELICIT-INFORMqh]r   (X
   functionalityr  X   basicr  eh]r  X   ssh_freer  auK}r  (hX   24r  h	X  ssh_is_server_known returns SSH_SERVER_KNOWN_OK: The server is known and has not changed.\nSSH_SERVER_KNOWN_CHANGED: The server key has changed. Either you are under attack or the administrator changed the key. You HAVE to warn the user about a possible attack.\nSSH_SERVER_FOUND_OTHER: The server gave use a key of a type while we had an other type recorded. It is a possible attack.\nSSH_SERVER_NOT_KNOWN: The server is unknown. User should confirm the MD5 is correct.\nSSH_SERVER_FILE_NOT_FOUND: The known host file does not exist. The host is thus unknown. File will be created if host key is accepted.\nSSH_SERVER_ERROR: Some error happened.r  hX   Apizar  h
X   23r	  hX   POSr
  hX   INFORMr  h]r  X
   functionalityr
  ah]r  X   ssh_is_server_knownr  auK}r  (hX   25r  h	X   ssh_disconnect returns void.r  hX   Apizar  h
X   24r  hX   POSr  hX   INFORMr  h]r  X   basicr  ah]r  X   ssh_disconnectr  auK}r  (hX   26r  h	X   ssh_free returns void.r  hX   Apizar  h
X   25r  hX   POSr   hX   INFORMr!  h]r"  X   basicr#  ah]r$  X   ssh_freer%  auK}r&  (hX   27r'  h	X,   How do I create a new ssh_channel in libssh?r(  hX
   Programmerr)  h
NhNhX   ELICIT-OFFER-OR-SUGGESTIONr*  h]r+  X   patternsr,  ah]r-  X   ssh_channelr.  auK}r/  (hX   28r0  h	X#   What object type is an ssh_channel?r1  hX
   Programmerr2  h
NhNhX
   ELICIT-INFORMr3  h]r4  X   basicr5  ah]r6  X   ssh_channelr7  auK}r8  (hX   29r9  h	X*   You may be looking for ssh_channel_new(). r:  hX   Apizar;  h
X   29r<  hX   POSr=  hX   SUGGESTr>  h]r?  X   patternsr@  ah]rA  X   ssh_channel_newrB  auK }rC  (hX   29rD  h	X   Allocate a new channel.rE  hX   ApizarF  h
X   31rG  hX   CONTrH  hX   INFORMrI  h]rJ  X
   functionalityrK  ah]rL  X   ssh_channel_newrM  auK!}rN  (hX   30rO  h	X=   The ssh::Channel class describes the state of an SSH channel.rP  hX   ApizarQ  h
X   30rR  hX   POSrS  hX   INFORMrT  h]rU  X   conceptsrV  ah]rW  X   ssh::ChannelrX  auK"}rY  (hX   31rZ  h	X+   How do I send a command over an ssh:Channelr[  hX
   Programmerr\  h
NhNhX   ELICIT-OFFER-OR-SUGGESTIONr]  h]r^  X   patternsr_  ah]r`  X   ssh::Channelra  auK#}rb  (hX   32rc  h	X   How do I close a channel?rd  hX
   Programmerre  h
NhNhX   ELICIT-OFFER-OR-SUGGESTIONrf  h]rg  X   patternsrh  ahNuK$}ri  (hX   33rj  h	X   How do I free a channel?rk  hX
   Programmerrl  h
NhNhX   ELICIT-OFFER-OR-SUGGESTIONrm  h]rn  X   patternsro  ahNuK%}rp  (hX   34rq  h	X0   Are you looking for ssh_channel_request_exec()? rr  hX   Apizars  h
X   34rt  hX   POSru  hX   SUGGESTrv  h]rw  X   patternsrx  ah]ry  X   ssh_channel_request_execrz  auK&}r{  (hX   34r|  h	XU   Run a shell command without an interactive shell. This is similar to 'sh -c command'.r}  hX   Apizar~  h
X   37r  hX   CONTr  hX   INFORMr  h]r  X
   functionalityr  ah]r  X   ssh_channel_request_execr  auK'}r  (hX   35r  h	X+   You may be looking for ssh_channel_close().r  hX   Apizar  h
X   35r  hX   POSr  hX   SUGGESTr  h]r  X   patternsr  ah]r  X   ssh_channel_closer  auK(}r  (hX   36r  h	X*   You may be looking for ssh_channel_free().r  hX   Apizar  h
X   36r  hX   POSr  hX   SUGGESTr  h]r  X   patternsr  ah]r  X   ssh_channel_freer  auK)}r  (hX   37r  h	X    How do I create an sftp_session?r  hX
   Programmerr  h
NhNhX   ELICIT-OFFER-OR-SUGGESTIONr  h]r  X   patternsr  ah]r  X   sftp_newr  auK*}r  (hX   38r  h	X.   How do I initialize an sftp_session in libssh?r  hX
   Programmerr  h
NhNhX   ELICIT-OFFER-OR-SUGGESTIONr  h]r  X   patternsr  ah]r  X   sftp_newr  auK+}r  (hX   39r  h	X3   What parameters does ssh_channel_request_exec take?r  hX
   Programmerr  h
X   37r  hX   FOLr  hX
   ELICIT-INFORMr  h]r  (X
   functionalityr  X   basicr  eh]r  X   ssh_channel_request_execr  auK,}r  (hX   40r  h	X"   You may be looking for sftp_new().r  hX   Apizar  h
X   41r  hX   POSr  hX   SUGGESTr  h]r  X   patternsr  ah]r  X   sftp_newr  auK-}r  (hX   40r  h	X    Start a new sftp session.r  hX   Apizar  h
X   44r  hX   CONTr  hX   INFORMr  h]r  X   basicr  ah]r  X   sftp_newr  auK.}r  (hX   41r  h	X6   How do I get the output from ssh_channel_request_exec?r  hX
   Programmerr  h
X   37r  hX   FOLr  hX   ELICIT-OFFER-OR-SUGGESTIONr  h]r  (X   patternsr  X
   functionalityr  eh]r  X   ssh_channel_request_execr  auK/}r  (hX   42r  h	X@   ssh_channel_request_exec(ssh_channel channel, const char * cmd).r  hX   Apizar  h
X   43r  hX   POSr  hX   INFORMr  h]r  X   basicr  ah]r  X   ssh_channel_request_execr  auK0}r  (hX   42r  h	X    Parameters are 1) channel: The channel to execute the command. 2) cmd: The command to execute (e.g. "ls ~/ -al | grep -i reports").r  hX   Apizar  h
X   47r  hX   CONTr  hX   INFORMr  h]r  X
   functionalityr  ah]r  X   ssh_channel_request_execr  auK1}r  (hX   43r  h	X   ssh_channel_request_exec returns SSH_OK on success, SSH_ERROR if an error occurred, SSH_AGAIN if in nonblocking mode and call has to be done again.r  hX   Apizar  h
X   48r  hX   CONTr  hX   INFORMr  h]r  X
   functionalityr  ah]r  X   ssh_channel_request_execr  auK2}r  (hX   44r  h	X9   How do I read the response from ssh_channel_request_exec?r  hX
   Programmerr   h
X   46r  hX   REPr  hX   ELICIT-OFFER-OR-SUGGESTIONr  h]r  X   patternsr  ah]r  X   ssh_channel_request_execr  auK3}r  (hX   45r	  h	X'   How do I read from a channel in libssh?r
  hX
   Programmerr  h
NhNhX   ELICIT-OFFER-OR-SUGGESTIONr  h]r
  X   patternsr  ahNuK4}r  (hX   46r  h	Xk   You may be looking for ssh_channel_read(ssh_channel channel, void * dest, uint32_t count, int is_stderr ). r  hX   Apizar  h
X   51r  hX   POSr  hX   SUGGESTr  h]r  (X   patternsr  X   basicr  eh]r  X   ssh_channel_readr  auK5}r  (hX   46r  h	X   Reads data from a channel. r  hX   Apizar  h
X   52r  hX   CONTr   hX   INFORMr!  h]r"  X   basicr#  ah]r$  X   ssh_channel_readr%  auK6}r&  (hX   46r'  h	X   Returns The number of bytes read, 0 on end of file or SSH_ERROR on error. In nonblocking mode it Can return 0 if no data is available or SSH_AGAIN.r(  hX   Apizar)  h
X   53r*  hX   CONTr+  hX   INFORMr,  h]r-  X
   functionalityr.  ah]r/  X   ssh_channel_readr0  auuuK}r1  (hhh}r2  (K }r3  (hhh	X   libssh documentaryr4  hX
   Programmerr5  h
NhNhX
   ELICIT-INFORMr6  h]r7  X   basicr8  ahNuK}r9  (hhh	X)   how to create an ssh session with libssh?r:  hX
   Programmerr;  h
NhNhX   ELICIT-OFFER-OR-SUGGESTIONr<  h]r=  X   patternsr>  ahNuK}r?  (hh+h	X1   Are you looking for the function ssh_new(void )? r@  hX   ApizarA  h
hhX   POSrB  hX   SUGGESTrC  h]rD  X   patternsrE  ah]rF  X   ssh_newrG  auK}rH  (hh+h	X   Create a new ssh session. rI  hX   ApizarJ  h
hhX   CONTrK  hX   INFORMrL  h]rM  X   basicrN  ah]rO  X   ssh_newrP  auK}rQ  (hh+h	X1   Returns A new ssh_session pointer, NULL on error.rR  hX   ApizarS  h
h+hX   CONTrT  hX   INFORMrU  h]rV  X
   functionalityrW  ah]rX  X   ssh_newrY  auK}rZ  (hh5h	X   how to connect to a serverr[  hX
   Programmerr\  h
NhNhX   ELICIT-OFFER-OR-SUGGESTIONr]  h]r^  X   patternsr_  ahNuK}r`  (hh<h	X   libssh documentary overviewra  hX
   Programmerrb  h
hhX   REPrc  hX
   ELICIT-INFORMrd  h]re  X   basicrf  ahNuK}rg  (hhFh	X.   ssh_session* ssh_new incompatible pointer typerh  hX
   Programmerri  h
h+hX   FOLrj  hX
   ELICIT-INFORMrk  h]rl  X
   functionalityrm  ah]rn  (X   ssh_newro  X   ssh_sessionrp  euK}rq  (hhQh	X"   ssh_connect(ssh_session session). rr  hX   Apizars  h
h<hX   POSrt  hX   INFORMru  h]rv  X   basicrw  ah]rx  X   ssh_connectry  auK	}rz  (hhQh	X   Connect to the ssh server. r{  hX   Apizar|  h
hXhX   CONTr}  hX   INFORMr~  h]r  X   basicr  ah]r  X   ssh_connectr  auK
}r  (hhQh	X1   Parameters: session- The ssh session to connect. r  hX   Apizar  h
hchX   CONTr  hX   INFORMr  h]r  X   basicr  ah]r  X   ssh_connectr  auK}r  (hhQh	X~   Returns: SSH_OK on success, SSH_ERROR on error. SSH_AGAIN, if the session is in nonblocking mode, and call must be done again.r  hX   Apizar  h
X   10r  hX   CONTr  hX   INFORMr  h]r  X
   functionalityr  ah]r  X   ssh_connectr  auK}r  (hhXh	X   I\'m sorry,r  hX   Apizar  h
hFhX   UNCr  hX   BE-POSITIVEr  hNhNuK
}r  (hhXh	X=    I\'m not sure what you mean by "libssh documentary overview"r  hX   Apizar  h
X   12r  hX   CONTr  hX   COMMENT-ABOUT-UNDERSTANDINGr  hNhNuK}r  (hhch	X'   list all function of libssh documentaryr  hX
   Programmerr  h
NhNhX
   ELICIT-INFORMr  h]r  X	   structurer  ahNuK}r  (hX   10r  h	X   ssh_connect set serverr  hX
   Programmerr  h
hXhX   FOLr  hX   ELICIT-OFFER-OR-SUGGESTIONr  h]r  X   patternsr  ah]r  X   ssh_connectr  auK}r  (hX   11r  h	X   ssh_session pointer typedefr  hX
   Programmerr  h
h+hX   FOLr  hX
   ELICIT-INFORMr  h]r  X	   structurer  ah]r  X   ssh_sessionr  auK}r  (hX   12r  h	X   type of SSH_ERRORr  hX
   Programmerr  h
h+hX   FOLr  hX
   ELICIT-INFORMr  h]r  X   basicr  ah]r  X   ssh_connectr  auK}r  (hX   13r  h	X.   The function ssh_new(void ) takes no argumentsr  hX   Apizar  h
hQhX   POSr  hX   INFORMr  h]r  X   basicr  ah]r  X   ssh_newr  auK}r  (hX   13r  h	X5   and returns a new ssh_session pointer, NULL on error.r  hX   Apizar  h
X   18r  hX   CONTr  hX   INFORMr  h]r  (X   basicr  X
   functionalityr  eh]r  X   ssh_newr  auK}r  (hX   14r  h	X$   There are many functions in libssh, r  hX   Apizar  h
X   14r  hX   NEGr  hX   INFORMr  hNhNuK}r  (hX   14r  h	X2   would you like to narrow down to a specific topic?r  hX   Apizar  h
X   20r  hX   FOLr  hX   SUGGESTr  hNhNuK}r  (hX   15r  h	X>   setting up a ssh connection and authentification with a serverr  hX
   Programmerr  h
NhNhX   ELICIT-OFFER-OR-SUGGESTIONr  h]r  X   patternsr  ahNuK}r  (hX   16r  h	X   OK, r  hX   Apizar  h
X   22r  hX   POSr  hX   COMMENT-ABOUT-UNDERSTANDINGr  hNhNuK}r  (hX   16r  h	XU   how can I help you with setting up a ssh connection and authentication with a server?r  hX   Apizar  h
X   22r  hX   FOLr  hX   ELICIT-OFFER-OR-SUGGESTIONr  h]r  X   patternsr  ahNuK}r   (hX   17r  h	X   show me an exampler  hX
   Programmerr  h
X   24r  hX   FOLr  hX
   ELICIT-INFORMr  h]r  X   examplesr  ahNuK}r	  (hX   18r
  h	X8   // Connect to server\n rc = ssh_connect(my_ssh_session);r  hX   Apizar  h
X   25r
  hX   POSr  hX   INFORMr  h]r  X   examplesr  ah]r  X   ssh_connectr  auK}r  (hX   19r  h	X,   show me the typedefinition of my_ssh_sessionr  hX
   Programmerr  h
X   26r  hX   FOLr  hX
   ELICIT-INFORMr  h]r  X	   structurer  ah]r  X   ssh_sessionr  auK}r  (hX   20r   h	X>   The ssh::Session class contains the state of a SSH connection.r!  hX   Apizar"  h
X   27r#  hX   POSr$  hX   INFORMr%  h]r&  X   conceptsr'  ah]r(  X   ssh::Sessionr)  auK}r*  (hX   21r+  h	X   ssh_connection signaturer,  hX
   Programmerr-  h
X   26r.  hX   FOLr/  hX
   ELICIT-INFORMr0  h]r1  X   basicr2  ah]r3  X   ssh_connectr4  auK}r5  (hX   22r6  h	X   ssh_connect()\nr7  hX   Apizar8  h
X   29r9  hX   POSr:  hX   OTHERr;  h]r<  X   basicr=  ah]r>  X   ssh_connectr?  auK}r@  (hX   22rA  h	X&   int ssh_connect(ssh_session session)\nrB  hX   ApizarC  h
X   30rD  hX   CONTrE  hX   INFORMrF  h]rG  X   basicrH  ah]rI  X   ssh_connectrJ  auK }rK  (hX   22rL  h	X   Connect to the ssh server.\nrM  hX   ApizarN  h
X   31rO  hX   CONTrP  hX   INFORMrQ  h]rR  X   basicrS  ah]rT  X   ssh_connectrU  auK!}rV  (hX   22rW  h	X2   Parameters[in]sessionThe ssh session to connect.\nrX  hX   ApizarY  h
X   32rZ  hX   CONTr[  hX   INFORMr\  h]r]  X   basicr^  ah]r_  X   ssh_connectr`  auK"}ra  (hX   22rb  h	X|   Returns SSH_OK on success, SSH_ERROR on error.SSH_AGAIN, if the session is in nonblocking mode, and call must be done again.rc  hX   Apizard  h
X   33re  hX   CONTrf  hX   INFORMrg  h]rh  X
   functionalityri  ah]rj  X   ssh_connectrk  auK#}rl  (hX   23rm  h	X   typedefinition ssh_sessionrn  hX
   Programmerro  h
X   34rp  hX   FOLrq  hX
   ELICIT-INFORMrr  h]rs  X	   structurert  ah]ru  X   ssh_sessionrv  auK$}rw  (hX   24rx  h	X?   The ssh::Session class contains the state of a SSH connection. ry  hX   Apizarz  h
X   35r{  hX   POSr|  hX   INFORMr}  h]r~  X   conceptsr  ah]r  X   ssh::Sessionr  auK%}r  (hX   24r  h	X   There are 22 member functions. r  hX   Apizar  h
X   35r  hX   PARTr  hX   INFORMr  h]r  X	   structurer  ah]r  X   ssh::Sessionr  auK&}r  (hX   24r  h	X+   Do you need help connecting an ssh_session?r  hX   Apizar  h
X   36r  hX   FOLr  hX
   ELICIT-INFORMr  h]r  X   patternsr  ah]r  X   ssh_sessionr  auK'}r  (hX   25r  h	X"   show me the members of ssh_sessionr  hX
   Programmerr  h
X   37r  hX   FOLr  hX
   ELICIT-INFORMr  h]r  X	   structurer  ah]r  X   ssh_sessionr  auK(}r  (hX   26r  h	XX   Members include acceptForward(int timeout_ms), connect(), disconnect(), getAuthList()...r  hX   Apizar  h
X   39r  hX   POSr  hX   INFORMr  h]r  X	   structurer  ah]r  X   ssh::Sessionr  auK)}r  (hX   27r  h	X   show me fields of ssh_sessionr  hX
   Programmerr  h
X   39r  hX   REPr  hX
   ELICIT-INFORMr  h]r  X	   structurer  ah]r  X   ssh_sessionr  auK*}r  (hX   28r  h	X    definition of ssh_session_structr  hX
   Programmerr  h
X   37r  hX   FOLr  hX
   ELICIT-INFORMr  h]r  X	   structurer  ah]r  X   ssh_sessionr  auK+}r  (hX   29r  h	X&   ssh_session has: friend class Channel;r  hX   Apizar  h
X   41r  hX   POSr  hX   INFORMr  h]r  X	   structurer  ah]r  X   ssh_sessionr  auK,}r  (hX   30r  h	X   I'm sorry, r  hX   Apizar  h
X   42r  hX   NEGr  hX   BE-POSITIVEr  hNhNuK-}r  (hX   30r  h	X$   I could not find ssh_session_struct.r  hX   Apizar  h
X   44r  hX   CONTr  hX   INFORMr  hNh]r  X   ssh_sessionr  auK.}r  (hX   31r  h	X&   how to set a remote for an ssh-sessionr  hX
   Programmerr  h
NhNhX   ELICIT-OFFER-OR-SUGGESTIONr  h]r  X   patternsr  ah]r  X   ssh_sessionr  auK/}r  (hX   32r  h	XK   I believe ssh_options_set() will help you set a remote for an ssh-session. r  hX   Apizar  h
X   46r  hX   POSr  hX   SUGGESTr  h]r  X   patternsr  ah]r  (X   ssh_options_setr  X   ssh_sessionr  euK0}r  (hX   32r  h	X   Would you like to know more?r  hX   Apizar  h
X   47r  hX   FOLr  hX
   ELICIT-INFORMr  h]r  X   basicr  ah]r  X   ssh_options_setr  auK1}r  (hX   33r   h	X   yesr  hX
   Programmerr  h
X   48r  hX   POSr  hX   INFORMr  h]r  X   basicr  ah]r  X   ssh_options_setr	  auK2}r
  (hX   34r  h	XX   int ssh_options_set(ssh_session session,enum ssh_options_e type,const void * value )\n\nr  hX   Apizar
  h
X   47r  hX   CONTr  hX   INFORMr  h]r  X   basicr  ah]r  X   ssh_options_setr  auK3}r  (hX   34r  h	X   Parameters: session- An allocated SSH session structure.type- The option type to set. value- The value to set. This is a generic pointer and the datatype which is used should be set according to the type set.\n\nr  hX   Apizar  h
X   50r  hX   CONTr  hX   INFORMr  h]r  X
   functionalityr  ah]r  X   ssh_options_setr  auK4}r   (hX   34r!  h	X(   Returns: 0 on success, &lt; 0 on error. r"  hX   Apizar#  h
X   51r$  hX   CONTr%  hX   INFORMr&  h]r'  X
   functionalityr(  ah]r)  X   ssh_options_setr*  auK5}r+  (hX   35r,  h	X
   ssh_options_er-  hX
   Programmerr.  h
X   50r/  hX   FOLr0  hX
   ELICIT-INFORMr1  h]r2  (X
   functionalityr3  X
   directivesr4  eh]r5  X   ssh_options_setr6  auK6}r7  (hX   36r8  h	X   There are many options for ssh_options_e type, including SSH_OPTIONS_HOST: The hostname or ip address to connect to (const char *), SSH_OPTIONS_PORT: The port to connect to (unsigned int), and SSH_OPTIONS_PORT_STR: The port to connect to (const char *).r9  hX   Apizar:  h
X   53r;  hX   POSr<  hX   INFORMr=  h]r>  (X
   functionalityr?  X
   directivesr@  eh]rA  X   ssh_options_setrB  auK7}rC  (hX   37rD  h	X   authenticate userrE  hX
   ProgrammerrF  h
NhNhX   ELICIT-OFFER-OR-SUGGESTIONrG  h]rH  X   patternsrI  ahNuK8}rJ  (hX   38rK  h	X   default ssh_session settingsrL  hX
   ProgrammerrM  h
X   54rN  hX   FOLrO  hX
   ELICIT-INFORMrP  h]rQ  X   patternsrR  ah]rS  X   ssh_options_setrT  auK9}rU  (hX   39rV  h	X*   How would you like to authenticate a user?rW  hX   ApizarX  h
X   55rY  hX   FOLrZ  hX
   ELICIT-INFORMr[  h]r\  X   patternsr]  ahNuK:}r^  (hX   40r_  h	X   passwordr`  hX
   Programmerra  h
X   57rb  hX   POSrc  hX   INFORMrd  h]re  X   patternsrf  ahNuK;}rg  (hX   41rh  h	X   Did you mean ssh_options?ri  hX   Apizarj  h
X   56rk  hX   FOLrl  hX
   ELICIT-INFORMrm  h]rn  X   patternsro  ahNuK<}rp  (hX   42rq  h	X_   int ssh_userauth_password(ssh_session session,const char * username,const char * password )\n\nrr  hX   Apizars  h
X   55rt  hX   POSru  hX   INFORMrv  h]rw  X   basicrx  ah]ry  X   ssh_userauth_passwordrz  auK=}r{  (hX   42r|  h	X{  Try to authenticate by password.This authentication method is normally disabled on SSHv2 server. You should use keyboard-interactive mode.The 'password' value MUST be encoded UTF-8. It is up to the server how to interpret the password and validate it against the password database. However, if you read the password in some other encoding, you MUST convert the password to UTF-8.r}  hX   Apizar~  h
X   60r  hX   CONTr  hX   INFORMr  h]r  (X
   functionalityr  X
   directivesr  X   environmentr  eh]r  X   ssh_userauth_passwordr  auK>}r  (hX   43r  h	X   connect to serverr  hX
   Programmerr  h
NhNhX   ELICIT-OFFER-OR-SUGGESTIONr  h]r  X   patternsr  ahNuK?}r  (hX   44r  h	XF   Once all settings have been made, you can connect using ssh_connect().r  hX   Apizar  h
X   62r  hX   POSr  hX   SUGGESTr  h]r  X   patternsr  ah]r  X   ssh_connectr  auK@}r  (hX   44r  h	XO   That function will return SSH_OK if the connection worked, SSH_ERROR otherwise.r  hX   Apizar  h
X   63r  hX   CONTr  hX   INFORMr  h]r  X
   functionalityr  ah]r  X   ssh_connectr  auKA}r  (hX   45r  h	X   what settings do I need to maker  hX
   Programmerr  h
X   63r  hX   FOLr  hX   ELICIT-OFFER-OR-SUGGESTIONr  h]r  X
   directivesr  ah]r  X   ssh_connectr  auKB}r  (hX   46r  h	Xl   You can set options using ssh_options_set(ssh_session session,enum ssh_options_e type,const void * value ). r  hX   Apizar  h
X   65r  hX   POSr  hX   SUGGESTr  h]r  (X   patternsr  X   basicr  eh]r  X   ssh_options_setr  auKC}r  (hX   46r  h	XL   For example, ssh_options_set(my_ssh_session, SSH_OPTIONS_HOST, "localhost");r  hX   Apizar  h
X   66r  hX   CONTr  hX   INFORMr  h]r  X   examplesr  ah]r  X   ssh_options_setr  auKD}r  (hX   47r  h	X   how to authenticate a serverr  hX
   Programmerr  h
NhNhX   ELICIT-OFFER-OR-SUGGESTIONr  h]r  X   patternsr  ahNuKE}r  (hX   48r  h	XI   The first way (recommended) is to use the ssh_is_server_known() function.r  hX   Apizar  h
X   68r  hX   POSr  hX   SUGGESTr  h]r  X   patternsr  ah]r  X   ssh_is_server_knownr  auKF}r  (hX   48r  h	X   Would you like to know more?r  hX   Apizar  h
X   69r  hX   FOLr  hX
   ELICIT-INFORMr  h]r  X   basicr  ah]r  X   ssh_is_server_knownr  auKG}r  (hX   49r  h	X   yer  hX
   Programmerr  h
X   70r  hX   POSr  hX   OTHERr  hNhNuKH}r  (hX   50r  h	X   yesr  hX
   Programmerr  h
X   71r  hX   REPr  hX   INFORMr  h]r  X   basicr  ah]r  X   ssh_is_server_knownr  auKI}r  (hX   51r  h	X.   int ssh_is_server_known(ssh_session session)\nr  hX   Apizar  h
X   69r  hX   CONTr  hX   INFORMr  h]r  X   basicr  ah]r  X   ssh_is_server_knownr   auKJ}r  (hX   51r  h	Xr   Check if the server is known.Checks the user's known host file for a previous connection to the current server.\n r  hX   Apizar  h
X   73r  hX   CONTr  hX   INFORMr  h]r  X
   functionalityr	  ah]r
  X   ssh_is_server_knownr  auKK}r  (hX   51r
  h	X  Parameters: -sessionThe SSH session to use.\nReturns:SSH_SERVER_KNOWN_OK: The server is known and has not changed.\nSSH_SERVER_KNOWN_CHANGED: The server key has changed. Either you are under attack or the administrator changed the key. You HAVE to warn the user about a possible attack.\nSSH_SERVER_FOUND_OTHER: The server gave use a key of a type while we had an other type recorded. It is a possible attack.\nSSH_SERVER_NOT_KNOWN: The server is unknown. User should confirm the MD5 is correct.\nSSH_SERVER_FILE_NOT_FOUND: The known host file does not exist. The host is thus unknown. File will be created if host key is accepted.\nSSH_SERVER_ERROR: Some error happened.r  hX   Apizar  h
X   74r  hX   CONTr  hX   INFORMr  h]r  X
   functionalityr  ah]r  X   ssh_is_server_knownr  auKL}r  (hX   52r  h	X   which of those errors is "-1"r  hX
   Programmerr  h
X   74r  hX   FOLr  hX
   ELICIT-INFORMr  h]r  X
   functionalityr  ah]r   X   ssh_is_server_knownr!  auKM}r"  (hX   53r#  h	X   how to fix SSH_SERVER_ERRORr$  hX
   Programmerr%  h
X   74r&  hX   FOLr'  hX   ELICIT-OFFER-OR-SUGGESTIONr(  h]r)  X   patternsr*  ah]r+  X   ssh_is_server_knownr,  auKN}r-  (hX   54r.  h	X+   You may be able to use ssh_get_error():\n\nr/  hX   Apizar0  h
X   77r1  hX   POSr2  hX   SUGGESTr3  h]r4  X   patternsr5  ah]r6  X
   ssh_get_errorr7  auKO}r8  (hX   54r9  h	X)   const char* ssh_get_error(void * error)\nr:  hX   Apizar;  h
X   78r<  hX   CONTr=  hX   INFORMr>  h]r?  X   basicr@  ah]rA  X
   ssh_get_errorrB  auKP}rC  (hX   54rD  h	X6   Retrieve the error text message from the last error.\nrE  hX   ApizarF  h
X   79rG  hX   CONTrH  hX   INFORMrI  h]rJ  X
   functionalityrK  ah]rL  X
   ssh_get_errorrM  auKQ}rN  (hX   54rO  h	X0   Parameters: error- An ssh_session or ssh_bind.\nrP  hX   ApizarQ  h
X   80rR  hX   CONTrS  hX   INFORMrT  h]rU  X   basicrV  ah]rW  X
   ssh_get_errorrX  auKR}rY  (hX   54rZ  h	X.   Returns: A static string describing the error.r[  hX   Apizar\  h
X   81r]  hX   CONTr^  hX   INFORMr_  h]r`  X
   functionalityra  ah]rb  X
   ssh_get_errorrc  auKS}rd  (hX   55re  h	X   website of libssh documentaryrf  hX
   Programmerrg  h
NhNhX
   ELICIT-INFORMrh  h]ri  X
   referencesrj  ahNuKT}rk  (hX   56rl  h	X   libssh documentaryrm  hX
   Programmerrn  h
NhNhX
   ELICIT-INFORMro  h]rp  X   basicrq  ahNuKU}rr  (hX   57rs  h	X5   How can I help you navigate the libssh documentation?rt  hX   Apizaru  h
X   84rv  hX   FOLrw  hX   ELICIT-OFFER-OR-SUGGESTIONrx  h]ry  X   basicrz  ahNuKV}r{  (hX   58r|  h	X   show me an overviewr}  hX
   Programmerr~  h
X   85r  hX   POSr  hX
   ELICIT-INFORMr  h]r  X	   structurer  ahNuKW}r  (hX   59r  h	X!   There are three main components: r  hX   Apizar  h
X   84r  hX   POSr  hX   INFORMr  h]r  X	   structurer  ahNuKX}r  (hX   59r  h	X>   The libssh server API, The libssh SFTP API, and The libssh APIr  hX   Apizar  h
X   87r  hX   CONTr  hX   INFORMr  h]r  X	   structurer  ahNuKY}r  (hX   60r  h	X%   show me an overview of the libssh apir  hX
   Programmerr  h
X   88r  hX   FOLr  hX
   ELICIT-INFORMr  h]r  X	   structurer  ahNuKZ}r  (hX   61r  h	X0   There are 15 main components of The libssh API: r  hX   Apizar  h
X   89r  hX   POSr  hX   INFORMr  h]r  X	   structurer  ahNuK[}r  (hX   61r  h	X{  The libssh callbacks, The SSH authentication functions, The SSH buffer functions, The SSH channel functions, The SSH error functions, The SSH logging functions,The SSH message functions, The SSH helper functions,The SSH Public Key Infrastructure, The SSH poll functions, The SSH scp functions, The SSH session functions, The SSH string functions, and The SSH threading functions.r  hX   Apizar  h
X   90r  hX   CONTr  hX   INFORMr  h]r  X	   structurer  ahNuK\}r  (hX   62r  h	X   libssh authentication functionsr  hX
   Programmerr  h
NhNhX
   ELICIT-INFORMr  h]r  X	   structurer  ahNuK]}r  (hX   63r  h	X    Okay, authentication functions. r  hX   Apizar  h
X   92r  hX   POSr  hX   COMMENT-ABOUT-UNDERSTANDINGr  h]r  X	   structurer  ahNuK^}r  (hX   63r  h	X#   Are you looking for a specific one?r  hX   Apizar  h
X   92r  hX   FOLr  hX
   ELICIT-INFORMr  h]r  X	   structurer  ahNuK_}r  (hX   64r  h	X5   show me the original text of the ssh_connect functionr  hX
   Programmerr  h
NhNhX
   ELICIT-INFORMr  h]r  X   basicr  ah]r  X   ssh_connectr  auK`}r  (hX   65r  h	X   ssh_connect()\nr  hX   Apizar  h
X   95r  hX   POSr  hX   OTHERr  h]r  X   basicr  ah]r  X   ssh_connectr  auKa}r  (hX   65r  h	X&   int ssh_connect(ssh_session session)\nr  hX   Apizar  h
X   96r  hX   CONTr  hX   INFORMr  h]r  X   basicr  ah]r  X   ssh_connectr  auKb}r  (hX   65r  h	X   Connect to the ssh server.\nr  hX   Apizar  h
X   97r  hX   CONTr  hX   INFORMr  h]r  X   basicr  ah]r  X   ssh_connectr  auKc}r  (hX   65r  h	X2   Parameters[in]sessionThe ssh session to connect.\nr  hX   Apizar  h
X   98r  hX   CONTr  hX   INFORMr  h]r  X   basicr  ah]r  X   ssh_connectr  auKd}r  (hX   65r   h	X|   Returns SSH_OK on success, SSH_ERROR on error.SSH_AGAIN, if the session is in nonblocking mode, and call must be done again.r  hX   Apizar  h
X   99r  hX   CONTr  hX   INFORMr  h]r  X
   functionalityr  ah]r  X   ssh_connectr	  auKe}r
  (hX   66r  h	X1   what settings do i have to set before ssh_connectr  hX
   Programmerr
  h
X   96r  hX   FOLr  hX   ELICIT-OFFER-OR-SUGGESTIONr  h]r  X
   directivesr  ah]r  (X   ssh_connectr  X   ssh_options_setr  euuuK}r  (hhh}r  (K }r  (hhh	X   hellor  hX
   Programmerr  h
NhNhX   BE-POSITIVEr  hNhNuK}r  (hhh	Xu   "In the main method, use the libssh API to create a new ssh_session. Ensure that the session is successfully created"r  hX
   Programmerr  h
NhNhX   INFORMr  hNhNuK}r   (hh+h	X    how to create a new ssh_session?r!  hX
   Programmerr"  h
hhX   CONTr#  hX   ELICIT-OFFER-OR-SUGGESTIONr$  h]r%  X   patternsr&  ah]r'  X   ssh_sessionr(  auK}r)  (hh5h	X   Hi!r*  hX   Apizar+  h
hhX   POSr,  hX   BE-POSITIVEr-  hNhNuK}r.  (hh5h	XB   I'm apiza, a virtual assistant designed to programmers with APIs. r/  hX   Apizar0  h
h+hX   CONTr1  hX   INFORMr2  hNhNuK}r3  (hh5h	X)   I look forward to working with you today!r4  hX   Apizar5  h
h5hX   CONTr6  hX   BE-POSITIVEr7  hNhNuK}r8  (hh<h	X
   okay habibi..r9  hX
   Programmerr:  h
h<hX   POSr;  hX   BE-POSITIVEr<  hNhNuK}r=  (hh<h	X   now give me the answerr>  hX
   Programmerr?  h
h<hX   NEGr@  hX   SUGGESTrA  hNhNuK}rB  (hhFh	XL   You can create a new ssh session using the "ssh_session ssh_new()" function.rC  hX   ApizarD  h
hhX   POSrE  hX   SUGGESTrF  h]rG  (X   patternsrH  X   basicrI  eh]rJ  (X   ssh_newrK  X   ssh_sessionrL  euK	}rM  (hhQh	X   I have written this,rN  hX
   ProgrammerrO  h
hXhX   FOLrP  hX   INFORMrQ  hNh]rR  X   ssh_sessionrS  auK
}rT  (hhXh	X   ```ssh_session session;```rU  hX
   ProgrammerrV  h
hchX   CONTrW  hX   INFORMrX  h]rY  X   examplesrZ  ah]r[  X   ssh_sessionr\  auK}r]  (hhch	X   has a new session been created?r^  hX
   Programmerr_  h
X   10r`  hX   CONTra  hX
   ELICIT-INFORMrb  h]rc  X
   functionalityrd  ah]re  X   ssh_sessionrf  auK}rg  (hX   10rh  h	X(   You have created an unitialized session,ri  hX   Apizarj  h
X   11rk  hX   POSrl  hX   INFORMrm  h]rn  (X
   functionalityro  X   patternsrp  eh]rq  X   ssh_sessionrr  auK
}rs  (hX   10rt  h	XR   please use the "ssh_session ssh_new()" function to fully intialize a new session. ru  hX   Apizarv  h
X   12rw  hX   CONTrx  hX   SUGGESTry  h]rz  (X
   functionalityr{  X   patternsr|  eh]r}  (X   ssh_sessionr~  X   ssh_newr  euK}r  (hX   10r  h	X7   It returns a new ssh_session pointer, or NULL on error.r  hX   Apizar  h
X   13r  hX   CONTr  hX   INFORMr  h]r  (X
   functionalityr  X   patternsr  eh]r  (X   ssh_sessionr  X   ssh_newr  euK}r  (hX   11r  h	X$   ```session = ssh_new()``` like this?r  hX
   Programmerr  h
X   12r  hX   FOLr  hX   ELICIT-ASSESSMENTr  h]r  X   examplesr  ah]r  (X   ssh_newr  X   ssh_sessionr  euK}r  (hX   12r  h	X
   I believe so.r  hX   Apizar  h
X   15r  hX   POSr  hX   ASSESSr  h]r  X   examplesr  ah]r  (X   ssh_newr  X   ssh_sessionr  euK}r  (hX   13r  h	X   how to connect to localhost?r  hX
   Programmerr  h
NhNhX   ELICIT-OFFER-OR-SUGGESTIONr  h]r  X   patternsr  ahNuK}r  (hX   14r  h	XZ   You can connect to a session by using the "int ssh_connect(ssh_session session)" function.r  hX   Apizar  h
X   17r  hX   POSr  hX   SUGGESTr  h]r  (X   patternsr  X   basicr  eh]r  X   ssh_connectr  auK}r  (hX   15r  h	X$   where to give username and password?r  hX
   Programmerr  h
X   18r  hX   FOLr  hX
   ELICIT-INFORMr  h]r  X   patternsr  ah]r  X   ssh_connectr  auK}r  (hX   16r  h	X   how to authenticate the server?r  hX
   Programmerr  h
NhNhX   ELICIT-OFFER-OR-SUGGESTIONr  h]r  X   patternsr  ahNuK}r  (hX   17r  h	Xa   You can set properties of a session using the "ssh_options_set(session, option, char*)" function.r  hX   Apizar  h
X   19r  hX   POSr  hX   SUGGESTr  h]r  (X   patternsr  X   examplesr  X   basicr  eh]r  X   ssh_options_setr  auK}r  (hX   17r  h	X,   An example would be to set the host options,r  hX   Apizar  h
X   21r  hX   CONTr  hX   INFORMr  h]r  (X   patternsr  X   examplesr  X   basicr  eh]r  X   ssh_options_setr  auK}r  (hX   17r  h	Xp   which can be done with the following statement "ssh_options_set(my_ssh_session, SSH_OPTIONS_HOST, "129.0.0.1");"r  hX   Apizar  h
X   22r  hX   CONTr  hX   INFORMr  h]r  (X   patternsr  X   examplesr  X   basicr  eh]r  X   ssh_options_setr  auK}r  (hX   18r  h	X6   There are several functions to authenticate a session,r  hX   Apizar  h
X   20r  hX   PARTr  hX   INFORMr  h]r  (X	   structurer  X   patternsr  ehNuK}r  (hX   18r  h	X(   would you like me to enumerate them all?r  hX   Apizar  h
X   24r  hX   FOLr   hX   ELICIT-OFFER-OR-SUGGESTIONr  h]r  (X	   structurer  X   patternsr  ehNuK}r  (hX   19r  h	X   tell me the easiest oner  hX
   Programmerr  h
X   25r	  hX   PARTr
  hX   SUGGESTr  h]r  X   basicr
  ahNuK}r  (hX   20r  h	X   "int ssh_userauth_publickey_auto(ssh_session session, const char* username, const char* passphrase)" will attempt to automatically authenticate with public key and "none".r  hX   Apizar  h
X   20r  hX   POSr  hX   INFORMr  h]r  (X
   functionalityr  X   patternsr  X   basicr  eh]r  X   ssh_userauth_publickey_autor  auK}r  (hX   21r  h	X)   Would you like me to list the parameters?r  hX   Apizar  h
X   27r  hX   FOLr   hX   ELICIT-OFFER-OR-SUGGESTIONr!  h]r"  X   basicr#  ah]r$  X   ssh_userauth_publickey_autor%  auK}r&  (hX   22r'  h	X<   howt to "Disconnect from the server and free the session." ?r(  hX
   Programmerr)  h
NhNhX   ELICIT-OFFER-OR-SUGGESTIONr*  h]r+  X   patternsr,  ahNuK}r-  (hX   23r.  h	Xv   "ssh_disconnect(ssh_session session)" and "ssh_free(ssh_session session)" functions can be used to clean up resources.r/  hX   Apizar0  h
X   29r1  hX   POSr2  hX   SUGGESTr3  h]r4  (X   patternsr5  X   basicr6  eh]r7  X   ssh_disconnectr8  auK}r9  (hX   24r:  h	X=   how to Create and open a new ssh_channel in the ssh_session ?r;  hX
   Programmerr<  h
NhNhX   ELICIT-OFFER-OR-SUGGESTIONr=  h]r>  X   patternsr?  ah]r@  X   ssh_channelrA  auK }rB  (hX   25rC  h	Xo   "ssh_channel ssh_channel_new(ssh_session session)" function can be used to create a new channel from a session.rD  hX   ApizarE  h
X   31rF  hX   POSrG  hX   SUGGESTrH  h]rI  (X   patternsrJ  X   basicrK  eh]rL  X   ssh_channel_newrM  auK!}rN  (hX   26rO  h	Xn   There are a few functions that can open a ssh_channel depending upon settings such as protocol, purpose, etc. rP  hX   ApizarQ  h
X   31rR  hX   PARTrS  hX   INFORMrT  h]rU  (X	   structurerV  X   patternsrW  eh]rX  X   ssh_channelrY  auK"}rZ  (hX   26r[  h	X#   Would you like me to list them all?r\  hX   Apizar]  h
X   33r^  hX   FOLr_  hX   ELICIT-OFFER-OR-SUGGESTIONr`  h]ra  (X	   structurerb  X   patternsrc  eh]rd  X   ssh_channelre  auK#}rf  (hX   27rg  h	X   tell the easiest onerh  hX
   Programmerri  h
X   34rj  hX   PARTrk  hX   SUGGESTrl  h]rm  X   basicrn  ah]ro  X   ssh_channelrp  auK$}rq  (hX   28rr  h	X   "int ssh_channel_open_session(ssh_channel channel)" seems to be the function that opens a channel that has the least amount of configuration.rs  hX   Apizart  h
X   31ru  hX   POSrv  hX   SUGGESTrw  h]rx  (X   patternsry  X   basicrz  eh]r{  (X   ssh_channel_open_sessionr|  X   ssh_channelr}  euK%}r~  (hX   29r  h	X5   how to Execute the command "who" on the open channel?r  hX
   Programmerr  h
NhNhX   ELICIT-OFFER-OR-SUGGESTIONr  h]r  X   patternsr  ah]r  X   ssh_channelr  auK&}r  (hX   30r  h	X   The function "int ssh_channel_request_exec(ssh_channel channel, const char* cmd)" executes a shell command without an interactive shell on the host machine.r  hX   Apizar  h
X   37r  hX   POSr  hX   INFORMr  h]r  (X
   functionalityr  X   patternsr  X   basicr  eh]r  X   ssh_channel_request_execr  auK'}r  (hX   31r  h	X"   how to read response from channel?r  hX
   Programmerr  h
X   38r  hX   FOLr  hX   ELICIT-OFFER-OR-SUGGESTIONr  h]r  X   patternsr  ah]r  (X   ssh_channelr  X   ssh_channel_request_execr  euK(}r  (hX   32r  h	X   You can read data from a channel using the "int ssh_channel_read(ssh_channel channel, void* buff, uint32_t count, int is_stderr)" function.r  hX   Apizar  h
X   39r  hX   POSr  hX   SUGGESTr  h]r  (X   patternsr  X   basicr  eh]r  X   ssh_channel_readr  auK)}r  (hX   33r  h	X@   what are these ? ```void* buff, uint32_t count, int is_stderr```r  hX
   Programmerr  h
X   40r  hX   FOLr  hX
   ELICIT-INFORMr  h]r  X
   functionalityr  ah]r  X   ssh_channel_readr  auK*}r  (hX   34r  h	X   According to the API documentation, void* buff is a destination buffer where the read data will be transferred to. unit32_t count is the number of bytes to be read, and int is_stderr is a boolean value to mark reading from the stderr flow.r  hX   Apizar  h
X   41r  hX   POSr  hX   INFORMr  h]r  X
   functionalityr  ah]r  X   ssh_channel_readr  auK+}r  (hX   35r  h	X   what values should i give ?r  hX
   Programmerr  h
X   42r  hX   FOLr  hX   ELICIT-OFFER-OR-SUGGESTIONr  h]r  X   patternsr  ah]r  X   ssh_channel_readr  auK,}r  (hX   36r  h	X   I am sorry, r  hX   Apizar  h
X   43r  hX   UNCr  hX   BE-POSITIVEr  hNhNuK-}r  (hX   36r  h	X   I am confused.r  hX   Apizar  h
X   44r  hX   CONTr  hX   COMMENT-ABOUT-UNDERSTANDINGr  hNhNuK.}r  (hX   37r  h	X0   can you give me example use of ssh_channel_read?r  hX
   Programmerr  h
X   40r  hX   FOLr  hX
   ELICIT-INFORMr  h]r  X   examplesr  ah]r  X   ssh_channel_readr  auK/}r  (hX   38r  h	X   An example usage of ssh_channel_read would be "ssh_channel_read(my_channel, my_buffer, sizeof(buffer), 0);" to read 512 bytes from the channel stdout if my_buffer is an array of type "char" of size 512.r  hX   Apizar  h
X   46r  hX   POSr  hX   INFORMr  h]r  X   examplesr  ah]r  X   ssh_channel_readr  auK0}r  (hX   39r  h	XO   Excuse me, "sizeof(buffer)" should be "sizeof(my_buffer)" in the above example.r  hX   Apizar  h
X   47r  hX   REPr  hX   INFORMr  h]r  X   examplesr  ah]r  X   ssh_channel_readr  auK1}r  (hX   40r  h	X2   can you give me an example of my_buffer or buffer?r  hX
   Programmerr  h
X   48r   hX   FOLr  hX
   ELICIT-INFORMr  h]r  X   examplesr  ah]r  X   ssh_channel_readr  auK2}r  (hX   41r  h	XT   A statically allocated buffer would use the following command "char my_buffer[512];"r	  hX   Apizar
  h
X   49r  hX   POSr  hX   INFORMr
  h]r  X   examplesr  ah]r  X   ssh_channel_readr  auK3}r  (hX   42r  h	X   how to print to stdout ?r  hX
   Programmerr  h
NhNhX   ELICIT-OFFER-OR-SUGGESTIONr  h]r  X   patternsr  ahNuK4}r  (hX   43r  h	X
   I'm sorry,r  hX   Apizar  h
X   51r  hX   NEGr  hX   BE-POSITIVEr  hNhNuK5}r   (hX   43r!  h	XN    I am not authorized to answer API questions regarding APIs other than libssh.r"  hX   Apizar#  h
X   52r$  hX   CONTr%  hX   INFORMr&  hNhNuK6}r'  (hX   44r(  h	X   how to shutdown the channel ?r)  hX
   Programmerr*  h
NhNhX   ELICIT-OFFER-OR-SUGGESTIONr+  h]r,  X   patternsr-  ah]r.  X   ssh_channelr/  auK7}r0  (hX   45r1  h	XL   There are two functions that refer to the functionality you are requestion. r2  hX   Apizar3  h
X   54r4  hX   PARTr5  hX   INFORMr6  h]r7  (X   patternsr8  X   basicr9  eh]r:  X   ssh_channelr;  auK8}r<  (hX   45r=  h	Xy   The first is "int ssh_channel_close(ssh_channel channel)" and the second is "void ssh_channel_free(ssh_channel channel)."r>  hX   Apizar?  h
X   55r@  hX   CONTrA  hX   INFORMrB  h]rC  (X   patternsrD  X   basicrE  eh]rF  (X   ssh_channel_closerG  X   ssh_channel_freerH  euK9}rI  (hX   46rJ  h	X   how to send eof?rK  hX
   ProgrammerrL  h
NhNhX   ELICIT-OFFER-OR-SUGGESTIONrM  h]rN  X   patternsrO  ahNuK:}rP  (hX   47rQ  h	Xo   You can use the function "int ssh_channel_send_eof(ssh_channel channel)" to send an end of file on the channel.rR  hX   ApizarS  h
X   57rT  hX   POSrU  hX   SUGGESTrV  h]rW  (X   patternsrX  X   basicrY  eh]rZ  X   ssh_channel_send_eofr[  auK;}r\  (hX   48r]  h	XN   how to Create and initialize a new sftp session on the connected ssh session ?r^  hX
   Programmerr_  h
NhNhX   ELICIT-OFFER-OR-SUGGESTIONr`  h]ra  X   patternsrb  ah]rc  X   sftp_sessionrd  auK<}re  (hX   49rf  h	XZ   You can use the "ssftp_session sftp_new(ssh_session session)" to start a new sftp session.rg  hX   Apizarh  h
X   59ri  hX   POSrj  hX   SUGGESTrk  h]rl  (X   patternsrm  X   basicrn  eh]ro  (X   sftp_newrp  X   sftp_sessionrq  euK=}rr  (hX   50rs  h	X6   Excuse me "sftp_session sftp_new(ssh_session session)"rt  hX   Apizaru  h
X   61rv  hX   REPrw  hX   INFORMrx  h]ry  X   basicrz  ah]r{  X   sftp_newr|  auK>}r}  (hX   51r~  h	X!   how to Create a new file in Dir1?r  hX
   Programmerr  h
NhNhX   ELICIT-OFFER-OR-SUGGESTIONr  h]r  X   patternsr  ahNuK?}r  (hX   52r  h	X   To open a new file using sftp, you can use the "sftp_file sftp_open(sftp_session session, const char* filepath, int accesstype, mode_t mode)" function.r  hX   Apizar  h
X   62r  hX   POSr  hX   SUGGESTr  h]r  (X   patternsr  X   basicr  eh]r  X	   sftp_openr  auK@}r  (hX   53r  h	X#   can you give me an example of mode?r  hX
   Programmerr  h
X   63r  hX   FOLr  hX
   ELICIT-INFORMr  h]r  X   examplesr  ah]r  X	   sftp_openr  auKA}r  (hX   54r  h	X0   An example mode_t mode value would be "S_IRWXU".r  hX   Apizar  h
X   64r  hX   POSr  hX   INFORMr  h]r  X   examplesr  ah]r  X	   sftp_openr  auKB}r  (hX   55r  h	X   how to create a new directory?r  hX
   Programmerr  h
NhNhX   ELICIT-OFFER-OR-SUGGESTIONr  h]r  X   patternsr  ahNuKC}r  (hX   56r  h	X{   You can create a new directory using the "int sftp_mkdir(sftp_session session, const char* dirpath, mode_t mode)" function.r  hX   Apizar  h
X   66r  hX   POSr  hX   SUGGESTr  h]r  (X   patternsr  X   basicr  eh]r  X
   sftp_mkdirr  auKD}r  (hX   57r  h	X)   can you give me an example of accesstype?r  hX
   Programmerr  h
X   63r  hX   FOLr  hX
   ELICIT-INFORMr  h]r  X   examplesr  ah]r  X
   sftp_mkdirr  auKE}r  (hX   58r  h	XW   An example of an access type would be "int access_type = O_WRONLY | O_CREAT | O_TRUNC;"r  hX   Apizar  h
X   68r  hX   POSr  hX   INFORMr  h]r  X   examplesr  ah]r  X
   sftp_mkdirr  auKF}r  (hX   59r  h	X#   how to write a string to the file ?r  hX
   Programmerr  h
X   63r  hX   FOLr  hX   ELICIT-OFFER-OR-SUGGESTIONr  h]r  X   patternsr  ahNuKG}r  (hX   60r  h	Xx   You can write to an open file using the "ssize_t sftp_write(sftp_file file, const void* buffer, size_t count)" function.r  hX   Apizar  h
X   70r  hX   POSr  hX   SUGGESTr  h]r  (X   patternsr  X   basicr  eh]r  X
   sftp_writer  auKH}r  (hX   61r  h	X2   can you give me an example of const void* buffer ?r  hX
   Programmerr  h
X   71r  hX   FOLr  hX
   ELICIT-INFORMr  h]r  X   examplesr  ah]r  X
   sftp_writer  auKI}r  (hX   62r  h	XW   In this specific case, "const void* buffer" is the contents of the file to be written. r  hX   Apizar  h
X   72r  hX   POSr  hX   INFORMr  h]r  X   examplesr  ah]r  X
   sftp_writer  auKJ}r  (hX   62r  h	Xc   An example would to write a static message "hello world!" where const char* buff = "hello world!";.r  hX   Apizar  h
X   73r  hX   CONTr  hX   INFORMr 	  h]r	  X   examplesr	  ah]r	  X
   sftp_writer	  auKK}r	  (hX   63r	  h	X   an example of count ?r	  hX
   Programmerr	  h
X   71r		  hX   FOLr
	  hX
   ELICIT-INFORMr	  h]r	  X   examplesr
	  ah]r	  X
   sftp_writer	  auKL}r	  (hX   64r	  h	X:   "count" is the number of bytes to be written to the file. r	  hX   Apizar	  h
X   75r	  hX   POSr	  hX   INFORMr	  h]r	  (X   conceptsr	  X   examplesr	  eh]r	  X
   sftp_writer	  auKM}r	  (hX   64r	  h	XQ   In the example where the buffer is "hello world!", count would be sizeof(buffer).r	  hX   Apizar	  h
X   76r 	  hX   CONTr!	  hX   INFORMr"	  h]r#	  (X   conceptsr$	  X   examplesr%	  eh]r&	  X
   sftp_writer'	  auKN}r(	  (hX   65r)	  h	X   how to close the file?r*	  hX
   Programmerr+	  h
NhNhX   ELICIT-OFFER-OR-SUGGESTIONr,	  h]r-	  X   patternsr.	  ahNuKO}r/	  (hX   66r0	  h	XI   You can close a file using the "int sftp_close(sftp_file file)" function.r1	  hX   Apizar2	  h
X   78r3	  hX   POSr4	  hX   SUGGESTr5	  h]r6	  (X   patternsr7	  X   basicr8	  eh]r9	  X
   sftp_closer:	  auKP}r;	  (hX   67r<	  h	X   how to free the session?r=	  hX
   Programmerr>	  h
NhNhX   ELICIT-OFFER-OR-SUGGESTIONr?	  h]r@	  X   patternsrA	  ahNuKQ}rB	  (hX   68rC	  h	XP   To free a sftp_session, use the "void sftp_free(sftp_session session)" function.rD	  hX   ApizarE	  h
X   80rF	  hX   POSrG	  hX   SUGGESTrH	  h]rI	  (X   patternsrJ	  X   basicrK	  eh]rL	  X	   sftp_freerM	  auKR}rN	  (hX   69rO	  h	X   how to return errorsrP	  hX
   ProgrammerrQ	  h
NhNhX   ELICIT-OFFER-OR-SUGGESTIONrR	  h]rS	  X   patternsrT	  ahNuKS}rU	  (hX   70rV	  h	X   ?rW	  hX
   ProgrammerrX	  h
X   82rY	  hX   CONTrZ	  hX   OTHERr[	  hNhNuKT}r\	  (hX   71r]	  h	X   I am sorry,r^	  hX   Apizar_	  h
X   83r`	  hX   UNCra	  hX   BE-POSITIVErb	  hNhNuKU}rc	  (hX   71rd	  h	X    I am confused.re	  hX   Apizarf	  h
X   84rg	  hX   CONTrh	  hX   COMMENT-ABOUT-UNDERSTANDINGri	  hNhNuKV}rj	  (hX   72rk	  h	X   how to return errors?rl	  hX
   Programmerrm	  h
X   82rn	  hX   REPro	  hX   ELICIT-OFFER-OR-SUGGESTIONrp	  h]rq	  X   patternsrr	  ahNuKW}rs	  (hX   73rt	  h	XH   There are several function used to get errors from different data types,ru	  hX   Apizarv	  h
X   86rw	  hX   PARTrx	  hX   INFORMry	  h]rz	  X   patternsr{	  ahNuKX}r|	  (hX   73r}	  h	X7   are you referring to getting errors from sftp_sessions?r~	  hX   Apizar	  h
X   86r	  hX   FOLr	  hX
   ELICIT-INFORMr	  h]r	  X   patternsr	  ah]r	  X   sftp_sessionr	  auKY}r	  (hX   74r	  h	X   yes from sftp_sessionsr	  hX
   Programmerr	  h
X   88r	  hX   POSr	  hX   INFORMr	  h]r	  X   patternsr	  ah]r	  X   sftp_sessionr	  auKZ}r	  (hX   75r	  h	X~   You can use the "int sftp_get_error(sftp_session session)" function to get the latest error set by a posix like sftp function.r	  hX   Apizar	  h
X   86r	  hX   POSr	  hX   SUGGESTr	  h]r	  (X   patternsr	  X   basicr	  eh]r	  (X   sftp_get_errorr	  X   sftp_sessionr	  euK[}r	  (hX   76r	  h	X5   can you give me example of output of sftp_get_error ?r	  hX
   Programmerr	  h
X   90r	  hX   FOLr	  hX
   ELICIT-INFORMr	  h]r	  X   examplesr	  ah]r	  X   sftp_get_errorr	  auK\}r	  (hX   77r	  h	X   an example for error checking when creating a directory is "if (sftp_get_error(session) != SSH_FX_FILE_ALREADY_EXISTS) { ... }"r	  hX   Apizar	  h
X   91r	  hX   POSr	  hX   INFORMr	  h]r	  X   examplesr	  ah]r	  X   sftp_get_errorr	  auK]}r	  (hX   78r	  h	X"   how to disconnect from the server?r	  hX
   Programmerr	  h
NhNhX   ELICIT-OFFER-OR-SUGGESTIONr	  h]r	  X   patternsr	  ahNuK^}r	  (hX   79r	  h	X]   To close an ssh_session, you can use the "void ssh_disconnect(ssh_session session)" function.r	  hX   Apizar	  h
X   93r	  hX   POSr	  hX   SUGGESTr	  h]r	  (X   patternsr	  X   basicr	  eh]r	  X   ssh_disconnectr	  auK_}r	  (hX   80r	  h	X   okay I think my job is doner	  hX
   Programmerr	  h
NhNhX   ASSESSr	  hNhNuK`}r	  (hX   81r	  h	X   Great! r	  hX   Apizar	  h
X   94r	  hX   POSr	  hX   ASSESSr	  hNhNuKa}r	  (hX   81r	  h	X9   Please contact my administrator for further instructions.r	  hX   Apizar	  h
NhNhX   SUGGESTr	  hNhNuuuK}r	  (hhh}r	  (K }r	  (hhh	X   hellor	  hX
   Programmerr	  h
NhNhX   BE-POSITIVEr	  hNhNuK}r	  (hhh	X   Hello!r	  hX   Apizar	  h
NhNhX   BE-POSITIVEr	  hNhNuK}r	  (hhh	X   How may I help you?r	  hX   Apizar	  h
NhNhX   ELICIT-OFFER-OR-SUGGESTIONr	  hNhNuK}r	  (hhh	X   I am Apiza. r	  hX   Apizar	  h
NhNhX   INFORMr	  hNhNuK}r	  (hh+h	X%   When was libssh Version 1.x released?r	  hX
   Programmerr	  h
NhNhX
   ELICIT-INFORMr	  h]r	  X   environmentr	  ahNuK}r	  (hh5h	X   Hmm, I don't know about that,r	  hX   Apizar	  h
h5hX   NEGr	  hX   INFORMr	  hNhNuK}r	  (hh5h	X   sorry! r	  hX   Apizar	  h
h<hX   CONTr	  hX   BE-POSITIVEr	  hNhNuK}r	  (hh5h	X    Is there anything else I can do?r	  hX   Apizar	  h
hFhX   FOLr	  hX   OFFERr	  hNhNuK}r 
  (hh<h	X"   How do I create a new ssh_session?r
  hX
   Programmerr
  h
NhNhX   ELICIT-OFFER-OR-SUGGESTIONr
  h]r
  X   patternsr
  ah]r
  X   ssh_sessionr
  auK	}r
  (hhFh	XI   The function "ssh_session ssh_new(void)" should create a new ssh_session.r	
  hX   Apizar

  h
hXhX   POSr
  hX   SUGGESTr
  h]r
  X   basicr
  ah]r
  (X   ssh_newr
  X   ssh_sessionr
  euK
}r
  (hhQh	X   How to I free a ssh session?r
  hX
   Programmerr
  h
NhNhX   ELICIT-OFFER-OR-SUGGESTIONr
  h]r
  X   patternsr
  ah]r
  X   ssh_sessionr
  auK}r
  (hhXh	X<   Try using the function "void ssh_free (ssh_session session)"r
  hX   Apizar
  h
X   10r
  hX   POSr
  hX   SUGGESTr
  h]r 
  (X   patternsr!
  X   basicr"
  eh]r#
  X   ssh_freer$
  auK}r%
  (hhch	X#   How do I connect to an IP and port?r&
  hX
   Programmerr'
  h
NhNhX   ELICIT-OFFER-OR-SUGGESTIONr(
  h]r)
  X   patternsr*
  ahNuK
}r+
  (hX   10r,
  h	XH   To connect, I\'d reccomend using "int ssh_connect(ssh_session session)".r-
  hX   Apizar.
  h
X   12r/
  hX   POSr0
  hX   SUGGESTr1
  h]r2
  (X   patternsr3
  X   basicr4
  eh]r5
  X   ssh_connectr6
  auK}r7
  (hX   10r8
  h	X    It looks like you can set an IP and Port using \n"int ssh_options_set(ssh_session session,\nenum ssh_options_e type,\nconst void * value \n)"r9
  hX   Apizar:
  h
X   12r;
  hX   POSr<
  hX   SUGGESTr=
  h]r>
  (X   patternsr?
  X   basicr@
  eh]rA
  X   ssh_options_setrB
  auK}rC
  (hX   11rD
  h	X,   What is the return value of ssh_options_set?rE
  hX
   ProgrammerrF
  h
X   14rG
  hX   FOLrH
  hX
   ELICIT-INFORMrI
  h]rJ
  X
   functionalityrK
  ah]rL
  X   ssh_options_setrM
  auK}rN
  (hX   12rO
  h	X@   ssh_options_set returns an int: "0 on success, &lt; 0 on error."rP
  hX   ApizarQ
  h
X   15rR
  hX   POSrS
  hX   INFORMrT
  h]rU
  (X
   functionalityrV
  X   basicrW
  eh]rX
  X   ssh_options_setrY
  auK}rZ
  (hX   13r[
  h	X"   How do I get an SSH error message?r\
  hX
   Programmerr]
  h
NhNhX   ELICIT-OFFER-OR-SUGGESTIONr^
  h]r_
  X   patternsr`
  ahNuK}ra
  (hX   14rb
  h	X7   The function "const char* ssh_get_error(void * error)".rc
  hX   Apizard
  h
X   17re
  hX   POSrf
  hX   INFORMrg
  h]rh
  X   basicri
  ah]rj
  X
   ssh_get_errorrk
  auK}rl
  (hX   14rm
  h	X:   This should return "A static string describing the error."rn
  hX   Apizaro
  h
X   18rp
  hX   CONTrq
  hX   SUGGESTrr
  h]rs
  X   patternsrt
  ah]ru
  X
   ssh_get_errorrv
  auK}rw
  (hX   15rx
  h	X   How do I pass the SSH password?ry
  hX
   Programmerrz
  h
NhNhX   ELICIT-OFFER-OR-SUGGESTIONr{
  h]r|
  X   patternsr}
  ahNuK}r~
  (hX   16r
  h	XA   The function ssh_options_set takes an enum "type" as a parameter.r
  hX   Apizar
  h
X   20r
  hX   POSr
  hX   INFORMr
  h]r
  X
   functionalityr
  ah]r
  X   ssh_options_setr
  auK}r
  (hX   16r
  h	X    One value for "type" is "SSH_OPTIONS_PASSWORD_AUTH": "Set it if password authentication should be used in ssh_userauth_auto_pubkey(). (int, 0=false). Currently without effect (ssh_userauth_auto_pubkey doesn\'t use password authentication)."r
  hX   Apizar
  h
X   21r
  hX   CONTr
  hX   INFORMr
  h]r
  (X   patternsr
  X
   functionalityr
  eh]r
  X   ssh_options_setr
  auK}r
  (hX   17r
  h	X3   What are the possible states of ssh_is_server_knownr
  hX
   Programmerr
  h
NhNhX
   ELICIT-INFORMr
  h]r
  X
   functionalityr
  ah]r
  X   ssh_is_server_knownr
  auK}r
  (hX   18r
  h	X`   The function int ssh_is_server_known (ssh_session session) returns an int, but it is deprecated.r
  hX   Apizar
  h
X   23r
  hX   PARTr
  hX   INFORMr
  h]r
  (X   environmentr
  X   basicr
  eh]r
  X   ssh_is_server_knownr
  auK}r
  (hX   19r
  h	X/   What is the alternative to ssh_is_server_known?r
  hX
   Programmerr
  h
X   24r
  hX   FOLr
  hX
   ELICIT-INFORMr
  h]r
  X	   structurer
  ah]r
  X   ssh_is_server_knownr
  auK}r
  (hX   20r
  h	X>   The best alternative would be "ssh_session_is_known_server()",r
  hX   Apizar
  h
X   25r
  hX   PARTr
  hX   SUGGESTr
  h]r
  X	   structurer
  ahNuK}r
  (hX   20r
  h	X/    but I can\'t find much information about that.r
  hX   Apizar
  h
X   26r
  hX   CONTr
  hX   INFORMr
  hNhNuK}r
  (hX   21r
  h	X6   What parameters does ssh_session_is_known_server take?r
  hX
   Programmerr
  h
X   26r
  hX   FOLr
  hX
   ELICIT-INFORMr
  h]r
  X   basicr
  ahNuK}r
  (hX   22r
  h	XB   ssh_session_is_known_server takes an "ssh_session" as a parameter.r
  hX   Apizar
  h
X   28r
  hX   POSr
  hX   INFORMr
  h]r
  X   basicr
  ahNuK}r
  (hX   23r
  h	X-   What does ssh_session_is_known_server return?r
  hX
   Programmerr
  h
X   26r
  hX   FOLr
  hX
   ELICIT-INFORMr
  h]r
  X   basicr
  ahNuK}r
  (hX   24r
  h	XR   "ssh_session_is_known_server()" returns an int describing the state of the server.r
  hX   Apizar
  h
X   30r
  hX   POSr
  hX   INFORMr
  h]r
  X   basicr
  ahNuK }r
  (hX   25r
  h	X3   What values can ssh_session_is_known_server return?r
  hX
   Programmerr
  h
X   31r
  hX   FOLr
  hX
   ELICIT-INFORMr
  h]r
  X
   functionalityr
  ahNuK!}r
  (hX   26r
  h	X8   It looks like these are all of the different values:\n\nr
  hX   Apizar
  h
X   32r
  hX   POSr
  hX   INFORMr
  h]r
  X
   functionalityr
  ah]r
  X   ssh_sessionr
  auK"}r
  (hX   26r
  h	Xf   /* These are the different states a SSH session can be into its life */\n enum ssh_session_state_e {\nr
  hX   Apizar   h
X   33r  hX   CONTr  hX   INFORMr  h]r  (X
   functionalityr  X	   structurer  eh]r  X   ssh_sessionr  auK#}r	  (hX   26r
  h	Xm    SSH_SESSION_STATE_NONE=0,\n SSH_SESSION_STATE_CONNECTING,\n SSH_SESSION_STATE_SOCKET_CONNECTED,\n SSH_SESSION_STATE_BANNER_RECEIVED,\n SSH_SESSION_STATE_INITIAL_KEX,\n SSH_SESSION_STATE_KEXINIT_RECEIVED,\n SSH_SESSION_STATE_DH,\n SSH_SESSION_STATE_AUTHENTICATING,\n SSH_SESSION_STATE_AUTHENTICATED,\n SSH_SESSION_STATE_ERROR,\n SSH_SESSION_STATE_DISCONNECTED\n };r  hX   Apizar  h
X   34r
  hX   CONTr  hX   INFORMr  h]r  (X
   functionalityr  X	   structurer  eh]r  X   ssh_sessionr  auK$}r  (hX   27r  h	X4   Which header file is ssh_session_is_known_server in?r  hX
   Programmerr  h
X   26r  hX   FOLr  hX
   ELICIT-INFORMr  h]r  X	   structurer  ahNuK%}r  (hX   28r  h	X
   I'm sorry,r   hX   Apizar!  h
X   36r"  hX   NEGr#  hX   BE-POSITIVEr$  hNhNuK&}r%  (hX   28r&  h	X   I can't help you with that. r'  hX   Apizar(  h
X   37r)  hX   CONTr*  hX   INFORMr+  hNhNuK'}r,  (hX   28r-  h	X$   Is there anything else I can answer?r.  hX   Apizar/  h
X   38r0  hX   FOLr1  hX   OFFERr2  hNhNuK(}r3  (hX   29r4  h	X-   Where is ssh_session_is_known_server defined?r5  hX
   Programmerr6  h
X   36r7  hX   REPr8  hX
   ELICIT-INFORMr9  h]r:  X	   structurer;  ahNuK)}r<  (hX   30r=  h	X
   I'm sorry,r>  hX   Apizar?  h
X   40r@  hX   NEGrA  hX   BE-POSITIVErB  hNhNuK*}rC  (hX   30rD  h	X   I can't help you with that. rE  hX   ApizarF  h
X   41rG  hX   CONTrH  hX   INFORMrI  hNhNuK+}rJ  (hX   30rK  h	X$   Is there anything else I can answer?rL  hX   ApizarM  h
X   42rN  hX   FOLrO  hX   OFFERrP  hNhNuK,}rQ  (hX   31rR  h	X+   What values can ssh_is_server_known return?rS  hX
   ProgrammerrT  h
X   24rU  hX   FOLrV  hX
   ELICIT-INFORMrW  h]rX  X
   functionalityrY  ah]rZ  X   ssh_is_server_knownr[  auK-}r\  (hX   32r]  h	X#   ssh_is_server_known returns an int.r^  hX   Apizar_  h
X   44r`  hX   POSra  hX   INFORMrb  h]rc  X   basicrd  ah]re  X   ssh_is_server_knownrf  auK.}rg  (hX   32rh  h	X   The value of this int can be SSH_SERVER_KNOWN_OK, SSH_SERVER_KNOWN_CHANGED, SSH_SERVER_FOUND_OTHER, SSH_SERVER_FILE_NOT_FOUND, or SSH_SERVER_NOT_KNOWN.ri  hX   Apizarj  h
X   45rk  hX   CONTrl  hX   INFORMrm  h]rn  X
   functionalityro  ah]rp  X   ssh_is_server_knownrq  auK/}rr  (hX   33rs  h	X&   What does SSH_SERVER_FOUND_OTHER mean?rt  hX
   Programmerru  h
X   46rv  hX   FOLrw  hX
   ELICIT-INFORMrx  h]ry  X   conceptsrz  ah]r{  X   ssh_is_server_knownr|  auK0}r}  (hX   34r~  h	X   It looks like SSH_SERVER_FOUND_OTHER indicates that "The host key for this server was not found but an other type of key exists."r  hX   Apizar  h
X   47r  hX   POSr  hX   INFORMr  h]r  X   conceptsr  ah]r  X   ssh_is_server_knownr  auK1}r  (hX   35r  h	X(   What are the possible types of SSH keys?r  hX
   Programmerr  h
X   48r  hX   FOLr  hX
   ELICIT-INFORMr  hNh]r  X   ssh_is_server_knownr  auK2}r  (hX   36r  h	X2   It looks like there are several possible SSH keys.r  hX   Apizar  h
X   49r  hX   PARTr  hX   INFORMr  hNh]r  X   ssh_is_server_knownr  auK3}r  (hX   36r  h	X8    Some examples are "ssh-rsa,ssh-dss,ecdh-sha2-nistp256".r  hX   Apizar  h
X   50r  hX   CONTr  hX   INFORMr  hNh]r  X   ssh_is_server_knownr  auK4}r  (hX   37r  h	X0   How do I determine which type of SSH key exists?r  hX
   Programmerr  h
X   51r  hX   FOLr  hX   ELICIT-OFFER-OR-SUGGESTIONr  h]r  X   patternsr  ahNuK5}r  (hX   38r  h	X6   The function "ssh_get_publickey_hash()" may be useful.r  hX   Apizar  h
X   52r  hX   POSr  hX   SUGGESTr  h]r  X   basicr  ah]r  X   ssh_get_publickey_hashr  auK6}r  (hX   38r  h	X7    It Allocates a buffer with the hash of the public key.r  hX   Apizar  h
X   53r  hX   CONTr  hX   INFORMr  h]r  X   patternsr  ah]r  X   ssh_get_publickey_hashr  auK7}r  (hX   39r  h	XF   Is there a libssh function to get the location of the public key file?r  hX
   Programmerr  h
X   54r  hX   FOLr  hX
   ELICIT-INFORMr  h]r  X   patternsr  ahNuK8}r  (hX   40r  h	X   I'm not sure about that.r  hX   Apizar  h
X   55r  hX   UNCr  hX   INFORMr  hNhNuK9}r  (hX   40r  h	XM   I was able to find that the known host file is in ~/.ssh/known_hosts on Unix.r  hX   Apizar  h
X   55r  hX   PARTr  hX   INFORMr  h]r  X	   structurer  ahNuK:}r  (hX   41r  h	X
   What's 1 + 1?r  hX
   Programmerr  h
NhNhX
   ELICIT-INFORMr  hNhNuK;}r  (hX   42r  h	hhX   Apizar  h
X   58r  hX   POSr  hX   INFORMr  hNhNuK<}r  (hX   43r  h	X!   What port does libssh default to?r  hX
   Programmerr  h
NhNhX
   ELICIT-INFORMr  h]r  X
   functionalityr  ahNuK=}r  (hX   44r  h	X   Default is port 22r  hX   Apizar  h
X   60r  hX   POSr  hX   INFORMr  h]r  X
   functionalityr  ahNuK>}r  (hX   45r  h	X.   What values does ssh_userauth_password return?r  hX
   Programmerr  h
NhNhX
   ELICIT-INFORMr  h]r  (X
   functionalityr  X   basicr  eh]r  X   ssh_userauth_passwordr  auK?}r   (hX   46r  h	X+   ssh_userauth_password() returns an int:\n\nr  hX   Apizar  h
X   62r  hX   POSr  hX   INFORMr  h]r  X   basicr  ah]r	  X   ssh_get_publickey_hashr
  auK@}r  (hX   46r  h	X7  SSH_AUTH_ERROR: A serious error happened.\nSSH_AUTH_DENIED: Authentication failed: use another method\nSSH_AUTH_PARTIAL: You've been partially authenticated, you still have to use another method\nSSH_AUTH_SUCCESS: Authentication success\nSSH_AUTH_AGAIN: In nonblocking mode, you've got to call this again later.r
  hX   Apizar  h
X   63r  hX   CONTr  hX   INFORMr  h]r  X
   functionalityr  ah]r  X   ssh_get_publickey_hashr  auKA}r  (hX   47r  h	XG   What are the commonly used functions taking ssh_channel as a parameter?r  hX
   Programmerr  h
NhNhX
   ELICIT-INFORMr  h]r  X	   structurer  ah]r  X   ssh_channelr  auKB}r  (hX   48r   h	XI   There are a lot of common functions that take ssh_channel as a parameter,r!  hX   Apizar"  h
X   65r#  hX   POSr$  hX   INFORMr%  h]r&  X	   structurer'  ah]r(  X   ssh_channelr)  auKC}r*  (hX   48r+  h	X1  including\n"void ssh_channel_free (ssh_channel channel)", \n"int channel_read_buffer (ssh_channel channel, ssh_buffer buffer, uint32_t count, int is_stderr)", \n"int ssh_channel_poll (ssh_channel channel, int is_stderr)", and\n"int ssh_channel_write (ssh_channel channel, const void *data, uint32_t len)".r,  hX   Apizar-  h
X   66r.  hX   CONTr/  hX   INFORMr0  h]r1  (X	   structurer2  X   basicr3  eh]r4  X   ssh_channelr5  auKD}r6  (hX   49r7  h	X!   How do I use channel_read_buffer?r8  hX
   Programmerr9  h
X   67r:  hX   FOLr;  hX   ELICIT-OFFER-OR-SUGGESTIONr<  h]r=  X   patternsr>  ah]r?  X   channel_read_bufferr@  auKE}rA  (hX   50rB  h	X   For example, if you have ssh_channel channel and ssh_buffer buffer, you could use\n"int nbytes = ssh_channel_read_buffer(channel, buffer, sizeof(buffer), 0);"rC  hX   ApizarD  h
X   68rE  hX   POSrF  hX   SUGGESTrG  h]rH  X   examplesrI  ah]rJ  X   channel_read_bufferrK  auKF}rL  (hX   51rM  h	X&   What is the actual type of ssh_buffer?rN  hX
   ProgrammerrO  h
X   69rP  hX   FOLrQ  hX
   ELICIT-INFORMrR  h]rS  X   basicrT  ah]rU  X
   ssh_bufferrV  auKG}rW  (hX   52rX  h	X9   The ssh_buffer_struct consists of the following fields:\nrY  hX   ApizarZ  h
X   70r[  hX   POSr\  hX   INFORMr]  h]r^  (X	   structurer_  X   basicr`  eh]ra  X
   ssh_bufferrb  auKH}rc  (hX   52rd  h	XH   char *data, uint32_t used, uint32_t allocated, uint32_t pos, int secure;re  hX   Apizarf  h
X   71rg  hX   CONTrh  hX   INFORMri  h]rj  (X	   structurerk  X   basicrl  eh]rm  X
   ssh_bufferrn  auKI}ro  (hX   53rp  h	XL   What is the difference between ssh_channel_read_buffer and ssh_channel_read?rq  hX
   Programmerrr  h
X   67rs  hX   FOLrt  hX
   ELICIT-INFORMru  h]rv  X
   functionalityrw  ah]rx  (X   channel_read_bufferry  X   ssh_channel_readrz  euKJ}r{  (hX   54r|  h	X   ssh_channel_read_buffer reads data from a channel into a buffer and has parameter ssh_buffer buffer, while ssh_channel_read reads data from a channel and has parameter void *dest.r}  hX   Apizar~  h
X   74r  hX   POSr  hX   INFORMr  h]r  X
   functionalityr  ah]r  (X   channel_read_bufferr  X   ssh_channel_readr  euKK}r  (hX   55r  h	X!   How do I close a channel cleanly?r  hX
   Programmerr  h
NhNhX   ELICIT-OFFER-OR-SUGGESTIONr  h]r  X   patternsr  ah]r  X   ssh_channelr  auKL}r  (hX   56r  h	X@   int ssh_channel_close(ssh_channel channel) will close a channel.r  hX   Apizar  h
X   75r  hX   POSr  hX   INFORMr  h]r  (X   patternsr  X   basicr  eh]r  X   ssh_channel_closer  auKM}r  (hX   56r  h	X   This sends an end of file and then closes the channel. You won't be able to recover any data the server was going to send or was in buffers.r  hX   Apizar  h
X   76r  hX   CONTr  hX   INFORMr  h]r  (X
   functionalityr  X   controlr  eh]r  X   ssh_channel_closer  auKN}r  (hX   57r  h	X;   Is ssh_channel_send_eof necessary before ssh_channel_close?r  hX
   Programmerr  h
X   76r  hX   FOLr  hX
   ELICIT-INFORMr  h]r  X
   directivesr  ah]r  (X   ssh_channel_closer  X   ssh_channel_send_eofr  euKO}r  (hX   58r  h	X&   ssh_channel_send_eof is not necessary,r  hX   Apizar  h
X   78r  hX   POSr  hX   INFORMr  h]r  X
   directivesr  ah]r  (X   ssh_channel_closer  X   ssh_channel_send_eofr  euKP}r  (hX   58r  h	XK    but you should use it before ssh_channel_close if no errors have occurred.r  hX   Apizar  h
X   79r  hX   CONTr  hX   SUGGESTr  h]r  X
   directivesr  ah]r  (X   ssh_channel_closer  X   ssh_channel_send_eofr  euKQ}r  (hX   59r  h	X0   Does ssh_channel_read NULL-terminate the buffer?r  hX
   Programmerr  h
NhNhX
   ELICIT-INFORMr  h]r  X
   functionalityr  ah]r  X   ssh_channel_readr  auKR}r  (hX   60r  h	X   Sorry, r  hX   Apizar  h
X   81r  hX   UNCr  hX   BE-POSITIVEr  hNhNuKS}r  (hX   60r  h	X   I am not sure. r  hX   Apizar  h
X   82r  hX   CONTr  hX   INFORMr  hNhNuKT}r  (hX   60r  h	XP   I found this code snippet that may be useful regarding ssh_channel_send_eof:\n\nr  hX   Apizar  h
X   81r  hX   PARTr  hX   INFORMr  hNh]r  X   ssh_channel_send_eofr  auKU}r  (hX   60r  h	X   rc = ssh_channel_send_eof(channel);\nif (rc == SSH_ERROR) {\n return -1;\n}\n\nwhile(!ssh_channel_is_eof(channel)) {\n rc = ssh_channel_read(channel, buf, sizeof(buf), 0);\n if (rc == SSH_ERROR) {\n return -1;\n }\n}\n\nssh_channel_close(channel);r  hX   Apizar  h
X   84r  hX   CONTr  hX   INFORMr  h]r  X   examplesr  ah]r  (X   ssh_channel_readr  X   ssh_channel_send_eofr  euKV}r  (hX   61r  h	XB   What are the possible types for the third parameter of sftp_mkdir?r  hX
   Programmerr  h
NhNhX
   ELICIT-INFORMr  h]r  X
   directivesr  ah]r  X
   sftp_mkdirr 
  auKW}r
  (hX   62r
  h	X;   The third parameter of sftp_mkdir must be of type "mode_t".r
  hX   Apizar
  h
X   86r
  hX   POSr
  hX   INFORMr
  h]r
  X
   directivesr	
  ah]r

  X
   sftp_mkdirr
  auKX}r
  (hX   63r

  h	X&   What are the possible types of mode_t?r
  hX
   Programmerr
  h
X   87r
  hX   FOLr
  hX
   ELICIT-INFORMr
  h]r
  X
   directivesr
  ahNuKY}r
  (hX   64r
  h	XO   I was able to find the following definitions for possible values of mode_t:\n\nr
  hX   Apizar
  h
X   88r
  hX   POSr
  hX   INFORMr
  h]r
  X	   structurer
  ahNuKZ}r
  (hX   64r
  h	X  #define S_IRWXU 0000700 /* RWX mask for owner */\n#define S_IRUSR 0000400 /* R for owner */\n#define S_IWUSR 0000200 /* W for owner */\n#define S_IXUSR 0000100 /* X for owner */\n\n#define S_IRWXG 0000070 /* RWX mask for group */\n#define S_IRGRP 0000040 /* R for group */\n#define S_IWGRP 0000020 /* W for group */\n#define S_IXGRP 0000010 /* X for group */\n\n#define S_IRWXO 0000007 /* RWX mask for other */\n#define S_IROTH 0000004 /* R for other */\n#define S_IWOTH 0000002 /* W for other */\n#define S_IXOTH 0000001 /* X for other */\n\n#define S_ISUID 0004000 /* set user id on execution */\n#define S_ISGID 0002000 /* set group id on execution */\n#define S_ISVTX 0001000 /* save swapped text even after use */r 
  hX   Apizar!
  h
X   89r"
  hX   CONTr#
  hX   INFORMr$
  h]r%
  X	   structurer&
  ahNuK[}r'
  (hX   65r(
  h	X2   What are the possible return values of sftp_write?r)
  hX
   Programmerr*
  h
NhNhX
   ELICIT-INFORMr+
  h]r,
  X
   functionalityr-
  ah]r.
  X
   sftp_writer/
  auK\}r0
  (hX   66r1
  h	X   How do I close a sftp_file?r2
  hX
   Programmerr3
  h
NhNhX   ELICIT-OFFER-OR-SUGGESTIONr4
  h]r5
  X   patternsr6
  ah]r7
  X	   sftp_filer8
  auK]}r9
  (hX   67r:
  h	Xj   sftp_write() Returns type "ssize_t": number of bytes written, &lt; 0 on error with ssh and sftp error set.r;
  hX   Apizar<
  h
X   91r=
  hX   POSr>
  hX   INFORMr?
  h]r@
  (X   basicrA
  X
   functionalityrB
  eh]rC
  X
   sftp_writerD
  auK^}rE
  (hX   68rF
  h	XJ   "int sftp_close(sftp_file file)" can be used to close an open file handle.rG
  hX   ApizarH
  h
X   92rI
  hX   POSrJ
  hX   SUGGESTrK
  h]rL
  (X   patternsrM
  X   basicrN
  eh]rO
  X
   sftp_closerP
  auK_}rQ
  (hX   69rR
  h	X,   How do I know if a sftp_file already exists?rS
  hX
   ProgrammerrT
  h
NhNhX   ELICIT-OFFER-OR-SUGGESTIONrU
  h]rV
  X   patternsrW
  ah]rX
  X	   sftp_filerY
  auK`}rZ
  (hX   70r[
  h	X#   How do I disconnect a sftp_session?r\
  hX
   Programmerr]
  h
NhNhX   ELICIT-OFFER-OR-SUGGESTIONr^
  h]r_
  X   patternsr`
  ah]ra
  X   sftp_sessionrb
  auKa}rc
  (hX   71rd
  h	X  In the function sftp_open(), the parameter "int accesstype" can regulate whether the file is opened based on file existance: "accesstype\tIs one of O_RDONLY, O_WRONLY or O_RDWR which request opening the file read-only,write-only or read/write. Acesss may also be bitwise-or\'d with one or more of the following: O_CREAT - If the file does not exist it will be created. O_EXCL - When used with O_CREAT, if the file already exists it is an error and the open will fail. O_TRUNC - If the file already exists it will be truncated."re
  hX   Apizarf
  h
X   95rg
  hX   POSrh
  hX   INFORMri
  h]rj
  (X
   functionalityrk
  X   patternsrl
  eh]rm
  (X	   sftp_openrn
  X	   sftp_filero
  euKb}rp
  (hX   72rq
  h	XG   I can\'t find anything to "disconnect" a sftp_session, only to "close".rr
  hX   Apizars
  h
X   96rt
  hX   NEGru
  hX   INFORMrv
  h]rw
  X   patternsrx
  ah]ry
  X   sftp_sessionrz
  auKc}r{
  (hX   73r|
  h	X   How do I close a sftp_session?r}
  hX
   Programmerr~
  h
X   98r
  hX   FOLr
  hX   ELICIT-OFFER-OR-SUGGESTIONr
  h]r
  X   patternsr
  ah]r
  X   sftp_sessionr
  auKd}r
  (hX   74r
  h	X#   And how do I switch SFTP directory?r
  hX
   Programmerr
  h
NhNhX   ELICIT-OFFER-OR-SUGGESTIONr
  h]r
  X   patternsr
  ahNuKe}r
  (hX   75r
  h	X>   "void sftp_free(sftp_session sftp)" will close a sftp session.r
  hX   Apizar
  h
X   99r
  hX   POSr
  hX   SUGGESTr
  h]r
  (X   patternsr
  X   basicr
  eh]r
  X	   sftp_freer
  auKf}r
  (hX   76r
  h	X7   Hmm, I can\'t find anything to "switch" SFTP directory,r
  hX   Apizar
  h
X   100r
  hX   NEGr
  hX   INFORMr
  h]r
  X   patternsr
  ahNuKg}r
  (hX   76r
  h	XR   but I see functions to "close", "create", "open", "move", or "remove" a directory.r
  hX   Apizar
  h
X   102r
  hX   CONTr
  hX   INFORMr
  h]r
  X   patternsr
  ahNuKh}r
  (hX   77r
  h	X3   How do I create a file inside a directory via SFTP?r
  hX
   Programmerr
  h
NhNhX   ELICIT-OFFER-OR-SUGGESTIONr
  h]r
  X   patternsr
  ahNuKi}r
  (hX   78r
  h	Xw   sftp_open() can be used to create a file inside a directory, using the "O_CREAT" option for the "accesstype" parameter.r
  hX   Apizar
  h
X   104r
  hX   POSr
  hX   SUGGESTr
  h]r
  (X   patternsr
  X   basicr
  eh]r
  X	   sftp_openr
  auuuK}r
  (hhh}r
  (K }r
  (hhh	X   Hir
  hX
   Programmerr
  h
NhNhX   BE-POSITIVEr
  hNhNuK}r
  (hhh	X   Hello! r
  hX   Apizar
  h
hhX   POSr
  hX   BE-POSITIVEr
  hNhNuK}r
  (hhh	XY   I am Apiza, an automated virtual assistant for programmers that is supervised by a human.r
  hX   Apizar
  h
hhX   CONTr
  hX   INFORMr
  hNhNuK}r
  (hhh	X$   I look forward to helping you today!r
  hX   Apizar
  h
hhX   CONTr
  hX   BE-POSITIVEr
  hNhNuK}r
  (hh+h	X'   how do I create a new session in libsshr
  hX
   Programmerr
  h
NhNhX   ELICIT-OFFER-OR-SUGGESTIONr
  h]r
  X   patternsr
  ah]r
  X   ssh_sessionr
  auK}r
  (hh5h	X/   I would suggest using the function ssh_new:\n\nr
  hX   Apizar
  h
h5hX   POSr
  hX   SUGGESTr
  h]r
  (X   patternsr
  X   basicr
  eh]r
  (X   ssh_newr
  X   ssh_sessionr
  euK}r
  (hh5h	X&   ssh_session ssh_new\t(\tvoid \t\t)\n\nr
  hX   Apizar
  h
h<hX   CONTr
  hX   INFORMr
  h]r
  X   basicr
  ah]r
  (X   ssh_newr
  X   ssh_sessionr
  euK}r
  (hh5h	X*   Description\nCreate a new ssh session.\n\nr
  hX   Apizar
  h
hFhX   CONTr
  hX   INFORMr
  h]r
  X
   functionalityr
  ah]r
  (X   ssh_newr
  X   ssh_sessionr
  euK}r
  (hh5h	X6   Returns\nA new ssh_session pointer, NULL on error.\n\nr
  hX   Apizar
  h
hQhX   CONTr
  hX   INFORMr
  h]r
  (X
   functionalityr   X   basicr  eh]r  (X   ssh_newr  X   ssh_sessionr  euK	}r  (hh5h	X4   References ssh_buffer_new(), and ssh_set_blocking().r  hX   Apizar  h
hXhX   CONTr  hX   INFORMr	  h]r
  X	   structurer  ah]r  (X   ssh_newr
  X   ssh_sessionr  euK
}r  (hh<h	X0   can you give me an example on how to use ssh_newr  hX
   Programmerr  h
hFhX   FOLr  hX
   ELICIT-INFORMr  h]r  X   examplesr  ah]r  X   ssh_newr  auK}r  (hhFh	X   Sure! r  hX   Apizar  h
X   10r  hX   POSr  hX   BE-POSITIVEr  hNhNuK}r  (hhFh	X.   Something like:\n\nmy_ssh_session = ssh_new();r  hX   Apizar   h
X   10r!  hX   POSr"  hX   INFORMr#  h]r$  X   examplesr%  ah]r&  X   ssh_newr'  auK
}r(  (hhQh	X   sweetr)  hX
   Programmerr*  h
X   12r+  hX   POSr,  hX   ASSESSr-  hNhNuK}r.  (hhXh	X   I'm glad to hear it!r/  hX   Apizar0  h
X   13r1  hX   POSr2  hX   BE-POSITIVEr3  hNhNuK}r4  (hhch	X'   how do I authenticate my libssh sessionr5  hX
   Programmerr6  h
NhNhX   ELICIT-OFFER-OR-SUGGESTIONr7  h]r8  X   patternsr9  ah]r:  X   ssh_sessionr;  auK}r<  (hX   10r=  h	X+   There are several authentication functions.r>  hX   Apizar?  h
X   15r@  hX   PARTrA  hX   INFORMrB  h]rC  X	   structurerD  ah]rE  X   ssh_sessionrF  auK}rG  (hX   10rH  h	X#   How would you like to authenticate?rI  hX   ApizarJ  h
X   15rK  hX   FOLrL  hX
   ELICIT-INFORMrM  h]rN  X   patternsrO  ahNuK}rP  (hX   11rQ  h	X   usernamerR  hX
   ProgrammerrS  h
X   17rT  hX   POSrU  hX   INFORMrV  h]rW  X   patternsrX  ahNuK}rY  (hX   12rZ  h	X<   I found a few functions that authenticate with username:\n\nr[  hX   Apizar\  h
X   15r]  hX   PARTr^  hX   INFORMr_  h]r`  (X	   structurera  X   patternsrb  eh]rc  X   ssh_sessionrd  auK}re  (hX   12rf  h	X,  int ssh_userauth_none\t(\tssh_session \tsession,\nconst char * \tusername \n)\n\nint ssh_userauth_password\t(\tssh_session \tsession,\nconst char * \tusername,\nconst char * \tpassword \n)\n\nint ssh_userauth_publickey\t(\tssh_session \tsession,\nconst char * \tusername,\nconst ssh_key \tprivkey \n)rg  hX   Apizarh  h
X   19ri  hX   CONTrj  hX   INFORMrk  h]rl  (X	   structurerm  X   basicrn  eh]ro  X   ssh_sessionrp  auK}rq  (hX   13rr  h	X)   how do I connect to localhost with libsshrs  hX
   Programmerrt  h
NhNhX   ELICIT-OFFER-OR-SUGGESTIONru  h]rv  X   patternsrw  ahNuK}rx  (hX   14ry  h	X^   To connect, I would recommend the function\n int ssh_connect\t(\tssh_session \tsession\t).\n\nrz  hX   Apizar{  h
X   21r|  hX   POSr}  hX   SUGGESTr~  h]r  (X   patternsr  X   basicr  eh]r  X   ssh_connectr  auK}r  (hX   14r  h	X   I also found a reference to "localhost" in \nint ssh_options_getopt\t(\tssh_session \tsession,\nint * \targcptr,\nchar ** \targv \n)r  hX   Apizar  h
X   22r  hX   FOLr  hX   INFORMr  h]r  (X   patternsr  X   basicr  eh]r  X   ssh_options_getoptr  auK}r  (hX   15r  h	X)   what do the return values for ssh_connectr  hX
   Programmerr  h
X   22r  hX   FOLr  hX
   ELICIT-INFORMr  h]r  X
   functionalityr  ah]r  X   ssh_connectr  auK}r  (hX   16r  h	X*   what are the return values for ssh_connectr  hX
   Programmerr  h
X   24r  hX   REPr  hX
   ELICIT-INFORMr  h]r  X
   functionalityr  ah]r  X   ssh_connectr  auK}r  (hX   17r  h	X   Returns\nSSH_OK on success, SSH_ERROR on error.\nSSH_AGAIN, if the session is in nonblocking mode, and call must be done again.r  hX   Apizar  h
X   25r  hX   POSr  hX   INFORMr  h]r  X
   functionalityr  ah]r  X   ssh_connectr  auK}r  (hX   18r  h	X4   what are the return values for ssh_userauth_passwordr  hX
   Programmerr  h
X   20r  hX   FOLr  hX
   ELICIT-INFORMr  h]r  X
   functionalityr  ah]r  X   ssh_userauth_passwordr  auK}r  (hX   19r  h	XB  Returns\nSSH_AUTH_ERROR: A serious error happened.\nSSH_AUTH_DENIED: Authentication failed: use another method\nSSH_AUTH_PARTIAL: You've been partially authenticated, you still have to use another method\nSSH_AUTH_SUCCESS: Authentication success\nSSH_AUTH_AGAIN: In nonblocking mode, you've got to call this again later.\nr  hX   Apizar  h
X   27r  hX   POSr  hX   INFORMr  h]r  X
   functionalityr  ah]r  X   ssh_userauth_passwordr  auK}r  (hX   19r  h	X   Note\nMost server implementations do not permit changing the username during authentication. The username should only be set with ssh_options_set() only before you connect to the server.r  hX   Apizar  h
X   28r  hX   FOLr  hX   INFORMr  h]r  X
   functionalityr  ah]r  X   ssh_userauth_passwordr  auK}r  (hX   20r  h	X/   how do I check that the host is known in libsshr  hX
   Programmerr  h
NhNhX   ELICIT-OFFER-OR-SUGGESTIONr  h]r  X   patternsr  ahNuK}r  (hX   21r  h	XL   There is a function int ssh_is_server_known\t(\tssh_session \tsession\t)\n\nr  hX   Apizar  h
X   30r  hX   POSr  hX   INFORMr  h]r  (X
   functionalityr  X   patternsr  X   basicr  eh]r  X   ssh_is_server_knownr  auK }r  (hX   21r  h	X~   Description\nCheck if the server is known.\nChecks the user's known host file for a previous connection to the current server.r  hX   Apizar  h
X   31r  hX   CONTr  hX   INFORMr  h]r  (X
   functionalityr  X   patternsr  X   basicr  eh]r  X   ssh_is_server_knownr  auK!}r  (hX   22r  h	X$   what does ssh_is_server_known returnr  hX
   Programmerr  h
X   31r  hX   FOLr  hX
   ELICIT-INFORMr  h]r  X
   functionalityr  ah]r  X   ssh_is_server_knownr  auK"}r  (hX   23r  h	Xs  Returns\nSSH_SERVER_KNOWN_OK: The server is known and has not changed.\nSSH_SERVER_KNOWN_CHANGED: The server key has changed. Either you are under attack or the administrator changed the key. You HAVE to warn the user about a possible attack.\nSSH_SERVER_FOUND_OTHER: The server gave use a key of a type while we had an other type recorded. It is a possible attack.\nSSH_SERVER_NOT_KNOWN: The server is unknown. User should confirm the MD5 is correct.\nSSH_SERVER_FILE_NOT_FOUND: The known host file does not exist. The host is thus unknown. File will be created if host key is accepted.\nSSH_SERVER_ERROR: Some error happened.r   hX   Apizar  h
X   33r  hX   POSr  hX   INFORMr  h]r  X
   functionalityr  ah]r  X   ssh_is_server_knownr  auK#}r	  (hX   24r
  h	X-   how do I create a new ssh_channel with libsshr  hX
   Programmerr  h
NhNhX   ELICIT-OFFER-OR-SUGGESTIONr
  h]r  X   patternsr  ah]r  X   ssh_channelr  auK$}r  (hX   25r  h	X[   I think you're looking for \n\nssh_channel ssh_channel_new\t(\tssh_session \tsession\t)\n\nr  hX   Apizar  h
X   35r  hX   POSr  hX   SUGGESTr  h]r  (X   patternsr  X   basicr  eh]r  X   ssh_channel_newr  auK%}r  (hX   25r  h	X)   Description\nAllocate a new  channel.\n\nr   hX   Apizar!  h
X   36r"  hX   CONTr#  hX   INFORMr$  h]r%  X
   functionalityr&  ah]r'  X   ssh_channel_newr(  auK&}r)  (hX   25r*  h	X0   Parameters\nsession: The ssh session to use.\n\nr+  hX   Apizar,  h
X   37r-  hX   CONTr.  hX   INFORMr/  h]r0  X   basicr1  ah]r2  X   ssh_channel_newr3  auK'}r4  (hX   25r5  h	X?   Returns\nA pointer to a newly allocated channel, NULL on error.r6  hX   Apizar7  h
X   38r8  hX   CONTr9  hX   INFORMr:  h]r;  X
   functionalityr<  ah]r=  X   ssh_channel_newr>  auK(}r?  (hX   26r@  h	X-   how do I execute a command with a ssh_channelrA  hX
   ProgrammerrB  h
NhNhX   ELICIT-OFFER-OR-SUGGESTIONrC  h]rD  X   patternsrE  ah]rF  X   ssh_channelrG  auK)}rH  (hX   27rI  h	XS   int ssh_channel_request_exec\t(\tssh_channel \tchannel,\nconst char * \tcmd \n)\n\nrJ  hX   ApizarK  h
X   40rL  hX   POSrM  hX   INFORMrN  h]rO  X   basicrP  ah]rQ  X   ssh_channel_request_execrR  auK*}rS  (hX   27rT  h	Xc   Description\nRun a shell command without an interactive shell.\nThis is similar to 'sh -c command'.rU  hX   ApizarV  h
X   41rW  hX   CONTrX  hX   INFORMrY  h]rZ  X
   functionalityr[  ah]r\  X   ssh_channel_request_execr]  auK+}r^  (hX   28r_  h	X)   what does ssh_channel_request_exec returnr`  hX
   Programmerra  h
X   41rb  hX   FOLrc  hX
   ELICIT-INFORMrd  h]re  X
   functionalityrf  ah]rg  X   ssh_channel_request_execrh  auK,}ri  (hX   29rj  h	X{   Returns\nSSH_OK on success, SSH_ERROR if an error occurred, SSH_AGAIN if in nonblocking mode and call has to be done again.rk  hX   Apizarl  h
X   43rm  hX   POSrn  hX   INFORMro  h]rp  X
   functionalityrq  ah]rr  X   ssh_channel_request_execrs  auK-}rt  (hX   30ru  h	X4   how do I read the result of ssh_channel_request_execrv  hX
   Programmerrw  h
X   41rx  hX   FOLry  hX   ELICIT-OFFER-OR-SUGGESTIONrz  h]r{  X   patternsr|  ah]r}  X   ssh_channel_request_execr~  auK.}r  (hX   31r  h	XH   I found a couple of functions that involve reading from the channel:\n\nr  hX   Apizar  h
X   45r  hX   PARTr  hX   INFORMr  h]r  X	   structurer  ah]r  X   ssh_channelr  auK/}r  (hX   31r  h	X  int channel_read_buffer\t(\tssh_channel \tchannel,\nssh_buffer \tbuffer,\nuint32_t \tcount,\nint \tis_stderr \n)\n\nint ssh_channel_read\t(\tssh_channel \tchannel,\nvoid * \tdest,\nuint32_t \tcount,\nint \tis_stderr \n)\n\nint ssh_channel_read_nonblocking\t(\tssh_channel \tchannel,\nvoid * \tdest,\nuint32_t \tcount,\nint \tis_stderr \n)\n\nint ssh_channel_read_timeout\t(\tssh_channel \tchannel,\nvoid * \tdest,\nuint32_t \tcount,\nint \tis_stderr,\nint \ttimeout \n)\n\nr  hX   Apizar  h
X   46r  hX   CONTr  hX   INFORMr  h]r  (X	   structurer  X   basicr  eh]r  X   ssh_channelr  auK0}r  (hX   31r  h	X0    Would you like to hear more about one of these?r  hX   Apizar  h
X   47r  hX   FOLr  hX
   ELICIT-INFORMr  h]r  X   basicr  ahNuK1}r  (hX   32r  h	X.   can you give me an example of ssh_channel_readr  hX
   Programmerr  h
X   47r  hX   FOLr  hX
   ELICIT-INFORMr  h]r  X   examplesr  ah]r  X   ssh_channel_readr  auK2}r  (hX   33r  h	X   Sure, here's an example:\nr  hX   Apizar  h
X   49r  hX   POSr  hX   INFORMr  h]r  X   examplesr  ah]r  X   ssh_channel_readr  auK3}r  (hX   33r  h	Xt   ssh_channel channel;\nchar buffer[256];\nint nbytes;\nnbytes = ssh_channel_read(channel, buffer, sizeof(buffer), 0);r  hX   Apizar  h
X   50r  hX   CONTr  hX   INFORMr  h]r  X   examplesr  ah]r  X   ssh_channel_readr  auK4}r  (hX   34r  h	X#   how do I send an eof to the channelr  hX
   Programmerr  h
NhNhX   ELICIT-OFFER-OR-SUGGESTIONr  h]r  X   patternsr  ah]r  X   ssh_channelr  auK5}r  (hX   35r  h	X   This method should work:\n\nr  hX   Apizar  h
X   52r  hX   POSr  hX   SUGGESTr  h]r  X   patternsr  ah]r  X   ssh_channel_send_eofr  auK6}r  (hX   35r  h	X7   int ssh_channel_send_eof\t(\tssh_channel channel\t)\n\nr  hX   Apizar  h
X   53r  hX   CONTr  hX   INFORMr  h]r  X   basicr  ah]r  X   ssh_channel_send_eofr  auK7}r  (hX   35r  h	X   Description \nSend an end of file on the channel. \nThis doesn't close the channel. You may still read from it but not write.\n\nr  hX   Apizar  h
X   54r  hX   CONTr  hX   INFORMr  h]r  X
   functionalityr  ah]r  X   ssh_channel_send_eofr  auK8}r  (hX   35r  h	X9   Parameters \nchannel: The channel to send the eof to.\n\nr  hX   Apizar  h
X   55r  hX   CONTr  hX   INFORMr  h]r  X   basicr  ah]r  X   ssh_channel_send_eofr  auK9}r  (hX   35r  h	X<   Returns \nSSH_OK on success, SSH_ERROR if an error occurred.r  hX   Apizar  h
X   56r  hX   CONTr  hX   INFORMr  h]r  X
   functionalityr  ah]r  X   ssh_channel_send_eofr  auK:}r   (hX   36r  h	X   how do I close the channelr  hX
   Programmerr  h
NhNhX   ELICIT-OFFER-OR-SUGGESTIONr  h]r  X   patternsr  ah]r  X   ssh_channelr  auK;}r	  (hX   37r
  h	XF   I think you can use int ssh_channel_close\t(\tssh_channel \tchannel\t)r  hX   Apizar  h
X   58r
  hX   POSr  hX   SUGGESTr  h]r  (X   patternsr  X   basicr  eh]r  X   ssh_channel_closer  auK<}r  (hX   38r  h	X"   what does ssh_channel_close returnr  hX
   Programmerr  h
X   59r  hX   FOLr  hX
   ELICIT-INFORMr  h]r  X
   functionalityr  ah]r  X   ssh_channel_closer  auK=}r   (hX   39r!  h	X;   Returns\nSSH_OK on success, SSH_ERROR if an error occurred.r"  hX   Apizar#  h
X   60r$  hX   POSr%  hX   INFORMr&  h]r'  X
   functionalityr(  ah]r)  X   ssh_channel_closer*  auK>}r+  (hX   40r,  h	X5   why am I getting an error on ssh_channel_request_execr-  hX
   Programmerr.  h
NhNhX
   ELICIT-INFORMr/  h]r0  X
   functionalityr1  ah]r2  X   ssh_channel_request_execr3  auK?}r4  (hX   41r5  h	X#   What kind of error are you getting?r6  hX   Apizar7  h
X   62r8  hX   FOLr9  hX
   ELICIT-INFORMr:  h]r;  X
   functionalityr<  ah]r=  X   ssh_channel_request_execr>  auK@}r?  (hX   42r@  h	X	   SSH_ERRORrA  hX
   ProgrammerrB  h
X   63rC  hX   POSrD  hX   INFORMrE  h]rF  X
   functionalityrG  ah]rH  X   ssh_channel_request_execrI  auKA}rJ  (hX   43rK  h	X&   This function may help you debug: \n\nrL  hX   ApizarM  h
X   62rN  hX   PARTrO  hX   SUGGESTrP  h]rQ  X   patternsrR  ah]rS  X
   ssh_get_errorrT  auKB}rU  (hX   43rV  h	X3   const char* ssh_get_error\t(\tvoid * \terror\t)\n\nrW  hX   ApizarX  h
X   65rY  hX   CONTrZ  hX   INFORMr[  h]r\  X   basicr]  ah]r^  X
   ssh_get_errorr_  auKC}r`  (hX   43ra  h	XE   Description\nRetrieve the error text message from the last error.\n\nrb  hX   Apizarc  h
X   66rd  hX   CONTre  hX   INFORMrf  h]rg  X
   functionalityrh  ah]ri  X
   ssh_get_errorrj  auKD}rk  (hX   43rl  h	X2   Parameters\nerror: An ssh_session or ssh_bind.\n\nrm  hX   Apizarn  h
X   67ro  hX   CONTrp  hX   INFORMrq  h]rr  X
   functionalityrs  ah]rt  X
   ssh_get_errorru  auKE}rv  (hX   43rw  h	X.   Returns\nA static string describing the error.rx  hX   Apizary  h
X   68rz  hX   CONTr{  hX   INFORMr|  h]r}  X
   functionalityr~  ah]r  X
   ssh_get_errorr  auKF}r  (hX   44r  h	X!   what does ssh_msg_disconnect meanr  hX
   Programmerr  h
NhNhX
   ELICIT-INFORMr  h]r  X
   functionalityr  ahNuKG}r  (hX   45r  h	X   ohr  hX
   Programmerr  h
X   70r  hX   POSr  hX   ASSESSr  hNhNuKH}r  (hX   46r  h	X   I don't have the channel openr  hX
   Programmerr  h
X   71r  hX   CONTr  hX   INFORMr  h]r  X
   functionalityr  ahNuKI}r  (hX   47r  h	X   how do I open a channel sessionr  hX
   Programmerr  h
NhNhX   ELICIT-OFFER-OR-SUGGESTIONr  h]r  X   patternsr  ah]r  X   ssh_channelr  auKJ}r  (hX   48r  h	X@   This function may help with deciphering a disconnect message\n\nr  hX   Apizar  h
X   70r  hX   POSr  hX   SUGGESTr  h]r  X   patternsr  ahNuKK}r  (hX   48r  h	XC   const char* ssh_get_disconnect_message\t(\tssh_session \tsession\t)r  hX   Apizar  h
X   74r  hX   CONTr  hX   INFORMr  h]r  X   basicr  ah]r  X   ssh_get_disconnect_messager  auKL}r  (hX   49r  h	X7   This function should let you open a channel session\n\nr  hX   Apizar  h
X   73r  hX   POSr  hX   SUGGESTr  h]r  X   patternsr  ah]r  X   ssh_channel_open_sessionr  auKM}r  (hX   49r  h	X=   int ssh_channel_open_session\t(\tssh_channel \tchannel\t)\n\nr  hX   Apizar  h
X   76r  hX   CONTr  hX   INFORMr  h]r  X   basicr  ah]r  X   ssh_channel_open_sessionr  auKN}r  (hX   49r  h	XQ   Description\nOpen a session channel (suited for a shell, not TCP forwarding).\n\nr  hX   Apizar  h
X   77r  hX   CONTr  hX   INFORMr  h]r  (X   qualityr  X   basicr  eh]r  X   ssh_channel_open_sessionr  auKO}r  (hX   49r  h	X.   Parameters\nchannel: An allocated channel.\n\nr  hX   Apizar  h
X   78r  hX   CONTr  hX   INFORMr  h]r  X   basicr  ah]r  X   ssh_channel_open_sessionr  auKP}r  (hX   49r  h	X   Returns\nSSH_OK on success, SSH_ERROR if an error occurred, SSH_AGAIN if in nonblocking mode and call has to be done again.\n\nr  hX   Apizar  h
X   79r  hX   CONTr  hX   INFORMr  h]r  X
   functionalityr  ah]r  X   ssh_channel_open_sessionr  auKQ}r  (hX   49r  h	Xx   See also\nssh_channel_open_forward()\nssh_channel_request_env()\nssh_channel_request_shell()\nssh_channel_request_exec()r  hX   Apizar  h
X   80r  hX   CONTr  hX   INFORMr  hNh]r  X   ssh_channel_open_sessionr  auKR}r  (hX   50r  h	X(   how do I create a sftp session in libsshr  hX
   Programmerr  h
NhNhX   ELICIT-OFFER-OR-SUGGESTIONr  h]r  X   patternsr  ah]r  X   sftp_sessionr  auKS}r  (hX   51r   h	X6   sftp_session sftp_new\t(\tssh_session \tsession\t)\n\nr  hX   Apizar  h
X   82r  hX   POSr  hX   INFORMr  h]r  X   basicr  ah]r  X   sftp_newr	  auKT}r
  (hX   51r  h	X*   Description\nStart a new sftp session.\n\nr  hX   Apizar
  h
X   83r  hX   CONTr  hX   INFORMr  h]r  X   basicr  ah]r  X   sftp_newr  auKU}r  (hX   51r  h	X0   Parameters\nsession: The ssh session to use.\n\nr  hX   Apizar  h
X   84r  hX   CONTr  hX   INFORMr  h]r  X   basicr  ah]r  X   sftp_newr  auKV}r   (hX   51r!  h	X1   Returns\nA new sftp session or NULL on error.\n\nr"  hX   Apizar#  h
X   85r$  hX   CONTr%  hX   INFORMr&  h]r'  (X   basicr(  X
   functionalityr)  eh]r*  X   sftp_newr+  auKW}r,  (hX   51r-  h	XU   References ssh_channel_free(), ssh_channel_new(), and ssh_channel_open_session().\n\nr.  hX   Apizar/  h
X   86r0  hX   CONTr1  hX   INFORMr2  h]r3  X	   structurer4  ah]r5  X   sftp_newr6  auKX}r7  (hX   51r8  h	X   See also\nsftp_free()r9  hX   Apizar:  h
X   87r;  hX   CONTr<  hX   INFORMr=  hNh]r>  X   sftp_newr?  auKY}r@  (hX   52rA  h	X   how do I init the sftp sessionrB  hX
   ProgrammerrC  h
NhNhX   ELICIT-OFFER-OR-SUGGESTIONrD  h]rE  X   patternsrF  ah]rG  X   sftp_sessionrH  auKZ}rI  (hX   53rJ  h	X   how do I create a directoryrK  hX
   ProgrammerrL  h
NhNhX   ELICIT-OFFER-OR-SUGGESTIONrM  h]rN  X   patternsrO  ah]rP  X	   sftp_initrQ  auK[}rR  (hX   54rS  h	X   This should do it:\n\nrT  hX   ApizarU  h
X   89rV  hX   POSrW  hX   SUGGESTrX  h]rY  X   patternsrZ  ah]r[  X	   sftp_initr\  auK\}r]  (hX   54r^  h	X,   int sftp_init\t(\tsftp_session \tsftp\t)\n\nr_  hX   Apizar`  h
X   91ra  hX   CONTrb  hX   INFORMrc  h]rd  X   basicre  ah]rf  X	   sftp_initrg  auK]}rh  (hX   54ri  h	X=   Description\nInitialize the sftp session with the server.\n\nrj  hX   Apizark  h
X   92rl  hX   CONTrm  hX   INFORMrn  h]ro  X
   functionalityrp  ah]rq  X	   sftp_initrr  auK^}rs  (hX   54rt  h	X5   Parameters\nsftp: The sftp session to initialize.\n\nru  hX   Apizarv  h
X   93rw  hX   CONTrx  hX   INFORMry  h]rz  X   basicr{  ah]r|  X	   sftp_initr}  auK_}r~  (hX   54r  h	X>   Returns\n0 on success, &lt; 0 on error with ssh error set.\n\nr  hX   Apizar  h
X   94r  hX   CONTr  hX   INFORMr  h]r  X
   functionalityr  ah]r  X	   sftp_initr  auK`}r  (hX   54r  h	X    References ssh_buffer_new().\n\nr  hX   Apizar  h
X   95r  hX   CONTr  hX   INFORMr  h]r  X	   structurer  ah]r  X	   sftp_initr  auKa}r  (hX   54r  h	X   See also\nsftp_new()r  hX   Apizar  h
X   96r  hX   CONTr  hX   INFORMr  hNh]r  X	   sftp_initr  auKb}r  (hX   55r  h	X0   how do I create a directory in libssh using sftpr  hX
   Programmerr  h
X   90r  hX   REPr  hX   ELICIT-OFFER-OR-SUGGESTIONr  h]r  X   patternsr  ahNuKc}r  (hX   56r  h	X+   how do I create a file in libssh using sftpr  hX
   Programmerr  h
NhNhX   ELICIT-OFFER-OR-SUGGESTIONr  h]r  X   patternsr  ahNuKd}r  (hX   57r  h	XH   I found two functions that may be appropriate to create a directory:\n\nr  hX   Apizar  h
X   98r  hX   PARTr  hX   SUGGESTr  h]r  X   patternsr  ahNuKe}r  (hX   57r  h	XY   int sftp_mkdir\t(\tsftp_session \tsftp,\nconst char * \tdirectory,\nmode_t \tmode \n)\n\nr  hX   Apizar  h
X   100r  hX   CONTr  hX   INFORMr  h]r  X   basicr  ah]r  X
   sftp_mkdirr  auKf}r  (hX   57r  h	X$   Description\nCreate a directory.\n\nr  hX   Apizar  h
X   101r  hX   CONTr  hX   INFORMr  h]r  X   basicr  ah]r  X
   sftp_mkdirr  auKg}r  (hX   57r  h	XU   and\n\nsftp_dir sftp_opendir\t(\tsftp_session \tsession,\nconst char * \tpath \n)\n\nr  hX   Apizar  h
X   102r  hX   CONTr  hX   INFORMr  h]r  X   basicr  ah]r  X   sftp_opendirr  auKh}r  (hX   57r  h	X?   Description\nOpen a directory used to obtain directory entries.r  hX   Apizar  h
X   103r  hX   CONTr  hX   INFORMr  h]r  X   basicr  ah]r  X   sftp_opendirr  auKi}r  (hX   58r  h	X,   I can\'t find a function to "create" a file,r  hX   Apizar  h
X   99r  hX   NEGr  hX   INFORMr  h]r  X   patternsr  ahNuKj}r  (hX   58r  h	X&   but I found one to "write" a file:\n\nr  hX   Apizar  h
X   105r  hX   CONTr  hX   INFORMr  h]r  X   patternsr  ahNuKk}r  (hX   58r  h	XQ   ssize_t sftp_write\t(\tsftp_file file, \nconst void * buf, \nsize_t count \n)\n\nr  hX   Apizar  h
X   106r  hX   CONTr  hX   INFORMr  h]r  X   basicr  ah]r  X
   sftp_writer  auKl}r  (hX   58r   h	XC   Description \nWrite to a file using an opened sftp file handle.\n\nr  hX   Apizar  h
X   107r  hX   CONTr  hX   INFORMr  h]r  X
   functionalityr  ah]r  X
   sftp_writer	  auKm}r
  (hX   58r  h	X   Parameters \nfile: Open sftp file handle to write to. \nbuf: Pointer to buffer to write data. \ncount: Size of buffer in bytes.\n\nr  hX   Apizar
  h
X   108r  hX   CONTr  hX   INFORMr  h]r  X
   functionalityr  ah]r  X
   sftp_writer  auKn}r  (hX   58r  h	XO   Returns \nNumber of bytes written, &lt; 0 on error with ssh and sftp error set.r  hX   Apizar  h
X   109r  hX   CONTr  hX   INFORMr  h]r  X
   functionalityr  ah]r  X
   sftp_writer  auKo}r   (hX   59r!  h	X(   can you give me an example of sftp_mkdirr"  hX
   Programmerr#  h
X   101r$  hX   FOLr%  hX
   ELICIT-INFORMr&  h]r'  X   examplesr(  ah]r)  X
   sftp_mkdirr*  auKp}r+  (hX   60r,  h	X   Sure, here\'s an example:\n\nr-  hX   Apizar.  h
X   111r/  hX   POSr0  hX   INFORMr1  h]r2  X   examplesr3  ah]r4  X
   sftp_mkdirr5  auKq}r6  (hX   60r7  h	XJ   int rc;\nsftp_session sftp;\nrc = sftp_mkdir(sftp, "helloworld", S_IRWXU);r8  hX   Apizar9  h
X   112r:  hX   CONTr;  hX   INFORMr<  h]r=  X   examplesr>  ah]r?  X
   sftp_mkdirr@  auKr}rA  (hX   61rB  h	X   what does sftp_mkdir returhnrC  hX
   ProgrammerrD  h
X   101rE  hX   FOLrF  hX
   ELICIT-INFORMrG  h]rH  X
   functionalityrI  ah]rJ  X
   sftp_mkdirrK  auKs}rL  (hX   62rM  h	XC   Returns\n0 on success, &lt; 0 on error with ssh and sftp error set.rN  hX   ApizarO  h
X   114rP  hX   POSrQ  hX   INFORMrR  h]rS  X
   functionalityrT  ah]rU  X
   sftp_mkdirrV  auKt}rW  (hX   63rX  h	X+   how do I create a file in libssh using sftprY  hX
   ProgrammerrZ  h
X   99r[  hX   REPr\  hX   ELICIT-OFFER-OR-SUGGESTIONr]  h]r^  X   patternsr_  ahNuKu}r`  (hX   64ra  h	X+   how do I tell if a directory already existsrb  hX
   Programmerrc  h
NhNhX   ELICIT-OFFER-OR-SUGGESTIONrd  h]re  X   patternsrf  ahNuKv}rg  (hX   65rh  h	X*   Was sftp_write useful in creating a file? ri  hX   Apizarj  h
X   116rk  hX   FOLrl  hX   ELICIT-ASSESSMENTrm  h]rn  X
   functionalityro  ah]rp  X
   sftp_writerq  auKw}rr  (hX   65rs  h	X!   If not, sftp_open might help.\n\nrt  hX   Apizaru  h
X   116rv  hX   POSrw  hX   SUGGESTrx  h]ry  X   patternsrz  ah]r{  X	   sftp_openr|  auKx}r}  (hX   65r~  h	X'   Description\nOpen a file on the server.r  hX   Apizar  h
X   119r  hX   CONTr  hX   INFORMr  h]r  X   basicr  ah]r  X	   sftp_openr  auKy}r  (hX   66r  h	X   tell me about Errorr  hX
   Programmerr  h
NhNhX
   ELICIT-INFORMr  h]r  X   basicr  ahNuKz}r  (hX   67r  h	X;   I can't find a function that checks if a directory exists. r  hX   Apizar  h
X   117r  hX   NEGr  hX   INFORMr  h]r  X   patternsr  ahNuK{}r  (hX   67r  h	X*  However, there are many functions requiring a directory, including \n\nsftp_dir sftp_opendir\t(\tsftp_session \tsession,\nconst char * \tpath \n)\n\nsftp_attributes sftp_readdir\t(\tsftp_session \tsession,\nsftp_dir \tdir \n)\n\nint sftp_rmdir\t(\tsftp_session \tsftp,\nconst char * \tdirectory \n)r  hX   Apizar  h
X   117r  hX   PARTr  hX   INFORMr  h]r  (X   patternsr  X   basicr  ehNuK|}r  (hX   68r  h	X   tell me about sftp_get_errorr  hX
   Programmerr  h
NhNhX
   ELICIT-INFORMr  h]r  X   basicr  ah]r  X   sftp_get_errorr  auK}}r  (hX   69r  h	X1   int sftp_get_error\t(\tsftp_session \tsftp\t)\n\nr  hX   Apizar  h
X   124r  hX   POSr  hX   INFORMr  h]r  X   basicr  ah]r  X   sftp_get_errorr  auK~}r  (hX   69r  h	Xw   Description\nGet the last sftp error.\nUse this function to get the latest error set by a posix like sftp function.\n\nr  hX   Apizar  h
X   125r  hX   CONTr  hX   INFORMr  h]r  (X
   functionalityr  X   patternsr  eh]r  X   sftp_get_errorr  auK}r  (hX   69r  h	X@   Parameters\nsftp: The sftp session where the error is saved.\n\nr  hX   Apizar  h
X   126r  hX   CONTr  hX   INFORMr  h]r  X
   functionalityr  ah]r  X   sftp_get_errorr  auK}r  (hX   69r  h	X`   Returns\nThe saved error (see server responses), &lt; 0 if an error in the function occured.\n\nr  hX   Apizar  h
X   127r  hX   CONTr  hX   INFORMr  h]r  X
   functionalityr  ah]r  X   sftp_get_errorr  auK}r  (hX   69r  h	X7   References ssh_buffer_free(), and ssh_buffer_new().\n\nr  hX   Apizar  h
X   128r  hX   CONTr  hX   INFORMr  h]r  X	   structurer  ah]r  X   sftp_get_errorr  auK}r  (hX   69r  h	X   See also\nServer responsesr  hX   Apizar  h
X   129r  hX   CONTr  hX   INFORMr  hNh]r  X   sftp_get_errorr  auK}r  (hX   70r  h	X   tell me about server responesr  hX
   Programmerr  h
X   130r  hX   FOLr  hX
   ELICIT-INFORMr  h]r  X   basicr  ahNuK}r  (hX   71r  h	X9   I can\'t find specific information on "server responses" r  hX   Apizar  h
X   131r  hX   NEGr  hX   INFORMr  h]r  X   basicr  ahNuK}r  (hX   71r  h	XN   but in context, I believe you are referring to \n\n/* Error return codes */\n r   hX   Apizar  h
X   132r  hX   CONTr  hX   INFORMr  h]r  X	   structurer  ahNuK}r  (hX   71r  h	X   #define SSH_OK 0 /* No error */\n #define SSH_ERROR -1 /* Error of some kind */\n #define SSH_AGAIN -2 /* The nonblocking call must be repeated */\n #define SSH_EOF -127 /* We have already a eof */r	  hX   Apizar
  h
X   131r  hX   POSr  hX   INFORMr
  h]r  X	   structurer  ahNuK}r  (hX   72r  h	X   tell me about sftp_openr  hX
   Programmerr  h
NhNhX
   ELICIT-INFORMr  h]r  X   basicr  ah]r  X	   sftp_openr  auK}r  (hX   73r  h	X'   can you give me an example of sftp_openr  hX
   Programmerr  h
NhNhX
   ELICIT-INFORMr  h]r  X   examplesr  ah]r   X	   sftp_openr!  auK}r"  (hX   74r#  h	Xo   sftp_file sftp_open\t(\tsftp_session \tsession,\nconst char * \tfile,\nint \taccesstype,\nmode_t \tmode \n)\n\nr$  hX   Apizar%  h
X   135r&  hX   POSr'  hX   INFORMr(  h]r)  X   basicr*  ah]r+  X	   sftp_openr,  auK}r-  (hX   74r.  h	X+   Description\nOpen a file on the server.\n\nr/  hX   Apizar0  h
X   137r1  hX   CONTr2  hX   INFORMr3  h]r4  X   basicr5  ah]r6  X	   sftp_openr7  auK}r8  (hX   74r9  h	X  Parameters\nsession: The sftp session handle.\nfile: The file to be opened.\naccesstype: Is one of O_RDONLY, O_WRONLY or O_RDWR which request opening the file read-only,write-only or read/write. Acesss may also be bitwise-or'd with one or more of the following: O_CREAT - If the file does not exist it will be created. O_EXCL - When used with O_CREAT, if the file already exists it is an error and the open will fail. O_TRUNC - If the file already exists it will be truncated.\nmode: Mode specifies the permissions to use if a new file is created. It is modified by the process's umask in the usual way: The permissions of the created file are (mode &amp; ~umask)\n\nr:  hX   Apizar;  h
X   138r<  hX   CONTr=  hX   INFORMr>  h]r?  (X
   functionalityr@  X   basicrA  eh]rB  X	   sftp_openrC  auK}rD  (hX   74rE  h	XK   Returns\nA sftp file handle, NULL on error with ssh and sftp error set.\n\nrF  hX   ApizarG  h
X   139rH  hX   CONTrI  hX   INFORMrJ  h]rK  (X
   functionalityrL  X   basicrM  eh]rN  X	   sftp_openrO  auK}rP  (hX   74rQ  h	XO   References ssh_buffer_free(), ssh_buffer_new(), and ssh_string_from_char().\n\nrR  hX   ApizarS  h
X   140rT  hX   CONTrU  hX   INFORMrV  h]rW  X	   structurerX  ah]rY  X	   sftp_openrZ  auK}r[  (hX   74r\  h	X   See also\nsftp_get_error()r]  hX   Apizar^  h
X   141r_  hX   CONTr`  hX   INFORMra  hNh]rb  X	   sftp_openrc  auK}rd  (hX   75re  h	X   Here is an example:\n\nrf  hX   Apizarg  h
X   136rh  hX   POSri  hX   INFORMrj  h]rk  X   examplesrl  ah]rm  X	   sftp_openrn  auK}ro  (hX   75rp  h	X   sftp_file file;\nsftp_session sftp;\nint access_type = O_WRONLY | O_CREAT | O_TRUNC;\n\nfile = sftp_open(sftp, "helloworld/helloworld.txt", access_type, S_IRWXU);rq  hX   Apizarr  h
X   143rs  hX   CONTrt  hX   INFORMru  h]rv  X   examplesrw  ah]rx  X	   sftp_openry  auuuK}rz  (hhh}r{  (K }r|  (hhh	X   Hello! r}  hX   Apizar~  h
NhNhX   BE-POSITIVEr  hNhNuK}r  (hhh	XB   I am Apiza, an automated virtual assistant supervised by a human. r  hX   Apizar  h
hhX   CONTr  hX   INFORMr  hNhNuK}r  (hhh	X$   I look forward to helping you today!r  hX   Apizar  h
hhX   CONTr  hX   BE-POSITIVEr  hNhNuK}r  (hhh	X	   Hi Apiza,r  hX
   Programmerr  h
hhX   POSr  hX   BE-POSITIVEr  hNhNuK}r  (hhh	X1    can you explain how to create a new ssh session?r  hX
   Programmerr  h
NhNhX   ELICIT-OFFER-OR-SUGGESTIONr  h]r  X   patternsr  ah]r  X   ssh_sessionr  auK}r  (hh+h	X   Sure! r  hX   Apizar  h
h5hX   POSr  hX   OFFERr  hNhNuK}r  (hh+h	Xi   It looks like the best way to create a new ssh session is with \n\nssh_session ssh_new\t(\tvoid \t\t)\n\nr  hX   Apizar  h
h5hX   POSr  hX   SUGGESTr  h]r  (X   patternsr  X   basicr  eh]r  (X   ssh_sessionr  X   ssh_newr  euK}r  (hh+h	X&   Description\nCreate a new ssh session.r  hX   Apizar  h
hFhX   CONTr  hX   INFORMr  h]r  X   basicr  ah]r  X   ssh_newr  auK}r  (hh5h	X1   is that a void method or does it return anything?r  hX
   Programmerr  h
hQhX   FOLr  hX
   ELICIT-INFORMr  h]r  X   basicr  ah]r  X   ssh_newr  auK	}r  (hh<h	X)   This method returns an "ssh_session":\n\nr  hX   Apizar  h
hXhX   POSr  hX   INFORMr  h]r  X   basicr  ah]r  X   ssh_newr  auK
}r  (hh<h	X2   Returns\nA new ssh_session pointer, NULL on error.r  hX   Apizar  h
hchX   CONTr  hX   INFORMr  h]r  (X
   functionalityr  X   basicr  eh]r  X   ssh_newr  auK}r  (hhFh	XB   how do I connect to localhost once I've created a new ssh_session?r  hX
   Programmerr  h
NhNhX   ELICIT-OFFER-OR-SUGGESTIONr  h]r  X   patternsr  ahNuK}r  (hhQh	X/   This looks like the best method to connect:\n\nr  hX   Apizar  h
X   11r  hX   POSr  hX   SUGGESTr  h]r  X   patternsr  ah]r  X   ssh_connectr  auK
}r  (hhQh	X.   int ssh_connect\t(\tssh_session session\t)\n\nr  hX   Apizar  h
X   12r  hX   CONTr  hX   INFORMr  h]r  X   basicr  ah]r  X   ssh_connectr  auK}r  (hhQh	X,   Description \nConnect to the ssh server.\n\nr  hX   Apizar  h
X   13r  hX   CONTr  hX   INFORMr  h]r  X   basicr  ah]r  X   ssh_connectr  auK}r  (hhQh	X5   Parameters \nsession: The ssh session to connect.\n\nr  hX   Apizar  h
X   14r  hX   CONTr  hX   INFORMr  h]r  X   basicr  ah]r  X   ssh_connectr  auK}r  (hhQh	X   Returns \nSSH_OK on success, SSH_ERROR on error. \nSSH_AGAIN, if the session is in nonblocking mode, and call must be done again.r  hX   Apizar  h
X   15r  hX   CONTr  hX   INFORMr  h]r   X
   functionalityr  ah]r  X   ssh_connectr  auK}r  (hhXh	XH   The only method I found involving "localhost" is ssh_options_getopt:\n\nr  hX   Apizar  h
X   11r  hX   PARTr  hX   INFORMr	  h]r
  (X	   structurer  X   patternsr  eh]r
  X   ssh_options_getoptr  auK}r  (hhXh	X[   int ssh_options_getopt\t(\tssh_session \tsession,\nint * \targcptr,\nchar ** \targv \n)\n\nr  hX   Apizar  h
X   17r  hX   CONTr  hX   INFORMr  h]r  X   basicr  ah]r  X   ssh_options_getoptr  auK}r  (hhXh	X  Description\nParse command line arguments.\nThis is a helper for your application to generate the appropriate options from the command line arguments.\nThe argv array and argc value are changed so that the parsed arguments wont appear anymore in them.\nThe single arguments (without switches) are not parsed. thus, myssh -l user localhost\nThe command wont set the hostname value of options to localhost.r  hX   Apizar  h
X   18r  hX   CONTr  hX   INFORMr  h]r  (X
   functionalityr   X   purposer!  X   examplesr"  eh]r#  X   ssh_options_getoptr$  auK}r%  (hhch	Xf   for the ssh_connect() method, shouldn't I provide a username and password to connect to an ssh server?r&  hX
   Programmerr'  h
X   13r(  hX   FOLr)  hX   ELICIT-OFFER-OR-SUGGESTIONr*  h]r+  (X
   directivesr,  X   patternsr-  eh]r.  X   ssh_connectr/  auK}r0  (hX   10r1  h	XU   The ssh_connect method doesn't seem to mention a username field or a password field. r2  hX   Apizar3  h
X   20r4  hX   PARTr5  hX   INFORMr6  h]r7  (X
   functionalityr8  X
   directivesr9  eh]r:  X   ssh_connectr;  auK}r<  (hX   10r=  h	X:   The function ssh_userauth_password may be appropriate:\n\nr>  hX   Apizar?  h
X   21r@  hX   FOLrA  hX   SUGGESTrB  h]rC  X   patternsrD  ah]rE  X   ssh_userauth_passwordrF  auK}rG  (hX   10rH  h	Xo   int ssh_userauth_password\t(\tssh_session \tsession,\nconst char * \tusername,\nconst char * \tpassword \n)\n\nrI  hX   ApizarJ  h
X   22rK  hX   CONTrL  hX   INFORMrM  h]rN  X   basicrO  ah]rP  X   ssh_userauth_passwordrQ  auK}rR  (hX   10rS  h	X  Description\nTry to authenticate by password.\nThis authentication method is normally disabled on SSHv2 server. You should use keyboard-interactive mode.\nThe 'password' value MUST be encoded UTF-8. It is up to the server how to interpret the password and validate it against the password database. However, if you read the password in some other encoding, you MUST convert the password to UTF-8.rT  hX   ApizarU  h
X   23rV  hX   CONTrW  hX   INFORMrX  h]rY  (X
   functionalityrZ  X
   directivesr[  X   environmentr\  eh]r]  X   ssh_userauth_passwordr^  auK}r_  (hX   11r`  h	Xj   for the ssh_connect() method, can you tell me what the int values are for SSH_OK, SSH_ERROR and SSH_AGAIN?ra  hX
   Programmerrb  h
X   13rc  hX   FOLrd  hX
   ELICIT-INFORMre  h]rf  X   basicrg  ah]rh  X   ssh_connectri  auK}rj  (hX   12rk  h	X   Sure rl  hX   Apizarm  h
X   25rn  hX   POSro  hX   OFFERrp  hNhNuK}rq  (hX   12rr  h	X5   it looks like these are the "Error return codes":\n\nrs  hX   Apizart  h
X   25ru  hX   POSrv  hX   INFORMrw  h]rx  X	   structurery  ah]rz  X   ssh_connectr{  auK}r|  (hX   12r}  h	X   /* Error return codes */\n #define SSH_OK 0 /* No error */\n #define SSH_ERROR -1 /* Error of some kind */\n #define SSH_AGAIN -2 /* The nonblocking call must be repeated */\n #define SSH_EOF -127 /* We have already a eof */r~  hX   Apizar  h
X   27r  hX   CONTr  hX   INFORMr  h]r  (X	   structurer  X   basicr  eh]r  X   ssh_connectr  auK}r  (hX   13r  h	X   and for the ssh_userauth_password() method, does that only tell you if the provided authentication is valid or will it connect to the server as well?r  hX
   Programmerr  h
X   23r  hX   FOLr  hX
   ELICIT-INFORMr  h]r  X
   functionalityr  ah]r  X   ssh_userauth_passwordr  auK}r  (hX   14r  h	XL   You must be connected to the server before using ssh_userauth_password. \n\nr  hX   Apizar  h
X   29r  hX   POSr  hX   SUGGESTr  h]r  X
   directivesr  ah]r  X   ssh_userauth_passwordr  auK}r  (hX   14r  h	XZ  ssh_userauth_password returns\n\nSSH_AUTH_ERROR: A serious error happened.\nSSH_AUTH_DENIED: Authentication failed: use another method\nSSH_AUTH_PARTIAL: You've been partially authenticated, you still have to use another method\nSSH_AUTH_SUCCESS: Authentication success\nSSH_AUTH_AGAIN: In nonblocking mode, you've got to call this again later.\nr  hX   Apizar  h
X   30r  hX   CONTr  hX   INFORMr  h]r  X
   functionalityr  ah]r  X   ssh_userauth_passwordr  auK }r  (hX   14r  h	X   Note\nMost server implementations do not permit changing the username during authentication. The username should only be set with ssh_options_set() only before you connect to the server.r  hX   Apizar  h
X   31r  hX   CONTr  hX   INFORMr  h]r  (X
   functionalityr  X
   directivesr  eh]r  X   ssh_userauth_passwordr  auK!}r  (hX   15r  h	X/   can you give me the int values for those codes?r  hX
   Programmerr  h
X   31r  hX   FOLr  hX
   ELICIT-INFORMr  h]r  X   basicr  ah]r  X   ssh_userauth_passwordr  auK"}r  (hX   16r  h	X	   Sure!\n\nr  hX   Apizar  h
X   33r  hX   POSr  hX   OFFERr  hNhNuK#}r  (hX   16r  h	X   enum ssh_auth_e {\n SSH_AUTH_SUCCESS=0,\n SSH_AUTH_DENIED,\n SSH_AUTH_PARTIAL,\n SSH_AUTH_INFO,\n SSH_AUTH_AGAIN,\n SSH_AUTH_ERROR=-1\n };r  hX   Apizar  h
X   34r  hX   CONTr  hX   INFORMr  h]r  X   basicr  ah]r  X   ssh_userauth_passwordr  auK$}r  (hX   17r  h	Xd   can you tell me more about how to connect to localhost after an ssh_session is successfully created?r  hX
   Programmerr  h
NhNhX   ELICIT-OFFER-OR-SUGGESTIONr  h]r  X   patternsr  ahNuK%}r  (hX   18r  h	X   Sure thing, r  hX   Apizar  h
X   36r  hX   POSr  hX   OFFERr  hNhNuK&}r  (hX   18r  h	XI   I was able to find one example that goes from ssh_new to ssh_connect:\n\nr  hX   Apizar  h
X   36r  hX   POSr  hX   INFORMr  h]r  X   examplesr  ah]r  (X   ssh_newr  X   ssh_connectr  euK'}r  (hX   18r  h	X   // Open session and set options\n my_ssh_session = ssh_new();\n if (my_ssh_session == NULL)\n exit(-1);\n ssh_options_set(my_ssh_session, SSH_OPTIONS_HOST, "localhost");\n // Connect to server\n rc = ssh_connect(my_ssh_session);r  hX   Apizar  h
X   38r  hX   CONTr  hX   INFORMr  h]r  X   examplesr  ah]r  (X   ssh_newr  X   ssh_options_setr  X   ssh_connectr  euK(}r  (hX   19r  h	X
   ok great. r  hX
   Programmerr  h
X   39r  hX   POSr  hX   ASSESSr  hNhNuK)}r   (hX   19r  h	X5   What method should I use to authenticate the server? r  hX
   Programmerr  h
NhNhX   ELICIT-OFFER-OR-SUGGESTIONr  h]r  X   patternsr  ahNuK*}r  (hX   19r  h	XJ   Is it different from ssh_userauth_password() which authenticates the user?r	  hX
   Programmerr
  h
X   42r  hX   CONTr  hX
   ELICIT-INFORMr
  h]r  X
   functionalityr  ah]r  X   ssh_userauth_passwordr  auK+}r  (hX   20r  h	X!   Hmm, I am not certain about that.r  hX   Apizar  h
X   41r  hX   UNCr  hX   COMMENT-ABOUT-UNDERSTANDINGr  hNhNuK,}r  (hX   20r  h	X(    I may still be able to find an answer. r  hX   Apizar  h
X   43r  hX   FOLr  hX   OFFERr  hNhNuK-}r   (hX   20r!  h	X   Can you elaborate?r"  hX   Apizar#  h
X   42r$  hX   FOLr%  hX
   ELICIT-INFORMr&  hNhNuK.}r'  (hX   21r(  h	X6   what method should be used to authenticate the server?r)  hX
   Programmerr*  h
X   45r+  hX   FOLr,  hX   ELICIT-OFFER-OR-SUGGESTIONr-  h]r.  X   patternsr/  ahNuK/}r0  (hX   22r1  h	X9   I couldn\'t find a function to "authenticate the server" r2  hX   Apizar3  h
X   46r4  hX   NEGr5  hX   INFORMr6  h]r7  X   patternsr8  ahNuK0}r9  (hX   22r:  h	X[   but I found ones to "Check if the server is known" and "verify [a hash of the public key]".r;  hX   Apizar<  h
X   47r=  hX   CONTr>  hX   INFORMr?  h]r@  X   patternsrA  ahNuK1}rB  (hX   22rC  h	X!   Would either of those be helpful?rD  hX   ApizarE  h
X   48rF  hX   FOLrG  hX
   ELICIT-INFORMrH  hNhNuK2}rI  (hX   23rJ  h	X   nevermind, rK  hX
   ProgrammerrL  h
X   49rM  hX   NEGrN  hX   ASSESSrO  hNhNuK3}rP  (hX   23rQ  h	X9   is it possible to authenticate a user without a username?rR  hX
   ProgrammerrS  h
NhNhX
   ELICIT-INFORMrT  h]rU  (X
   directivesrV  X   patternsrW  ehNuK4}rX  (hX   24rY  h	XH   also, what does a return code of 1 signify from ssh_userauth_password()?rZ  hX
   Programmerr[  h
NhNhX
   ELICIT-INFORMr\  h]r]  X
   functionalityr^  ah]r_  X   ssh_userauth_passwordr`  auK5}ra  (hX   25rb  h	X_   I found the following "userauth" methods that don\'t need a "username" or "user" parameter:\n\nrc  hX   Apizard  h
X   51re  hX   PARTrf  hX   INFORMrg  h]rh  (X
   functionalityri  X	   structurerj  ehNuK6}rk  (hX   25rl  h	X  int ssh_userauth_gssapi\t(\tssh_session \tsession\t)\n\nconst char* ssh_userauth_kbdint_getanswer\t(\tssh_session \tsession,\nunsigned int \ti \n)\n\nconst char* ssh_userauth_kbdint_getinstruction\t(\tssh_session \tsession\t)\n\nconst char* ssh_userauth_kbdint_getname\t(\tssh_session \tsession\t)\n\nint ssh_userauth_kbdint_getnanswers\t(\tssh_session \tsession\t)\n\nint ssh_userauth_kbdint_getnprompts\t(\tssh_session \tsession\t)\n\nconst char* ssh_userauth_kbdint_getprompt\t(\tssh_session \tsession,\nunsigned int \ti,\nchar * \techo \n)\n\nint ssh_userauth_kbdint_setanswer\t(\tssh_session \tsession,\nunsigned int \ti,\nconst char * \tanswer \n)\n\nrm  hX   Apizarn  h
X   53ro  hX   CONTrp  hX   INFORMrq  h]rr  (X	   structurers  X   basicrt  ehNuK7}ru  (hX   25rv  h	X/   Would you like to know more about any of these?rw  hX   Apizarx  h
X   54ry  hX   FOLrz  hX
   ELICIT-INFORMr{  hNhNuK8}r|  (hX   26r}  h	X%   A 1 denotes the enum SSH_AUTH_DENIED.r~  hX   Apizar  h
X   52r  hX   POSr  hX   INFORMr  h]r  X   basicr  ah]r  X   ssh_userauth_passwordr  auK9}r  (hX   27r  h	X   no, r  hX
   Programmerr  h
X   55r  hX   NEGr  hX   ASSESSr  hNhNuK:}r  (hX   27r  h	XA   can you show me an example of ssh_userauth_password() being used?r  hX
   Programmerr  h
NhNhX
   ELICIT-INFORMr  h]r  X   examplesr  ah]r  X   ssh_userauth_passwordr  auK;}r  (hX   28r  h	X   Sure! r  hX   Apizar  h
X   58r  hX   POSr  hX   OFFERr  hNhNuK<}r  (hX   28r  h	X"   I found the following example:\n\nr  hX   Apizar  h
X   58r  hX   POSr  hX   INFORMr  h]r  X   examplesr  ah]r  X   ssh_userauth_passwordr  auK=}r  (hX   28r  h	XF  int rc;\nchar * password;\nssh_session my_ssh_session;\n...\nrc = ssh_userauth_password(my_ssh_session, NULL, password);\nif (rc != SSH_AUTH_SUCCESS)\n{\n fprintf(stderr, "Error authenticating with password: %s\\n",\n ssh_get_error(my_ssh_session));\n ssh_disconnect(my_ssh_session);\n ssh_free(my_ssh_session);\n exit(-1);\n}r  hX   Apizar  h
X   60r  hX   CONTr  hX   INFORMr  h]r  X   examplesr  ah]r  X   ssh_userauth_passwordr  auK>}r  (hX   29r  h	X   great, that works. r  hX
   Programmerr  h
X   61r  hX   POSr  hX   ASSESSr  hNh]r  X   ssh_userauth_passwordr  auK?}r  (hX   29r  h	X3   And do ssh_disconnect and ssh_free return anything?r  hX
   Programmerr  h
X   61r  hX   FOLr  hX
   ELICIT-INFORMr  h]r  X   basicr  ah]r  (X   ssh_disconnectr  X   ssh_freer  euK@}r  (hX   30r  h	X   I'm glad to hear that!\n\nr  hX   Apizar  h
X   62r  hX   POSr  hX   BE-POSITIVEr  hNhNuKA}r  (hX   30r  h	X-   ssh_disconnect and ssh_free both return void.r  hX   Apizar  h
X   63r  hX   POSr  hX   INFORMr  h]r  X   basicr  ah]r  (X   ssh_disconnectr  X   ssh_freer  euKB}r  (hX   31r  h	X   Ok, r  hX
   Programmerr  h
X   65r  hX   POSr  hX   ASSESSr  hNhNuKC}r  (hX   31r  h	XI   how would I create and open a new ssh channel in an existing ssh session?r  hX
   Programmerr  h
NhNhX   ELICIT-OFFER-OR-SUGGESTIONr  h]r  X   patternsr  ah]r  (X   ssh_channelr  X   ssh_sessionr  euKD}r  (hX   32r  h	Xo   It looks like ssh_channel ssh_channel_new\t(\tssh_session \tsession\t) will help create a new ssh channel. \n\nr  hX   Apizar  h
X   67r  hX   POSr  hX   SUGGESTr  h]r  (X   patternsr  X   basicr  eh]r  (X   ssh_channelr  X   ssh_channel_newr  euKE}r  (hX   32r  h	X(   Description\nAllocate a new channel.\n\nr  hX   Apizar  h
X   68r  hX   CONTr  hX   INFORMr   h]r  X   basicr  ah]r  X   ssh_channel_newr  auKF}r  (hX   32r  h	X3   There are a few methods to open an ssh channel:\n\nr  hX   Apizar  h
X   67r	  hX   PARTr
  hX   INFORMr  h]r  (X	   structurer
  X   patternsr  eh]r  X   ssh_channelr  auKG}r  (hX   32r  h	X"  int ssh_channel_open_auth_agent\t(\tssh_channel \tchannel\t)\n\nint ssh_channel_open_session\t(\tssh_channel \tchannel\t)\n\nint ssh_channel_open_forward\t(\tssh_channel \tchannel,\nconst char * \tremotehost,\nint \tremoteport,\nconst char * \tsourcehost,\nint \tlocalport \n)\n\nint ssh_channel_open_reverse_forward\t(\tssh_channel \tchannel,\nconst char * \tremotehost,\nint \tremoteport,\nconst char * \tsourcehost,\nint \tlocalport \n)\n\nint ssh_channel_open_x11\t(\tssh_channel \tchannel,\nconst char * \torig_addr,\nint \torig_port \n)\n\nr  hX   Apizar  h
X   70r  hX   CONTr  hX   INFORMr  h]r  (X	   structurer  X   basicr  eh]r  X   ssh_channelr  auKH}r  (hX   32r  h	X/   Would you like to hear more about one of these?r  hX   Apizar   h
X   71r!  hX   FOLr"  hX
   ELICIT-INFORMr#  hNhNuKI}r$  (hX   33r%  h	X.   can you tell me more about ssh_channel_new(). r&  hX
   Programmerr'  h
X   68r(  hX   FOLr)  hX
   ELICIT-INFORMr*  h]r+  X   basicr,  ah]r-  X   ssh_channel_newr.  auKJ}r/  (hX   33r0  h	X*   how do I know if it executed successfully?r1  hX
   Programmerr2  h
X   73r3  hX   FOLr4  hX
   ELICIT-INFORMr5  h]r6  X
   functionalityr7  ah]r8  X   ssh_channel_newr9  auKK}r:  (hX   34r;  h	X	   Sure!\n\nr<  hX   Apizar=  h
X   73r>  hX   POSr?  hX   OFFERr@  hNhNuKL}rA  (hX   34rB  h	X<   ssh_channel ssh_channel_new\t(\tssh_session \tsession\t)\n\nrC  hX   ApizarD  h
X   75rE  hX   CONTrF  hX   INFORMrG  h]rH  X   basicrI  ah]rJ  X   ssh_channel_newrK  auKM}rL  (hX   34rM  h	X(   Description\nAllocate a new channel.\n\nrN  hX   ApizarO  h
X   76rP  hX   CONTrQ  hX   INFORMrR  h]rS  X   basicrT  ah]rU  X   ssh_channel_newrV  auKN}rW  (hX   34rX  h	X0   Parameters\nsession: The ssh session to use.\n\nrY  hX   ApizarZ  h
X   77r[  hX   CONTr\  hX   INFORMr]  h]r^  X   basicr_  ah]r`  X   ssh_channel_newra  auKO}rb  (hX   34rc  h	XC   Returns\nA pointer to a newly allocated channel, NULL on error.\n\nrd  hX   Apizare  h
X   78rf  hX   CONTrg  hX   INFORMrh  h]ri  X
   functionalityrj  ah]rk  X   ssh_channel_newrl  auKP}rm  (hX   34rn  h	X3   References ssh_buffer_free(), and ssh_buffer_new().ro  hX   Apizarp  h
X   79rq  hX   CONTrr  hX   INFORMrs  h]rt  X	   structureru  ah]rv  X   ssh_channel_newrw  auKQ}rx  (hX   35ry  h	X
   ok great, rz  hX
   Programmerr{  h
X   80r|  hX   POSr}  hX   ASSESSr~  hNhNuKR}r  (hX   35r  h	XY   and whats the difference between ssh_channel_open_auth_agent and ssh_channel_open_sessionr  hX
   Programmerr  h
X   71r  hX   FOLr  hX
   ELICIT-INFORMr  h]r  (X   purposer  X   patternsr  X
   functionalityr  eh]r  (X   ssh_channel_open_auth_agentr  X   ssh_channel_open_sessionr  euKS}r  (hX   36r  h	XL  ssh_channel_open_auth_agent:\n\nDescription\nOpen an agent authentication forwarding channel.\nThis type of channel can be opened by a server towards a client in order to provide SSH-Agent services to the server-side process. This channel can only be opened if the client claimed support by sending a channel request beforehand.\n\nr  hX   Apizar  h
X   82r  hX   POSr  hX   INFORMr  h]r  (X
   functionalityr  X
   directivesr  eh]r  X   ssh_channel_open_auth_agentr  auKT}r  (hX   36r  h	Xj   ssh_channel_open_session:\n\nDescription\nOpen a session channel (suited for a shell, not TCP forwarding).r  hX   Apizar  h
X   83r  hX   CONTr  hX   INFORMr  h]r  (X
   functionalityr  X
   directivesr  eh]r  X   ssh_channel_open_sessionr  auKU}r  (hX   37r  h	X?   ssh_channel_open_session seems to be the more popular function.r  hX   Apizar  h
X   84r  hX   FOLr  hX   INFORMr  h]r  X   qualityr  ah]r  X   ssh_channel_open_sessionr  auKV}r  (hX   38r  h	X;   and what are the return codes for ssh_channel_open_session?r  hX
   Programmerr  h
X   71r  hX   FOLr  hX
   ELICIT-INFORMr  h]r  X
   functionalityr  ah]r  X   ssh_channel_open_sessionr  auKW}r  (hX   39r  h	X{   Returns\nSSH_OK on success, SSH_ERROR if an error occurred, SSH_AGAIN if in nonblocking mode and call has to be done again.r  hX   Apizar  h
X   86r  hX   POSr  hX   INFORMr  h]r  X
   functionalityr  ah]r  X   ssh_channel_open_sessionr  auKX}r  (hX   40r  h	X   I'm getting an SSH_ERROR. r  hX
   Programmerr  h
X   86r  hX   PARTr  hX   INFORMr  h]r  X
   functionalityr  ah]r  X   ssh_channel_open_sessionr  auKY}r  (hX   40r  h	X-   Can you show me an example of how it's used? r  hX
   Programmerr  h
X   88r  hX   FOLr  hX
   ELICIT-INFORMr  h]r  X   examplesr  ah]r  X   ssh_channel_open_sessionr  auKZ}r  (hX   40r  h	X    Any parameters I need to set up?r  hX
   Programmerr  h
X   88r  hX   FOLr  hX   ELICIT-OFFER-OR-SUGGESTIONr  h]r  X   patternsr  ah]r  X   ssh_channel_open_sessionr  auK[}r  (hX   41r  h	X   Sure! r  hX   Apizar  h
X   89r  hX   POSr  hX   OFFERr  hNhNuK\}r  (hX   41r  h	X"   I found the following example:\n\nr  hX   Apizar  h
X   89r  hX   POSr  hX   INFORMr  h]r  X   examplesr  ah]r  X   ssh_channel_open_sessionr  auK]}r  (hX   41r  h	X   int rc;\nssh_channel channel;\n...\nrc = ssh_channel_open_session(channel);\nif (rc != SSH_OK)\n{\n ssh_channel_free(channel);\n return rc;\n}r  hX   Apizar  h
X   92r  hX   CONTr  hX   INFORMr  h]r   X   examplesr  ah]r  X   ssh_channel_open_sessionr  auK^}r  (hX   42r  h	X   great, r  hX
   Programmerr  h
X   93r  hX   POSr	  hX   ASSESSr
  hNhNuK_}r  (hX   42r  h	X7   and how would I execute a command on an opened channel?r
  hX
   Programmerr  h
NhNhX   ELICIT-OFFER-OR-SUGGESTIONr  h]r  X   patternsr  ah]r  X   ssh_channelr  auK`}r  (hX   43r  h	X   This method should work:\n\nr  hX   Apizar  h
X   95r  hX   POSr  hX   SUGGESTr  h]r  X   patternsr  ah]r  X   ssh_channel_request_execr  auKa}r  (hX   43r   h	XS   int ssh_channel_request_exec\t(\tssh_channel \tchannel,\nconst char * \tcmd \n)\n\nr!  hX   Apizar"  h
X   96r#  hX   CONTr$  hX   INFORMr%  h]r&  X   basicr'  ah]r(  X   ssh_channel_request_execr)  auKb}r*  (hX   43r+  h	Xi   Description\nRun a shell command without an interactive shell.\nThis is similar to \'sh -c command\'.\n\nr,  hX   Apizar-  h
X   97r.  hX   CONTr/  hX   INFORMr0  h]r1  X
   functionalityr2  ah]r3  X   ssh_channel_request_execr4  auKc}r5  (hX   43r6  h	X   Parameters\nchannel: The channel to execute the command.\ncmd: The command to execute (e.g. "ls ~/ -al | grep -i reports").\n\nr7  hX   Apizar8  h
X   98r9  hX   CONTr:  hX   INFORMr;  h]r<  (X
   functionalityr=  X   examplesr>  eh]r?  X   ssh_channel_request_execr@  auKd}rA  (hX   43rB  h	X   Returns\nSSH_OK on success, SSH_ERROR if an error occurred, SSH_AGAIN if in nonblocking mode and call has to be done again.\n\nrC  hX   ApizarD  h
X   99rE  hX   CONTrF  hX   INFORMrG  h]rH  X
   functionalityrI  ah]rJ  X   ssh_channel_request_execrK  auKe}rL  (hX   43rM  h	X   Example:\n\nrc = channel_request_exec(channel, "ps aux");\nif (rc &gt; 0) {\n return -1;\n}\nwhile ((rc = channel_read(channel, buffer, sizeof(buffer), 0)) &gt; 0) {\n if (fwrite(buffer, 1, rc, stdout) != (unsigned int) rc) {\n return -1;\n }\n}rN  hX   ApizarO  h
X   100rP  hX   CONTrQ  hX   INFORMrR  h]rS  X   examplesrT  ah]rU  X   ssh_channel_request_execrV  auKf}rW  (hX   44rX  h	X#   what is buffer in that code sample?rY  hX
   ProgrammerrZ  h
X   101r[  hX   FOLr\  hX
   ELICIT-INFORMr]  h]r^  X   basicr_  ah]r`  X   ssh_channel_readra  auKg}rb  (hX   45rc  h	X   just a char *?rd  hX
   Programmerre  h
X   102rf  hX   CONTrg  hX
   ELICIT-INFORMrh  h]ri  X   basicrj  ah]rk  X   ssh_channel_readrl  auKh}rm  (hX   46rn  h	X<   The buffer variable used in ssh_channel_read is a void *\n\nro  hX   Apizarp  h
X   102rq  hX   POSrr  hX   INFORMrs  h]rt  X   basicru  ah]rv  X   ssh_channel_readrw  auKi}rx  (hX   46ry  h	Xk   int ssh_channel_read\t(\tssh_channel \tchannel,\nvoid * \tdest,\nuint32_t \tcount,\nint \tis_stderr \n)\n\nrz  hX   Apizar{  h
X   104r|  hX   CONTr}  hX   INFORMr~  h]r  X   basicr  ah]r  X   ssh_channel_readr  auKj}r  (hX   46r  h	X   Parameters\nchannel: The channel to read from.\ndest: The destination buffer which will get the data.\ncount: The count of bytes to be read.\nis_stderr: A boolean value to mark reading from the stderr flow.r  hX   Apizar  h
X   105r  hX   CONTr  hX   INFORMr  h]r  X
   functionalityr  ah]r  X   ssh_channel_readr  auKk}r  (hX   47r  h	X   how do I shut down a channel?r  hX
   Programmerr  h
NhNhX   ELICIT-OFFER-OR-SUGGESTIONr  h]r  X   patternsr  ahNuKl}r  (hX   48r  h	X   specifically by sending an eof?r  hX
   Programmerr  h
X   107r  hX   FOLr  hX   ELICIT-OFFER-OR-SUGGESTIONr  h]r  X   patternsr  ahNuKm}r  (hX   49r  h	X"   One of those methods may help:\n\nr  hX   Apizar  h
X   107r  hX   POSr  hX   SUGGESTr  h]r  X   patternsr  ah]r  (X   ssh_channel_closer  X   ssh_channel_freer  euKn}r  (hX   49r  h	X4   int ssh_channel_close\t(\tssh_channel \tchannel\t)\nr  hX   Apizar  h
X   109r  hX   CONTr  hX   INFORMr  h]r  X   basicr  ah]r  X   ssh_channel_closer  auKo}r  (hX   49r  h	X   Description\nClose a channel.\nThis sends an end of file and then closes the channel. You won't be able to recover any data the server was going to send or was in buffers.\n\n\nr  hX   Apizar  h
X   110r  hX   CONTr  hX   INFORMr  h]r  X
   functionalityr  ah]r  X   ssh_channel_closer  auKp}r  (hX   49r  h	X4   void ssh_channel_free\t(\tssh_channel \tchannel\t)\nr  hX   Apizar  h
X   111r  hX   CONTr  hX   INFORMr  h]r  X   basicr  ah]r  X   ssh_channel_freer  auKq}r  (hX   49r  h	X&   Description\nClose and free a channel.r  hX   Apizar  h
X   112r  hX   CONTr  hX   INFORMr  h]r  X   basicr  ah]r  X   ssh_channel_freer  auKr}r  (hX   50r  h	XQ   To send an eof, you may use int ssh_channel_send_eof\t(\tssh_channel \tchannel\t)r  hX   Apizar  h
X   108r  hX   POSr  hX   SUGGESTr  h]r  (X   patternsr  X   basicr  eh]r  X   ssh_channel_send_eofr  auKs}r  (hX   51r  h	X-   does ssh_channel_close also free the channel?r  hX
   Programmerr  h
X   110r  hX   FOLr  hX
   ELICIT-INFORMr  h]r  X
   functionalityr  ah]r  X   ssh_channel_closer  auKt}r  (hX   52r  h	X+   ssh_channel_close only closes the channel. r  hX   Apizar  h
X   115r  hX   POSr  hX   INFORMr  h]r  X
   functionalityr  ah]r  X   ssh_channel_closer  auKu}r  (hX   52r  h	X.   ssh_channel_free closes and frees the channel.r  hX   Apizar  h
X   116r  hX   FOLr  hX   INFORMr  h]r  X
   functionalityr   ah]r  X   ssh_channel_freer  auKv}r  (hX   53r  h	X   nevermind I figured it outr  hX
   Programmerr  h
X   115r  hX   NEGr  hX   INFORMr	  hNhNuKw}r
  (hX   54r  h	X   I am glad to hear it!r  hX   Apizar
  h
X   118r  hX   POSr  hX   BE-POSITIVEr  hNhNuKx}r  (hX   55r  h	X>   how do I create a new sftp_session on an existing ssh_session?r  hX
   Programmerr  h
NhNhX   ELICIT-OFFER-OR-SUGGESTIONr  h]r  X   patternsr  ah]r  (X   sftp_sessionr  X   ssh_sessionr  euKy}r  (hX   56r  h	X6   sftp_session sftp_new\t(\tssh_session \tsession\t)\n\nr  hX   Apizar  h
X   120r  hX   POSr   hX   INFORMr!  h]r"  X   basicr#  ah]r$  (X   sftp_sessionr%  X   sftp_newr&  euKz}r'  (hX   56r(  h	X*   Description\nStart a new sftp session.\n\nr)  hX   Apizar*  h
X   121r+  hX   CONTr,  hX   INFORMr-  h]r.  X   basicr/  ah]r0  X   sftp_newr1  auK{}r2  (hX   56r3  h	Xa   Parameters\nsession: The ssh session to use.\n\nReturns\nA new sftp session or NULL on error.\n\nr4  hX   Apizar5  h
X   122r6  hX   CONTr7  hX   INFORMr8  h]r9  X
   functionalityr:  ah]r;  X   sftp_newr<  auK|}r=  (hX   56r>  h	XU   References ssh_channel_free(), ssh_channel_new(), and ssh_channel_open_session().\n\nr?  hX   Apizar@  h
X   123rA  hX   CONTrB  hX   INFORMrC  h]rD  X	   structurerE  ah]rF  X   sftp_newrG  auK}}rH  (hX   56rI  h	X   See also\nsftp_free()rJ  hX   ApizarK  h
X   124rL  hX   CONTrM  hX   INFORMrN  hNh]rO  X	   sftp_freerP  auK~}rQ  (hX   57rR  h	X=   do I need to call any methods to initialize the sftp_session?rS  hX
   ProgrammerrT  h
NhNhX   ELICIT-OFFER-OR-SUGGESTIONrU  h]rV  X
   directivesrW  ah]rX  X   sftp_sessionrY  auK}rZ  (hX   58r[  h	X   It looks like you do. r\  hX   Apizar]  h
X   126r^  hX   POSr_  hX   SUGGESTr`  h]ra  X
   directivesrb  ah]rc  X   sftp_sessionrd  auK}re  (hX   58rf  h	X:   You can use\n\n int sftp_init\t(\tsftp_session \tsftp\t)\nrg  hX   Apizarh  h
X   127ri  hX   FOLrj  hX   SUGGESTrk  h]rl  (X   patternsrm  X   basicrn  eh]ro  X	   sftp_initrp  auK}rq  (hX   58rr  h	X:   Returns\n0 on success, &lt; 0 on error with ssh error set.rs  hX   Apizart  h
X   128ru  hX   CONTrv  hX   INFORMrw  h]rx  X
   functionalityry  ah]rz  X	   sftp_initr{  auuuK}r|  (hhh}r}  (K }r~  (hhh	X   create ssh_sessionr  hX
   Programmerr  h
NhNhX   ELICIT-OFFER-OR-SUGGESTIONr  h]r  X   patternsr  ah]r  X   ssh_sessionr  auK}r  (hhh	X   How do I create an ssh session?r  hX
   Programmerr  h
hhX   REPr  hX   OTHERr  h]r  X   patternsr  ah]r  X   ssh_sessionr  auK}r  (hh+h	X   How do I create an ssh session?r  hX
   Programmerr  h
hhX   REPr  hX   OTHERr  h]r  X   patternsr  ah]r  X   ssh_sessionr  auK}r  (hh5h	X   Hello! r  hX   Apizar  h
NhNhX   BE-POSITIVEr  hNhNuK}r  (hh5h	X   My name is Apiza!r  hX   Apizar  h
NhNhX   INFORMr  hNhNuK}r  (hh<h	X   Hir  hX
   Programmerr  h
h+hX   POSr  hX   BE-POSITIVEr  hNhNuK}r  (hhFh	X   How do I create an ssh sessionr  hX
   Programmerr  h
hhX   REPr  hX   ELICIT-OFFER-OR-SUGGESTIONr  h]r  X   patternsr  ah]r  X   ssh_sessionr  auK}r  (hhQh	X>   To create a new ssh session, use ssh_new with this signature: r  hX   Apizar  h
hFhX   POSr  hX   SUGGESTr  h]r  X   patternsr  ah]r  (X   ssh_sessionr  X   ssh_newr  euK}r  (hhQh	X   ssh_session ssh_new (void)r  hX   Apizar  h
hQhX   CONTr  hX   INFORMr  h]r  X   basicr  ah]r  X   ssh_newr  auK	}r  (hhXh	X3   How do I ensure a session was successfully created?r  hX
   Programmerr  h
hQhX   FOLr  hX
   ELICIT-INFORMr  h]r  X
   functionalityr  ah]r  (X   ssh_newr  X   ssh_sessionr  euK
}r  (hhch	X)   If an error occurs, null will be returnedr  hX   Apizar  h
hchX   POSr  hX   INFORMr  h]r  X
   functionalityr  ah]r  X   ssh_newr  auK}r  (hX   10r  h	X   expected expression before voidr  hX
   Programmerr  h
hQhX   FOLr  hX
   ELICIT-INFORMr  h]r  X
   functionalityr  ah]r  X   ssh_newr  auK}r  (hX   11r  h	X   I'm sorry, r  hX   Apizar  h
X   11r  hX   UNCr  hX   BE-POSITIVEr  hNhNuK
}r  (hX   11r  h	X(   I'm not sure what this is referring to. r  hX   Apizar  h
X   12r  hX   CONTr  hX   COMMENT-ABOUT-UNDERSTANDINGr  hNhNuK}r  (hX   11r  h	X    I can only answer API questions.r  hX   Apizar  h
X   13r  hX   FOLr  hX   INFORMr  hNhNuK}r  (hX   12r  h	X   Connect to localhostr  hX
   Programmerr  h
NhNhX   ELICIT-OFFER-OR-SUGGESTIONr  h]r  X   patternsr  ahNuK}r  (hX   13r  h	X   To connect, use ssh_connect r  hX   Apizar  h
X   15r  hX   POSr  hX   SUGGESTr   h]r  X   patternsr  ah]r  X   ssh_connectr  auK}r  (hX   13r  h	X:   with this signature: int ssh_connect (ssh_session session)r  hX   Apizar  h
X   16r	  hX   CONTr
  hX   INFORMr  h]r  X   basicr
  ah]r  X   ssh_connectr  auK}r  (hX   14r  h	X   authenticater  hX
   Programmerr  h
NhNhX   ELICIT-OFFER-OR-SUGGESTIONr  h]r  X   patternsr  ahNuK}r  (hX   15r  h	X   I'm sorry, r  hX   Apizar  h
X   18r  hX   PARTr  hX   BE-POSITIVEr  hNhNuK}r  (hX   15r  h	X*   there are several authentication methods. r   hX   Apizar!  h
X   19r"  hX   CONTr#  hX   INFORMr$  h]r%  X	   structurer&  ahNuK}r'  (hX   15r(  h	X   Would you like me to list them?r)  hX   Apizar*  h
X   20r+  hX   FOLr,  hX   ELICIT-OFFER-OR-SUGGESTIONr-  h]r.  X	   structurer/  ahNuK}r0  (hX   16r1  h	X   yesr2  hX
   Programmerr3  h
X   21r4  hX   POSr5  hX   SUGGESTr6  h]r7  X	   structurer8  ahNuK}r9  (hX   17r:  h	X   ssh_userauth_gssapi\nssh_userauth_kbdint\nssh_userauth_none\nssh_userauth_password\nssh_userauth_publickey\nssh_userauth_publickey_auto\nssh_userauth_try_publickeyr;  hX   Apizar<  h
X   18r=  hX   POSr>  hX   INFORMr?  h]r@  X	   structurerA  ahNuK}rB  (hX   18rC  h	X   ssh_userauth_passwordrD  hX
   ProgrammerrE  h
X   23rF  hX   FOLrG  hX
   ELICIT-INFORMrH  h]rI  X   basicrJ  ah]rK  X   ssh_userauth_passwordrL  auK}rM  (hX   19rN  h	Xx   This method's signature is: int ssh_userauth_password (ssh_session session, const char * username, const char *password)rO  hX   ApizarP  h
X   24rQ  hX   POSrR  hX   INFORMrS  h]rT  X   basicrU  ah]rV  X   ssh_userauth_passwordrW  auK}rX  (hX   20rY  h	X   get error messagerZ  hX
   Programmerr[  h
NhNhX   ELICIT-OFFER-OR-SUGGESTIONr\  h]r]  X   patternsr^  ahNuK}r_  (hX   21r`  h	X'   To get error message, use ssh_get_errorra  hX   Apizarb  h
X   26rc  hX   POSrd  hX   SUGGESTre  h]rf  X   patternsrg  ah]rh  X
   ssh_get_errorri  auK}rj  (hX   21rk  h	X?   with this signature: const char* ssh_get_error ( void * error )rl  hX   Apizarm  h
X   27rn  hX   CONTro  hX   INFORMrp  h]rq  X   basicrr  ah]rs  X
   ssh_get_errorrt  auK}ru  (hX   22rv  h	X   serverrw  hX
   Programmerrx  h
NhNhX
   ELICIT-INFORMry  h]rz  X   basicr{  ahNuK}r|  (hX   23r}  h	X   I'm sorry, r~  hX   Apizar  h
X   29r  hX   NEGr  hX   BE-POSITIVEr  hNhNuK}r  (hX   23r  h	X   I can only answer API questionsr  hX   Apizar  h
X   30r  hX   CONTr  hX   INFORMr  hNhNuK }r  (hX   24r  h	X   Set server addressr  hX
   Programmerr  h
X   29r  hX   REPr  hX   ELICIT-OFFER-OR-SUGGESTIONr  h]r  X   patternsr  ahNuK!}r  (hX   25r  h	X   ssh_connectr  hX
   Programmerr  h
NhNhX
   ELICIT-INFORMr  h]r  X   basicr  ah]r  X   ssh_connectr  auK"}r  (hX   26r  h	X@   The method's signature is: int ssh_connect (ssh_session session)r  hX   Apizar  h
X   33r  hX   POSr  hX   INFORMr  h]r  X   basicr  ah]r  X   ssh_connectr  auK#}r  (hX   27r  h	X   Check that host is knownr  hX
   Programmerr  h
NhNhX   ELICIT-OFFER-OR-SUGGESTIONr  h]r  X   patternsr  ahNuK$}r  (hX   28r  h	X   disconnect from serverr  hX
   Programmerr  h
NhNhX   ELICIT-OFFER-OR-SUGGESTIONr  h]r  X   patternsr  ahNuK%}r  (hX   29r  h	X   SSH Return codesr  hX
   Programmerr  h
NhNhX
   ELICIT-INFORMr  h]r  X	   structurer  ahNuK&}r  (hX   30r  h	X8   To check if the server is known, use ssh_is_server_knownr  hX   Apizar  h
X   35r  hX   POSr  hX   SUGGESTr  h]r  X   patternsr  ah]r  X   ssh_is_server_knownr  auK'}r  (hX   30r  h	X@    with signature: int ssh_is_server_known ( ssh_session session )r  hX   Apizar  h
X   38r  hX   CONTr  hX   INFORMr  h]r  X   basicr  ah]r  X   ssh_is_server_knownr  auK(}r  (hX   31r  h	X   set server for a sessionr  hX
   Programmerr  h
NhNhX   ELICIT-OFFER-OR-SUGGESTIONr  h]r  X   patternsr  ah]r  X   ssh_sessionr  auK)}r  (hX   32r  h	X   set host for sessionr  hX
   Programmerr  h
NhNhX   ELICIT-OFFER-OR-SUGGESTIONr  h]r  X   patternsr  ah]r  X   ssh_sessionr  auK*}r  (hX   33r  h	X!   To disconnect, use ssh_disconnectr  hX   Apizar  h
X   36r  hX   POSr  hX   SUGGESTr  h]r  X   patternsr  ah]r  X   ssh_disconnectr  auK+}r  (hX   33r  h	X;   with signature: void ssh_disconnect ( ssh_session session )r  hX   Apizar  h
X   42r  hX   CONTr  hX   INFORMr  h]r  X   basicr  ah]r  X   ssh_disconnectr  auK,}r  (hX   34r  h	X   set host for a sessionr  hX
   Programmerr  h
X   41r  hX   REPr  hX   ELICIT-OFFER-OR-SUGGESTIONr   h]r  X   patternsr  ah]r  X   ssh_sessionr  auK-}r  (hX   35r  h	X   I'm sorry, r  hX   Apizar  h
X   44r	  hX   UNCr
  hX   BE-POSITIVEr  hNhNuK.}r  (hX   35r
  h	X    I don't understand your questionr  hX   Apizar  h
X   45r  hX   CONTr  hX   COMMENT-ABOUT-UNDERSTANDINGr  hNhNuK/}r  (hX   36r  h	X   host addressr  hX
   Programmerr  h
NhNhX   ELICIT-OFFER-OR-SUGGESTIONr  h]r  X   basicr  ahNuK0}r  (hX   37r  h	X   I'm sorry, r  hX   Apizar  h
X   47r  hX   UNCr  hX   BE-POSITIVEr   hNhNuK1}r!  (hX   37r"  h	X    I don't understand your questionr#  hX   Apizar$  h
X   48r%  hX   CONTr&  hX   COMMENT-ABOUT-UNDERSTANDINGr'  hNhNuK2}r(  (hX   38r)  h	X)   how to set the host address for a sessionr*  hX
   Programmerr+  h
X   44r,  hX   REPr-  hX   ELICIT-OFFER-OR-SUGGESTIONr.  h]r/  X   patternsr0  ah]r1  X   ssh_sessionr2  auK3}r3  (hX   39r4  h	X   I'm sorry, r5  hX   Apizar6  h
X   50r7  hX   UNCr8  hX   BE-POSITIVEr9  hNhNuK4}r:  (hX   39r;  h	X    I don't understand your questionr<  hX   Apizar=  h
X   51r>  hX   CONTr?  hX   COMMENT-ABOUT-UNDERSTANDINGr@  hNhNuK5}rA  (hX   40rB  h	X   How to set host for sessionrC  hX
   ProgrammerrD  h
X   50rE  hX   REPrF  hX   ELICIT-OFFER-OR-SUGGESTIONrG  h]rH  X   patternsrI  ah]rJ  X   ssh_sessionrK  auK6}rL  (hX   41rM  h	X   error codes in libsshrN  hX
   ProgrammerrO  h
NhNhX
   ELICIT-INFORMrP  h]rQ  X	   structurerR  ahNuK7}rS  (hX   42rT  h	X   ssh_options_setrU  hX
   ProgrammerrV  h
NhNhX
   ELICIT-INFORMrW  h]rX  X   basicrY  ah]rZ  X   ssh_options_setr[  auK8}r\  (hX   43r]  h	Xr   This method's signature is int ssh_options_set( ssh_session session, enum ssh_options_e type, const void * value )r^  hX   Apizar_  h
X   55r`  hX   POSra  hX   INFORMrb  h]rc  X   basicrd  ah]re  X   ssh_options_setrf  auK9}rg  (hX   44rh  h	X   ssh options hostri  hX
   Programmerrj  h
X   56rk  hX   FOLrl  hX
   ELICIT-INFORMrm  h]rn  X   patternsro  ah]rp  X   ssh_options_setrq  auK:}rr  (hX   45rs  h	X   free ssh sessionrt  hX
   Programmerru  h
NhNhX   ELICIT-OFFER-OR-SUGGESTIONrv  h]rw  X   patternsrx  ah]ry  X   ssh_sessionrz  auK;}r{  (hX   46r|  h	X*   To get options, use method ssh_options_getr}  hX   Apizar~  h
X   57r  hX   PARTr  hX   SUGGESTr  h]r  X   patternsr  ah]r  X   ssh_options_getr  auK<}r  (hX   46r  h	Xf   with signature: int ssh_options_get (ssh_session \tsession, enum ssh_options_e type, char ** \tvalue )r  hX   Apizar  h
X   59r  hX   CONTr  hX   INFORMr  h]r  X   basicr  ah]r  X   ssh_options_getr  auK=}r  (hX   47r  h	X   ssh_options_set hostr  hX
   Programmerr  h
X   57r  hX   REPr  hX
   ELICIT-INFORMr  h]r  X   patternsr  ah]r  X   ssh_options_setr  auK>}r  (hX   48r  h	X6   To deallocate a SSH session handle, use method ss_freer  hX   Apizar  h
X   58r  hX   POSr  hX   SUGGESTr  h]r  X   patternsr  ah]r  X   ssh_freer  auK?}r  (hX   48r  h	X:   with this signature: void ssh_free ( ssh_session session )r  hX   Apizar  h
X   62r  hX   CONTr  hX   INFORMr  h]r  X   basicr  ah]r  X   ssh_freer  auK@}r  (hX   49r  h	Xr   This method's signature is int ssh_options_set( ssh_session session, enum ssh_options_e type, const void * value )r  hX   Apizar  h
X   61r  hX   PARTr  hX   INFORMr  h]r  X   basicr  ah]r  X   ssh_options_setr  auKA}r  (hX   50r  h	X   ssh_options enumr  hX
   Programmerr  h
X   64r  hX   FOLr  hX
   ELICIT-INFORMr  h]r  X	   structurer  ah]r  X   ssh_options_setr  auKB}r  (hX   51r  h	X   SSH_OKr  hX
   Programmerr  h
NhNhX
   ELICIT-INFORMr  h]r  X   basicr  ahNuKC}r  (hX   52r  h	X
   Enum values: r  hX   Apizar  h
X   65r  hX   POSr  hX   OTHERr  h]r  X	   structurer  ah]r  X   ssh_options_setr  auKD}r  (hX   52r  h	X  Parameters\nsession: An allocated SSH session structure.\ntype: The option type to set. This could be one of the following:\nSSH_OPTIONS_HOST: The hostname or ip address to connect to (const char *).\nSSH_OPTIONS_PORT: The port to connect to (unsigned int).\nSSH_OPTIONS_PORT_STR: The port to connect to (const char *).\nSSH_OPTIONS_FD: The file descriptor to use (socket_t).\n\nIf you wish to open the socket yourself for a reason or another, set the file descriptor. Don't forget to set the hostname as the hostname is used as a key in the known_host mechanism.\nSSH_OPTIONS_BINDADDR: The address to bind the client to (const char *).\nSSH_OPTIONS_USER: The username for authentication (const char *).\n\nIf the value is NULL, the username is set to the default username.\nSSH_OPTIONS_SSH_DIR: Set the ssh directory (const char *,format string).\n\nIf the value is NULL, the directory is set to the default ssh directory.r  hX   Apizar  h
X   67r  hX   CONTr  hX   INFORMr  h]r  (X
   functionalityr  X
   directivesr  eh]r  X   ssh_options_setr  auKE}r  (hX   53r  h	X
  The ssh directory is used for files like known_hosts and identity (private and public key). It may include "%s" which will be replaced by the user home directory.\nSSH_OPTIONS_KNOWNHOSTS: Set the known hosts file name (const char *,format string).\n\nIf the value is NULL, the directory is set to the default known hosts file, normally ~/.ssh/known_hosts.\n\nThe known hosts file is used to certify remote hosts are genuine. It may include "%d" which will be replaced by the user home directory.\nSSH_OPTIONS_GLOBAL_KNOWNHOSTS: Set the global known hosts file name (const char *,format string).\n\nIf the value is NULL, the directory is set to the default global known hosts file, normally /etc/ssh/ssh_known_hosts.\n\nThe known hosts file is used to certify remote hosts are genuine.\nSSH_OPTIONS_ADD_IDENTITY (or SSH_OPTIONS_IDENTITY): Add a new identity file (const char *, format string) to the identity list.\n\nBy default identity, id_dsa and id_rsa are checked.\n\nThe identity used to authenticate with public key will be prepended to the list. It may include "%s" which will be replaced by the user home directory.\nSSH_OPTIONS_TIMEOUT: Set a timeout for the connection in seconds (long).\nSSH_OPTIONS_TIMEOUT_USEC: Set a timeout for the connection in micro seconds (long).\nSSH_OPTIONS_SSH1: Allow or deny the connection to SSH1 servers (int, 0 is false).\nSSH_OPTIONS_SSH2: Allow or deny the connection to SSH2 servers (int, 0 is false).\nSSH_OPTIONS_LOG_VERBOSITY: Set the session logging verbosity (int).\n\nThe verbosity of the messages. Every log smaller or equal to verbosity will be shown.\nSSH_LOG_NOLOG: No logging\nSSH_LOG_RARE: Rare conditions or warnings\nSSH_LOG_ENTRY: API-accessible entrypoints\nSSH_LOG_PACKET: Packet id and size\nSSH_LOG_FUNCTIONS: Function entering and leaving\nSSH_OPTIONS_LOG_VERBOSITY_STR: Set the session logging verbosity (const char *).\n\nThe verbosity of the messages. Every log smaller or equal to verbosity will be shown.\nSSH_LOG_NOLOG: No logging\nSSH_LOG_RARE: Rare conditions or warnings\nSSH_LOG_ENTRY: API-accessible entrypoints\nSSH_LOG_PACKET: Packet id and size\nSSH_LOG_FUNCTIONS: Function entering and leaving \nSee the corresponding numbers in libssh.h.\nSSH_OPTIONS_AUTH_CALLBACK: Set a callback to use your own authentication function (function pointer).\nSSH_OPTIONS_AUTH_USERDATA: Set the user data passed to the authentication function (generic pointer).\nSSH_OPTIONS_LOG_CALLBACK: Set a callback to use your own logging function (function pointer).\nSSH_OPTIONS_LOG_USERDATA: Set the user data passed to the logging function (generic pointer).\nSSH_OPTIONS_STATUS_CALLBACK: Set a callback to show connection status in realtime (function pointer).\n\nfn(void *arg, float status)r  hX   Apizar  h
X   68r  hX   CONTr  hX   INFORMr  h]r  (X
   functionalityr  X
   directivesr  eh]r  X   ssh_options_setr  auKF}r  (hX   54r  h	X  During ssh_connect(), libssh will call the callback with status from 0.0 to 1.0.\nSSH_OPTIONS_STATUS_ARG: Set the status argument which should be passed to the status callback (generic pointer).\nSSH_OPTIONS_CIPHERS_C_S: Set the symmetric cipher client to server (const char *, comma-separated list).\nSSH_OPTIONS_CIPHERS_S_C: Set the symmetric cipher server to client (const char *, comma-separated list).\nSSH_OPTIONS_KEY_EXCHANGE: Set the key exchange method to be used (const char *, comma-separated list). ex: "ecdh-sha2-nistp256,diffie-hellman-group14-sha1,diffie-hellman-group1-sha1"\nSSH_OPTIONS_HOSTKEYS: Set the preferred server host key types (const char *, comma-separated list). ex: "ssh-rsa,ssh-dss,ecdh-sha2-nistp256"\nSSH_OPTIONS_COMPRESSION_C_S: Set the compression to use for client to server communication (const char *, "yes", "no" or a specific algorithm name if needed ("zlib","<mailto:zlib@openssh.com|zlib@openssh.com>","none").\nSSH_OPTIONS_COMPRESSION_S_C: Set the compression to use for server to client communication (const char *, "yes", "no" or a specific algorithm name if needed ("zlib","<mailto:zlib@openssh.com|zlib@openssh.com>","none").\nSSH_OPTIONS_COMPRESSION: Set the compression to use for both directions communication (const char *, "yes", "no" or a specific algorithm name if needed ("zlib","<mailto:zlib@openssh.com|zlib@openssh.com>","none").\nSSH_OPTIONS_COMPRESSION_LEVEL: Set the compression level to use for zlib functions. (int, value from 1 to 9, 9 being the most efficient but slower).\nSSH_OPTIONS_STRICTHOSTKEYCHECK: Set the parameter StrictHostKeyChecking to avoid asking about a fingerprint (int, 0 = false).\nSSH_OPTIONS_PROXYCOMMAND: Set the command to be executed in order to connect to server (const char *).\nSSH_OPTIONS_GSSAPI_SERVER_IDENTITY Set it to specify the GSSAPI server identity that libssh should expect when connecting to the server (const char *).\nSSH_OPTIONS_GSSAPI_CLIENT_IDENTITY Set it to specify the GSSAPI client identity that libssh should expect when connecting to the server (const char *).\nSSH_OPTIONS_GSSAPI_DELEGATE_CREDENTIALS Set it to specify that GSSAPI should delegate credentials to the server (int, 0 = false).\nSSH_OPTIONS_PASSWORD_AUTH Set it if password authentication should be used in ssh_userauth_auto_pubkey(). (int, 0=false). Currently without effect (ssh_userauth_auto_pubkey doesn\'t use password authentication).\nSSH_OPTIONS_PUBKEY_AUTH Set it if pubkey authentication should be used in ssh_userauth_auto_pubkey(). (int, 0=false).\nSSH_OPTIONS_KBDINT_AUTH Set it if keyboard-interactive authentication should be used in ssh_userauth_auto_pubkey(). (int, 0=false). Currently without effect (ssh_userauth_auto_pubkey doesn\'t use keyboard-interactive authentication).\nSSH_OPTIONS_GSSAPI_AUTH Set it if gssapi authentication should be used in ssh_userauth_auto_pubkey(). (int, 0=false). Currently without effect (ssh_userauth_auto_pubkey doesn\'t use gssapi authentication).\nSSH_OPTIONS_NODELAY Set it to disable Nagle\'s Algorithm (TCP_NODELAY) on the session socket. (int, 0=false)\nr  hX   Apizar  h
X   69r  hX   CONTr  hX   INFORMr  h]r  (X
   functionalityr  X
   directivesr  eh]r  X   ssh_options_setr  auKG}r  (hX   54r  h	X   Parameters\nvalue: The value to set. This is a generic pointer and the datatype which is used should be set according to the type set.r   hX   Apizar  h
X   70r  hX   CONTr  hX   INFORMr  h]r  X
   functionalityr  ah]r  X   ssh_options_setr  auKH}r	  (hX   55r
  h	X   return values of ssh_connectr  hX
   Programmerr  h
NhNhX
   ELICIT-INFORMr
  h]r  X
   functionalityr  ah]r  X   ssh_connectr  auKI}r  (hX   56r  h	X~   Returns SSH_OK on success, SSH_ERROR on error.\nSSH_AGAIN, if the session is in nonblocking mode, and call must be done again.r  hX   Apizar  h
X   72r  hX   POSr  hX   INFORMr  h]r  X
   functionalityr  ah]r  X   ssh_connectr  auKJ}r  (hX   57r  h	X$   return values of ssh_is_server_knownr  hX
   Programmerr   h
NhNhX
   ELICIT-INFORMr!  h]r"  X
   functionalityr#  ah]r$  X   ssh_is_server_knownr%  auKK}r&  (hX   58r'  h	Xr  Returns SSH_SERVER_KNOWN_OK: The server is known and has not changed.\nSSH_SERVER_KNOWN_CHANGED: The server key has changed. Either you are under attack or the administrator changed the key. You HAVE to warn the user about a possible attack.\nSSH_SERVER_FOUND_OTHER: The server gave use a key of a type while we had an other type recorded. It is a possible attack.\nSSH_SERVER_NOT_KNOWN: The server is unknown. User should confirm the MD5 is correct.\nSSH_SERVER_FILE_NOT_FOUND: The known host file does not exist. The host is thus unknown. File will be created if host key is accepted.\nSSH_SERVER_ERROR: Some error happened.r(  hX   Apizar)  h
X   74r*  hX   POSr+  hX   INFORMr,  h]r-  X
   functionalityr.  ah]r/  X   ssh_is_server_knownr0  auKL}r1  (hX   59r2  h	X7   ssh_server_is_known called without crytographic contextr3  hX
   Programmerr4  h
NhNhX
   ELICIT-INFORMr5  h]r6  X
   functionalityr7  ah]r8  X   ssh_is_server_knownr9  auKM}r:  (hX   60r;  h	X   I'm sorry, r<  hX   Apizar=  h
X   76r>  hX   UNCr?  hX   BE-POSITIVEr@  hNhNuKN}rA  (hX   60rB  h	X    I don't understand your questionrC  hX   ApizarD  h
X   77rE  hX   CONTrF  hX   COMMENT-ABOUT-UNDERSTANDINGrG  hNhNuKO}rH  (hX   61rI  h	X&   return values of ssh_userauth_passwordrJ  hX
   ProgrammerrK  h
NhNhX
   ELICIT-INFORMrL  h]rM  X
   functionalityrN  ah]rO  X   ssh_userauth_passwordrP  auKP}rQ  (hX   62rR  h	XB  Returns\nSSH_AUTH_ERROR: A serious error happened.\nSSH_AUTH_DENIED: Authentication failed: use another method\nSSH_AUTH_PARTIAL: You've been partially authenticated, you still have to use another method\nSSH_AUTH_SUCCESS: Authentication success\nSSH_AUTH_AGAIN: In nonblocking mode, you've got to call this again later.\nrS  hX   ApizarT  h
X   79rU  hX   POSrV  hX   INFORMrW  h]rX  X
   functionalityrY  ah]rZ  X   ssh_userauth_passwordr[  auKQ}r\  (hX   62r]  h	X   Note\nMost server implementations do not permit changing the username during authentication. The username should only be set with ssh_options_set() only before you connect to the server.r^  hX   Apizar_  h
X   80r`  hX   CONTra  hX   INFORMrb  h]rc  X
   directivesrd  ah]re  X   ssh_userauth_passwordrf  auKR}rg  (hX   63rh  h	X   create new ssh_channelri  hX
   Programmerrj  h
NhNhX   ELICIT-OFFER-OR-SUGGESTIONrk  h]rl  X   patternsrm  ah]rn  X   ssh_channelro  auKS}rp  (hX   64rq  h	X   open ssh_channelrr  hX
   Programmerrs  h
NhNhX   ELICIT-OFFER-OR-SUGGESTIONrt  h]ru  X   patternsrv  ah]rw  X   ssh_channelrx  auKT}ry  (hX   65rz  h	X   who command on channelr{  hX
   Programmerr|  h
NhNhX   ELICIT-OFFER-OR-SUGGESTIONr}  h]r~  X   patternsr  ah]r  X   ssh_channelr  auKU}r  (hX   66r  h	X.   To allocate a new channel, use ssh_channel_newr  hX   Apizar  h
X   82r  hX   POSr  hX   SUGGESTr  h]r  X   patternsr  ah]r  (X   ssh_channelr  X   ssh_channel_newr  euKV}r  (hX   66r  h	XD    with signature: ssh_channel ssh_channel_new ( ssh_session session )r  hX   Apizar  h
X   85r  hX   CONTr  hX   INFORMr  h]r  X   basicr  ah]r  X   ssh_channel_newr  auKW}r  (hX   67r  h	X   open an ssh channelr  hX
   Programmerr  h
X   83r  hX   REPr  hX   ELICIT-OFFER-OR-SUGGESTIONr  h]r  X   patternsr  ah]r  X   ssh_channelr  auKX}r  (hX   68r  h	X6   To check if a channel is open, use ssh_channel_is_openr  hX   Apizar  h
X   87r  hX   NEGr  hX   SUGGESTr  h]r  X   patternsr  ah]r  X   ssh_channel_is_openr  auKY}r  (hX   68r  h	X@    with signature: int ssh_channel_is_open ( ssh_channel channel )r  hX   Apizar  h
X   88r  hX   CONTr  hX   INFORMr  h]r  X   basicr  ah]r  X   ssh_channel_is_openr  auKZ}r  (hX   69r  h	X   open a new ssh_channelr  hX
   Programmerr  h
X   87r  hX   REPr  hX   ELICIT-OFFER-OR-SUGGESTIONr  h]r  X   patternsr  ah]r  X   ssh_channelr  auK[}r  (hX   70r  h	X;   To open a new session channel, use ssh_channel_open_sessionr  hX   Apizar  h
X   90r  hX   POSr  hX   SUGGESTr  h]r  X   patternsr  ah]r  (X   ssh_channelr  X   ssh_channel_open_sessionr  euK\}r  (hX   70r  h	XB   with signature: int ssh_channel_open_session ) ssh_channel channelr  hX   Apizar  h
X   91r  hX   CONTr  hX   INFORMr  h]r  X   basicr  ah]r  X   ssh_channel_open_sessionr  auK]}r  (hX   71r  h	X(   return codes of ssh_channel_open_sessionr  hX
   Programmerr  h
X   91r  hX   FOLr  hX
   ELICIT-INFORMr  h]r  X
   functionalityr  ah]r  X   ssh_channel_open_sessionr  auK^}r  (hX   72r  h	X{   Returns\nSSH_OK on success, SSH_ERROR if an error occurred, SSH_AGAIN if in nonblocking mode and call has to be done again.r  hX   Apizar  h
X   93r  hX   POSr  hX   INFORMr  h]r  X
   functionalityr  ah]r  X   ssh_channel_open_sessionr  auK_}r  (hX   73r  h	X   execute command on channelr  hX
   Programmerr  h
NhNhX   ELICIT-OFFER-OR-SUGGESTIONr  h]r  X   patternsr  ah]r  X   ssh_channelr  auK`}r  (hX   74r  h	X   who command on channelr  hX
   Programmerr  h
X   84r  hX   REPr   hX   ELICIT-OFFER-OR-SUGGESTIONr  h]r  X   patternsr  ah]r  X   ssh_channelr  auKa}r  (hX   75r  h	X
   close channelr  hX
   Programmerr	  h
NhNhX   ELICIT-OFFER-OR-SUGGESTIONr
  h]r  X   patternsr  ah]r
  X   ssh_channelr  auKb}r  (hX   76r  h	X   free channelr  hX
   Programmerr  h
NhNhX   ELICIT-OFFER-OR-SUGGESTIONr  h]r  X   patternsr  ah]r  X   ssh_channelr  auKc}r  (hX   77r  h	XN   To run a shell command without interactive shell, use ssh_channel_request_execr  hX   Apizar  h
X   95r  hX   POSr  hX   SUGGESTr  h]r  X   patternsr   ah]r!  (X   ssh_channelr"  X   ssh_channel_request_execr#  euKd}r$  (hX   77r%  h	XW   with signature: int ssh_channel_request_exec (\tssh_channel channel, const char * cmd )r&  hX   Apizar'  h
X   99r(  hX   CONTr)  hX   INFORMr*  h]r+  X   basicr,  ah]r-  X   ssh_channel_request_execr.  auKe}r/  (hX   78r0  h	X)   To close a channel, use ssh_channel_closer1  hX   Apizar2  h
X   97r3  hX   POSr4  hX   SUGGESTr5  h]r6  X   patternsr7  ah]r8  (X   ssh_channelr9  X   ssh_channel_closer:  euKf}r;  (hX   78r<  h	X=    with signature int ssh_channel_close ( ssh_channel channel )r=  hX   Apizar>  h
X   101r?  hX   CONTr@  hX   INFORMrA  h]rB  X   basicrC  ah]rD  X   ssh_channel_closerE  auKg}rF  (hX   79rG  h	X   read response from channelrH  hX
   ProgrammerrI  h
NhNhX   ELICIT-OFFER-OR-SUGGESTIONrJ  h]rK  X   patternsrL  ah]rM  X   ssh_channelrN  auKh}rO  (hX   80rP  h	X/   To read data from channel, use ssh_channel_readrQ  hX   ApizarR  h
X   103rS  hX   POSrT  hX   SUGGESTrU  h]rV  X   patternsrW  ah]rX  (X   ssh_channelrY  X   ssh_channel_readrZ  euKi}r[  (hX   80r\  h	Xm    with signature int ssh_channel_read ( ssh_channel channel,\nvoid * \tdest, uint32_t \tcount, int is_stderr )r]  hX   Apizar^  h
X   104r_  hX   CONTr`  hX   INFORMra  h]rb  X   basicrc  ah]rd  X   ssh_channel_readre  auKj}rf  (hX   81rg  h	X   who commandrh  hX
   Programmerri  h
X   96rj  hX   REPrk  hX
   ELICIT-INFORMrl  h]rm  X   patternsrn  ahNuKk}ro  (hX   82rp  h	X   I'm sorry, rq  hX   Apizarr  h
X   106rs  hX   UNCrt  hX   BE-POSITIVEru  hNhNuKl}rv  (hX   82rw  h	X    I don't understand your questionrx  hX   Apizary  h
X   107rz  hX   CONTr{  hX   COMMENT-ABOUT-UNDERSTANDINGr|  hNhNuKm}r}  (hX   83r~  h	X   print response to stdoutr  hX
   Programmerr  h
NhNhX   ELICIT-OFFER-OR-SUGGESTIONr  h]r  X   patternsr  ahNuKn}r  (hX   84r  h	X    print channel response to stdoutr  hX
   Programmerr  h
X   109r  hX   REPr  hX   ELICIT-OFFER-OR-SUGGESTIONr  h]r  X   patternsr  ahNuKo}r  (hX   85r  h	X   ssh_channel_read response countr  hX
   Programmerr  h
X   105r  hX   FOLr  hX
   ELICIT-INFORMr  h]r  X   patternsr  ah]r  X   ssh_channel_readr  auKp}r  (hX   86r  h	X   Returns\nThe number of bytes read, 0 on end of file or SSH_ERROR on error. In nonblocking mode it Can return 0 if no data is available or SSH_AGAIN.r  hX   Apizar  h
X   111r  hX   NEGr  hX   INFORMr  h]r  X
   functionalityr  ah]r  X   ssh_channel_readr  auKq}r  (hX   87r  h	X    return value of std_channel_readr  hX
   Programmerr  h
NhNhX
   ELICIT-INFORMr  h]r  X
   functionalityr  ah]r  X   ssh_channel_readr  auKr}r  (hX   88r  h	X   Returns\nThe number of bytes read, 0 on end of file or SSH_ERROR on error. In nonblocking mode it Can return 0 if no data is available or SSH_AGAIN.r  hX   Apizar  h
X   113r  hX   POSr  hX   INFORMr  h]r  X
   functionalityr  ah]r  X   ssh_channel_readr  auKs}r  (hX   89r  h	X   ssh_channel_readr  hX
   Programmerr  h
NhNhX
   ELICIT-INFORMr  h]r  X   basicr  ah]r  X   ssh_channel_readr  auKt}r  (hX   90r  h	X   What does ssh_channel_read do?r  hX
   Programmerr  h
NhNhX
   ELICIT-INFORMr  h]r  X
   functionalityr  ah]r  X   ssh_channel_readr  auKu}r  (hX   91r  h	X   This signature for this method is int ssh_channel_read\t( ssh_channel \tchannel, void * dest, uint32_t count, int \tis_stderr )r  hX   Apizar  h
X   115r  hX   POSr  hX   INFORMr  h]r  X   basicr  ah]r  X   ssh_channel_readr  auKv}r  (hX   92r  h	X*   ssh_channel_read reads data from a channelr  hX   Apizar  h
X   116r  hX   POSr  hX   INFORMr  h]r  X
   functionalityr  ah]r  X   ssh_channel_readr  auKw}r  (hX   93r  h	X   send data to channelr  hX
   Programmerr  h
NhNhX   ELICIT-OFFER-OR-SUGGESTIONr  h]r  X   patternsr  ah]r  X   ssh_channelr  auKx}r  (hX   94r  h	X   write data to channelr  hX
   Programmerr  h
NhNhX   ELICIT-OFFER-OR-SUGGESTIONr  h]r  X   patternsr  ah]r  X   ssh_channelr  auKy}r  (hX   95r  h	X   send EOFr  hX
   Programmerr  h
NhNhX   ELICIT-OFFER-OR-SUGGESTIONr  h]r  X   patternsr  ahNuKz}r  (hX   96r  h	X?   To send an end of file on the channel, use ssh_channel_send_eofr  hX   Apizar  h
X   121r  hX   POSr  hX   SUGGESTr  h]r  X   patternsr   ah]r  (X   ssh_channelr  X   ssh_channel_send_eofr  euK{}r  (hX   96r  h	X@   with signature: int ssh_channel_send_eof ( ssh_channel channel )r  hX   Apizar  h
X   122r  hX   CONTr	  hX   INFORMr
  h]r  X   basicr  ah]r
  X   ssh_channel_send_eofr  auK|}r  (hX   97r  h	X   create sftp sessionr  hX
   Programmerr  h
NhNhX   ELICIT-OFFER-OR-SUGGESTIONr  h]r  X   patternsr  ah]r  X   sftp_sessionr  auK}}r  (hX   98r  h	X8   To create a new sftp server session, use sftp_server_newr  hX   Apizar  h
X   124r  hX   POSr  hX   SUGGESTr  h]r  X   patternsr   ah]r!  (X   sftp_sessionr"  X   sftp_server_newr#  euK~}r$  (hX   98r%  h	XV   with signature sftp_session sftp_server_new\t( ssh_session session, ssh_channel chan )r&  hX   Apizar'  h
X   125r(  hX   CONTr)  hX   INFORMr*  h]r+  X   basicr,  ah]r-  X   sftp_server_newr.  auK}r/  (hX   99r0  h	X   get open channel on ssh sessionr1  hX
   Programmerr2  h
NhNhX   ELICIT-OFFER-OR-SUGGESTIONr3  h]r4  X   patternsr5  ah]r6  (X   ssh_channelr7  X   ssh_sessionr8  euK}r9  (hX   100r:  h	X   initialize sftp sessionr;  hX
   Programmerr<  h
NhNhX   ELICIT-OFFER-OR-SUGGESTIONr=  h]r>  X   patternsr?  ah]r@  X   sftp_sessionrA  auK}rB  (hX   101rC  h	X.   To allocate a new channel, use ssh_channel_newrD  hX   ApizarE  h
X   127rF  hX   PARTrG  hX   SUGGESTrH  h]rI  X   patternsrJ  ah]rK  (X   ssh_channelrL  X   ssh_channel_newrM  euK}rN  (hX   101rO  h	XD    with signature: ssh_channel ssh_channel_new ( ssh_session session )rP  hX   ApizarQ  h
X   129rR  hX   CONTrS  hX   INFORMrT  h]rU  X   basicrV  ah]rW  X   ssh_channel_newrX  auK}rY  (hX   102rZ  h	X#   create a directory with sftp serverr[  hX
   Programmerr\  h
NhNhX   ELICIT-OFFER-OR-SUGGESTIONr]  h]r^  X   patternsr_  ahNuK}r`  (hX   103ra  h	X?   To initialize a new sftp channel with the server, use sftp_initrb  hX   Apizarc  h
X   128rd  hX   POSre  hX   SUGGESTrf  h]rg  X   patternsrh  ah]ri  X	   sftp_initrj  auK}rk  (hX   103rl  h	X4    with signature: int sftp_init ( sftp_session sftp )rm  hX   Apizarn  h
X   132ro  hX   CONTrp  hX   INFORMrq  h]rr  X   basicrs  ah]rt  X	   sftp_initru  auK}rv  (hX   104rw  h	X   sftp_init return valuesrx  hX
   Programmerry  h
X   133rz  hX   FOLr{  hX
   ELICIT-INFORMr|  h]r}  X
   functionalityr~  ah]r  X	   sftp_initr  auK}r  (hX   105r  h	X$   To create a directory use sftp_mkdirr  hX   Apizar  h
X   131r  hX   POSr  hX   SUGGESTr  h]r  X   patternsr  ah]r  X
   sftp_mkdirr  auK}r  (hX   105r  h	XX   with signature int sftp_mkdir ( sftp_session sftp, const char * directory, mode_t mode )r  hX   Apizar  h
X   135r  hX   CONTr  hX   INFORMr  h]r  X   basicr  ah]r  X
   sftp_mkdirr  auK}r  (hX   106r  h	X:   Returns\n0 on success, &lt; 0 on error with ssh error set.r  hX   Apizar  h
X   134r  hX   POSr  hX   INFORMr  h]r  X   patternsr  ah]r  X	   sftp_initr  auK}r  (hX   107r  h	X   mode_t values for mkdirr  hX
   Programmerr  h
X   136r  hX   FOLr  hX
   ELICIT-INFORMr  h]r  X   patternsr  ah]r  X
   sftp_mkdirr  auK}r  (hX   108r  h	X   mode: Specifies the permissions to use. It is modified by the process's umask in the usual way: The permissions of the created file are (mode &amp; ~umask)r  hX   Apizar  h
X   138r  hX   POSr  hX   INFORMr  h]r  X
   functionalityr  ah]r  X
   sftp_mkdirr  auK}r  (hX   109r  h	X   create sftpr  hX
   Programmerr  h
NhNhX   ELICIT-OFFER-OR-SUGGESTIONr  h]r  X   patternsr  ah]r  X   sftp_sessionr  auK}r  (hX   110r  h	X8   To create a new sftp server session, use sftp_server_newr  hX   Apizar  h
X   140r  hX   POSr  hX   SUGGESTr  h]r  X   patternsr  ah]r  (X   sftp_sessionr  X   sftp_server_newr  euK}r  (hX   110r  h	XV    with signature sftp_session sftp_server_new ( ssh_session session, ssh_channel chan )r  hX   Apizar  h
X   141r  hX   CONTr  hX   INFORMr  h]r  X   basicr  ah]r  X   sftp_server_newr  auK}r  (hX   111r  h	X   file permissions enumr  hX
   Programmerr  h
X   139r  hX   FOLr  hX
   ELICIT-INFORMr  h]r  X	   structurer  ah]r  X
   sftp_mkdirr  auK}r  (hX   112r  h	X   I'm sorry, r  hX   Apizar  h
X   143r  hX   UNCr  hX   BE-POSITIVEr  hNhNuK}r  (hX   112r  h	X    I don't understand your questionr  hX   Apizar  h
X   144r  hX   CONTr  hX   COMMENT-ABOUT-UNDERSTANDINGr  hNhNuK}r  (hX   113r  h	X   mode_t enum valuesr  hX
   Programmerr  h
X   143r  hX   REPr  hX
   ELICIT-INFORMr  h]r  X	   structurer  ah]r  X
   sftp_mkdirr  auK}r  (hX   114r  h	X   create file with sftpr  hX
   Programmerr  h
NhNhX   ELICIT-OFFER-OR-SUGGESTIONr   h]r  X   patternsr  ahNuK}r  (hX   115r  h	X   write value to file with sftpr  hX
   Programmerr  h
NhNhX   ELICIT-OFFER-OR-SUGGESTIONr  h]r  X   patternsr	  ahNuK}r
  (hX   116r  h	X"   To write to a file, use sftp_writer  hX   Apizar
  h
X   148r  hX   POSr  hX   SUGGESTr  h]r  X   patternsr  ah]r  X
   sftp_writer  auK}r  (hX   116r  h	XT   with signature ssize_t sftp_write ( sftp_file file, const void * buf, size_t count )r  hX   Apizar  h
X   149r  hX   CONTr  hX   INFORMr  h]r  X   basicr  ah]r  X
   sftp_writer  auuuK}r   (hhh}r!  (K }r"  (hhh	X	   Hi Apiza,r#  hX
   Programmerr$  h
NhNhX   BE-POSITIVEr%  hNhNuK}r&  (hhh	X   how's it going?r'  hX
   Programmerr(  h
NhNhX
   ELICIT-INFORMr)  hNhNuK}r*  (hhh	X   Hellor+  hX   Apizar,  h
hhX   POSr-  hX   BE-POSITIVEr.  hNhNuK}r/  (hh+h	X   How was your day?r0  hX
   Programmerr1  h
NhNhX
   ELICIT-INFORMr2  hNhNuK}r3  (hh5h	X
   I am well.r4  hX   Apizar5  h
h+hX   POSr6  hX   INFORMr7  hNhNuK}r8  (hh<h	X   It was hot here today.r9  hX
   Programmerr:  h
NhNhX   INFORMr;  hNhNuK}r<  (hh<h	X!   How is the weather where you are?r=  hX
   Programmerr>  h
h<hX   FOLr?  hX
   ELICIT-INFORMr@  hNhNuK}rA  (hhFh	X,   The weather here is warm with thunderstorms.rB  hX   ApizarC  h
hFhX   POSrD  hX   INFORMrE  hNhNuK}rF  (hhQh	X   I'm just outside Chicago.rG  hX
   ProgrammerrH  h
NhNhX   INFORMrI  hNhNuK	}rJ  (hhQh	X   Are you located in South Bend?rK  hX
   ProgrammerrL  h
hXhX   FOLrM  hX
   ELICIT-INFORMrN  hNhNuK
}rO  (hhXh	X4   My current location is Cleveland, OH, United States.rP  hX   ApizarQ  h
hchX   POSrR  hX   INFORMrS  hNhNuK}rT  (hhch	XI   Apiza, what is the command to create a new ssh_session in the libssh API?rU  hX
   ProgrammerrV  h
NhNhX
   ELICIT-INFORMrW  h]rX  X   patternsrY  ah]rZ  X   ssh_sessionr[  auK}r\  (hX   10r]  h	X-   The command to create a new ssh session is:\nr^  hX   Apizar_  h
X   11r`  hX   POSra  hX   INFORMrb  h]rc  X   patternsrd  ah]re  (X   ssh_sessionrf  X   ssh_newrg  euK
}rh  (hX   10ri  h	X&   ssh_session ssh_new\t(\tvoid \t\t)\n\nrj  hX   Apizark  h
X   12rl  hX   CONTrm  hX   INFORMrn  h]ro  X   basicrp  ah]rq  X   ssh_newrr  auK}rs  (hX   10rt  h	X.   Description\nCreate a new ssh session.\n\n\n\nru  hX   Apizarv  h
X   13rw  hX   CONTrx  hX   INFORMry  h]rz  X   basicr{  ah]r|  X   ssh_newr}  auK}r~  (hX   10r  h	X2   Returns\nA new ssh_session pointer, NULL on error.r  hX   Apizar  h
X   14r  hX   CONTr  hX   INFORMr  h]r  X
   functionalityr  ah]r  X   ssh_newr  auK}r  (hX   11r  h	X8   Just to confirm, is the ssh_session type a pointer type?r  hX
   Programmerr  h
X   15r  hX   FOLr  hX
   ELICIT-INFORMr  h]r  X   basicr  ah]r  (X   ssh_sessionr  X   ssh_newr  euK}r  (hX   12r  h	X"   ssh_session is not a pointer type.r  hX   Apizar  h
X   16r  hX   POSr  hX   INFORMr  h]r  X   basicr  ah]r  (X   ssh_sessionr  X   ssh_newr  euK}r  (hX   13r  h	Xs   But when you gave me the command to create a new ssh session, you said it "Returns" "A new ssh_session pointer...".r  hX
   Programmerr  h
X   17r  hX   UNCr  hX   INFORMr  hNh]r  (X   ssh_sessionr  X   ssh_newr  euK}r  (hX   14r  h	X
   I'm confused.r  hX
   Programmerr  h
X   18r  hX   CONTr  hX   ASSESSr  hNhNuK}r  (hX   15r  h	X-   ssh_new returns a pointer to type ssh_sessionr  hX   Apizar  h
X   17r  hX   FOLr  hX   INFORMr  h]r  X   basicr  ah]r  (X   ssh_sessionr  X   ssh_newr  euK}r  (hX   16r  h	X   OK,r  hX
   Programmerr  h
X   20r  hX   POSr  hX   COMMENT-ABOUT-UNDERSTANDINGr  hNhNuK}r  (hX   16r  h	X    thanks for clarifying.r  hX
   Programmerr  h
X   21r  hX   CONTr  hX   BE-POSITIVEr  hNhNuK}r  (hX   17r  h	X9   Next up: how do I connect to a host using the libssh API?r  hX
   Programmerr  h
NhNhX   ELICIT-OFFER-OR-SUGGESTIONr  h]r  X   patternsr  ahNuK}r  (hX   18r  h	X.   To connect to a host, try using the command:\nr  hX   Apizar  h
X   23r  hX   POSr  hX   SUGGESTr  h]r  X   patternsr  ah]r  X   ssh_connectr  auK}r  (hX   18r  h	X0   int ssh_connect\t(\tssh_session \tsession\t)\n\nr  hX   Apizar  h
X   24r  hX   CONTr  hX   INFORMr  h]r  X   basicr  ah]r  X   ssh_connectr  auK}r  (hX   18r  h	X+   Description\nConnect to the ssh server.\n\nr  hX   Apizar  h
X   25r  hX   CONTr  hX   INFORMr  h]r  X   basicr  ah]r  X   ssh_connectr  auK}r  (hX   18r  h	X   Parameters\nsession: The ssh session to connect.\n\nReturns\nSSH_OK on success, SSH_ERROR on error.\nSSH_AGAIN, if the session is in nonblocking mode, and call must be done again.\n\nr  hX   Apizar  h
X   26r  hX   CONTr  hX   INFORMr  h]r  X
   functionalityr  ah]r  X   ssh_connectr  auK}r  (hX   18r   h	X%   See also\nssh_new()\nssh_disconnect()r  hX   Apizar  h
X   27r  hX   CONTr  hX   INFORMr  hNh]r  X   ssh_connectr  auK}r  (hX   19r	  h	X
   Thank you.r
  hX
   Programmerr  h
X   28r  hX   POSr
  hX   BE-POSITIVEr  hNhNuK}r  (hX   20r  h	X8   Also, how do I authenticate a server in the libssh API? r  hX
   Programmerr  h
NhNhX   ELICIT-OFFER-OR-SUGGESTIONr  h]r  X   patternsr  ahNuK}r  (hX   20r  h	X@   And in the libssh API, how do I authenticate a user to a server?r  hX
   Programmerr  h
NhNhX   ELICIT-OFFER-OR-SUGGESTIONr  h]r  X   patternsr  ahNuK }r  (hX   21r  h	X2   To authenticate a server, try using the command:\nr  hX   Apizar   h
X   30r!  hX   POSr"  hX   SUGGESTr#  h]r$  X   patternsr%  ah]r&  X   ssh_is_server_knownr'  auK!}r(  (hX   21r)  h	X8   int ssh_is_server_known\t(\tssh_session \tsession\t)\n\nr*  hX   Apizar+  h
X   32r,  hX   CONTr-  hX   INFORMr.  h]r/  X   basicr0  ah]r1  X   ssh_is_server_knownr2  auK"}r3  (hX   21r4  h	X   Description\nCheck if the server is known.\nChecks the user's known host file for a previous connection to the current server.\n\nr5  hX   Apizar6  h
X   33r7  hX   CONTr8  hX   INFORMr9  h]r:  X
   functionalityr;  ah]r<  X   ssh_is_server_knownr=  auK#}r>  (hX   21r?  h	X0   Parameters\nsession: The SSH session to use.\n\nr@  hX   ApizarA  h
X   34rB  hX   CONTrC  hX   INFORMrD  h]rE  X   basicrF  ah]rG  X   ssh_is_server_knownrH  auK$}rI  (hX   21rJ  h	X  Returns\nSSH_SERVER_KNOWN_OK: The server is known and has not changed.\nSSH_SERVER_KNOWN_CHANGED: The server key has changed. Either you are under attack or the administrator changed the key. You HAVE to warn the user about a possible attack.\nSSH_SERVER_FOUND_OTHER: The server gave use a key of a type while we had an other type recorded. It is a possible attack.\nSSH_SERVER_NOT_KNOWN: The server is unknown. User should confirm the MD5 is correct.\nSSH_SERVER_FILE_NOT_FOUND: The known host file does not exist. The host is thus unknown. File will be created if host key is accepted.\nSSH_SERVER_ERROR: Some error happened.\n\nSee also\nssh_get_pubkey_hash()\nBug:\nThere is no current way to remove or modify an entry into the known host table.\n\nTo authenticate a user to a server, try using the command:\nint ssh_userauth_password\t(\tssh_session \tsession,\nconst char * \tusername,\nconst char * \tpassword \n)\n\nDescription\nTry to authenticate by password.\nThis authentication method is normally disabled on SSHv2 server. You should use keyboard-interactive mode.\nThe 'password' value MUST be encoded UTF-8. It is up to the server how to interpret the password and validate it against the password database. However, if you read the password in some other encoding, you MUST convert the password to UTF-8.\n\nParameters\nsession: The ssh session to use.\nusername: The username, this SHOULD be NULL.\npassword: The password to authenticate in UTF-8.\n\nReturns\nSSH_AUTH_ERROR: A serious error happened.\nSSH_AUTH_DENIED: Authentication failed: use another method\nSSH_AUTH_PARTIAL: You've been partially authenticated, you still have to use another method\nSSH_AUTH_SUCCESS: Authentication success\nSSH_AUTH_AGAIN: In nonblocking mode, you've got to call this again later.\nrK  hX   ApizarL  h
X   35rM  hX   CONTrN  hX   INFORMrO  h]rP  (X
   functionalityrQ  X   qualityrR  X   patternsrS  X
   directivesrT  eh]rU  X   ssh_is_server_knownrV  auK%}rW  (hX   21rX  h	X   Note\nMost server implementations do not permit changing the username during authentication. The username should only be set with ssh_options_set() only before you connect to the server.\n\nrY  hX   ApizarZ  h
X   36r[  hX   CONTr\  hX   INFORMr]  h]r^  (X
   directivesr_  X
   functionalityr`  eh]ra  X   ssh_is_server_knownrb  auK&}rc  (hX   21rd  h	X4   See also\nssh_userauth_none()\nssh_userauth_kbdint()re  hX   Apizarf  h
X   37rg  hX   CONTrh  hX   INFORMri  hNh]rj  X   ssh_is_server_knownrk  auK'}rl  (hX   22rm  h	X   Sounds good.rn  hX
   Programmerro  h
X   38rp  hX   POSrq  hX   ASSESSrr  hNhNuK(}rs  (hX   22rt  h	XA   But how do I connect to a specific hostname using the libssh API?ru  hX
   Programmerrv  h
X   38rw  hX   FOLrx  hX   ELICIT-OFFER-OR-SUGGESTIONry  h]rz  X   patternsr{  ahNuK)}r|  (hX   23r}  h	X   Sorry, r~  hX   Apizar  h
X   40r  hX   FOLr  hX   BE-POSITIVEr  hNhNuK*}r  (hX   23r  h	X(   what do you mean by "specific hostname"?r  hX   Apizar  h
X   41r  hX   CONTr  hX
   ELICIT-INFORMr  h]r  X   conceptsr  ahNuK+}r  (hX   24r  h	X6   To be exact, I want to open a connection to localhost.r  hX
   Programmerr  h
X   42r  hX   POSr  hX   INFORMr  h]r  X   patternsr  ahNuK,}r  (hX   25r  h	X   Try using the command:\nr  hX   Apizar  h
X   40r  hX   POSr  hX   SUGGESTr  h]r  X   patternsr  ahNuK-}r  (hX   25r  h	X   int ssh_channel_open_forward\t(\tssh_channel \tchannel,\nconst char * \tremotehost,\nint \tremoteport,\nconst char * \tsourcehost,\nint \tlocalport \n)\n\nr  hX   Apizar  h
X   44r  hX   CONTr  hX   INFORMr  h]r  X   basicr  ah]r  X   ssh_channel_open_forwardr  auK.}r  (hX   25r  h	X2   Description\nOpen a TCP/IP forwarding channel.\n\nr  hX   Apizar  h
X   45r  hX   CONTr  hX   INFORMr  h]r  X
   functionalityr  ah]r  X   ssh_channel_open_forwardr  auK/}r  (hX   25r  h	X{  Parameters\nchannel: An allocated channel.\nremotehost: The remote host to connected (host name or IP).\nremoteport: The remote port.\nsourcehost: The numeric IP address of the machine from where the connection request originates. This is mostly for logging purposes.\nlocalport: The port on the host from where the connection originated. This is mostly for logging purposes.\n\nr  hX   Apizar  h
X   46r  hX   CONTr  hX   INFORMr  h]r  (X
   functionalityr  X   purposer  eh]r  X   ssh_channel_open_forwardr  auK0}r  (hX   25r  h	X{   Returns\nSSH_OK on success, SSH_ERROR if an error occurred, SSH_AGAIN if in nonblocking mode and call has to be done again.r  hX   Apizar  h
X   47r  hX   CONTr  hX   INFORMr  h]r  X
   functionalityr  ah]r  X   ssh_channel_open_forwardr  auK1}r  (hX   26r  h	X   OK.r  hX
   Programmerr  h
X   48r  hX   POSr  hX   ASSESSr  hNhNuK2}r  (hX   27r  h	XG   This code returns an SSH_ERROR: connection_status = ssh_connect(sess); r  hX
   Programmerr  h
X   48r  hX   FOLr  hX   INFORMr  h]r  X
   functionalityr  ah]r  X   ssh_channel_open_forwardr  auK3}r  (hX   27r  h	X:   sess is an ssh_session which was returned from ssh_new(). r  hX
   Programmerr  h
X   50r  hX   CONTr  hX   INFORMr  hNh]r  X   ssh_channel_open_forwardr  auK4}r  (hX   27r  h	X   What did I do wrong?r  hX
   Programmerr  h
X   51r  hX   FOLr  hX
   ELICIT-INFORMr  h]r  X
   functionalityr  ah]r  X   ssh_channel_open_forwardr  auK5}r  (hX   28r  h	X   I'm not sure what is wrong with This code returns an SSH_ERROR: connection_status = ssh_connect(sess); sess is an ssh_session which was returned from ssh_new().r  hX   Apizar  h
X   52r  hX   NEGr  hX   INFORMr  h]r  X
   functionalityr  ah]r  X   ssh_channel_open_forwardr  auK6}r  (hX   29r  h	X"   Can I pass ssh_connect a hostname?r  hX
   Programmerr  h
NhNhX
   ELICIT-INFORMr    h]r   (X
   functionalityr   X   basicr   eh]r   X   ssh_connectr   auK7}r   (hX   30r   h	X%   ssh_connect() takes an ssh_session:\nr   hX   Apizar	   h
X   54r
   hX   PARTr   hX   INFORMr   h]r
   X   basicr   ah]r   X   ssh_connectr   auK8}r   (hX   30r   h	X0   int ssh_connect\t(\tssh_session \tsession\t)\n\nr   hX   Apizar   h
X   55r   hX   CONTr   hX   INFORMr   h]r   X   basicr   ah]r   X   ssh_connectr   auK9}r   (hX   30r   h	X+   Description\nConnect to the ssh server.\n\nr   hX   Apizar   h
X   56r    hX   CONTr!   hX   INFORMr"   h]r#   X   basicr$   ah]r%   X   ssh_connectr&   auK:}r'   (hX   30r(   h	X   Parameters\nsession: The ssh session to connect.\n\nReturns\nSSH_OK on success, SSH_ERROR on error.\nSSH_AGAIN, if the session is in nonblocking mode, and call must be done again.\n\nr)   hX   Apizar*   h
X   57r+   hX   CONTr,   hX   INFORMr-   h]r.   X
   functionalityr/   ah]r0   X   ssh_connectr1   auK;}r2   (hX   30r3   h	X%   See also\nssh_new()\nssh_disconnect()r4   hX   Apizar5   h
X   58r6   hX   CONTr7   hX   INFORMr8   hNh]r9   X   ssh_connectr:   auK<}r;   (hX   31r<   h	X-   How do I set the hostname for an SSH session?r=   hX
   Programmerr>   h
NhNhX   ELICIT-OFFER-OR-SUGGESTIONr?   h]r@   X   patternsrA   ahNuK=}rB   (hX   32rC   h	X(   How do I use the ssh_disconnect command?rD   hX
   ProgrammerrE   h
NhNhX   ELICIT-OFFER-OR-SUGGESTIONrF   h]rG   X   patternsrH   ah]rI   X   ssh_disconnectrJ   auK>}rK   (hX   33rL   h	X2   For setting the hostname, try using the command:\nrM   hX   ApizarN   h
X   60rO   hX   POSrP   hX   SUGGESTrQ   h]rR   X   patternsrS   ah]rT   X   ssh_channel_open_forwardrU   auK?}rV   (hX   33rW   h	X   Try using the command:\nrX   hX   ApizarY   h
X   62rZ   hX   REPr[   hX   OTHERr\   h]r]   X   patternsr^   ah]r_   X   ssh_channel_open_forwardr`   auK@}ra   (hX   33rb   h	X   int ssh_channel_open_forward ( ssh_channel channel,\nconst char * remotehost,\nint remoteport,\nconst char * sourcehost,\nint localport \n)\n\nrc   hX   Apizard   h
X   63re   hX   POSrf   hX   INFORMrg   h]rh   X   basicri   ah]rj   X   ssh_channel_open_forwardrk   auKA}rl   (hX   33rm   h	X2   Description\nOpen a TCP/IP forwarding channel.\n\nrn   hX   Apizaro   h
X   64rp   hX   CONTrq   hX   INFORMrr   h]rs   X
   functionalityrt   ah]ru   X   ssh_channel_open_forwardrv   auKB}rw   (hX   33rx   h	X{  Parameters\nchannel: An allocated channel.\nremotehost: The remote host to connected (host name or IP).\nremoteport: The remote port.\nsourcehost: The numeric IP address of the machine from where the connection request originates. This is mostly for logging purposes.\nlocalport: The port on the host from where the connection originated. This is mostly for logging purposes.\n\nry   hX   Apizarz   h
X   65r{   hX   CONTr|   hX   INFORMr}   h]r~   (X
   functionalityr   X   purposer   eh]r   X   ssh_channel_open_forwardr   auKC}r   (hX   33r   h	X{   Returns\nSSH_OK on success, SSH_ERROR if an error occurred, SSH_AGAIN if in nonblocking mode and call has to be done again.r   hX   Apizar   h
X   66r   hX   CONTr   hX   INFORMr   h]r   X
   functionalityr   ah]r   X   ssh_channel_open_forwardr   auKD}r   (hX   34r   h	X    The ssh_disconnect command is:\nr   hX   Apizar   h
X   61r   hX   POSr   hX   INFORMr   hNh]r   X   ssh_disconnectr   auKE}r   (hX   34r   h	X4   void ssh_disconnect\t(\tssh_session \tsession\t)\n\nr   hX   Apizar   h
X   68r   hX   CONTr   hX   INFORMr   h]r   X   basicr   ah]r   X   ssh_disconnectr   auKF}r   (hX   34r   h	Xu   Description\nDisconnect from a session (client or server).\nThe session can then be reused to open a new session.\n\nr   hX   Apizar   h
X   69r   hX   CONTr   hX   INFORMr   h]r   (X
   functionalityr   X
   directivesr   eh]r   X   ssh_disconnectr   auKG}r   (hX   34r   h	X,   Parameters\nsession: The SSH session to use.r   hX   Apizar   h
X   70r   hX   CONTr   hX   INFORMr   h]r   X   basicr   ah]r   X   ssh_disconnectr   auKH}r   (hX   35r   h	X   How do I open a channel in SSH?r   hX
   Programmerr   h
NhNhX   ELICIT-OFFER-OR-SUGGESTIONr   h]r   X   patternsr   ah]r   X   ssh_channelr   auKI}r   (hX   36r   h	X$   To open a new channel in SSH, try:\nr   hX   Apizar   h
X   72r   hX   POSr   hX   SUGGESTr   h]r   X   patternsr   ah]r   X   ssh_channelr   auKJ}r   (hX   36r   h	X<   ssh_channel ssh_channel_new\t(\tssh_session \tsession\t)\n\nr   hX   Apizar   h
X   73r   hX   CONTr   hX   INFORMr   h]r   X   basicr   ah]r   X   ssh_channel_newr   auKK}r   (hX   36r   h	X(   Description\nAllocate a new channel.\n\nr   hX   Apizar   h
X   74r   hX   CONTr   hX   INFORMr   h]r   X   basicr   ah]r   X   ssh_channel_newr   auKL}r   (hX   36r   h	X0   Parameters\nsession: The ssh session to use.\n\nr   hX   Apizar   h
X   75r   hX   CONTr   hX   INFORMr   h]r   X   basicr   ah]r   X   ssh_channel_newr   auKM}r   (hX   36r   h	X?   Returns\nA pointer to a newly allocated channel, NULL on error.r   hX   Apizar   h
X   76r   hX   CONTr   hX   INFORMr   h]r   (X   basicr   X
   functionalityr   eh]r   X   ssh_channel_newr   auKN}r   (hX   37r   h	X   How do I free an SSH session?r   hX
   Programmerr   h
NhNhX   ELICIT-OFFER-OR-SUGGESTIONr   h]r   X   patternsr !  ah]r!  X   ssh_sessionr!  auKO}r!  (hX   38r!  h	X-   How many arguments does ssh_connect() accept?r!  hX
   Programmerr!  h
NhNhX
   ELICIT-INFORMr!  h]r!  X   basicr	!  ah]r
!  X   ssh_connectr!  auKP}r!  (hX   39r
!  h	X   To free an SSH session, try:\nr!  hX   Apizar!  h
X   78r!  hX   POSr!  hX   SUGGESTr!  h]r!  X   patternsr!  ah]r!  X   ssh_sessionr!  auKQ}r!  (hX   39r!  h	X.   void ssh_free\t(\tssh_session \tsession\t)\n\nr!  hX   Apizar!  h
X   80r!  hX   CONTr!  hX   INFORMr!  h]r!  X   basicr!  ah]r !  X   ssh_freer!!  auKR}r"!  (hX   39r#!  h	X1   Description\nDeallocate a SSH session handle.\n\nr$!  hX   Apizar%!  h
X   81r&!  hX   CONTr'!  hX   INFORMr(!  h]r)!  X
   functionalityr*!  ah]r+!  X   ssh_freer,!  auKS}r-!  (hX   39r.!  h	X1   Parameters\nsession: The SSH session to free.\n\nr/!  hX   Apizar0!  h
X   82r1!  hX   CONTr2!  hX   INFORMr3!  h]r4!  X   basicr5!  ah]r6!  X   ssh_freer7!  auKT}r8!  (hX   39r9!  h	X%   See also\nssh_disconnect()\nssh_new()r:!  hX   Apizar;!  h
X   83r<!  hX   CONTr=!  hX   INFORMr>!  hNh]r?!  X   ssh_freer@!  auKU}rA!  (hX   40rB!  h	X#   ssh_connect() takes one argument:\nrC!  hX   ApizarD!  h
X   79rE!  hX   POSrF!  hX   INFORMrG!  h]rH!  X   basicrI!  ah]rJ!  X   ssh_connectrK!  auKV}rL!  (hX   40rM!  h	X0   int ssh_connect\t(\tssh_session \tsession\t)\n\nrN!  hX   ApizarO!  h
X   85rP!  hX   CONTrQ!  hX   INFORMrR!  h]rS!  X   basicrT!  ah]rU!  X   ssh_connectrV!  auKW}rW!  (hX   40rX!  h	X+   Description\nConnect to the ssh server.\n\nrY!  hX   ApizarZ!  h
X   86r[!  hX   CONTr\!  hX   INFORMr]!  h]r^!  X   basicr_!  ah]r`!  X   ssh_connectra!  auKX}rb!  (hX   40rc!  h	X4   Parameters\nsession: The ssh session to connect.\n\nrd!  hX   Apizare!  h
X   87rf!  hX   CONTrg!  hX   INFORMrh!  h]ri!  X   basicrj!  ah]rk!  X   ssh_connectrl!  auKY}rm!  (hX   40rn!  h	X   Returns\nSSH_OK on success, SSH_ERROR on error.\nSSH_AGAIN, if the session is in nonblocking mode, and call must be done again.\n\nro!  hX   Apizarp!  h
X   88rq!  hX   CONTrr!  hX   INFORMrs!  h]rt!  X
   functionalityru!  ah]rv!  X   ssh_connectrw!  auKZ}rx!  (hX   40ry!  h	X%   See also\nssh_new()\nssh_disconnect()rz!  hX   Apizar{!  h
X   89r|!  hX   CONTr}!  hX   INFORMr~!  hNh]r!  X   ssh_connectr!  auK[}r!  (hX   41r!  h	X0   I need double quotes around strings in C, right?r!  hX
   Programmerr!  h
NhNhX
   ELICIT-INFORMr!  h]r!  X
   directivesr!  ahNuK\}r!  (hX   42r!  h	XL   ssh_channel_open_forward() takes a long time and doesn't return any output. r!  hX
   Programmerr!  h
NhNhX   INFORMr!  h]r!  (X
   functionalityr!  X   qualityr!  eh]r!  X   ssh_channel_open_forwardr!  auK]}r!  (hX   42r!  h	X   Is this normal? r!  hX
   Programmerr!  h
X   92r!  hX   FOLr!  hX
   ELICIT-INFORMr!  h]r!  (X
   functionalityr!  X   qualityr!  eh]r!  X   ssh_channel_open_forwardr!  auK^}r!  (hX   42r!  h	X    Is there a way to set a timeout?r!  hX
   Programmerr!  h
X   92r!  hX   FOLr!  hX
   ELICIT-INFORMr!  h]r!  X   patternsr!  ah]r!  X   ssh_channel_open_forwardr!  auK_}r!  (hX   43r!  h	X*   How do I set a hostname on an SSH session?r!  hX
   Programmerr!  h
X   60r!  hX   REPr!  hX   ELICIT-OFFER-OR-SUGGESTIONr!  h]r!  X   patternsr!  ahNuK`}r!  (hX   44r!  h	X*   How do I set a hostname on an SSH channel?r!  hX
   Programmerr!  h
NhNhX   ELICIT-OFFER-OR-SUGGESTIONr!  h]r!  X   patternsr!  ahNuKa}r!  (hX   45r!  h	X0   Yes, strings, or char arrays, use double quotes.r!  hX   Apizar!  h
X   91r!  hX   POSr!  hX   INFORMr!  h]r!  X
   directivesr!  ahNuKb}r!  (hX   46r!  h	X   For channel timeout, try:\nr!  hX   Apizar!  h
X   94r!  hX   POSr!  hX   SUGGESTr!  h]r!  X   patternsr!  ah]r!  X   ssh_channel_poll_timeoutr!  auKc}r!  (hX   46r!  h	X`   int ssh_channel_poll_timeout\t(\tssh_channel \tchannel,\nint \ttimeout,\nint \tis_stderr \n)\n\nr!  hX   Apizar!  h
X   98r!  hX   CONTr!  hX   INFORMr!  h]r!  X   basicr!  ah]r!  X   ssh_channel_poll_timeoutr!  auKd}r!  (hX   46r!  h	XQ   Description\nPolls a channel for data to read, waiting for a certain timeout.\n\nr!  hX   Apizar!  h
X   99r!  hX   CONTr!  hX   INFORMr!  h]r!  X
   functionalityr!  ah]r!  X   ssh_channel_poll_timeoutr!  auKe}r!  (hX   46r!  h	X  Parameters\nchannel: The channel to poll.\ntimeout: Set an upper limit on the time for which this function will block, in milliseconds. Specifying a negative value means an infinite timeout. This parameter is passed to the poll() function.\nis_stderr: A boolean to select the stderr stream.\n\nReturns\nThe number of bytes available for reading, 0 if nothing is available (timeout elapsed), SSH_EOF on end of file, SSH_ERROR on error.\n\nr!  hX   Apizar!  h
X   100r!  hX   CONTr!  hX   INFORMr!  h]r!  (X
   functionalityr!  X   controlr!  eh]r!  X   ssh_channel_poll_timeoutr!  auKf}r!  (hX   46r!  h	X   See also\nssh_channel_is_eof()r!  hX   Apizar!  h
X   101r!  hX   CONTr!  hX   INFORMr!  hNh]r!  X   ssh_channel_poll_timeoutr!  auKg}r!  (hX   47r!  h	X   For setting a hostname, try:\nr!  hX   Apizar!  h
X   95r!  hX   POSr!  hX   SUGGESTr!  h]r!  X   patternsr "  ah]r"  X   ssh_channel_open_forwardr"  auKh}r"  (hX   47r"  h	X   int ssh_channel_open_forward\t(\tssh_channel \tchannel,\nconst char * \tremotehost,\nint \tremoteport,\nconst char * \tsourcehost,\nint \tlocalport \n)\n\nr"  hX   Apizar"  h
X   103r"  hX   CONTr"  hX   INFORMr	"  h]r
"  X   basicr"  ah]r"  X   ssh_channel_open_forwardr
"  auKi}r"  (hX   47r"  h	X2   Description\nOpen a TCP/IP forwarding channel.\n\nr"  hX   Apizar"  h
X   104r"  hX   CONTr"  hX   INFORMr"  h]r"  X
   functionalityr"  ah]r"  X   ssh_channel_open_forwardr"  auKj}r"  (hX   47r"  h	X{  Parameters\nchannel: An allocated channel.\nremotehost: The remote host to connected (host name or IP).\nremoteport: The remote port.\nsourcehost: The numeric IP address of the machine from where the connection request originates. This is mostly for logging purposes.\nlocalport: The port on the host from where the connection originated. This is mostly for logging purposes.\n\nr"  hX   Apizar"  h
X   105r"  hX   CONTr"  hX   INFORMr"  h]r "  (X
   functionalityr!"  X   purposer""  eh]r#"  X   ssh_channel_open_forwardr$"  auKk}r%"  (hX   47r&"  h	X{   Returns\nSSH_OK on success, SSH_ERROR if an error occurred, SSH_AGAIN if in nonblocking mode and call has to be done again.r'"  hX   Apizar("  h
X   106r)"  hX   CONTr*"  hX   INFORMr+"  h]r,"  X
   functionalityr-"  ah]r."  X   ssh_channel_open_forwardr/"  auKl}r0"  (hX   48r1"  h	X   I tried that. r2"  hX
   Programmerr3"  h
X   104r4"  hX   NEGr5"  hX   INFORMr6"  h]r7"  X
   functionalityr8"  ah]r9"  X   ssh_channel_open_forwardr:"  auKm}r;"  (hX   48r<"  h	X	   It locks.r="  hX
   Programmerr>"  h
X   108r?"  hX   CONTr@"  hX   INFORMrA"  h]rB"  X
   functionalityrC"  ah]rD"  X   ssh_channel_open_forwardrE"  auKn}rF"  (hX   49rG"  h	X   For it locks, try:\nrH"  hX   ApizarI"  h
X   109rJ"  hX   FOLrK"  hX   SUGGESTrL"  h]rM"  X   patternsrN"  ah]rO"  X   ssh_channel_set_blockingrP"  auKo}rQ"  (hX   49rR"  h	XP   void ssh_channel_set_blocking\t(\tssh_channel \tchannel,\nint \tblocking \n)\n\nrS"  hX   ApizarT"  h
X   110rU"  hX   CONTrV"  hX   INFORMrW"  h]rX"  X   basicrY"  ah]rZ"  X   ssh_channel_set_blockingr["  auKp}r\"  (hX   49r]"  h	XC   Description\nPut the channel into blocking or nonblocking mode.\n\nr^"  hX   Apizar_"  h
X   111r`"  hX   CONTra"  hX   INFORMrb"  h]rc"  X
   functionalityrd"  ah]re"  X   ssh_channel_set_blockingrf"  auKq}rg"  (hX   49rh"  h	X^   Parameters\nchannel: The channel to use.\nblocking: A boolean for blocking or nonblocking.\n\nri"  hX   Apizarj"  h
X   112rk"  hX   CONTrl"  hX   INFORMrm"  h]rn"  X
   functionalityro"  ah]rp"  X   ssh_channel_set_blockingrq"  auKr}rr"  (hX   49rs"  h	X   See also\nssh_set_blocking()rt"  hX   Apizaru"  h
X   113rv"  hX   CONTrw"  hX   INFORMrx"  hNh]ry"  X   ssh_channel_set_blockingrz"  auKs}r{"  (hX   50r|"  h	X(   How do I set the hostname for a channel?r}"  hX
   Programmerr~"  h
X   96r"  hX   REPr"  hX   ELICIT-OFFER-OR-SUGGESTIONr"  h]r"  X   patternsr"  ahNuKt}r"  (hX   51r"  h	X   What are your goals in life?r"  hX
   Programmerr"  h
NhNhX
   ELICIT-INFORMr"  hNhNuKu}r"  (hX   52r"  h	X.   For setting the hostname for a channel, try:\nr"  hX   Apizar"  h
X   115r"  hX   POSr"  hX   SUGGESTr"  h]r"  X   patternsr"  ah]r"  X   ssh_channel_open_forwardr"  auKv}r"  (hX   52r"  h	X   int ssh_channel_open_forward\t(\tssh_channel \tchannel,\nconst char * \tremotehost,\nint \tremoteport,\nconst char * \tsourcehost,\nint \tlocalport \n)\n\nr"  hX   Apizar"  h
X   117r"  hX   CONTr"  hX   INFORMr"  h]r"  X   basicr"  ah]r"  X   ssh_channel_open_forwardr"  auKw}r"  (hX   52r"  h	X2   Description\nOpen a TCP/IP forwarding channel.\n\nr"  hX   Apizar"  h
X   118r"  hX   CONTr"  hX   INFORMr"  h]r"  X
   functionalityr"  ah]r"  X   ssh_channel_open_forwardr"  auKx}r"  (hX   52r"  h	X{  Parameters\nchannel: An allocated channel.\nremotehost: The remote host to connected (host name or IP).\nremoteport: The remote port.\nsourcehost: The numeric IP address of the machine from where the connection request originates. This is mostly for logging purposes.\nlocalport: The port on the host from where the connection originated. This is mostly for logging purposes.\n\nr"  hX   Apizar"  h
X   119r"  hX   CONTr"  hX   INFORMr"  h]r"  (X
   functionalityr"  X   purposer"  eh]r"  X   ssh_channel_open_forwardr"  auKy}r"  (hX   52r"  h	X   Returns\nSSH_OK on success, SSH_ERROR if an error occurred, SSH_AGAIN if in nonblocking mode and call has to be done again.\n\nr"  hX   Apizar"  h
X   120r"  hX   CONTr"  hX   INFORMr"  h]r"  X
   functionalityr"  ah]r"  X   ssh_channel_open_forwardr"  auKz}r"  (hX   52r"  h	X   or\n\nint ssh_channel_open_reverse_forward\t(\tssh_channel \tchannel,\nconst char * \tremotehost,\nint \tremoteport,\nconst char * \tsourcehost,\nint \tlocalport \n)\n\nr"  hX   Apizar"  h
X   121r"  hX   CONTr"  hX   INFORMr"  h]r"  X   basicr"  ah]r"  X    ssh_channel_open_reverse_forwardr"  auK{}r"  (hX   52r"  h	X:   Description\nOpen a TCP/IP reverse forwarding channel.\n\nr"  hX   Apizar"  h
X   122r"  hX   CONTr"  hX   INFORMr"  h]r"  X
   functionalityr"  ah]r"  X    ssh_channel_open_reverse_forwardr"  auK|}r"  (hX   52r"  h	X>  Parameters\nchannel: An allocated channel.\nremotehost: The remote host to connected (host name or IP).\nremoteport: The remote port.\nsourcehost: The source host (your local computer). It's optional and for logging purpose.\nlocalport: The source port (your local computer). It's optional and for logging purpose.\n\nr"  hX   Apizar"  h
X   123r"  hX   CONTr"  hX   INFORMr"  h]r"  (X
   functionalityr"  X   purposer"  eh]r"  X    ssh_channel_open_reverse_forwardr"  auK}}r"  (hX   52r"  h	X{   Returns\nSSH_OK on success, SSH_ERROR if an error occurred, SSH_AGAIN if in nonblocking mode and call has to be done again.r"  hX   Apizar"  h
X   124r"  hX   CONTr"  hX   INFORMr"  h]r"  X
   functionalityr"  ah]r"  X    ssh_channel_open_reverse_forwardr"  auK~}r"  (hX   53r"  h	X4   Apiza, how do I execute a command on an SSH channel?r"  hX
   Programmerr"  h
NhNhX   ELICIT-OFFER-OR-SUGGESTIONr"  h]r"  X   patternsr"  ah]r"  X   ssh_channelr"  auK}r"  (hX   54r"  h	X0   Here are the functions related to ssh_channel:\nr"  hX   Apizar"  h
X   126r"  hX   PARTr"  hX   INFORMr"  h]r"  X	   structurer"  ah]r #  X   ssh_channelr#  auK}r#  (hX   54r#  h	XT  channel_read_buffer\nssh_channel_accept_forward\nssh_channel_accept_x11\nssh_channel_cancel_forward\nssh_channel_change_pty_size\nssh_channel_close\nssh_channel_free\nssh_channel_get_exit_status\nssh_channel_get_session\nssh_channel_is_closed\nssh_channel_is_eof\nssh_channel_is_open\nssh_channel_listen_forward\nssh_channel_new\nssh_channel_open_auth_agent\nssh_channel_open_forward\nssh_channel_open_reverse_forward\nssh_channel_open_session\nssh_channel_open_x11\nssh_channel_poll\nssh_channel_poll_timeout\nssh_channel_read\nssh_channel_read_nonblocking\nssh_channel_read_timeout\nssh_channel_request_auth_agent\nssh_channel_request_env\nssh_channel_request_exec\nssh_channel_request_pty\nssh_channel_request_pty_size\nssh_channel_request_send_break\nssh_channel_request_send_exit_signal\nssh_channel_request_send_exit_status\nssh_channel_request_send_signal\nssh_channel_request_shell\nssh_channel_request_subsystem\nssh_channel_request_x11\nssh_channel_select\nssh_channel_send_eof\nssh_channel_set_blocking\nssh_channel_set_counter\nssh_channel_window_size\nssh_channel_write\nssh_channel_write_stderrr#  hX   Apizar#  h
X   127r#  hX   CONTr#  hX   INFORMr#  h]r	#  X	   structurer
#  ah]r#  X   ssh_channelr#  auK}r
#  (hX   55r#  h	X/   What are the functions related to SSH sessions?r#  hX
   Programmerr#  h
NhNhX
   ELICIT-INFORMr#  h]r#  X	   structurer#  ah]r#  X   ssh_sessionr#  auK}r#  (hX   56r#  h	X4   How do I use the ssh_channel_request_exec() command?r#  hX
   Programmerr#  h
X   128r#  hX   FOLr#  hX
   ELICIT-INFORMr#  h]r#  X   patternsr#  ah]r#  X   ssh_channel_request_execr #  auK}r!#  (hX   57r"#  h	X0   Here are the functions related to ssh_session:\nr##  hX   Apizar$#  h
X   129r%#  hX   POSr&#  hX   INFORMr'#  h]r(#  X	   structurer)#  ah]r*#  X   ssh_sessionr+#  auK}r,#  (hX   57r-#  h	X`  ssh_blocking_flush\nssh_clean_pubkey_hash\nssh_connect\nssh_disconnect\nssh_dump_knownhost\nssh_free\nssh_get_cipher_in\nssh_get_cipher_out\nssh_get_clientbanner\nssh_get_disconnect_message\nssh_get_fd\nssh_get_hexa\nssh_get_hmac_in\nssh_get_hmac_out\nssh_get_issue_banner\nssh_get_kex_algo\nssh_get_openssh_version\nssh_get_poll_flags\nssh_get_pubkey_hash\nssh_get_publickey\nssh_get_publickey_hash\nssh_get_serverbanner\nssh_get_server_publickey\nssh_get_status\nssh_get_version\nssh_is_blocking\nssh_is_connected\nssh_is_server_known\nssh_new\nssh_options_copy\nssh_options_get\nssh_options_getopt\nssh_options_get_port\nssh_options_parse_config\nssh_options_set\nssh_print_hexa\nssh_select\nssh_send_debug\nssh_send_ignore\nssh_set_blocking\nssh_set_counters\nssh_set_fd_except\nssh_set_fd_toread\nssh_set_fd_towrite\nssh_silent_disconnect\nssh_write_knownhostr.#  hX   Apizar/#  h
X   131r0#  hX   CONTr1#  hX   INFORMr2#  h]r3#  X	   structurer4#  ah]r5#  X   ssh_sessionr6#  auK}r7#  (hX   58r8#  h	X9   Here is the documentation for ssh_channel_request_exec:\nr9#  hX   Apizar:#  h
X   130r;#  hX   POSr<#  hX   INFORMr=#  hNh]r>#  X   ssh_channel_request_execr?#  auK}r@#  (hX   58rA#  h	XS   int ssh_channel_request_exec\t(\tssh_channel \tchannel,\nconst char * \tcmd \n)\n\nrB#  hX   ApizarC#  h
X   133rD#  hX   CONTrE#  hX   INFORMrF#  h]rG#  X   basicrH#  ah]rI#  X   ssh_channel_request_execrJ#  auK}rK#  (hX   58rL#  h	Xi   Description\nRun a shell command without an interactive shell.\nThis is similar to \'sh -c command\'.\n\nrM#  hX   ApizarN#  h
X   134rO#  hX   CONTrP#  hX   INFORMrQ#  h]rR#  X
   functionalityrS#  ah]rT#  X   ssh_channel_request_execrU#  auK}rV#  (hX   58rW#  h	X   Parameters\nchannel: The channel to execute the command.\ncmd: The command to execute (e.g. "ls ~/ -al | grep -i reports").\n\nrX#  hX   ApizarY#  h
X   135rZ#  hX   CONTr[#  hX   INFORMr\#  h]r]#  (X
   functionalityr^#  X   examplesr_#  eh]r`#  X   ssh_channel_request_execra#  auK}rb#  (hX   58rc#  h	X   Example:\n\nrc = channel_request_exec(channel, "ps aux");\nif (rc &gt; 0) {\n return -1;\n}\nwhile ((rc = channel_read(channel, buffer, sizeof(buffer), 0)) &gt; 0) {\n if (fwrite(buffer, 1, rc, stdout) != (unsigned int) rc) {\n return -1;\n }\n}\n\nrd#  hX   Apizare#  h
X   136rf#  hX   CONTrg#  hX   INFORMrh#  h]ri#  X   examplesrj#  ah]rk#  X   ssh_channel_request_execrl#  auK}rm#  (hX   58rn#  h	X%   See also\nssh_channel_request_shell()ro#  hX   Apizarp#  h
X   137rq#  hX   CONTrr#  hX   INFORMrs#  hNh]rt#  X   ssh_channel_request_execru#  auK}rv#  (hX   59rw#  h	X   Thanks for your help today. rx#  hX
   Programmerry#  h
NhNhX   BE-POSITIVErz#  hNhNuK}r{#  (hX   59r|#  h	X   It was great to meet you!r}#  hX
   Programmerr~#  h
NhNhX   BE-POSITIVEr#  hNhNuK}r#  (hX   60r#  h	X#   What are your plans for the future?r#  hX
   Programmerr#  h
NhNhX
   ELICIT-INFORMr#  hNhNuuuK	}r#  (hhh}r#  (K }r#  (hhh	X   hir#  hX
   Programmerr#  h
NhNhX   BE-POSITIVEr#  hNhNuK}r#  (hhh	X   Hello! r#  hX   Apizar#  h
hhX   POSr#  hX   BE-POSITIVEr#  hNhNuK}r#  (hhh	XE   I'm Apiza: a Virtual Assistant designed to help answer api questions!r#  hX   Apizar#  h
NhNhX   INFORMr#  hNhNuK}r#  (hh+h	X?   what is the API for instantiating connection object for libSSH?r#  hX
   Programmerr#  h
NhNhX
   ELICIT-INFORMr#  h]r#  X   patternsr#  ahNuK}r#  (hh5h	X"   how do I create a new ssh_session?r#  hX
   Programmerr#  h
NhNhX   ELICIT-OFFER-OR-SUGGESTIONr#  h]r#  X   patternsr#  ah]r#  X   ssh_sessionr#  auK}r#  (hh<h	XX   To create a connection in libSSH, you could use the function "ssh_session ssh_new(void)"r#  hX   Apizar#  h
h5hX   POSr#  hX   SUGGESTr#  h]r#  (X   patternsr#  X   basicr#  eh]r#  (X   ssh_sessionr#  X   ssh_newr#  euK}r#  (hhFh	XI   what are the parameters for setting localhost, port number and ip addressr#  hX
   Programmerr#  h
NhNhX
   ELICIT-INFORMr#  h]r#  X   patternsr#  ahNuK}r#  (hhQh	X   how do I conectr#  hX
   Programmerr#  h
NhNhX   ELICIT-OFFER-OR-SUGGESTIONr#  hNhNuK}r#  (hhXh	X   how do I connectr#  hX
   Programmerr#  h
hQhX   REPr#  hX   OTHERr#  h]r#  X   patternsr#  ahNuK	}r#  (hhch	X   According to libssh::ssh_options_set(ssh_session session, enum ssh_options_e type, const void* value), the "type" parameter can be set to: SSH_OPTIONS_HOST for setting a host, SSH_OPTIONS_PORT for setting a port numberr#  hX   Apizar#  h
hFhX   POSr#  hX   INFORMr#  h]r#  (X   patternsr#  X   basicr#  eh]r#  X   ssh_options_setr#  auK
}r#  (hX   10r#  h	XU   To connect in libssh, you can use the function "int ssh_connect(ssh_session session)"r#  hX   Apizar#  h
hXhX   POSr#  hX   SUGGESTr#  h]r#  (X   patternsr#  X   basicr#  eh]r#  X   ssh_connectr#  auK}r#  (hX   11r#  h	X   thanks thats helpfulr#  hX
   Programmerr#  h
X   10r#  hX   POSr#  hX   ASSESSr#  hNhNuK}r#  (hX   12r#  h	X   I am happy to be of service!r#  hX   Apizar#  h
X   11r#  hX   POSr#  hX   BE-POSITIVEr#  hNhNuK
}r#  (hX   13r#  h	X$   how do I authenticate to the server?r#  hX
   Programmerr#  h
NhNhX   ELICIT-OFFER-OR-SUGGESTIONr#  h]r#  X   patternsr#  ahNuK}r#  (hX   14r#  h	X,   There are several authentication functions, r#  hX   Apizar#  h
X   13r#  hX   PARTr#  hX   INFORMr#  h]r#  X	   structurer#  ahNuK}r#  (hX   14r#  h	X#   would you like me to list them all?r#  hX   Apizar#  h
X   14r#  hX   FOLr#  hX   ELICIT-OFFER-OR-SUGGESTIONr#  h]r#  X	   structurer#  ahNuK}r#  (hX   15r#  h	X   just for the serverr#  hX
   Programmerr#  h
X   15r#  hX   PARTr#  hX   SUGGESTr $  h]r$  X	   structurer$  ahNuK}r$  (hX   16r$  h	X,   There are several authentication functions, r$  hX   Apizar$  h
X   16r$  hX   PARTr$  hX   INFORMr	$  h]r
$  X	   structurer$  ahNuK}r$  (hX   16r
$  h	X#   would you like me to list them all?r$  hX   Apizar$  h
X   17r$  hX   FOLr$  hX   ELICIT-OFFER-OR-SUGGESTIONr$  h]r$  X	   structurer$  ahNuK}r$  (hX   17r$  h	X   yesr$  hX
   Programmerr$  h
X   19r$  hX   POSr$  hX   SUGGESTr$  h]r$  X	   structurer$  ahNuK}r$  (hX   18r$  h	XN  int ssh_userauth_gssapi(ssh_session session)\nint ssh_userauth_kbdint(ssh_session session, const char * user, const char * submethods)\nint ssh_userauth_none(ssh_session session, const char * username)\nint ssh_userauth_password(ssh_session session, const char * username, const char * password)\nint ssh_userauth_publickey(ssh_session session, const char * username, const ssh_key privkey)\nint ssh_userauth_publickey_auto(ssh_session session, const char * username, const char * passphrase)\nint ssh_userauth_try_publickey(ssh_session session, const char * username, const ssh_key pubkey)r $  hX   Apizar!$  h
X   14r"$  hX   POSr#$  hX   INFORMr$$  h]r%$  (X	   structurer&$  X   basicr'$  ehNuK}r($  (hX   19r)$  h	X)   do you know the is_server_known function?r*$  hX
   Programmerr+$  h
NhNhX
   ELICIT-INFORMr,$  h]r-$  X   basicr.$  ah]r/$  X   ssh_is_server_knownr0$  auK}r1$  (hX   20r2$  h	X"   how do I create a new ssh_channel?r3$  hX
   Programmerr4$  h
NhNhX   ELICIT-OFFER-OR-SUGGESTIONr5$  h]r6$  X   patternsr7$  ah]r8$  X   ssh_channelr9$  auK}r:$  (hX   21r;$  h	Xy   libssh contains a function "int ssh_is_server_known(ssh_session session)" that can be used to check if a server is known.r<$  hX   Apizar=$  h
X   21r>$  hX   POSr?$  hX   INFORMr@$  h]rA$  (X   patternsrB$  X   basicrC$  eh]rD$  X   ssh_is_server_knownrE$  auK}rF$  (hX   22rG$  h	Xd   to create a new channel, you can use the "ssh_channel ssh_channel_new(ssh_session session)" functionrH$  hX   ApizarI$  h
X   22rJ$  hX   POSrK$  hX   SUGGESTrL$  h]rM$  (X   patternsrN$  X   basicrO$  eh]rP$  (X   ssh_channelrQ$  X   ssh_channel_newrR$  euK}rS$  (hX   23rT$  h	X@   how would i execute the who command in the ssh_channel function?rU$  hX
   ProgrammerrV$  h
NhNhX   ELICIT-OFFER-OR-SUGGESTIONrW$  h]rX$  X   patternsrY$  ah]rZ$  X   ssh_channelr[$  auK}r\$  (hX   24r]$  h	X   I'm sorry, r^$  hX   Apizar_$  h
X   25r`$  hX   UNCra$  hX   BE-POSITIVErb$  hNhNuK}rc$  (hX   24rd$  h	X#   I do not understand your question, re$  hX   Apizarf$  h
X   26rg$  hX   CONTrh$  hX   COMMENT-ABOUT-UNDERSTANDINGri$  hNhNuK}rj$  (hX   24rk$  h	X1   I am only authorized to respond to api questions.rl$  hX   Apizarm$  h
X   25rn$  hX   NEGro$  hX   INFORMrp$  hNhNuK}rq$  (hX   25rr$  h	X$   what is the api for the ssh_channel?rs$  hX
   Programmerrt$  h
NhNhX
   ELICIT-INFORMru$  h]rv$  (X   basicrw$  X	   structurerx$  eh]ry$  X   ssh_channelrz$  auK}r{$  (hX   26r|$  h	X?   There are 47 functions referring to channel objects in libssh, r}$  hX   Apizar~$  h
X   29r$  hX   PARTr$  hX   INFORMr$  h]r$  X	   structurer$  ah]r$  X   ssh_channelr$  auK}r$  (hX   26r$  h	X   to which are you referring?r$  hX   Apizar$  h
X   30r$  hX   FOLr$  hX
   ELICIT-INFORMr$  h]r$  X	   structurer$  ah]r$  X   ssh_channelr$  auK }r$  (hX   27r$  h	X   whor$  hX
   Programmerr$  h
X   31r$  hX   POSr$  hX
   ELICIT-INFORMr$  hNhNuK!}r$  (hX   28r$  h	X   I'm sorry, r$  hX   Apizar$  h
X   32r$  hX   UNCr$  hX   BE-POSITIVEr$  hNhNuK"}r$  (hX   28r$  h	X#   I do not understand your question, r$  hX   Apizar$  h
X   33r$  hX   CONTr$  hX   COMMENT-ABOUT-UNDERSTANDINGr$  hNhNuK#}r$  (hX   28r$  h	X1   I am only authorized to respond to api questions.r$  hX   Apizar$  h
X   32r$  hX   NEGr$  hX   INFORMr$  hNhNuK$}r$  (hX   29r$  h	X-   what does the s_server_known function return?r$  hX
   Programmerr$  h
X   23r$  hX   FOLr$  hX
   ELICIT-INFORMr$  h]r$  X
   functionalityr$  ah]r$  X   ssh_is_server_knownr$  auK%}r$  (hX   30r$  h	X<   what is the data type that is_server_known function returns?r$  hX
   Programmerr$  h
X   36r$  hX   REPr$  hX
   ELICIT-INFORMr$  h]r$  X   basicr$  ah]r$  X   ssh_is_server_knownr$  auK&}r$  (hX   31r$  h	X2   According to libssh: ssh_is_server_known returns: r$  hX   Apizar$  h
X   37r$  hX   POSr$  hX   OTHERr$  h]r$  X
   functionalityr$  ah]r$  X   ssh_is_server_knownr$  auK'}r$  (hX   31r$  h	Xs  Returns\nSSH_SERVER_KNOWN_OK: The server is known and has not changed.\nSSH_SERVER_KNOWN_CHANGED: The server key has changed. Either you are under attack or the administrator changed the key. You HAVE to warn the user about a possible attack.\nSSH_SERVER_FOUND_OTHER: The server gave use a key of a type while we had an other type recorded. It is a possible attack.\nSSH_SERVER_NOT_KNOWN: The server is unknown. User should confirm the MD5 is correct.\nSSH_SERVER_FILE_NOT_FOUND: The known host file does not exist. The host is thus unknown. File will be created if host key is accepted.\nSSH_SERVER_ERROR: Some error happened.r$  hX   Apizar$  h
X   38r$  hX   CONTr$  hX   INFORMr$  h]r$  X
   functionalityr$  ah]r$  X   ssh_is_server_knownr$  auK(}r$  (hX   32r$  h	X   thanksr$  hX
   Programmerr$  h
X   39r$  hX   POSr$  hX   ASSESSr$  hNhNuK)}r$  (hX   33r$  h	X   You're welcome!r$  hX   Apizar$  h
X   40r$  hX   POSr$  hX   BE-POSITIVEr$  hNhNuK*}r$  (hX   34r$  h	X:   how do I execute an SSH command in an established session?r$  hX
   Programmerr$  h
NhNhX   ELICIT-OFFER-OR-SUGGESTIONr$  h]r$  X   patternsr$  ah]r$  X   ssh_sessionr$  auK+}r$  (hX   35r$  h	X   You can attempt to run a shell command without an interactive shell in libssh by using the "int ssh_channel_request_exec(ssh_channel channel, const char* cmd)" functionr$  hX   Apizar$  h
X   42r$  hX   POSr$  hX   SUGGESTr$  h]r$  (X   patternsr$  X   basicr$  eh]r$  X   ssh_channel_request_execr$  auK,}r$  (hX   36r$  h	X"   how do I show the remote username?r$  hX
   Programmerr$  h
NhNhX   ELICIT-OFFER-OR-SUGGESTIONr %  h]r%  X   patternsr%  ahNuK-}r%  (hX   37r%  h	X0   is there a function for showing remote username?r%  hX
   Programmerr%  h
X   44r%  hX   REPr%  hX
   ELICIT-INFORMr	%  h]r
%  X   patternsr%  ahNuK.}r%  (hX   38r
%  h	X   how do I free a channel?r%  hX
   Programmerr%  h
NhNhX   ELICIT-OFFER-OR-SUGGESTIONr%  h]r%  X   patternsr%  ah]r%  X   ssh_channelr%  auK/}r%  (hX   39r%  h	X   how do I shut down a channel?r%  hX
   Programmerr%  h
NhNhX   ELICIT-OFFER-OR-SUGGESTIONr%  h]r%  X   patternsr%  ah]r%  X   ssh_channelr%  auK0}r%  (hX   40r%  h	X   You can attempt to retrieve a username in libssh by using the "int ssh_getpass(const char* prompt, char* buf, size_t len, int echo, int verify)" functionr %  hX   Apizar!%  h
X   45r"%  hX   POSr#%  hX   SUGGESTr$%  h]r%%  (X   patternsr&%  X   basicr'%  eh]r(%  X   ssh_getpassr)%  auK1}r*%  (hX   41r+%  h	Xc   You can free a channel in libssh by using the "void ssh_channel_free(ssh_channel channel)" functionr,%  hX   Apizar-%  h
X   46r.%  hX   POSr/%  hX   SUGGESTr0%  h]r1%  (X   patternsr2%  X   basicr3%  eh]r4%  (X   ssh_channelr5%  X   ssh_channel_freer6%  euK2}r7%  (hX   42r8%  h	Xd   You can close a channel in libssh by using the "int ssh_channel_close(ssh_channel channel)" functionr9%  hX   Apizar:%  h
X   47r;%  hX   POSr<%  hX   SUGGESTr=%  h]r>%  (X   patternsr?%  X   basicr@%  eh]rA%  (X   ssh_channelrB%  X   ssh_channel_closerC%  euK3}rD%  (hX   43rE%  h	X   ok. rF%  hX
   ProgrammerrG%  h
NhNhX   ASSESSrH%  hNhNuK4}rI%  (hX   43rJ%  h	X-   what is the api for creating an SFTP session?rK%  hX
   ProgrammerrL%  h
NhNhX
   ELICIT-INFORMrM%  h]rN%  X   patternsrO%  ah]rP%  X   sftp_sessionrQ%  auK5}rR%  (hX   44rS%  h	X^   You can create a sftp session using the "sftp_session sftp_new(ssh_session session)" function.rT%  hX   ApizarU%  h
X   52rV%  hX   POSrW%  hX   SUGGESTrX%  h]rY%  (X   patternsrZ%  X   basicr[%  eh]r\%  (X   sftp_sessionr]%  X   sftp_newr^%  euK6}r_%  (hX   45r`%  h	X;   what functions are available on the sftp_session interface?ra%  hX
   Programmerrb%  h
NhNhX
   ELICIT-INFORMrc%  h]rd%  X	   structurere%  ah]rf%  X   sftp_sessionrg%  auK7}rh%  (hX   46ri%  h	X;   There are 49 functions associated with ssh_session objects,rj%  hX   Apizark%  h
X   54rl%  hX   PARTrm%  hX   INFORMrn%  h]ro%  X	   structurerp%  ah]rq%  X   sftp_sessionrr%  auK8}rs%  (hX   46rt%  h	X#   would you like me to list them all?ru%  hX   Apizarv%  h
X   55rw%  hX   FOLrx%  hX   ELICIT-OFFER-OR-SUGGESTIONry%  h]rz%  X	   structurer{%  ah]r|%  X   sftp_sessionr}%  auK9}r~%  (hX   47r%  h	X(   just for creating a file and a directoryr%  hX
   Programmerr%  h
X   56r%  hX   PARTr%  hX   SUGGESTr%  h]r%  X	   structurer%  ah]r%  X   sftp_sessionr%  auK:}r%  (hX   48r%  h	X   You can open a file in libssh using the "sftp_file sftp_open(sftp_session session, const char* file, int accesstype, mode_t mode)" functionr%  hX   Apizar%  h
X   54r%  hX   POSr%  hX   SUGGESTr%  h]r%  (X   patternsr%  X   basicr%  eh]r%  (X   sftp_sessionr%  X	   sftp_openr%  euK;}r%  (hX   49r%  h	Xu   You can open a directory in libssh using the "sftp_dir sftp_opendir(sftp_session session, const char* file)" functionr%  hX   Apizar%  h
X   59r%  hX   CONTr%  hX   SUGGESTr%  h]r%  (X   patternsr%  X   basicr%  eh]r%  (X   sftp_sessionr%  X   sftp_opendirr%  euK<}r%  (hX   50r%  h	X   how do I free an sftp session?r%  hX
   Programmerr%  h
NhNhX   ELICIT-OFFER-OR-SUGGESTIONr%  h]r%  X   patternsr%  ah]r%  X   sftp_sessionr%  auK=}r%  (hX   51r%  h	X_   You can free a sftp_session in libssh by using the "void sftp_free(sftp_session sftp)" functionr%  hX   Apizar%  h
X   60r%  hX   POSr%  hX   SUGGESTr%  h]r%  (X   patternsr%  X   basicr%  eh]r%  (X   sftp_sessionr%  X	   sftp_freer%  euK>}r%  (hX   52r%  h	X   thanksr%  hX
   Programmerr%  h
X   61r%  hX   POSr%  hX   ASSESSr%  hNhNuK?}r%  (hX   53r%  h	X   You're welcome!r%  hX   Apizar%  h
X   62r%  hX   POSr%  hX   BE-POSITIVEr%  hNhNuK@}r%  (hX   54r%  h	XN   what are possible return values when creating a file with sftp_file interface?r%  hX
   Programmerr%  h
NhNhX
   ELICIT-INFORMr%  h]r%  X
   functionalityr%  ah]r%  X	   sftp_filer%  auKA}r%  (hX   55r%  h	X,   in libssh, the function "sftp_open" returns:r%  hX   Apizar%  h
X   64r%  hX   POSr%  hX   OTHERr%  h]r%  X
   functionalityr%  ah]r%  X	   sftp_openr%  auKB}r%  (hX   55r%  h	XG   Returns\nA sftp file handle, NULL on error with ssh and sftp error set.r%  hX   Apizar%  h
X   65r%  hX   CONTr%  hX   INFORMr%  h]r%  X
   functionalityr%  ah]r%  X	   sftp_openr%  auKC}r%  (hX   56r%  h	X3   what arguments does the sftp_mkdir function accept?r%  hX
   Programmerr%  h
NhNhX
   ELICIT-INFORMr%  h]r%  (X
   functionalityr%  X   basicr%  eh]r%  X
   sftp_mkdirr%  auKD}r%  (hX   57r%  h	Xu   In libssh, the function "sftp_mkdir" has signature "sftp_mkdir(sft_session sftp, const char* directory, mode_t mode)"r%  hX   Apizar%  h
X   68r%  hX   POSr%  hX   INFORMr%  h]r%  X   basicr%  ah]r%  X
   sftp_mkdirr%  auuuK
}r%  (hhh}r%  (K }r%  (hhh	X    How to create a new ssh session?r%  hX
   Programmerr%  h
NhNhX   ELICIT-OFFER-OR-SUGGESTIONr &  h]r&  X   patternsr&  ah]r&  X   ssh_sessionr&  auK}r&  (hhh	XI   To create a new session, use ssh_new with signature ssh_session ssh_new()r&  hX   Apizar&  h
hhX   POSr&  hX   SUGGESTr	&  h]r
&  (X   patternsr&  X   basicr&  eh]r
&  (X   ssh_sessionr&  X   ssh_newr&  euK}r&  (hh+h	X   what is the signature?r&  hX
   Programmerr&  h
hhX   FOLr&  hX
   ELICIT-INFORMr&  h]r&  X   conceptsr&  ahNuK}r&  (hh5h	X4   The method signature explains how to call the methodr&  hX   Apizar&  h
hhX   POSr&  hX   INFORMr&  h]r&  X   conceptsr&  ahNuK}r&  (hh<h	X)   what parameters has the method ssh_new()?r&  hX
   Programmerr &  h
hhX   FOLr!&  hX
   ELICIT-INFORMr"&  h]r#&  X   basicr$&  ah]r%&  X   ssh_newr&&  auK}r'&  (hhFh	X#   There are no parameters for ssh_newr(&  hX   Apizar)&  h
h5hX   POSr*&  hX   INFORMr+&  h]r,&  X   basicr-&  ah]r.&  X   ssh_newr/&  auK}r0&  (hhQh	X#   what type of values does it return?r1&  hX
   Programmerr2&  h
hhX   FOLr3&  hX
   ELICIT-INFORMr4&  h]r5&  X   basicr6&  ah]r7&  X   ssh_newr8&  auK}r9&  (hhXh	X,   ssh_new return ssh_session or NULL on error.r:&  hX   Apizar;&  h
hFhX   POSr<&  hX   INFORMr=&  h]r>&  X   basicr?&  ah]r@&  X   ssh_newrA&  auK}rB&  (hhch	X   How to connect to the server?rC&  hX
   ProgrammerrD&  h
NhNhX   ELICIT-OFFER-OR-SUGGESTIONrE&  h]rF&  X   patternsrG&  ahNuK	}rH&  (hX   10rI&  h	X-   To connect to the ssh server, use ssh_connectrJ&  hX   ApizarK&  h
hXhX   POSrL&  hX   SUGGESTrM&  h]rN&  X   patternsrO&  ah]rP&  X   ssh_connectrQ&  auK
}rR&  (hX   11rS&  h	X   is ssh_connect a function?rT&  hX
   ProgrammerrU&  h
hchX   FOLrV&  hX
   ELICIT-INFORMrW&  h]rX&  X   basicrY&  ah]rZ&  X   ssh_connectr[&  auK}r\&  (hX   12r]&  h	X   yesr^&  hX   Apizar_&  h
X   10r`&  hX   POSra&  hX   INFORMrb&  h]rc&  X   basicrd&  ah]re&  X   ssh_connectrf&  auK}rg&  (hX   13rh&  h	X   what parameters does it take?ri&  hX
   Programmerrj&  h
hchX   FOLrk&  hX
   ELICIT-INFORMrl&  h]rm&  X   basicrn&  ah]ro&  X   ssh_connectrp&  auK
}rq&  (hX   14rr&  h	X?   It takes in one parameter: a session with data type ssh_sessionrs&  hX   Apizart&  h
X   12ru&  hX   POSrv&  hX   INFORMrw&  h]rx&  X   basicry&  ah]rz&  X   ssh_connectr{&  auK}r|&  (hX   15r}&  h	X<   The method signature is int ssh_connect(ssh_session session)r~&  hX   Apizar&  h
X   13r&  hX   FOLr&  hX   INFORMr&  h]r&  X   basicr&  ah]r&  X   ssh_connectr&  auK}r&  (hX   16r&  h	X   what value does it return?r&  hX
   Programmerr&  h
hchX   FOLr&  hX
   ELICIT-INFORMr&  h]r&  X   basicr&  ah]r&  X   ssh_connectr&  auK}r&  (hX   17r&  h	X   ok iunderstandr&  hX
   Programmerr&  h
X   15r&  hX   NEGr&  hX   ASSESSr&  hNhNuK}r&  (hX   18r&  h	X5   how to specify the exact server i want to connect to?r&  hX
   Programmerr&  h
hchX   FOLr&  hX   ELICIT-OFFER-OR-SUGGESTIONr&  h]r&  X   patternsr&  ah]r&  X   ssh_connectr&  auK}r&  (hX   19r&  h	X/   You can use the method ssh_options_set for thatr&  hX   Apizar&  h
X   17r&  hX   POSr&  hX   SUGGESTr&  h]r&  X   patternsr&  ah]r&  X   ssh_options_setr&  auK}r&  (hX   20r&  h	Xm   The method signature is int ssh_options_set(ssh_session session, enum ssh_options_e type, const void * value)r&  hX   Apizar&  h
X   18r&  hX   CONTr&  hX   INFORMr&  h]r&  X   basicr&  ah]r&  X   ssh_options_setr&  auK}r&  (hX   21r&  h	X=   what is the relationship between ssh_connect and ssh_options?r&  hX
   Programmerr&  h
NhNhX
   ELICIT-INFORMr&  h]r&  X	   structurer&  ah]r&  (X   ssh_options_setr&  X   ssh_connectr&  euK}r&  (hX   22r&  h	XC   ssh_options_set is a function that can set all possible ssh optionsr&  hX   Apizar&  h
X   20r&  hX   POSr&  hX   INFORMr&  h]r&  X
   functionalityr&  ah]r&  X   ssh_options_setr&  auK}r&  (hX   23r&  h	XR   The enum ssh_options_e can be values such as SSH_OPTIONS_HOST and SSH_OPTIONS_PORTr&  hX   Apizar&  h
X   21r&  hX   CONTr&  hX   INFORMr&  h]r&  X   patternsr&  ah]r&  X   ssh_options_setr&  auK}r&  (hX   24r&  h	X9   is ssh_options enough by itself to connect to the server?r&  hX
   Programmerr&  h
X   22r&  hX   FOLr&  hX
   ELICIT-INFORMr&  h]r&  X
   functionalityr&  ah]r&  X   ssh_options_setr&  auK}r&  (hX   25r&  h	X.   or i should use it first then use ssh_connect?r&  hX
   Programmerr&  h
X   23r&  hX   CONTr&  hX   ELICIT-OFFER-OR-SUGGESTIONr&  h]r&  X   patternsr&  ah]r&  (X   ssh_options_setr&  X   ssh_connectr&  euK}r&  (hX   26r&  h	X,   The method ssh_options_set sets the options.r&  hX   Apizar&  h
X   23r&  hX   POSr&  hX   INFORMr&  h]r&  X
   functionalityr&  ah]r&  X   ssh_options_setr&  auK}r&  (hX   27r&  h	X7   the right order is ssh_options then ssh_connect, right?r&  hX
   Programmerr&  h
X   25r&  hX   FOLr&  hX
   ELICIT-INFORMr '  h]r'  X   patternsr'  ah]r'  (X   ssh_options_setr'  X   ssh_connectr'  euK}r'  (hX   28r'  h	X
   I'm sorry,r'  hX   Apizar	'  h
X   26r
'  hX   NEGr'  hX   BE-POSITIVEr'  hNhNuK}r
'  (hX   28r'  h	X*    I'm only able to respond to API questionsr'  hX   Apizar'  h
X   27r'  hX   CONTr'  hX   INFORMr'  hNhNuK}r'  (hX   29r'  h	X+   what is the third parameter in ssh_options?r'  hX
   Programmerr'  h
X   19r'  hX   FOLr'  hX
   ELICIT-INFORMr'  h]r'  (X
   functionalityr'  X   basicr'  eh]r'  X   ssh_options_setr'  auK}r '  (hX   30r!'  h	Xz   value: The value to set. This is a generic pointer and the datatype which is used should be set according to the type set.r"'  hX   Apizar#'  h
X   29r$'  hX   POSr%'  hX   INFORMr&'  h]r''  X
   functionalityr('  ah]r)'  X   ssh_options_setr*'  auK}r+'  (hX   31r,'  h	X!   how to connect to the local host?r-'  hX
   Programmerr.'  h
NhNhX   ELICIT-OFFER-OR-SUGGESTIONr/'  h]r0'  X   patternsr1'  ahNuK }r2'  (hX   32r3'  h	X-   To connect to the ssh server, use ssh_connectr4'  hX   Apizar5'  h
X   31r6'  hX   POSr7'  hX   SUGGESTr8'  h]r9'  X   patternsr:'  ah]r;'  X   ssh_connectr<'  auK!}r='  (hX   33r>'  h	X   how to authenticate the server?r?'  hX
   Programmerr@'  h
NhNhX   ELICIT-OFFER-OR-SUGGESTIONrA'  h]rB'  X   patternsrC'  ahNuK"}rD'  (hX   34rE'  h	X2   There are many different types of authentication, rF'  hX   ApizarG'  h
X   33rH'  hX   PARTrI'  hX   INFORMrJ'  h]rK'  (X	   structurerL'  X   patternsrM'  ehNuK#}rN'  (hX   34rO'  h	X   would you like me to list them?rP'  hX   ApizarQ'  h
X   34rR'  hX   FOLrS'  hX   ELICIT-OFFER-OR-SUGGESTIONrT'  h]rU'  (X	   structurerV'  X   patternsrW'  ehNuK$}rX'  (hX   35rY'  h	X   yesrZ'  hX
   Programmerr['  h
X   35r\'  hX   POSr]'  hX   SUGGESTr^'  h]r_'  X	   structurer`'  ahNuK%}ra'  (hX   36rb'  h	X  ssh_userauth_agent\nssh_userauth_gssapi\nssh_userauth_kbdint\nssh_userauth_kbdint_getanswer\nssh_userauth_kbdint_getinstruction\nssh_userauth_kbdint_getname\nssh_userauth_kbdint_getnanswers\nssh_userauth_kbdint_getnprompts\nssh_userauth_kbdint_getprompt\nssh_userauth_kbdint_setanswer\nssh_userauth_list\nssh_userauth_none\nssh_userauth_password\nssh_userauth_publickey\nssh_userauth_publickey_auto\nssh_userauth_try_publickeyrc'  hX   Apizard'  h
X   33re'  hX   POSrf'  hX   INFORMrg'  h]rh'  X	   structureri'  ahNuK&}rj'  (hX   37rk'  h	X-   what is the method for server authentication?rl'  hX
   Programmerrm'  h
X   37rn'  hX   FOLro'  hX
   ELICIT-INFORMrp'  h]rq'  X   patternsrr'  ahNuK'}rs'  (hX   38rt'  h	X$   There are many ways to authenticate,ru'  hX   Apizarv'  h
X   38rw'  hX   NEGrx'  hX   INFORMry'  h]rz'  X   patternsr{'  ahNuK(}r|'  (hX   38r}'  h	X   they are listed abover~'  hX   Apizar'  h
X   39r'  hX   CONTr'  hX   INFORMr'  hNhNuK)}r'  (hX   39r'  h	X    what does ssh_userauth_agent do?r'  hX
   Programmerr'  h
X   37r'  hX   FOLr'  hX
   ELICIT-INFORMr'  h]r'  X
   functionalityr'  ah]r'  X   ssh_userauth_agentr'  auK*}r'  (hX   40r'  h	XP   ssh_userauth_agent is used to try to do public key authentication with ssh agentr'  hX   Apizar'  h
X   41r'  hX   POSr'  hX   INFORMr'  h]r'  X
   functionalityr'  ah]r'  X   ssh_userauth_agentr'  auK+}r'  (hX   41r'  h	X   what is server authentication?r'  hX
   Programmerr'  h
NhNhX
   ELICIT-INFORMr'  h]r'  X   conceptsr'  ahNuK,}r'  (hX   42r'  h	X$   There are many ways to authenticate,r'  hX   Apizar'  h
X   43r'  hX   NEGr'  hX   INFORMr'  h]r'  X   patternsr'  ahNuK-}r'  (hX   42r'  h	X   they are listed abover'  hX   Apizar'  h
X   44r'  hX   CONTr'  hX   INFORMr'  hNhNuK.}r'  (hX   43r'  h	X   authenticating ssh server?r'  hX
   Programmerr'  h
NhNhX
   ELICIT-INFORMr'  h]r'  X   patternsr'  ahNuK/}r'  (hX   44r'  h	X1   There are many different types of authentication,r'  hX   Apizar'  h
X   47r'  hX   PARTr'  hX   INFORMr'  h]r'  X   patternsr'  ahNuK0}r'  (hX   44r'  h	X   would you like me to list them?r'  hX   Apizar'  h
X   48r'  hX   FOLr'  hX   ELICIT-OFFER-OR-SUGGESTIONr'  hNhNuK1}r'  (hX   45r'  h	X   how to authenticate the user?r'  hX
   Programmerr'  h
NhNhX   ELICIT-OFFER-OR-SUGGESTIONr'  h]r'  X   patternsr'  ahNuK2}r'  (hX   46r'  h	XD   Authentication can be performed with one of the following methods:\nr'  hX   Apizar'  h
X   49r'  hX   POSr'  hX   SUGGESTr'  h]r'  (X   patternsr'  X	   structurer'  ehNuK3}r'  (hX   46r'  h	X  ssh_userauth_agent\nssh_userauth_gssapi\nssh_userauth_kbdint\nssh_userauth_kbdint_getanswer\nssh_userauth_kbdint_getinstruction\nssh_userauth_kbdint_getname\nssh_userauth_kbdint_getnanswers\nssh_userauth_kbdint_getnprompts\nssh_userauth_kbdint_getprompt\nssh_userauth_kbdint_setanswer\nssh_userauth_list\nssh_userauth_none\nssh_userauth_password\nssh_userauth_publickey\nssh_userauth_publickey_auto\nssh_userauth_try_publickeyr'  hX   Apizar'  h
X   50r'  hX   CONTr'  hX   INFORMr'  h]r'  X	   structurer'  ahNuK4}r'  (hX   47r'  h	X&   Would you like to know more about one?r'  hX   Apizar'  h
X   51r'  hX   FOLr'  hX
   ELICIT-INFORMr'  h]r'  X   basicr'  ahNuK5}r'  (hX   48r'  h	X   ssh_userauth_noner'  hX
   Programmerr'  h
X   51r'  hX   FOLr'  hX   INFORMr'  h]r'  X   basicr'  ah]r'  X   ssh_userauth_noner'  auK6}r'  (hX   49r'  h	XH   ssh_userauth_none method tries to authenticate through the "none" methodr'  hX   Apizar'  h
X   53r'  hX   POSr'  hX   INFORMr'  h]r'  X
   functionalityr'  ah]r'  X   ssh_userauth_noner'  auK7}r (  (hX   50r(  h	X   what is the "none" method?r(  hX
   Programmerr(  h
X   54r(  hX   FOLr(  hX
   ELICIT-INFORMr(  h]r(  X   conceptsr(  ah]r	(  X   ssh_userauth_noner
(  auK8}r(  (hX   51r(  h	X3   The none method does not perform any authenticationr
(  hX   Apizar(  h
X   55r(  hX   POSr(  hX   INFORMr(  h]r(  X   conceptsr(  ah]r(  X   ssh_userauth_noner(  auK9}r(  (hX   52r(  h	X,   what is the signature of ssh_userauth_agent?r(  hX
   Programmerr(  h
X   51r(  hX   FOLr(  hX
   ELICIT-INFORMr(  h]r(  X   basicr(  ah]r(  X   ssh_userauth_agentr (  auK:}r!(  (hX   53r"(  h	XP   The signature is ssh_userauth_agent (ssh_session session, const char * username)r#(  hX   Apizar$(  h
X   57r%(  hX   POSr&(  hX   INFORMr'(  h]r((  X   basicr)(  ah]r*(  X   ssh_userauth_agentr+(  auK;}r,(  (hX   54r-(  h	XT   The signature is int ssh_userauth_agent (ssh_session session, const char * username)r.(  hX   Apizar/(  h
X   58r0(  hX   REPr1(  hX   INFORMr2(  h]r3(  X   basicr4(  ah]r5(  X   ssh_userauth_agentr6(  auK<}r7(  (hX   55r8(  h	X-   what is the signature of ssh_userauth_gssapi?r9(  hX
   Programmerr:(  h
X   51r;(  hX   FOLr<(  hX
   ELICIT-INFORMr=(  h]r>(  X   basicr?(  ah]r@(  X   ssh_userauth_gssapirA(  auK=}rB(  (hX   56rC(  h	X>   The signature is int ssh_userauth_gssapi (ssh_session session)rD(  hX   ApizarE(  h
X   61rF(  hX   POSrG(  hX   INFORMrH(  h]rI(  X   basicrJ(  ah]rK(  X   ssh_userauth_gssapirL(  auK>}rM(  (hX   57rN(  h	X,   what does the method ssh_userauth_gssapi do?rO(  hX
   ProgrammerrP(  h
X   51rQ(  hX   FOLrR(  hX
   ELICIT-INFORMrS(  h]rT(  X
   functionalityrU(  ah]rV(  X   ssh_userauth_gssapirW(  auK?}rX(  (hX   58rY(  h	XU   ssh_userauth_gssapi method tries to authenticate through the "gssapi-with-mic" methodrZ(  hX   Apizar[(  h
X   62r\(  hX   POSr](  hX   INFORMr^(  h]r_(  X
   functionalityr`(  ah]ra(  X   ssh_userauth_gssapirb(  auK@}rc(  (hX   59rd(  h	X   what is the "gssapi-with-mic"?re(  hX
   Programmerrf(  h
X   63rg(  hX   FOLrh(  hX
   ELICIT-INFORMri(  h]rj(  X   conceptsrk(  ah]rl(  X   ssh_userauth_gssapirm(  auKA}rn(  (hX   60ro(  h	X
   I'm sorry,rp(  hX   Apizarq(  h
X   64rr(  hX   NEGrs(  hX   BE-POSITIVErt(  hNhNuKB}ru(  (hX   60rv(  h	X     I can only answer API questionsrw(  hX   Apizarx(  h
X   65ry(  hX   CONTrz(  hX   INFORMr{(  hNhNuKC}r|(  (hX   61r}(  h	X&   how to know i connected to the server?r~(  hX
   Programmerr(  h
NhNhX   ELICIT-OFFER-OR-SUGGESTIONr(  h]r(  X   patternsr(  ahNuKD}r(  (hX   62r(  h	X   ssh_connect returns an integer representing the status of the action: SSH_OK on success, SSH_ERROR on error.\nSSH_AGAIN, if the session is in nonblocking mode, and call must be done again.r(  hX   Apizar(  h
X   67r(  hX   POSr(  hX   INFORMr(  h]r(  X
   functionalityr(  ah]r(  X   ssh_connectr(  auKE}r(  (hX   63r(  h	X4   what does -1 means as a return value of ssh_connect?r(  hX
   Programmerr(  h
X   68r(  hX   FOLr(  hX
   ELICIT-INFORMr(  h]r(  X
   functionalityr(  ah]r(  X   ssh_connectr(  auKF}r(  (hX   64r(  h	X   ssh_connect returns an integer representing the status of the action: SSH_OK on success, SSH_ERROR on error.\nSSH_AGAIN, if the session is in nonblocking mode, and call must be done again.r(  hX   Apizar(  h
X   69r(  hX   PARTr(  hX   INFORMr(  h]r(  X
   functionalityr(  ah]r(  X   ssh_connectr(  auKG}r(  (hX   65r(  h	X"   how to call ssh_userauth_password?r(  hX
   Programmerr(  h
NhNhX   ELICIT-OFFER-OR-SUGGESTIONr(  h]r(  X   patternsr(  ah]r(  X   ssh_userauth_passwordr(  auKH}r(  (hX   66r(  h	Xm   The signature is int ssh_userauth_password(ssh_session session, const char * username, const char * password)r(  hX   Apizar(  h
X   71r(  hX   POSr(  hX   INFORMr(  h]r(  X   basicr(  ah]r(  X   ssh_userauth_passwordr(  auKI}r(  (hX   67r(  h	X   and the return value?r(  hX
   Programmerr(  h
X   72r(  hX   FOLr(  hX
   ELICIT-INFORMr(  h]r(  X
   functionalityr(  ah]r(  X   ssh_userauth_passwordr(  auKJ}r(  (hX   68r(  h	X  Returns:\nSSH_AUTH_ERROR: A serious error happened.\nSSH_AUTH_DENIED: Authentication failed: use another method\nSSH_AUTH_PARTIAL: You've been partially authenticated, you still have to use another method\nSSH_AUTH_SUCCESS: Authentication success\nSSH_AUTH_AGAIN: In nonblocking mode, you've got to call this again later.\nNote\nMost server implementations do not permit changing the username during authentication. The username should only be set with ssh_options_set() only before you connect to the server.r(  hX   Apizar(  h
X   73r(  hX   POSr(  hX   INFORMr(  h]r(  (X
   functionalityr(  X
   directivesr(  eh]r(  X   ssh_userauth_passwordr(  auKK}r(  (hX   69r(  h	X-   how to set the username in ssh_options_set()?r(  hX
   Programmerr(  h
NhNhX   ELICIT-OFFER-OR-SUGGESTIONr(  h]r(  X   patternsr(  ah]r(  X   ssh_options_setr(  auKL}r(  (hX   70r(  h	X0   ssh_options_set takes in an enum ssh_options_e. r(  hX   Apizar(  h
X   75r(  hX   POSr(  hX   INFORMr(  h]r(  X   patternsr(  ah]r(  X   ssh_options_setr(  auKM}r(  (hX   70r(  h	X2   One of the values of that enum is SSH_OPTIONS_USERr(  hX   Apizar(  h
X   76r(  hX   CONTr(  hX   INFORMr(  h]r(  X   patternsr(  ah]r(  X   ssh_options_setr(  auKN}r(  (hX   71r(  h	X1   what should be the value for SSH_OPTIONS_USER&gt;r(  hX
   Programmerr(  h
X   77r(  hX   FOLr(  hX
   ELICIT-INFORMr(  h]r(  X   patternsr(  ah]r(  X   ssh_options_setr(  auKO}r(  (hX   72r(  h	jW	  hX
   Programmerr(  h
X   78r(  hX   CONTr(  hX   OTHERr(  hNhNuKP}r(  (hX   73r )  h	X   SSH_OPTIONS_USER: The username for authentication (const char *).\n\nIf the value is NULL, the username is set to the default username.r)  hX   Apizar)  h
X   79r)  hX   POSr)  hX   INFORMr)  h]r)  X
   functionalityr)  ahNuKQ}r)  (hX   74r	)  h	X"   how to disconnect from the server?r
)  hX
   Programmerr)  h
NhNhX   ELICIT-OFFER-OR-SUGGESTIONr)  h]r
)  X   patternsr)  ahNuKR}r)  (hX   75r)  h	X!   To disconnect, use ssh_disconnectr)  hX   Apizar)  h
X   81r)  hX   POSr)  hX   SUGGESTr)  h]r)  X   patternsr)  ah]r)  X   ssh_disconnectr)  auKS}r)  (hX   75r)  h	X8   with signature: void ssh_disconnect(ssh_session session)r)  hX   Apizar)  h
X   82r)  hX   CONTr)  hX   INFORMr )  h]r!)  X   basicr")  ah]r#)  X   ssh_disconnectr$)  auKT}r%)  (hX   76r&)  h	X   what value does it return?r')  hX
   Programmerr()  h
X   83r))  hX   FOLr*)  hX
   ELICIT-INFORMr+)  h]r,)  (X   basicr-)  X
   functionalityr.)  eh]r/)  X   ssh_disconnectr0)  auKU}r1)  (hX   77r2)  h	X   It does not return a valuer3)  hX   Apizar4)  h
X   84r5)  hX   POSr6)  hX   INFORMr7)  h]r8)  X   basicr9)  ah]r:)  X   ssh_disconnectr;)  auKV}r<)  (hX   78r=)  h	X   how to open a new ssh session?r>)  hX
   Programmerr?)  h
NhNhX   ELICIT-OFFER-OR-SUGGESTIONr@)  h]rA)  X   patternsrB)  ah]rC)  X   ssh_sessionrD)  auKW}rE)  (hX   79rF)  h	X(   To create a new ssh session, use ssh_newrG)  hX   ApizarH)  h
X   86rI)  hX   POSrJ)  hX   SUGGESTrK)  h]rL)  X   patternsrM)  ah]rN)  (X   ssh_sessionrO)  X   ssh_newrP)  euKX}rQ)  (hX   80rR)  h	X(   how to execute a command in the channel?rS)  hX
   ProgrammerrT)  h
NhNhX   ELICIT-OFFER-OR-SUGGESTIONrU)  h]rV)  X   patternsrW)  ahNuKY}rX)  (hX   81rY)  h	XQ   To run a shell command without an interactive shell, use ssh_channel_request_execrZ)  hX   Apizar[)  h
X   88r\)  hX   POSr])  hX   SUGGESTr^)  h]r_)  X   patternsr`)  ah]ra)  X   ssh_channel_request_execrb)  auKZ}rc)  (hX   82rd)  h	X"   This is similar to 'sh -c command're)  hX   Apizarf)  h
X   89rg)  hX   FOLrh)  hX   INFORMri)  h]rj)  X
   functionalityrk)  ah]rl)  X   ssh_channel_request_execrm)  auK[}rn)  (hX   83ro)  h	X2   what is the signature of ssh_channel_request_exec?rp)  hX
   Programmerrq)  h
NhNhX
   ELICIT-INFORMrr)  h]rs)  X   basicrt)  ah]ru)  X   ssh_channel_request_execrv)  auK\}rw)  (hX   84rx)  h	XF   int ssh_channel_request_exec ( ssh_channel channel, const char * cmd )ry)  hX   Apizarz)  h
X   91r{)  hX   POSr|)  hX   INFORMr})  h]r~)  X   basicr)  ah]r)  X   ssh_channel_request_execr)  auuuK}r)  (hhh}r)  (K }r)  (hhh	X   Hello Apiza,r)  hX
   Programmerr)  h
NhNhX   BE-POSITIVEr)  hNhNuK}r)  (hhh	X/   are the functions of libssh preceeded by 'ssh'?r)  hX
   Programmerr)  h
NhNhX
   ELICIT-INFORMr)  h]r)  X   conceptsr)  ahNuK}r)  (hhh	X   Hi Programmer_11.r)  hX   Apizar)  h
hhX   POSr)  hX   BE-POSITIVEr)  hNhNuK}r)  (hhh	X7   Most of the functions of LibSSH are preceded by `ssh`. r)  hX   Apizar)  h
hhX   POSr)  hX   INFORMr)  h]r)  X   conceptsr)  ahNuK}r)  (hhh	X   An example is `ssh_basename`. r)  hX   Apizar)  h
h+hX   CONTr)  hX   INFORMr)  hNhNuK}r)  (hhh	X*   Some functions are not preceded by `ssh`, r)  hX   Apizar)  h
h5hX   CONTr)  hX   INFORMr)  h]r)  X   conceptsr)  ahNuK}r)  (hhh	X#   for example, `channel_read_buffer`.r)  hX   Apizar)  h
h<hX   CONTr)  hX   INFORMr)  hNhNuK}r)  (hh+h	XB   Is there a function to set the options of the connection in LibSSHr)  hX
   Programmerr)  h
NhNhX
   ELICIT-INFORMr)  h]r)  X   patternsr)  ahNuK}r)  (hh5h	X-   And which is the code if the server is known?r)  hX
   Programmerr)  h
NhNhX
   ELICIT-INFORMr)  h]r)  X
   functionalityr)  ahNuK	}r)  (hh<h	X   How about this function?\n\nr)  hX   Apizar)  h
hQhX   POSr)  hX   ELICIT-ASSESSMENTr)  hNh]r)  X   ssh_options_setr)  auK
}r)  (hh<h	Xj   ```\nint ssh_options_set ( ssh_session session,\nenum ssh_options_e type,\nconst void * value \n)\n```\n\nr)  hX   Apizar)  h
hchX   CONTr)  hX   INFORMr)  h]r)  X   basicr)  ah]r)  X   ssh_options_setr)  auK}r)  (hh<h	X@   Description\nThis function can set all possible ssh options.\n\nr)  hX   Apizar)  h
X   10r)  hX   CONTr)  hX   INFORMr)  h]r)  X
   functionalityr)  ah]r)  X   ssh_options_setr)  auK}r)  (hh<h	X@   Let me know if you would like to see the complete documentation.r)  hX   Apizar)  h
X   11r)  hX   FOLr)  hX   ELICIT-OFFER-OR-SUGGESTIONr)  h]r)  X
   functionalityr)  ah]r)  X   ssh_options_setr)  auK
}r)  (hhFh	X   Please, r)  hX
   Programmerr)  h
X   11r)  hX   FOLr)  hX   BE-POSITIVEr)  hNhNuK}r)  (hhFh	X3   show me the complete documentation of this functionr)  hX
   Programmerr)  h
X   13r)  hX   CONTr)  hX   SUGGESTr)  h]r)  X   basicr)  ah]r)  X   ssh_options_setr)  auK}r)  (hhQh	Xi   ```\r\nint ssh_options_set(ssh_session session,\r\nenum ssh_options_e type,\r\nconst void * value \r\n)\rr)  hX   Apizar)  h
X   14r)  hX   POSr)  hX   INFORMr)  h]r)  X   basicr)  ah]r)  X   ssh_options_setr)  auK}r)  (hhXh	X*   What about the parameters of the function?r)  hX
   Programmerr)  h
X   15r)  hX   FOLr)  hX
   ELICIT-INFORMr)  h]r)  X
   functionalityr)  ah]r)  X   ssh_options_setr)  auK}r)  (hhch	X   Ok,r *  hX
   Programmerr*  h
X   16r*  hX   NEGr*  hX   ASSESSr*  hNhNuK}r*  (hhch	X   I have seen itr*  hX
   Programmerr*  h
X   17r*  hX   CONTr	*  hX   INFORMr
*  hNh]r*  X   ssh_options_setr*  auK}r
*  (hX   10r*  h	X0   And the constant of the server when it is known?r*  hX
   Programmerr*  h
NhNhX
   ELICIT-INFORMr*  h]r*  X
   functionalityr*  ahNuK}r*  (hX   11r*  h	X$   I'm not sure what you mean by that. r*  hX   Apizar*  h
X   19r*  hX   UNCr*  hX   COMMENT-ABOUT-UNDERSTANDINGr*  hNhNuK}r*  (hX   11r*  h	X'   Which constant are you wondering about?r*  hX   Apizar*  h
X   19r*  hX   FOLr *  hX
   ELICIT-INFORMr!*  hNhNuK}r"*  (hX   12r#*  h	X4   I want to know the constant when the server is knownr$*  hX
   Programmerr%*  h
X   21r&*  hX   POSr'*  hX   INFORMr(*  h]r)*  X
   functionalityr**  ahNuK}r+*  (hX   13r,*  h	X7   Does this information about `ssh_options_set` help?\n\nr-*  hX   Apizar.*  h
X   19r/*  hX   PARTr0*  hX   ELICIT-ASSESSMENTr1*  hNh]r2*  X   ssh_options_setr3*  auK}r4*  (hX   13r5*  h	X   Parameters\nvalue: The value to set. This is a generic pointer and the datatype which is used should be set according to the type set.r6*  hX   Apizar7*  h
X   23r8*  hX   CONTr9*  hX   INFORMr:*  h]r;*  X
   functionalityr<*  ah]r=*  X   ssh_options_setr>*  auK}r?*  (hX   14r@*  h	X/   Here is some documentation that might help:\n\nrA*  hX   ApizarB*  h
X   19rC*  hX   PARTrD*  hX   SUGGESTrE*  hNh]rF*  X   ssh_is_server_knownrG*  auK}rH*  (hX   14rI*  h	X=   ```\nint ssh_is_server_known\t(\tssh_session \tsession\t)\n\nrJ*  hX   ApizarK*  h
X   25rL*  hX   CONTrM*  hX   INFORMrN*  h]rO*  X   basicrP*  ah]rQ*  X   ssh_is_server_knownrR*  auK}rS*  (hX   14rT*  h	X   Description\nCheck if the server is known.\nChecks the user's known host file for a previous connection to the current server.\n\nrU*  hX   ApizarV*  h
X   26rW*  hX   CONTrX*  hX   INFORMrY*  h]rZ*  X
   functionalityr[*  ah]r\*  X   ssh_is_server_knownr]*  auK}r^*  (hX   14r_*  h	X0   Parameters\nsession: The SSH session to use.\n\nr`*  hX   Apizara*  h
X   27rb*  hX   CONTrc*  hX   INFORMrd*  h]re*  X   basicrf*  ah]rg*  X   ssh_is_server_knownrh*  auK}ri*  (hX   14rj*  h	Xw  Returns\nSSH_SERVER_KNOWN_OK: The server is known and has not changed.\nSSH_SERVER_KNOWN_CHANGED: The server key has changed. Either you are under attack or the administrator changed the key. You HAVE to warn the user about a possible attack.\nSSH_SERVER_FOUND_OTHER: The server gave use a key of a type while we had an other type recorded. It is a possible attack.\nSSH_SERVER_NOT_KNOWN: The server is unknown. User should confirm the MD5 is correct.\nSSH_SERVER_FILE_NOT_FOUND: The known host file does not exist. The host is thus unknown. File will be created if host key is accepted.\nSSH_SERVER_ERROR: Some error happened.\n\nrk*  hX   Apizarl*  h
X   28rm*  hX   CONTrn*  hX   INFORMro*  h]rp*  X
   functionalityrq*  ah]rr*  X   ssh_is_server_knownrs*  auK}rt*  (hX   14ru*  h	X!   See also\nssh_get_pubkey_hash()\nrv*  hX   Apizarw*  h
X   29rx*  hX   CONTry*  hX   INFORMrz*  hNh]r{*  X   ssh_is_server_knownr|*  auK}r}*  (hX   14r~*  h	XZ   Bug:\nThere is no current way to remove or modify an entry into the known host table.\n```r*  hX   Apizar*  h
X   30r*  hX   CONTr*  hX   INFORMr*  h]r*  X   qualityr*  ah]r*  X   ssh_is_server_knownr*  auK }r*  (hX   15r*  h	X   Perfectr*  hX
   Programmerr*  h
X   31r*  hX   POSr*  hX   ASSESSr*  hNhNuK!}r*  (hX   16r*  h	X   How do I create a new channel?r*  hX
   Programmerr*  h
NhNhX   ELICIT-OFFER-OR-SUGGESTIONr*  h]r*  X   patternsr*  ah]r*  X   ssh_channelr*  auK"}r*  (hX   17r*  h	X   Try this function:\n\nr*  hX   Apizar*  h
X   33r*  hX   POSr*  hX   SUGGESTr*  h]r*  X   patternsr*  ahNuK#}r*  (hX   17r*  h	X\   ```\nsftp_session sftp_new_channel\t(\tssh_session \tsession,\nssh_channel \tchannel \n)\n\nr*  hX   Apizar*  h
X   34r*  hX   CONTr*  hX   INFORMr*  h]r*  X   basicr*  ah]r*  X   sftp_new_channelr*  auK$}r*  (hX   17r*  h	XC   Description\nStart a new sftp session with an existing channel.\n\nr*  hX   Apizar*  h
X   35r*  hX   CONTr*  hX   INFORMr*  h]r*  X   basicr*  ah]r*  X   sftp_new_channelr*  auK%}r*  (hX   17r*  h	X   Parameters\nsession: The ssh session to use.\nchannel: An open session channel with subsystem already allocated\n\nReturns\nA new sftp session or NULL on error.\n\nr*  hX   Apizar*  h
X   36r*  hX   CONTr*  hX   INFORMr*  h]r*  X
   functionalityr*  ah]r*  X   sftp_new_channelr*  auK&}r*  (hX   17r*  h	X   See also\nsftp_free()\n```r*  hX   Apizar*  h
X   37r*  hX   CONTr*  hX   INFORMr*  hNh]r*  X   sftp_new_channelr*  auK'}r*  (hX   18r*  h	X   Sorry, r*  hX
   Programmerr*  h
X   38r*  hX   NEGr*  hX   BE-POSITIVEr*  hNhNuK(}r*  (hX   18r*  h	X   how do I create a ssh_channel?r*  hX
   Programmerr*  h
X   39r*  hX   FOLr*  hX   ELICIT-OFFER-OR-SUGGESTIONr*  h]r*  X   patternsr*  ah]r*  X   ssh_channelr*  auK)}r*  (hX   19r*  h	X   Try this function:\n\nr*  hX   Apizar*  h
X   40r*  hX   POSr*  hX   SUGGESTr*  h]r*  X   patternsr*  ah]r*  X   ssh_channelr*  auK*}r*  (hX   19r*  h	XA   ```\nssh_channel ssh_channel_new\t(\tssh_session \tsession\t)\n\nr*  hX   Apizar*  h
X   41r*  hX   CONTr*  hX   INFORMr*  h]r*  X   basicr*  ah]r*  X   ssh_channel_newr*  auK+}r*  (hX   19r*  h	X(   Description\nAllocate a new channel.\n\nr*  hX   Apizar*  h
X   42r*  hX   CONTr*  hX   INFORMr*  h]r*  X   basicr*  ah]r*  X   ssh_channel_newr*  auK,}r*  (hX   19r*  h	X0   Parameters\nsession: The ssh session to use.\n\nr +  hX   Apizar+  h
X   43r+  hX   CONTr+  hX   INFORMr+  h]r+  X   basicr+  ah]r+  X   ssh_channel_newr+  auK-}r	+  (hX   19r
+  h	XF   Returns\nA pointer to a newly allocated channel, NULL on error.\n\n```r+  hX   Apizar+  h
X   44r
+  hX   CONTr+  hX   INFORMr+  h]r+  X
   functionalityr+  ah]r+  X   ssh_channel_newr+  auK.}r+  (hX   20r+  h	X*   How do I open a new session in a channel? r+  hX
   Programmerr+  h
NhNhX   ELICIT-OFFER-OR-SUGGESTIONr+  h]r+  X   patternsr+  ah]r+  (X   ssh_sessionr+  X   ssh_channelr+  euK/}r+  (hX   20r+  h	X   And how do I execute a command?r +  hX
   Programmerr!+  h
NhNhX   ELICIT-OFFER-OR-SUGGESTIONr"+  h]r#+  X   patternsr$+  ahNuK0}r%+  (hX   21r&+  h	X9   Try this function to open a new session in a channel:\n\nr'+  hX   Apizar(+  h
X   46r)+  hX   POSr*+  hX   SUGGESTr++  h]r,+  X   patternsr-+  ah]r.+  X   ssh_channel_open_sessionr/+  auK1}r0+  (hX   21r1+  h	XB   ```\nint ssh_channel_open_session\t(\tssh_channel \tchannel\t)\n\nr2+  hX   Apizar3+  h
X   48r4+  hX   CONTr5+  hX   INFORMr6+  h]r7+  X   basicr8+  ah]r9+  X   ssh_channel_open_sessionr:+  auK2}r;+  (hX   21r<+  h	XQ   Description\nOpen a session channel (suited for a shell, not TCP forwarding).\n\nr=+  hX   Apizar>+  h
X   49r?+  hX   CONTr@+  hX   INFORMrA+  h]rB+  (X
   functionalityrC+  X   purposerD+  eh]rE+  X   ssh_channel_open_sessionrF+  auK3}rG+  (hX   21rH+  h	X.   Parameters\nchannel: An allocated channel.\n\nrI+  hX   ApizarJ+  h
X   50rK+  hX   CONTrL+  hX   INFORMrM+  h]rN+  X   basicrO+  ah]rP+  X   ssh_channel_open_sessionrQ+  auK4}rR+  (hX   21rS+  h	X   Returns\nSSH_OK on success, SSH_ERROR if an error occurred, SSH_AGAIN if in nonblocking mode and call has to be done again.\n\nrT+  hX   ApizarU+  h
X   51rV+  hX   CONTrW+  hX   INFORMrX+  h]rY+  X
   functionalityrZ+  ah]r[+  X   ssh_channel_open_sessionr\+  auK5}r]+  (hX   21r^+  h	X   See also\nssh_channel_open_forward()\nssh_channel_request_env()\nssh_channel_request_shell()\nssh_channel_request_exec()\n\n```r_+  hX   Apizar`+  h
X   52ra+  hX   CONTrb+  hX   INFORMrc+  hNh]rd+  X   ssh_channel_open_sessionre+  auK6}rf+  (hX   22rg+  h	X+   Try this function to execute a command:\n\nrh+  hX   Apizari+  h
X   47rj+  hX   POSrk+  hX   SUGGESTrl+  h]rm+  X   purposern+  ah]ro+  X   ssh_channel_request_execrp+  auK7}rq+  (hX   22rr+  h	XX   ```\nint ssh_channel_request_exec\t(\tssh_channel \tchannel,\nconst char * \tcmd \n)\n\nrs+  hX   Apizart+  h
X   54ru+  hX   CONTrv+  hX   INFORMrw+  h]rx+  X   basicry+  ah]rz+  X   ssh_channel_request_execr{+  auK8}r|+  (hX   22r}+  h	Xi   Description\nRun a shell command without an interactive shell.\nThis is similar to \'sh -c command\'.\n\nr~+  hX   Apizar+  h
X   55r+  hX   CONTr+  hX   INFORMr+  h]r+  X
   functionalityr+  ah]r+  X   ssh_channel_request_execr+  auK9}r+  (hX   22r+  h	X   Parameters\nchannel: The channel to execute the command.\ncmd: The command to execute (e.g. "ls ~/ -al | grep -i reports").\n\nr+  hX   Apizar+  h
X   56r+  hX   CONTr+  hX   INFORMr+  h]r+  (X
   functionalityr+  X   examplesr+  eh]r+  X   ssh_channel_request_execr+  auK:}r+  (hX   22r+  h	X}   Returns\nSSH_OK on success, SSH_ERROR if an error occurred, SSH_AGAIN if in nonblocking mode and call has to be done again.\nr+  hX   Apizar+  h
X   57r+  hX   CONTr+  hX   INFORMr+  h]r+  X
   functionalityr+  ah]r+  X   ssh_channel_request_execr+  auK;}r+  (hX   22r+  h	X   Example:\n\nrc = channel_request_exec(channel, "ps aux");\nif (rc &gt; 0) {\n return -1;\n}\nwhile ((rc = channel_read(channel, buffer, sizeof(buffer), 0)) &gt; 0) {\n if (fwrite(buffer, 1, rc, stdout) != (unsigned int) rc) {\n return -1;\n }\n}\n\nr+  hX   Apizar+  h
X   58r+  hX   CONTr+  hX   INFORMr+  h]r+  X   examplesr+  ah]r+  X   ssh_channel_request_execr+  auK<}r+  (hX   22r+  h	X.   See also\nssh_channel_request_shell()\n\n\n```r+  hX   Apizar+  h
X   59r+  hX   CONTr+  hX   INFORMr+  hNh]r+  X   ssh_channel_request_execr+  auK=}r+  (hX   23r+  h	X2   How is the syntax of the read of a channel method?r+  hX
   Programmerr+  h
X   59r+  hX   FOLr+  hX
   ELICIT-INFORMr+  h]r+  (X
   functionalityr+  X
   directivesr+  eh]r+  X   ssh_channel_readr+  auK>}r+  (hX   24r+  h	X
   Ok, nothing, r+  hX
   Programmerr+  h
X   61r+  hX   NEGr+  hX   COMMENT-ABOUT-UNDERSTANDINGr+  hNhNuK?}r+  (hX   24r+  h	X"   I have seen it in the previous oner+  hX
   Programmerr+  h
X   62r+  hX   CONTr+  hX   INFORMr+  hNhNuK@}r+  (hX   25r+  h	X!   Does this documentation help?\n\nr+  hX   Apizar+  h
X   59r+  hX   POSr+  hX   ELICIT-ASSESSMENTr+  hNh]r+  X   ssh_channel_readr+  auKA}r+  (hX   25r+  h	Xp   ```\nint ssh_channel_read\t(\tssh_channel \tchannel,\nvoid * \tdest,\nuint32_t \tcount,\nint \tis_stderr \n)\n\nr+  hX   Apizar+  h
X   64r+  hX   CONTr+  hX   INFORMr+  h]r+  X   basicr+  ah]r+  X   ssh_channel_readr+  auKB}r+  (hX   25r+  h	X+   Description\nReads data from a channel.\n\nr+  hX   Apizar+  h
X   65r+  hX   CONTr+  hX   INFORMr+  h]r+  X   basicr+  ah]r+  X   ssh_channel_readr+  auKC}r+  (hX   25r+  h	X   Parameters\nchannel: The channel to read from.\ndest: The destination buffer which will get the data.\ncount: The count of bytes to be read.\nis_stderr: A boolean value to mark reading from the stderr flow.\n\nr+  hX   Apizar+  h
X   66r+  hX   CONTr+  hX   INFORMr+  h]r+  X
   functionalityr+  ah]r+  X   ssh_channel_readr+  auKD}r+  (hX   25r+  h	X   Returns\nThe number of bytes read, 0 on end of file or SSH_ERROR on error. In nonblocking mode it Can return 0 if no data is available or SSH_AGAIN.\n\n```r+  hX   Apizar+  h
X   67r+  hX   CONTr+  hX   INFORMr+  h]r+  (X
   functionalityr+  X   basicr+  eh]r ,  X   ssh_channel_readr,  auKE}r,  (hX   26r,  h	X   How can I start a sftp session?r,  hX
   Programmerr,  h
NhNhX   ELICIT-OFFER-OR-SUGGESTIONr,  h]r,  X   patternsr,  ah]r	,  X   sftp_sessionr
,  auKF}r,  (hX   27r,  h	X   sftp connection,r
,  hX
   Programmerr,  h
X   69r,  hX   REPr,  hX   OTHERr,  hNhNuKG}r,  (hX   27r,  h	X   sorryr,  hX
   Programmerr,  h
X   70r,  hX   CONTr,  hX   BE-POSITIVEr,  hNhNuKH}r,  (hX   28r,  h	X   Try this function:\n\nr,  hX   Apizar,  h
X   69r,  hX   POSr,  hX   SUGGESTr,  h]r ,  X   patternsr!,  ah]r",  X   sftp_sessionr#,  auKI}r$,  (hX   28r%,  h	X;   ```\nsftp_session sftp_new\t(\tssh_session \tsession\t)\n\nr&,  hX   Apizar',  h
X   72r(,  hX   CONTr),  hX   INFORMr*,  h]r+,  X   basicr,,  ah]r-,  X   sftp_new_channelr.,  auKJ}r/,  (hX   28r0,  h	X*   Description\nStart a new sftp session.\n\nr1,  hX   Apizar2,  h
X   73r3,  hX   CONTr4,  hX   INFORMr5,  h]r6,  X   basicr7,  ah]r8,  X   sftp_new_channelr9,  auKK}r:,  (hX   28r;,  h	X0   Parameters\nsession: The ssh session to use.\n\nr<,  hX   Apizar=,  h
X   74r>,  hX   CONTr?,  hX   INFORMr@,  h]rA,  X   basicrB,  ah]rC,  X   sftp_new_channelrD,  auKL}rE,  (hX   28rF,  h	X1   Returns\nA new sftp session or NULL on error.\n\nrG,  hX   ApizarH,  h
X   75rI,  hX   CONTrJ,  hX   INFORMrK,  h]rL,  X
   functionalityrM,  ah]rN,  X   sftp_new_channelrO,  auKM}rP,  (hX   28rQ,  h	X   See also\nsftp_free()\n\n```rR,  hX   ApizarS,  h
X   76rT,  hX   CONTrU,  hX   INFORMrV,  hNh]rW,  X   sftp_new_channelrX,  auKN}rY,  (hX   29rZ,  h	X$   And to initialize a sftp connection?r[,  hX
   Programmerr\,  h
NhNhX   ELICIT-OFFER-OR-SUGGESTIONr],  h]r^,  X   patternsr_,  ah]r`,  X   sftp_sessionra,  auKO}rb,  (hX   30rc,  h	X   Try this function:\n\nrd,  hX   Apizare,  h
X   78rf,  hX   POSrg,  hX   SUGGESTrh,  h]ri,  X   patternsrj,  ah]rk,  X	   sftp_initrl,  auKP}rm,  (hX   30rn,  h	X1   ```\nint sftp_init\t(\tsftp_session \tsftp\t)\n\nro,  hX   Apizarp,  h
X   79rq,  hX   CONTrr,  hX   INFORMrs,  h]rt,  X   basicru,  ah]rv,  X	   sftp_initrw,  auKQ}rx,  (hX   30ry,  h	X=   Description\nInitialize the sftp session with the server.\n\nrz,  hX   Apizar{,  h
X   80r|,  hX   CONTr},  hX   INFORMr~,  h]r,  X   basicr,  ah]r,  X	   sftp_initr,  auKR}r,  (hX   30r,  h	X5   Parameters\nsftp: The sftp session to initialize.\n\nr,  hX   Apizar,  h
X   81r,  hX   CONTr,  hX   INFORMr,  h]r,  X   basicr,  ah]r,  X	   sftp_initr,  auKS}r,  (hX   30r,  h	X>   Returns\n0 on success, &lt; 0 on error with ssh error set.\n\nr,  hX   Apizar,  h
X   82r,  hX   CONTr,  hX   INFORMr,  h]r,  X
   functionalityr,  ah]r,  X	   sftp_initr,  auKT}r,  (hX   30r,  h	X   See also\nsftp_new()\n\n```r,  hX   Apizar,  h
X   83r,  hX   CONTr,  hX   INFORMr,  hNh]r,  X	   sftp_initr,  auKU}r,  (hX   31r,  h	XG   Can you give me the complete documentation about the method sftp_mkdir?r,  hX
   Programmerr,  h
NhNhX
   ELICIT-INFORMr,  h]r,  X   basicr,  ah]r,  X
   sftp_mkdirr,  auKV}r,  (hX   32r,  h	X8   Here is the complete documentation for `sftp_mkdir`:\n\nr,  hX   Apizar,  h
X   85r,  hX   POSr,  hX   INFORMr,  hNh]r,  X
   sftp_mkdirr,  auKW}r,  (hX   32r,  h	X^   ```\nint sftp_mkdir\t(\tsftp_session \tsftp,\nconst char * \tdirectory,\nmode_t \tmode \n)\n\nr,  hX   Apizar,  h
X   86r,  hX   CONTr,  hX   INFORMr,  h]r,  X   basicr,  ah]r,  X
   sftp_mkdirr,  auKX}r,  (hX   32r,  h	X$   Description\nCreate a directory.\n\nr,  hX   Apizar,  h
X   87r,  hX   CONTr,  hX   INFORMr,  h]r,  X   basicr,  ah]r,  X
   sftp_mkdirr,  auKY}r,  (hX   32r,  h	X   Parameters\nsftp: The sftp session handle.\ndirectory: The directory to create.\nmode: Specifies the permissions to use. It is modified by the process's umask in the usual way: The permissions of the created file are (mode &amp; ~umask)\n\nr,  hX   Apizar,  h
X   88r,  hX   CONTr,  hX   INFORMr,  h]r,  X
   functionalityr,  ah]r,  X
   sftp_mkdirr,  auKZ}r,  (hX   32r,  h	XG   Returns\n0 on success, &lt; 0 on error with ssh and sftp error set.\n\nr,  hX   Apizar,  h
X   89r,  hX   CONTr,  hX   INFORMr,  h]r,  X
   functionalityr,  ah]r,  X
   sftp_mkdirr,  auK[}r,  (hX   32r,  h	X!   See also\nsftp_get_error()\n\n```r,  hX   Apizar,  h
X   90r,  hX   CONTr,  hX   INFORMr,  hNh]r,  X
   sftp_mkdirr,  auK\}r,  (hX   33r,  h	X:   Can you tell me more about the modes of sftp_mkdir method?r,  hX
   Programmerr,  h
X   89r,  hX   FOLr,  hX
   ELICIT-INFORMr,  h]r,  X
   functionalityr,  ah]r,  X
   sftp_mkdirr,  auK]}r,  (hX   34r,  h	X   And about the method sftp_open?r,  hX
   Programmerr,  h
NhNhX
   ELICIT-INFORMr,  h]r,  X   basicr,  ah]r,  X	   sftp_openr,  auK^}r,  (hX   35r,  h	X'   Here is the definition of `mode_t`:\n\nr,  hX   Apizar -  h
X   92r-  hX   POSr-  hX   INFORMr-  h]r-  X   basicr-  ah]r-  X
   sftp_mkdirr-  auK_}r-  (hX   35r	-  h	X   ```\n typedef int mode_t;\n```r
-  hX   Apizar-  h
X   94r-  hX   CONTr
-  hX   INFORMr-  h]r-  X   basicr-  ah]r-  X
   sftp_mkdirr-  auK`}r-  (hX   36r-  h	X1   Here is some documentation about `sftp_open`:\n\nr-  hX   Apizar-  h
X   93r-  hX   POSr-  hX   INFORMr-  hNh]r-  X	   sftp_openr-  auKa}r-  (hX   36r-  h	Xt   ```\nsftp_file sftp_open\t(\tsftp_session \tsession,\nconst char * \tfile,\nint \taccesstype,\nmode_t \tmode \n)\n\nr-  hX   Apizar-  h
X   96r -  hX   CONTr!-  hX   INFORMr"-  h]r#-  X   basicr$-  ah]r%-  X	   sftp_openr&-  auKb}r'-  (hX   36r(-  h	X+   Description\nOpen a file on the server.\n\nr)-  hX   Apizar*-  h
X   97r+-  hX   CONTr,-  hX   INFORMr--  h]r.-  X   basicr/-  ah]r0-  X	   sftp_openr1-  auKc}r2-  (hX   36r3-  h	X  Parameters\nsession: The sftp session handle.\nfile: The file to be opened.\naccesstype: Is one of O_RDONLY, O_WRONLY or O_RDWR which request opening the file read-only,write-only or read/write. Acesss may also be bitwise-or'd with one or more of the following: O_CREAT - If the file does not exist it will be created. O_EXCL - When used with O_CREAT, if the file already exists it is an error and the open will fail. O_TRUNC - If the file already exists it will be truncated.\nmode: Mode specifies the permissions to use if a new file is created. It is modified by the process's umask in the usual way: The permissions of the created file are (mode &amp; ~umask)\n\nr4-  hX   Apizar5-  h
X   98r6-  hX   CONTr7-  hX   INFORMr8-  h]r9-  X
   functionalityr:-  ah]r;-  X	   sftp_openr<-  auKd}r=-  (hX   36r>-  h	XK   Returns\nA sftp file handle, NULL on error with ssh and sftp error set.\n\nr?-  hX   Apizar@-  h
X   99rA-  hX   CONTrB-  hX   INFORMrC-  h]rD-  X
   functionalityrE-  ah]rF-  X	   sftp_openrG-  auKe}rH-  (hX   36rI-  h	X#   See also\nsftp_get_error()\n\n\n```rJ-  hX   ApizarK-  h
X   100rL-  hX   CONTrM-  hX   INFORMrN-  hNh]rO-  X	   sftp_openrP-  auKf}rQ-  (hX   37rR-  h	X8   What about the third parameter of the sftp_mkdir method?rS-  hX
   ProgrammerrT-  h
X   89rU-  hX   FOLrV-  hX
   ELICIT-INFORMrW-  h]rX-  X   basicrY-  ah]rZ-  X
   sftp_mkdirr[-  auKg}r\-  (hX   38r]-  h	XK   The third parameter of the `sftp_mkdir` method is:\n\n```\nmode_t mode\n```r^-  hX   Apizar_-  h
X   102r`-  hX   POSra-  hX   INFORMrb-  h]rc-  X   basicrd-  ah]re-  X
   sftp_mkdirrf-  auKh}rg-  (hX   39rh-  h	XV   The `mode` parameter of `sftp_mkdir` is a Unix permission number for the created file.ri-  hX   Apizarj-  h
X   103rk-  hX   CONTrl-  hX   INFORMrm-  h]rn-  X   conceptsro-  ah]rp-  X
   sftp_mkdirrq-  auKi}rr-  (hX   40rs-  h	X0   Is there a type for a file of a sftp connection?rt-  hX
   Programmerru-  h
NhNhX
   ELICIT-INFORMrv-  h]rw-  (X	   structurerx-  X   basicry-  eh]rz-  X   sftp_sessionr{-  auKj}r|-  (hX   41r}-  h	X0   Here is a struct definition that might help:\n\nr~-  hX   Apizar-  h
X   105r-  hX   POSr-  hX   INFORMr-  hNh]r-  X   sftp_sessionr-  auKk}r-  (hX   41r-  h	X   ```\nstruct sftp_session_struct {\n ssh_session session;\n ssh_channel channel;\n int server_version;\n int client_version;\n int version;\n sftp_request_queue queue;\n uint32_t id_counter;\n int errnum;\n void **handles;\n sftp_ext ext;\n};\n```r-  hX   Apizar-  h
X   106r-  hX   CONTr-  hX   INFORMr-  h]r-  (X	   structurer-  X   basicr-  eh]r-  X   sftp_sessionr-  auKl}r-  (hX   42r-  h	X)   Which is the error of existing directory?r-  hX
   Programmerr-  h
NhNhX
   ELICIT-INFORMr-  h]r-  (X
   functionalityr-  X	   structurer-  ehNuKm}r-  (hX   43r-  h	X6   Here is another struct definition that might help:\n\nr-  hX   Apizar-  h
X   107r-  hX   CONTr-  hX   INFORMr-  hNh]r-  X	   sftp_filer-  auKn}r-  (hX   43r-  h	X   ```\n/* file handler */\nstruct sftp_file_struct {\n sftp_session sftp;\n char *name;\n uint64_t offset;\n ssh_string handle;\n int eof;\n int nonblocking;\n};\n```r-  hX   Apizar-  h
X   109r-  hX   CONTr-  hX   INFORMr-  h]r-  (X	   structurer-  X   basicr-  eh]r-  X	   sftp_filer-  auKo}r-  (hX   44r-  h	X   Perfect with this oner-  hX
   Programmerr-  h
X   110r-  hX   POSr-  hX   ASSESSr-  hNhNuKp}r-  (hX   45r-  h	X)   Which is the error of existing directory?r-  hX
   Programmerr-  h
X   108r-  hX   REPr-  hX
   ELICIT-INFORMr-  h]r-  (X
   functionalityr-  X	   structurer-  ehNuKq}r-  (hX   46r-  h	X1   Here is a function that might help with that:\n\nr-  hX   Apizar-  h
X   112r-  hX   POSr-  hX   INFORMr-  hNhNuKr}r-  (hX   46r-  h	X6   ```\nint sftp_get_error\t(\tsftp_session \tsftp\t)\n\nr-  hX   Apizar-  h
X   113r-  hX   CONTr-  hX   INFORMr-  h]r-  X   basicr-  ah]r-  X   sftp_get_errorr-  auKs}r-  (hX   46r-  h	Xx    Description\nGet the last sftp error.\nUse this function to get the latest error set by a posix like sftp function.\n\nr-  hX   Apizar-  h
X   114r-  hX   CONTr-  hX   INFORMr-  h]r-  X
   functionalityr-  ah]r-  X   sftp_get_errorr-  auKt}r-  (hX   46r-  h	X@   Parameters\nsftp: The sftp session where the error is saved.\n\nr-  hX   Apizar-  h
X   115r-  hX   CONTr-  hX   INFORMr-  h]r-  X   basicr-  ah]r-  X   sftp_get_errorr-  auKu}r-  (hX   46r-  h	X`   Returns\nThe saved error (see server responses), &lt; 0 if an error in the function occured.\n\nr-  hX   Apizar-  h
X   116r-  hX   CONTr-  hX   INFORMr-  h]r-  X
   functionalityr-  ah]r-  X   sftp_get_errorr-  auKv}r-  (hX   46r-  h	X!   See also\nServer responses\n\n```r-  hX   Apizar-  h
X   117r-  hX   CONTr-  hX   INFORMr-  hNh]r-  X   sftp_get_errorr-  auKw}r-  (hX   47r-  h	X    Which kind of SFTP errors exist?r-  hX
   Programmerr-  h
NhNhX
   ELICIT-INFORMr-  h]r .  X	   structurer.  ahNuKx}r.  (hX   48r.  h	X*   Here is a web resource on SFTP errors:\n\nr.  hX   Apizar.  h
X   119r.  hX   POSr.  hX   INFORMr.  h]r	.  (X
   referencesr
.  X	   structurer.  ehNuKy}r.  (hX   48r
.  h	X(   <https://winscp.net/eng/docs/sftp_codes>r.  hX   Apizar.  h
X   120r.  hX   CONTr.  hX   INFORMr.  h]r.  (X
   referencesr.  X	   structurer.  ehNuuuK}r.  (hhh}r.  (K }r.  (hhh	X   hir.  hX
   Programmerr.  h
NhNhX   BE-POSITIVEr.  hNhNuK}r.  (hhh	X   Hello, I'm Apiza.r.  hX   Apizar.  h
hhX   POSr.  hX   BE-POSITIVEr .  hNhNuK}r!.  (hhh	X<    Let me know if you have any questions about the LibSSH API.r".  hX   Apizar#.  h
NhNhX   SUGGESTr$.  hNhNuK}r%.  (hh+h	X   libssh connect to localhostr&.  hX
   Programmerr'.  h
NhNhX   ELICIT-OFFER-OR-SUGGESTIONr(.  h]r).  X   patternsr*.  ahNuK}r+.  (hh5h	X   hi Apizar,.  hX
   Programmerr-.  h
hhX   POSr..  hX   BE-POSITIVEr/.  hNhNuK}r0.  (hh<h	XD   Here is a function that might help with connecting to localhost:\n\nr1.  hX   Apizar2.  h
h+hX   POSr3.  hX   SUGGESTr4.  h]r5.  X   patternsr6.  ahNuK}r7.  (hh<h	X5   ```\nint ssh_connect\t(\tssh_session \tsession\t)\n\nr8.  hX   Apizar9.  h
h<hX   CONTr:.  hX   INFORMr;.  h]r<.  X   basicr=.  ah]r>.  X   ssh_connectr?.  auK}r@.  (hh<h	X+   Description\nConnect to the ssh server.\n\nrA.  hX   ApizarB.  h
hFhX   CONTrC.  hX   INFORMrD.  h]rE.  X   basicrF.  ah]rG.  X   ssh_connectrH.  auK}rI.  (hh<h	X4   Parameters\nsession: The ssh session to connect.\n\nrJ.  hX   ApizarK.  h
hQhX   CONTrL.  hX   INFORMrM.  h]rN.  X   basicrO.  ah]rP.  X   ssh_connectrQ.  auK	}rR.  (hh<h	X   Returns\nSSH_OK on success, SSH_ERROR on error.\nSSH_AGAIN, if the session is in nonblocking mode, and call must be done again.\n\nrS.  hX   ApizarT.  h
hXhX   CONTrU.  hX   INFORMrV.  h]rW.  X
   functionalityrX.  ah]rY.  X   ssh_connectrZ.  auK
}r[.  (hh<h	X,   See also\nssh_new()\nssh_disconnect()\n\n```r\.  hX   Apizar].  h
hchX   CONTr^.  hX   INFORMr_.  hNh]r`.  X   ssh_connectra.  auK}rb.  (hhFh	X   new ssh sessionrc.  hX
   Programmerrd.  h
NhNhX   ELICIT-OFFER-OR-SUGGESTIONre.  h]rf.  X   patternsrg.  ah]rh.  X   ssh_sessionri.  auK}rj.  (hhQh	X>   Here is a function that might help with a new SSH session:\n\nrk.  hX   Apizarl.  h
X   11rm.  hX   POSrn.  hX   SUGGESTro.  h]rp.  X   patternsrq.  ah]rr.  (X   ssh_sessionrs.  X   ssh_newrt.  euK
}ru.  (hhQh	X+   ```\nssh_session ssh_new\t(\tvoid \t\t)\n\nrv.  hX   Apizarw.  h
X   12rx.  hX   CONTry.  hX   INFORMrz.  h]r{.  X   basicr|.  ah]r}.  X   ssh_newr~.  auK}r.  (hhQh	X.   Description\nCreate a new ssh session.\n\n\n\nr.  hX   Apizar.  h
X   13r.  hX   CONTr.  hX   INFORMr.  h]r.  X   basicr.  ah]r.  X   ssh_newr.  auK}r.  (hhQh	X9   Returns\nA new ssh_session pointer, NULL on error.\n\n```r.  hX   Apizar.  h
X   14r.  hX   CONTr.  hX   INFORMr.  h]r.  (X
   functionalityr.  X   basicr.  eh]r.  X   ssh_newr.  auK}r.  (hhXh	X	   ssh errorr.  hX
   Programmerr.  h
NhNhX
   ELICIT-INFORMr.  h]r.  X   basicr.  ahNuK}r.  (hhch	XK   Two functions that might help are `ssh_get_error` and `ssh_get_error_code`.r.  hX   Apizar.  h
X   16r.  hX   POSr.  hX   SUGGESTr.  h]r.  X	   structurer.  ah]r.  (X
   ssh_get_errorr.  X   ssh_get_error_coder.  euK}r.  (hhch	XJ   Let me know if you would like to see the documentation for either of them.r.  hX   Apizar.  h
X   17r.  hX   FOLr.  hX   SUGGESTr.  h]r.  X   basicr.  ah]r.  (X
   ssh_get_errorr.  X   ssh_get_error_coder.  euK}r.  (hX   10r.  h	X
   ssh_get_errorr.  hX
   Programmerr.  h
X   17r.  hX   FOLr.  hX
   ELICIT-INFORMr.  h]r.  X   basicr.  ah]r.  X
   ssh_get_errorr.  auK}r.  (hX   11r.  h	X   Here you go:\n\nr.  hX   Apizar.  h
X   19r.  hX   POSr.  hX   OTHERr.  hNh]r.  X
   ssh_get_errorr.  auK}r.  (hX   11r.  h	X8   ```\nconst char* ssh_get_error\t(\tvoid * \terror\t)\n\nr.  hX   Apizar.  h
X   20r.  hX   CONTr.  hX   INFORMr.  h]r.  X   basicr.  ah]r.  X
   ssh_get_errorr.  auK}r.  (hX   11r.  h	XE   Description\nRetrieve the error text message from the last error.\n\nr.  hX   Apizar.  h
X   21r.  hX   CONTr.  hX   INFORMr.  h]r.  X
   functionalityr.  ah]r.  X
   ssh_get_errorr.  auK}r.  (hX   11r.  h	X2   Parameters\nerror: An ssh_session or ssh_bind.\n\nr.  hX   Apizar.  h
X   22r.  hX   CONTr.  hX   INFORMr.  h]r.  X   basicr.  ah]r.  X
   ssh_get_errorr.  auK}r.  (hX   11r.  h	X7   Returns\nA static string describing the error.\n\n\n```r.  hX   Apizar.  h
X   23r.  hX   CONTr.  hX   INFORMr.  h]r.  (X
   functionalityr.  X   basicr.  eh]r.  X
   ssh_get_errorr.  auK}r.  (hX   12r.  h	X
   autheticationr.  hX
   Programmerr.  h
NhNhX
   ELICIT-INFORMr.  h]r.  X   patternsr.  ahNuK}r.  (hX   13r.  h	X4   There are lots of functions that might be relevant. r.  hX   Apizar.  h
X   25r.  hX   PARTr.  hX   INFORMr.  h]r.  (X   patternsr /  X	   structurer/  ehNuK}r/  (hX   13r/  h	X   Here is one:\n\nr/  hX   Apizar/  h
X   25r/  hX   POSr/  hX   SUGGESTr/  h]r	/  X   patternsr
/  ah]r/  X   ssh_channel_open_auth_agentr/  auK}r
/  (hX   13r/  h	XE   ```\nint ssh_channel_open_auth_agent\t(\tssh_channel \tchannel\t)\n\nr/  hX   Apizar/  h
X   27r/  hX   CONTr/  hX   INFORMr/  h]r/  X   basicr/  ah]r/  X   ssh_channel_open_auth_agentr/  auK}r/  (hX   13r/  h	X,  Description\nOpen an agent authentication forwarding channel.\nThis type of channel can be opened by a server towards a client in order to provide SSH-Agent services to the server-side process. This channel can only be opened if the client claimed support by sending a channel request beforehand.\n\nr/  hX   Apizar/  h
X   28r/  hX   CONTr/  hX   INFORMr/  h]r/  (X
   functionalityr /  X   purposer!/  X
   directivesr"/  eh]r#/  X   ssh_channel_open_auth_agentr$/  auK}r%/  (hX   13r&/  h	X.   Parameters\nchannel: An allocated channel.\n\nr'/  hX   Apizar(/  h
X   29r)/  hX   CONTr*/  hX   INFORMr+/  h]r,/  X   basicr-/  ah]r./  X   ssh_channel_open_auth_agentr//  auK}r0/  (hX   13r1/  h	X   Returns\nSSH_OK on success, SSH_ERROR if an error occurred, SSH_AGAIN if in nonblocking mode and call has to be done again.\n\nr2/  hX   Apizar3/  h
X   30r4/  hX   CONTr5/  hX   INFORMr6/  h]r7/  X
   functionalityr8/  ah]r9/  X   ssh_channel_open_auth_agentr:/  auK }r;/  (hX   13r</  h	X-   See also\nssh_channel_open_forward()\n\n\n```r=/  hX   Apizar>/  h
X   31r?/  hX   CONTr@/  hX   INFORMrA/  hNh]rB/  X   ssh_channel_open_auth_agentrC/  auK!}rD/  (hX   14rE/  h	X   check that the host is knownrF/  hX
   ProgrammerrG/  h
NhNhX   ELICIT-OFFER-OR-SUGGESTIONrH/  h]rI/  X   patternsrJ/  ahNuK"}rK/  (hX   15rL/  h	XB   Here is a function that might help check if the host is known:\n\nrM/  hX   ApizarN/  h
X   33rO/  hX   POSrP/  hX   SUGGESTrQ/  h]rR/  X   patternsrS/  ah]rT/  X   ssh_is_server_knownrU/  auK#}rV/  (hX   15rW/  h	X=   ```\nint ssh_is_server_known\t(\tssh_session \tsession\t)\n\nrX/  hX   ApizarY/  h
X   34rZ/  hX   CONTr[/  hX   INFORMr\/  h]r]/  X   basicr^/  ah]r_/  X   ssh_is_server_knownr`/  auK$}ra/  (hX   15rb/  h	X   Description\nCheck if the server is known.\nChecks the user's known host file for a previous connection to the current server.\n\nrc/  hX   Apizard/  h
X   35re/  hX   CONTrf/  hX   INFORMrg/  h]rh/  X
   functionalityri/  ah]rj/  X   ssh_is_server_knownrk/  auK%}rl/  (hX   15rm/  h	X0   Parameters\nsession: The SSH session to use.\n\nrn/  hX   Apizaro/  h
X   36rp/  hX   CONTrq/  hX   INFORMrr/  h]rs/  X   basicrt/  ah]ru/  X   ssh_is_server_knownrv/  auK&}rw/  (hX   15rx/  h	Xw  Returns\nSSH_SERVER_KNOWN_OK: The server is known and has not changed.\nSSH_SERVER_KNOWN_CHANGED: The server key has changed. Either you are under attack or the administrator changed the key. You HAVE to warn the user about a possible attack.\nSSH_SERVER_FOUND_OTHER: The server gave use a key of a type while we had an other type recorded. It is a possible attack.\nSSH_SERVER_NOT_KNOWN: The server is unknown. User should confirm the MD5 is correct.\nSSH_SERVER_FILE_NOT_FOUND: The known host file does not exist. The host is thus unknown. File will be created if host key is accepted.\nSSH_SERVER_ERROR: Some error happened.\n\nry/  hX   Apizarz/  h
X   37r{/  hX   CONTr|/  hX   INFORMr}/  h]r~/  X
   functionalityr/  ah]r/  X   ssh_is_server_knownr/  auK'}r/  (hX   15r/  h	X!   See also\nssh_get_pubkey_hash()\nr/  hX   Apizar/  h
X   38r/  hX   CONTr/  hX   INFORMr/  hNh]r/  X   ssh_is_server_knownr/  auK(}r/  (hX   15r/  h	X^   Bug:\nThere is no current way to remove or modify an entry into the known host table.\n\n\n```r/  hX   Apizar/  h
X   39r/  hX   CONTr/  hX   INFORMr/  h]r/  X   qualityr/  ah]r/  X   ssh_is_server_knownr/  auK)}r/  (hX   16r/  h	X$   authenticate the user to the server.r/  hX
   Programmerr/  h
NhNhX   ELICIT-OFFER-OR-SUGGESTIONr/  h]r/  X   patternsr/  ahNuK*}r/  (hX   17r/  h	X   disconnect from the serverr/  hX
   Programmerr/  h
NhNhX   ELICIT-OFFER-OR-SUGGESTIONr/  h]r/  X   patternsr/  ahNuK+}r/  (hX   18r/  h	X   free the sessionr/  hX
   Programmerr/  h
NhNhX   ELICIT-OFFER-OR-SUGGESTIONr/  h]r/  X   patternsr/  ah]r/  X   ssh_sessionr/  auK,}r/  (hX   19r/  h	X3   This function might help authenticate the user:\n\nr/  hX   Apizar/  h
X   41r/  hX   POSr/  hX   SUGGESTr/  h]r/  X   patternsr/  ah]r/  X   ssh_userauth_agentr/  auK-}r/  (hX   19r/  h	XW   ```\nint ssh_userauth_agent\t(\tssh_session \tsession,\nconst char * \tusername \n)\n\nr/  hX   Apizar/  h
X   44r/  hX   CONTr/  hX   INFORMr/  h]r/  X   basicr/  ah]r/  X   ssh_userauth_agentr/  auK.}r/  (hX   19r/  h	XD   Description\nTry to do public key authentication with ssh agent.\n\nr/  hX   Apizar/  h
X   45r/  hX   CONTr/  hX   INFORMr/  h]r/  X
   functionalityr/  ah]r/  X   ssh_userauth_agentr/  auK/}r/  (hX   19r/  h	X^   Parameters\nsession: The ssh session to use.\nusername: The username, this SHOULD be NULL.\n\nr/  hX   Apizar/  h
X   46r/  hX   CONTr/  hX   INFORMr/  h]r/  (X
   functionalityr/  X
   directivesr/  eh]r/  X   ssh_userauth_agentr/  auK0}r/  (hX   19r/  h	X  Returns\nSSH_AUTH_ERROR: A serious error happened.\nSSH_AUTH_DENIED: The server doesn't accept that public key as an authentication token. Try another key or another method.\nSSH_AUTH_PARTIAL: You've been partially authenticated, you still have to use another method.\nSSH_AUTH_SUCCESS: The public key is accepted, you want now to use ssh_userauth_publickey().\nSSH_AUTH_AGAIN: In nonblocking mode, you've got to call this again later.\nr/  hX   Apizar/  h
X   47r/  hX   CONTr/  hX   INFORMr/  h]r/  X
   functionalityr/  ah]r/  X   ssh_userauth_agentr/  auK1}r/  (hX   19r/  h	X   Note\nMost server implementations do not permit changing the username during authentication. The username should only be set with ssh_options_set() only before you connect to the server.\n\n```r/  hX   Apizar/  h
X   48r/  hX   CONTr/  hX   INFORMr/  h]r/  (X
   functionalityr/  X
   directivesr/  eh]r/  X   ssh_userauth_agentr/  auK2}r/  (hX   20r/  h	X8   This function might help disconnect from the server:\n\nr/  hX   Apizar/  h
X   42r/  hX   POSr/  hX   SUGGESTr/  h]r/  X   patternsr/  ah]r/  X   ssh_disconnectr/  auK3}r/  (hX   20r/  h	X9   ```\nvoid ssh_disconnect\t(\tssh_session \tsession\t)\n\nr/  hX   Apizar/  h
X   50r 0  hX   CONTr0  hX   INFORMr0  h]r0  X   basicr0  ah]r0  X   ssh_disconnectr0  auK4}r0  (hX   20r0  h	Xu   Description\nDisconnect from a session (client or server).\nThe session can then be reused to open a new session.\n\nr	0  hX   Apizar
0  h
X   51r0  hX   CONTr0  hX   INFORMr
0  h]r0  (X
   functionalityr0  X   patternsr0  eh]r0  X   ssh_disconnectr0  auK5}r0  (hX   20r0  h	X7   Parameters\nsession: The SSH session to use.\n\n\n\n```r0  hX   Apizar0  h
X   52r0  hX   CONTr0  hX   INFORMr0  h]r0  X   basicr0  ah]r0  X   ssh_disconnectr0  auK6}r0  (hX   21r0  h	X.   This function might help free the session:\n\nr 0  hX   Apizar!0  h
X   42r"0  hX   POSr#0  hX   SUGGESTr$0  h]r%0  X   patternsr&0  ah]r'0  (X   ssh_sessionr(0  X   ssh_freer)0  euK7}r*0  (hX   21r+0  h	X3   ```\nvoid ssh_free\t(\tssh_session \tsession\t)\n\nr,0  hX   Apizar-0  h
X   54r.0  hX   CONTr/0  hX   INFORMr00  h]r10  X   basicr20  ah]r30  X   ssh_freer40  auK8}r50  (hX   21r60  h	X1   Description\nDeallocate a SSH session handle.\n\nr70  hX   Apizar80  h
X   55r90  hX   CONTr:0  hX   INFORMr;0  h]r<0  X
   functionalityr=0  ah]r>0  X   ssh_freer?0  auK9}r@0  (hX   21rA0  h	X1   Parameters\nsession: The SSH session to free.\n\nrB0  hX   ApizarC0  h
X   56rD0  hX   CONTrE0  hX   INFORMrF0  h]rG0  X   basicrH0  ah]rI0  X   ssh_freerJ0  auK:}rK0  (hX   21rL0  h	X,   See also\nssh_disconnect()\nssh_new()\n\n```rM0  hX   ApizarN0  h
X   57rO0  hX   CONTrP0  hX   INFORMrQ0  hNh]rR0  X   ssh_freerS0  auK;}rT0  (hX   22rU0  h	X   open ssh_channelrV0  hX
   ProgrammerrW0  h
NhNhX   ELICIT-OFFER-OR-SUGGESTIONrX0  h]rY0  X   patternsrZ0  ah]r[0  X   ssh_channelr\0  auK<}r]0  (hX   23r^0  h	X&   Execute a command on the open channel.r_0  hX
   Programmerr`0  h
NhNhX   ELICIT-OFFER-OR-SUGGESTIONra0  h]rb0  X   patternsrc0  ah]rd0  X   ssh_channelre0  auK=}rf0  (hX   24rg0  h	X   read response from the channelrh0  hX
   Programmerri0  h
NhNhX   ELICIT-OFFER-OR-SUGGESTIONrj0  h]rk0  X   patternsrl0  ah]rm0  X   ssh_channelrn0  auK>}ro0  (hX   25rp0  h	X   shut down channelrq0  hX
   Programmerrr0  h
NhNhX   ELICIT-OFFER-OR-SUGGESTIONrs0  h]rt0  X   patternsru0  ah]rv0  X   ssh_channelrw0  auK?}rx0  (hX   26ry0  h	X   free the channelrz0  hX
   Programmerr{0  h
NhNhX   ELICIT-OFFER-OR-SUGGESTIONr|0  h]r}0  X   patternsr~0  ah]r0  X   ssh_channelr0  auK@}r0  (hX   27r0  h	X=   There are lots of functions that might help open ssh_channel.r0  hX   Apizar0  h
X   59r0  hX   PARTr0  hX   INFORMr0  h]r0  X   patternsr0  ah]r0  X   ssh_channelr0  auKA}r0  (hX   27r0  h	X   Here's one:\n\nr0  hX   Apizar0  h
X   59r0  hX   POSr0  hX   SUGGESTr0  h]r0  X   patternsr0  ah]r0  X   ssh_channel_open_sessionr0  auKB}r0  (hX   27r0  h	XB   ```\nint ssh_channel_open_session\t(\tssh_channel \tchannel\t)\n\nr0  hX   Apizar0  h
X   65r0  hX   CONTr0  hX   INFORMr0  h]r0  X   basicr0  ah]r0  X   ssh_channel_open_sessionr0  auKC}r0  (hX   27r0  h	XQ   Description\nOpen a session channel (suited for a shell, not TCP forwarding).\n\nr0  hX   Apizar0  h
X   66r0  hX   CONTr0  hX   INFORMr0  h]r0  (X
   functionalityr0  X   purposer0  eh]r0  X   ssh_channel_open_sessionr0  auKD}r0  (hX   27r0  h	X.   Parameters\nchannel: An allocated channel.\n\nr0  hX   Apizar0  h
X   67r0  hX   CONTr0  hX   INFORMr0  h]r0  X   basicr0  ah]r0  X   ssh_channel_open_sessionr0  auKE}r0  (hX   27r0  h	X   Returns\nSSH_OK on success, SSH_ERROR if an error occurred, SSH_AGAIN if in nonblocking mode and call has to be done again.\n\nr0  hX   Apizar0  h
X   68r0  hX   CONTr0  hX   INFORMr0  h]r0  X
   functionalityr0  ah]r0  X   ssh_channel_open_sessionr0  auKF}r0  (hX   27r0  h	X   See also\nssh_channel_open_forward()\nssh_channel_request_env()\nssh_channel_request_shell()\nssh_channel_request_exec()\n\n```r0  hX   Apizar0  h
X   69r0  hX   CONTr0  hX   INFORMr0  hNh]r0  X   ssh_channel_open_sessionr0  auKG}r0  (hX   28r0  h	X9   Here is a function that might help execute a command:\n\nr0  hX   Apizar0  h
X   60r0  hX   POSr0  hX   SUGGESTr0  h]r0  X   patternsr0  ah]r0  X   ssh_channel_request_execr0  auKH}r0  (hX   28r0  h	XX   ```\nint ssh_channel_request_exec\t(\tssh_channel \tchannel,\nconst char * \tcmd \n)\n\nr0  hX   Apizar0  h
X   71r0  hX   CONTr0  hX   INFORMr0  h]r0  X   basicr0  ah]r0  X   ssh_channel_request_execr0  auKI}r0  (hX   28r0  h	Xi   Description\nRun a shell command without an interactive shell.\nThis is similar to \'sh -c command\'.\n\nr0  hX   Apizar0  h
X   72r0  hX   CONTr0  hX   INFORMr0  h]r0  X
   functionalityr0  ah]r0  X   ssh_channel_request_execr0  auKJ}r0  (hX   28r0  h	X   Parameters\nchannel: The channel to execute the command.\ncmd: The command to execute (e.g. "ls ~/ -al | grep -i reports").\n\nr0  hX   Apizar0  h
X   73r0  hX   CONTr0  hX   INFORMr0  h]r0  (X
   functionalityr0  X   examplesr0  eh]r0  X   ssh_channel_request_execr0  auKK}r0  (hX   28r0  h	X}   Returns\nSSH_OK on success, SSH_ERROR if an error occurred, SSH_AGAIN if in nonblocking mode and call has to be done again.\nr0  hX   Apizar0  h
X   74r0  hX   CONTr0  hX   INFORMr 1  h]r1  X
   functionalityr1  ah]r1  X   ssh_channel_request_execr1  auKL}r1  (hX   28r1  h	X)  Example:\n\nrc = channel_request_exec(channel, "ps aux");\nif (rc &gt; 0) {\n return -1;\n}\nwhile ((rc = channel_read(channel, buffer, sizeof(buffer), 0)) &gt; 0) {\n if (fwrite(buffer, 1, rc, stdout) != (unsigned int) rc) {\n return -1;\n }\n}\n\nSee also\nssh_channel_request_shell()\n\n\n\n```r1  hX   Apizar1  h
X   75r	1  hX   CONTr
1  hX   INFORMr1  h]r1  X   examplesr
1  ah]r1  X   ssh_channel_request_execr1  auKM}r1  (hX   29r1  h	X7   Here is a function that might help read a response:\n\nr1  hX   Apizar1  h
X   61r1  hX   POSr1  hX   SUGGESTr1  h]r1  X   patternsr1  ah]r1  X   ssh_channel_readr1  auKN}r1  (hX   29r1  h	Xp   ```\nint ssh_channel_read\t(\tssh_channel \tchannel,\nvoid * \tdest,\nuint32_t \tcount,\nint \tis_stderr \n)\n\nr1  hX   Apizar1  h
X   77r1  hX   CONTr 1  hX   INFORMr!1  h]r"1  X   basicr#1  ah]r$1  X   ssh_channel_readr%1  auKO}r&1  (hX   29r'1  h	X+   Description\nReads data from a channel.\n\nr(1  hX   Apizar)1  h
X   78r*1  hX   CONTr+1  hX   INFORMr,1  h]r-1  X   basicr.1  ah]r/1  X   ssh_channel_readr01  auKP}r11  (hX   29r21  h	X   Parameters\nchannel: The channel to read from.\ndest: The destination buffer which will get the data.\ncount: The count of bytes to be read.\nis_stderr: A boolean value to mark reading from the stderr flow.\n\nr31  hX   Apizar41  h
X   79r51  hX   CONTr61  hX   INFORMr71  h]r81  X
   functionalityr91  ah]r:1  X   ssh_channel_readr;1  auKQ}r<1  (hX   29r=1  h	X   Returns\nThe number of bytes read, 0 on end of file or SSH_ERROR on error. In nonblocking mode it Can return 0 if no data is available or SSH_AGAIN.\n\n```r>1  hX   Apizar?1  h
X   80r@1  hX   CONTrA1  hX   INFORMrB1  h]rC1  X
   functionalityrD1  ah]rE1  X   ssh_channel_readrF1  auKR}rG1  (hX   30rH1  h	X   new channelrI1  hX
   ProgrammerrJ1  h
NhNhX   ELICIT-OFFER-OR-SUGGESTIONrK1  h]rL1  X   patternsrM1  ah]rN1  X   ssh_channelrO1  auKS}rP1  (hX   31rQ1  h	X=   Here is a function that might help shut down the channel:\n\nrR1  hX   ApizarS1  h
X   62rT1  hX   POSrU1  hX   SUGGESTrV1  h]rW1  X   patternsrX1  ah]rY1  (X   ssh_channelrZ1  X
   ssh_scp_closer[1  euKT}r\1  (hX   31r]1  h	X/   ```\nint ssh_scp_close\t(\tssh_scp \tscp\t)\n\nr^1  hX   Apizar_1  h
X   83r`1  hX   CONTra1  hX   INFORMrb1  h]rc1  X   basicrd1  ah]re1  X
   ssh_scp_closerf1  auKU}rg1  (hX   31rh1  h	X'   Description\nClose the scp channel.\n\nri1  hX   Apizarj1  h
X   84rk1  hX   CONTrl1  hX   INFORMrm1  h]rn1  X   basicro1  ah]rp1  X
   ssh_scp_closerq1  auKV}rr1  (hX   31rs1  h	X.   Parameters\nscp: The scp context to close.\n\nrt1  hX   Apizaru1  h
X   85rv1  hX   CONTrw1  hX   INFORMrx1  h]ry1  X   basicrz1  ah]r{1  X
   ssh_scp_closer|1  auKW}r}1  (hX   31r~1  h	X4   Returns\nSSH_OK on success or an SSH error code.\n\nr1  hX   Apizar1  h
X   86r1  hX   CONTr1  hX   INFORMr1  h]r1  X
   functionalityr1  ah]r1  X
   ssh_scp_closer1  auKX}r1  (hX   31r1  h	X#   See also\nssh_scp_init()\n\n\n\n```r1  hX   Apizar1  h
X   87r1  hX   CONTr1  hX   INFORMr1  hNh]r1  X
   ssh_scp_closer1  auKY}r1  (hX   32r1  h	X8   Here is a function that might help free the channel:\n\nr1  hX   Apizar1  h
X   63r1  hX   POSr1  hX   SUGGESTr1  h]r1  X   patternsr1  ah]r1  (X   ssh_channelr1  X   ssh_channel_freer1  euKZ}r1  (hX   32r1  h	X;   ```\nvoid ssh_channel_free\t(\tssh_channel \tchannel\t)\n\nr1  hX   Apizar1  h
X   89r1  hX   CONTr1  hX   INFORMr1  h]r1  X   basicr1  ah]r1  X   ssh_channel_freer1  auK[}r1  (hX   32r1  h	X*   Description\nClose and free a channel.\n\nr1  hX   Apizar1  h
X   90r1  hX   CONTr1  hX   INFORMr1  h]r1  X   basicr1  ah]r1  X   ssh_channel_freer1  auK\}r1  (hX   32r1  h	X0   Parameters\nchannel: The channel to free.\n\n```r1  hX   Apizar1  h
X   91r1  hX   CONTr1  hX   INFORMr1  h]r1  X   basicr1  ah]r1  X   ssh_channel_freer1  auK]}r1  (hX   33r1  h	X9   Here is a function that might help get a new channel:\n\nr1  hX   Apizar1  h
X   82r1  hX   POSr1  hX   SUGGESTr1  h]r1  X   patternsr1  ah]r1  (X   ssh_channelr1  X   ssh_channel_newr1  euK^}r1  (hX   33r1  h	XA   ```\nssh_channel ssh_channel_new\t(\tssh_session \tsession\t)\n\nr1  hX   Apizar1  h
X   93r1  hX   CONTr1  hX   INFORMr1  h]r1  X   basicr1  ah]r1  X   ssh_channel_newr1  auK_}r1  (hX   33r1  h	X(   Description\nAllocate a new channel.\n\nr1  hX   Apizar1  h
X   94r1  hX   CONTr1  hX   INFORMr1  h]r1  X   basicr1  ah]r1  X   ssh_channel_newr1  auK`}r1  (hX   33r1  h	X0   Parameters\nsession: The ssh session to use.\n\nr1  hX   Apizar1  h
X   95r1  hX   CONTr1  hX   INFORMr1  h]r1  X   basicr1  ah]r1  X   ssh_channel_newr1  auKa}r1  (hX   33r1  h	XF   Returns\nA pointer to a newly allocated channel, NULL on error.\n\n```r1  hX   Apizar1  h
X   96r1  hX   CONTr1  hX   INFORMr1  h]r1  X
   functionalityr1  ah]r1  X   ssh_channel_newr1  auKb}r1  (hX   34r1  h	X   get error from channelr1  hX
   Programmerr1  h
NhNhX   ELICIT-OFFER-OR-SUGGESTIONr1  h]r1  X   patternsr1  ah]r1  X   ssh_channelr1  auKc}r1  (hX   35r 2  h	X2   Here is a function that might help get an error:\nr2  hX   Apizar2  h
X   98r2  hX   POSr2  hX   SUGGESTr2  h]r2  X   patternsr2  ah]r2  X
   ssh_get_errorr	2  auKd}r
2  (hX   35r2  h	X8   ```\nconst char* ssh_get_error\t(\tvoid * \terror\t)\n\nr2  hX   Apizar
2  h
X   99r2  hX   CONTr2  hX   INFORMr2  h]r2  X   basicr2  ah]r2  X
   ssh_get_errorr2  auKe}r2  (hX   35r2  h	XE   Description\nRetrieve the error text message from the last error.\n\nr2  hX   Apizar2  h
X   100r2  hX   CONTr2  hX   INFORMr2  h]r2  X
   functionalityr2  ah]r2  X
   ssh_get_errorr2  auKf}r 2  (hX   35r!2  h	X2   Parameters\nerror: An ssh_session or ssh_bind.\n\nr"2  hX   Apizar#2  h
X   101r$2  hX   CONTr%2  hX   INFORMr&2  h]r'2  X   basicr(2  ah]r)2  X
   ssh_get_errorr*2  auKg}r+2  (hX   35r,2  h	X7   Returns\nA static string describing the error.\n\n\n```r-2  hX   Apizar.2  h
X   102r/2  hX   CONTr02  hX   INFORMr12  h]r22  X
   functionalityr32  ah]r42  X
   ssh_get_errorr52  auKh}r62  (hX   36r72  h	X   sending the eofr82  hX
   Programmerr92  h
NhNhX   ELICIT-OFFER-OR-SUGGESTIONr:2  h]r;2  X   patternsr<2  ahNuKi}r=2  (hX   37r>2  h	X4   Here is a function that might help send the eof:\n\nr?2  hX   Apizar@2  h
X   104rA2  hX   POSrB2  hX   SUGGESTrC2  h]rD2  X   patternsrE2  ah]rF2  X   ssh_channel_send_eofrG2  auKj}rH2  (hX   37rI2  h	X>   ```\nint ssh_channel_send_eof\t(\tssh_channel \tchannel\t)\n\nrJ2  hX   ApizarK2  h
X   105rL2  hX   CONTrM2  hX   INFORMrN2  h]rO2  X   basicrP2  ah]rQ2  X   ssh_channel_send_eofrR2  auKk}rS2  (hX   37rT2  h	X   Description\nSend an end of file on the channel.\nThis doesn't close the channel. You may still read from it but not write.\n\nrU2  hX   ApizarV2  h
X   106rW2  hX   CONTrX2  hX   INFORMrY2  h]rZ2  X
   functionalityr[2  ah]r\2  X   ssh_channel_send_eofr]2  auKl}r^2  (hX   37r_2  h	X8   Parameters\nchannel: The channel to send the eof to.\n\nr`2  hX   Apizara2  h
X   107rb2  hX   CONTrc2  hX   INFORMrd2  h]re2  X   basicrf2  ah]rg2  X   ssh_channel_send_eofrh2  auKm}ri2  (hX   37rj2  h	X=   Returns\nSSH_OK on success, SSH_ERROR if an error occurred.\nrk2  hX   Apizarl2  h
X   108rm2  hX   CONTrn2  hX   INFORMro2  h]rp2  X
   functionalityrq2  ah]rr2  X   ssh_channel_send_eofrs2  auKn}rt2  (hX   37ru2  h	XU  Example:\n\nrc = ssh_channel_send_eof(channel);\nif (rc == SSH_ERROR) {\n return -1;\n}\nwhile(!ssh_channel_is_eof(channel)) {\n rc = ssh_channel_read(channel, buf, sizeof(buf), 0);\n if (rc == SSH_ERROR) {\n return -1;\n }\n}\nssh_channel_close(channel);\n\nSee also\nssh_channel_close()\nssh_channel_free()\nssh_channel_is_eof()\n\n\n\n```rv2  hX   Apizarw2  h
X   109rx2  hX   CONTry2  hX   INFORMrz2  h]r{2  X   examplesr|2  ah]r}2  X   ssh_channel_send_eofr~2  auKo}r2  (hX   38r2  h	X
   close channelr2  hX
   Programmerr2  h
NhNhX   ELICIT-OFFER-OR-SUGGESTIONr2  h]r2  X   patternsr2  ah]r2  X   ssh_channel_closer2  auKp}r2  (hX   39r2  h	X9   Here is a function that might help close the channel:\n\nr2  hX   Apizar2  h
X   111r2  hX   POSr2  hX   SUGGESTr2  h]r2  X   patternsr2  ah]r2  X   ssh_channel_closer2  auKq}r2  (hX   39r2  h	X;   ```\nint ssh_channel_close\t(\tssh_channel \tchannel\t)\n\nr2  hX   Apizar2  h
X   112r2  hX   CONTr2  hX   INFORMr2  h]r2  X   basicr2  ah]r2  X   ssh_channel_closer2  auKr}r2  (hX   39r2  h	X   Description\nClose a channel.\nThis sends an end of file and then closes the channel. You won't be able to recover any data the server was going to send or was in buffers.\n\nr2  hX   Apizar2  h
X   113r2  hX   CONTr2  hX   INFORMr2  h]r2  X
   functionalityr2  ah]r2  X   ssh_channel_closer2  auKs}r2  (hX   39r2  h	X.   Parameters\nchannel: The channel to close.\n\nr2  hX   Apizar2  h
X   114r2  hX   CONTr2  hX   INFORMr2  h]r2  X   basicr2  ah]r2  X   ssh_channel_closer2  auKt}r2  (hX   39r2  h	X?   Returns\nSSH_OK on success, SSH_ERROR if an error occurred.\n\nr2  hX   Apizar2  h
X   115r2  hX   CONTr2  hX   INFORMr2  h]r2  X
   functionalityr2  ah]r2  X   ssh_channel_closer2  auKu}r2  (hX   39r2  h	X7   See also\nssh_channel_free()\nssh_channel_is_eof()\n```r2  hX   Apizar2  h
X   116r2  hX   CONTr2  hX   INFORMr2  h]r2  (X   patternsr2  X   examplesr2  X   basicr2  eh]r2  X   ssh_channel_closer2  auKv}r2  (hX   40r2  h	X   new sftp_sessionr2  hX
   Programmerr2  h
NhNhX   ELICIT-OFFER-OR-SUGGESTIONr2  h]r2  X   patternsr2  ah]r2  X   sftp_sessionr2  auKw}r2  (hX   41r2  h	X   Create a new directoryr2  hX
   Programmerr2  h
NhNhX   ELICIT-OFFER-OR-SUGGESTIONr2  h]r2  X   patternsr2  ahNuKx}r2  (hX   42r2  h	X   Create a new filer2  hX
   Programmerr2  h
NhNhX   ELICIT-OFFER-OR-SUGGESTIONr2  h]r2  X   patternsr2  ahNuKy}r2  (hX   43r2  h	X>   Here is a function that might help get a new sftp session:\n\nr2  hX   Apizar2  h
X   118r2  hX   POSr2  hX   SUGGESTr2  h]r2  X   patternsr2  ah]r2  X   sftp_sessionr2  auKz}r2  (hX   43r2  h	X;   ```\nsftp_session sftp_new\t(\tssh_session \tsession\t)\n\nr2  hX   Apizar2  h
X   121r2  hX   CONTr2  hX   INFORMr2  h]r2  X   basicr2  ah]r2  X   sftp_newr2  auK{}r2  (hX   43r2  h	X*   Description\nStart a new sftp session.\n\nr2  hX   Apizar2  h
X   122r2  hX   CONTr2  hX   INFORMr2  h]r 3  X   basicr3  ah]r3  X   sftp_newr3  auK|}r3  (hX   43r3  h	X0   Parameters\nsession: The ssh session to use.\n\nr3  hX   Apizar3  h
X   123r3  hX   CONTr	3  hX   INFORMr
3  h]r3  X   basicr3  ah]r
3  X   sftp_newr3  auK}}r3  (hX   43r3  h	X1   Returns\nA new sftp session or NULL on error.\n\nr3  hX   Apizar3  h
X   124r3  hX   CONTr3  hX   INFORMr3  h]r3  (X
   functionalityr3  X   basicr3  eh]r3  X   sftp_newr3  auK~}r3  (hX   43r3  h	X   See also\nsftp_free()\n```r3  hX   Apizar3  h
X   125r3  hX   CONTr 3  hX   INFORMr!3  hNh]r"3  X   sftp_newr#3  auK}r$3  (hX   44r%3  h	X   Write to the filer&3  hX
   Programmerr'3  h
NhNhX   ELICIT-OFFER-OR-SUGGESTIONr(3  h]r)3  X   patternsr*3  ahNuK}r+3  (hX   45r,3  h	X>   Here is a function that might help create a new directory:\n\nr-3  hX   Apizar.3  h
X   119r/3  hX   POSr03  hX   SUGGESTr13  h]r23  X   patternsr33  ah]r43  X
   sftp_mkdirr53  auK}r63  (hX   45r73  h	X^   ```\nint sftp_mkdir\t(\tsftp_session \tsftp,\nconst char * \tdirectory,\nmode_t \tmode \n)\n\nr83  hX   Apizar93  h
X   128r:3  hX   CONTr;3  hX   INFORMr<3  h]r=3  X   basicr>3  ah]r?3  X
   sftp_mkdirr@3  auK}rA3  (hX   45rB3  h	X$   Description\nCreate a directory.\n\nrC3  hX   ApizarD3  h
X   129rE3  hX   CONTrF3  hX   INFORMrG3  h]rH3  X   basicrI3  ah]rJ3  X
   sftp_mkdirrK3  auK}rL3  (hX   45rM3  h	X   Parameters\nsftp: The sftp session handle.\ndirectory: The directory to create.\nmode: Specifies the permissions to use. It is modified by the process's umask in the usual way: The permissions of the created file are (mode &amp; ~umask)\n\nrN3  hX   ApizarO3  h
X   130rP3  hX   CONTrQ3  hX   INFORMrR3  h]rS3  X
   functionalityrT3  ah]rU3  X
   sftp_mkdirrV3  auK}rW3  (hX   45rX3  h	XG   Returns\n0 on success, &lt; 0 on error with ssh and sftp error set.\n\nrY3  hX   ApizarZ3  h
X   131r[3  hX   CONTr\3  hX   INFORMr]3  h]r^3  X
   functionalityr_3  ah]r`3  X
   sftp_mkdirra3  auK}rb3  (hX   45rc3  h	X!   See also\nsftp_get_error()\n\n```rd3  hX   Apizare3  h
X   132rf3  hX   CONTrg3  hX   INFORMrh3  hNh]ri3  X
   sftp_mkdirrj3  auK}rk3  (hX   46rl3  h	X9   Here is a function that might help create a new file:\n\nrm3  hX   Apizarn3  h
X   120ro3  hX   POSrp3  hX   SUGGESTrq3  h]rr3  X   patternsrs3  ah]rt3  X	   sftp_openru3  auK}rv3  (hX   46rw3  h	Xt   ```\nsftp_file sftp_open\t(\tsftp_session \tsession,\nconst char * \tfile,\nint \taccesstype,\nmode_t \tmode \n)\n\nrx3  hX   Apizary3  h
X   134rz3  hX   CONTr{3  hX   INFORMr|3  h]r}3  X   basicr~3  ah]r3  X	   sftp_openr3  auK}r3  (hX   46r3  h	X+   Description\nOpen a file on the server.\n\nr3  hX   Apizar3  h
X   135r3  hX   CONTr3  hX   INFORMr3  h]r3  X   basicr3  ah]r3  X	   sftp_openr3  auK}r3  (hX   46r3  h	X  Parameters\nsession: The sftp session handle.\nfile: The file to be opened.\naccesstype: Is one of O_RDONLY, O_WRONLY or O_RDWR which request opening the file read-only,write-only or read/write. Acesss may also be bitwise-or'd with one or more of the following: O_CREAT - If the file does not exist it will be created. O_EXCL - When used with O_CREAT, if the file already exists it is an error and the open will fail. O_TRUNC - If the file already exists it will be truncated.\nmode: Mode specifies the permissions to use if a new file is created. It is modified by the process's umask in the usual way: The permissions of the created file are (mode &amp; ~umask)\n\nr3  hX   Apizar3  h
X   136r3  hX   CONTr3  hX   INFORMr3  h]r3  X
   functionalityr3  ah]r3  X	   sftp_openr3  auK}r3  (hX   46r3  h	XK   Returns\nA sftp file handle, NULL on error with ssh and sftp error set.\n\nr3  hX   Apizar3  h
X   137r3  hX   CONTr3  hX   INFORMr3  h]r3  X
   functionalityr3  ah]r3  X	   sftp_openr3  auK}r3  (hX   46r3  h	X!   See also\nsftp_get_error()\n\n```r3  hX   Apizar3  h
X   138r3  hX   CONTr3  hX   INFORMr3  hNh]r3  X	   sftp_openr3  auK}r3  (hX   47r3  h	X9   Here is a function that might help write to the file:\n\nr3  hX   Apizar3  h
X   127r3  hX   POSr3  hX   SUGGESTr3  h]r3  X   patternsr3  ah]r3  X
   sftp_writer3  auK}r3  (hX   47r3  h	XZ   ```\nssize_t sftp_write\t(\tsftp_file \tfile,\nconst void * \tbuf,\nsize_t \tcount \n)\n\nr3  hX   Apizar3  h
X   140r3  hX   CONTr3  hX   INFORMr3  h]r3  X   basicr3  ah]r3  X
   sftp_writer3  auK}r3  (hX   47r3  h	XB   Description\nWrite to a file using an opened sftp file handle.\n\nr3  hX   Apizar3  h
X   141r3  hX   CONTr3  hX   INFORMr3  h]r3  X
   functionalityr3  ah]r3  X
   sftp_writer3  auK}r3  (hX   47r3  h	X   Parameters\nfile: Open sftp file handle to write to.\nbuf: Pointer to buffer to write data.\ncount: Size of buffer in bytes.\n\nr3  hX   Apizar3  h
X   142r3  hX   CONTr3  hX   INFORMr3  h]r3  X
   functionalityr3  ah]r3  X
   sftp_writer3  auK}r3  (hX   47r3  h	XR   Returns\nNumber of bytes written, &lt; 0 on error with ssh and sftp error set.\n\nr3  hX   Apizar3  h
X   143r3  hX   CONTr3  hX   INFORMr3  h]r3  X
   functionalityr3  ah]r3  X
   sftp_writer3  auK}r3  (hX   47r3  h	X9   See also\nsftp_open()\nsftp_read()\nsftp_close()\n\n\n```r3  hX   Apizar3  h
X   144r3  hX   CONTr3  hX   INFORMr3  hNh]r3  X
   sftp_writer3  auK}r3  (hX   48r3  h	X   sftp get errorr3  hX
   Programmerr3  h
NhNhX   ELICIT-OFFER-OR-SUGGESTIONr3  h]r3  X   patternsr3  ahNuK}r3  (hX   49r3  h	X3   Here is the documentation for `sftp_get_error`:\n\nr3  hX   Apizar3  h
X   146r3  hX   POSr3  hX   INFORMr3  hNh]r3  X   sftp_get_errorr3  auK}r3  (hX   49r3  h	X6   ```\nint sftp_get_error\t(\tsftp_session \tsftp\t)\n\nr3  hX   Apizar3  h
X   147r3  hX   CONTr 4  hX   INFORMr4  h]r4  X   basicr4  ah]r4  X   sftp_get_errorr4  auK}r4  (hX   49r4  h	Xw   Description\nGet the last sftp error.\nUse this function to get the latest error set by a posix like sftp function.\n\nr4  hX   Apizar	4  h
X   148r
4  hX   CONTr4  hX   INFORMr4  h]r
4  X
   functionalityr4  ah]r4  X   sftp_get_errorr4  auK}r4  (hX   49r4  h	X@   Parameters\nsftp: The sftp session where the error is saved.\n\nr4  hX   Apizar4  h
X   149r4  hX   CONTr4  hX   INFORMr4  h]r4  X
   functionalityr4  ah]r4  X   sftp_get_errorr4  auK}r4  (hX   49r4  h	X`   Returns\nThe saved error (see server responses), &lt; 0 if an error in the function occured.\n\nr4  hX   Apizar4  h
X   150r 4  hX   CONTr!4  hX   INFORMr"4  h]r#4  X
   functionalityr$4  ah]r%4  X   sftp_get_errorr&4  auK}r'4  (hX   49r(4  h	X!   See also\nServer responses\n\n```r)4  hX   Apizar*4  h
X   151r+4  hX   CONTr,4  hX   INFORMr-4  hNh]r.4  X   sftp_get_errorr/4  auK}r04  (hX   50r14  h	X   Server responsesr24  hX
   Programmerr34  h
NhNhX
   ELICIT-INFORMr44  h]r54  X   conceptsr64  ahNuK}r74  (hX   51r84  h	X?   I couldn't find anything like that in the LibSSH documentation.r94  hX   Apizar:4  h
X   153r;4  hX   UNCr<4  hX   INFORMr=4  hNhNuK}r>4  (hX   51r?4  h	X(    Here is a web link that might help:\n\nr@4  hX   ApizarA4  h
X   153rB4  hX   POSrC4  hX   INFORMrD4  h]rE4  X
   referencesrF4  ahNuK}rG4  (hX   51rH4  h	X(   <https://winscp.net/eng/docs/sftp_codes>rI4  hX   ApizarJ4  h
X   155rK4  hX   CONTrL4  hX   INFORMrM4  h]rN4  X
   referencesrO4  ahNuK}rP4  (hX   52rQ4  h	X   sftp error coderR4  hX
   ProgrammerrS4  h
NhNhX
   ELICIT-INFORMrT4  h]rU4  X	   structurerV4  ahNuK}rW4  (hX   53rX4  h	X?   I couldn't find anything like that in the LibSSH documentation.rY4  hX   ApizarZ4  h
X   157r[4  hX   UNCr\4  hX   INFORMr]4  hNhNuK}r^4  (hX   53r_4  h	X'   Here is a web link that might help:\n\nr`4  hX   Apizara4  h
X   157rb4  hX   POSrc4  hX   INFORMrd4  h]re4  X
   referencesrf4  ahNuK}rg4  (hX   53rh4  h	XD   <https://www.secureblackbox.com/kb/help/ref_err_sftperrorcodes.html>ri4  hX   Apizarj4  h
X   159rk4  hX   CONTrl4  hX   INFORMrm4  h]rn4  X
   referencesro4  ahNuuuK
}rp4  (hhh}rq4  (K }rr4  (hhh	X   hello Apizars4  hX
   Programmerrt4  h
NhNhX   BE-POSITIVEru4  hNhNuK}rv4  (hhh	X   Hi Programmer_13.rw4  hX   Apizarx4  h
hhX   POSry4  hX   BE-POSITIVErz4  hNhNuK}r{4  (hhh	X;   Let me know if you have any questions about the LibSSH API.r|4  hX   Apizar}4  h
NhNhX   SUGGESTr~4  hNhNuK}r4  (hh+h	X/   how can I connect to the localhost using LibSSHr4  hX
   Programmerr4  h
NhNhX   ELICIT-OFFER-OR-SUGGESTIONr4  h]r4  X   patternsr4  ahNuK}r4  (hh5h	X'   Here is a function that might help:\n\nr4  hX   Apizar4  h
h+hX   POSr4  hX   SUGGESTr4  h]r4  X   patternsr4  ahNuK}r4  (hh5h	X5   ```\nint ssh_connect\t(\tssh_session \tsession\t)\n\nr4  hX   Apizar4  h
h5hX   CONTr4  hX   INFORMr4  h]r4  X   basicr4  ah]r4  X   ssh_connectr4  auK}r4  (hh5h	X+   Description\nConnect to the ssh server.\n\nr4  hX   Apizar4  h
h<hX   CONTr4  hX   INFORMr4  h]r4  X   basicr4  ah]r4  X   ssh_connectr4  auK}r4  (hh5h	X4   Parameters\nsession: The ssh session to connect.\n\nr4  hX   Apizar4  h
hFhX   CONTr4  hX   INFORMr4  h]r4  X   basicr4  ah]r4  X   ssh_connectr4  auK}r4  (hh5h	X   Returns\nSSH_OK on success, SSH_ERROR on error.\nSSH_AGAIN, if the session is in nonblocking mode, and call must be done again.\n\nr4  hX   Apizar4  h
hQhX   CONTr4  hX   INFORMr4  h]r4  X
   functionalityr4  ah]r4  X   ssh_connectr4  auK	}r4  (hh5h	X,   See also\nssh_new()\nssh_disconnect()\n\n```r4  hX   Apizar4  h
hXhX   CONTr4  hX   INFORMr4  hNh]r4  X   ssh_connectr4  auK
}r4  (hh<h	X<   Do you have any examples of this function in use cases Apizar4  hX
   Programmerr4  h
hXhX   FOLr4  hX
   ELICIT-INFORMr4  h]r4  X   examplesr4  ah]r4  X   ssh_connectr4  auK}r4  (hhFh	X   Sorry,r4  hX   Apizar4  h
X   10r4  hX   NEGr4  hX   BE-POSITIVEr4  hNhNuK}r4  (hhFh	X4   the LibSSH documentation doesn't come with examples.r4  hX   Apizar4  h
X   11r4  hX   CONTr4  hX   INFORMr4  hNhNuK
}r4  (hhQh	X$   can you show me the function ssh_newr4  hX
   Programmerr4  h
hchX   FOLr4  hX
   ELICIT-INFORMr4  h]r4  X   basicr4  ah]r4  X   ssh_newr4  auK}r4  (hhXh	X,   Here is the documentation for `ssh_new`:\n\nr4  hX   Apizar4  h
X   13r4  hX   POSr4  hX   INFORMr4  hNh]r4  X   ssh_newr4  auK}r4  (hhXh	X+   ```\nssh_session ssh_new\t(\tvoid \t\t)\n\nr4  hX   Apizar4  h
X   14r4  hX   CONTr4  hX   INFORMr4  h]r4  X   basicr4  ah]r4  X   ssh_newr4  auK}r4  (hhXh	X.   Description\nCreate a new ssh session.\n\n\n\nr4  hX   Apizar4  h
X   15r4  hX   CONTr4  hX   INFORMr4  h]r4  X   basicr4  ah]r4  X   ssh_newr4  auK}r4  (hhXh	X=   Returns\nA new ssh_session pointer, NULL on error.\n\n\n\n```r4  hX   Apizar4  h
X   16r4  hX   CONTr4  hX   INFORMr4  h]r4  X
   functionalityr4  ah]r4  X   ssh_newr4  auK}r4  (hhch	X0   can you show me the documentation on ssh_sessionr4  hX
   Programmerr4  h
NhNhX
   ELICIT-INFORMr4  h]r4  X   basicr 5  ah]r5  X   ssh_sessionr5  auK}r5  (hX   10r5  h	X,   I couldn't find anything exactly like that. r5  hX   Apizar5  h
X   18r5  hX   UNCr5  hX   INFORMr	5  hNhNuK}r
5  (hX   10r5  h	X0   Here is a struct definition that might help:\n\nr5  hX   Apizar
5  h
X   18r5  hX   PARTr5  hX   SUGGESTr5  h]r5  (X	   structurer5  X   basicr5  eh]r5  X   ssh_sessionr5  auK}r5  (hX   10r5  h	X=  ```\nstruct ssh_session_struct {\n struct error_struct error;\n struct ssh_socket_struct *socket;\n char *serverbanner;\n char *clientbanner;\n int protoversion;\n int server;\n int client;\n int openssh;\n uint32_t send_seq;\n uint32_t recv_seq;\n/* status flags */\n int closed;\n int closed_by_except;\n\n int connected;\n /* !=0 when the user got a session handle */\n int alive;\n /* two previous are deprecated */\n /* int auth_service_asked; */\n\n /* session flags (SSH_SESSION_FLAG_*) */\n int flags;\n\n ssh_string banner; /* that's the issue banner from\n the server */\n char *discon_msg; /* disconnect message from\n the remote host */\n ssh_buffer in_buffer;\n PACKET in_packet;\n ssh_buffer out_buffer;\n\n /* the states are used by the nonblocking stuff to remember */\n /* where it was before being interrupted */\n enum ssh_pending_call_e pending_call_state;\n enum ssh_session_state_e session_state;\n int packet_state;\n enum ssh_dh_state_e dh_handshake_state;\n enum ssh_auth_service_state_e auth_service_state;\n enum ssh_auth_state_e auth_state;\n enum ssh_channel_request_state_e global_req_state;\n ssh_string dh_server_signature; /* information used by dh_handshake. */\n KEX server_kex;\n KEX client_kex;\n ssh_buffer in_hashbuf;\n ssh_buffer out_hashbuf;\n struct ssh_crypto_struct *current_crypto;\n struct ssh_crypto_struct *next_crypto; /* next_crypto is going to be used after a SSH2_MSG_NEWKEYS */\n\n ssh_channel channels; /* linked list of channels */\n int maxchannel;\n int exec_channel_opened; /* version 1 only. more\n info in channels1.c */\n ssh_agent agent; /* ssh agent */\n\n/* keyb interactive data */\n struct ssh_kbdint_struct *kbdint;\n int version; /* 1 or 2 */\n /* server host keys */\n ssh_private_key rsa_key;\n ssh_private_key dsa_key;\n /* auths accepted by server */\n int auth_methods;\n int hostkeys; /* contains type of host key wanted by client, in server impl */\n struct ssh_list *ssh_message_list; /* list of delayed SSH messages */\n int (*ssh_message_callback)( struct ssh_session_struct *session, ssh_message msg, void *userdata);\n void *ssh_message_callback_data;\n int log_verbosity; /*cached copy of the option structure */\n int log_indent; /* indentation level in enter_function logs */\n\n void (*ssh_connection_callback)( struct ssh_session_struct *session);\n ssh_callbacks callbacks; /* Callbacks to user functions */\n struct ssh_packet_callbacks_struct default_packet_callbacks;\n struct ssh_list *packet_callbacks;\n struct ssh_socket_callbacks_struct socket_callbacks;\n ssh_poll_ctx default_poll_ctx;\n /* options */\n#ifdef WITH_PCAP\n ssh_pcap_context pcap_ctx; /* pcap debugging context */\n#endif\n char *username;\n char *host;\n char *bindaddr; /* bind the client to an ip addr */\n char *xbanner; /* TODO: looks like it is not needed */\n struct ssh_list *identity;\n char *sshdir;\n char *knownhosts;\n char *wanted_methods[10];\n char compressionlevel;\n unsigned long timeout; /* seconds */\n unsigned long timeout_usec;\n unsigned int port;\n socket_t fd;\n int ssh2;\n int ssh1;\n int StrictHostKeyChecking;\n char *ProxyCommand;\n};\n\n```r5  hX   Apizar5  h
X   20r5  hX   CONTr5  hX   INFORMr5  h]r5  (X	   structurer5  X   basicr5  eh]r 5  X   ssh_sessionr!5  auK}r"5  (hX   11r#5  h	X9   how can I authenticate the server after I have created itr$5  hX
   Programmerr%5  h
NhNhX   ELICIT-OFFER-OR-SUGGESTIONr&5  h]r'5  X   patternsr(5  ahNuK}r)5  (hX   12r*5  h	X'   Here is a function that might help:\n\nr+5  hX   Apizar,5  h
X   22r-5  hX   POSr.5  hX   SUGGESTr/5  h]r05  X   patternsr15  ah]r25  X   ssh_channel_open_auth_agentr35  auK}r45  (hX   12r55  h	XE   ```\nint ssh_channel_open_auth_agent\t(\tssh_channel \tchannel\t)\n\nr65  hX   Apizar75  h
X   23r85  hX   CONTr95  hX   INFORMr:5  h]r;5  X   basicr<5  ah]r=5  X   ssh_channel_open_auth_agentr>5  auK}r?5  (hX   12r@5  h	X,  Description\nOpen an agent authentication forwarding channel.\nThis type of channel can be opened by a server towards a client in order to provide SSH-Agent services to the server-side process. This channel can only be opened if the client claimed support by sending a channel request beforehand.\n\nrA5  hX   ApizarB5  h
X   24rC5  hX   CONTrD5  hX   INFORMrE5  h]rF5  (X
   functionalityrG5  X   purposerH5  eh]rI5  X   ssh_channel_open_auth_agentrJ5  auK}rK5  (hX   12rL5  h	X.   Parameters\nchannel: An allocated channel.\n\nrM5  hX   ApizarN5  h
X   25rO5  hX   CONTrP5  hX   INFORMrQ5  h]rR5  X   basicrS5  ah]rT5  X   ssh_channel_open_auth_agentrU5  auK}rV5  (hX   12rW5  h	X   Returns\nSSH_OK on success, SSH_ERROR if an error occurred, SSH_AGAIN if in nonblocking mode and call has to be done again.\n\nrX5  hX   ApizarY5  h
X   26rZ5  hX   CONTr[5  hX   INFORMr\5  h]r]5  X
   functionalityr^5  ah]r_5  X   ssh_channel_open_auth_agentr`5  auK}ra5  (hX   12rb5  h	X-   See also\nssh_channel_open_forward()\n\n\n```rc5  hX   Apizard5  h
X   27re5  hX   CONTrf5  hX   INFORMrg5  hNh]rh5  X   ssh_channel_open_auth_agentri5  auK}rj5  (hX   13rk5  h	X)   how can I report errors with this libraryrl5  hX
   Programmerrm5  h
NhNhX   ELICIT-OFFER-OR-SUGGESTIONrn5  h]ro5  X   patternsrp5  ahNuK}rq5  (hX   14rr5  h	X'   Here is a function that might help:\n\nrs5  hX   Apizart5  h
X   29ru5  hX   POSrv5  hX   SUGGESTrw5  h]rx5  X   patternsry5  ah]rz5  X
   ssh_get_errorr{5  auK}r|5  (hX   14r}5  h	X8   ```\nconst char* ssh_get_error\t(\tvoid * \terror\t)\n\nr~5  hX   Apizar5  h
X   30r5  hX   CONTr5  hX   INFORMr5  h]r5  X   basicr5  ah]r5  X
   ssh_get_errorr5  auK }r5  (hX   14r5  h	XE   Description\nRetrieve the error text message from the last error.\n\nr5  hX   Apizar5  h
X   31r5  hX   CONTr5  hX   INFORMr5  h]r5  X
   functionalityr5  ah]r5  X
   ssh_get_errorr5  auK!}r5  (hX   14r5  h	X2   Parameters\nerror: An ssh_session or ssh_bind.\n\nr5  hX   Apizar5  h
X   32r5  hX   CONTr5  hX   INFORMr5  h]r5  X   basicr5  ah]r5  X
   ssh_get_errorr5  auK"}r5  (hX   14r5  h	X7   Returns\nA static string describing the error.\n\n\n```r5  hX   Apizar5  h
X   33r5  hX   CONTr5  hX   INFORMr5  h]r5  X
   functionalityr5  ah]r5  X
   ssh_get_errorr5  auK#}r5  (hX   15r5  h	X-   can you show me the ssh_channel documentationr5  hX
   Programmerr5  h
NhNhX
   ELICIT-INFORMr5  h]r5  X   basicr5  ah]r5  X   ssh_channelr5  auK$}r5  (hX   16r5  h	X0   Here is a struct definition that might help:\n\nr5  hX   Apizar5  h
X   35r5  hX   POSr5  hX   INFORMr5  h]r5  (X	   structurer5  X   basicr5  eh]r5  X   ssh_channelr5  auK%}r5  (hX   16r5  h	X  ```\nstruct ssh_channel_struct {\n struct ssh_channel_struct *prev;\n struct ssh_channel_struct *next;\n ssh_session session; /* SSH_SESSION pointer */\n uint32_t local_channel;\n uint32_t local_window;\n int local_eof;\n uint32_t local_maxpacket;\n\n uint32_t remote_channel;\n uint32_t remote_window;\n int remote_eof; /* end of file received */\n uint32_t remote_maxpacket;\n enum ssh_channel_state_e state;\n int delayed_close;\n ssh_buffer stdout_buffer;\n ssh_buffer stderr_buffer;\n void *userarg;\n int version;\n int blocking;\n int exit_status;\n enum ssh_channel_request_state_e request_state;\n ssh_channel_callbacks callbacks;\n};\n\n\n```r5  hX   Apizar5  h
X   36r5  hX   CONTr5  hX   INFORMr5  h]r5  (X	   structurer5  X   basicr5  eh]r5  X   ssh_channelr5  auK&}r5  (hX   17r5  h	X'   how can I get a channel from a session?r5  hX
   Programmerr5  h
NhNhX   ELICIT-OFFER-OR-SUGGESTIONr5  h]r5  X   patternsr5  ah]r5  (X   ssh_channelr5  X   ssh_sessionr5  euK'}r5  (hX   18r5  h	X'   Here is a function that might help:\n\nr5  hX   Apizar5  h
X   38r5  hX   POSr5  hX   SUGGESTr5  h]r5  X   patternsr5  ah]r5  (X   ssh_channelr5  X   ssh_sessionr5  X   ssh_channel_get_sessionr5  euK(}r5  (hX   18r5  h	XI   ```\nssh_session ssh_channel_get_session\t(\tssh_channel \tchannel\t)\n\nr5  hX   Apizar5  h
X   39r5  hX   CONTr5  hX   INFORMr5  h]r5  X   basicr5  ah]r5  X   ssh_channel_get_sessionr5  auK)}r5  (hX   18r5  h	X@   Description\nRecover the session in which belongs a channel.\n\nr5  hX   Apizar5  h
X   40r5  hX   CONTr5  hX   INFORMr5  h]r5  X
   functionalityr5  ah]r5  X   ssh_channel_get_sessionr5  auK*}r5  (hX   18r5  h	XA   Parameters\nchannel: The channel to recover the session from.\n\nr5  hX   Apizar5  h
X   41r5  hX   CONTr5  hX   INFORMr5  h]r5  X   basicr5  ah]r5  X   ssh_channel_get_sessionr 6  auK+}r6  (hX   18r6  h	X%   Returns\nThe session pointer.\n\n\n``r6  hX   Apizar6  h
X   42r6  hX   CONTr6  hX   INFORMr6  h]r6  X   basicr	6  ah]r
6  X   ssh_channel_get_sessionr6  auK,}r6  (hX   19r
6  h	X-   how can I authenticate the user to the serverr6  hX
   Programmerr6  h
NhNhX   ELICIT-OFFER-OR-SUGGESTIONr6  h]r6  X   patternsr6  ahNuK-}r6  (hX   20r6  h	X'   Here is a function that might help:\n\nr6  hX   Apizar6  h
X   44r6  hX   POSr6  hX   SUGGESTr6  h]r6  X   patternsr6  ah]r6  X   ssh_userauth_noner6  auK.}r6  (hX   20r6  h	XV   ```\nint ssh_userauth_none\t(\tssh_session \tsession,\nconst char * \tusername \n)\n\nr 6  hX   Apizar!6  h
X   45r"6  hX   CONTr#6  hX   INFORMr$6  h]r%6  X   basicr&6  ah]r'6  X   ssh_userauth_noner(6  auK/}r)6  (hX   20r*6  h	X?   Description\nTry to authenticate through the "none" method.\n\nr+6  hX   Apizar,6  h
X   46r-6  hX   CONTr.6  hX   INFORMr/6  h]r06  X
   functionalityr16  ah]r26  X   ssh_userauth_noner36  auK0}r46  (hX   20r56  h	X^   Parameters\nsession: The ssh session to use.\nusername: The username, this SHOULD be NULL.\n\nr66  hX   Apizar76  h
X   47r86  hX   CONTr96  hX   INFORMr:6  h]r;6  (X
   functionalityr<6  X
   directivesr=6  eh]r>6  X   ssh_userauth_noner?6  auK1}r@6  (hX   20rA6  h	XD  Returns\nSSH_AUTH_ERROR: A serious error happened.\nSSH_AUTH_DENIED: Authentication failed: use another method\nSSH_AUTH_PARTIAL: You\'ve been partially authenticated, you still have to use another method\nSSH_AUTH_SUCCESS: Authentication success\nSSH_AUTH_AGAIN: In nonblocking mode, you\'ve got to call this again later.\nrB6  hX   ApizarC6  h
X   48rD6  hX   CONTrE6  hX   INFORMrF6  h]rG6  X
   functionalityrH6  ah]rI6  X   ssh_userauth_nonerJ6  auK2}rK6  (hX   20rL6  h	X   Note\nMost server implementations do not permit changing the username during authentication. The username should only be set with ssh_options_set() only before you connect to the server.\n\n\n```rM6  hX   ApizarN6  h
X   49rO6  hX   CONTrP6  hX   INFORMrQ6  h]rR6  (X
   functionalityrS6  X
   directivesrT6  eh]rU6  X   ssh_userauth_nonerV6  auK3}rW6  (hX   21rX6  h	X   Apiza I am running into this error when attempting to use the ssh_get_error method error: expected expression before 'ssh_session'rY6  hX
   ProgrammerrZ6  h
X   31r[6  hX   FOLr\6  hX   INFORMr]6  h]r^6  X
   functionalityr_6  ah]r`6  X
   ssh_get_errorra6  auK4}rb6  (hX   21rc6  h	X+   do you know how to help me with that error?rd6  hX
   Programmerre6  h
X   51rf6  hX   CONTrg6  hX   ELICIT-OFFER-OR-SUGGESTIONrh6  h]ri6  X
   functionalityrj6  ah]rk6  X
   ssh_get_errorrl6  auK5}rm6  (hX   22rn6  h	X#   I'm not sure how to help with that.ro6  hX   Apizarp6  h
X   52rq6  hX   UNCrr6  hX   INFORMrs6  hNhNuK6}rt6  (hX   22ru6  h	X   Sorry!rv6  hX   Apizarw6  h
X   53rx6  hX   CONTry6  hX   BE-POSITIVErz6  hNhNuK7}r{6  (hX   23r|6  h	XD   Do you have any additional information on the ssh_get_error functionr}6  hX
   Programmerr~6  h
X   31r6  hX   FOLr6  hX
   ELICIT-INFORMr6  h]r6  X   basicr6  ah]r6  X
   ssh_get_errorr6  auK8}r6  (hX   24r6  h	X;   Here is the complete documentation for `ssh_get_error`:\n\nr6  hX   Apizar6  h
X   55r6  hX   POSr6  hX   INFORMr6  hNh]r6  X
   ssh_get_errorr6  auK9}r6  (hX   24r6  h	X8   ```\nconst char* ssh_get_error\t(\tvoid * \terror\t)\n\nr6  hX   Apizar6  h
X   56r6  hX   CONTr6  hX   INFORMr6  h]r6  X   basicr6  ah]r6  X
   ssh_get_errorr6  auK:}r6  (hX   24r6  h	XE   Description\nRetrieve the error text message from the last error.\n\nr6  hX   Apizar6  h
X   57r6  hX   CONTr6  hX   INFORMr6  h]r6  X
   functionalityr6  ah]r6  X
   ssh_get_errorr6  auK;}r6  (hX   24r6  h	X2   Parameters\nerror: An ssh_session or ssh_bind.\n\nr6  hX   Apizar6  h
X   58r6  hX   CONTr6  hX   INFORMr6  h]r6  X   basicr6  ah]r6  X
   ssh_get_errorr6  auK<}r6  (hX   24r6  h	X9   Returns\nA static string describing the error.\n\n```\n\nr6  hX   Apizar6  h
X   59r6  hX   CONTr6  hX   INFORMr6  h]r6  X
   functionalityr6  ah]r6  X
   ssh_get_errorr6  auK=}r6  (hX   24r6  h	X:   There is also a related function `ssh_get_error_code`:\n\nr6  hX   Apizar6  h
X   60r6  hX   FOLr6  hX   SUGGESTr6  h]r6  X	   structurer6  ah]r6  X   ssh_get_error_coder6  auK>}r6  (hX   24r6  h	X5   ```\nint ssh_get_error_code\t(\tvoid * \terror\t)\n\nr6  hX   Apizar6  h
X   61r6  hX   CONTr6  hX   INFORMr6  h]r6  X   basicr6  ah]r6  X   ssh_get_error_coder6  auK?}r6  (hX   24r6  h	X=   Description\nRetrieve the error code from the last error.\n\nr6  hX   Apizar6  h
X   62r6  hX   CONTr6  hX   INFORMr6  h]r6  X
   functionalityr6  ah]r6  X   ssh_get_error_coder6  auK@}r6  (hX   24r6  h	X2   Parameters\nerror: An ssh_session or ssh_bind.\n\nr6  hX   Apizar6  h
X   63r6  hX   CONTr6  hX   INFORMr6  h]r6  X   basicr6  ah]r6  X   ssh_get_error_coder6  auKA}r6  (hX   24r6  h	X  Returns\nSSH_NO_ERROR No error occurred\nSSH_REQUEST_DENIED The last request was denied but situation is recoverable\nSSH_FATAL A fatal error occurred. This could be an unexpected disconnection\nOther error codes are internal but can be considered same than SSH_FATAL.\n```r6  hX   Apizar6  h
X   64r6  hX   CONTr6  hX   INFORMr6  h]r6  X
   functionalityr6  ah]r6  X   ssh_get_error_coder6  auKB}r6  (hX   25r6  h	X    how can I open a new ssh_channelr6  hX
   Programmerr6  h
NhNhX   ELICIT-OFFER-OR-SUGGESTIONr6  h]r6  X   patternsr6  ah]r6  X   ssh_channelr6  auKC}r6  (hX   26r6  h	X'   Here is a function that might help:\n\nr6  hX   Apizar6  h
X   66r6  hX   POSr 7  hX   SUGGESTr7  h]r7  X   patternsr7  ah]r7  (X   ssh_channelr7  X   ssh_channel_newr7  euKD}r7  (hX   26r7  h	XA   ```\nssh_channel ssh_channel_new\t(\tssh_session \tsession\t)\n\nr	7  hX   Apizar
7  h
X   67r7  hX   CONTr7  hX   INFORMr
7  h]r7  X   basicr7  ah]r7  X   ssh_channel_newr7  auKE}r7  (hX   26r7  h	X(   Description\nAllocate a new channel.\n\nr7  hX   Apizar7  h
X   68r7  hX   CONTr7  hX   INFORMr7  h]r7  X   basicr7  ah]r7  X   ssh_channel_newr7  auKF}r7  (hX   26r7  h	X0   Parameters\nsession: The ssh session to use.\n\nr7  hX   Apizar 7  h
X   69r!7  hX   CONTr"7  hX   INFORMr#7  h]r$7  X   basicr%7  ah]r&7  X   ssh_channel_newr'7  auKG}r(7  (hX   26r)7  h	XF   Returns\nA pointer to a newly allocated channel, NULL on error.\n\n```r*7  hX   Apizar+7  h
X   70r,7  hX   CONTr-7  hX   INFORMr.7  h]r/7  X
   functionalityr07  ah]r17  X   ssh_channel_newr27  auKH}r37  (hX   27r47  h	X5   how do I excecute the who command on the open channelr57  hX
   Programmerr67  h
NhNhX   ELICIT-OFFER-OR-SUGGESTIONr77  h]r87  X   patternsr97  ah]r:7  X   ssh_channelr;7  auKI}r<7  (hX   28r=7  h	X'   Here is a function that might help:\n\nr>7  hX   Apizar?7  h
X   72r@7  hX   POSrA7  hX   SUGGESTrB7  h]rC7  X   patternsrD7  ah]rE7  (X   ssh_channelrF7  X   ssh_channel_request_execrG7  euKJ}rH7  (hX   28rI7  h	XX   ```\nint ssh_channel_request_exec\t(\tssh_channel \tchannel,\nconst char * \tcmd \n)\n\nrJ7  hX   ApizarK7  h
X   73rL7  hX   CONTrM7  hX   INFORMrN7  h]rO7  X   basicrP7  ah]rQ7  X   ssh_channel_request_execrR7  auKK}rS7  (hX   28rT7  h	Xi   Description\nRun a shell command without an interactive shell.\nThis is similar to \'sh -c command\'.\n\nrU7  hX   ApizarV7  h
X   74rW7  hX   CONTrX7  hX   INFORMrY7  h]rZ7  X
   functionalityr[7  ah]r\7  X   ssh_channel_request_execr]7  auKL}r^7  (hX   28r_7  h	X   Parameters\nchannel: The channel to execute the command.\ncmd: The command to execute (e.g. "ls ~/ -al | grep -i reports").\n\nr`7  hX   Apizara7  h
X   75rb7  hX   CONTrc7  hX   INFORMrd7  h]re7  (X
   functionalityrf7  X   examplesrg7  eh]rh7  X   ssh_channel_request_execri7  auKM}rj7  (hX   28rk7  h	X}   Returns\nSSH_OK on success, SSH_ERROR if an error occurred, SSH_AGAIN if in nonblocking mode and call has to be done again.\nrl7  hX   Apizarm7  h
X   76rn7  hX   CONTro7  hX   INFORMrp7  h]rq7  X
   functionalityrr7  ah]rs7  X   ssh_channel_request_execrt7  auKN}ru7  (hX   28rv7  h	X)  Example:\n\nrc = channel_request_exec(channel, "ps aux");\nif (rc &gt; 0) {\n return -1;\n}\nwhile ((rc = channel_read(channel, buffer, sizeof(buffer), 0)) &gt; 0) {\n if (fwrite(buffer, 1, rc, stdout) != (unsigned int) rc) {\n return -1;\n }\n}\n\nSee also\nssh_channel_request_shell()\n\n\n\n```rw7  hX   Apizarx7  h
X   77ry7  hX   CONTrz7  hX   INFORMr{7  h]r|7  X   examplesr}7  ah]r~7  X   ssh_channel_request_execr7  auKO}r7  (hX   29r7  h	X   how do I close a channelr7  hX
   Programmerr7  h
NhNhX   ELICIT-OFFER-OR-SUGGESTIONr7  h]r7  X   patternsr7  ah]r7  X   ssh_channelr7  auKP}r7  (hX   30r7  h	X'   Here is a function that might help:\n\nr7  hX   Apizar7  h
X   79r7  hX   POSr7  hX   SUGGESTr7  h]r7  X   patternsr7  ah]r7  (X   ssh_channelr7  X   ssh_channel_closer7  euKQ}r7  (hX   30r7  h	X;   ```\nint ssh_channel_close\t(\tssh_channel \tchannel\t)\n\nr7  hX   Apizar7  h
X   80r7  hX   CONTr7  hX   INFORMr7  h]r7  X   basicr7  ah]r7  X   ssh_channel_closer7  auKR}r7  (hX   30r7  h	X   Description\nClose a channel.\nThis sends an end of file and then closes the channel. You won't be able to recover any data the server was going to send or was in buffers.\n\nr7  hX   Apizar7  h
X   81r7  hX   CONTr7  hX   INFORMr7  h]r7  X
   functionalityr7  ah]r7  X   ssh_channel_closer7  auKS}r7  (hX   30r7  h	X.   Parameters\nchannel: The channel to close.\n\nr7  hX   Apizar7  h
X   82r7  hX   CONTr7  hX   INFORMr7  h]r7  X   basicr7  ah]r7  X   ssh_channel_closer7  auKT}r7  (hX   30r7  h	X?   Returns\nSSH_OK on success, SSH_ERROR if an error occurred.\n\nr7  hX   Apizar7  h
X   83r7  hX   CONTr7  hX   INFORMr7  h]r7  X
   functionalityr7  ah]r7  X   ssh_channel_closer7  auKU}r7  (hX   30r7  h	X;   See also\nssh_channel_free()\nssh_channel_is_eof()\n\n\n```r7  hX   Apizar7  h
X   84r7  hX   CONTr7  hX   INFORMr7  hNh]r7  X   ssh_channel_closer7  auKV}r7  (hX   31r7  h	XA   apiza can you show me ssh_channel_free() and ssh_channel_is_eof()r7  hX
   Programmerr7  h
X   85r7  hX   FOLr7  hX
   ELICIT-INFORMr7  h]r7  X   basicr7  ah]r7  (X   ssh_channel_freer7  X   ssh_channel_is_eofr7  euKW}r7  (hX   32r7  h	X2   Here is the documentation for those functions:\n\nr7  hX   Apizar7  h
X   86r7  hX   POSr7  hX   INFORMr7  hNh]r7  (X   ssh_channel_freer7  X   ssh_channel_is_eofr7  euKX}r7  (hX   32r7  h	X;   ```\nvoid ssh_channel_free\t(\tssh_channel \tchannel\t)\n\nr7  hX   Apizar7  h
X   87r7  hX   CONTr7  hX   INFORMr7  h]r7  X   basicr7  ah]r7  X   ssh_channel_freer7  auKY}r7  (hX   32r7  h	X*   Description\nClose and free a channel.\n\nr7  hX   Apizar7  h
X   88r7  hX   CONTr7  hX   INFORMr7  h]r7  (X
   functionalityr7  X   basicr7  eh]r7  X   ssh_channel_freer7  auKZ}r7  (hX   32r7  h	X/   Parameters\nchannel: The channel to free.\n\n\nr7  hX   Apizar7  h
X   89r7  hX   CONTr7  hX   INFORMr7  h]r7  X   basicr7  ah]r 8  X   ssh_channel_freer8  auK[}r8  (hX   32r8  h	XC   ```\n\n```\nint ssh_channel_is_eof\t(\tssh_channel \tchannel\t)\n\nr8  hX   Apizar8  h
X   90r8  hX   CONTr8  hX   INFORMr8  h]r	8  X   basicr
8  ah]r8  X   ssh_channel_is_eofr8  auK\}r
8  (hX   32r8  h	X1   Description\nCheck if remote has sent an EOF.\n\nr8  hX   Apizar8  h
X   91r8  hX   CONTr8  hX   INFORMr8  h]r8  X
   functionalityr8  ah]r8  X   ssh_channel_is_eofr8  auK]}r8  (hX   32r8  h	X.   Parameters\nchannel: The channel to check.\n\nr8  hX   Apizar8  h
X   92r8  hX   CONTr8  hX   INFORMr8  h]r8  X   basicr 8  ah]r!8  X   ssh_channel_is_eofr"8  auK^}r#8  (hX   32r$8  h	X8   Returns\n0 if there is no EOF, nonzero otherwise.\n\n```r%8  hX   Apizar&8  h
X   93r'8  hX   CONTr(8  hX   INFORMr)8  h]r*8  X
   functionalityr+8  ah]r,8  X   ssh_channel_is_eofr-8  auK_}r.8  (hX   33r/8  h	X   how can I send the eofr08  hX
   Programmerr18  h
NhNhX   ELICIT-OFFER-OR-SUGGESTIONr28  h]r38  X   patternsr48  ahNuK`}r58  (hX   34r68  h	X'   Here is a function that might help:\n\nr78  hX   Apizar88  h
X   95r98  hX   POSr:8  hX   SUGGESTr;8  h]r<8  X   patternsr=8  ah]r>8  X   ssh_channel_is_eofr?8  auKa}r@8  (hX   34rA8  h	X>   ```\nint ssh_channel_send_eof\t(\tssh_channel \tchannel\t)\n\nrB8  hX   ApizarC8  h
X   96rD8  hX   CONTrE8  hX   INFORMrF8  h]rG8  X   basicrH8  ah]rI8  X   ssh_channel_is_eofrJ8  auKb}rK8  (hX   34rL8  h	X   Description\nSend an end of file on the channel.\nThis doesn't close the channel. You may still read from it but not write.\n\nrM8  hX   ApizarN8  h
X   97rO8  hX   CONTrP8  hX   INFORMrQ8  h]rR8  X
   functionalityrS8  ah]rT8  X   ssh_channel_is_eofrU8  auKc}rV8  (hX   34rW8  h	X8   Parameters\nchannel: The channel to send the eof to.\n\nrX8  hX   ApizarY8  h
X   98rZ8  hX   CONTr[8  hX   INFORMr\8  h]r]8  X
   functionalityr^8  ah]r_8  X   ssh_channel_is_eofr`8  auKd}ra8  (hX   34rb8  h	X=   Returns\nSSH_OK on success, SSH_ERROR if an error occurred.\nrc8  hX   Apizard8  h
X   99re8  hX   CONTrf8  hX   INFORMrg8  h]rh8  X
   functionalityri8  ah]rj8  X   ssh_channel_is_eofrk8  auKe}rl8  (hX   34rm8  h	X  Example:\n\nrc = ssh_channel_send_eof(channel);\nif (rc == SSH_ERROR) {\n return -1;\n}\nwhile(!ssh_channel_is_eof(channel)) {\n rc = ssh_channel_read(channel, buf, sizeof(buf), 0);\n if (rc == SSH_ERROR) {\n return -1;\n }\n}\nssh_channel_close(channel);\n\nrn8  hX   Apizaro8  h
X   100rp8  hX   CONTrq8  hX   INFORMrr8  h]rs8  X   examplesrt8  ah]ru8  X   ssh_channel_is_eofrv8  auKf}rw8  (hX   34rx8  h	XP   See also\nssh_channel_close()\nssh_channel_free()\nssh_channel_is_eof()\n\n\n```ry8  hX   Apizarz8  h
X   101r{8  hX   CONTr|8  hX   INFORMr}8  hNh]r~8  X   ssh_channel_is_eofr8  auKg}r8  (hX   35r8  h	X2   how can I create and initialize a new sftp_sessionr8  hX
   Programmerr8  h
NhNhX   ELICIT-OFFER-OR-SUGGESTIONr8  h]r8  X   patternsr8  ah]r8  X   sftp_sessionr8  auKh}r8  (hX   36r8  h	X'   Here is a function that might help:\n\nr8  hX   Apizar8  h
X   103r8  hX   POSr8  hX   SUGGESTr8  h]r8  X   patternsr8  ah]r8  (X   sftp_sessionr8  X   sftp_newr8  euKi}r8  (hX   36r8  h	X;   ```\nsftp_session sftp_new\t(\tssh_session \tsession\t)\n\nr8  hX   Apizar8  h
X   104r8  hX   CONTr8  hX   INFORMr8  h]r8  X   basicr8  ah]r8  X   sftp_newr8  auKj}r8  (hX   36r8  h	X*   Description\nStart a new sftp session.\n\nr8  hX   Apizar8  h
X   105r8  hX   CONTr8  hX   INFORMr8  h]r8  X   basicr8  ah]r8  X   sftp_newr8  auKk}r8  (hX   36r8  h	X0   Parameters\nsession: The ssh session to use.\n\nr8  hX   Apizar8  h
X   106r8  hX   CONTr8  hX   INFORMr8  h]r8  X   basicr8  ah]r8  X   sftp_newr8  auKl}r8  (hX   36r8  h	X1   Returns\nA new sftp session or NULL on error.\n\nr8  hX   Apizar8  h
X   107r8  hX   CONTr8  hX   INFORMr8  h]r8  X
   functionalityr8  ah]r8  X   sftp_newr8  auKm}r8  (hX   36r8  h	X   See also\nsftp_free()\n\n\n```r8  hX   Apizar8  h
X   108r8  hX   CONTr8  hX   INFORMr8  hNh]r8  X   sftp_newr8  auKn}r8  (hX   37r8  h	XA   where is buffer defined for the ssh_channel_request_exec functionr8  hX
   Programmerr8  h
X   74r8  hX   FOLr8  hX
   ELICIT-INFORMr8  h]r8  X	   structurer8  ah]r8  X   ssh_channel_request_execr8  auKo}r8  (hX   38r8  h	X3   how can I create a new direction on the remote hostr8  hX
   Programmerr8  h
NhNhX   ELICIT-OFFER-OR-SUGGESTIONr8  h]r8  X   patternsr8  ahNuKp}r8  (hX   39r8  h	X'   can I see the ssh_channel_read functionr8  hX
   Programmerr8  h
X   101r8  hX   FOLr8  hX
   ELICIT-INFORMr8  h]r8  (X   basicr8  X	   structurer8  eh]r8  X   ssh_channel_readr8  auKq}r8  (hX   40r8  h	X0   Here is a struct definition that might help:\n\nr8  hX   Apizar8  h
X   110r8  hX   POSr8  hX   INFORMr8  h]r8  (X   basicr8  X	   structurer8  eh]r8  X
   ssh_bufferr8  auKr}r8  (hX   40r8  h	Xo   ```\nstruct ssh_buffer_struct {\n char *data;\n uint32_t used;\n uint32_t allocated;\n uint32_t pos;\n};\n\n```r8  hX   Apizar8  h
X   113r8  hX   CONTr8  hX   INFORMr8  h]r8  (X   basicr8  X	   structurer8  eh]r8  X
   ssh_bufferr8  auKs}r 9  (hX   41r9  h	X5   Here is the documentation for `ssh_channel_read`:\n\nr9  hX   Apizar9  h
X   114r9  hX   CONTr9  hX   INFORMr9  hNh]r9  X   ssh_channel_readr9  auKt}r	9  (hX   41r
9  h	Xp   ```\nint ssh_channel_read\t(\tssh_channel \tchannel,\nvoid * \tdest,\nuint32_t \tcount,\nint \tis_stderr \n)\n\nr9  hX   Apizar9  h
X   115r
9  hX   CONTr9  hX   INFORMr9  h]r9  X   basicr9  ah]r9  X   ssh_channel_readr9  auKu}r9  (hX   41r9  h	X+   Description\nReads data from a channel.\n\nr9  hX   Apizar9  h
X   116r9  hX   CONTr9  hX   INFORMr9  h]r9  X   basicr9  ah]r9  X   ssh_channel_readr9  auKv}r9  (hX   41r 9  h	X   Parameters\nchannel: The channel to read from.\ndest: The destination buffer which will get the data.\ncount: The count of bytes to be read.\nis_stderr: A boolean value to mark reading from the stderr flow.\n\nr!9  hX   Apizar"9  h
X   117r#9  hX   CONTr$9  hX   INFORMr%9  h]r&9  X
   functionalityr'9  ah]r(9  X   ssh_channel_readr)9  auKw}r*9  (hX   41r+9  h	X   Returns\nThe number of bytes read, 0 on end of file or SSH_ERROR on error. In nonblocking mode it Can return 0 if no data is available or SSH_AGAIN.\n\n\n```r,9  hX   Apizar-9  h
X   118r.9  hX   CONTr/9  hX   INFORMr09  h]r19  X
   functionalityr29  ah]r39  X   ssh_channel_readr49  auKx}r59  (hX   42r69  h	X<   how can I declare a destination buffer for the read functionr79  hX
   Programmerr89  h
X   116r99  hX   FOLr:9  hX   ELICIT-OFFER-OR-SUGGESTIONr;9  h]r<9  X   patternsr=9  ah]r>9  X   ssh_channel_readr?9  auKy}r@9  (hX   43rA9  h	X3   how can I create a new directory on the remote hostrB9  hX
   ProgrammerrC9  h
NhNhX   ELICIT-OFFER-OR-SUGGESTIONrD9  h]rE9  X   patternsrF9  ahNuKz}rG9  (hX   44rH9  h	X'   Here is a function that might help:\n\nrI9  hX   ApizarJ9  h
X   120rK9  hX   POSrL9  hX   SUGGESTrM9  h]rN9  X   patternsrO9  ah]rP9  X   ssh_buffer_newrQ9  auK{}rR9  (hX   44rS9  h	X@   ```\nstruct ssh_buffer_struct* ssh_buffer_new\t(\tvoid \t\t)\n\nrT9  hX   ApizarU9  h
X   122rV9  hX   CONTrW9  hX   INFORMrX9  h]rY9  X   basicrZ9  ah]r[9  X   ssh_buffer_newr\9  auK|}r]9  (hX   44r^9  h	X-   Description\nCreate a new SSH buffer.\n\n\n\nr_9  hX   Apizar`9  h
X   123ra9  hX   CONTrb9  hX   INFORMrc9  h]rd9  X   basicre9  ah]rf9  X   ssh_buffer_newrg9  auK}}rh9  (hX   44ri9  h	X@   Returns\nA newly initialized SSH buffer, NULL on error.\n\n\n```rj9  hX   Apizark9  h
X   124rl9  hX   CONTrm9  hX   INFORMrn9  h]ro9  X
   functionalityrp9  ah]rq9  X   ssh_buffer_newrr9  auK~}rs9  (hX   45rt9  h	X'   Here is a function that might help:\n\nru9  hX   Apizarv9  h
X   121rw9  hX   POSrx9  hX   SUGGESTry9  h]rz9  X   patternsr{9  ah]r|9  X
   sftp_mkdirr}9  auK}r~9  (hX   45r9  h	X^   ```\nint sftp_mkdir\t(\tsftp_session \tsftp,\nconst char * \tdirectory,\nmode_t \tmode \n)\n\nr9  hX   Apizar9  h
X   126r9  hX   CONTr9  hX   INFORMr9  h]r9  X   basicr9  ah]r9  X
   sftp_mkdirr9  auK}r9  (hX   45r9  h	X$   Description\nCreate a directory.\n\nr9  hX   Apizar9  h
X   127r9  hX   CONTr9  hX   INFORMr9  h]r9  X   basicr9  ah]r9  X
   sftp_mkdirr9  auK}r9  (hX   45r9  h	X   Parameters\nsftp: The sftp session handle.\ndirectory: The directory to create.\nmode: Specifies the permissions to use. It is modified by the process's umask in the usual way: The permissions of the created file are (mode &amp; ~umask)\n\nr9  hX   Apizar9  h
X   128r9  hX   CONTr9  hX   INFORMr9  h]r9  X
   functionalityr9  ah]r9  X
   sftp_mkdirr9  auK}r9  (hX   45r9  h	XG   Returns\n0 on success, &lt; 0 on error with ssh and sftp error set.\n\nr9  hX   Apizar9  h
X   129r9  hX   CONTr9  hX   INFORMr9  h]r9  X
   functionalityr9  ah]r9  X
   sftp_mkdirr9  auK}r9  (hX   45r9  h	X#   See also\nsftp_get_error()\n\n\n```r9  hX   Apizar9  h
X   130r9  hX   CONTr9  hX   INFORMr9  hNh]r9  X
   sftp_mkdirr9  auK}r9  (hX   46r9  h	X(   can you show me the definition of mode_tr9  hX
   Programmerr9  h
X   127r9  hX   FOLr9  hX
   ELICIT-INFORMr9  h]r9  X   basicr9  ahNuK}r9  (hX   47r9  h	X&   can you show me how to write to a filer9  hX
   Programmerr9  h
NhNhX   ELICIT-OFFER-OR-SUGGESTIONr9  h]r9  X   patternsr9  ahNuK}r9  (hX   48r9  h	X'   Here is the definition of `mode_t`:\n\nr9  hX   Apizar9  h
X   132r9  hX   POSr9  hX   INFORMr9  h]r9  X   basicr9  ahNuK}r9  (hX   48r9  h	X   ```\ntypedef int mode_t;\n```r9  hX   Apizar9  h
X   134r9  hX   CONTr9  hX   INFORMr9  h]r9  X   basicr9  ahNuK}r9  (hX   49r9  h	X'   Here is a function that might help:\n\nr9  hX   Apizar9  h
X   133r9  hX   POSr9  hX   SUGGESTr9  h]r9  X   patternsr9  ahNuK}r9  (hX   49r9  h	XZ   ```\nssize_t sftp_write\t(\tsftp_file \tfile,\nconst void * \tbuf,\nsize_t \tcount \n)\n\nr9  hX   Apizar9  h
X   136r9  hX   CONTr9  hX   INFORMr9  h]r9  X   basicr9  ah]r9  X
   sftp_writer9  auK}r9  (hX   49r9  h	XB   Description\nWrite to a file using an opened sftp file handle.\n\nr9  hX   Apizar9  h
X   137r9  hX   CONTr9  hX   INFORMr9  h]r9  X
   functionalityr9  ah]r9  X
   sftp_writer9  auK}r9  (hX   49r9  h	X   Parameters\nfile: Open sftp file handle to write to.\nbuf: Pointer to buffer to write data.\ncount: Size of buffer in bytes.\n\nr9  hX   Apizar9  h
X   138r9  hX   CONTr9  hX   INFORMr9  h]r9  X
   functionalityr9  ah]r9  X
   sftp_writer9  auK}r9  (hX   49r :  h	XR   Returns\nNumber of bytes written, &lt; 0 on error with ssh and sftp error set.\n\nr:  hX   Apizar:  h
X   139r:  hX   CONTr:  hX   INFORMr:  h]r:  X
   functionalityr:  ah]r:  X
   sftp_writer	:  auK}r
:  (hX   49r:  h	X9   See also\nsftp_open()\nsftp_read()\nsftp_close()\n\n\n```r:  hX   Apizar
:  h
X   140r:  hX   CONTr:  hX   INFORMr:  hNh]r:  X
   sftp_writer:  auK}r:  (hX   50r:  h	X   how do I create a filer:  hX
   Programmerr:  h
NhNhX   ELICIT-OFFER-OR-SUGGESTIONr:  h]r:  X   patternsr:  ahNuK}r:  (hX   51r:  h	X'   Here is a function that might help:\n\nr:  hX   Apizar:  h
X   142r:  hX   POSr:  hX   SUGGESTr :  h]r!:  X   patternsr":  ah]r#:  X	   sftp_openr$:  auK}r%:  (hX   51r&:  h	Xt   ```\nsftp_file sftp_open\t(\tsftp_session \tsession,\nconst char * \tfile,\nint \taccesstype,\nmode_t \tmode \n)\n\nr':  hX   Apizar(:  h
X   143r):  hX   CONTr*:  hX   INFORMr+:  h]r,:  X   basicr-:  ah]r.:  X	   sftp_openr/:  auK}r0:  (hX   51r1:  h	X+   Description\nOpen a file on the server.\n\nr2:  hX   Apizar3:  h
X   144r4:  hX   CONTr5:  hX   INFORMr6:  h]r7:  X   basicr8:  ah]r9:  X	   sftp_openr::  auK}r;:  (hX   51r<:  h	X  Parameters\nsession: The sftp session handle.\nfile: The file to be opened.\naccesstype: Is one of O_RDONLY, O_WRONLY or O_RDWR which request opening the file read-only,write-only or read/write. Acesss may also be bitwise-or'd with one or more of the following: O_CREAT - If the file does not exist it will be created. O_EXCL - When used with O_CREAT, if the file already exists it is an error and the open will fail. O_TRUNC - If the file already exists it will be truncated.\nmode: Mode specifies the permissions to use if a new file is created. It is modified by the process's umask in the usual way: The permissions of the created file are (mode &amp; ~umask)\n\nr=:  hX   Apizar>:  h
X   145r?:  hX   CONTr@:  hX   INFORMrA:  h]rB:  X
   functionalityrC:  ah]rD:  X	   sftp_openrE:  auK}rF:  (hX   51rG:  h	XK   Returns\nA sftp file handle, NULL on error with ssh and sftp error set.\n\nrH:  hX   ApizarI:  h
X   146rJ:  hX   CONTrK:  hX   INFORMrL:  h]rM:  X
   functionalityrN:  ah]rO:  X	   sftp_openrP:  auK}rQ:  (hX   51rR:  h	X%   See also\nsftp_get_error()\n\n\n\n```rS:  hX   ApizarT:  h
X   147rU:  hX   CONTrV:  hX   INFORMrW:  hNh]rX:  X	   sftp_openrY:  auuuK}rZ:  (hhh}r[:  (K }r\:  (hhh	X   help on ssh_sessionr]:  hX
   Programmerr^:  h
NhNhX   ELICIT-OFFER-OR-SUGGESTIONr_:  h]r`:  X   basicra:  ah]rb:  X   ssh_sessionrc:  auK}rd:  (hhh	X   man ssh_sessionre:  hX
   Programmerrf:  h
hhX   REPrg:  hX
   ELICIT-INFORMrh:  h]ri:  X   basicrj:  ah]rk:  X   ssh_sessionrl:  auK}rm:  (hh+h	X   helprn:  hX
   Programmerro:  h
NhNhX   ELICIT-OFFER-OR-SUGGESTIONrp:  hNhNuK}rq:  (hh5h	X   Hello! rr:  hX   Apizars:  h
NhNhX   BE-POSITIVErt:  hNhNuK}ru:  (hh5h	X2   I have several functions relating to ssh_session. rv:  hX   Apizarw:  h
hhX   NEGrx:  hX   INFORMry:  h]rz:  X	   structurer{:  ah]r|:  X   ssh_sessionr}:  auK}r~:  (hh5h	X   What can I help you with?r:  hX   Apizar:  h
h5hX   FOLr:  hX   ELICIT-OFFER-OR-SUGGESTIONr:  hNhNuK}r:  (hh<h	X   create a new ssh_sessionr:  hX
   Programmerr:  h
NhNhX   ELICIT-OFFER-OR-SUGGESTIONr:  h]r:  X   patternsr:  ah]r:  X   ssh_sessionr:  auK}r:  (hhFh	X   This function should work:\n\nr:  hX   Apizar:  h
hFhX   POSr:  hX   SUGGESTr:  h]r:  X   patternsr:  ah]r:  X   ssh_sessionr:  auK}r:  (hhFh	X&   ssh_session ssh_new\t(\tvoid \t\t)\n\nr:  hX   Apizar:  h
hQhX   CONTr:  hX   INFORMr:  h]r:  X   basicr:  ah]r:  X   ssh_newr:  auK	}r:  (hhFh	X*   Description\nCreate a new ssh session.\n\nr:  hX   Apizar:  h
hXhX   CONTr:  hX   INFORMr:  h]r:  X   basicr:  ah]r:  X   ssh_newr:  auK
}r:  (hhFh	X2   Returns\nA new ssh_session pointer, NULL on error.r:  hX   Apizar:  h
hchX   CONTr:  hX   INFORMr:  h]r:  X
   functionalityr:  ah]r:  X   ssh_newr:  auK}r:  (hhQh	X   manpage of ssh_newr:  hX
   Programmerr:  h
hhX   REPr:  hX
   ELICIT-INFORMr:  h]r:  X   basicr:  ah]r:  X   ssh_newr:  auK}r:  (hhXh	X   help on ssh_newr:  hX
   Programmerr:  h
X   11r:  hX   REPr:  hX   ELICIT-OFFER-OR-SUGGESTIONr:  h]r:  X   basicr:  ah]r:  X   ssh_newr:  auK
}r:  (hhch	X2   Unfortunately I can't provide you with a manpage, r:  hX   Apizar:  h
X   11r:  hX   NEGr:  hX   INFORMr:  hNhNuK}r:  (hhch	X1   but I can answer any specific questions you have!r:  hX   Apizar:  h
X   13r:  hX   FOLr:  hX   OFFERr:  hNhNuK}r:  (hX   10r:  h	X   How can I help with ssh_new?r:  hX   Apizar:  h
X   12r:  hX   FOLr:  hX   ELICIT-OFFER-OR-SUGGESTIONr:  h]r:  X   basicr:  ah]r:  X   ssh_newr:  auK}r:  (hX   11r:  h	X9   Typical usage of ssh_new() looks something like this:\n\nr:  hX   Apizar:  h
X   12r:  hX   POSr:  hX   INFORMr:  h]r:  X   examplesr:  ah]r:  X   ssh_newr:  auK}r:  (hX   11r:  h	X!   ssh_session *session = ssh_new();r:  hX   Apizar:  h
X   16r:  hX   CONTr:  hX   INFORMr:  h]r:  X   examplesr:  ah]r:  X   ssh_newr:  auK}r:  (hX   12r:  h	X   help on ssh_session connectionr:  hX
   Programmerr:  h
NhNhX   ELICIT-OFFER-OR-SUGGESTIONr:  h]r:  X   patternsr:  ah]r:  X   ssh_sessionr:  auK}r:  (hX   13r:  h	XF   I found two functions relating directly to ssh_session connection:\n\nr:  hX   Apizar:  h
X   18r:  hX   PARTr:  hX   INFORMr:  h]r:  X	   structurer ;  ah]r;  X   ssh_sessionr;  auK}r;  (hX   13r;  h	X`   int ssh_connect\t(\tssh_session \tsession\t)\n\nvoid ssh_disconnect\t(\tssh_session \tsession\t)r;  hX   Apizar;  h
X   19r;  hX   CONTr;  hX   INFORMr	;  h]r
;  X	   structurer;  ah]r;  (X   ssh_connectr
;  X   ssh_disconnectr;  euK}r;  (hX   14r;  h	X   help on ssh_connectr;  hX
   Programmerr;  h
X   20r;  hX   FOLr;  hX   ELICIT-OFFER-OR-SUGGESTIONr;  h]r;  X   basicr;  ah]r;  X   ssh_connectr;  auK}r;  (hX   15r;  h	X8   Here are the details about the function ssh_connect:\n\nr;  hX   Apizar;  h
X   21r;  hX   POSr;  hX   INFORMr ;  hNh]r!;  X   ssh_connectr";  auK}r#;  (hX   15r$;  h	X0   int ssh_connect\t(\tssh_session \tsession\t)\n\nr%;  hX   Apizar&;  h
X   22r';  hX   CONTr(;  hX   INFORMr);  h]r*;  X   basicr+;  ah]r,;  X   ssh_connectr-;  auK}r.;  (hX   15r/;  h	X+   Description\nConnect to the ssh server.\n\nr0;  hX   Apizar1;  h
X   23r2;  hX   CONTr3;  hX   INFORMr4;  h]r5;  X   basicr6;  ah]r7;  X   ssh_connectr8;  auK}r9;  (hX   15r:;  h	X   Parameters\nsession: The ssh session to connect.\n\nReturns\nSSH_OK on success, SSH_ERROR on error.\nSSH_AGAIN, if the session is in nonblocking mode, and call must be done again.\n\nr;;  hX   Apizar<;  h
X   24r=;  hX   CONTr>;  hX   INFORMr?;  h]r@;  X
   functionalityrA;  ah]rB;  X   ssh_connectrC;  auK}rD;  (hX   15rE;  h	X%   See also\nssh_new()\nssh_disconnect()rF;  hX   ApizarG;  h
X   25rH;  hX   CONTrI;  hX   INFORMrJ;  hNh]rK;  X   ssh_connectrL;  auK}rM;  (hX   16rN;  h	X   list all ssh functionsrO;  hX
   ProgrammerrP;  h
NhNhX
   ELICIT-INFORMrQ;  h]rR;  X	   structurerS;  ahNuK}rT;  (hX   17rU;  h	X/   There are many function in the libssh library! rV;  hX   ApizarW;  h
X   27rX;  hX   NEGrY;  hX   INFORMrZ;  h]r[;  X	   structurer\;  ahNuK}r];  (hX   17r^;  h	X+   Feel free to ask about a particular topic, r_;  hX   Apizar`;  h
X   28ra;  hX   FOLrb;  hX   SUGGESTrc;  hNhNuK}rd;  (hX   17re;  h	X&   and I will list all related functions.rf;  hX   Apizarg;  h
X   29rh;  hX   CONTri;  hX   OFFERrj;  hNhNuK}rk;  (hX   18rl;  h	X!   list all ssh connection functionsrm;  hX
   Programmerrn;  h
X   29ro;  hX   FOLrp;  hX
   ELICIT-INFORMrq;  h]rr;  (X	   structurers;  X   patternsrt;  ehNuK }ru;  (hX   19rv;  h	XH   These are all of the functions I could find related to "connection":\n\nrw;  hX   Apizarx;  h
X   31ry;  hX   POSrz;  hX   INFORMr{;  h]r|;  X	   structurer};  ahNuK!}r~;  (hX   19r;  h	Xe  ssh_channel ssh_channel_accept_forward\t(\tssh_session \tsession,\nint \ttimeout_ms,\nint * \tdestination_port\n)\n\nint ssh_channel_listen_forward\t(\tssh_session \tsession,\nconst char * \taddress,\nint \tport,\nint * \tbound_port\n)\n\nint ssh_connect\t(\tssh_session \tsession\t)\n\nvoid ssh_disconnect\t(\tssh_session \tsession\t)\n\nint ssh_event_add_connector\t(\tssh_event \tevent,\nssh_connector \tconnector\n)\n\nint ssh_event_remove_connector\t(\tssh_event \tevent,\nssh_connector \tconnector\n)\n\nconst char* ssh_get_disconnect_message\t(\tssh_session \tsession\t)\n\nsocket_t ssh_get_fd\t(\tssh_session \tsession\t)\n\nint ssh_is_connected\t(\tssh_session \tsession\t)\n\nint ssh_is_server_known\t(\tssh_session \tsession\t)\n\nint ssh_options_copy\t(\tssh_session \tsrc,\nssh_session * \tdest\n)\n\nvoid ssh_silent_disconnect\t(\tssh_session \tsession\t)r;  hX   Apizar;  h
X   32r;  hX   CONTr;  hX   INFORMr;  h]r;  X	   structurer;  ahNuK"}r;  (hX   20r;  h	XR   It looks like ssh_connect() is the function most directly related to "connection."r;  hX   Apizar;  h
X   33r;  hX   FOLr;  hX   INFORMr;  h]r;  X   patternsr;  ah]r;  X   ssh_connectr;  auK#}r;  (hX   21r;  h	X   help on ssh option functionsr;  hX
   Programmerr;  h
X   33r;  hX   FOLr;  hX   ELICIT-OFFER-OR-SUGGESTIONr;  h]r;  X   basicr;  ah]r;  X   ssh_options_copyr;  auK$}r;  (hX   22r;  h	X3   The function ssh_options_copy works as follows:\n\nr;  hX   Apizar;  h
X   35r;  hX   POSr;  hX   INFORMr;  hNh]r;  X   ssh_options_copyr;  auK%}r;  (hX   22r;  h	X   Description\nDuplicate the options of a session structure.\nIf you make several sessions with the same options this is useful. You cannot use twice the same option structure in ssh_session_connect.\n\nr;  hX   Apizar;  h
X   36r;  hX   CONTr;  hX   INFORMr;  h]r;  (X
   functionalityr;  X   purposer;  X
   directivesr;  eh]r;  X   ssh_options_copyr;  auK&}r;  (hX   22r;  h	X   Parameters\nsrc: The session to use to copy the options.\ndest: A pointer to store the allocated session with duplicated options. You have to free the memory.\n\nr;  hX   Apizar;  h
X   37r;  hX   CONTr;  hX   INFORMr;  h]r;  X
   functionalityr;  ah]r;  X   ssh_options_copyr;  auK'}r;  (hX   22r;  h	X1   Returns\n0 on sucess, -1 on error with errno set.r;  hX   Apizar;  h
X   38r;  hX   CONTr;  hX   INFORMr;  h]r;  X
   functionalityr;  ah]r;  X   ssh_options_copyr;  auK(}r;  (hX   23r;  h	X`   It appears to be related to the setter an getter functions ssh_options_set and ssh_options_get. r;  hX   Apizar;  h
X   35r;  hX   PARTr;  hX   INFORMr;  h]r;  X	   structurer;  ah]r;  X   ssh_options_copyr;  auK)}r;  (hX   23r;  h	X2   Would you like to know more about either of these?r;  hX   Apizar;  h
X   40r;  hX   FOLr;  hX
   ELICIT-INFORMr;  hNh]r;  (X   ssh_options_setr;  X   ssh_options_getr;  euK*}r;  (hX   24r;  h	X   function to set ssh hostr;  hX
   Programmerr;  h
NhNhX   ELICIT-OFFER-OR-SUGGESTIONr;  h]r;  X   patternsr;  ahNuK+}r;  (hX   25r;  h	X@   The function ssh_options_set allows you to set the ssh host.\n\nr;  hX   Apizar;  h
X   42r;  hX   POSr;  hX   SUGGESTr;  h]r;  X   patternsr;  ah]r;  X   ssh_options_setr;  auK,}r;  (hX   25r;  h	Xg   int ssh_options_set\t(\tssh_session \tsession,\nenum ssh_options_e \ttype,\nconst void * \tvalue\n)\n\nr;  hX   Apizar;  h
X   43r;  hX   CONTr;  hX   INFORMr;  h]r;  X   basicr;  ah]r;  X   ssh_options_setr;  auK-}r;  (hX   25r;  h	X   The type parameter can take the value SSH_OPTIONS_HOST, and value is then the hostname or ip address to connect to (const char *).r;  hX   Apizar;  h
X   44r;  hX   CONTr <  hX   INFORMr<  h]r<  X   patternsr<  ah]r<  X   ssh_options_setr<  auK.}r<  (hX   26r<  h	X]   Remember, I'm here to help ‚Äì I can provide examples, suggestions, or function details. r<  hX   Apizar	<  h
NhNhX   OFFERr
<  hNhNuK/}r<  (hX   26r<  h	X   Don't hesitate to ask!r
<  hX   Apizar<  h
NhNhX   SUGGESTr<  hNhNuK0}r<  (hX   27r<  h	X   ssh authenticate exampler<  hX
   Programmerr<  h
NhNhX
   ELICIT-INFORMr<  h]r<  X   examplesr<  ahNuK1}r<  (hX   28r<  h	X   Sure, r<  hX   Apizar<  h
X   48r<  hX   POSr<  hX   BE-POSITIVEr<  hNhNuK2}r<  (hX   28r<  h	X<   are you interested in authenticating the server or the user?r <  hX   Apizar!<  h
X   48r"<  hX   FOLr#<  hX
   ELICIT-INFORMr$<  h]r%<  X   patternsr&<  ahNuK3}r'<  (hX   29r(<  h	X   authenticate the userr)<  hX
   Programmerr*<  h
X   50r+<  hX   POSr,<  hX   INFORMr-<  h]r.<  X   patternsr/<  ahNuK4}r0<  (hX   30r1<  h	X   also authenticate the serverr2<  hX
   Programmerr3<  h
X   50r4<  hX   POSr5<  hX   INFORMr6<  h]r7<  X   patternsr8<  ahNuK5}r9<  (hX   31r:<  h	X'   I found the following code snippet:\n\nr;<  hX   Apizar<<  h
X   51r=<  hX   POSr><  hX   INFORMr?<  h]r@<  X   examplesrA<  ahNuK6}rB<  (hX   31rC<  h	XL  // Authenticate ourselves\n password = getpass("Password: ");\n rc = ssh_userauth_password(my_ssh_session, NULL, password);\n if (rc != SSH_AUTH_SUCCESS)\n {\n fprintf(stderr, "Error authenticating with password: %s\\n",\n ssh_get_error(my_ssh_session));\n ssh_disconnect(my_ssh_session);\n ssh_free(my_ssh_session);\n exit(-1);\n }rD<  hX   ApizarE<  h
X   53rF<  hX   CONTrG<  hX   INFORMrH<  h]rI<  X   examplesrJ<  ahNuK7}rK<  (hX   32rL<  h	X'   example code of authenticate the serverrM<  hX
   ProgrammerrN<  h
NhNhX
   ELICIT-INFORMrO<  h]rP<  X   examplesrQ<  ahNuK8}rR<  (hX   33rS<  h	X   Sure,rT<  hX   ApizarU<  h
X   55rV<  hX   POSrW<  hX   BE-POSITIVErX<  hNhNuK9}rY<  (hX   33rZ<  h	X4   here\'s an example of authenticating the server:\n\nr[<  hX   Apizar\<  h
X   55r]<  hX   POSr^<  hX   INFORMr_<  h]r`<  X   examplesra<  ahNuK:}rb<  (hX   33rc<  h	X  `enum ssh_known_hosts_e state;\n...\nstate = ssh_session_is_known_server(session);\n switch (state) {\n case SSH_KNOWN_HOSTS_OK:\n /* OK */\n break;\n case SSH_KNOWN_HOSTS_CHANGED:\n fprintf(stderr, "Host key for server changed: it is now:\\n");\n ssh_print_hexa("Public key hash", hash, hlen);\n fprintf(stderr, "For security reasons, connection will be stopped\\n");\n ssh_clean_pubkey_hash(&amp;hash);\n return -1;\n case SSH_KNOWN_HOSTS_OTHER:\n fprintf(stderr, "The host key for this server was not found but an other"\n "type of key exists.\\n");\n fprintf(stderr, "An attacker might change the default server key to"\n "confuse your client into thinking the key does not exist\\n");\n ssh_clean_pubkey_hash(&amp;hash);\n return -1;\n case SSH_KNOWN_HOSTS_NOT_FOUND:\n fprintf(stderr, "Could not find known host file.\\n");\n fprintf(stderr, "If you accept the host key here, the file will be"\n "automatically created.\\n");\n /* FALL THROUGH to SSH_SERVER_NOT_KNOWN behavior */\n case SSH_KNOWN_HOSTS_UNKNOWN:\n hexa = ssh_get_hexa(hash, hlen);\n fprintf(stderr,"The server is unknown. Do you trust the host key?\\n");\n fprintf(stderr, "Public key hash: %s\\n", hexa);\n ssh_string_free_char(hexa);\n ssh_clean_pubkey_hash(&amp;hash);\n p = fgets(buf, sizeof(buf), stdin);\n if (p == NULL) {\n return -1;\n }\n cmp = strncasecmp(buf, "yes", 3);\n if (cmp != 0) {\n return -1;\n }\n rc = ssh_session_update_known_hosts(session);\n if (rc &lt; 0) {\n fprintf(stderr, "Error %s\\n", strerror(errno));\n return -1;\n }\n break;\n case SSH_KNOWN_HOSTS_ERROR:\n fprintf(stderr, "Error %s", ssh_get_error(session));\n ssh_clean_pubkey_hash(&amp;hash);\n return -1;\n }`rd<  hX   Apizare<  h
X   57rf<  hX   CONTrg<  hX   INFORMrh<  h]ri<  X   examplesrj<  ahNuK;}rk<  (hX   34rl<  h	X   header file of SSH_OKrm<  hX
   Programmerrn<  h
NhNhX
   ELICIT-INFORMro<  h]rp<  (X	   structurerq<  X   basicrr<  ehNuK<}rs<  (hX   35rt<  h	X2   I found SSH_OK listed as an Error return code:\n\nru<  hX   Apizarv<  h
X   59rw<  hX   POSrx<  hX   INFORMry<  h]rz<  (X	   structurer{<  X   basicr|<  ehNuK=}r}<  (hX   35r~<  h	X   /* Error return codes */\n#define SSH_OK 0 /* No error */\n#define SSH_ERROR -1 /* Error of some kind */\n#define SSH_AGAIN -2 /* The nonblocking call must be repeated */\n#define SSH_EOF -127 /* We have already a eof */r<  hX   Apizar<  h
X   60r<  hX   CONTr<  hX   INFORMr<  h]r<  (X	   structurer<  X   basicr<  ehNuK>}r<  (hX   36r<  h	X&   SSH_OK is defined in which header filer<  hX
   Programmerr<  h
X   60r<  hX   REPr<  hX
   ELICIT-INFORMr<  h]r<  (X	   structurer<  X   basicr<  ehNuK?}r<  (hX   37r<  h	X   It is defined in libssh.hr<  hX   Apizar<  h
X   62r<  hX   POSr<  hX   INFORMr<  h]r<  (X	   structurer<  X   basicr<  ehNuK@}r<  (hX   38r<  h	X2   SSH_KNOWN_HOSTS_OK is defined in which header filer<  hX
   Programmerr<  h
NhNhX
   ELICIT-INFORMr<  h]r<  (X	   structurer<  X   basicr<  ehNuKA}r<  (hX   39r<  h	X   This may take a second, r<  hX   Apizar<  h
X   64r<  hX   PARTr<  hX   OTHERr<  hNhNuKB}r<  (hX   39r<  h	X0   I can't find SSH_KNOWN_HOSTS_OK in the headers. r<  hX   Apizar<  h
X   64r<  hX   UNCr<  hX   INFORMr<  h]r<  (X	   structurer<  X   basicr<  ehNuKC}r<  (hX   39r<  h	X@   I am searching for similar strings that serve a similar purpose.r<  hX   Apizar<  h
X   66r<  hX   FOLr<  hX   OFFERr<  hNhNuKD}r<  (hX   40r<  h	X1   It appears SSH_KNOWN_HOSTS_OK may be deprecated. r<  hX   Apizar<  h
X   66r<  hX   FOLr<  hX   INFORMr<  h]r<  X   environmentr<  ahNuKE}r<  (hX   40r<  h	X2   In libssh.h, I was able to find the following:\n\nr<  hX   Apizar<  h
X   66r<  hX   FOLr<  hX   INFORMr<  h]r<  X	   structurer<  ahNuKF}r<  (hX   40r<  h	X   enum ssh_server_known_e {\n\tSSH_SERVER_ERROR=-1,\n\tSSH_SERVER_NOT_KNOWN=0,\n\tSSH_SERVER_KNOWN_OK,\n\tSSH_SERVER_KNOWN_CHANGED,\n\tSSH_SERVER_FOUND_OTHER,\n\tSSH_SERVER_FILE_NOT_FOUND\n};\n\nr<  hX   Apizar<  h
X   69r<  hX   CONTr<  hX   INFORMr<  h]r<  (X	   structurer<  X   basicr<  ehNuKG}r<  (hX   40r<  h	XS   This enum may serve the same purpose in the most up-to-date version of the library.r<  hX   Apizar<  h
X   70r<  hX   CONTr<  hX   INFORMr<  h]r<  (X	   structurer<  X   environmentr<  ehNuKH}r<  (hX   41r<  h	X*   header file of ssh_session_is_known_serverr<  hX
   Programmerr<  h
NhNhX
   ELICIT-INFORMr<  h]r<  (X	   structurer<  X   basicr<  ehNuKI}r<  (hX   42r<  h	X9   I found ssh_session_is_known_server in several examples, r<  hX   Apizar<  h
X   72r<  hX   PARTr<  hX   INFORMr<  h]r<  X	   structurer<  ahNuKJ}r<  (hX   42r<  h	X8   but it appears to be deprecated in the current library. r<  hX   Apizar<  h
X   73r<  hX   CONTr<  hX   INFORMr<  h]r<  X   environmentr<  ahNuKK}r<  (hX   42r<  h	Xm   The function int ssh_is_server_known\t(ssh_session \tsession) is the up-to-date version of that function.\n\nr<  hX   Apizar<  h
X   73r<  hX   FOLr =  hX   INFORMr=  h]r=  X   environmentr=  ah]r=  X   ssh_is_server_knownr=  auKL}r=  (hX   42r=  h	X   Description\nCheck if the server is known.\nChecks the user's known host file for a previous connection to the current server.\n\nr=  hX   Apizar	=  h
X   75r
=  hX   CONTr=  hX   INFORMr=  h]r
=  X
   functionalityr=  ah]r=  X   ssh_is_server_knownr=  auKM}r=  (hX   42r=  h	X0   Parameters\nsession: The SSH session to use.\n\nr=  hX   Apizar=  h
X   76r=  hX   CONTr=  hX   INFORMr=  h]r=  X   basicr=  ah]r=  X   ssh_is_server_knownr=  auKN}r=  (hX   42r=  h	Xs  Returns\nSSH_SERVER_KNOWN_OK: The server is known and has not changed.\nSSH_SERVER_KNOWN_CHANGED: The server key has changed. Either you are under attack or the administrator changed the key. You HAVE to warn the user about a possible attack.\nSSH_SERVER_FOUND_OTHER: The server gave use a key of a type while we had an other type recorded. It is a possible attack.\nSSH_SERVER_NOT_KNOWN: The server is unknown. User should confirm the MD5 is correct.\nSSH_SERVER_FILE_NOT_FOUND: The known host file does not exist. The host is thus unknown. File will be created if host key is accepted.\nSSH_SERVER_ERROR: Some error happened.r=  hX   Apizar=  h
X   77r =  hX   CONTr!=  hX   INFORMr"=  h]r#=  X
   functionalityr$=  ah]r%=  X   ssh_is_server_knownr&=  auKO}r'=  (hX   43r(=  h	X    ssh_is_server_known example coder)=  hX
   Programmerr*=  h
X   75r+=  hX   FOLr,=  hX
   ELICIT-INFORMr-=  h]r.=  X   examplesr/=  ah]r0=  X   ssh_is_server_knownr1=  auKP}r2=  (hX   44r3=  h	XE   The function ssh_is_server_known should work something like this:\n\nr4=  hX   Apizar5=  h
X   79r6=  hX   POSr7=  hX   INFORMr8=  h]r9=  X   examplesr:=  ah]r;=  X   ssh_is_server_knownr<=  auKQ}r==  (hX   44r>=  h	XT   int rc = ssh_is_server_known(session);\nif(rc!=SSH_SERVER_KNOWN_OK){\n return -1;\n}r?=  hX   Apizar@=  h
X   80rA=  hX   CONTrB=  hX   INFORMrC=  h]rD=  X   examplesrE=  ah]rF=  X   ssh_is_server_knownrG=  auKR}rH=  (hX   45rI=  h	X   verify ssh server example coderJ=  hX
   ProgrammerrK=  h
NhNhX
   ELICIT-INFORMrL=  h]rM=  X   examplesrN=  ahNuKS}rO=  (hX   46rP=  h	Xi   The code snippet above should "check that the server you just connected to is known and safe to use."\n\nrQ=  hX   ApizarR=  h
X   82rS=  hX   PARTrT=  hX   INFORMrU=  h]rV=  X   patternsrW=  ah]rX=  X   ssh_is_server_knownrY=  auKT}rZ=  (hX   46r[=  h	XK   The session variable must first be initialized and connected to the server.r\=  hX   Apizar]=  h
X   83r^=  hX   CONTr_=  hX   SUGGESTr`=  h]ra=  X
   directivesrb=  ah]rc=  X   ssh_is_server_knownrd=  auKU}re=  (hX   47rf=  h	X   get ssh public key functionsrg=  hX
   Programmerrh=  h
NhNhX
   ELICIT-INFORMri=  h]rj=  X	   structurerk=  ahNuKV}rl=  (hX   48rm=  h	X&   There are 21 public key functions:\n\nrn=  hX   Apizaro=  h
X   85rp=  hX   POSrq=  hX   INFORMrr=  h]rs=  X	   structurert=  ahNuKW}ru=  (hX   48rv=  h	X  ssh_key_clean\nssh_key_cmp\nssh_key_free\nssh_key_is_private\nssh_key_is_public\nssh_key_new\nssh_key_type\nssh_key_type_from_name\nssh_key_type_to_char\nssh_pki_copy_cert_to_privkey\nssh_pki_export_privkey_file\nssh_pki_export_privkey_to_pubkey\nssh_pki_export_pubkey_base64\nssh_pki_generate\nssh_pki_import_cert_base64\nssh_pki_import_cert_file\nssh_pki_import_privkey_base64\nssh_pki_import_privkey_file\nssh_pki_import_pubkey_base64\nssh_pki_import_pubkey_file\nssh_pki_key_ecdsa_namerw=  hX   Apizarx=  h
X   86ry=  hX   CONTrz=  hX   INFORMr{=  h]r|=  X	   structurer}=  ahNuKX}r~=  (hX   49r=  h	X#   how to get ssh public key from hostr=  hX
   Programmerr=  h
NhNhX   ELICIT-OFFER-OR-SUGGESTIONr=  h]r=  X   patternsr=  ahNuKY}r=  (hX   50r=  h	XS   There are also the functions related to "public key" in the ssh_session module:\n\nr=  hX   Apizar=  h
X   88r=  hX   PARTr=  hX   INFORMr=  h]r=  X	   structurer=  ahNuKZ}r=  (hX   50r=  h	XC   ssh_get_publickey\nssh_get_publickey_hash\nssh_get_server_publickeyr=  hX   Apizar=  h
X   89r=  hX   CONTr=  hX   INFORMr=  h]r=  X	   structurer=  ahNuK[}r=  (hX   51r=  h	X   ssh_get_publickey example coder=  hX
   Programmerr=  h
X   90r=  hX   FOLr=  hX
   ELICIT-INFORMr=  h]r=  X   examplesr=  ah]r=  X   ssh_get_publickeyr=  auK\}r=  (hX   52r=  h	X   I couldn't find any examples for\n\nint ssh_get_publickey\t(\tssh_session \tsession,\nssh_key * \tkey\n)\n\nand the documentation is limited.r=  hX   Apizar=  h
X   91r=  hX   UNCr=  hX   INFORMr=  h]r=  X   basicr=  ah]r=  X   ssh_get_publickeyr=  auK]}r=  (hX   52r=  h	X4   There is documentation for the related function:\n\nr=  hX   Apizar=  h
X   92r=  hX   FOLr=  hX   INFORMr=  hNh]r=  X   ssh_get_publickey_hashr=  auK^}r=  (hX   52r=  h	X   int ssh_get_publickey_hash\t(\tconst ssh_key \tkey,\nenum ssh_publickey_hash_type \ttype,\nunsigned char ** \thash,\nsize_t * \thlen\n)\n\nr=  hX   Apizar=  h
X   93r=  hX   CONTr=  hX   INFORMr=  h]r=  X   basicr=  ah]r=  X   ssh_get_publickey_hashr=  auK_}r=  (hX   52r=  h	X  Description\nAllocates a buffer with the hash of the public key.\nThis function allows you to get a hash of the public key. You can then print this hash in a human-readable form to the user so that he is able to verify it. Use ssh_get_hexa() or ssh_print_hexa() to display it.\n\nr=  hX   Apizar=  h
X   94r=  hX   CONTr=  hX   INFORMr=  h]r=  (X
   functionalityr=  X   purposer=  X   patternsr=  eh]r=  X   ssh_get_publickey_hashr=  auK`}r=  (hX   52r=  h	X   Parameters\nkey: The public key to create the hash for.\ntype: The type of the hash you want.\nhash: A pointer to store the allocated buffer. It can be freed using ssh_clean_pubkey_hash().\nhlen: The length of the hash.\n\nr=  hX   Apizar=  h
X   95r=  hX   CONTr=  hX   INFORMr=  h]r=  X
   functionalityr=  ah]r=  X   ssh_get_publickey_hashr=  auKa}r=  (hX   52r=  h	X2   Returns\n0 on success, -1 if an error occured.\n\nr=  hX   Apizar=  h
X   96r=  hX   CONTr=  hX   INFORMr=  h]r=  X
   functionalityr=  ah]r=  X   ssh_get_publickey_hashr=  auKb}r=  (hX   52r=  h	XZ   See also\nssh_is_server_known()\nssh_get_hexa()\nssh_print_hexa()\nssh_clean_pubkey_hash()r=  hX   Apizar=  h
X   97r=  hX   CONTr=  hX   INFORMr=  hNh]r=  X   ssh_get_publickey_hashr=  auKc}r=  (hX   53r=  h	X   As well as\nr=  hX   Apizar=  h
X   98r=  hX   CONTr=  hX   INFORMr=  hNh]r=  X   ssh_get_server_publickeyr=  auKd}r=  (hX   53r=  h	XO   int ssh_get_server_publickey\t(\tssh_session \tsession,\nssh_key * \tkey\n)\n\nr=  hX   Apizar=  h
X   99r=  hX   CONTr=  hX   INFORMr=  h]r=  X   basicr=  ah]r=  X   ssh_get_server_publickeyr >  auKe}r>  (hX   53r>  h	X:   Description\nGet the server public key from a session.\n\nr>  hX   Apizar>  h
X   100r>  hX   CONTr>  hX   INFORMr>  h]r>  X   basicr	>  ah]r
>  X   ssh_get_server_publickeyr>  auKf}r>  (hX   53r
>  h	X   Parameters\nsession: The session to get the key from.\n[out]: key: A pointer to store the allocated key. You need to free the key.\n\nr>  hX   Apizar>  h
X   101r>  hX   CONTr>  hX   INFORMr>  h]r>  (X
   functionalityr>  X
   directivesr>  eh]r>  X   ssh_get_server_publickeyr>  auKg}r>  (hX   53r>  h	X4   Returns\nSSH_OK on success, SSH_ERROR on errror.\n\nr>  hX   Apizar>  h
X   102r>  hX   CONTr>  hX   INFORMr>  h]r>  X
   functionalityr >  ah]r!>  X   ssh_get_server_publickeyr">  auKh}r#>  (hX   53r$>  h	X   See also\nssh_key_free()r%>  hX   Apizar&>  h
X   103r'>  hX   CONTr(>  hX   INFORMr)>  h]r*>  (X
   functionalityr+>  X
   directivesr,>  X   basicr->  eh]r.>  X   ssh_get_server_publickeyr/>  auKi}r0>  (hX   54r1>  h	X-   example code of ssh connection authenticationr2>  hX
   Programmerr3>  h
NhNhX
   ELICIT-INFORMr4>  h]r5>  X   examplesr6>  ahNuKj}r7>  (hX   55r8>  h	X   ssh authentication exampler9>  hX
   Programmerr:>  h
NhNhX
   ELICIT-INFORMr;>  h]r<>  X   examplesr=>  ahNuuuK}r>>  (hX   allegror?>  h}r@>  (K }rA>  (hhh	X   Hi ApizarB>  hX
   ProgrammerrC>  h
NhNhX   BE-POSITIVErD>  hNhNuK}rE>  (hhh	X   Hello! rF>  hX   ApizarG>  h
hhX   POSrH>  hX   BE-POSITIVErI>  hNhNuK}rJ>  (hhh	XL   I am Apiza, a virtual assistant designed to help you navigate and use APIs. rK>  hX   ApizarL>  h
NhNhX   INFORMrM>  hNhNuK}rN>  (hhh	X   How can I help?rO>  hX   ApizarP>  h
NhNhX   ELICIT-OFFER-OR-SUGGESTIONrQ>  hNhNuK}rR>  (hh+h	X4   What is the definition of structure of ALLERGO_EVENTrS>  hX
   ProgrammerrT>  h
NhNhX
   ELICIT-INFORMrU>  h]rV>  (X	   structurerW>  X   basicrX>  eh]rY>  X
   ALLEGRO_EVENTrZ>  auK}r[>  (hh5h	jW	  hX
   Programmerr\>  h
h5hX   CONTr]>  hX   OTHERr^>  hNhNuK}r_>  (hh<h	X8   I found the following description for ALLEGRO_EVENT:\n\nr`>  hX   Apizara>  h
h5hX   POSrb>  hX   INFORMrc>  hNh]rd>  X
   ALLEGRO_EVENTre>  auK}rf>  (hh<h	X   An ALLEGRO_EVENT is a union of all builtin event structures, i.e. it is an object large enough to hold the data of any event type. rg>  hX   Apizarh>  h
hFhX   CONTri>  hX   INFORMrj>  h]rk>  (X   basicrl>  X   qualityrm>  eh]rn>  X
   ALLEGRO_EVENTro>  auK}rp>  (hh<h	X   All events have the following fields in common:\n\ntype (ALLEGRO_EVENT_TYPE)\n\tIndicates the type of event.\nany.source (ALLEGRO_EVENT_SOURCE *)\n\tThe event source which generated the event.\nany.timestamp (double)\n\tWhen the event was generated.rq>  hX   Apizarr>  h
hQhX   CONTrs>  hX   INFORMrt>  h]ru>  X	   structurerv>  ah]rw>  X
   ALLEGRO_EVENTrx>  auK	}ry>  (hhFh	X3   What are the possible values for ALLERGO_EVENT_TYPErz>  hX
   Programmerr{>  h
hXhX   FOLr|>  hX
   ELICIT-INFORMr}>  h]r~>  X	   structurer>  ah]r>  (X
   ALLEGRO_EVENTr>  X   ALLEGRO_EVENT_TYPEr>  euK
}r>  (hhQh	X   And ALLERGO_EVENT_SOURCEr>  hX
   Programmerr>  h
hchX   FOLr>  hX
   ELICIT-INFORMr>  h]r>  X	   structurer>  ah]r>  (X
   ALLEGRO_EVENTr>  X   ALLEGRO_EVENT_SOURCEr>  euK}r>  (hhXh	X   ALLERGO_EVENT_TYPE is an enum with several values, including ALLEGRO_EVENT_JOYSTICK_AXIS , ALLEGRO_EVENT_KEY_DOWN , and ALLEGRO_EVENT_MOUSE_AXES. There are 30 different values in total. r>  hX   Apizar>  h
X   10r>  hX   POSr>  hX   INFORMr>  h]r>  (X	   structurer>  X   basicr>  eh]r>  X   ALLEGRO_EVENT_TYPEr>  auK}r>  (hhXh	X+   Are you looking for one type in particular?r>  hX   Apizar>  h
X   11r>  hX   FOLr>  hX
   ELICIT-INFORMr>  h]r>  X	   structurer>  ah]r>  X   ALLEGRO_EVENT_TYPEr>  auK
}r>  (hhch	X>   I found the following description of ALLEGRO_EVENT_SOURCE:\n\nr>  hX   Apizar>  h
X   10r>  hX   POSr>  hX   INFORMr>  hNh]r>  X   ALLEGRO_EVENT_SOURCEr>  auK}r>  (hhch	X!  An event source is any object which can generate events. For example, an ALLEGRO_DISPLAY can generate events, and you can get the ALLEGRO_EVENT_SOURCE pointer from an ALLEGRO_DISPLAY with al_get_display_event_source.\n\nYou may create your own "user" event sources that emit custom events.r>  hX   Apizar>  h
X   13r>  hX   CONTr>  hX   INFORMr>  h]r>  (X   conceptsr>  X   patternsr>  eh]r>  X   ALLEGRO_EVENT_SOURCEr>  auK}r>  (hX   10r>  h	X2   Please tell me more about ALlERGO_EVENT_KEY eventsr>  hX
   Programmerr>  h
X   11r>  hX   FOLr>  hX
   ELICIT-INFORMr>  h]r>  X   basicr>  ahNuK}r>  (hX   11r>  h	X}   There are three different types of EVENT_KEY events: ALLEGRO_EVENT_KEY_DOWN, ALLEGRO_EVENT_KEY_UP, and ALLEGRO_EVENT_KEY_CHARr>  hX   Apizar>  h
X   15r>  hX   POSr>  hX   INFORMr>  h]r>  X	   structurer>  ahNuK}r>  (hX   12r>  h	X-   Is there allergo_event key left and key rightr>  hX
   Programmerr>  h
NhNhX
   ELICIT-INFORMr>  h]r>  X	   structurer>  ahNuK}r>  (hX   13r>  h	X?   I found two Key codes: ALLEGRO_KEY_LEFT and ALLEGRO_KEY_RIGHT. r>  hX   Apizar>  h
X   17r>  hX   POSr>  hX   INFORMr>  h]r>  X	   structurer>  ahNuK}r>  (hX   13r>  h	X<   These can be used with keyboard routines such as al_key_downr>  hX   Apizar>  h
X   18r>  hX   FOLr>  hX   INFORMr>  h]r>  X   patternsr>  ah]r>  X   al_key_downr>  auK}r>  (hX   14r>  h	X"   Tell me more about al_key routinesr>  hX
   Programmerr>  h
X   19r>  hX   FOLr>  hX
   ELICIT-INFORMr>  h]r>  X   basicr>  ahNuK}r>  (hX   15r>  h	X  There are 9 functions directly relating to the keyboard:\n\nal_install_keyboard\nal_is_keyboard_installed\nal_uninstall_keyboard\nal_get_keyboard_state\nal_clear_keyboard_state\nal_key_down\nal_keycode_to_name\nal_set_keyboard_leds\nal_get_keyboard_event_sourcer>  hX   Apizar>  h
X   20r>  hX   POSr>  hX   INFORMr>  h]r>  X	   structurer>  ahNuK}r>  (hX   16r>  h	X"   What function plays an audio file?r>  hX
   Programmerr>  h
NhNhX
   ELICIT-INFORMr>  h]r>  X   patternsr>  ahNuK}r>  (hX   17r>  h	X3   There are many function related to Audio playback. r>  hX   Apizar>  h
X   22r>  hX   PARTr ?  hX   INFORMr?  h]r?  X	   structurer?  ahNuK}r?  (hX   17r?  h	X/   al_play_sample plays a given ALLEGRO_SAMPLE.\n r?  hX   Apizar?  h
X   22r?  hX   POSr	?  hX   INFORMr
?  h]r?  X   patternsr?  ah]r
?  (X   al_play_sampler?  X   ALLEGRO_SAMPLEr?  euK}r?  (hX   17r?  h	X   bool al_play_sample(ALLEGRO_SAMPLE *spl, float gain, float pan, float speed,\n ALLEGRO_PLAYMODE loop, ALLEGRO_SAMPLE_ID *ret_id)r?  hX   Apizar?  h
X   24r?  hX   CONTr?  hX   INFORMr?  h]r?  X   basicr?  ah]r?  (X   al_play_sampler?  X   ALLEGRO_SAMPLEr?  euK}r?  (hX   18r?  h	X:   Would you like help loading and playing an ALLEGRO_SAMPLE?r?  hX   Apizar?  h
X   22r ?  hX   FOLr!?  hX   OFFERr"?  h]r#?  X   patternsr$?  ah]r%?  X   ALLEGRO_SAMPLEr&?  auK}r'?  (hX   19r(?  h	X   Yesr)?  hX
   Programmerr*?  h
X   26r+?  hX   POSr,?  hX   INFORMr-?  h]r.?  X   patternsr/?  ahNuK}r0?  (hX   20r1?  h	X   Sure thing! r2?  hX   Apizar3?  h
X   27r4?  hX   POSr5?  hX   BE-POSITIVEr6?  hNhNuK}r7?  (hX   20r8?  h	XG   It looks like this is how you could load and play an audio file:\n\n\n r9?  hX   Apizar:?  h
X   27r;?  hX   POSr<?  hX   SUGGESTr=?  h]r>?  X   examplesr??  ahNuK}r@?  (hX   20rA?  h	X  ALLEGRO_SAMPLE *sample=NULL;\n\t\n if(!al_install_audio()){\n fprintf(stderr, "failed to initialize audio!\\n");\n return -1;\n }\n\t\n if (!al_reserve_samples(1)){\n fprintf(stderr, "failed to reserve samples!\\n");\n return -1;\n }\n\t\n sample = al_load_sample( "footstep.wav" );\n\n if (!sample){\n printf( "Audio clip sample not loaded!\\n" );\n return -1;\n }\n\n al_play_sample(sample, 1.0, 0.0,1.0,ALLEGRO_PLAYMODE_LOOP,NULL);\n\t\n al_destroy_sample(sample);rB?  hX   ApizarC?  h
X   29rD?  hX   CONTrE?  hX   INFORMrF?  h]rG?  X   examplesrH?  ahNuK}rI?  (hX   21rJ?  h	X'   Why is allergo sample* mistaken as int*rK?  hX
   ProgrammerrL?  h
X   25rM?  hX   FOLrN?  hX
   ELICIT-INFORMrO?  h]rP?  X
   functionalityrQ?  ah]rR?  X   ALLEGRO_SAMPLErS?  auK }rT?  (hX   22rU?  h	X,   What does the function al_load_sample returnrV?  hX
   ProgrammerrW?  h
X   30rX?  hX   FOLrY?  hX
   ELICIT-INFORMrZ?  h]r[?  X
   functionalityr\?  ah]r]?  X   al_load_sampler^?  auK!}r_?  (hX   23r`?  h	X-   The al_load_sample function looks like this: ra?  hX   Apizarb?  h
X   32rc?  hX   POSrd?  hX   INFORMre?  hNh]rf?  X   al_load_samplerg?  auK"}rh?  (hX   23ri?  h	X8   ALLEGRO_SAMPLE *al_load_sample(const char *filename)\n\nrj?  hX   Apizark?  h
X   33rl?  hX   CONTrm?  hX   INFORMrn?  h]ro?  X   basicrp?  ah]rq?  X   al_load_samplerr?  auK#}rs?  (hX   23rt?  h	X/   Returns the sample on success, NULL on failure.ru?  hX   Apizarv?  h
X   34rw?  hX   CONTrx?  hX   INFORMry?  h]rz?  X
   functionalityr{?  ah]r|?  X   al_load_sampler}?  auK$}r~?  (hX   24r?  h	X   For sample-loading errors, it look like you may need to initialize the "audio codec add-on". Use `al_init_acodec_addon()` to initialize the audio codec.r?  hX   Apizar?  h
X   31r?  hX   POSr?  hX   SUGGESTr?  h]r?  X   patternsr?  ah]r?  X   al_init_acodec_addonr?  auK%}r?  (hX   25r?  h	X.   Can you help me with fuctions that draw bitmapr?  hX
   Programmerr?  h
NhNhX   ELICIT-OFFER-OR-SUGGESTIONr?  h]r?  X   patternsr?  ahNuK&}r?  (hX   26r?  h	X   I'm happy to help! r?  hX   Apizar?  h
X   37r?  hX   POSr?  hX   BE-POSITIVEr?  hNhNuK'}r?  (hX   26r?  h	X2   Where would you like to start with bitmap drawing?r?  hX   Apizar?  h
X   37r?  hX   FOLr?  hX
   ELICIT-INFORMr?  h]r?  X   patternsr?  ahNuK(}r?  (hX   27r?  h	X   I want to draw a pngr?  hX
   Programmerr?  h
X   39r?  hX   POSr?  hX   INFORMr?  h]r?  X   patternsr?  ahNuK)}r?  (hX   28r?  h	X   Alright, the variable that you will need to initialize is an ALLEGRO_BITMAP. You can do so with the function al_create_bitmap: r?  hX   Apizar?  h
X   40r?  hX   POSr?  hX   SUGGESTr?  h]r?  X   patternsr?  ah]r?  (X   ALLEGRO_BITMAPr?  X   al_create_bitmapr?  euK*}r?  (hX   28r?  h	X.   ALLEGRO_BITMAP *al_create_bitmap(int w, int h)r?  hX   Apizar?  h
X   41r?  hX   CONTr?  hX   INFORMr?  h]r?  X   basicr?  ah]r?  (X   ALLEGRO_BITMAPr?  X   al_create_bitmapr?  euK+}r?  (hX   29r?  h	X;   What function takes a png file as input and draws a bitmap?r?  hX
   Programmerr?  h
NhNhX
   ELICIT-INFORMr?  h]r?  X   patternsr?  ahNuK,}r?  (hX   30r?  h	X8   ALLEGRO_BITMAP *al_load_bitmap(const char *filename)\n\nr?  hX   Apizar?  h
X   43r?  hX   POSr?  hX   INFORMr?  h]r?  (X   basicr?  X   patternsr?  eh]r?  X   al_load_bitmapr?  auK-}r?  (hX   30r?  h	X/   Loads an image file into a new ALLEGRO_BITMAP. r?  hX   Apizar?  h
X   44r?  hX   CONTr?  hX   INFORMr?  h]r?  X
   functionalityr?  ah]r?  X   al_load_bitmapr?  auK.}r?  (hX   30r?  h	X   The file type is determined by the extension, except if the file has no extension in which case al_identify_bitmap is used instead.\n\nReturns NULL on error.r?  hX   Apizar?  h
X   45r?  hX   CONTr?  hX   INFORMr?  h]r?  (X
   functionalityr?  X   controlr?  eh]r?  X   al_load_bitmapr?  auK/}r?  (hX   31r?  h	X   Load bitmap returns nullr?  hX
   Programmerr?  h
X   46r?  hX   FOLr?  hX   INFORMr?  h]r?  X
   functionalityr?  ah]r?  X   al_load_bitmapr?  auK0}r?  (hX   32r?  h	XZ   If you\'re getting errors loading an image, you may need to initialize the "image addon." r?  hX   Apizar?  h
X   47r?  hX   POSr?  hX   SUGGESTr?  h]r?  X   patternsr?  ahNuK1}r?  (hX   32r @  h	X+   You can do this using al_init_image_addon()r@  hX   Apizar@  h
X   48r@  hX   CONTr@  hX   SUGGESTr@  h]r@  X   patternsr@  ah]r@  X   al_init_image_addonr	@  auK2}r
@  (hX   33r@  h	X:   Image not displayed event after loading the png in bitmap?r@  hX
   Programmerr
@  h
X   46r@  hX   FOLr@  hX   ELICIT-OFFER-OR-SUGGESTIONr@  h]r@  X
   functionalityr@  ah]r@  X   al_load_bitmapr@  auK3}r@  (hX   34r@  h	X   Sorry, r@  hX   Apizar@  h
X   50r@  hX   UNCr@  hX   BE-POSITIVEr@  hNhNuK4}r@  (hX   34r@  h	X!   could you rephrase your question?r@  hX   Apizar@  h
X   51r @  hX   CONTr!@  hX   COMMENT-ABOUT-UNDERSTANDINGr"@  hNhNuuuK}r#@  (hj?>  h}r$@  (K }r%@  (hhh	X   Hello Apizar&@  hX
   Programmerr'@  h
NhNhX   BE-POSITIVEr(@  hNhNuK}r)@  (hhh	X   Hi!r*@  hX   Apizar+@  h
hhX   POSr,@  hX   BE-POSITIVEr-@  hNhNuK}r.@  (hhh	XD    I'm Apiza, a virtual assistant designed to help you use a new API. r/@  hX   Apizar0@  h
NhNhX   INFORMr1@  hNhNuK}r2@  (hhh	X   How can I help you?r3@  hX   Apizar4@  h
NhNhX   ELICIT-OFFER-OR-SUGGESTIONr5@  hNhNuK}r6@  (hh+h	X   How do I get keyboard eventsr7@  hX
   Programmerr8@  h
NhNhX   ELICIT-OFFER-OR-SUGGESTIONr9@  h]r:@  X   patternsr;@  ahNuK}r<@  (hh5h	X"   How do I register keyboard events?r=@  hX
   Programmerr>@  h
NhNhX   ELICIT-OFFER-OR-SUGGESTIONr?@  h]r@@  X   patternsrA@  ahNuK}rB@  (hh<h	X   Apiza are you thererC@  hX
   ProgrammerrD@  h
NhNhX"   ELICIT-COMMENT-ABOUT-UNDERSTANDINGrE@  hNhNuK}rF@  (hhFh	X   <@UB659D0FM> do you hear merG@  hX
   ProgrammerrH@  h
NhNhX"   ELICIT-COMMENT-ABOUT-UNDERSTANDINGrI@  hNhNuK}rJ@  (hhQh	X/   How do I register keyboard events with allegro?rK@  hX
   ProgrammerrL@  h
h<hX   REPrM@  hX   ELICIT-OFFER-OR-SUGGESTIONrN@  h]rO@  X   patternsrP@  ahNuK	}rQ@  (hhXh	X'   Something like ALLEGRO_EVENT_KEY_DOWN? rR@  hX   ApizarS@  h
hXhX   POSrT@  hX   SUGGESTrU@  h]rV@  X   basicrW@  ah]rX@  X   ALLEGRO_EVENT_KEY_DOWNrY@  auK
}rZ@  (hhXh	XT   If you have an event ```ev```, you can check the value of ```ev.keyboard.keycode```.r[@  hX   Apizar\@  h
hchX   CONTr]@  hX   INFORMr^@  h]r_@  (X	   structurer`@  X   patternsra@  eh]rb@  X   ALLEGRO_EVENT_KEY_DOWNrc@  auK}rd@  (hhch	X   You do not need to specifically register the keyboard, though it should be installed with\n```bool al_install_keyboard(void)```re@  hX   Apizarf@  h
X   10rg@  hX   CONTrh@  hX   SUGGESTri@  h]rj@  (X
   directivesrk@  X   patternsrl@  eh]rm@  X   al_install_keyboardrn@  auK}ro@  (hX   10rp@  h	X;   What header do i need to include for the allegro key eventsrq@  hX
   Programmerrr@  h
NhNhX
   ELICIT-INFORMrs@  h]rt@  X	   structureru@  ahNuK
}rv@  (hX   11rw@  h	jW	  hX
   Programmerrx@  h
X   12ry@  hX   CONTrz@  hX   OTHERr{@  hNhNuK}r|@  (hX   12r}@  h	X?   Events and keyboard input are included in the allegro.h header.r~@  hX   Apizar@  h
X   13r@  hX   POSr@  hX   INFORMr@  h]r@  X	   structurer@  ahNuK}r@  (hX   13r@  h	XP   What are the allegro event key right and allegro event key left variables calledr@  hX
   Programmerr@  h
NhNhX
   ELICIT-INFORMr@  h]r@  X   basicr@  ahNuK}r@  (hX   14r@  h	X   ALLEGRO_KEY_LEFT and ALLEGRO_KEY_RIGHT are key codes, which are returned in the event.keyboard.keycode field of the ALLEGRO_KEY_DOWN and ALLEGRO_KEY_UP events.r@  hX   Apizar@  h
X   15r@  hX   POSr@  hX   INFORMr@  h]r@  (X	   structurer@  X   patternsr@  X   basicr@  ehNuK}r@  (hX   15r@  h	X/   how to pop elements off the allegro event queuer@  hX
   Programmerr@  h
NhNhX   ELICIT-OFFER-OR-SUGGESTIONr@  h]r@  X   patternsr@  ah]r@  X   ALLEGRO_EVENT_QUEUEr@  auK}r@  (hX   16r@  h	Xh   The function\n\n```void al_wait_for_event(ALLEGRO_EVENT_QUEUE *queue, ALLEGRO_EVENT *ret_event)\t```\n\nr@  hX   Apizar@  h
X   17r@  hX   POSr@  hX   INFORMr@  h]r@  X   basicr@  ah]r@  (X   ALLEGRO_EVENT_QUEUEr@  X   al_wait_for_eventr@  euK}r@  (hX   16r@  h	X   Description: Wait until the event queue specified is non-empty. If ret_event is not NULL, the first event in the queue will be copied into ret_event and removed from the queue. If ret_event is NULL the first event is left at the head of the queue.r@  hX   Apizar@  h
X   18r@  hX   CONTr@  hX   INFORMr@  h]r@  X
   functionalityr@  ah]r@  X   al_wait_for_eventr@  auK}r@  (hX   17r@  h	X(   Is there a timeout to wait for an event?r@  hX
   Programmerr@  h
NhNhX
   ELICIT-INFORMr@  h]r@  X
   functionalityr@  ah]r@  X
   ALLEGRO_EVENTr@  auK}r@  (hX   18r@  h	X-   Do either of these functions look useful?\n\nr@  hX   Apizar@  h
X   20r@  hX   PARTr@  hX   SUGGESTr@  hNh]r@  (X   al_wait_for_eventr@  X   al_wait_for_event_untilr@  euK}r@  (hX   18r@  h	X   ```bool al_wait_for_event_timed(ALLEGRO_EVENT_QUEUE *queue,\n ALLEGRO_EVENT *ret_event, float secs)```\n\n```bool al_wait_for_event_until(ALLEGRO_EVENT_QUEUE *queue,\n ALLEGRO_EVENT *ret_event, ALLEGRO_TIMEOUT *timeout)```r@  hX   Apizar@  h
X   21r@  hX   CONTr@  hX   INFORMr@  h]r@  X   basicr@  ah]r@  (X   al_wait_for_eventr@  X   al_wait_for_event_untilr@  euK}r@  (hX   19r@  h	X   What is ALLEGRO_TIMEOUTr@  hX
   Programmerr@  h
X   22r@  hX   FOLr@  hX
   ELICIT-INFORMr@  h]r@  X   basicr@  ah]r@  (X   al_wait_for_event_untilr@  X   ALLEGRO_TIMEOUTr@  euK}r@  (hX   20r@  h	XL   ALLEGRO_TIMEOUT\n\n```typedef struct ALLEGRO_TIMEOUT ALLEGRO_TIMEOUT;```\n\nr@  hX   Apizar@  h
X   23r@  hX   POSr@  hX   INFORMr@  h]r@  X   basicr@  ah]r@  X   ALLEGRO_TIMEOUTr@  auK}r@  (hX   20r@  h	X~   Represent a timeout value. The size of the structure is known so it can be statically allocated. The contents are private.\n\nr@  hX   Apizar@  h
X   24r@  hX   CONTr@  hX   INFORMr@  h]r@  (X   qualityr@  X	   structurer@  X   basicr@  eh]r@  X   ALLEGRO_TIMEOUTr@  auK}r@  (hX   20r@  h	XX   Initialized with\n\n```void al_init_timeout(ALLEGRO_TIMEOUT *timeout, double seconds)```r@  hX   Apizar@  h
X   25r@  hX   CONTr@  hX   INFORMr A  h]rA  (X   patternsrA  X   basicrA  eh]rA  (X   ALLEGRO_TIMEOUTrA  X   al_init_timeoutrA  euK}rA  (hX   21rA  h	X;   what is the function signature of al_get_timer_event_sourcer	A  hX
   Programmerr
A  h
NhNhX
   ELICIT-INFORMrA  h]rA  X   basicr
A  ah]rA  X   al_get_timer_event_sourcerA  auK}rA  (hX   22rA  h	XJ   ```void al_set_timer_speed(ALLEGRO_TIMER *timer, double new_speed_secs)```rA  hX   ApizarA  h
X   27rA  hX   POSrA  hX   INFORMrA  h]rA  X   basicrA  ah]rA  X   al_set_timer_speedrA  auK}rA  (hX   23rA  h	X
   Correction:\nrA  hX   ApizarA  h
X   28rA  hX   REPr A  hX   OTHERr!A  hNhNuK}r"A  (hX   23r#A  h	XK   ```ALLEGRO_EVENT_SOURCE *al_get_timer_event_source(ALLEGRO_TIMER *timer)```r$A  hX   Apizar%A  h
X   29r&A  hX   CONTr'A  hX   INFORMr(A  h]r)A  X   basicr*A  ah]r+A  X   al_get_timer_event_sourcer,A  auK}r-A  (hX   24r.A  h	X=   please provide more information about al_wait_for_event_timedr/A  hX
   Programmerr0A  h
X   22r1A  hX   FOLr2A  hX
   ELICIT-INFORMr3A  h]r4A  X   basicr5A  ah]r6A  X   al_wait_for_event_timedr7A  auK }r8A  (hX   25r9A  h	X   al_wait_for_event_timed:\n\nr:A  hX   Apizar;A  h
X   31r<A  hX   POSr=A  hX   INFORMr>A  hNh]r?A  X   al_wait_for_event_timedr@A  auK!}rAA  (hX   25rBA  h	X   Wait until the event queue specified is non-empty. If ret_event is not NULL, the first event in the queue will be copied into ret_event and removed from the queue. If ret_event is NULL the first event is left at the head of the queue.\n\nrCA  hX   ApizarDA  h
X   32rEA  hX   CONTrFA  hX   INFORMrGA  h]rHA  X
   functionalityrIA  ah]rJA  X   al_wait_for_event_timedrKA  auK"}rLA  (hX   25rMA  h	X   secs determines approximately how many seconds to wait. If the call times out, false is returned. Otherwise, if an event ocurred, true is returned.\n\nFor compatibility with all platforms, secs must be 2,147,483.647 seconds or less.rNA  hX   ApizarOA  h
X   33rPA  hX   CONTrQA  hX   INFORMrRA  h]rSA  (X
   functionalityrTA  X
   directivesrUA  X   environmentrVA  eh]rWA  X   al_wait_for_event_timedrXA  auK#}rYA  (hX   26rZA  h	X.   what are all the possible allegro event types?r[A  hX
   Programmerr\A  h
NhNhX
   ELICIT-INFORMr]A  h]r^A  X	   structurer_A  ahNuK$}r`A  (hX   27raA  h	X/   What are the allegro keyboard input event typesrbA  hX
   ProgrammerrcA  h
NhNhX
   ELICIT-INFORMrdA  h]reA  X	   structurerfA  ahNuK%}rgA  (hX   28rhA  h	X[   There are about 27 event types, related to KEY, MOUSE, JOYSTICK, TIME, DISPLAY, and TOUCH. riA  hX   ApizarjA  h
X   35rkA  hX   POSrlA  hX   INFORMrmA  h]rnA  X	   structureroA  ahNuK&}rpA  (hX   28rqA  h	XZ   The event types related to Key Events are ALLEGRO_EVENT_KEY_DOWN and ALLEGRO_EVENT_KEY_UP.rrA  hX   ApizarsA  h
X   36rtA  hX   POSruA  hX   INFORMrvA  h]rwA  X	   structurerxA  ah]ryA  (X   ALLEGRO_EVENT_KEY_DOWNrzA  X   ALLEGRO_EVENT_KEY_UPr{A  euK'}r|A  (hX   29r}A  h	XZ   The event types related to Key Events are ALLEGRO_EVENT_KEY_DOWN and ALLEGRO_EVENT_KEY_UP.r~A  hX   ApizarA  h
X   38rA  hX   REPrA  hX   OTHERrA  h]rA  X	   structurerA  ah]rA  (X   ALLEGRO_EVENT_KEY_DOWNrA  X   ALLEGRO_EVENT_KEY_UPrA  euK(}rA  (hX   30rA  h	X!   how to play a sound with allegro'rA  hX
   ProgrammerrA  h
NhNhX   ELICIT-OFFER-OR-SUGGESTIONrA  h]rA  X   patternsrA  ahNuK)}rA  (hX   31rA  h	X!   How to play a sound with Allegro?rA  hX
   ProgrammerrA  h
X   40rA  hX   REPrA  hX   OTHERrA  h]rA  X   patternsrA  ahNuK*}rA  (hX   32rA  h	X)   The simplest method is al_play_sample\n\nrA  hX   ApizarA  h
X   41rA  hX   POSrA  hX   SUGGESTrA  h]rA  X   patternsrA  ah]rA  X   al_play_samplerA  auK+}rA  (hX   32rA  h	X   ```bool al_play_sample(ALLEGRO_SAMPLE *spl, float gain, float pan, float speed,\n ALLEGRO_PLAYMODE loop, ALLEGRO_SAMPLE_ID *ret_id)```\n\nrA  hX   ApizarA  h
X   42rA  hX   CONTrA  hX   INFORMrA  h]rA  X   basicrA  ah]rA  X   al_play_samplerA  auK,}rA  (hX   32rA  h	XM   Plays a sample on one of the sample instances created by al_reserve_samples. rA  hX   ApizarA  h
X   43rA  hX   CONTrA  hX   INFORMrA  h]rA  (X
   functionalityrA  X   patternsrA  eh]rA  X   al_play_samplerA  auK-}rA  (hX   32rA  h	X+   Returns true on success, false on failure. rA  hX   ApizarA  h
X   44rA  hX   CONTrA  hX   INFORMrA  h]rA  X
   functionalityrA  ah]rA  X   al_play_samplerA  auK.}rA  (hX   32rA  h	XO   Playback may fail because all the reserved sample instances are currently used.rA  hX   ApizarA  h
X   45rA  hX   CONTrA  hX   INFORMrA  h]rA  X
   functionalityrA  ah]rA  X   al_play_samplerA  auK/}rA  (hX   33rA  h	X   What is ALLEGRO_PLAYMODErA  hX
   ProgrammerrA  h
X   43rA  hX   FOLrA  hX
   ELICIT-INFORMrA  h]rA  X   basicrA  ah]rA  (X   al_play_samplerA  X   ALLEGRO_PLAYMODErA  euK0}rA  (hX   34rA  h	X   What is ALLEGRO_SAMPLE_IDrA  hX
   ProgrammerrA  h
X   43rA  hX   FOLrA  hX
   ELICIT-INFORMrA  h]rA  X   basicrA  ah]rA  (X   al_play_samplerA  X   ALLEGRO_SAMPLE_IDrA  euK1}rA  (hX   35rA  h	X   That refers to an enum. rA  hX   ApizarA  h
X   47rA  hX   POSrA  hX   INFORMrA  h]rA  X   basicrA  ah]rA  (X   al_play_samplerA  X   ALLEGRO_PLAYMODErA  euK2}rA  (hX   35rA  h	XS   Options are ALLEGRO_PLAYMODE_ONCE, ALLEGRO_PLAYMODE_LOOP, or ALLEGRO_PLAYMODE_BIDIRrA  hX   ApizarA  h
X   49rA  hX   CONTrA  hX   INFORMrA  h]rA  X	   structurerA  ah]rA  X   ALLEGRO_PLAYMODErA  auK3}rA  (hX   36r B  h	X   Regarding ALLEGRO_SAMPLE_ID variable ret_id - if non-NULL the variable which this points to will be assigned an id representing the sample being played. rB  hX   ApizarB  h
X   48rB  hX   POSrB  hX   INFORMrB  h]rB  (X
   functionalityrB  X   patternsrB  eh]r	B  (X   al_play_sampler
B  X   ALLEGRO_SAMPLE_IDrB  euK4}rB  (hX   36r
B  h	X}   If al_play_sample returns false, then the contents of ret_id are invalid and must not be used as argument to other functions.rB  hX   ApizarB  h
X   51rB  hX   CONTrB  hX   INFORMrB  h]rB  (X
   functionalityrB  X
   directivesrB  eh]rB  X   al_play_samplerB  auK5}rB  (hX   37rB  h	X0   I was able to find an example function call:\n\nrB  hX   ApizarB  h
X   46rB  hX   FOLrB  hX   INFORMrB  h]rB  X   examplesr B  ah]r!B  X   al_play_sampler"B  auK6}r#B  (hX   37r$B  h	XF   ```al_play_sample(sample, 1.0, 0.0,1.0,ALLEGRO_PLAYMODE_LOOP,NULL);```r%B  hX   Apizar&B  h
X   53r'B  hX   CONTr(B  hX   INFORMr)B  h]r*B  X   examplesr+B  ah]r,B  X   al_play_sampler-B  auK7}r.B  (hX   38r/B  h	X   What is an ALLEGRO_SAMPLEr0B  hX
   Programmerr1B  h
X   43r2B  hX   FOLr3B  hX
   ELICIT-INFORMr4B  h]r5B  X   basicr6B  ah]r7B  (X   al_play_sampler8B  X   ALLEGRO_SAMPLEr9B  euK8}r:B  (hX   39r;B  h	X,  An ALLEGRO_SAMPLE object stores the data necessary for playing pre-defined digital audio. It holds a user-specified PCM data buffer and information about its format (data length, depth, frequency, channel configuration). You can have the same ALLEGRO_SAMPLE playing multiple times simultaneously.\n\nr<B  hX   Apizar=B  h
X   55r>B  hX   POSr?B  hX   INFORMr@B  h]rAB  (X
   functionalityrBB  X   purposerCB  X   patternsrDB  eh]rEB  X   ALLEGRO_SAMPLErFB  auK9}rGB  (hX   39rHB  h	XC   Samples are often initialized with the function al_load_sample:\n\nrIB  hX   ApizarJB  h
X   56rKB  hX   CONTrLB  hX   INFORMrMB  h]rNB  X   patternsrOB  ah]rPB  (X   ALLEGRO_SAMPLErQB  X   al_load_samplerRB  euK:}rSB  (hX   39rTB  h	X:   ```ALLEGRO_SAMPLE *al_load_sample(const char *filename)```rUB  hX   ApizarVB  h
X   57rWB  hX   CONTrXB  hX   INFORMrYB  h]rZB  X   basicr[B  ah]r\B  X   al_load_sampler]B  auK;}r^B  (hX   40r_B  h	X   how to free pointers allegror`B  hX
   ProgrammerraB  h
NhNhX   ELICIT-OFFER-OR-SUGGESTIONrbB  h]rcB  X   patternsrdB  ahNuK<}reB  (hX   41rfB  h	X   how to free ALLEGRO_SAMPLErgB  hX
   ProgrammerrhB  h
NhNhX   ELICIT-OFFER-OR-SUGGESTIONriB  h]rjB  X   patternsrkB  ah]rlB  X   ALLEGRO_SAMPLErmB  auK=}rnB  (hX   42roB  h	X/   The function al_destroy_sample should work:\n\nrpB  hX   ApizarqB  h
X   60rrB  hX   POSrsB  hX   SUGGESTrtB  h]ruB  X   patternsrvB  ah]rwB  (X   al_destroy_samplerxB  X   ALLEGRO_SAMPLEryB  euK>}rzB  (hX   42r{B  h	X1   ```void al_destroy_sample(ALLEGRO_SAMPLE *spl)```r|B  hX   Apizar}B  h
X   21r~B  hX   CONTrB  hX   INFORMrB  h]rB  X   basicrB  ah]rB  X   al_destroy_samplerB  auK?}rB  (hX   43rB  h	X    al_load_sample is returning NULLrB  hX
   ProgrammerrB  h
X   58rB  hX   FOLrB  hX   INFORMrB  h]rB  X
   functionalityrB  ah]rB  X   al_load_samplerB  auK@}rB  (hX   44rB  h	X;   It looks like al_load_sample only returns NULL on failure. rB  hX   ApizarB  h
X   63rB  hX   PARTrB  hX   INFORMrB  h]rB  X
   functionalityrB  ah]rB  X   al_load_samplerB  auKA}rB  (hX   44rB  h	X-   Could I see how you are calling the function?rB  hX   ApizarB  h
X   63rB  hX   FOLrB  hX
   ELICIT-INFORMrB  h]rB  X   examplesrB  ah]rB  X   al_load_samplerB  auKB}rB  (hX   45rB  h	X*   spl = al_load_sample( AUDIO_SAMPLE_PATH );rB  hX
   ProgrammerrB  h
X   65rB  hX   POSrB  hX   INFORMrB  h]rB  X   examplesrB  ah]rB  X   al_load_samplerB  auKC}rB  (hX   46rB  h	XG   If AUDIO_SAMPLE_PATH is a valid path, this call should return a sample.rB  hX   ApizarB  h
X   66rB  hX   PARTrB  hX   INFORMrB  h]rB  (X
   functionalityrB  X   patternsrB  eh]rB  X   al_load_samplerB  auKD}rB  (hX   47rB  h	X>   There a couple of other reasons this function might not work. rB  hX   ApizarB  h
X   67rB  hX   CONTrB  hX   INFORMrB  hNh]rB  X   al_load_samplerB  auKE}rB  (hX   47rB  h	X>   Have you called al_install_audio() and al_init_acodec_addon()?rB  hX   ApizarB  h
X   66rB  hX   FOLrB  hX
   ELICIT-INFORMrB  h]rB  X   patternsrB  ah]rB  (X   al_load_samplerB  X   al_install_audiorB  X   al_init_acodec_addonrB  euKF}rB  (hX   48rB  h	X)   finction signature for al_install_audio()rB  hX
   ProgrammerrB  h
X   69rB  hX   FOLrB  hX
   ELICIT-INFORMrB  h]rB  X   basicrB  ah]rB  X   al_install_audiorB  auKG}rB  (hX   49rB  h	X-   function signature for al_init_acodec_addon()rB  hX
   ProgrammerrB  h
X   69rB  hX   FOLrB  hX
   ELICIT-INFORMrB  h]rB  X   basicrB  ah]rB  X   al_init_acodec_addonrB  auKH}rB  (hX   50rB  h	X!   ```bool al_install_audio(void)```rB  hX   ApizarB  h
X   70rB  hX   POSrB  hX   INFORMrB  h]rB  X   basicrB  ahNuKI}rB  (hX   51rB  h	X%   ```bool al_init_acodec_addon(void)```rB  hX   ApizarB  h
X   71rB  hX   POSrB  hX   INFORMrB  h]rB  X   basicrB  ahNuKJ}rB  (hX   52rB  h	X   If it helps,rB  hX   ApizarB  h
X   41rB  hX   POSr C  hX   BE-POSITIVErC  hNhNuKK}rC  (hX   52rC  h	XP    I was able to extract the following example that should Play an audio file.\n\nrC  hX   ApizarC  h
X   74rC  hX   CONTrC  hX   INFORMrC  h]r	C  X   patternsr
C  ahNuKL}rC  (hX   52rC  h	X  ```ALLEGRO_SAMPLE *sample=NULL;\n\n...\n\nif(!al_install_audio()){\n fprintf(stderr, "failed to initialize audio!\\n");\n return -1;\n}\n\nif(!al_init_acodec_addon()){\n fprintf(stderr, "failed to initialize audio codecs!\\n");\n return -1;\n}\n\t\nif (!al_reserve_samples(1)){\n fprintf(stderr, "failed to reserve samples!\\n");\n return -1;\n}\n\n...\n\t\nsample = al_load_sample( "footstep.wav" );\n\n...\n\nal_play_sample(sample, 1.0, 0.0,1.0,ALLEGRO_PLAYMODE_LOOP,NULL);```r
C  hX   ApizarC  h
X   75rC  hX   CONTrC  hX   INFORMrC  h]rC  X   examplesrC  ahNuKM}rC  (hX   53rC  h	X    how to display text with allegrorC  hX
   ProgrammerrC  h
NhNhX   ELICIT-OFFER-OR-SUGGESTIONrC  h]rC  X   patternsrC  ahNuKN}rC  (hX   54rC  h	X-   There are several functions to display text, rC  hX   ApizarC  h
X   77rC  hX   PARTr C  hX   INFORMr!C  h]r"C  X   patternsr#C  ahNuKO}r$C  (hX   54r%C  h	X    the simplest is al_draw_text\n\nr&C  hX   Apizar'C  h
X   77r(C  hX   POSr)C  hX   SUGGESTr*C  h]r+C  X   patternsr,C  ah]r-C  X   al_draw_textr.C  auKP}r/C  (hX   54r0C  h	X~   ```void al_draw_text(const ALLEGRO_FONT *font,\n ALLEGRO_COLOR color, float x, float y, int flags,\n char const *text) ```\n\nr1C  hX   Apizar2C  h
X   80r3C  hX   CONTr4C  hX   INFORMr5C  h]r6C  X   basicr7C  ah]r8C  X   al_draw_textr9C  auKQ}r:C  (hX   54r;C  h	Xl   Writes the NUL-terminated string text onto the target bitmap at position x, y, using the specified font.\n\nr<C  hX   Apizar=C  h
X   81r>C  hX   CONTr?C  hX   INFORMr@C  h]rAC  X
   functionalityrBC  ah]rCC  X   al_draw_textrDC  auKR}rEC  (hX   54rFC  h	X  The flags parameter can be 0 or one of the following flags:\n\nALLEGRO_ALIGN_LEFT - Draw the text left-aligned (same as 0).\nALLEGRO_ALIGN_CENTRE - Draw the text centered around the given position.\nALLEGRO_ALIGN_RIGHT - Draw the text right-aligned to the given position.\nIt can also be combined with this flag:\n\nALLEGRO_ALIGN_INTEGER - Always draw text aligned to an integer pixel position. This was formerly the default behaviour. rGC  hX   ApizarHC  h
X   82rIC  hX   CONTrJC  hX   INFORMrKC  h]rLC  (X
   directivesrMC  X   patternsrNC  eh]rOC  X   al_draw_textrPC  auKS}rQC  (hX   54rRC  h	X   Since: 5.0.8, 5.1.4\nThis function does not support newline characters (\\n), but you can use al_draw_multiline_text for multi line text output.rSC  hX   ApizarTC  h
X   83rUC  hX   CONTrVC  hX   INFORMrWC  h]rXC  (X   environmentrYC  X
   directivesrZC  X   patternsr[C  eh]r\C  X   al_draw_textr]C  auKT}r^C  (hX   55r_C  h	X   load ALLEGRO_FONTr`C  hX
   ProgrammerraC  h
X   80rbC  hX   FOLrcC  hX   ELICIT-OFFER-OR-SUGGESTIONrdC  h]reC  X   patternsrfC  ah]rgC  X   ALLEGRO_FONTrhC  auKU}riC  (hX   56rjC  h	X   load ALLEGRO_COLORrkC  hX
   ProgrammerrlC  h
X   80rmC  hX   FOLrnC  hX   ELICIT-OFFER-OR-SUGGESTIONroC  h]rpC  X   patternsrqC  ah]rrC  X
   ALLEGRO_COLORrsC  auKV}rtC  (hX   57ruC  h	X   This function should work:\n\nrvC  hX   ApizarwC  h
X   84rxC  hX   POSryC  hX   SUGGESTrzC  h]r{C  X   patternsr|C  ah]r}C  (X   ALLEGRO_FONTr~C  X   al_load_fontrC  euKW}rC  (hX   57rC  h	XK   ```ALLEGRO_FONT *al_load_font(char const *filename, int size, int flags)```rC  hX   ApizarC  h
X   86rC  hX   CONTrC  hX   INFORMrC  h]rC  X   basicrC  ah]rC  X   al_load_fontrC  auKX}rC  (hX   58rC  h	X3   I could not find a function to load ALLEGRO_COLOR, rC  hX   ApizarC  h
X   85rC  hX   NEGrC  hX   INFORMrC  h]rC  X
   functionalityrC  ah]rC  X
   ALLEGRO_COLORrC  auKY}rC  (hX   58rC  h	XY   but there are several functions that take primitive parameters and return ALLEGRO_COLOR, rC  hX   ApizarC  h
X   86rC  hX   FOLrC  hX   INFORMrC  h]rC  X   patternsrC  ah]rC  X
   ALLEGRO_COLORrC  auKZ}rC  (hX   58rC  h	XP   such as\n\n```ALLEGRO_COLOR al_color_cmyk(float c, float m, float y, float k)```rC  hX   ApizarC  h
X   89rC  hX   CONTrC  hX   INFORMrC  h]rC  X   basicrC  ah]rC  (X
   ALLEGRO_COLORrC  X
   al_color_cmykrC  euK[}rC  (hX   59rC  h	X   al_load_font flagsrC  hX
   ProgrammerrC  h
X   87rC  hX   FOLrC  hX
   ELICIT-INFORMrC  h]rC  X   basicrC  ah]rC  X   al_load_fontrC  auK\}rC  (hX   60rC  h	X$   more information about al_load_font rC  hX
   ProgrammerrC  h
X   87rC  hX   FOLrC  hX
   ELICIT-INFORMrC  h]rC  X   basicrC  ah]rC  X   al_load_fontrC  auK]}rC  (hX   60rC  h	X   pleaserC  hX
   ProgrammerrC  h
X   92rC  hX   CONTrC  hX   BE-POSITIVErC  hNhNuK^}rC  (hX   61rC  h	X%   more information about al_color_cmyk rC  hX
   ProgrammerrC  h
X   90rC  hX   FOLrC  hX
   ELICIT-INFORMrC  h]rC  X   basicrC  ah]rC  X
   al_color_cmykrC  auK_}rC  (hX   61rC  h	X   pleaserC  hX
   ProgrammerrC  h
X   94rC  hX   CONTrC  hX   BE-POSITIVErC  hNhNuK`}rC  (hX   62rC  h	X   Sure thing!\n\nrC  hX   ApizarC  h
X   92rC  hX   POSrC  hX   BE-POSITIVErC  hNhNuKa}rC  (hX   62rC  h	XO   ```ALLEGRO_FONT *al_load_font(char const *filename, int size, int flags)```\n\nrC  hX   ApizarC  h
X   96rC  hX   CONTrC  hX   INFORMrC  h]rC  X   basicrC  ah]rC  X   al_load_fontrC  auKb}rC  (hX   62rC  h	X   Loads a font from disk. This will use al_load_bitmap_font_flags if you pass the name of a known bitmap format, or else al_load_ttf_font.\n\nrC  hX   ApizarC  h
X   97rC  hX   CONTrC  hX   INFORMrC  h]rC  (X
   functionalityrC  X   controlrC  eh]rC  X   al_load_fontrC  auKc}rC  (hX   62rC  h	X   The flags parameter is passed through to either of those functions. Bitmap and TTF fonts are also affected by the current bitmap flags at the time the font is loaded.rC  hX   ApizarC  h
X   98rC  hX   CONTrC  hX   INFORMr D  h]rD  (X
   functionalityrD  X   controlrD  eh]rD  X   al_load_fontrD  auKd}rD  (hX   63rD  h	XI   ```ALLEGRO_COLOR al_color_cmyk(float c, float m, float y, float k)```\n\nrD  hX   Apizar	D  h
X   94r
D  hX   POSrD  hX   INFORMrD  h]r
D  X   basicrD  ah]rD  X
   al_color_cmykrD  auKe}rD  (hX   63rD  h	XR   Return an ALLEGRO_COLOR structure from CMYK values (cyan, magenta, yellow, black).rD  hX   ApizarD  h
X   100rD  hX   CONTrD  hX   INFORMrD  h]rD  X
   functionalityrD  ah]rD  X
   al_color_cmykrD  auKf}rD  (hX   64rD  h	XH   Would you like me to list all of the functions related to ALLEGRO_COLOR?rD  hX   ApizarD  h
X   100r D  hX   FOLr!D  hX   OFFERr"D  h]r#D  X	   structurer$D  ah]r%D  X
   ALLEGRO_COLORr&D  auKg}r'D  (hX   65r(D  h	X   YES r)D  hX
   Programmerr*D  h
X   102r+D  hX   POSr,D  hX   ASSESSr-D  hNh]r.D  X
   ALLEGRO_COLORr/D  auKh}r0D  (hX   65r1D  h	X   pleaser2D  hX
   Programmerr3D  h
X   103r4D  hX   CONTr5D  hX   BE-POSITIVEr6D  hNhNuKi}r7D  (hX   66r8D  h	X  ```\nal_color_cmyk\nal_color_cmyk_to_rgb\nal_color_hsl\nal_color_hsl_to_rgb\nal_color_hsv\nal_color_hsv_to_rgb\nal_color_html\nal_color_html_to_rgb\nal_color_rgb_to_html\nal_color_name\nal_color_name_to_rgb\nal_color_rgb_to_cmyk\nal_color_rgb_to_hsl\nal_color_rgb_to_hsv\nal_color_rgb_to_name\nal_color_rgb_to_xyz\nal_color_xyz\nal_color_xyz_to_rgb\nal_color_rgb_to_xyy\nal_color_xyy\nal_color_xyy_to_rgb\nal_color_rgb_to_lab\nal_color_lab\nal_color_lab_to_rgb\nal_color_rgb_to_lch\nal_color_lch\nal_color_lch_to_rgb\nal_color_distance_ciede2000_lab\nal_color_rgb_to_yuv\nal_color_yuv\nal_color_yuv_to_rgb\nal_get_allegro_color_version\nal_is_color_valid\n```r9D  hX   Apizar:D  h
X   103r;D  hX   POSr<D  hX   INFORMr=D  h]r>D  X	   structurer?D  ah]r@D  X
   ALLEGRO_COLORrAD  auKj}rBD  (hX   67rCD  h	X   al_load_font example rDD  hX
   ProgrammerrED  h
X   97rFD  hX   FOLrGD  hX
   ELICIT-INFORMrHD  h]rID  X   examplesrJD  ah]rKD  X   al_load_fontrLD  auKk}rMD  (hX   67rND  h	X   pleaserOD  hX
   ProgrammerrPD  h
X   106rQD  hX   CONTrRD  hX   BE-POSITIVErSD  hNhNuuuK}rTD  (hj?>  h}rUD  (K }rVD  (hhh	X
   Anyone there?rWD  hX
   ProgrammerrXD  h
NhNhX"   ELICIT-COMMENT-ABOUT-UNDERSTANDINGrYD  hNhNuK}rZD  (hhh	X   Hi! r[D  hX   Apizar\D  h
NhNhX   BE-POSITIVEr]D  hNhNuK}r^D  (hhh	XL   I am Apiza, a virtual assistant built to help you navigate the Allegro API. r_D  hX   Apizar`D  h
NhNhX   INFORMraD  hNhNuK}rbD  (hhh	X   How can I help you?rcD  hX   ApizardD  h
NhNhX   ELICIT-OFFER-OR-SUGGESTIONreD  hNhNuK}rfD  (hh+h	X/   What functions are provided for keyboard input?rgD  hX
   ProgrammerrhD  h
NhNhX
   ELICIT-INFORMriD  h]rjD  X	   structurerkD  ahNuK}rlD  (hh5h	XD   I found the following functions labelled as "Keyboard routines":\n\nrmD  hX   ApizarnD  h
h5hX   POSroD  hX   INFORMrpD  hNhNuK}rqD  (hh5h	X   al_install_keyboard\nal_is_keyboard_installed\nal_uninstall_keyboard\nal_get_keyboard_state\nal_clear_keyboard_state\nal_key_down\nal_keycode_to_name\nal_set_keyboard_leds\nal_get_keyboard_event_sourcerrD  hX   ApizarsD  h
h<hX   CONTrtD  hX   INFORMruD  h]rvD  X	   structurerwD  ahNuK}rxD  (hh<h	X1   what is the parameter list of ai_install_keyboardryD  hX
   ProgrammerrzD  h
NhNhX
   ELICIT-INFORMr{D  h]r|D  X   basicr}D  ah]r~D  X   al_install_keyboardrD  auK}rD  (hhFh	X   bool al_install_keyboard(void)rD  hX   ApizarD  h
hQhX   POSrD  hX   INFORMrD  h]rD  X   basicrD  ah]rD  X   al_install_keyboardrD  auK	}rD  (hhQh	X*   When does ai_install_keyboard return true?rD  hX
   ProgrammerrD  h
NhNhX
   ELICIT-INFORMrD  h]rD  X
   functionalityrD  ah]rD  X   al_install_keyboardrD  auK
}rD  (hhXh	Xd   Returns true if successful. If a driver was already installed, nothing happens and true is returned.rD  hX   ApizarD  h
hchX   POSrD  hX   INFORMrD  h]rD  X
   functionalityrD  ah]rD  X   al_install_keyboardrD  auK}rD  (hhch	X3   What is the parameter list of al_uninstall_keyboardrD  hX
   ProgrammerrD  h
NhNhX
   ELICIT-INFORMrD  h]rD  X   basicrD  ah]rD  X   al_uninstall_keyboardrD  auK}rD  (hX   10rD  h	X    void al_uninstall_keyboard(void)rD  hX   ApizarD  h
X   11rD  hX   POSrD  hX   INFORMrD  h]rD  X   basicrD  ah]rD  X   al_uninstall_keyboardrD  auK
}rD  (hX   11rD  h	X#   How can I implement keyboard input?rD  hX
   ProgrammerrD  h
NhNhX   ELICIT-OFFER-OR-SUGGESTIONrD  h]rD  X   patternsrD  ahNuK}rD  (hX   12rD  h	XA   To get keyboard input, you can utilize the ALLEGRO_EVENT struct. rD  hX   ApizarD  h
X   13rD  hX   POSrD  hX   SUGGESTrD  h]rD  X   patternsrD  ah]rD  X
   ALLEGRO_EVENTrD  auK}rD  (hX   12rD  h	X   The event types ALLEGRO_EVENT_KEY_DOWN, ALLEGRO_EVENT_KEY_UP, and ALLEGRO_EVENT_KEY_CHAR allow you to get keys pressed or released in event.keyboard.keycoderD  hX   ApizarD  h
X   14rD  hX   CONTrD  hX   INFORMrD  h]rD  X   patternsrD  ah]rD  X
   ALLEGRO_EVENTrD  auK}rD  (hX   13rD  h	X<   What is the parameter list for al_get_keyboard_event_source?rD  hX
   ProgrammerrD  h
NhNhX
   ELICIT-INFORMrD  h]rD  X   basicrD  ah]rD  X   al_get_keyboard_event_sourcerD  auK}rD  (hX   14rD  h	X8   ALLEGRO_EVENT_SOURCE *al_get_keyboard_event_source(void)rD  hX   ApizarD  h
X   16rD  hX   POSrD  hX   INFORMrD  h]rD  X   basicrD  ah]rD  X   al_get_keyboard_event_sourcerD  auK}rD  (hX   15rD  h	X#   What type is event.keyboard.keycoderD  hX
   ProgrammerrD  h
X   15rD  hX   FOLrD  hX
   ELICIT-INFORMrD  h]rD  X   basicrD  ah]rD  X
   ALLEGRO_EVENTrD  auK}rD  (hX   16rD  h	XU   keyboard.keycode (int)\nThe code corresponding to the physical key which was pressed.rD  hX   ApizarD  h
X   18rD  hX   POSrD  hX   INFORMrD  h]rD  (X   conceptsrD  X   basicrD  eh]rD  X
   ALLEGRO_EVENTrD  auK}rD  (hX   17rD  h	X   How can I play sound effects?rD  hX
   ProgrammerrD  h
NhNhX   ELICIT-OFFER-OR-SUGGESTIONrD  h]rD  X   patternsrD  ahNuK}rD  (hX   18rD  h	X8   The simplest method to Play Sound is al_play_sample:\n\nrD  hX   ApizarD  h
X   20r E  hX   POSrE  hX   SUGGESTrE  h]rE  X   patternsrE  ah]rE  X   al_play_samplerE  auK}rE  (hX   18rE  h	X   ```bool al_play_sample(ALLEGRO_SAMPLE *spl, float gain, float pan, float speed,\n ALLEGRO_PLAYMODE loop, ALLEGRO_SAMPLE_ID *ret_id)```\n\nr	E  hX   Apizar
E  h
X   21rE  hX   CONTrE  hX   INFORMr
E  h]rE  X   basicrE  ah]rE  X   al_play_samplerE  auK}rE  (hX   18rE  h	Xz   To use al_play_sample, you must first install the audio subsystem, the audio codec addon, reserve samples, and load samplerE  hX   ApizarE  h
X   22rE  hX   CONTrE  hX   SUGGESTrE  h]rE  X
   directivesrE  ah]rE  X   al_play_samplerE  auK}rE  (hX   19rE  h	X%   How do I install the audio subsystem?rE  hX
   Programmerr E  h
X   23r!E  hX   FOLr"E  hX   ELICIT-OFFER-OR-SUGGESTIONr#E  h]r$E  X   patternsr%E  ahNuK}r&E  (hX   20r'E  h	X,   This should install the audio subsystem:\n\nr(E  hX   Apizar)E  h
X   24r*E  hX   POSr+E  hX   SUGGESTr,E  h]r-E  X   patternsr.E  ahNuK}r/E  (hX   20r0E  h	X%   ```bool al_install_audio(void)```\n\nr1E  hX   Apizar2E  h
X   25r3E  hX   CONTr4E  hX   INFORMr5E  h]r6E  X   basicr7E  ah]r8E  X   al_install_audior9E  auK}r:E  (hX   20r;E  h	X   Install the audio subsystem.r<E  hX   Apizar=E  h
X   26r>E  hX   CONTr?E  hX   INFORMr@E  h]rAE  X   basicrBE  ah]rCE  X   al_install_audiorDE  auK}rEE  (hX   21rFE  h	X'   How can I install an audio codec addon?rGE  hX
   ProgrammerrHE  h
X   23rIE  hX   FOLrJE  hX   ELICIT-OFFER-OR-SUGGESTIONrKE  h]rLE  X   patternsrME  ahNuK}rNE  (hX   22rOE  h	X)   ```bool al_init_acodec_addon(void)```\n\nrPE  hX   ApizarQE  h
X   28rRE  hX   POSrSE  hX   INFORMrTE  h]rUE  X   basicrVE  ah]rWE  X   al_init_acodec_addonrXE  auK}rYE  (hX   22rZE  h	X}   This function registers all the known audio file type handlers for al_load_sample, al_save_sample, al_load_audio_stream, etc.r[E  hX   Apizar\E  h
X   29r]E  hX   CONTr^E  hX   INFORMr_E  h]r`E  (X
   functionalityraE  X   patternsrbE  eh]rcE  X   al_init_acodec_addonrdE  auK}reE  (hX   23rfE  h	X)   How can I reserve and load audio samples?rgE  hX
   ProgrammerrhE  h
X   23riE  hX   FOLrjE  hX   ELICIT-OFFER-OR-SUGGESTIONrkE  h]rlE  X   patternsrmE  ahNuK }rnE  (hX   24roE  h	XO   *Reserve audio samples:\n\n```bool al_reserve_samples(int reserve_samples)```\nrpE  hX   ApizarqE  h
X   31rrE  hX   POSrsE  hX   INFORMrtE  h]ruE  X   basicrvE  ah]rwE  X   al_reserve_samplesrxE  auK!}ryE  (hX   24rzE  h	XO   Reserves a number of sample instances, attaching them to the default mixer.\n\nr{E  hX   Apizar|E  h
X   32r}E  hX   CONTr~E  hX   INFORMrE  h]rE  X
   functionalityrE  ah]rE  X   al_reserve_samplesrE  auK"}rE  (hX   24rE  h	XT   *Load audio samples:\n\n```ALLEGRO_SAMPLE *al_load_sample(const char *filename)```\nrE  hX   ApizarE  h
X   33rE  hX   CONTrE  hX   INFORMrE  h]rE  X   basicrE  ah]rE  X   al_load_samplerE  auK#}rE  (hX   24rE  h	XB   Loads a few different audio file formats based on their extension.rE  hX   ApizarE  h
X   34rE  hX   CONTrE  hX   INFORMrE  h]rE  X
   functionalityrE  ah]rE  X   al_load_samplerE  auK$}rE  (hX   25rE  h	X    Where are the samples allocated?rE  hX
   ProgrammerrE  h
X   34rE  hX   FOLrE  hX
   ELICIT-INFORMrE  h]rE  X
   functionalityrE  ah]rE  X   al_load_samplerE  auK%}rE  (hX   26rE  h	X=   Audio samples are contained within the ALLEGRO_SAMPLE struct.rE  hX   ApizarE  h
X   36rE  hX   POSrE  hX   INFORMrE  h]rE  X
   functionalityrE  ah]rE  (X   al_load_samplerE  X   ALLEGRO_SAMPLErE  euK&}rE  (hX   27rE  h	X   plauyrE  hX   ApizarE  h
NhNhX   OTHERrE  hNhNuK'}rE  (hX   28rE  h	X&   Is this created by al_reserve_samples?rE  hX
   ProgrammerrE  h
X   37rE  hX   FOLrE  hX
   ELICIT-INFORMrE  h]rE  X
   functionalityrE  ah]rE  (X   al_reserve_samplesrE  X   ALLEGRO_SAMPLErE  euK(}rE  (hX   29rE  h	X?   al_reserve_samples Returns true on success, false on error.\n\nrE  hX   ApizarE  h
X   39rE  hX   POSrE  hX   INFORMrE  h]rE  X
   functionalityrE  ah]rE  X   al_reserve_samplesrE  auK)}rE  (hX   29rE  h	X>   al_load_sample Returns the sample on success, NULL on failure.rE  hX   ApizarE  h
X   40rE  hX   CONTrE  hX   INFORMrE  h]rE  X
   functionalityrE  ah]rE  X   al_load_samplerE  auK*}rE  (hX   30rE  h	X$   is there a function to free samples?rE  hX
   ProgrammerrE  h
X   34rE  hX   FOLrE  hX
   ELICIT-INFORMrE  h]rE  X   patternsrE  ahNuK+}rE  (hX   31rE  h	X"   al_destroy_sample should work:\n\nrE  hX   ApizarE  h
X   42rE  hX   POSrE  hX   SUGGESTrE  h]rE  X   patternsrE  ah]rE  X   al_destroy_samplerE  auK,}rE  (hX   31rE  h	X5   ```void al_destroy_sample(ALLEGRO_SAMPLE *spl)```\n\nrE  hX   ApizarE  h
X   43rE  hX   CONTrE  hX   INFORMrE  h]rE  X   basicrE  ah]rE  X   al_destroy_samplerE  auK-}rE  (hX   31rE  h	X   Free the sample data structure.rE  hX   ApizarE  h
X   44rE  hX   CONTrE  hX   INFORMrE  h]rE  X
   functionalityrE  ah]r F  X   al_destroy_samplerF  auK.}rF  (hX   32rF  h	X.   What are possible values for ALLEGRO_PLAYNODE?rF  hX
   ProgrammerrF  h
X   22rF  hX   FOLrF  hX
   ELICIT-INFORMrF  h]r	F  X	   structurer
F  ah]rF  (X   ALLEGRO_PLAYMODErF  X   al_play_sampler
F  euK/}rF  (hX   33rF  h	X   enum ALLEGRO_PLAYMODE\n\nrF  hX   ApizarF  h
X   46rF  hX   POSrF  hX   OTHERrF  h]rF  X   basicrF  ah]rF  X   ALLEGRO_PLAYMODErF  auK0}rF  (hX   33rF  h	X1   Description: Sample and stream playback mode.\n\nrF  hX   ApizarF  h
X   47rF  hX   CONTrF  hX   INFORMrF  h]r F  X   basicr!F  ah]r"F  X   ALLEGRO_PLAYMODEr#F  auK1}r$F  (hX   33r%F  h	XM   Values:\nALLEGRO_PLAYMODE_ONCE\nALLEGRO_PLAYMODE_LOOP\nALLEGRO_PLAYMODE_BIDIRr&F  hX   Apizar'F  h
X   48r(F  hX   CONTr)F  hX   INFORMr*F  h]r+F  X	   structurer,F  ah]r-F  X   ALLEGRO_PLAYMODEr.F  auK2}r/F  (hX   34r0F  h	XX   What is the purpose of the last parameter in al_play_sample? (ALLEGRO_SAMPLE_ID *ret_id)r1F  hX
   Programmerr2F  h
X   22r3F  hX   FOLr4F  hX
   ELICIT-INFORMr5F  h]r6F  X
   functionalityr7F  ah]r8F  X   al_play_sampler9F  auK3}r:F  (hX   35r;F  h	X   ret_id - if non-NULL the variable which this points to will be assigned an id representing the sample being played. If al_play_sample returns false, then the contents of ret_id are invalid and must not be used as argument to other functions.r<F  hX   Apizar=F  h
X   50r>F  hX   POSr?F  hX   INFORMr@F  h]rAF  (X
   functionalityrBF  X
   directivesrCF  eh]rDF  X   al_play_samplerEF  auK4}rFF  (hX   36rGF  h	X/   How can I display text within the window frame?rHF  hX
   ProgrammerrIF  h
NhNhX   ELICIT-OFFER-OR-SUGGESTIONrJF  h]rKF  X   patternsrLF  ahNuK5}rMF  (hX   37rNF  h	XH   The simplest method to Display text in window frame is al_draw_text:\n\nrOF  hX   ApizarPF  h
X   52rQF  hX   POSrRF  hX   SUGGESTrSF  h]rTF  X   patternsrUF  ah]rVF  X   al_draw_textrWF  auK6}rXF  (hX   37rYF  h	X~   ```void al_draw_text(const ALLEGRO_FONT *font,\n ALLEGRO_COLOR color, float x, float y, int flags,\n char const *text) ```\n\nrZF  hX   Apizar[F  h
X   53r\F  hX   CONTr]F  hX   INFORMr^F  h]r_F  X   basicr`F  ah]raF  X   al_draw_textrbF  auK7}rcF  (hX   37rdF  h	X&   This requires the ALLEGRO_FONT add-on.reF  hX   ApizarfF  h
X   54rgF  hX   CONTrhF  hX   INFORMriF  h]rjF  X
   directivesrkF  ah]rlF  (X   al_draw_textrmF  X   ALLEGRO_FONTrnF  euK8}roF  (hX   38rpF  h	X-   How can I initialize the ALLEGRO_FONT add-on?rqF  hX
   ProgrammerrrF  h
X   55rsF  hX   FOLrtF  hX   ELICIT-OFFER-OR-SUGGESTIONruF  h]rvF  X   patternsrwF  ah]rxF  X   ALLEGRO_FONTryF  auK9}rzF  (hX   39r{F  h	X'   ```bool al_init_font_addon(void)```\n\nr|F  hX   Apizar}F  h
X   56r~F  hX   POSrF  hX   INFORMrF  h]rF  X   basicrF  ah]rF  (X   ALLEGRO_FONTrF  X   al_init_font_addonrF  euK:}rF  (hX   39rF  h	X   Initialise the font addon.rF  hX   ApizarF  h
X   57rF  hX   CONTrF  hX   INFORMrF  h]rF  X   basicrF  ah]rF  X   al_init_font_addonrF  auK;}rF  (hX   40rF  h	X   How can I load a font?rF  hX
   ProgrammerrF  h
X   54rF  hX   FOLrF  hX   ELICIT-OFFER-OR-SUGGESTIONrF  h]rF  X   patternsrF  ahNuK<}rF  (hX   41rF  h	X7   The simplest method to Load a font is al_load_font:\n\nrF  hX   ApizarF  h
X   59rF  hX   POSrF  hX   SUGGESTrF  h]rF  X   patternsrF  ah]rF  X   al_load_fontrF  auK=}rF  (hX   41rF  h	XO   ```ALLEGRO_FONT *al_load_font(char const *filename, int size, int flags)```\n\nrF  hX   ApizarF  h
X   60rF  hX   CONTrF  hX   INFORMrF  h]rF  X   basicrF  ah]rF  X   al_load_fontrF  auK>}rF  (hX   41rF  h	X   Loads a font from disk.rF  hX   ApizarF  h
X   61rF  hX   CONTrF  hX   INFORMrF  h]rF  X   basicrF  ah]rF  X   al_load_fontrF  auK?}rF  (hX   42rF  h	X'   What are the parameters size and flags?rF  hX
   ProgrammerrF  h
X   61rF  hX   FOLrF  hX
   ELICIT-INFORMrF  h]rF  (X   conceptsrF  X   basicrF  eh]rF  X   al_load_fontrF  auK@}rF  (hX   43rF  h	X   The size parameter is an int.\n\nThe flags parameter is passed through to either of those functions. Bitmap and TTF fonts are also affected by the current bitmap flags at the time the font is loaded.rF  hX   ApizarF  h
X   63rF  hX   POSrF  hX   INFORMrF  h]rF  (X
   functionalityrF  X   basicrF  eh]rF  X   al_load_fontrF  auKA}rF  (hX   44rF  h	X   What is the size of a font?rF  hX
   ProgrammerrF  h
X   64rF  hX   FOLrF  hX
   ELICIT-INFORMrF  h]rF  X   conceptsrF  ah]rF  X   al_load_fontrF  auKB}rF  (hX   45rF  h	X#   What are possible values for flags?rF  hX
   ProgrammerrF  h
X   64rF  hX   FOLrF  hX
   ELICIT-INFORMrF  h]rF  X
   directivesrF  ah]rF  X   al_load_fontrF  auKC}rF  (hX   46rF  h	XR   I found a description of the int size for the similar method al_load_ttf_font:\n\nrF  hX   ApizarF  h
X   65rF  hX   POSrF  hX   INFORMrF  hNh]rF  X   al_load_fontrF  auKD}rF  (hX   46rF  h	XY   The size parameter determines the size the font will be rendered at, specified in pixels.rF  hX   ApizarF  h
X   67rF  hX   CONTrF  hX   INFORMrF  h]rF  X   conceptsrF  ah]rF  X   al_load_fontrF  auKE}rF  (hX   47rF  h	X<   I found this list of supported values for the int flags:\n\nrF  hX   Apizar G  h
X   66rG  hX   POSrG  hX   INFORMrG  hNh]rG  X   al_load_fontrG  auKF}rG  (hX   47rG  h	X@  ALLEGRO_TTF_NO_KERNING - Do not use any kerning even if the font file supports it.\n\nALLEGRO_TTF_MONOCHROME - Load as a monochrome font (which means no anti-aliasing of the font is done).\n\nALLEGRO_TTF_NO_AUTOHINT - Disable the Auto Hinter which is enabled by default in newer versions of FreeType. Since: 5.0.6, 5.1.2rG  hX   Apizar	G  h
X   69r
G  hX   CONTrG  hX   INFORMrG  h]r
G  (X
   functionalityrG  X
   directivesrG  X	   structurerG  X   environmentrG  eh]rG  X   al_load_fontrG  auKG}rG  (hX   48rG  h	X   How can I free a font?rG  hX
   ProgrammerrG  h
NhNhX   ELICIT-OFFER-OR-SUGGESTIONrG  h]rG  X   patternsrG  ahNuKH}rG  (hX   49rG  h	X   al_destroy_font\n\nrG  hX   ApizarG  h
X   71rG  hX   POSr G  hX   INFORMr!G  h]r"G  X   basicr#G  ah]r$G  X   al_destroy_fontr%G  auKI}r&G  (hX   49r'G  h	X/   ```void al_destroy_font(ALLEGRO_FONT *f)```\n\nr(G  hX   Apizar)G  h
X   72r*G  hX   CONTr+G  hX   INFORMr,G  h]r-G  X   basicr.G  ah]r/G  X   al_destroy_fontr0G  auKJ}r1G  (hX   49r2G  h	XM   Frees the memory being used by a font structure. Does nothing if passed NULL.r3G  hX   Apizar4G  h
X   73r5G  hX   CONTr6G  hX   INFORMr7G  h]r8G  X
   functionalityr9G  ah]r:G  X   al_destroy_fontr;G  auKK}r<G  (hX   50r=G  h	X,   What are the values x and y in al_draw_text?r>G  hX
   Programmerr?G  h
X   54r@G  hX   FOLrAG  hX
   ELICIT-INFORMrBG  h]rCG  X
   functionalityrDG  ah]rEG  X   al_draw_textrFG  auKL}rGG  (hX   51rHG  h	X+   What are possible values for ALLEGRO_COLOR?rIG  hX
   ProgrammerrJG  h
X   54rKG  hX   FOLrLG  hX
   ELICIT-INFORMrMG  h]rNG  X
   directivesrOG  ah]rPG  X
   ALLEGRO_COLORrQG  auKM}rRG  (hX   52rSG  h	X"   The x and y variables are floats. rTG  hX   ApizarUG  h
X   75rVG  hX   POSrWG  hX   INFORMrXG  h]rYG  X   basicrZG  ah]r[G  X   al_draw_textr\G  auKN}r]G  (hX   52r^G  h	X   The function al_draw_text Writes the NUL-terminated string text onto the target bitmap at position x, y, using the specified font.r_G  hX   Apizar`G  h
X   77raG  hX   CONTrbG  hX   INFORMrcG  h]rdG  X
   functionalityreG  ah]rfG  X   al_draw_textrgG  auKO}rhG  (hX   53riG  h	X*   What is the coordinate system for x and y?rjG  hX
   ProgrammerrkG  h
X   78rlG  hX   FOLrmG  hX
   ELICIT-INFORMrnG  h]roG  X   conceptsrpG  ah]rqG  X   al_draw_textrrG  auKP}rsG  (hX   54rtG  h	X5   ```typedef struct ALLEGRO_COLOR ALLEGRO_COLOR;```\n\nruG  hX   ApizarvG  h
X   76rwG  hX   PARTrxG  hX   INFORMryG  h]rzG  X   basicr{G  ah]r|G  X
   ALLEGRO_COLORr}G  auKQ}r~G  (hX   54rG  h	XJ   An ALLEGRO_COLOR structure describes a color in a device independent way. rG  hX   ApizarG  h
X   81rG  hX   CONTrG  hX   INFORMrG  h]rG  X   purposerG  ah]rG  X
   ALLEGRO_COLORrG  auKR}rG  (hX   54rG  h	Xe   Use al_map_rgb et al. and al_unmap_rgb et al. to translate from and to various color representations.rG  hX   ApizarG  h
X   82rG  hX   CONTrG  hX   INFORMrG  h]rG  X   patternsrG  ah]rG  (X
   ALLEGRO_COLORrG  X
   al_map_rgbrG  X   al_unmap_rgbrG  euKS}rG  (hX   55rG  h	X'   What are the parameters for al_map_rgb?rG  hX
   ProgrammerrG  h
X   82rG  hX   FOLrG  hX
   ELICIT-INFORMrG  h]rG  X   basicrG  ah]rG  X
   al_map_rgbrG  auKT}rG  (hX   56rG  h	X7   I am not sure about the coordinate system for x and y .rG  hX   ApizarG  h
X   79rG  hX   NEGrG  hX   INFORMrG  hNh]rG  X   al_draw_textrG  auKU}rG  (hX   57rG  h	X2   What is the minimum and maximum value for x and y?rG  hX
   ProgrammerrG  h
X   84rG  hX   FOLrG  hX
   ELICIT-INFORMrG  h]rG  X
   directivesrG  ah]rG  X   al_draw_textrG  auKV}rG  (hX   58rG  h	XX   ```ALLEGRO_COLOR al_map_rgb(\n unsigned char r, unsigned char g, unsigned char b)```\n\nrG  hX   ApizarG  h
X   83rG  hX   POSrG  hX   INFORMrG  h]rG  X   basicrG  ah]rG  X
   al_map_rgbrG  auKW}rG  (hX   58rG  h	XP   Convert r, g, b (ranging from 0-255) into an ALLEGRO_COLOR, using 255 for alpha.rG  hX   ApizarG  h
X   86rG  hX   CONTrG  hX   INFORMrG  h]rG  (X
   functionalityrG  X
   directivesrG  eh]rG  X
   al_map_rgbrG  auKX}rG  (hX   59rG  h	X   x and y refer to the pixel coordinates within the display. The coordinate (0,0) refers to the upper-left-most pixel of the display.rG  hX   ApizarG  h
X   79rG  hX   POSrG  hX   INFORMrG  h]rG  X   conceptsrG  ah]rG  X   al_draw_textrG  auKY}rG  (hX   60rG  h	X1   How can I get the height and width of the window?rG  hX
   ProgrammerrG  h
X   88rG  hX   FOLrG  hX   ELICIT-OFFER-OR-SUGGESTIONrG  h]rG  X   patternsrG  ahNuKZ}rG  (hX   61rG  h	X   These methods should work:\n\nrG  hX   ApizarG  h
X   89rG  hX   POSrG  hX   SUGGESTrG  h]rG  X   patternsrG  ahNuK[}rG  (hX   61rG  h	X<   ```int al_get_display_width(ALLEGRO_DISPLAY *display)```\n\nrG  hX   ApizarG  h
X   90rG  hX   CONTrG  hX   INFORMrG  h]rG  X   basicrG  ah]rG  X   al_get_display_widthrG  auK\}rG  (hX   61rG  h	X"   Gets the width of the display.\n\nrG  hX   ApizarG  h
X   91rG  hX   CONTrG  hX   INFORMrG  h]rG  X   basicrG  ah]rG  X   al_get_display_widthrG  auK]}rG  (hX   61r H  h	X=   ```int al_get_display_height(ALLEGRO_DISPLAY *display)```\n\nrH  hX   ApizarH  h
X   92rH  hX   CONTrH  hX   INFORMrH  h]rH  X   basicrH  ah]rH  X   al_get_display_heightr	H  auK^}r
H  (hX   61rH  h	X   Gets the height of the display.rH  hX   Apizar
H  h
X   93rH  hX   CONTrH  hX   INFORMrH  h]rH  X   basicrH  ah]rH  X   al_get_display_heightrH  auK_}rH  (hX   62rH  h	XS   How can I convert an integer from al_get_display_width to a float for coordinate x?rH  hX
   ProgrammerrH  h
X   91rH  hX   FOLrH  hX   ELICIT-OFFER-OR-SUGGESTIONrH  h]rH  X   patternsrH  ah]rH  X   al_get_display_widthrH  auK`}r H  (hX   63r!H  h	X%   al_get_display_width returns an int. r"H  hX   Apizar#H  h
X   95r$H  hX   POSr%H  hX   INFORMr&H  h]r'H  X   basicr(H  ah]r)H  X   al_get_display_widthr*H  auKa}r+H  (hX   63r,H  h	X   This value can cast to a floatr-H  hX   Apizar.H  h
X   96r/H  hX   CONTr0H  hX   INFORMr1H  h]r2H  X   basicr3H  ahNuKb}r4H  (hX   64r5H  h	X(   What is the return type of al_draw_text?r6H  hX
   Programmerr7H  h
X   54r8H  hX   FOLr9H  hX
   ELICIT-INFORMr:H  h]r;H  X   basicr<H  ah]r=H  X   al_draw_textr>H  auKc}r?H  (hX   65r@H  h	X    void al_draw_text\n\nVoid returnrAH  hX   ApizarBH  h
X   98rCH  hX   POSrDH  hX   INFORMrEH  h]rFH  X   basicrGH  ah]rHH  X   al_draw_textrIH  auKd}rJH  (hX   66rKH  h	X*   Can you give me an example to render text?rLH  hX
   ProgrammerrMH  h
X   54rNH  hX   FOLrOH  hX
   ELICIT-INFORMrPH  h]rQH  X   examplesrRH  ahNuKe}rSH  (hX   67rTH  h	X   Sure, rUH  hX   ApizarVH  h
X   100rWH  hX   POSrXH  hX   INFORMrYH  hNhNuKf}rZH  (hX   67r[H  h	X&   I will try to put together an example.r\H  hX   Apizar]H  h
X   101r^H  hX   CONTr_H  hX   OFFERr`H  hNhNuKg}raH  (hX   68rbH  h	X   How can I stop a timer?rcH  hX
   ProgrammerrdH  h
NhNhX   ELICIT-OFFER-OR-SUGGESTIONreH  h]rfH  X   patternsrgH  ahNuKh}rhH  (hX   69riH  h	X    How can I register mouse events?rjH  hX
   ProgrammerrkH  h
NhNhX   ELICIT-OFFER-OR-SUGGESTIONrlH  h]rmH  X   patternsrnH  ahNuKi}roH  (hX   70rpH  h	X   al_stop_timer should work:\n\nrqH  hX   ApizarrH  h
X   103rsH  hX   POSrtH  hX   SUGGESTruH  h]rvH  X   patternsrwH  ah]rxH  X
   al_stop_timerryH  auKj}rzH  (hX   70r{H  h	X2   ```void al_stop_timer(ALLEGRO_TIMER *timer)```\n\nr|H  hX   Apizar}H  h
X   105r~H  hX   CONTrH  hX   INFORMrH  h]rH  X   basicrH  ah]rH  X
   al_stop_timerrH  auKk}rH  (hX   70rH  h	X   Stop the timer specified.rH  hX   ApizarH  h
X   106rH  hX   CONTrH  hX   INFORMrH  h]rH  X
   functionalityrH  ah]rH  X
   al_stop_timerrH  auKl}rH  (hX   71rH  h	X9   I was able to put together an example to Render text:\n\nrH  hX   ApizarH  h
X   102rH  hX   FOLrH  hX   INFORMrH  h]rH  X   examplesrH  ahNuKm}rH  (hX   71rH  h	Xh  ```al_init_font_addon(); // initialize the font addon\nal_init_ttf_addon();// initialize the ttf (True Type Font) addon\n...\nALLEGRO_DISPLAY *display = al_create_display(640,480);\n...\nALLEGRO_FONT *font = al_load_ttf_font("pirulen.ttf",72,0 );\n...\nal_draw_text(font, al_map_rgb(255,255,255), 640/2, (480/4),ALLEGRO_ALIGN_CENTRE, "Your Text Here!");```\n\nrH  hX   ApizarH  h
X   108rH  hX   CONTrH  hX   INFORMrH  h]rH  X   examplesrH  ahNuKn}rH  (hX   71rH  h	X   Does this look useful?rH  hX   ApizarH  h
X   109rH  hX   FOLrH  hX   ELICIT-ASSESSMENTrH  hNhNuKo}rH  (hX   72rH  h	X(   There are several Mouse event types:\n\nrH  hX   ApizarH  h
X   104rH  hX   PARTrH  hX   INFORMrH  hNhNuKp}rH  (hX   72rH  h	X   ALLEGRO_EVENT_MOUSE_AXES\nALLEGRO_EVENT_MOUSE_BUTTON_DOWN\nALLEGRO_EVENT_MOUSE_BUTTON_UP\nALLEGRO_EVENT_MOUSE_WARPED\nALLEGRO_EVENT_MOUSE_ENTER_DISPLAY\nALLEGRO_EVENT_MOUSE_LEAVE_DISPLAYrH  hX   ApizarH  h
X   111rH  hX   CONTrH  hX   INFORMrH  h]rH  X	   structurerH  ahNuKq}rH  (hX   73rH  h	X#   How can I get the state of a timer?rH  hX
   ProgrammerrH  h
NhNhX   ELICIT-OFFER-OR-SUGGESTIONrH  h]rH  X   patternsrH  ahNuKr}rH  (hX   74rH  h	X+   How can I resume a timer after stopping it?rH  hX
   ProgrammerrH  h
NhNhX   ELICIT-OFFER-OR-SUGGESTIONrH  h]rH  X   patternsrH  ahNuKs}rH  (hX   75rH  h	XE   I found a few methods to get information about an ALLEGRO_TIMER :\n\nrH  hX   ApizarH  h
X   113rH  hX   PARTrH  hX   INFORMrH  hNh]rH  X
   ALLEGRO_TIMERrH  auKt}rH  (hX   75rH  h	X[   al_get_timer_started\nal_get_timer_count\nal_get_timer_speed\nal_get_timer_event_source\n\nrH  hX   ApizarH  h
X   115rH  hX   CONTrH  hX   INFORMrH  h]rH  X	   structurerH  ah]rH  X   al_get_timer_startedrH  auKu}rH  (hX   75rH  h	X3   I could not find any that return an ALLEGRO_STATE .rH  hX   ApizarH  h
X   116rH  hX   CONTrH  hX   INFORMrH  h]rH  X	   structurerH  ah]rH  X
   ALLEGRO_STATErH  auKv}rH  (hX   76rH  h	X0   What is the return type of al_get_timer_started?rH  hX
   ProgrammerrH  h
X   116rH  hX   FOLrH  hX
   ELICIT-INFORMrH  h]rH  X   basicrH  ah]rH  X   al_get_timer_startedrH  auKw}rH  (hX   77rH  h	X5   ``` void al_resume_timer(ALLEGRO_TIMER *timer)```\n\nrH  hX   ApizarH  h
X   114rH  hX   POSrH  hX   INFORMrH  h]rH  X   basicrH  ah]rH  X   al_resume_timerrH  auKx}rH  (hX   77rH  h	X   Resume the timer specified.rH  hX   ApizarH  h
X   119r I  hX   CONTrI  hX   INFORMrI  h]rI  X   basicrI  ah]rI  X   al_resume_timerrI  auKy}rI  (hX   78rI  h	X?   ```bool al_get_timer_started(const ALLEGRO_TIMER *timer)```\n\nr	I  hX   Apizar
I  h
X   118rI  hX   POSrI  hX   INFORMr
I  h]rI  X   basicrI  ah]rI  X   al_get_timer_startedrI  auKz}rI  (hX   78rI  h	X8   Return true if the timer specified is currently started.rI  hX   ApizarI  h
X   121rI  hX   CONTrI  hX   INFORMrI  h]rI  X
   functionalityrI  ah]rI  X   al_get_timer_startedrI  auK{}rI  (hX   79rI  h	X#   How can I install the mouse driver?rI  hX
   Programmerr I  h
NhNhX   ELICIT-OFFER-OR-SUGGESTIONr!I  h]r"I  X   patternsr#I  ahNuK|}r$I  (hX   80r%I  h	X   al_install_mouse\n\nr&I  hX   Apizar'I  h
X   123r(I  hX   POSr)I  hX   INFORMr*I  hNh]r+I  X   al_install_mouser,I  auK}}r-I  (hX   80r.I  h	X%   ```bool al_install_mouse(void)```\n\nr/I  hX   Apizar0I  h
X   124r1I  hX   CONTr2I  hX   INFORMr3I  h]r4I  X   basicr5I  ah]r6I  X   al_install_mouser7I  auK~}r8I  (hX   80r9I  h	X   Install a mouse driver.\n\nr:I  hX   Apizar;I  h
X   125r<I  hX   CONTr=I  hX   INFORMr>I  h]r?I  X   basicr@I  ah]rAI  X   al_install_mouserBI  auK}rCI  (hX   80rDI  h	Xd   Returns true if successful. If a driver was already installed, nothing happens and true is returned.rEI  hX   ApizarFI  h
X   126rGI  hX   CONTrHI  hX   INFORMrII  h]rJI  X
   functionalityrKI  ah]rLI  X   al_install_mouserMI  auK}rNI  (hX   81rOI  h	X   How can I load a bitmap?rPI  hX
   ProgrammerrQI  h
NhNhX   ELICIT-OFFER-OR-SUGGESTIONrRI  h]rSI  X   patternsrTI  ahNuK}rUI  (hX   82rVI  h	X,   The simplest function is al_load_bitmap:\n\nrWI  hX   ApizarXI  h
X   128rYI  hX   POSrZI  hX   SUGGESTr[I  h]r\I  X   patternsr]I  ah]r^I  X   al_load_bitmapr_I  auK}r`I  (hX   82raI  h	X>   ```ALLEGRO_BITMAP *al_load_bitmap(const char *filename)```\n\nrbI  hX   ApizarcI  h
X   129rdI  hX   CONTreI  hX   INFORMrfI  h]rgI  X   basicrhI  ah]riI  X   al_load_bitmaprjI  auK}rkI  (hX   82rlI  h	X.   Loads an image file into a new ALLEGRO_BITMAP.rmI  hX   ApizarnI  h
X   130roI  hX   CONTrpI  hX   INFORMrqI  h]rrI  X
   functionalityrsI  ah]rtI  X   al_load_bitmapruI  auK}rvI  (hX   83rwI  h	X"   How can I scale and draw a bitmap?rxI  hX
   ProgrammerryI  h
NhNhX   ELICIT-OFFER-OR-SUGGESTIONrzI  h]r{I  X   patternsr|I  ahNuK}r}I  (hX   84r~I  h	X%   There are a few methods that fit:\n\nrI  hX   ApizarI  h
X   133rI  hX   PARTrI  hX   INFORMrI  hNhNuK}rI  (hX   84rI  h	X   al_draw_scaled_rotated_bitmap\nal_draw_tinted_scaled_rotated_bitmap\nal_draw_tinted_scaled_rotated_bitmap_region\nal_draw_scaled_bitmap\nal_draw_tinted_scaled_bitmap\n\nrI  hX   ApizarI  h
X   134rI  hX   CONTrI  hX   INFORMrI  h]rI  X	   structurerI  ahNuK}rI  (hX   84rI  h	X1   The simplest method is al_draw_scaled_bitmap:\n\nrI  hX   ApizarI  h
X   133rI  hX   POSrI  hX   SUGGESTrI  h]rI  X   patternsrI  ah]rI  X   al_draw_scaled_bitmaprI  auK}rI  (hX   84rI  h	X   ```void al_draw_scaled_bitmap(ALLEGRO_BITMAP *bitmap,\n float sx, float sy, float sw, float sh,\n float dx, float dy, float dw, float dh, int flags)```\n\nrI  hX   ApizarI  h
X   135rI  hX   CONTrI  hX   INFORMrI  h]rI  X   basicrI  ah]rI  X   al_draw_scaled_bitmaprI  auK}rI  (hX   84rI  h	X@   Draws a scaled version of the given bitmap to the target bitmap.rI  hX   ApizarI  h
X   136rI  hX   CONTrI  hX   INFORMrI  h]rI  X
   functionalityrI  ah]rI  X   al_draw_scaled_bitmaprI  auK}rI  (hX   85rI  h	X-   What are the parameters sx, sy, sw, sh, etc.?rI  hX
   ProgrammerrI  h
X   136rI  hX   FOLrI  hX
   ELICIT-INFORMrI  h]rI  X   conceptsrI  ah]rI  X   al_draw_scaled_bitmaprI  auK}rI  (hX   86rI  h	X   The parameters for al_draw_scaled_bitmap:\n\nsx - source x\nsy - source y\nsw - source width\nsh - source height\ndx - destination x\ndy - destination y\ndw - destination width\ndh - destination height\nflags - same as for al_draw_bitmaprI  hX   ApizarI  h
X   139rI  hX   POSrI  hX   INFORMrI  h]rI  X   conceptsrI  ah]rI  X   al_draw_scaled_bitmaprI  auK}rI  (hX   87rI  h	X"   What does al_set_target_bitmap do?rI  hX
   ProgrammerrI  h
NhNhX
   ELICIT-INFORMrI  h]rI  X
   functionalityrI  ah]rI  X   al_set_target_bitmaprI  auK}rI  (hX   88rI  h	X   To summarize:\n\nThis function selects the bitmap to which all subsequent drawing operations in the calling thread will draw to.\n\nrI  hX   ApizarI  h
X   140rI  hX   POSrI  hX   INFORMrI  h]rI  X
   functionalityrI  ah]rI  X   al_set_target_bitmaprI  auK}rI  (hX   88rI  h	X$   Would you like the full description?rI  hX   ApizarI  h
X   141rI  hX   FOLrI  hX
   ELICIT-INFORMrI  hNh]rI  X   al_set_target_bitmaprI  auK}rI  (hX   89rI  h	X,   How can I draw a bitmap onto another bitmap?rI  hX
   ProgrammerrI  h
NhNhX   ELICIT-OFFER-OR-SUGGESTIONrI  h]rI  X   patternsrI  ahNuK}rI  (hX   90rI  h	X$   How can I get the width of a bitmap?rI  hX
   ProgrammerrI  h
NhNhX   ELICIT-OFFER-OR-SUGGESTIONrI  h]rI  X   patternsrI  ahNuK}rI  (hX   91rI  h	X   All al_draw_* functions draw onto the target bitmap. The target bitmap defaults to the display, unless otherwise specified. The target bitmap can be set with al_set_target_bitmap.rI  hX   ApizarI  h
X   143rI  hX   POSrI  hX   INFORMrI  h]rI  (X   conceptsrI  X   patternsrI  eh]rI  X   al_set_target_bitmaprI  auK}rI  (hX   92rI  h	X   al_get_bitmap_width\n\nrI  hX   ApizarI  h
X   144rI  hX   POSr J  hX   INFORMrJ  hNh]rJ  X   al_get_bitmap_widthrJ  auK}rJ  (hX   92rJ  h	X9   ```int al_get_bitmap_width(ALLEGRO_BITMAP *bitmap)```\n\nrJ  hX   ApizarJ  h
X   146rJ  hX   CONTr	J  hX   INFORMr
J  h]rJ  X   basicrJ  ah]r
J  X   al_get_bitmap_widthrJ  auK}rJ  (hX   92rJ  h	X(   Returns the width of a bitmap in pixels.rJ  hX   ApizarJ  h
X   147rJ  hX   CONTrJ  hX   INFORMrJ  h]rJ  X   basicrJ  ah]rJ  X   al_get_bitmap_widthrJ  auK}rJ  (hX   93rJ  h	X=   Do I need to initialize bitmap before calling al_load_bitmap?rJ  hX
   ProgrammerrJ  h
X   129rJ  hX   FOLrJ  hX
   ELICIT-INFORMr J  h]r!J  X
   directivesr"J  ah]r#J  X   al_load_bitmapr$J  auK}r%J  (hX   94r&J  h	X   I do not think so. r'J  hX   Apizar(J  h
X   149r)J  hX   POSr*J  hX   INFORMr+J  h]r,J  X
   directivesr-J  ah]r.J  X   al_load_bitmapr/J  auK}r0J  (hX   94r1J  h	XS   I found the following example in which al_load_bitmap without al_create_bitmap:\n\nr2J  hX   Apizar3J  h
X   150r4J  hX   CONTr5J  hX   INFORMr6J  h]r7J  X   examplesr8J  ah]r9J  (X   al_load_bitmapr:J  X   al_create_bitmapr;J  euK}r<J  (hX   94r=J  h	Xt   ```\nALLEGRO_BITMAP *image = NULL;\n\n...\n\nal_init_image_addon()\n\n...\n\nimage = al_load_bitmap("image.png");```r>J  hX   Apizar?J  h
X   151r@J  hX   CONTrAJ  hX   INFORMrBJ  h]rCJ  X   examplesrDJ  ah]rEJ  X   al_load_bitmaprFJ  auuuK}rGJ  (hj?>  h}rHJ  (K }rIJ  (hhh	X   Hi ApizarJJ  hX
   ProgrammerrKJ  h
NhNhX   BE-POSITIVErLJ  hNhNuK}rMJ  (hhh	X   I am Programmer_18rNJ  hX
   ProgrammerrOJ  h
NhNhX   INFORMrPJ  hNhNuK}rQJ  (hh+h	X   Hi! rRJ  hX   ApizarSJ  h
hhX   POSrTJ  hX   BE-POSITIVErUJ  hNhNuK}rVJ  (hh+h	XK   I am Apiza, a virtual assistant built to help you navigate the Allegro API.rWJ  hX   ApizarXJ  h
NhNhX   INFORMrYJ  hNhNuK}rZJ  (hh+h	X   How can I help you?r[J  hX   Apizar\J  h
NhNhX   ELICIT-OFFER-OR-SUGGESTIONr]J  hNhNuK}r^J  (hh5h	X   Hi, Programmer_18!r_J  hX   Apizar`J  h
hhX   POSraJ  hX   BE-POSITIVErbJ  hNhNuK}rcJ  (hh<h	X   What is the Allegro API?rdJ  hX
   ProgrammerreJ  h
NhNhX
   ELICIT-INFORMrfJ  h]rgJ  X   conceptsrhJ  ahNuK}riJ  (hhFh	X  Allegro\nAllegro logo\nAllegro logo\nOriginal author(s)\tShawn Hargreaves\nDeveloper(s)\tAllegro developers\nInitial release\tearly 1990; 28 years ago\nStable release\t\n5.2.4 / February 25, 2018; 7 months ago\nRepository\t\n<https://github.com/liballeg/allegro5>\nEdit this at Wikidata\nWritten in\tC\nOperating system\tWindows, Linux, macOS, et al.\nType\tMultimedia and Games SDK\nLicense\tAllegro 4: Beerware[1]\nAllegro 5: zlib\nWebsite\t<http://liballeg.org|liballeg.org>\nrjJ  hX   ApizarkJ  h
hFhX   POSrlJ  hX   OTHERrmJ  h]rnJ  X   conceptsroJ  ahNuK}rpJ  (hhFh	X8   Allegro is a software library for video game developmentrqJ  hX   ApizarrJ  h
hQhX   CONTrsJ  hX   INFORMrtJ  h]ruJ  X   conceptsrvJ  ahNuK	}rwJ  (hhQh	X'   What is the purpose of the Allegro API?rxJ  hX
   ProgrammerryJ  h
hXhX   FOLrzJ  hX
   ELICIT-INFORMr{J  h]r|J  X   purposer}J  ahNuK
}r~J  (hhXh	X8   Allegro is a software library for video game developmentrJ  hX   ApizarJ  h
hchX   POSrJ  hX   INFORMrJ  h]rJ  X   purposerJ  ahNuK}rJ  (hhch	X#   Does Allegro have a physics engine?rJ  hX
   ProgrammerrJ  h
NhNhX
   ELICIT-INFORMrJ  h]rJ  X
   functionalityrJ  ahNuK}rJ  (hX   10rJ  h	X0   Allegro does not have a built-in physics engine.rJ  hX   ApizarJ  h
X   11rJ  hX   POSrJ  hX   INFORMrJ  h]rJ  X
   functionalityrJ  ahNuK
}rJ  (hX   11rJ  h	X   what is ALLEGRO_DISPLAYrJ  hX
   ProgrammerrJ  h
NhNhX
   ELICIT-INFORMrJ  h]rJ  X   basicrJ  ah]rJ  X   ALLEGRO_DISPLAYrJ  auK}rJ  (hX   12rJ  h	X6   ```typedef struct ALLEGRO_DISPLAY ALLEGRO_DISPLAY```\nrJ  hX   ApizarJ  h
X   13rJ  hX   POSrJ  hX   INFORMrJ  h]rJ  X   basicrJ  ah]rJ  X   ALLEGRO_DISPLAYrJ  auK}rJ  (hX   12rJ  h	X6   An opaque type representing an open display or window.rJ  hX   ApizarJ  h
X   14rJ  hX   CONTrJ  hX   INFORMrJ  h]rJ  X   basicrJ  ah]rJ  X   ALLEGRO_DISPLAYrJ  auK}rJ  (hX   13rJ  h	X*   What order are the keys in the keys array?rJ  hX
   ProgrammerrJ  h
NhNhX
   ELICIT-INFORMrJ  h]rJ  X	   structurerJ  ahNuK}rJ  (hX   14rJ  h	X   determined by MYKEYS?rJ  hX
   ProgrammerrJ  h
X   16rJ  hX   CONTrJ  hX
   ELICIT-INFORMrJ  h]rJ  X	   structurerJ  ahNuK}rJ  (hX   15rJ  h	X>   I was able to find an example that may answer your question:\nrJ  hX   ApizarJ  h
X   17rJ  hX   POSrJ  hX   INFORMrJ  h]rJ  X	   structurerJ  ahNuK}rJ  (hX   15rJ  h	XA   ```\nenum MYKEYS {\n KEY_UP, KEY_DOWN, KEY_LEFT, KEY_RIGHT\n};```rJ  hX   ApizarJ  h
X   18rJ  hX   CONTrJ  hX   INFORMrJ  h]rJ  X	   structurerJ  ahNuK}rJ  (hX   16rJ  h	X(   Does Allegro have an event for key pressrJ  hX
   ProgrammerrJ  h
NhNhX
   ELICIT-INFORMrJ  h]rJ  (X
   functionalityrJ  X	   structurerJ  ehNuK}rJ  (hX   17rJ  h	X9   There are three Event types relating to the keyboard:\n\nrJ  hX   ApizarJ  h
X   20rJ  hX   POSrJ  hX   INFORMrJ  h]rJ  X	   structurerJ  ahNuK}rJ  (hX   17rJ  h	X   ALLEGRO_EVENT_KEY_DOWN\nALLEGRO_EVENT_KEY_UP\nALLEGRO_EVENT_KEY_CHAR\n\nThey share the attributes\n\n\nstruct ALLEGRO_DISPLAY *display\nint keycode\nint unichar\nunsigned int modifiers\nbool repeatrJ  hX   ApizarJ  h
X   21rJ  hX   CONTrJ  hX   INFORMrJ  h]rJ  X	   structurerJ  ah]rJ  (X   ALLEGRO_EVENT_KEY_DOWNrJ  X   ALLEGRO_EVENT_KEY_UPrJ  X   ALLEGRO_EVENT_KEY_CHARrJ  euK}rJ  (hX   18rJ  h	X%   How do I register for KEY_DOWN eventsrJ  hX
   ProgrammerrJ  h
NhNhX   ELICIT-OFFER-OR-SUGGESTIONrJ  h]rJ  X   patternsrJ  ah]rJ  X   ALLEGRO_EVENT_KEY_DOWNrJ  auK}rJ  (hX   19rJ  h	X&   How do I register for keyboard events?rJ  hX
   ProgrammerrJ  h
X   23r K  hX   REPrK  hX   ELICIT-OFFER-OR-SUGGESTIONrK  h]rK  X   patternsrK  ahNuK}rK  (hX   20rK  h	X   Once the keyboard has been installed with al_install_keyboard, the keyboard can be registered as an event source with\n\n```al_register_event_source(event_queue, al_get_keyboard_event_source());```rK  hX   ApizarK  h
X   24r	K  hX   POSr
K  hX   SUGGESTrK  h]rK  (X   patternsr
K  X   basicrK  eh]rK  X   al_register_event_sourcerK  auK}rK  (hX   21rK  h	X&   can more then one key be down at once?rK  hX
   ProgrammerrK  h
X   25rK  hX   FOLrK  hX
   ELICIT-INFORMrK  h]rK  X
   functionalityrK  ah]rK  X   ALLEGRO_EVENT_KEY_DOWNrK  auK}rK  (hX   22rK  h	X   Using the ALLEGRO_EVENT_QUEUE struct, multiple keys can be down at once. Every key press will add a new ALLEGRO_EVENT to the ALLEGRO_EVENT_QUEUE, even if other keys are being held.rK  hX   ApizarK  h
X   26r K  hX   POSr!K  hX   INFORMr"K  h]r#K  (X
   functionalityr$K  X   controlr%K  eh]r&K  (X   ALLEGRO_EVENT_QUEUEr'K  X
   ALLEGRO_EVENTr(K  euK}r)K  (hX   23r*K  h	X   FALSEr+K  hX
   Programmerr,K  h
X   27r-K  hX   NEGr.K  hX   ASSESSr/K  h]r0K  X
   functionalityr1K  ahNuK}r2K  (hX   24r3K  h	XG   keybdnu.c:190: al_get_keyboard: Assertion `new_keyboard_driver' failed.r4K  hX
   Programmerr5K  h
X   28r6K  hX   CONTr7K  hX   INFORMr8K  h]r9K  X
   functionalityr:K  ahNuK}r;K  (hX   25r<K  h	XQ   Keyboard errors may emerge if the keyboard driver is not successfully installed. r=K  hX   Apizar>K  h
X   29r?K  hX   POSr@K  hX   INFORMrAK  h]rBK  X
   functionalityrCK  ahNuK}rDK  (hX   25rEK  h	X\   You can call al_is_keyboard_installed to confirm that the driver has installed properly:\n\nrFK  hX   ApizarGK  h
X   30rHK  hX   CONTrIK  hX   SUGGESTrJK  h]rKK  X   patternsrLK  ah]rMK  X   al_is_keyboard_installedrNK  auK }rOK  (hX   25rPK  h	X)   ```bool al_is_keyboard_installed(void)```rQK  hX   ApizarRK  h
X   31rSK  hX   CONTrTK  hX   INFORMrUK  h]rVK  X   basicrWK  ah]rXK  X   al_is_keyboard_installedrYK  auK!}rZK  (hX   26r[K  h	X   How do I install the keyboard?r\K  hX
   Programmerr]K  h
X   30r^K  hX   FOLr_K  hX   ELICIT-OFFER-OR-SUGGESTIONr`K  h]raK  X   patternsrbK  ahNuK"}rcK  (hX   27rdK  h	X(   ```bool al_install_keyboard(void)```\n\nreK  hX   ApizarfK  h
X   33rgK  hX   POSrhK  hX   INFORMriK  h]rjK  X   basicrkK  ah]rlK  X   al_install_keyboardrmK  auK#}rnK  (hX   27roK  h	X   Install a keyboard driver. rpK  hX   ApizarqK  h
X   34rrK  hX   CONTrsK  hX   INFORMrtK  h]ruK  X   basicrvK  ah]rwK  X   al_install_keyboardrxK  auK$}ryK  (hX   27rzK  h	Xd   Returns true if successful. If a driver was already installed, nothing happens and true is returned.r{K  hX   Apizar|K  h
X   35r}K  hX   CONTr~K  hX   INFORMrK  h]rK  X
   functionalityrK  ah]rK  X   al_install_keyboardrK  auK%}rK  (hX   28rK  h	X   How do I add sound effects?rK  hX
   ProgrammerrK  h
NhNhX   ELICIT-OFFER-OR-SUGGESTIONrK  h]rK  X   patternsrK  ahNuK&}rK  (hX   29rK  h	X   How do I play sound files?rK  hX
   ProgrammerrK  h
X   37rK  hX   REPrK  hX   ELICIT-OFFER-OR-SUGGESTIONrK  h]rK  X   patternsrK  ahNuK'}rK  (hX   30rK  h	XM   To play sound, the audio add-on and audio codec add-on must be installed.\n\nrK  hX   ApizarK  h
X   38rK  hX   POSrK  hX   SUGGESTrK  h]rK  X
   directivesrK  ahNuK(}rK  (hX   30rK  h	X#   ```bool al_install_audio(void)```\nrK  hX   ApizarK  h
X   39rK  hX   CONTrK  hX   INFORMrK  h]rK  X   basicrK  ah]rK  X   al_install_audiorK  auK)}rK  (hX   30rK  h	X)   ```bool al_init_acodec_addon(void)```\n\nrK  hX   ApizarK  h
X   40rK  hX   CONTrK  hX   INFORMrK  h]rK  X   basicrK  ah]rK  X   al_init_acodec_addonrK  auK*}rK  (hX   30rK  h	X3   There are several functions to play audio samples. rK  hX   ApizarK  h
X   41rK  hX   CONTrK  hX   INFORMrK  hNhNuK+}rK  (hX   30rK  h	X&    The simplest is al_play_sample\n:\n\nrK  hX   ApizarK  h
X   42rK  hX   CONTrK  hX   SUGGESTrK  h]rK  X   patternsrK  ah]rK  X   al_play_samplerK  auK,}rK  (hX   30rK  h	X   ```bool al_play_sample(ALLEGRO_SAMPLE *spl, float gain, float pan, float speed,\n ALLEGRO_PLAYMODE loop, ALLEGRO_SAMPLE_ID *ret_id)```\n\nrK  hX   ApizarK  h
X   43rK  hX   CONTrK  hX   INFORMrK  h]rK  X   basicrK  ah]rK  X   al_play_samplerK  auK-}rK  (hX   30rK  h	X8   An ALLEGRO_SAMPLE must first be reserved and loaded.\n\nrK  hX   ApizarK  h
X   44rK  hX   CONTrK  hX   SUGGESTrK  h]rK  X
   directivesrK  ah]rK  X   al_play_samplerK  auK.}rK  (hX   30rK  h	X4   ```bool al_reserve_samples(int reserve_samples)```\nrK  hX   ApizarK  h
X   45rK  hX   CONTrK  hX   INFORMrK  h]rK  X   basicrK  ah]rK  X   al_reserve_samplesrK  auK/}rK  (hX   30rK  h	X:   ```ALLEGRO_SAMPLE *al_load_sample(const char *filename)```rK  hX   ApizarK  h
X   46rK  hX   CONTrK  hX   INFORMrK  h]rK  X   basicrK  ah]rK  X   al_load_samplerK  auK0}rK  (hX   31rK  h	X%   what is the parameter reserve_samplesrK  hX
   ProgrammerrK  h
X   46rK  hX   FOLrK  hX
   ELICIT-INFORMrK  h]rK  X   conceptsrK  ah]rK  X   al_reserve_samplesrK  auK1}rK  (hX   32rK  h	Xo   int reserve_samples - refers to the number of sample instances to be reserved and attached to the default mixerrK  hX   ApizarK  h
X   48r L  hX   POSrL  hX   INFORMrL  h]rL  X   conceptsrL  ah]rL  X   al_reserve_samplesrL  auK2}rL  (hX   33rL  h	X2   what are the valid gain values for al_play_sample?r	L  hX
   Programmerr
L  h
X   44rL  hX   FOLrL  hX
   ELICIT-INFORMr
L  h]rL  X
   directivesrL  ah]rL  X   al_play_samplerL  auK3}rL  (hX   34rL  h	X'   I need documentation for al_play_samplerL  hX
   ProgrammerrL  h
NhNhX
   ELICIT-INFORMrL  h]rL  X   basicrL  ah]rL  X   al_play_samplerL  auK4}rL  (hX   35rL  h	XU   gain - relative volume at which the sample is played; 1.0 is normal.\ngain is a floatrL  hX   ApizarL  h
X   50rL  hX   POSr L  hX   INFORMr!L  h]r"L  (X   conceptsr#L  X   basicr$L  eh]r%L  X   al_play_sampler&L  auK5}r'L  (hX   36r(L  h	X#   Sure, here's the documentation:\n\nr)L  hX   Apizar*L  h
X   51r+L  hX   POSr,L  hX   INFORMr-L  hNhNuK6}r.L  (hX   36r/L  h	X   al_play_sample\n\nr0L  hX   Apizar1L  h
X   53r2L  hX   CONTr3L  hX   OTHERr4L  hNh]r5L  X   al_play_sampler6L  auK7}r7L  (hX   36r8L  h	X   ```bool al_play_sample(ALLEGRO_SAMPLE *spl, float gain, float pan, float speed,\n ALLEGRO_PLAYMODE loop, ALLEGRO_SAMPLE_ID *ret_id)```\n\nr9L  hX   Apizar:L  h
X   54r;L  hX   CONTr<L  hX   INFORMr=L  h]r>L  X   basicr?L  ah]r@L  X   al_play_samplerAL  auK8}rBL  (hX   36rCL  h	XM   Plays a sample on one of the sample instances created by al_reserve_samples. rDL  hX   ApizarEL  h
X   55rFL  hX   CONTrGL  hX   INFORMrHL  h]rIL  (X
   functionalityrJL  X   patternsrKL  eh]rLL  X   al_play_samplerML  auK9}rNL  (hX   36rOL  h	X+   Returns true on success, false on failure. rPL  hX   ApizarQL  h
X   56rRL  hX   CONTrSL  hX   INFORMrTL  h]rUL  X
   functionalityrVL  ah]rWL  X   al_play_samplerXL  auK:}rYL  (hX   36rZL  h	XS   Playback may fail because all the reserved sample instances are currently used.\n\nr[L  hX   Apizar\L  h
X   57r]L  hX   CONTr^L  hX   INFORMr_L  h]r`L  X
   functionalityraL  ah]rbL  X   al_play_samplercL  auK;}rdL  (hX   36reL  h	X.  Parameters:\n\ngain - relative volume at which the sample is played; 1.0 is normal.\npan - 0.0 is centred, -1.0 is left, 1.0 is right, or ALLEGRO_AUDIO_PAN_NONE.\nspeed - relative speed at which the sample is played; 1.0 is normal.\nloop - ALLEGRO_PLAYMODE_ONCE, ALLEGRO_PLAYMODE_LOOP, or ALLEGRO_PLAYMODE_BIDIR\nret_id - if non-NULL the variable which this points to will be assigned an id representing the sample being played. If al_play_sample returns false, then the contents of ret_id are invalid and must not be used as argument to other functions.\n\nrfL  hX   ApizargL  h
X   58rhL  hX   CONTriL  hX   INFORMrjL  h]rkL  (X
   functionalityrlL  X
   directivesrmL  X   conceptsrnL  eh]roL  X   al_play_samplerpL  auK<}rqL  (hX   36rrL  h	Xz   See also: ALLEGRO_PLAYMODE, ALLEGRO_AUDIO_PAN_NONE, ALLEGRO_SAMPLE_ID, al_stop_sample, al_stop_samples, al_lock_sample_id.rsL  hX   ApizartL  h
X   59ruL  hX   CONTrvL  hX   INFORMrwL  h]rxL  X	   structureryL  ah]rzL  X   al_play_sampler{L  auK=}r|L  (hX   37r}L  h	X!   How do I draw text on the displayr~L  hX
   ProgrammerrL  h
NhNhX   ELICIT-OFFER-OR-SUGGESTIONrL  h]rL  X   patternsrL  ahNuK>}rL  (hX   38rL  h	X%   I need documentation for al_draw_textrL  hX
   ProgrammerrL  h
NhNhX
   ELICIT-INFORMrL  h]rL  X   basicrL  ah]rL  X   al_draw_textrL  auK?}rL  (hX   39rL  h	X7   Three are several methods to Draw text on the display. rL  hX   ApizarL  h
X   61rL  hX   POSrL  hX   INFORMrL  h]rL  X   patternsrL  ahNuK@}rL  (hX   39rL  h	X   The simplest is\n\n```void al_draw_text(const ALLEGRO_FONT *font,\n ALLEGRO_COLOR color, float x, float y, int flags,\n char const *text) ```\n\nrL  hX   ApizarL  h
X   63rL  hX   CONTrL  hX   SUGGESTrL  h]rL  (X   patternsrL  X   basicrL  eh]rL  X   al_draw_textrL  auKA}rL  (hX   39rL  h	X.   The font add-on must first be initialized.\n\nrL  hX   ApizarL  h
X   64rL  hX   FOLrL  hX   SUGGESTrL  h]rL  X
   directivesrL  ahNuKB}rL  (hX   39rL  h	X'   ```bool al_init_font_addon(void)```\n\nrL  hX   ApizarL  h
X   65rL  hX   CONTrL  hX   INFORMrL  h]rL  X   basicrL  ah]rL  X   al_init_font_addonrL  auKC}rL  (hX   39rL  h	Xx   An ALLEGRO_FONT struct can be loaded with\n\n```ALLEGRO_FONT *al_load_font(char const *filename, int size, int flags)```rL  hX   ApizarL  h
X   66rL  hX   FOLrL  hX   INFORMrL  h]rL  (X   patternsrL  X   basicrL  eh]rL  (X   ALLEGRO_FONTrL  X   al_init_font_addonrL  euKD}rL  (hX   40rL  h	X   Sure,rL  hX   ApizarL  h
X   62rL  hX   POSrL  hX   ASSESSrL  hNhNuKE}rL  (hX   40rL  h	X   here it is:\n\nrL  hX   ApizarL  h
X   68rL  hX   CONTrL  hX   INFORMrL  hNhNuKF}rL  (hX   40rL  h	X   al_draw_text\n\nrL  hX   ApizarL  h
X   69rL  hX   CONTrL  hX   OTHERrL  hNh]rL  X   al_draw_textrL  auKG}rL  (hX   40rL  h	X   ```\nvoid al_draw_text(const ALLEGRO_FONT *font,\n ALLEGRO_COLOR color, float x, float y, int flags,\n char const *text) ```\n\nrL  hX   ApizarL  h
X   70rL  hX   CONTrL  hX   INFORMrL  h]rL  X   basicrL  ah]rL  X   al_draw_textrL  auKH}rL  (hX   40rL  h	Xl   Writes the NUL-terminated string text onto the target bitmap at position x, y, using the specified font.\n\nrL  hX   ApizarL  h
X   71rL  hX   CONTrL  hX   INFORMrL  h]rL  X
   functionalityrL  ah]rL  X   al_draw_textrL  auKI}rL  (hX   40rL  h	X  The flags parameter can be 0 or one of the following flags:\n\nALLEGRO_ALIGN_LEFT - Draw the text left-aligned (same as 0).\nALLEGRO_ALIGN_CENTRE - Draw the text centered around the given position.\nALLEGRO_ALIGN_RIGHT - Draw the text right-aligned to the given position.\nIt can also be combined with this flag:\n\nALLEGRO_ALIGN_INTEGER - Always draw text aligned to an integer pixel position. This was formerly the default behaviour. Since: 5.0.8, 5.1.4\nrL  hX   ApizarL  h
X   72rL  hX   CONTrL  hX   INFORMrL  h]rL  (X
   directivesrL  X   patternsrL  X   environmentrL  eh]rL  X   al_draw_textrL  auKJ}rL  (hX   40rL  h	X   This function does not support newline characters (\\n), but you can use al_draw_multiline_text for multi line text output.\n\nrL  hX   ApizarL  h
X   73r M  hX   CONTrM  hX   INFORMrM  h]rM  (X
   functionalityrM  X   patternsrM  eh]rM  X   al_draw_textrM  auKK}rM  (hX   40r	M  h	XV   See also: al_draw_ustr, al_draw_textf, al_draw_justified_text, al_draw_multiline_text.r
M  hX   ApizarM  h
X   74rM  hX   CONTr
M  hX   INFORMrM  h]rM  X	   structurerM  ah]rM  X   al_draw_textrM  auKL}rM  (hX   41rM  h	X   define ALLEGRO_COLORrM  hX
   ProgrammerrM  h
X   71rM  hX   FOLrM  hX
   ELICIT-INFORMrM  h]rM  X   basicrM  ah]rM  X
   ALLEGRO_COLORrM  auKM}rM  (hX   42rM  h	X/   typedef struct ALLEGRO_COLOR ALLEGRO_COLOR;\n\nr M  hX   Apizar!M  h
X   76r"M  hX   POSr#M  hX   INFORMr$M  h]r%M  X   basicr&M  ah]r'M  X
   ALLEGRO_COLORr(M  auKN}r)M  (hX   42r*M  h	XJ   An ALLEGRO_COLOR structure describes a color in a device independent way. r+M  hX   Apizar,M  h
X   77r-M  hX   CONTr.M  hX   INFORMr/M  h]r0M  X   purposer1M  ah]r2M  X
   ALLEGRO_COLORr3M  auKO}r4M  (hX   42r5M  h	Xe   Use al_map_rgb et al. and al_unmap_rgb et al. to translate from and to various color representations.r6M  hX   Apizar7M  h
X   78r8M  hX   CONTr9M  hX   INFORMr:M  h]r;M  X   patternsr<M  ah]r=M  (X
   ALLEGRO_COLORr>M  X
   al_map_rgbr?M  X   al_unmap_rgbr@M  euKP}rAM  (hX   43rBM  h	X(   what are the parameters for al_load_fontrCM  hX
   ProgrammerrDM  h
X   67rEM  hX   FOLrFM  hX
   ELICIT-INFORMrGM  h]rHM  X   basicrIM  ah]rJM  X   al_load_fontrKM  auKQ}rLM  (hX   44rMM  h	XO   ```ALLEGRO_FONT *al_load_font(char const *filename, int size, int flags)```\n\nrNM  hX   ApizarOM  h
X   80rPM  hX   POSrQM  hX   INFORMrRM  h]rSM  X   basicrTM  ah]rUM  X   al_load_fontrVM  auKR}rWM  (hX   44rXM  h	XY  The flags can be 0 or\n\nALLEGRO_TTF_NO_KERNING - Do not use any kerning even if the font file supports it.\n\nALLEGRO_TTF_MONOCHROME - Load as a monochrome font (which means no anti-aliasing of the font is done).\n\nALLEGRO_TTF_NO_AUTOHINT - Disable the Auto Hinter which is enabled by default in newer versions of FreeType. Since: 5.0.6, 5.1.2rYM  hX   ApizarZM  h
X   81r[M  hX   CONTr\M  hX   INFORMr]M  h]r^M  (X
   functionalityr_M  X
   directivesr`M  X   environmentraM  eh]rbM  X   al_load_fontrcM  auKS}rdM  (hX   45reM  h	X*   what is the x y orientation of the displayrfM  hX
   ProgrammerrgM  h
X   71rhM  hX   FOLriM  hX
   ELICIT-INFORMrjM  h]rkM  X   conceptsrlM  ah]rmM  X   al_draw_textrnM  auuuK}roM  (hj?>  h}rpM  (K }rqM  (hhh	X   allegro keyboard inputrrM  hX
   ProgrammerrsM  h
NhNhX
   ELICIT-INFORMrtM  h]ruM  X   patternsrvM  ahNuK}rwM  (hhh	X   You can save the state of the keyboard specified at the time the function is called into the structure pointed to by ret_state, using al_get_keyboard_staterxM  hX   ApizaryM  h
hhX   POSrzM  hX   SUGGESTr{M  h]r|M  X   patternsr}M  ah]r~M  X   al_get_keyboard_staterM  auK}rM  (hh+h	X6   Whats the function signature for al_get_keyboard_staterM  hX
   ProgrammerrM  h
hhX   FOLrM  hX
   ELICIT-INFORMrM  h]rM  X   basicrM  ah]rM  X   al_get_keyboard_staterM  auK}rM  (hh5h	X=   void al_get_keyboard_state(ALLEGRO_KEYBOARD_STATE *ret_state)rM  hX   ApizarM  h
hhX   POSrM  hX   INFORMrM  h]rM  X   basicrM  ah]rM  X   al_get_keyboard_staterM  auK}rM  (hh<h	X(   Documentation for ALLEGRO_KEYBOARD_STATErM  hX
   ProgrammerrM  h
h+hX   FOLrM  hX
   ELICIT-INFORMrM  h]rM  X   basicrM  ah]rM  X   ALLEGRO_KEYBOARD_STATErM  auK}rM  (hhFh	Xw   ALLEGRO_KEYBOARD_STATE is a structure that is used to hold a "snapshot" of a keyboard\'s state at a particular instant.rM  hX   ApizarM  h
h5hX   POSrM  hX   INFORMrM  h]rM  (X   basicrM  X   conceptsrM  eh]rM  X   ALLEGRO_KEYBOARD_STATErM  auK}rM  (hhFh	X   It contains the following publicly readable fields: display - points to the display that had keyboard focus at the time the state was saved. If no display was focused, this points to NULL.rM  hX   ApizarM  h
h<hX   CONTrM  hX   INFORMrM  h]rM  (X	   structurerM  X   conceptsrM  eh]rM  X   ALLEGRO_KEYBOARD_STATErM  auK}rM  (hhQh	X>   al_get_keyboard_state: Assertion `new_keyboard_driver' failed.rM  hX
   ProgrammerrM  h
NhNhX   INFORMrM  h]rM  X
   functionalityrM  ah]rM  X   al_get_keyboard_staterM  auK}rM  (hhXh	X5   To install a keyboard driver, use al_install_keyboardrM  hX   ApizarM  h
hQhX   POSrM  hX   SUGGESTrM  h]rM  X   patternsrM  ah]rM  X   al_install_keyboardrM  auK	}rM  (hhch	X*   function signature for al_install_keyboardrM  hX
   ProgrammerrM  h
hXhX   FOLrM  hX
   ELICIT-INFORMrM  h]rM  X   basicrM  ah]rM  X   al_install_keyboardrM  auK
}rM  (hX   10rM  h	X   bool al_install_keyboard(void)rM  hX   ApizarM  h
hchX   POSrM  hX   INFORMrM  h]rM  X   basicrM  ah]rM  X   al_install_keyboardrM  auK}rM  (hX   11rM  h	XB   Allegro error al_get_keyboard_state: Assertion `ret_state' failed.rM  hX
   ProgrammerrM  h
NhNhX   INFORMrM  h]rM  X
   functionalityrM  ah]rM  X   al_get_keyboard_staterM  auK}rM  (hX   12rM  h	X'   I'm not sure I understand your questionrM  hX   ApizarM  h
X   11rM  hX   UNCrM  hX   COMMENT-ABOUT-UNDERSTANDINGrM  hNhNuK
}rM  (hX   13rM  h	X   al_get_keyboard_state assertionrM  hX
   ProgrammerrM  h
X   12rM  hX   FOLrM  hX
   ELICIT-INFORMrM  h]rM  X
   functionalityrM  ah]rM  X   al_get_keyboard_staterM  auK}rM  (hX   14rM  h	X   You can save the state of the keyboard specified at the time the function is called into the structure pointed to by ret_state, using al_get_keyboard_staterM  hX   ApizarM  h
X   13rM  hX   PARTrM  hX   SUGGESTrM  h]rM  X   patternsrM  ah]rM  X   al_get_keyboard_staterM  auK}rM  (hX   15rM  h	X5   Why does al_get_keyboard_state() fail with assertion?rM  hX
   ProgrammerrM  h
X   14rM  hX   FOLrM  hX
   ELICIT-INFORMrM  h]r N  X
   functionalityrN  ah]rN  X   al_get_keyboard_staterN  auK}rN  (hX   16rN  h	X'   I'm not sure I understand your questionrN  hX   ApizarN  h
X   15rN  hX   UNCr	N  hX   COMMENT-ABOUT-UNDERSTANDINGr
N  hNhNuK}rN  (hX   17rN  h	XH   Would you like me to send you the source code for al_get_keyboard_state?r
N  hX   ApizarN  h
X   16rN  hX   FOLrN  hX   OFFERrN  h]rN  X   basicrN  ah]rN  X   al_get_keyboard_staterN  auK}rN  (hX   18rN  h	X   YesrN  hX
   ProgrammerrN  h
X   17rN  hX   POSrN  hX   ASSESSrN  hNhNuK}rN  (hX   19rN  h	X   void al_get_keyboard_state(ALLEGRO_KEYBOARD_STATE *ret_state)\n{\n ASSERT(new_keyboard_driver);\n ASSERT(ret_state);\n\n new_keyboard_driver-&gt;get_keyboard_state(ret_state);\n}rN  hX   Apizar N  h
X   18r!N  hX   POSr"N  hX   INFORMr#N  h]r$N  X   basicr%N  ah]r&N  X   al_get_keyboard_stater'N  auK}r(N  (hX   20r)N  h	X   Allegro sound functionsr*N  hX
   Programmerr+N  h
NhNhX
   ELICIT-INFORMr,N  h]r-N  X	   structurer.N  ahNuK}r/N  (hX   21r0N  h	XJ   Could you be more specific as to what audio function you're interested in?r1N  hX   Apizar2N  h
X   20r3N  hX   FOLr4N  hX
   ELICIT-INFORMr5N  h]r6N  X   patternsr7N  ahNuK}r8N  (hX   22r9N  h	X   Allegro play soundr:N  hX
   Programmerr;N  h
X   21r<N  hX   POSr=N  hX   ELICIT-OFFER-OR-SUGGESTIONr>N  h]r?N  X   patternsr@N  ahNuK}rAN  (hX   23rBN  h	X   Play a sound effect in allegrorCN  hX
   ProgrammerrDN  h
X   22rEN  hX   REPrFN  hX   ELICIT-OFFER-OR-SUGGESTIONrGN  h]rHN  X   patternsrIN  ahNuK}rJN  (hX   24rKN  h	X*   Use al_install_audio to initialize sound. rLN  hX   ApizarMN  h
X   22rNN  hX   POSrON  hX   INFORMrPN  h]rQN  X   patternsrRN  ah]rSN  X   al_install_audiorTN  auK}rUN  (hX   24rVN  h	Xc   To load any sample formats, you will need to initialise the acodec addon with al_init_acodec_addon.rWN  hX   ApizarXN  h
X   24rYN  hX   FOLrZN  hX   SUGGESTr[N  h]r\N  X
   directivesr]N  ah]r^N  X   al_init_acodec_addonr_N  auK}r`N  (hX   25raN  h	X'   function signature for al_install_audiorbN  hX
   ProgrammerrcN  h
X   24rdN  hX   FOLreN  hX
   ELICIT-INFORMrfN  h]rgN  X   basicrhN  ah]riN  X   al_install_audiorjN  auK}rkN  (hX   26rlN  h	X   bool al_install_audio(void)rmN  hX   ApizarnN  h
X   26roN  hX   POSrpN  hX   INFORMrqN  h]rrN  X   basicrsN  ah]rtN  X   al_install_audioruN  auK}rvN  (hX   27rwN  h	X+   function signature for al_init_acodec_addonrxN  hX
   ProgrammerryN  h
X   25rzN  hX   FOLr{N  hX
   ELICIT-INFORMr|N  h]r}N  X   basicr~N  ah]rN  X   al_init_acodec_addonrN  auK}rN  (hX   28rN  h	X   bool al_init_acodec_addon(void)rN  hX   ApizarN  h
X   28rN  hX   POSrN  hX   INFORMrN  h]rN  X   basicrN  ah]rN  X   al_init_acodec_addonrN  auK}rN  (hX   29rN  h	X+   How do you load an audio sample in Allegro?rN  hX
   ProgrammerrN  h
NhNhX   ELICIT-OFFER-OR-SUGGESTIONrN  h]rN  X   patternsrN  ahNuK}rN  (hX   30rN  h	X   al_load_sample loads a few different audio file formats based on their extension.\nNote that this stores the entire file in memory at once, which may be time consuming. To read the file as it is needed, use al_load_audio_stream.\nrN  hX   ApizarN  h
X   30rN  hX   POSrN  hX   INFORMrN  h]rN  (X
   functionalityrN  X   qualityrN  X   patternsrN  eh]rN  X   al_load_samplerN  auK }rN  (hX   30rN  h	X/   Returns the sample on success, NULL on failure.rN  hX   ApizarN  h
X   31rN  hX   CONTrN  hX   INFORMrN  h]rN  X
   functionalityrN  ah]rN  X   al_load_samplerN  auK!}rN  (hX   31rN  h	X'   Function signature for al_load_sample()rN  hX
   ProgrammerrN  h
X   31rN  hX   FOLrN  hX
   ELICIT-INFORMrN  h]rN  X   basicrN  ah]rN  X   al_load_samplerN  auK"}rN  (hX   32rN  h	X4   ALLEGRO_SAMPLE *al_load_sample(const char *filename)rN  hX   ApizarN  h
X   33rN  hX   POSrN  hX   INFORMrN  h]rN  X   basicrN  ah]rN  X   al_load_samplerN  auK#}rN  (hX   33rN  h	X'   Function signature for al_play_sample()rN  hX
   ProgrammerrN  h
NhNhX
   ELICIT-INFORMrN  h]rN  X   basicrN  ah]rN  X   al_play_samplerN  auK$}rN  (hX   34rN  h	X   bool al_play_sample(ALLEGRO_SAMPLE *spl, float gain, float pan, float speed,\n ALLEGRO_PLAYMODE loop, ALLEGRO_SAMPLE_ID *ret_id)rN  hX   ApizarN  h
X   35rN  hX   POSrN  hX   INFORMrN  h]rN  X   basicrN  ah]rN  X   al_play_samplerN  auK%}rN  (hX   35rN  h	X   What is ALLEGRO_SAMPLE_IDrN  hX
   ProgrammerrN  h
X   36rN  hX   FOLrN  hX
   ELICIT-INFORMrN  h]rN  X   conceptsrN  ah]rN  (X   ALLEGRO_SAMPLE_IDrN  X   al_play_samplerN  euK&}rN  (hX   36rN  h	X   An ALLEGRO_SAMPLE_ID represents a sample being played via al_play_sample. It can be used to later stop the sample with al_stop_sample. The underlying ALLEGRO_SAMPLE_INSTANCE can be extracted using al_lock_sample_id.rN  hX   ApizarN  h
X   37rN  hX   POSrN  hX   INFORMrN  h]rN  (X   conceptsrN  X   patternsrN  eh]rN  (X   ALLEGRO_SAMPLE_IDrN  X   al_play_samplerN  euK'}rN  (hX   37rN  h	X   What is ALLEGRO_PLAYMODE ?rN  hX
   ProgrammerrN  h
X   36rN  hX   FOLrN  hX
   ELICIT-INFORMrN  h]rN  X   conceptsrN  ah]rN  X   ALLEGRO_PLAYMODErN  auK(}rN  (hX   38rN  h	X   ALLEGRO_PLAYMODE is an enum.rN  hX   ApizarN  h
X   39rN  hX   POSrN  hX   INFORMrN  h]r O  X   basicrO  ah]rO  X   ALLEGRO_PLAYMODErO  auK)}rO  (hX   39rO  h	X   Enumerate ALLEGRO_PLAYMODErO  hX
   ProgrammerrO  h
X   40rO  hX   FOLr	O  hX
   ELICIT-INFORMr
O  h]rO  X	   structurerO  ah]r
O  X   ALLEGRO_PLAYMODErO  auK*}rO  (hX   40rO  h	X    Sample and stream playback mode.rO  hX   ApizarO  h
X   41rO  hX   POSrO  hX   INFORMrO  h]rO  X   conceptsrO  ah]rO  X   ALLEGRO_PLAYMODErO  auK+}rO  (hX   40rO  h	XD   ALLEGRO_PLAYMODE_ONCE, ALLEGRO_PLAYMODE_LOOP, ALLEGRO_PLAYMODE_BIDIRrO  hX   ApizarO  h
X   42rO  hX   CONTrO  hX   INFORMr O  h]r!O  X	   structurer"O  ah]r#O  X   ALLEGRO_PLAYMODEr$O  auK,}r%O  (hX   41r&O  h	X(   Why is al_play_sample() returning false?r'O  hX
   Programmerr(O  h
NhNhX
   ELICIT-INFORMr)O  h]r*O  X
   functionalityr+O  ah]r,O  X   al_play_sampler-O  auK-}r.O  (hX   42r/O  h	X\   al_play_sample plays a sample on one of the sample instances created by al_reserve_samples. r0O  hX   Apizar1O  h
X   44r2O  hX   POSr3O  hX   INFORMr4O  h]r5O  (X
   functionalityr6O  X   patternsr7O  eh]r8O  X   al_play_sampler9O  auK.}r:O  (hX   42r;O  h	X+   Returns true on success, false on failure. r<O  hX   Apizar=O  h
X   45r>O  hX   CONTr?O  hX   INFORMr@O  h]rAO  (X
   functionalityrBO  X   patternsrCO  eh]rDO  X   al_play_samplerEO  auK/}rFO  (hX   42rGO  h	XO   Playback may fail because all the reserved sample instances are currently used.rHO  hX   ApizarIO  h
X   46rJO  hX   CONTrKO  hX   INFORMrLO  h]rMO  X
   functionalityrNO  ah]rOO  X   al_play_samplerPO  auK0}rQO  (hX   43rRO  h	X+   function signature for al_reserve_samples()rSO  hX
   ProgrammerrTO  h
X   45rUO  hX   FOLrVO  hX
   ELICIT-INFORMrWO  h]rXO  X   basicrYO  ah]rZO  X   al_reserve_samplesr[O  auK1}r\O  (hX   44r]O  h	X,   bool al_reserve_samples(int reserve_samples)r^O  hX   Apizar_O  h
X   48r`O  hX   POSraO  hX   INFORMrbO  h]rcO  X   basicrdO  ah]reO  X   al_reserve_samplesrfO  auK2}rgO  (hX   45rhO  h	X0   What are the allegro functions for drawing text?riO  hX
   ProgrammerrjO  h
NhNhX
   ELICIT-INFORMrkO  h]rlO  X	   structurermO  ahNuK3}rnO  (hX   46roO  h	X  Drawing operations:\n\t\tal_clear_to_color\n\t\tal_clear_depth_buffer\n\t\tal_draw_bitmap\n\t\tal_draw_tinted_bitmap\n\t\tal_draw_bitmap_region\n\t\tal_draw_tinted_bitmap_region\n\t\tal_draw_pixel\n\t\tal_draw_rotated_bitmap\n\t\tal_draw_tinted_rotated_bitmap\n\t\tal_draw_scaled_rotated_bitmap\n\t\tal_draw_tinted_scaled_rotated_bitmap\n\t\tal_draw_tinted_scaled_rotated_bitmap_region\n\t\tal_draw_scaled_bitmap\n\t\tal_draw_tinted_scaled_bitmap\n\t\tal_get_target_bitmap\n\t\tal_put_pixel\n\t\tal_put_blended_pixelrpO  hX   ApizarqO  h
X   50rrO  hX   POSrsO  hX   INFORMrtO  h]ruO  X	   structurervO  ahNuK4}rwO  (hX   47rxO  h	X9   Would you like to know more about one of those functions?ryO  hX   ApizarzO  h
X   51r{O  hX   FOLr|O  hX
   ELICIT-INFORMr}O  h]r~O  X   basicrO  ahNuK5}rO  (hX   48rO  h	X   Allegro font functionsrO  hX
   ProgrammerrO  h
NhNhX
   ELICIT-INFORMrO  h]rO  X	   structurerO  ahNuK6}rO  (hX   49rO  h	X'   I'm not sure I understand your questionrO  hX   ApizarO  h
X   53rO  hX   UNCrO  hX   COMMENT-ABOUT-UNDERSTANDINGrO  hNhNuK7}rO  (hX   50rO  h	X"   How do you load a font in allegro?rO  hX
   ProgrammerrO  h
X   54rO  hX   FOLrO  hX   ELICIT-OFFER-OR-SUGGESTIONrO  h]rO  X   patternsrO  ahNuK8}rO  (hX   51rO  h	X=  al_load_font loads a font from disk. This will use al_load_bitmap_font_flags if you pass the name of a known bitmap format, or else al_load_ttf_font.\nThe flags parameter is passed through to either of those functions. Bitmap and TTF fonts are also affected by the current bitmap flags at the time the font is loaded.rO  hX   ApizarO  h
X   55rO  hX   POSrO  hX   INFORMrO  h]rO  (X
   functionalityrO  X   controlrO  X   patternsrO  eh]rO  X   al_load_fontrO  auK9}rO  (hX   52rO  h	X#   function signature for al_load_fontrO  hX
   ProgrammerrO  h
X   56rO  hX   FOLrO  hX
   ELICIT-INFORMrO  h]rO  X   basicrO  ah]rO  X   al_load_fontrO  auK:}rO  (hX   53rO  h	XE   ALLEGRO_FONT *al_load_font(char const *filename, int size, int flags)rO  hX   ApizarO  h
X   57rO  hX   POSrO  hX   INFORMrO  h]rO  X   basicrO  ah]rO  X   al_load_fontrO  auK;}rO  (hX   54rO  h	X   List al_load_bitmap_font_flagsrO  hX
   ProgrammerrO  h
X   58rO  hX   FOLrO  hX
   ELICIT-INFORMrO  h]rO  X	   structurerO  ah]rO  X   al_load_bitmap_font_flagsrO  auK<}rO  (hX   55rO  h	X   al_load_bitmap_font_flags like al_load_bitmap_font but additionally takes a flags parameter which is a bitfield containing a combination of the following:\nALLEGRO_NO_PREMULTIPLIED_ALPHA\nrO  hX   ApizarO  h
X   59rO  hX   POSrO  hX   INFORMrO  h]rO  (X   basicrO  X
   directivesrO  eh]rO  X   al_load_bitmap_font_flagsrO  auK=}rO  (hX   55rO  h	X-   The same meaning as for al_load_bitmap_flags.rO  hX   ApizarO  h
X   60rO  hX   CONTrO  hX   INFORMrO  h]rO  X	   structurerO  ah]rO  X   al_load_bitmap_font_flagsrO  auK>}rO  (hX   56rO  h	X.   Do I need to initialize allegro for ttf fonts?rO  hX
   ProgrammerrO  h
NhNhX
   ELICIT-INFORMrO  h]rO  X
   directivesrO  ahNuK?}rO  (hX   57rO  h	X   al_init_ttf_addon call this after al_init_font_addon to make al_load_font recognize ".ttf" and other formats supported by al_load_ttf_font. rO  hX   ApizarO  h
X   62rO  hX   POSrO  hX   SUGGESTrO  h]rO  (X
   directivesrO  X   patternsrO  X
   functionalityrO  eh]rO  (X   al_init_ttf_addonrO  X   al_init_font_addonrO  euK@}rO  (hX   57rO  h	X*   Returns true on success, false on failure.rO  hX   ApizarO  h
X   63rO  hX   CONTrO  hX   INFORMrO  h]rO  X
   functionalityrO  ah]rO  X   al_init_ttf_addonrO  auKA}rO  (hX   58rO  h	X   Allegro render ttf fontrO  hX
   ProgrammerrO  h
NhNhX   ELICIT-OFFER-OR-SUGGESTIONr P  h]rP  X   patternsrP  ahNuKB}rP  (hX   59rP  h	X*   How to draw an ALLEGRO_FONT to backbuffer?rP  hX
   ProgrammerrP  h
NhNhX   ELICIT-OFFER-OR-SUGGESTIONrP  h]rP  X   patternsr	P  ah]r
P  X   ALLEGRO_FONTrP  auKC}rP  (hX   60r
P  h	X7   ALLEGRO_FONT is a handle identifying any kind of font. rP  hX   ApizarP  h
X   65rP  hX   PARTrP  hX   INFORMrP  h]rP  X   conceptsrP  ah]rP  X   ALLEGRO_FONTrP  auKD}rP  (hX   60rP  h	X   Usually you will create it with al_load_font which supports loading all kinds of TrueType fonts supported by the FreeType library. rP  hX   ApizarP  h
X   67rP  hX   CONTrP  hX   SUGGESTrP  h]rP  (X   patternsrP  X   qualityr P  eh]r!P  (X   al_load_fontr"P  X   ALLEGRO_FONTr#P  euKE}r$P  (hX   60r%P  h	X   If you instead pass the filename of a bitmap file, it will be loaded with al_load_bitmap and a font in Allegro's bitmap font format will be created from it with al_grab_font_from_bitmap.r&P  hX   Apizar'P  h
X   68r(P  hX   CONTr)P  hX   INFORMr*P  h]r+P  (X   controlr,P  X   patternsr-P  eh]r.P  X   al_load_fontr/P  auKF}r0P  (hX   61r1P  h	X)   How do you draw an ALLEGRO_FONT instance?r2P  hX
   Programmerr3P  h
X   66r4P  hX   REPr5P  hX   ELICIT-OFFER-OR-SUGGESTIONr6P  h]r7P  X   patternsr8P  ah]r9P  X   ALLEGRO_FONTr:P  auKG}r;P  (hX   62r<P  h	X$   Are you interested in al_draw_textf?r=P  hX   Apizar>P  h
X   70r?P  hX   POSr@P  hX
   ELICIT-INFORMrAP  h]rBP  X   basicrCP  ah]rDP  X
   al_draw_textfrEP  auuuK}rFP  (hj?>  h}rGP  (K }rHP  (hhh	X,   what is the function to read keyboard input?rIP  hX
   ProgrammerrJP  h
NhNhX
   ELICIT-INFORMrKP  h]rLP  X   patternsrMP  ahNuK}rNP  (hhh	X,   what is the function to read keyboard input?rOP  hX
   ProgrammerrPP  h
hhX   REPrQP  hX
   ELICIT-INFORMrRP  h]rSP  X   patternsrTP  ahNuK}rUP  (hh+h	X1   Here is a function that might help with that:\n\nrVP  hX   ApizarWP  h
hhX   POSrXP  hX   INFORMrYP  h]rZP  X   patternsr[P  ah]r\P  X   al_key_downr]P  auK}r^P  (hh+h	XH   ```bool al_key_down(const ALLEGRO_KEYBOARD_STATE *state, int keycode)```r_P  hX   Apizar`P  h
hhX   CONTraP  hX   INFORMrbP  h]rcP  X   basicrdP  ah]reP  X   al_key_downrfP  auK}rgP  (hh5h	X6   what is the api for allocating ALLEGRO_KEYBOARD_STATE?rhP  hX
   ProgrammerriP  h
h+hX   FOLrjP  hX
   ELICIT-INFORMrkP  h]rlP  X   patternsrmP  ahNuK}rnP  (hh<h	X1   Here is a function that might help with that:\n\nroP  hX   ApizarpP  h
h5hX   POSrqP  hX   INFORMrrP  h]rsP  X   patternsrtP  ah]ruP  X   al_clear_keyboard_statervP  auK}rwP  (hh<h	X<   ```void al_clear_keyboard_state(ALLEGRO_DISPLAY *display)```rxP  hX   ApizaryP  h
h<hX   CONTrzP  hX   INFORMr{P  h]r|P  X   basicr}P  ah]r~P  X   al_clear_keyboard_staterP  auK}rP  (hhFh	X$   give me example of al_key_down usagerP  hX
   ProgrammerrP  h
h+hX   FOLrP  hX
   ELICIT-INFORMrP  h]rP  X   examplesrP  ah]rP  X   al_key_downrP  auK}rP  (hhQh	X)   Here is an example of keyboard input:\n\nrP  hX   ApizarP  h
hQhX   POSrP  hX   INFORMrP  h]rP  X   examplesrP  ahNuK	}rP  (hhQh	X@   <https://wiki.allegro.cc/index.php?title=Basic_Keyboard_Example>rP  hX   ApizarP  h
hXhX   CONTrP  hX   INFORMrP  h]rP  (X   examplesrP  X
   referencesrP  ehNuK
}rP  (hhXh	X!   how to you play an audio wav filerP  hX
   ProgrammerrP  h
NhNhX   ELICIT-OFFER-OR-SUGGESTIONrP  h]rP  X   patternsrP  ahNuK}rP  (hhch	X1   Here is a function that might help with that:\n\nrP  hX   ApizarP  h
X   10rP  hX   POSrP  hX   SUGGESTrP  h]rP  X   patternsrP  ah]rP  X   al_play_samplerP  auK}rP  (hhch	X   ```\nbool al_play_sample(ALLEGRO_SAMPLE *spl, float gain, float pan, float speed,\n ALLEGRO_PLAYMODE loop, ALLEGRO_SAMPLE_ID *ret_id)\n```rP  hX   ApizarP  h
X   11rP  hX   CONTrP  hX   INFORMrP  h]rP  X   basicrP  ah]rP  X   al_play_samplerP  auK
}rP  (hX   10rP  h	X%   give me example of playing a wav filerP  hX
   ProgrammerrP  h
NhNhX
   ELICIT-INFORMrP  h]rP  X   examplesrP  ahNuK}rP  (hX   11rP  h	X-   Here is an example of playing a wav file:\n\nrP  hX   ApizarP  h
X   13rP  hX   POSrP  hX   INFORMrP  h]rP  X   examplesrP  ahNuK}rP  (hX   11rP  h	XI   <https://wiki.allegro.cc/index.php?title=Allegro_5_Tutorial/Addons/Audio>rP  hX   ApizarP  h
X   14rP  hX   CONTrP  hX   INFORMrP  h]rP  (X   examplesrP  X
   referencesrP  ehNuK}rP  (hX   12rP  h	X1   what is the function to display numbers on screenrP  hX
   ProgrammerrP  h
NhNhX
   ELICIT-INFORMrP  h]rP  X   patternsrP  ahNuK}rP  (hX   13rP  h	X1   Here is a function that might help with that:\n\nrP  hX   ApizarP  h
X   16rP  hX   POSrP  hX   INFORMrP  h]rP  X   patternsrP  ah]rP  X   al_create_displayrP  auK}rP  (hX   13rP  h	X:   ```\nALLEGRO_DISPLAY *al_create_display(int w, int h)\n```rP  hX   ApizarP  h
X   17rP  hX   CONTrP  hX   INFORMrP  h]rP  X   basicrP  ah]rP  X   al_create_displayrP  auK}rP  (hX   14rP  h	X-   give me example of display numbers to displayrP  hX
   ProgrammerrP  h
NhNhX
   ELICIT-INFORMrP  h]rP  X   examplesrP  ahNuK}rP  (hX   15rP  h	X)   Here is an example of using displays:\n\nrP  hX   ApizarP  h
X   19rP  hX   POSrP  hX   INFORMrP  h]rP  X   examplesrP  ahNuK}rP  (hX   15rP  h	XE   <https://wiki.allegro.cc/index.php?title=Allegro_5_Tutorial/Displays>rP  hX   ApizarP  h
X   20rP  hX   CONTrP  hX   INFORMrP  h]r Q  (X   examplesrQ  X
   referencesrQ  ehNuK}rQ  (hX   16rQ  h	X   how to draw text on displayrQ  hX
   ProgrammerrQ  h
NhNhX   ELICIT-OFFER-OR-SUGGESTIONrQ  h]rQ  X   patternsr	Q  ahNuK}r
Q  (hX   17rQ  h	X1   Here is a function that might help with that:\n\nrQ  hX   Apizar
Q  h
X   22rQ  hX   POSrQ  hX   SUGGESTrQ  h]rQ  X   patternsrQ  ah]rQ  X   al_draw_textrQ  auK}rQ  (hX   17rQ  h	X~   ```\nvoid al_draw_text(const ALLEGRO_FONT *font,\n ALLEGRO_COLOR color, float x, float y, int flags,\n char const *text) \n```rQ  hX   ApizarQ  h
X   23rQ  hX   CONTrQ  hX   INFORMrQ  h]rQ  X   basicrQ  ah]rQ  X   al_draw_textrQ  auK}r Q  (hX   18r!Q  h	X   how to get size of displayr"Q  hX
   Programmerr#Q  h
NhNhX   ELICIT-OFFER-OR-SUGGESTIONr$Q  h]r%Q  X   patternsr&Q  ahNuK}r'Q  (hX   19r(Q  h	X1   Here is a function that might help with that:\n\nr)Q  hX   Apizar*Q  h
X   25r+Q  hX   POSr,Q  hX   SUGGESTr-Q  h]r.Q  X   patternsr/Q  ah]r0Q  X   al_get_display_widthr1Q  auK}r2Q  (hX   19r3Q  h	X<   ```\nint al_get_display_width(ALLEGRO_DISPLAY *display)\n```r4Q  hX   Apizar5Q  h
X   26r6Q  hX   CONTr7Q  hX   INFORMr8Q  h]r9Q  X   basicr:Q  ah]r;Q  X   al_get_display_widthr<Q  auK}r=Q  (hX   20r>Q  h	X%   show me example of using al_draw_textr?Q  hX
   Programmerr@Q  h
X   24rAQ  hX   FOLrBQ  hX
   ELICIT-INFORMrCQ  h]rDQ  X   examplesrEQ  ah]rFQ  X   al_draw_textrGQ  auK}rHQ  (hX   21rIQ  h	X'   Here is an example of drawing text:\n\nrJQ  hX   ApizarKQ  h
X   28rLQ  hX   POSrMQ  hX   INFORMrNQ  h]rOQ  X   examplesrPQ  ahNuK}rQQ  (hX   21rRQ  h	XI   <https://wiki.allegro.cc/index.php?title=Allegro_5_Tutorial/Addons/Fonts>rSQ  hX   ApizarTQ  h
X   29rUQ  hX   CONTrVQ  hX   INFORMrWQ  h]rXQ  (X   examplesrYQ  X
   referencesrZQ  ehNuK}r[Q  (hX   22r\Q  h	X%   show me man page for al_load_ttf_fontr]Q  hX
   Programmerr^Q  h
NhNhX
   ELICIT-INFORMr_Q  h]r`Q  X   basicraQ  ah]rbQ  X   al_load_ttf_fontrcQ  auK }rdQ  (hX   23reQ  h	X5   Here is the documentation for `al_load_ttf_font`:\n\nrfQ  hX   ApizargQ  h
X   31rhQ  hX   POSriQ  hX   INFORMrjQ  hNh]rkQ  X   al_load_ttf_fontrlQ  auK!}rmQ  (hX   23rnQ  h	X  ```\nLoads a TrueType font from a file using the FreeType library. Quoting from the FreeType FAQ this means support for many different font formats:\n\nTrueType, OpenType, Type1, CID, CFF, Windows FON/FNT, X11 PCF, and others\n\nThe size parameter determines the size the font will be rendered at, specified in pixels. The standard font size is measured in units per EM, if you instead want to specify the size as the total height of glyphs in pixels, pass it as a negative value.\n\nroQ  hX   ApizarpQ  h
X   32rqQ  hX   CONTrrQ  hX   INFORMrsQ  h]rtQ  (X
   functionalityruQ  X
   directivesrvQ  X   patternsrwQ  X
   referencesrxQ  eh]ryQ  X   al_load_ttf_fontrzQ  auK"}r{Q  (hX   23r|Q  h	Xv    Note: If you want to display text at multiple sizes, load the font multiple times with different size parameters.\n\nr}Q  hX   Apizar~Q  h
X   33rQ  hX   CONTrQ  hX   INFORMrQ  h]rQ  X   patternsrQ  ah]rQ  X   al_load_ttf_fontrQ  auK#}rQ  (hX   23rQ  h	Xm  The following flags are supported:\n\n ALLEGRO_TTF_NO_KERNING - Do not use any kerning even if the font file supports it.\n\n ALLEGRO_TTF_MONOCHROME - Load as a monochrome font (which means no anti-aliasing of the font is done).\n\n ALLEGRO_TTF_NO_AUTOHINT - Disable the Auto Hinter which is enabled by default in newer versions of FreeType. Since: 5.0.6, 5.1.2\n\nrQ  hX   ApizarQ  h
X   34rQ  hX   CONTrQ  hX   INFORMrQ  h]rQ  (X
   directivesrQ  X   environmentrQ  eh]rQ  X   al_load_ttf_fontrQ  auK$}rQ  (hX   23rQ  h	X4   See also: al_init_ttf_addon, al_load_ttf_font_f\n```rQ  hX   ApizarQ  h
X   35rQ  hX   CONTrQ  hX   INFORMrQ  h]rQ  X	   structurerQ  ah]rQ  X   al_load_ttf_fontrQ  auK%}rQ  (hX   24rQ  h	X,   what are the reasons al_load_ttf_font fails?rQ  hX
   ProgrammerrQ  h
NhNhX
   ELICIT-INFORMrQ  h]rQ  X
   functionalityrQ  ah]rQ  X   al_load_ttf_fontrQ  auK&}rQ  (hX   25rQ  h	X   I'm sorry, rQ  hX   ApizarQ  h
X   37rQ  hX   NEGrQ  hX   BE-POSITIVErQ  hNhNuK'}rQ  (hX   25rQ  h	X(   I'm not sure how to answer that questionrQ  hX   ApizarQ  h
X   38rQ  hX   CONTrQ  hX   INFORMrQ  hNhNuK(}rQ  (hX   26rQ  h	X&   when does al_load_ttf_font return NULLrQ  hX
   ProgrammerrQ  h
X   39rQ  hX   FOLrQ  hX
   ELICIT-INFORMrQ  h]rQ  X
   functionalityrQ  ah]rQ  X   al_load_ttf_fontrQ  auK)}rQ  (hX   27rQ  h	X1   Here is the source code for `al_load_ttf_font`:\nrQ  hX   ApizarQ  h
X   40rQ  hX   PARTrQ  hX   INFORMrQ  h]rQ  X   basicrQ  ah]rQ  X   al_load_ttf_fontrQ  auK*}rQ  (hX   27rQ  h	X   ```\n/* Function: al_load_ttf_font\n */\nALLEGRO_FONT *al_load_ttf_font(char const *filename, int size, int flags)\n{\n return al_load_ttf_font_stretch(filename, 0, size, flags);\n}\n```rQ  hX   ApizarQ  h
X   41rQ  hX   CONTrQ  hX   INFORMrQ  h]rQ  X   basicrQ  ah]rQ  X   al_load_ttf_fontrQ  auK+}rQ  (hX   28rQ  h	X0   show me source code for al_load_ttf_font_stretchrQ  hX
   ProgrammerrQ  h
NhNhX
   ELICIT-INFORMrQ  h]rQ  X   basicrQ  ah]rQ  X   al_load_ttf_font_stretchrQ  auK,}rQ  (hX   29rQ  h	X9   Here is the source code for `al_load_ttf_font_stretch`:\nrQ  hX   ApizarQ  h
X   43rQ  hX   POSrQ  hX   INFORMrQ  h]rQ  X   basicrQ  ah]rQ  X   al_load_ttf_font_stretchrQ  auK-}rQ  (hX   29rQ  h	XV  ```\n/* Function: al_load_ttf_font_stretch\n */\nALLEGRO_FONT *al_load_ttf_font_stretch(char const *filename, int w, int h,\n int flags)\n{\n ALLEGRO_FILE *f;\n ALLEGRO_FONT *font;\n ASSERT(filename);\n\n f = al_fopen(filename, "rb");\n if (!f) {\n ALLEGRO_ERROR("Unable to open file for reading: %s\\n", filename);\n return NULL;\n }\n\n /* The file handle is owned by the function and the file is usually only\n * closed when the font is destroyed, in case Freetype has to load data\n * at a later time.\n */\n font = al_load_ttf_font_stretch_f(f, filename, w, h, flags);\n\n return font;\n}\n```rQ  hX   ApizarQ  h
X   44rQ  hX   CONTrQ  hX   INFORMrQ  h]rQ  X   basicrQ  ah]rQ  X   al_load_ttf_font_stretchrQ  auK.}rQ  (hX   30rQ  h	X2   show me source code for al_load_ttf_font_stretch_frQ  hX
   ProgrammerrQ  h
NhNhX
   ELICIT-INFORMrQ  h]rQ  X   basicrQ  ah]rQ  X   al_load_ttf_font_stretch_frQ  auK/}rQ  (hX   31rQ  h	X=   Here is the source code for `al_load_ttf_font_stretch_f`:\r\nrQ  hX   Apizar R  h
X   46rR  hX   POSrR  hX   INFORMrR  h]rR  X   basicrR  ah]rR  X   al_load_ttf_font_stretch_frR  auK0}rR  (hX   31r	R  h	Xw   ```\r\n/* Function: al_load_ttf_font_stretch_f\r\n */\r\nALLEGRO_FONT *al_load_ttf_font_stretch_f(ALLEGRO_FILE *file,\rr
R  hX   ApizarR  h
X   47rR  hX   CONTr
R  hX   INFORMrR  h]rR  X   basicrR  ah]rR  X   al_load_ttf_font_stretch_frR  auK1}rR  (hX   32rR  h	X   how to enable Allegro loggingrR  hX
   ProgrammerrR  h
NhNhX   ELICIT-OFFER-OR-SUGGESTIONrR  h]rR  X   patternsrR  ahNuK2}rR  (hX   33rR  h	X1   Here is a function that might help with that:\n\nrR  hX   ApizarR  h
X   49rR  hX   POSrR  hX   SUGGESTr R  h]r!R  X   patternsr"R  ah]r#R  X   al_open_native_text_logr$R  auK3}r%R  (hX   33r&R  h	XP   ```\nALLEGRO_TEXTLOG *al_open_native_text_log(char const *title, int flags)\n```r'R  hX   Apizar(R  h
X   50r)R  hX   CONTr*R  hX   INFORMr+R  h]r,R  X   basicr-R  ah]r.R  X   al_open_native_text_logr/R  auK4}r0R  (hX   34r1R  h	X0   show me example of using al_open_native_text_logr2R  hX
   Programmerr3R  h
X   51r4R  hX   FOLr5R  hX
   ELICIT-INFORMr6R  h]r7R  X   examplesr8R  ah]r9R  X   al_open_native_text_logr:R  auK5}r;R  (hX   35r<R  h	X$   show me example of debugging allegror=R  hX
   Programmerr>R  h
NhNhX
   ELICIT-INFORMr?R  h]r@R  X   examplesrAR  ahNuK6}rBR  (hX   36rCR  h	X'   Here is an example of using dialog:\n\nrDR  hX   ApizarER  h
X   52rFR  hX   POSrGR  hX   INFORMrHR  h]rIR  X   examplesrJR  ahNuK7}rKR  (hX   36rLR  h	XP   <https://wiki.allegro.cc/index.php?title=Showing_a_basic_native_GUI_message_box>rMR  hX   ApizarNR  h
X   54rOR  hX   CONTrPR  hX   INFORMrQR  h]rRR  (X   examplesrSR  X
   referencesrTR  ehNuK8}rUR  (hX   37rVR  h	X   I'm sorry, rWR  hX   ApizarXR  h
X   53rYR  hX   NEGrZR  hX   BE-POSITIVEr[R  hNhNuK9}r\R  (hX   37r]R  h	X-   I don't have an example of debugging allegro.r^R  hX   Apizar_R  h
X   54r`R  hX   CONTraR  hX   INFORMrbR  hNhNuK:}rcR  (hX   38rdR  h	X*   show me example of enabling trace messagesreR  hX
   ProgrammerrfR  h
NhNhX
   ELICIT-INFORMrgR  h]rhR  X   examplesriR  ahNuK;}rjR  (hX   39rkR  h	X   I'm sorry, rlR  hX   ApizarmR  h
X   58rnR  hX   NEGroR  hX   BE-POSITIVErpR  hNhNuK<}rqR  (hX   39rrR  h	X3   I don't have an example of enabling trace messages.rsR  hX   ApizartR  h
X   59ruR  hX   CONTrvR  hX   INFORMrwR  hNhNuK=}rxR  (hX   40ryR  h	X2   show me example of creating a bitmap from an imagerzR  hX
   Programmerr{R  h
NhNhX
   ELICIT-INFORMr|R  h]r}R  X   examplesr~R  ahNuK>}rR  (hX   41rR  h	X(   Here is an example of using bitmaps:\n\nrR  hX   ApizarR  h
X   61rR  hX   POSrR  hX   INFORMrR  h]rR  X   examplesrR  ahNuK?}rR  (hX   41rR  h	XD   <https://wiki.allegro.cc/index.php?title=Allegro_5_Tutorial/Bitmaps>rR  hX   ApizarR  h
X   62rR  hX   CONTrR  hX   INFORMrR  h]rR  (X   examplesrR  X
   referencesrR  ehNuK@}rR  (hX   42rR  h	X"   how to load an image into a bitmaprR  hX
   ProgrammerrR  h
NhNhX   ELICIT-OFFER-OR-SUGGESTIONrR  h]rR  X   patternsrR  ahNuKA}rR  (hX   43rR  h	X1   Here is a function that might help with that:\n\nrR  hX   ApizarR  h
X   64rR  hX   POSrR  hX   SUGGESTrR  h]rR  X   patternsrR  ah]rR  X   al_load_bitmaprR  auKB}rR  (hX   43rR  h	X>   ```\nALLEGRO_BITMAP *al_load_bitmap(const char *filename)\n```rR  hX   ApizarR  h
X   65rR  hX   CONTrR  hX   INFORMrR  h]rR  X   basicrR  ah]rR  X   al_load_bitmaprR  auKC}rR  (hX   44rR  h	X   how to resize a bitmaprR  hX
   ProgrammerrR  h
NhNhX   ELICIT-OFFER-OR-SUGGESTIONrR  h]rR  X   patternsrR  ahNuKD}rR  (hX   45rR  h	X1   Here is a function that might help with that:\n\nrR  hX   ApizarR  h
X   67rR  hX   POSrR  hX   SUGGESTrR  h]rR  X   patternsrR  ah]rR  X   al_draw_scaled_bitmaprR  auKE}rR  (hX   45rR  h	X   ```\nvoid al_draw_scaled_bitmap(ALLEGRO_BITMAP *bitmap,\n float sx, float sy, float sw, float sh,\n float dx, float dy, float dw, float dh, int flags)\n```rR  hX   ApizarR  h
X   68rR  hX   CONTrR  hX   INFORMrR  h]rR  X   basicrR  ah]rR  X   al_draw_scaled_bitmaprR  auKF}rR  (hX   46rR  h	X.   show me example of using al_draw_scaled_bitmaprR  hX
   ProgrammerrR  h
NhNhX
   ELICIT-INFORMrR  h]rR  X   examplesrR  ah]rR  X   al_draw_scaled_bitmaprR  auKG}rR  (hX   47rR  h	X
   I'm sorry,rR  hX   ApizarR  h
X   70rR  hX   NEGrR  hX   BE-POSITIVErR  hNhNuKH}rR  (hX   47rR  h	X!    I don't have an example of that.rR  hX   ApizarR  h
X   71rR  hX   CONTrR  hX   INFORMrR  hNhNuuuK}rR  (hj?>  h}rR  (K }rR  (hhh	X   Hello ApizarR  hX
   ProgrammerrR  h
NhNhX   BE-POSITIVErR  hNhNuK}rR  (hhh	X   Hi Programmer_21rR  hX   ApizarR  h
hhX   POSrR  hX   BE-POSITIVErR  hNhNuK}rR  (hh+h	X   I've never used Allegro beforerR  hX
   ProgrammerrR  h
NhNhX   INFORMrR  hNhNuK}rR  (hh5h	X(   Ask about an Allegro function or featurerR  hX   ApizarR  h
NhNhX   SUGGESTrR  hNhNuK}rR  (hh5h	X7   and I will try to provide you with helpful information!rR  hX   ApizarR  h
h+hX   CONTrR  hX   OFFERrR  hNhNuK}rR  (hh<h	X   how do I get the key input?rR  hX
   ProgrammerrR  h
NhNhX   ELICIT-OFFER-OR-SUGGESTIONrR  h]rR  X   patternsr S  ahNuK}rS  (hhFh	X+   How do I get the keyboard input in allegro?rS  hX
   ProgrammerrS  h
h<hX   REPrS  hX   ELICIT-OFFER-OR-SUGGESTIONrS  h]rS  X   patternsrS  ahNuK}rS  (hhQh	X   Does this help?\n\nr	S  hX   Apizar
S  h
hFhX   POSrS  hX   SUGGESTrS  hNhNuK}r
S  (hhQh	X   ```\nALLEGRO_EVENT_KEY_CHAR\n\nrS  hX   ApizarS  h
hQhX   CONTrS  hX   INFORMrS  h]rS  X   basicrS  ah]rS  X   ALLEGRO_EVENT_KEY_CHARrS  auK	}rS  (hhQh	XL   A character was typed on the keyboard, or a character was auto-repeated.\n\nrS  hX   ApizarS  h
hXhX   CONTrS  hX   INFORMrS  h]rS  X   conceptsrS  ah]rS  X   ALLEGRO_EVENT_KEY_CHARrS  auK
}rS  (hhQh	X  keyboard.keycode (int)\n The code corresponding to the physical key which was last pressed. See the Key codes section for the list of ALLEGRO_KEY_* constants. \nkeyboard.unichar (int)\n\n A Unicode code point (character). This may be zero or negative if the event was generated for a non-visible "character", such as an arrow or Function key. In that case you can act upon the keycode field.\n\n Some special keys will set the unichar field to their standard ASCII values: Tab=9, Return=13, Escape=27. In addition if you press the Control key together with A to Z the unichar field will have the values 1 to 26. For example Ctrl-A will set unichar to 1 and Ctrl-H will set it to 8.\n\n As of Allegro 5.0.2 there are some inconsistencies in the treatment of Backspace (8 or 127) and Delete (127 or 0) keys on different platforms. These can be worked around by checking the keycode field.\nkeyboard.modifiers (unsigned)\n This is a bitfield of the modifier keys which were pressed when the event occurred. See "Keyboard modifier flags" for the constants. \nkeyboard.repeat (bool)\n Indicates if this is a repeated character. \nkeyboard.display (ALLEGRO_DISPLAY *)\n The display which had keyboard focus when the event occurred. \n```r S  hX   Apizar!S  h
hchX   CONTr"S  hX   INFORMr#S  h]r$S  (X   conceptsr%S  X
   directivesr&S  X   controlr'S  X	   structurer(S  X   environmentr)S  eh]r*S  X   ALLEGRO_EVENT_KEY_CHARr+S  auK}r,S  (hhXh	X   How do I use that?r-S  hX
   Programmerr.S  h
X   10r/S  hX   FOLr0S  hX   ELICIT-OFFER-OR-SUGGESTIONr1S  h]r2S  X
   functionalityr3S  ahNuK}r4S  (hhch	X0   Here is some information about getting events:\nr5S  hX   Apizar6S  h
X   11r7S  hX   POSr8S  hX   INFORMr9S  hNhNuK
}r:S  (hhch	X  ```\nEvent queues and input\n\nInput comes from multiple sources: keyboard, mouse, joystick, timers, etc. Event queues aggregate events from all these sources, then you can query the queue for events.\n\nCreate an event queue with al_create_event_queue, then tell input sources to place new events into that queue using al_register_event_source. The usual input event sources can be retrieved with al_get_keyboard_event_source, al_get_mouse_event_source and al_get_joystick_event_source.\n\nEvents can be retrieved with al_wait_for_event or al_get_next_event. Check the event type and other fields of ALLEGRO_EVENT to react to the input.\n\nDisplays are also event sources, which emit events when they are resized. You\'ll need to set the ALLEGRO_RESIZABLE flag with al_set_new_display_flags before creating the display, then register the display with an event queue. When you get a resize event, call al_acknowledge_resize.\n\nTimers are event sources which "tick" periodically, causing an event to be inserted into the queues that the timer is registered with. Create some with al_create_timer.\n\nal_get_time and al_rest are more direct ways to deal with time.\n```r;S  hX   Apizar<S  h
X   12r=S  hX   CONTr>S  hX   INFORMr?S  h]r@S  (X   conceptsrAS  X   purposerBS  X   controlrCS  X   patternsrDS  eh]rES  X
   ALLEGRO_EVENTrFS  auK}rGS  (hX   10rHS  h	X   Do you have any examples?rIS  hX
   ProgrammerrJS  h
X   13rKS  hX   FOLrLS  hX
   ELICIT-INFORMrMS  h]rNS  X   examplesrOS  ah]rPS  X
   ALLEGRO_EVENTrQS  auK}rRS  (hX   11rSS  h	X%   Here\'s an example of using events:\nrTS  hX   ApizarUS  h
X   14rVS  hX   POSrWS  hX   INFORMrXS  hNh]rYS  X
   ALLEGRO_EVENTrZS  auK}r[S  (hX   11r\S  h	X  ```\n#include &lt;stdio.h&gt;\n#include &lt;allegro5/allegro.h&gt;\n \nint main(int argc, char **argv){\n \n ALLEGRO_DISPLAY *display = NULL;\n ALLEGRO_EVENT_QUEUE *event_queue = NULL;\n\n if(!al_init()) {\n fprintf(stderr, "failed to initialize allegro!\\n");\n return -1;\n }\n\n display = al_create_display(640, 480);\n if(!display) {\n fprintf(stderr, "failed to create display!\\n");\n return -1;\n }\n\n event_queue = al_create_event_queue();\n if(!event_queue) {\n fprintf(stderr, "failed to create event_queue!\\n");\n al_destroy_display(display);\n return -1;\n }\n \n al_register_event_source(event_queue, al_get_display_event_source(display));\n\n al_clear_to_color(al_map_rgb(0,0,0));\n \n al_flip_display();\n \n while(1)\n {\n ALLEGRO_EVENT ev;\n ALLEGRO_TIMEOUT timeout;\n al_init_timeout(&amp;timeout, 0.06);\n \n bool get_event = al_wait_for_event_until(event_queue, &amp;ev, &amp;timeout);\n\n if(get_event &amp;&amp; ev.type == ALLEGRO_EVENT_DISPLAY_CLOSE) {\n break;\n }\n\n al_clear_to_color(al_map_rgb(0,0,0));\n al_flip_display();\n }\n \n al_destroy_display(display);\n al_destroy_event_queue(event_queue);\n\n return 0;\n}\n```r]S  hX   Apizar^S  h
X   15r_S  hX   CONTr`S  hX   INFORMraS  h]rbS  X   examplesrcS  ah]rdS  X
   ALLEGRO_EVENTreS  auK}rfS  (hX   12rgS  h	X   list of ALLEGRO_KEY_* constantsrhS  hX
   ProgrammerriS  h
hchX   FOLrjS  hX
   ELICIT-INFORMrkS  h]rlS  X	   structurermS  ahNuK}rnS  (hX   13roS  h	X0   These are the list of key codes used by Allegro,rpS  hX   ApizarqS  h
X   17rrS  hX   POSrsS  hX   INFORMrtS  hNhNuK}ruS  (hX   13rvS  h	Xh   which are returned in the event.keyboard.keycode field of the ALLEGRO_KEY_DOWN and ALLEGRO_KEY_UP eventsrwS  hX   ApizarxS  h
X   18ryS  hX   CONTrzS  hX   INFORMr{S  h]r|S  (X	   structurer}S  X   patternsr~S  ehNuK}rS  (hX   13rS  h	X*   and which you can pass to al_key_down:\n\nrS  hX   ApizarS  h
X   19rS  hX   CONTrS  hX   SUGGESTrS  h]rS  X   patternsrS  ah]rS  X   al_key_downrS  auK}rS  (hX   13rS  h	X3  ```\nALLEGRO_KEY_A ... ALLEGRO_KEY_Z\nALLEGRO_KEY_0 ... ALLEGRO_KEY_9\nALLEGRO_KEY_PAD_0 ... ALLEGRO_KEY_PAD_9\nALLEGRO_KEY_F1 ... ALLEGRO_KEY_F12\nALLEGRO_KEY_ESCAPE\nALLEGRO_KEY_TILDE\nALLEGRO_KEY_MINUS\nALLEGRO_KEY_EQUALS\nALLEGRO_KEY_BACKSPACE\nALLEGRO_KEY_TAB\nALLEGRO_KEY_OPENBRACE\nALLEGRO_KEY_CLOSEBRACE\nALLEGRO_KEY_ENTER\nALLEGRO_KEY_SEMICOLON\nALLEGRO_KEY_QUOTE\nALLEGRO_KEY_BACKSLASH\nALLEGRO_KEY_BACKSLASH2\nALLEGRO_KEY_COMMA\nALLEGRO_KEY_FULLSTOP\nALLEGRO_KEY_SLASH\nALLEGRO_KEY_SPACE\nALLEGRO_KEY_INSERT\nALLEGRO_KEY_DELETE\nALLEGRO_KEY_HOME\nALLEGRO_KEY_END\nALLEGRO_KEY_PGUP\nALLEGRO_KEY_PGDN\nALLEGRO_KEY_LEFT\nALLEGRO_KEY_RIGHT\nALLEGRO_KEY_UP\nALLEGRO_KEY_DOWN\nALLEGRO_KEY_PAD_SLASH\nALLEGRO_KEY_PAD_ASTERISK\nALLEGRO_KEY_PAD_MINUS\nALLEGRO_KEY_PAD_PLUS\nALLEGRO_KEY_PAD_DELETE\nALLEGRO_KEY_PAD_ENTER\nALLEGRO_KEY_PRINTSCREEN\nALLEGRO_KEY_PAUSE\nALLEGRO_KEY_ABNT_C1\nALLEGRO_KEY_YEN\nALLEGRO_KEY_KANA\nALLEGRO_KEY_CONVERT\nALLEGRO_KEY_NOCONVERT\nALLEGRO_KEY_AT\nALLEGRO_KEY_CIRCUMFLEX\nALLEGRO_KEY_COLON2\nALLEGRO_KEY_KANJI\nALLEGRO_KEY_LSHIFT\nALLEGRO_KEY_RSHIFT\nALLEGRO_KEY_LCTRL\nALLEGRO_KEY_RCTRL\nALLEGRO_KEY_ALT\nALLEGRO_KEY_ALTGR\nALLEGRO_KEY_LWIN\nALLEGRO_KEY_RWIN\nALLEGRO_KEY_MENU\nALLEGRO_KEY_SCROLLLOCK\nALLEGRO_KEY_NUMLOCK\nALLEGRO_KEY_CAPSLOCK\nALLEGRO_KEY_PAD_EQUALS\nALLEGRO_KEY_BACKQUOTE\nALLEGRO_KEY_SEMICOLON2\nALLEGRO_KEY_COMMAND\n\n/* Since: 5.1.1 */\n/* Android only for now */\nALLEGRO_KEY_BACK\n\n/* Since: 5.1.2 */\n/* Android only for now */\nALLEGRO_KEY_VOLUME_UP\nALLEGRO_KEY_VOLUME_DOWN\n\n/* Since: 5.1.6 */\n/* Android only for now */\nALLEGRO_KEY_SEARCH\nALLEGRO_KEY_DPAD_CENTER\nALLEGRO_KEY_BUTTON_X\nALLEGRO_KEY_BUTTON_Y\nALLEGRO_KEY_DPAD_UP\nALLEGRO_KEY_DPAD_DOWN\nALLEGRO_KEY_DPAD_LEFT\nALLEGRO_KEY_DPAD_RIGHT\nALLEGRO_KEY_SELECT\nALLEGRO_KEY_START\nALLEGRO_KEY_L1\nALLEGRO_KEY_R1\n```rS  hX   ApizarS  h
X   20rS  hX   CONTrS  hX   INFORMrS  h]rS  X	   structurerS  ahNuK}rS  (hX   14rS  h	X   example ALLEGRO_KEY_DOWNrS  hX
   ProgrammerrS  h
X   21rS  hX   FOLrS  hX
   ELICIT-INFORMrS  h]rS  X   examplesrS  ahNuK}rS  (hX   15rS  h	X   example event.keyboard.keycoderS  hX
   ProgrammerrS  h
X   18rS  hX   FOLrS  hX
   ELICIT-INFORMrS  h]rS  X   examplesrS  ah]rS  X
   ALLEGRO_EVENTrS  auK}rS  (hX   16rS  h	X,   Here is an example using `KEY_DOWN`:\r\n\r\nrS  hX   ApizarS  h
X   22rS  hX   POSrS  hX   INFORMrS  hNhNuK}rS  (hX   16rS  h	X<   ```\r\n#include <stdio.h>\r\n#include <allegro5/allegro.h>\rrS  hX   ApizarS  h
X   24rS  hX   CONTrS  hX   INFORMrS  h]rS  X   examplesrS  ahNuK}rS  (hX   17rS  h	X
   debug textrS  hX
   ProgrammerrS  h
NhNhX   ELICIT-OFFER-OR-SUGGESTIONrS  h]rS  X   patternsrS  ahNuK}rS  (hX   18rS  h	X   Sorry,rS  hX   ApizarS  h
X   26rS  hX   UNCrS  hX   BE-POSITIVErS  hNhNuK}rS  (hX   18rS  h	X"   I'm not sure what you mean by thatrS  hX   ApizarS  h
X   27rS  hX   CONTrS  hX   COMMENT-ABOUT-UNDERSTANDINGrS  hNhNuK}rS  (hX   19rS  h	X   how do I output debug strings?rS  hX
   ProgrammerrS  h
X   28rS  hX   FOLrS  hX   ELICIT-OFFER-OR-SUGGESTIONrS  h]rS  X   patternsrS  ahNuK}rS  (hX   20rS  h	X   print functionrS  hX
   ProgrammerrS  h
NhNhX
   ELICIT-INFORMrS  h]rS  X   patternsrS  ahNuK}rS  (hX   21rS  h	X   Does this function help?\n\nrS  hX   ApizarS  h
X   29rS  hX   POSrS  hX   SUGGESTrS  hNh]rS  X   al_ustr_newfrS  auK }rS  (hX   21rS  h	XI   ```\nal_ustr_newf\n\nALLEGRO_USTR *al_ustr_newf(const char *fmt, ...)\n\nrS  hX   ApizarS  h
X   31rS  hX   CONTrS  hX   INFORMrS  h]rS  X   basicrS  ah]rS  X   al_ustr_newfrS  auK!}rS  (hX   21rS  h	X   Source Code\n\nrS  hX   ApizarS  h
X   32rS  hX   CONTrS  hX   OTHERrS  hNh]rS  X   al_ustr_newfrS  auK"}rS  (hX   21rS  h	X;   Create a new string using a printf-style format string.\n\nrS  hX   ApizarS  h
X   33rS  hX   CONTrS  hX   INFORMrS  h]r T  X
   functionalityrT  ah]rT  X   al_ustr_newfrT  auK#}rT  (hX   21rT  h	X  Notes:\n\nThe "%s" specifier takes C string arguments, not ALLEGRO_USTRs. Therefore to pass an ALLEGRO_USTR as a parameter you must use al_cstr, and it must be NUL terminated. If the string contains an embedded NUL byte everything from that byte onwards will be ignored.\n\nThe "%c" specifier outputs a single byte, not the UTF-8 encoding of a code point. Therefore it is only usable for ASCII characters (value &lt;= 127) or if you really mean to output byte values from 128--255. To insert the UTF-8 encoding of a code point, encode it into a memory buffer using al_utf8_encode then use the "%s" specifier. Remember to NUL terminate the buffer.\n\nrT  hX   ApizarT  h
X   34rT  hX   CONTr	T  hX   INFORMr
T  h]rT  (X
   directivesrT  X
   functionalityr
T  X   patternsrT  eh]rT  X   al_ustr_newfrT  auK$}rT  (hX   21rT  h	X+   See also: al_ustr_new, al_ustr_appendf\n```rT  hX   ApizarT  h
X   35rT  hX   CONTrT  hX   INFORMrT  h]rT  X	   structurerT  ah]rT  X   al_ustr_newfrT  auK%}rT  (hX   22rT  h	X   No.rT  hX
   ProgrammerrT  h
X   36r T  hX   NEGr!T  hX   INFORMr"T  hNhNuK&}r#T  (hX   23r$T  h	X'   ALLEGRO_EVENT_KEY_DOWN isn't triggeringr%T  hX
   Programmerr&T  h
NhNhX   INFORMr'T  h]r(T  X   controlr)T  ah]r*T  X   ALLEGRO_EVENT_KEY_DOWNr+T  auK'}r,T  (hX   24r-T  h	X:   Here is some information about events that might help:\n\nr.T  hX   Apizar/T  h
X   38r0T  hX   POSr1T  hX   INFORMr2T  hNhNuK(}r3T  (hX   24r4T  h	X6  ```\nWhat are Events?\n\nEvents tell you that something has happened in your program such as a key being pressed, the mouse has moved, a timer has been ticked, and the display has synchronized. Allegro uses them to notify you of all types of events, but you may create your own customized events if required.\nr5T  hX   Apizar6T  h
X   39r7T  hX   CONTr8T  hX   INFORMr9T  h]r:T  (X   conceptsr;T  X   purposer<T  eh]r=T  X
   ALLEGRO_EVENTr>T  auK)}r?T  (hX   24r@T  h	Xo  Why do I want Events?\n\nUsing Allegro's event queue system is the most efficient way to handle events; you simply wait for the arrival of new events and handle them when they occur. An alternative method of handling events is via polling -- constantly checking whether an event has occurred. The event system reduces processor usage compared to the polling method.\nrAT  hX   ApizarBT  h
X   40rCT  hX   CONTrDT  hX   INFORMrET  h]rFT  X   qualityrGT  ah]rHT  X
   ALLEGRO_EVENTrIT  auK*}rJT  (hX   24rKT  h	X   Event Sources\n\nAn event source is something that notifies the program when something has occurred. There are several standard Allegro event sources, including but not limited to Timers, Displays, and Inputs.\nrLT  hX   ApizarMT  h
X   41rNT  hX   CONTrOT  hX   INFORMrPT  h]rQT  X   conceptsrRT  ah]rST  X
   ALLEGRO_EVENTrTT  auK+}rUT  (hX   24rVT  h	XC  Event Queues\n\nAn event queue is where events are placed in a first-in-first-out container and are removed when the events are being handled by the main program. You may create multiple event queues and direct the event sources into the appropriate queues. However, using a single event queue is the simplest method. \n```rWT  hX   ApizarXT  h
X   42rYT  hX   CONTrZT  hX   INFORMr[T  h]r\T  (X   conceptsr]T  X   patternsr^T  eh]r_T  (X
   ALLEGRO_EVENTr`T  X   ALLEGRO_EVENT_QUEUEraT  euK,}rbT  (hX   25rcT  h	X5   Does this help with your question about printing?\n\nrdT  hX   ApizareT  h
X   30rfT  hX   POSrgT  hX   SUGGESTrhT  hNhNuK-}riT  (hX   25rjT  h	XS   ```\nal_fprintf\n\nint al_fprintf(ALLEGRO_FILE *pfile, const char *format, ...)\n\nrkT  hX   ApizarlT  h
X   31rmT  hX   CONTrnT  hX   INFORMroT  h]rpT  X   basicrqT  ah]rrT  X
   al_fprintfrsT  auK.}rtT  (hX   25ruT  h	X   Source Code\n\nrvT  hX   ApizarwT  h
X   32rxT  hX   CONTryT  hX   OTHERrzT  hNh]r{T  X
   al_fprintfr|T  auK/}r}T  (hX   25r~T  h	X6   Writes to a file with stdio "printf"-like formatting. rT  hX   ApizarT  h
X   33rT  hX   CONTrT  hX   INFORMrT  h]rT  X
   functionalityrT  ah]rT  X
   al_fprintfrT  auK0}rT  (hX   25rT  h	XH   Returns the number of bytes written, or a negative number on error.\n```rT  hX   ApizarT  h
X   34rT  hX   CONTrT  hX   INFORMrT  h]rT  X
   functionalityrT  ah]rT  X
   al_fprintfrT  auK1}rT  (hX   26rT  h	X   event.type to stringrT  hX
   ProgrammerrT  h
NhNhX
   ELICIT-INFORMrT  h]rT  X   patternsrT  ah]rT  X
   ALLEGRO_EVENTrT  auK2}rT  (hX   27rT  h	X   print event.typerT  hX
   ProgrammerrT  h
X   49rT  hX   REPrT  hX
   ELICIT-INFORMrT  h]rT  X   patternsrT  ah]rT  X
   ALLEGRO_EVENTrT  auK3}rT  (hX   28rT  h	X;   Here is the documentation I have on ALLEGRO_EVENT_TYPE:\n\nrT  hX   ApizarT  h
X   50rT  hX   PARTrT  hX   INFORMrT  hNh]rT  X   ALLEGRO_EVENT_TYPErT  auK4}rT  (hX   28rT  h	XG   ```\nALLEGRO_EVENT_TYPE\n\ntypedef unsigned int ALLEGRO_EVENT_TYPE;\n\nrT  hX   ApizarT  h
X   51rT  hX   CONTrT  hX   INFORMrT  h]rT  X   basicrT  ah]rT  X   ALLEGRO_EVENT_TYPErT  auK5}rT  (hX   28rT  h	X   Source Code\n\nrT  hX   ApizarT  h
X   52rT  hX   CONTrT  hX   OTHERrT  hNh]rT  X   ALLEGRO_EVENT_TYPErT  auK6}rT  (hX   28rT  h	XF   An integer used to distinguish between different types of events.\n```rT  hX   ApizarT  h
X   53rT  hX   CONTrT  hX   INFORMrT  h]rT  X
   functionalityrT  ah]rT  X   ALLEGRO_EVENT_TYPErT  auK7}rT  (hX   29rT  h	X!   al_register_event_source keyboardrT  hX
   ProgrammerrT  h
NhNhX
   ELICIT-INFORMrT  h]rT  X   patternsrT  ah]rT  X   al_register_event_sourcerT  auK8}rT  (hX   30rT  h	X   Does this work?\n\nrT  hX   ApizarT  h
X   55rT  hX   POSrT  hX   SUGGESTrT  hNh]rT  X   al_register_event_sourcerT  auK9}rT  (hX   30rT  h	XQ   ```\n al_register_event_source(event_queue, al_get_keyboard_event_source());\n```rT  hX   ApizarT  h
X   56rT  hX   CONTrT  hX   INFORMrT  h]rT  X   examplesrT  ah]rT  X   al_register_event_sourcerT  auK:}rT  (hX   31rT  h	X,   Here is some more context for that line:\n\nrT  hX   ApizarT  h
X   57rT  hX   FOLrT  hX   INFORMrT  hNh]rT  X   al_register_event_sourcerT  auK;}rT  (hX   31rT  h	X  ```\n event_queue = al_create_event_queue();\n if(!event_queue) {\n fprintf(stderr, "failed to create event_queue!\\n");\n al_destroy_bitmap(bouncer);\n al_destroy_display(display);\n al_destroy_timer(timer);\n return -1;\n }\n \n al_register_event_source(event_queue, al_get_display_event_source(display));\n \n al_register_event_source(event_queue, al_get_timer_event_source(timer));\n\n al_register_event_source(event_queue, al_get_keyboard_event_source()); \n```rT  hX   ApizarT  h
X   58rT  hX   CONTrT  hX   INFORMrT  h]rT  X   examplesrT  ah]rT  X   al_register_event_sourcerT  auK<}r U  (hX   32rU  h	X
   Thank you.rU  hX
   ProgrammerrU  h
X   59rU  hX   POSrU  hX   ASSESSrU  hNhNuK=}rU  (hX   33rU  h	X
   Load audior	U  hX
   Programmerr
U  h
NhNhX   ELICIT-OFFER-OR-SUGGESTIONrU  h]rU  X   patternsr
U  ahNuK>}rU  (hX   34rU  h	X&   Here is an example of using audio:\n\nrU  hX   ApizarU  h
X   61rU  hX   POSrU  hX   INFORMrU  hNhNuK?}rU  (hX   34rU  h	X{  ```\n#include &lt;stdio.h&gt;\n#include &lt;allegro5/allegro.h&gt;\n#include &lt;allegro5/allegro_audio.h&gt;\n#include &lt;allegro5/allegro_acodec.h&gt;\n\nint main(int argc, char **argv){\n\n ALLEGRO_DISPLAY *display = NULL;\n ALLEGRO_SAMPLE *sample=NULL;\n \n if(!al_init()){\n fprintf(stderr, "failed to initialize allegro!\\n");\n return -1;\n }\n \n if(!al_install_audio()){\n fprintf(stderr, "failed to initialize audio!\\n");\n return -1;\n }\n\n if(!al_init_acodec_addon()){\n fprintf(stderr, "failed to initialize audio codecs!\\n");\n return -1;\n }\n \n if (!al_reserve_samples(1)){\n fprintf(stderr, "failed to reserve samples!\\n");\n return -1;\n }\n \n sample = al_load_sample( "footstep.wav" );\n\n if (!sample){\n printf( "Audio clip sample not loaded!\\n" ); \n return -1;\n }\n \n display = al_create_display(640, 480);\n \n if(!display){\n fprintf(stderr, "failed to create display!\\n");\n return -1;\n }\n\n /* Loop the sample until the display closes. */\n al_play_sample(sample, 1.0, 0.0,1.0,ALLEGRO_PLAYMODE_LOOP,NULL);\n\n al_rest(10.0);\n \n al_destroy_display(display);\n al_destroy_sample(sample);\n return 0;\n}\n```rU  hX   ApizarU  h
X   62rU  hX   CONTrU  hX   INFORMrU  h]rU  X   examplesrU  ahNuK@}rU  (hX   35rU  h	X   ALLEGRO_PLAYMODE_* singler U  hX
   Programmerr!U  h
X   63r"U  hX   FOLr#U  hX
   ELICIT-INFORMr$U  h]r%U  (X	   structurer&U  X   patternsr'U  eh]r(U  (X   ALLEGRO_PLAYMODEr)U  X   al_play_sampler*U  euKA}r+U  (hX   36r,U  h	X<   Here is the documentation I have about ALLEGRO_PLAYMODE:\n\nr-U  hX   Apizar.U  h
X   64r/U  hX   POSr0U  hX   INFORMr1U  hNh]r2U  X   ALLEGRO_PLAYMODEr3U  auKB}r4U  (hX   36r5U  h	X2   ```\nALLEGRO_PLAYMODE\n\nenum ALLEGRO_PLAYMODE\n\nr6U  hX   Apizar7U  h
X   65r8U  hX   CONTr9U  hX   INFORMr:U  h]r;U  X   basicr<U  ah]r=U  X   ALLEGRO_PLAYMODEr>U  auKC}r?U  (hX   36r@U  h	X   Source Code\n\nrAU  hX   ApizarBU  h
X   66rCU  hX   CONTrDU  hX   OTHERrEU  hNh]rFU  X   ALLEGRO_PLAYMODErGU  auKD}rHU  (hX   36rIU  h	X%   Sample and stream playback mode.\n\n rJU  hX   ApizarKU  h
X   67rLU  hX   CONTrMU  hX   INFORMrNU  h]rOU  X   conceptsrPU  ah]rQU  X   ALLEGRO_PLAYMODErRU  auKE}rSU  (hX   36rTU  h	XK   ALLEGRO_PLAYMODE_ONCE\n ALLEGRO_PLAYMODE_LOOP\n ALLEGRO_PLAYMODE_BIDIR\n```rUU  hX   ApizarVU  h
X   68rWU  hX   CONTrXU  hX   INFORMrYU  h]rZU  X	   structurer[U  ah]r\U  X   ALLEGRO_PLAYMODEr]U  auKF}r^U  (hX   37r_U  h	X   hud display align top leftr`U  hX
   ProgrammerraU  h
NhNhX   ELICIT-OFFER-OR-SUGGESTIONrbU  h]rcU  X   patternsrdU  ahNuKG}reU  (hX   38rfU  h	X<   Here is an example of some display code that might help:\n\nrgU  hX   ApizarhU  h
X   70riU  hX   POSrjU  hX   INFORMrkU  hNhNuKH}rlU  (hX   38rmU  h	X~  ```\n#include "allegro5/allegro.h"\n#include "allegro5/allegro_image.h"\n#include "allegro5/allegro_native_dialog.h"\n\nint main(int argc, char **argv){\n\n ALLEGRO_DISPLAY *display = NULL;\n ALLEGRO_BITMAP *image = NULL;\n\n if(!al_init()) {\n al_show_native_message_box(display, "Error", "Error", "Failed to initialize allegro!", \n NULL, ALLEGRO_MESSAGEBOX_ERROR);\n return 0;\n }\n\n if(!al_init_image_addon()) {\n al_show_native_message_box(display, "Error", "Error", "Failed to initialize al_init_image_addon!", \n NULL, ALLEGRO_MESSAGEBOX_ERROR);\n return 0;\n }\n\n display = al_create_display(800,600);\n\n if(!display) {\n al_show_native_message_box(display, "Error", "Error", "Failed to initialize display!", \n NULL, ALLEGRO_MESSAGEBOX_ERROR);\n return 0;\n }\n\n image = al_load_bitmap("image.png");\n\n if(!image) {\n al_show_native_message_box(display, "Error", "Error", "Failed to load image!", \n NULL, ALLEGRO_MESSAGEBOX_ERROR);\n al_destroy_display(display);\n return 0;\n }\n\n al_draw_bitmap(image,200,200,0);\n\n al_flip_display();\n al_rest(2);\n\n al_destroy_display(display);\n al_destroy_bitmap(image);\n\n return 0;\n}\n```rnU  hX   ApizaroU  h
X   71rpU  hX   CONTrqU  hX   INFORMrrU  h]rsU  X   examplesrtU  ahNuKI}ruU  (hX   39rvU  h	X   display ui textrwU  hX
   ProgrammerrxU  h
NhNhX   ELICIT-OFFER-OR-SUGGESTIONryU  h]rzU  X   patternsr{U  ahNuKJ}r|U  (hX   40r}U  h	X*   Here\'s an example of displaying text:\n\nr~U  hX   ApizarU  h
X   73rU  hX   POSrU  hX   INFORMrU  hNhNuKK}rU  (hX   40rU  h	X  ```\n#include &lt;stdio.h&gt;\n#include &lt;allegro5/allegro.h&gt;\n#include &lt;allegro5/allegro_font.h&gt;\n#include &lt;allegro5/allegro_ttf.h&gt;\n\nint main(int argc, char **argv){\n\n if(!al_init()){\n fprintf(stderr, "Failed to initialize Allegro.\\n");\n return -1;\n }\n\n al_init_font_addon(); // initialize the font addon\n al_init_ttf_addon();// initialize the ttf (True Type Font) addon\n\n ALLEGRO_DISPLAY *display = al_create_display(640,480);\n \n if (!display){\n fprintf(stderr, "Failed to create display.\\n");\n return -1;\n }\n\n ALLEGRO_FONT *font = al_load_ttf_font("pirulen.ttf",72,0 );\n\n if (!font){\n fprintf(stderr, "Could not load \'pirulen.ttf\'.\\n");\n return -1;\n }\n\n al_clear_to_color(al_map_rgb(50,10,70));\n al_draw_text(font, al_map_rgb(255,255,255), 640/2, (480/4),ALLEGRO_ALIGN_CENTRE, "Your Text Here!");\n\n al_flip_display();\n\n al_rest(10.0);\n\n al_destroy_display(display);\n\n return 0;\n}\n```rU  hX   ApizarU  h
X   74rU  hX   CONTrU  hX   INFORMrU  h]rU  X   examplesrU  ahNuKL}rU  (hX   41rU  h	X   ALLEGRO_ALIGN_*rU  hX
   ProgrammerrU  h
X   75rU  hX   FOLrU  hX
   ELICIT-INFORMrU  h]rU  X	   structurerU  ah]rU  X   al_draw_textrU  auKM}rU  (hX   42rU  h	X0   Here's some documentation that might help:\n\n\nrU  hX   ApizarU  h
X   76rU  hX   POSrU  hX   INFORMrU  hNh]rU  X   al_draw_textrU  auKN}rU  (hX   42rU  h	X   ```\nal_draw_text\n\nrU  hX   ApizarU  h
X   77rU  hX   CONTrU  hX   INFORMrU  hNh]rU  X   al_draw_textrU  auKO}rU  (hX   42rU  h	Xx   void al_draw_text(const ALLEGRO_FONT *font,\n ALLEGRO_COLOR color, float x, float y, int flags,\n char const *text) \n\nrU  hX   ApizarU  h
X   78rU  hX   CONTrU  hX   INFORMrU  h]rU  X   basicrU  ah]rU  X   al_draw_textrU  auKP}rU  (hX   42rU  h	X   Source Code\n\nrU  hX   ApizarU  h
X   79rU  hX   CONTrU  hX   OTHERrU  hNh]rU  X   al_draw_textrU  auKQ}rU  (hX   42rU  h	Xl   Writes the NUL-terminated string text onto the target bitmap at position x, y, using the specified font.\n\nrU  hX   ApizarU  h
X   80rU  hX   CONTrU  hX   INFORMrU  h]rU  X
   functionalityrU  ah]rU  X   al_draw_textrU  auKR}rU  (hX   42rU  h	X  The flags parameter can be 0 or one of the following flags:\n\n ALLEGRO_ALIGN_LEFT - Draw the text left-aligned (same as 0).\n ALLEGRO_ALIGN_CENTRE - Draw the text centered around the given position.\n ALLEGRO_ALIGN_RIGHT - Draw the text right-aligned to the given position.\n\nIt can also be combined with this flag:\n\n ALLEGRO_ALIGN_INTEGER - Always draw text aligned to an integer pixel position. This was formerly the default behaviour. rU  hX   ApizarU  h
X   81rU  hX   CONTrU  hX   INFORMrU  h]rU  (X
   directivesrU  X
   functionalityrU  eh]rU  X   al_draw_textrU  auKS}rU  (hX   42rU  h	X   Since: 5.0.8, 5.1.4\n\nThis function does not support newline characters (\\n), but you can use al_draw_multiline_text for multi line text output.\n\nrU  hX   ApizarU  h
X   82rU  hX   CONTrU  hX   INFORMrU  h]rU  (X   environmentrU  X
   directivesrU  X   patternsrU  eh]rU  X   al_draw_textrU  auKT}rU  (hX   42rU  h	X[   See also: al_draw_ustr, al_draw_textf, al_draw_justified_text, al_draw_multiline_text.\n```rU  hX   ApizarU  h
X   83rU  hX   CONTrU  hX   INFORMrU  h]rU  X	   structurerU  ah]rU  X   al_draw_textrU  auKU}rU  (hX   43rU  h	X   screen sizerU  hX
   ProgrammerrU  h
NhNhX
   ELICIT-INFORMrU  h]rU  X   conceptsrU  ahNuKV}rU  (hX   44rU  h	X
   al_draw_textfrU  hX
   ProgrammerrU  h
X   84rU  hX   FOLrU  hX
   ELICIT-INFORMrU  h]rU  X   basicrU  ah]rU  X
   al_draw_textfrU  auKW}rU  (hX   45rU  h	X.   Here's the documentation on that function:\n\nr V  hX   ApizarV  h
X   86rV  hX   POSrV  hX   INFORMrV  hNh]rV  X
   al_draw_textfrV  auKX}rV  (hX   45rV  h	X   ```\nal_draw_textf\n\nr	V  hX   Apizar
V  h
X   87rV  hX   CONTrV  hX   INFORMr
V  hNh]rV  X
   al_draw_textfrV  auKY}rV  (hX   45rV  h	X   void al_draw_textf(const ALLEGRO_FONT *font, ALLEGRO_COLOR color,\n float x, float y, int flags,\n const char *format, ...)\n\nrV  hX   ApizarV  h
X   88rV  hX   CONTrV  hX   INFORMrV  h]rV  X   basicrV  ah]rV  X
   al_draw_textfrV  auKZ}rV  (hX   45rV  h	X   Source Code\n\nrV  hX   ApizarV  h
X   89rV  hX   CONTr V  hX   OTHERr!V  hNh]r"V  X
   al_draw_textfr#V  auK[}r$V  (hX   45r%V  h	X=   Formatted text output, using a printf() style format string. r&V  hX   Apizar'V  h
X   90r(V  hX   CONTr)V  hX   INFORMr*V  h]r+V  X
   functionalityr,V  ah]r-V  X
   al_draw_textfr.V  auK\}r/V  (hX   45r0V  h	XH   All parameters have the same meaning as with al_draw_text otherwise.\n\nr1V  hX   Apizar2V  h
X   91r3V  hX   CONTr4V  hX   INFORMr5V  h]r6V  (X
   functionalityr7V  X	   structurer8V  eh]r9V  X
   al_draw_textfr:V  auK]}r;V  (hX   45r<V  h	X)   See also: al_draw_text, al_draw_ustr\n```r=V  hX   Apizar>V  h
X   92r?V  hX   CONTr@V  hX   INFORMrAV  h]rBV  X	   structurerCV  ah]rDV  X
   al_draw_textfrEV  auK^}rFV  (hX   46rGV  h	X   al_draw_text integerrHV  hX
   ProgrammerrIV  h
NhNhX
   ELICIT-INFORMrJV  h]rKV  X   patternsrLV  ah]rMV  X   al_draw_textrNV  auK_}rOV  (hX   47rPV  h	X.   Here's the documentation on that function:\n\nrQV  hX   ApizarRV  h
X   94rSV  hX   POSrTV  hX   INFORMrUV  hNh]rVV  X   al_draw_textrWV  auK`}rXV  (hX   47rYV  h	X   ```\nal_draw_text\n\nrZV  hX   Apizar[V  h
X   95r\V  hX   CONTr]V  hX   INFORMr^V  hNh]r_V  X   al_draw_textr`V  auKa}raV  (hX   47rbV  h	Xx   void al_draw_text(const ALLEGRO_FONT *font,\n ALLEGRO_COLOR color, float x, float y, int flags,\n char const *text) \n\nrcV  hX   ApizardV  h
X   96reV  hX   CONTrfV  hX   INFORMrgV  h]rhV  X   basicriV  ah]rjV  X   al_draw_textrkV  auKb}rlV  (hX   47rmV  h	X   Source Code\n\nrnV  hX   ApizaroV  h
X   97rpV  hX   CONTrqV  hX   OTHERrrV  hNh]rsV  X   al_draw_textrtV  auKc}ruV  (hX   47rvV  h	Xl   Writes the NUL-terminated string text onto the target bitmap at position x, y, using the specified font.\n\nrwV  hX   ApizarxV  h
X   98ryV  hX   CONTrzV  hX   INFORMr{V  h]r|V  X
   functionalityr}V  ah]r~V  X   al_draw_textrV  auKd}rV  (hX   47rV  h	X  The flags parameter can be 0 or one of the following flags:\n\n ALLEGRO_ALIGN_LEFT - Draw the text left-aligned (same as 0).\n ALLEGRO_ALIGN_CENTRE - Draw the text centered around the given position.\n ALLEGRO_ALIGN_RIGHT - Draw the text right-aligned to the given position.\n\nIt can also be combined with this flag:\n\n ALLEGRO_ALIGN_INTEGER - Always draw text aligned to an integer pixel position. This was formerly the default behaviour. rV  hX   ApizarV  h
X   99rV  hX   CONTrV  hX   INFORMrV  h]rV  (X
   directivesrV  X
   functionalityrV  eh]rV  X   al_draw_textrV  auKe}rV  (hX   47rV  h	X   Since: 5.0.8, 5.1.4\n\nThis function does not support newline characters (\\n), but you can use al_draw_multiline_text for multi line text output.\n\nrV  hX   ApizarV  h
X   100rV  hX   CONTrV  hX   INFORMrV  h]rV  (X   environmentrV  X
   directivesrV  X   patternsrV  eh]rV  X   al_draw_textrV  auKf}rV  (hX   47rV  h	X[   See also: al_draw_ustr, al_draw_textf, al_draw_justified_text, al_draw_multiline_text.\n```rV  hX   ApizarV  h
X   101rV  hX   CONTrV  hX   INFORMrV  h]rV  X	   structurerV  ah]rV  X   al_draw_textrV  auKg}rV  (hX   48rV  h	X   al_draw_text number examplerV  hX
   ProgrammerrV  h
X   102rV  hX   FOLrV  hX
   ELICIT-INFORMrV  h]rV  X   examplesrV  ah]rV  X   al_draw_textrV  auKh}rV  (hX   49rV  h	X%   Here\'s an example function call:\n\nrV  hX   ApizarV  h
X   103rV  hX   POSrV  hX   INFORMrV  hNh]rV  X   al_draw_textrV  auKi}rV  (hX   49rV  h	Xn   ```\nal_draw_text(font, al_map_rgb(255,255,255), 640/2, (480/4),ALLEGRO_ALIGN_CENTRE, "Your Text Here!");\n```rV  hX   ApizarV  h
X   104rV  hX   CONTrV  hX   INFORMrV  h]rV  X   examplesrV  ah]rV  X   al_draw_textrV  auKj}rV  (hX   50rV  h	X   number to stringrV  hX
   ProgrammerrV  h
X   105rV  hX   FOLrV  hX
   ELICIT-INFORMrV  h]rV  X   patternsrV  ahNuKk}rV  (hX   51rV  h	X   Does this C function help?\n\nrV  hX   ApizarV  h
X   106rV  hX   POSrV  hX   SUGGESTrV  hNhNuKl}rV  (hX   51rV  h	X!   ```\nsprintf(str, "%d", 42);\n```rV  hX   ApizarV  h
X   107rV  hX   CONTrV  hX   INFORMrV  h]rV  X   examplesrV  ahNuKm}rV  (hX   52rV  h	X8   Allegro doesn't have the ability to display HUD numbers?rV  hX
   ProgrammerrV  h
X   108rV  hX   FOLrV  hX
   ELICIT-INFORMrV  h]rV  X
   functionalityrV  ahNuKn}rV  (hX   53rV  h	X   Sorry,rV  hX   ApizarV  h
X   109rV  hX   UNCrV  hX   BE-POSITIVErV  hNhNuKo}rV  (hX   53rV  h	X#   I'm not sure what you mean by that.rV  hX   ApizarV  h
X   110rV  hX   CONTrV  hX   COMMENT-ABOUT-UNDERSTANDINGrV  hNhNuKp}rV  (hX   54rV  h	X6   Does Allegro have a way to display a number in the UI?rV  hX
   ProgrammerrV  h
X   111rV  hX   FOLrV  hX
   ELICIT-INFORMrV  h]rV  X
   functionalityrV  ahNuKq}rV  (hX   55rV  h	X%   The native dialogs addon might help. rV  hX   ApizarV  h
X   112r W  hX   POSrW  hX   INFORMrW  h]rW  X   patternsrW  ahNuKr}rW  (hX   55rW  h	X   Here is an example:\n\nrW  hX   ApizarW  h
X   113r	W  hX   CONTr
W  hX   INFORMrW  hNhNuKs}rW  (hX   55r
W  h	XQ  ```\n#include "allegro5/allegro.h"\n#include &lt;allegro5/allegro_native_dialog.h&gt;\n\nint main(int argc, char **argv){\n\n if(al_init()) {\n al_show_native_message_box(al_get_current_display(), \n "Window Title", \n "Content Title", \n "The error message here",\n NULL, ALLEGRO_MESSAGEBOX_ERROR);\n return 0;\n }\n\n return 0;\n}\n```rW  hX   ApizarW  h
X   114rW  hX   CONTrW  hX   INFORMrW  h]rW  X   examplesrW  ahNuuuK}rW  (hj?>  h}rW  (K }rW  (hhh	X   Hello, rW  hX
   ProgrammerrW  h
NhNhX   BE-POSITIVErW  hNhNuK}rW  (hhh	X5   so the first question:\nIs there keyboard event type?rW  hX
   ProgrammerrW  h
NhNhX
   ELICIT-INFORMrW  h]rW  X	   structurer W  ahNuK}r!W  (hhh	X   Hi! r"W  hX   Apizar#W  h
hhX   POSr$W  hX   BE-POSITIVEr%W  hNhNuK}r&W  (hhh	X1   My name is Apiza, a brand new virtual assistant, r'W  hX   Apizar(W  h
NhNhX   INFORMr)W  hNhNuK}r*W  (hhh	X$   I look forward to helping you today.r+W  hX   Apizar,W  h
NhNhX   BE-POSITIVEr-W  hNhNuK}r.W  (hh+h	X   Is there keyboard event type?r/W  hX
   Programmerr0W  h
hhX   REPr1W  hX
   ELICIT-INFORMr2W  h]r3W  X	   structurer4W  ahNuK}r5W  (hh5h	X$   Yes, there is a keyboard event type,r6W  hX   Apizar7W  h
h<hX   POSr8W  hX   INFORMr9W  h]r:W  X	   structurer;W  ahNuK}r<W  (hh5h	X    would you like the type name?r=W  hX   Apizar>W  h
hFhX   FOLr?W  hX
   ELICIT-INFORMr@W  h]rAW  X   basicrBW  ahNuK}rCW  (hh<h	X!   What is keyboard event type name?rDW  hX
   ProgrammerrEW  h
hQhX   POSrFW  hX
   ELICIT-INFORMrGW  h]rHW  X   basicrIW  ahNuK	}rJW  (hhFh	Xp   you can register a keyboard callback with al_register_event_source(event_queue, al_get_keyboard_event_source());rKW  hX   ApizarLW  h
hXhX   PARTrMW  hX   SUGGESTrNW  h]rOW  (X   patternsrPW  X   basicrQW  eh]rRW  X   al_register_event_sourcerSW  auK
}rTW  (hhQh	X%   What is keyboard event constant name?rUW  hX
   ProgrammerrVW  h
hchX   NEGrWW  hX
   ELICIT-INFORMrXW  h]rYW  X   basicrZW  ahNuK}r[W  (hhXh	Xd   a keyboard event can be inferred via an enum contained by the "type" field of an ALLEGO_EVENT objectr\W  hX   Apizar]W  h
X   10r^W  hX   POSr_W  hX   INFORMr`W  h]raW  X	   structurerbW  ah]rcW  X
   ALLEGRO_EVENTrdW  auK}reW  (hhch	X   Describe ALLEGO_EVENT objectrfW  hX
   ProgrammerrgW  h
X   11rhW  hX   FOLriW  hX
   ELICIT-INFORMrjW  h]rkW  X   basicrlW  ah]rmW  X
   ALLEGRO_EVENTrnW  auK
}roW  (hX   10rpW  h	X   an ALLEGRO_EVENT object is a data type containing information regarding an event that has been recorded from a variety of input sources. rqW  hX   ApizarrW  h
X   12rsW  hX   POSrtW  hX   INFORMruW  h]rvW  X
   functionalityrwW  ah]rxW  X
   ALLEGRO_EVENTryW  auK}rzW  (hX   10r{W  h	XL   The most notable use of this type is to specify what type of event occurred.r|W  hX   Apizar}W  h
X   13r~W  hX   CONTrW  hX   INFORMrW  h]rW  X   purposerW  ah]rW  X
   ALLEGRO_EVENTrW  auK}rW  (hX   11rW  h	X#   Show me declaration of ALLEGO_EVENTrW  hX
   ProgrammerrW  h
X   14rW  hX   FOLrW  hX
   ELICIT-INFORMrW  h]rW  (X	   structurerW  X   basicrW  eh]rW  X
   ALLEGRO_EVENTrW  auK}rW  (hX   12rW  h	X"   one second, parsing source code...rW  hX   ApizarW  h
X   15rW  hX   PARTrW  hX   OTHERrW  hNhNuK}rW  (hX   13rW  h	X   from source file events.h:\n\nrW  hX   ApizarW  h
X   15rW  hX   POSrW  hX   INFORMrW  h]rW  X	   structurerW  ahNuK}rW  (hX   13rW  h	X4  typedef union ALLEGRO_EVENT ALLEGRO_EVENT;\n\nunion ALLEGRO_EVENT\n{\n /* This must be the same as the first field of _AL_EVENT_HEADER. */\n ALLEGRO_EVENT_TYPE type;\n /* `any' is to allow the user to access the other fields which are\n * common to all event types, without using some specific type\n * structure.\n */\n ALLEGRO_ANY_EVENT any;\n ALLEGRO_DISPLAY_EVENT display;\n ALLEGRO_JOYSTICK_EVENT joystick;\n ALLEGRO_KEYBOARD_EVENT keyboard;\n ALLEGRO_MOUSE_EVENT mouse;\n ALLEGRO_TIMER_EVENT timer;\n ALLEGRO_TOUCH_EVENT touch;\n ALLEGRO_USER_EVENT user;\n};rW  hX   ApizarW  h
X   17rW  hX   CONTrW  hX   INFORMrW  h]rW  (X
   directivesrW  X	   structurerW  X   basicrW  eh]rW  X
   ALLEGRO_EVENTrW  auK}rW  (hX   14rW  h	X)   Show me declaration of ALLEGRO_EVENT_TYPErW  hX
   ProgrammerrW  h
X   18rW  hX   FOLrW  hX
   ELICIT-INFORMrW  h]rW  (X	   structurerW  X   basicrW  eh]rW  X   ALLEGRO_EVENT_TYPErW  auK}rW  (hX   15rW  h	X   from source file events.h:\n\nrW  hX   ApizarW  h
X   19rW  hX   POSrW  hX   INFORMrW  h]rW  X	   structurerW  ahNuK}rW  (hX   15rW  h	X  /* Type: ALLEGRO_EVENT_TYPE\n */\ntypedef unsigned int ALLEGRO_EVENT_TYPE;\n\nenum\n{\n ALLEGRO_EVENT_JOYSTICK_AXIS = 1,\n ALLEGRO_EVENT_JOYSTICK_BUTTON_DOWN = 2,\n ALLEGRO_EVENT_JOYSTICK_BUTTON_UP = 3,\n ALLEGRO_EVENT_JOYSTICK_CONFIGURATION = 4,\n\n ALLEGRO_EVENT_KEY_DOWN = 10,\n ALLEGRO_EVENT_KEY_CHAR = 11,\n ALLEGRO_EVENT_KEY_UP = 12,\n\n ALLEGRO_EVENT_MOUSE_AXES = 20,\n ALLEGRO_EVENT_MOUSE_BUTTON_DOWN = 21,\n ALLEGRO_EVENT_MOUSE_BUTTON_UP = 22,\n ALLEGRO_EVENT_MOUSE_ENTER_DISPLAY = 23,\n ALLEGRO_EVENT_MOUSE_LEAVE_DISPLAY = 24,\n ALLEGRO_EVENT_MOUSE_WARPED = 25,\n\n ALLEGRO_EVENT_TIMER = 30,\n\n ALLEGRO_EVENT_DISPLAY_EXPOSE = 40,\n ALLEGRO_EVENT_DISPLAY_RESIZE = 41,\n ALLEGRO_EVENT_DISPLAY_CLOSE = 42,\n ALLEGRO_EVENT_DISPLAY_LOST = 43,\n ALLEGRO_EVENT_DISPLAY_FOUND = 44,\n ALLEGRO_EVENT_DISPLAY_SWITCH_IN = 45,\n ALLEGRO_EVENT_DISPLAY_SWITCH_OUT = 46,\n ALLEGRO_EVENT_DISPLAY_ORIENTATION = 47,\n ALLEGRO_EVENT_DISPLAY_HALT_DRAWING = 48,\n ALLEGRO_EVENT_DISPLAY_RESUME_DRAWING = 49,\n\n ALLEGRO_EVENT_TOUCH_BEGIN = 50,\n ALLEGRO_EVENT_TOUCH_END = 51,\n ALLEGRO_EVENT_TOUCH_MOVE = 52,\n ALLEGRO_EVENT_TOUCH_CANCEL = 53,\n\n ALLEGRO_EVENT_DISPLAY_CONNECTED = 60,\n ALLEGRO_EVENT_DISPLAY_DISCONNECTED = 61\n};rW  hX   ApizarW  h
X   20rW  hX   CONTrW  hX   INFORMrW  h]rW  (X	   structurerW  X   basicrW  eh]rW  X   ALLEGRO_EVENT_TYPErW  auK}rW  (hX   16rW  h	X-   Show me declaration of ALLEGRO_KEYBOARD_EVENTrW  hX
   ProgrammerrW  h
X   18rW  hX   FOLrW  hX
   ELICIT-INFORMrW  h]rW  (X	   structurerW  X   basicrW  ehNuK}rW  (hX   17rW  h	X   from source file events.h:\n\nrW  hX   ApizarW  h
X   22rW  hX   POSrW  hX   INFORMrW  h]rW  X	   structurerW  ahNuK}rW  (hX   17rW  h	Xn  typedef struct ALLEGRO_KEYBOARD_EVENT\n{\n _AL_EVENT_HEADER(struct ALLEGRO_KEYBOARD)\n struct ALLEGRO_DISPLAY *display; /* the window the key was pressed in */\n int keycode; /* the physical key pressed */\n int unichar; /* unicode character or negative */\n unsigned int modifiers; /* bitfield */\n bool repeat; /* auto-repeated or not */\n} ALLEGRO_KEYBOARD_EVENT;rW  hX   ApizarW  h
X   23rW  hX   CONTrW  hX   INFORMrW  h]rW  (X   conceptsrW  X	   structurerW  X   basicrW  ehNuK}rW  (hX   18rW  h	XG   What does mean al_get_keyboard: Assertion `new_keyboard_driver' failed.rW  hX
   ProgrammerrW  h
NhNhX
   ELICIT-INFORMrW  h]rW  X   conceptsrW  ahNuK}rW  (hX   19rW  h	X   I am unsure,rW  hX   ApizarW  h
X   25rW  hX   UNCrW  hX   INFORMrW  hNhNuK}rW  (hX   19rW  h	X   scanning source files...rW  hX   ApizarW  h
X   26rW  hX   CONTr X  hX   OTHERrX  hNhNuK}rX  (hX   20rX  h	XP   I believe the assertion comes from this function defined in src/keybdnu.c:\n\n\nrX  hX   ApizarX  h
X   25rX  hX   POSrX  hX   INFORMrX  h]r	X  X   controlr
X  ahNuK}rX  (hX   20rX  h	X   /* Function: al_is_keyboard_installed\n */\nbool al_is_keyboard_installed(void)\n{\n return (new_keyboard_driver ? true : false);\n}r
X  hX   ApizarX  h
X   28rX  hX   CONTrX  hX   INFORMrX  h]rX  (X   basicrX  X
   functionalityrX  eh]rX  X   al_is_keyboard_installedrX  auK}rX  (hX   21rX  h	X   How to install keyboard?rX  hX
   ProgrammerrX  h
NhNhX   ELICIT-OFFER-OR-SUGGESTIONrX  h]rX  X   patternsrX  ahNuK}rX  (hX   22rX  h	XF   keyboards can be initialized using the function al_install_keyboard();r X  hX   Apizar!X  h
X   30r"X  hX   POSr#X  hX   INFORMr$X  h]r%X  X   patternsr&X  ah]r'X  X   al_install_keyboardr(X  auK }r)X  (hX   23r*X  h	X4   Show me declaration for al_install_keyboard functionr+X  hX
   Programmerr,X  h
X   31r-X  hX   FOLr.X  hX
   ELICIT-INFORMr/X  h]r0X  X   basicr1X  ah]r2X  X   al_install_keyboardr3X  auK!}r4X  (hX   24r5X  h	X$   one second, scanning source files...r6X  hX   Apizar7X  h
X   32r8X  hX   PARTr9X  hX   OTHERr:X  hNhNuK"}r;X  (hX   25r<X  h	XF   would you like the declaration or definition of al_install_keyboard()?r=X  hX   Apizar>X  h
X   32r?X  hX   FOLr@X  hX
   ELICIT-INFORMrAX  hNh]rBX  X   al_install_keyboardrCX  auK#}rDX  (hX   26rEX  h	X3   I would like to get declaration al_install_keyboardrFX  hX
   ProgrammerrGX  h
X   34rHX  hX   POSrIX  hX
   ELICIT-INFORMrJX  h]rKX  X   basicrLX  ah]rMX  X   al_install_keyboardrNX  auK$}rOX  (hX   27rPX  h	X   bool al_install_keyboard(void);rQX  hX   ApizarRX  h
X   35rSX  hX   POSrTX  hX   INFORMrUX  h]rVX  X   basicrWX  ah]rXX  X   al_install_keyboardrYX  auK%}rZX  (hX   28r[X  h	X-   Show me documentation for al_install_keyboardr\X  hX
   Programmerr]X  h
X   36r^X  hX   FOLr_X  hX
   ELICIT-INFORMr`X  h]raX  X   basicrbX  ah]rcX  X   al_install_keyboardrdX  auK&}reX  (hX   29rfX  h	X/   from doc file docs/src/refman/keyboard.txt:\n\nrgX  hX   ApizarhX  h
X   37riX  hX   POSrjX  hX   INFORMrkX  hNh]rlX  X   al_install_keyboardrmX  auK'}rnX  (hX   29roX  h	X   ## API: rpX  hX   ApizarqX  h
X   38rrX  hX   CONTrsX  hX   OTHERrtX  hNhNuK(}ruX  (hX   29rvX  h	X   al_install_keyboard\n\nrwX  hX   ApizarxX  h
X   39ryX  hX   CONTrzX  hX   OTHERr{X  hNh]r|X  X   al_install_keyboardr}X  auK)}r~X  (hX   29rX  h	X   Install a keyboard driver.rX  hX   ApizarX  h
X   40rX  hX   CONTrX  hX   INFORMrX  h]rX  X
   functionalityrX  ah]rX  X   al_install_keyboardrX  auK*}rX  (hX   29rX  h	Xi   Returns true if successful. If a driver\nwas already installed, nothing happens and true is returned.\n\nrX  hX   ApizarX  h
X   41rX  hX   CONTrX  hX   INFORMrX  h]rX  X
   functionalityrX  ah]rX  X   al_install_keyboardrX  auK+}rX  (hX   29rX  h	X=   See also: [al_uninstall_keyboard], [al_is_keyboard_installed]rX  hX   ApizarX  h
X   42rX  hX   CONTrX  hX   INFORMrX  h]rX  X	   structurerX  ah]rX  X   al_install_keyboardrX  auK,}rX  (hX   30rX  h	X-   What is values available for keyboard keycoderX  hX
   ProgrammerrX  h
X   24rX  hX   FOLrX  hX
   ELICIT-INFORMrX  h]rX  (X
   directivesrX  X	   structurerX  ehNuK-}rX  (hX   31rX  h	X/   from doc file docs/src/refman/keyboard.txt:\n\nrX  hX   ApizarX  h
X   44rX  hX   POSrX  hX   INFORMrX  h]rX  X	   structurerX  ahNuK.}rX  (hX   31rX  h	X   ## Key codes\n\nrX  hX   ApizarX  h
X   45rX  hX   CONTrX  hX   OTHERrX  hNhNuK/}rX  (hX   31rX  h	X   The constant ALLEGRO_KEY_MAX is always one higher than\nthe highest key code. So if you want to use the key code as array index\nyou can do something like this:\n\n~~~~c\nbool pressed_keys[ALLEGRO_KEY_MAX];\n//...\npressed_keys[key_code] = true;\n~~~~\n\nrX  hX   ApizarX  h
X   46rX  hX   CONTrX  hX   INFORMrX  h]rX  (X   conceptsrX  X   patternsrX  X   examplesrX  ehNuK0}rX  (hX   31rX  h	X   These are the list of key codes used by Allegro, which are returned in\nthe event.keyboard.keycode field of the ALLEGRO_KEY_DOWN and\nALLEGRO_KEY_UP events and which you can pass to [al_key_down]:\n\n rX  hX   ApizarX  h
X   47rX  hX   CONTrX  hX   INFORMrX  h]rX  (X	   structurerX  X   patternsrX  eh]rX  X   al_key_downrX  auK1}rX  (hX   31rX  h	X"	  ALLEGRO_KEY_A ... ALLEGRO_KEY_Z\n ALLEGRO_KEY_0 ... ALLEGRO_KEY_9\n ALLEGRO_KEY_PAD_0 ... ALLEGRO_KEY_PAD_9\n ALLEGRO_KEY_F1 ... ALLEGRO_KEY_F12\n ALLEGRO_KEY_ESCAPE\n ALLEGRO_KEY_TILDE\n ALLEGRO_KEY_MINUS\n ALLEGRO_KEY_EQUALS\n ALLEGRO_KEY_BACKSPACE\n ALLEGRO_KEY_TAB\n ALLEGRO_KEY_OPENBRACE\n ALLEGRO_KEY_CLOSEBRACE\n ALLEGRO_KEY_ENTER\n ALLEGRO_KEY_SEMICOLON\n ALLEGRO_KEY_QUOTE\n ALLEGRO_KEY_BACKSLASH\n ALLEGRO_KEY_BACKSLASH2\n ALLEGRO_KEY_COMMA\n ALLEGRO_KEY_FULLSTOP\n ALLEGRO_KEY_SLASH\n ALLEGRO_KEY_SPACE\n ALLEGRO_KEY_INSERT\n ALLEGRO_KEY_DELETE\n ALLEGRO_KEY_HOME\n ALLEGRO_KEY_END\n ALLEGRO_KEY_PGUP\n ALLEGRO_KEY_PGDN\n ALLEGRO_KEY_LEFT\n ALLEGRO_KEY_RIGHT\n ALLEGRO_KEY_UP\n ALLEGRO_KEY_DOWN\n ALLEGRO_KEY_PAD_SLASH\n ALLEGRO_KEY_PAD_ASTERISK\n ALLEGRO_KEY_PAD_MINUS\n ALLEGRO_KEY_PAD_PLUS\n ALLEGRO_KEY_PAD_DELETE\n ALLEGRO_KEY_PAD_ENTER\n ALLEGRO_KEY_PRINTSCREEN\n ALLEGRO_KEY_PAUSE\n ALLEGRO_KEY_ABNT_C1\n ALLEGRO_KEY_YEN\n ALLEGRO_KEY_KANA\n ALLEGRO_KEY_CONVERT\n ALLEGRO_KEY_NOCONVERT\n ALLEGRO_KEY_AT\n ALLEGRO_KEY_CIRCUMFLEX\n ALLEGRO_KEY_COLON2\n ALLEGRO_KEY_KANJI\n ALLEGRO_KEY_LSHIFT\n ALLEGRO_KEY_RSHIFT\n ALLEGRO_KEY_LCTRL\n ALLEGRO_KEY_RCTRL\n ALLEGRO_KEY_ALT\n ALLEGRO_KEY_ALTGR\n ALLEGRO_KEY_LWIN\n ALLEGRO_KEY_RWIN\n ALLEGRO_KEY_MENU\n ALLEGRO_KEY_SCROLLLOCK\n ALLEGRO_KEY_NUMLOCK\n ALLEGRO_KEY_CAPSLOCK\n ALLEGRO_KEY_PAD_EQUALS\n ALLEGRO_KEY_BACKQUOTE\n ALLEGRO_KEY_SEMICOLON2\n ALLEGRO_KEY_COMMAND\n\n /* Since: 5.1.1 */\n /* Android only for now */\n ALLEGRO_KEY_BACK\n\n /* Since: 5.1.2 */\n /* Android only for now */\n ALLEGRO_KEY_VOLUME_UP\n ALLEGRO_KEY_VOLUME_DOWN\n\n /* Since: 5.1.6 */\n /* Android only for now */\n ALLEGRO_KEY_SEARCH\n ALLEGRO_KEY_DPAD_CENTER\n ALLEGRO_KEY_BUTTON_X\n ALLEGRO_KEY_BUTTON_Y\n ALLEGRO_KEY_DPAD_UP\n ALLEGRO_KEY_DPAD_DOWN\n ALLEGRO_KEY_DPAD_LEFT\n ALLEGRO_KEY_DPAD_RIGHT\n ALLEGRO_KEY_SELECT\n ALLEGRO_KEY_START\n ALLEGRO_KEY_L1\n ALLEGRO_KEY_R1\n\n## Keyboard modifier flags\n\n ALLEGRO_KEYMOD_SHIFT\n ALLEGRO_KEYMOD_CTRL\n ALLEGRO_KEYMOD_ALT\n ALLEGRO_KEYMOD_LWIN\n ALLEGRO_KEYMOD_RWIN\n ALLEGRO_KEYMOD_MENU\n ALLEGRO_KEYMOD_ALTGR\n ALLEGRO_KEYMOD_COMMAND\n ALLEGRO_KEYMOD_SCROLLLOCK\n ALLEGRO_KEYMOD_NUMLOCK\n ALLEGRO_KEYMOD_CAPSLOCK\n ALLEGRO_KEYMOD_INALTSEQ\n ALLEGRO_KEYMOD_ACCENT1\n ALLEGRO_KEYMOD_ACCENT2\n ALLEGRO_KEYMOD_ACCENT3\n ALLEGRO_KEYMOD_ACCENT4\n\nrX  hX   ApizarX  h
X   48rX  hX   CONTrX  hX   INFORMrX  h]rX  (X	   structurerX  X   environmentrX  ehNuK2}rX  (hX   31rX  h	X   The event field 'keyboard.modifiers' is a bitfield composed of these constants.\nThese indicate the modifier keys which were pressed at the time a character was\ntyped.rX  hX   ApizarX  h
X   49rX  hX   CONTrX  hX   INFORMrX  h]rX  (X	   structurerX  X   purposerX  ehNuK3}rX  (hX   32rX  h	X   How to play music?rX  hX
   ProgrammerrX  h
NhNhX   ELICIT-OFFER-OR-SUGGESTIONrX  h]rX  X   patternsrX  ahNuK4}rX  (hX   33rX  h	X   How to play wav file?rX  hX
   ProgrammerrX  h
X   51rX  hX   REPrX  hX   ELICIT-OFFER-OR-SUGGESTIONrX  h]rX  X   patternsrX  ahNuK5}rX  (hX   34rX  h	X-   you can play a sample using the function:\n\nrX  hX   ApizarX  h
X   52rX  hX   POSrX  hX   SUGGESTrX  h]rX  X   patternsrX  ahNuK6}rX  (hX   34rX  h	X   bool al_play_sample(ALLEGRO_SAMPLE *spl, float gain, float pan, float speed,\n ALLEGRO_PLAYMODE loop, ALLEGRO_SAMPLE_ID *ret_id)rX  hX   Apizar Y  h
X   53rY  hX   CONTrY  hX   INFORMrY  h]rY  X   basicrY  ah]rY  X   al_play_samplerY  auK7}rY  (hX   35r	Y  h	X   Play the wav file?r
Y  hX
   ProgrammerrY  h
X   54rY  hX   NEGr
Y  hX   ELICIT-OFFER-OR-SUGGESTIONrY  h]rY  X   patternsrY  ahNuK8}rY  (hX   36rY  h	X4   to load an audio file, you can use the function:\n\nrY  hX   ApizarY  h
X   55rY  hX   POSrY  hX   SUGGESTrY  h]rY  X   patternsrY  ahNuK9}rY  (hX   36rY  h	XV   /* Function: al_load_sample\n */\nALLEGRO_SAMPLE *al_load_sample(const char *filename)rY  hX   ApizarY  h
X   56rY  hX   CONTrY  hX   INFORMr Y  h]r!Y  X   basicr"Y  ah]r#Y  X   al_load_sampler$Y  auK:}r%Y  (hX   37r&Y  h	X   definition of ALLEGRO_PLAYMODEr'Y  hX
   Programmerr(Y  h
X   54r)Y  hX   FOLr*Y  hX
   ELICIT-INFORMr+Y  h]r,Y  (X	   structurer-Y  X   basicr.Y  eh]r/Y  X   ALLEGRO_PLAYMODEr0Y  auK;}r1Y  (hX   38r2Y  h	X=   from source file addons/audio/allegro5/allegro_audio.h:\n\n\nr3Y  hX   Apizar4Y  h
X   58r5Y  hX   POSr6Y  hX   INFORMr7Y  h]r8Y  X	   structurer9Y  ah]r:Y  X   ALLEGRO_PLAYMODEr;Y  auK<}r<Y  (hX   38r=Y  h	X  /* Enum: ALLEGRO_PLAYMODE\n */\nenum ALLEGRO_PLAYMODE\n{\n ALLEGRO_PLAYMODE_ONCE = 0x100,\n ALLEGRO_PLAYMODE_LOOP = 0x101,\n ALLEGRO_PLAYMODE_BIDIR = 0x102,\n _ALLEGRO_PLAYMODE_STREAM_ONCE = 0x103, /* internal */\n _ALLEGRO_PLAYMODE_STREAM_ONEDIR = 0x104 /* internal */\n};r>Y  hX   Apizar?Y  h
X   59r@Y  hX   CONTrAY  hX   INFORMrBY  h]rCY  (X	   structurerDY  X   basicrEY  eh]rFY  X   ALLEGRO_PLAYMODErGY  auK=}rHY  (hX   39rIY  h	X   example of ALLEGRO_SAMPLE_IDrJY  hX
   ProgrammerrKY  h
X   54rLY  hX   FOLrMY  hX
   ELICIT-INFORMrNY  h]rOY  X   examplesrPY  ah]rQY  X   ALLEGRO_SAMPLE_IDrRY  auK>}rSY  (hX   40rTY  h	X   NULLrUY  hX   ApizarVY  h
X   61rWY  hX   POSrXY  hX   INFORMrYY  h]rZY  X   examplesr[Y  ah]r\Y  X   ALLEGRO_SAMPLE_IDr]Y  auK?}r^Y  (hX   41r_Y  h	X   example of al_play_sampler`Y  hX
   ProgrammerraY  h
X   54rbY  hX   FOLrcY  hX
   ELICIT-INFORMrdY  h]reY  X   examplesrfY  ah]rgY  X   al_play_samplerhY  auK@}riY  (hX   42rjY  h	X@   al_play_sample(sample, 1.0, 0.0,1.0,ALLEGRO_PLAYMODE_LOOP,NULL);rkY  hX   ApizarlY  h
X   63rmY  hX   POSrnY  hX   INFORMroY  h]rpY  X   examplesrqY  ah]rrY  X   al_play_samplersY  auKA}rtY  (hX   43ruY  h	X   how to use al_load_samplervY  hX
   ProgrammerrwY  h
X   57rxY  hX   FOLryY  hX   ELICIT-OFFER-OR-SUGGESTIONrzY  h]r{Y  X   patternsr|Y  ah]r}Y  X   al_load_sampler~Y  auKB}rY  (hX   44rY  h	X!   al_load_sample( "footstep.wav" );rY  hX   ApizarY  h
X   65rY  hX   POSrY  hX   INFORMrY  h]rY  X   examplesrY  ah]rY  X   al_load_samplerY  auKC}rY  (hX   45rY  h	X   declaration of al_load_samplerY  hX
   ProgrammerrY  h
X   57rY  hX   FOLrY  hX
   ELICIT-INFORMrY  h]rY  X   basicrY  ah]rY  X   al_load_samplerY  auKD}rY  (hX   46rY  h	X#   you can use the following function:rY  hX   ApizarY  h
X   67rY  hX   POSrY  hX   SUGGESTrY  hNh]rY  X   al_load_samplerY  auKE}rY  (hX   46rY  h	XU   /* Function: al_load_sample\n*/\nALLEGRO_SAMPLE *al_load_sample(const char *filename)rY  hX   ApizarY  h
X   68rY  hX   CONTrY  hX   INFORMrY  h]rY  X   basicrY  ah]rY  X   al_load_samplerY  auKF}rY  (hX   47rY  h	X$   How to check error of al_load_samplerY  hX
   ProgrammerrY  h
X   57rY  hX   FOLrY  hX   ELICIT-OFFER-OR-SUGGESTIONrY  h]rY  X   patternsrY  ah]rY  X   al_load_samplerY  auKG}rY  (hX   48rY  h	X:   al_load_sample returns a pointer, on error it returns NULLrY  hX   ApizarY  h
X   70rY  hX   POSrY  hX   INFORMrY  h]rY  (X
   functionalityrY  X   basicrY  eh]rY  X   al_load_samplerY  auKH}rY  (hX   49rY  h	X;   How to get error message in case of error in al_load_samplerY  hX
   ProgrammerrY  h
X   71rY  hX   NEGrY  hX   ELICIT-OFFER-OR-SUGGESTIONrY  h]rY  X   patternsrY  ah]rY  X   al_load_samplerY  auKI}rY  (hX   50rY  h	X8   I do not believe al_load_sample returns an error messagerY  hX   ApizarY  h
X   72rY  hX   NEGrY  hX   INFORMrY  h]rY  X
   functionalityrY  ah]rY  X   al_load_samplerY  auKJ}rY  (hX   51rY  h	X!   possible errors in al_load_samplerY  hX
   ProgrammerrY  h
X   73rY  hX   FOLrY  hX
   ELICIT-INFORMrY  h]rY  X
   functionalityrY  ah]rY  X   al_load_samplerY  auKK}rY  (hX   52rY  h	X/   here is the source code for al_load_sample:\n\nrY  hX   ApizarY  h
X   74rY  hX   PARTrY  hX   INFORMrY  hNh]rY  X   al_load_samplerY  auKL}rY  (hX   52rY  h	X6  /* Function: al_load_sample\n */\nALLEGRO_SAMPLE *al_load_sample(const char *filename)\n{\n const char *ext;\n ACODEC_TABLE *ent;\n\n ASSERT(filename);\n ext = strrchr(filename, \'.\');\n if (ext == NULL) {\n ALLEGRO_ERROR("Unable to determine extension for %s.\\n", filename);\n return NULL;\n }\n\n ent = find_acodec_table_entry(ext);\n if (ent &amp;&amp; ent-&gt;loader) {\n return (ent-&gt;loader)(filename);\n }\n else {\n ALLEGRO_ERROR("No handler for audio file extension %s - "\n "therefore not trying to load %s.\\n", ext, filename);\n }\n\n return NULL;\n}rY  hX   ApizarY  h
X   75rY  hX   CONTrY  hX   INFORMrY  h]rY  (X
   functionalityrY  X   basicrY  eh]rY  X   al_load_samplerY  auKM}rY  (hX   53rY  h	X    How to set handler for wav file?rY  hX
   ProgrammerrY  h
NhNhX   ELICIT-OFFER-OR-SUGGESTIONrY  h]rY  X   patternsrY  ahNuKN}rY  (hX   54rY  h	X-   I am sorry, I do not understand your questionrY  hX   Apizar Z  h
X   77rZ  hX   UNCrZ  hX   COMMENT-ABOUT-UNDERSTANDINGrZ  hNhNuKO}rZ  (hX   55rZ  h	X   How to add acodec table entry?rZ  hX
   ProgrammerrZ  h
NhNhX   ELICIT-OFFER-OR-SUGGESTIONrZ  h]r	Z  X   patternsr
Z  ahNuKP}rZ  (hX   56rZ  h	X7   here is the declaration for add_acodec_table_entry:\n\nr
Z  hX   ApizarZ  h
X   79rZ  hX   POSrZ  hX   INFORMrZ  hNhNuKQ}rZ  (hX   56rZ  h	X<   static ACODEC_TABLE *add_acodec_table_entry(const char *ext)rZ  hX   ApizarZ  h
X   80rZ  hX   CONTrZ  hX   INFORMrZ  h]rZ  X   basicrZ  ahNuKR}rZ  (hX   57rZ  h	X   How to play audio file, rZ  hX
   ProgrammerrZ  h
NhNhX   ELICIT-OFFER-OR-SUGGESTIONrZ  h]r Z  X   patternsr!Z  ahNuKS}r"Z  (hX   57r#Z  h	X   example?r$Z  hX
   Programmerr%Z  h
X   82r&Z  hX   CONTr'Z  hX
   ELICIT-INFORMr(Z  h]r)Z  X   examplesr*Z  ahNuKT}r+Z  (hX   58r,Z  h	X   here is a rough example:\n\nr-Z  hX   Apizar.Z  h
X   83r/Z  hX   POSr0Z  hX   INFORMr1Z  hNhNuKU}r2Z  (hX   58r3Z  h	XT  ALLEGRO_SAMPLE *sample=NULL;\nif(!al_install_audio()){\n fprintf(stderr, "failed to initialize audio!\\n");\n return -1;\n}\nsample = al_load_sample( "footstep.wav" );\nif (!sample){\n printf( "Audio clip sample not loaded!\\n" );\n return -1;\n}\nal_play_sample(sample, 1.0, 0.0,1.0,ALLEGRO_PLAYMODE_LOOP,NULL);\nal_destroy_sample(sample);r4Z  hX   Apizar5Z  h
X   84r6Z  hX   CONTr7Z  hX   INFORMr8Z  h]r9Z  X   examplesr:Z  ahNuKV}r;Z  (hX   59r<Z  h	X%   How to enable ALLEGRO_ERROR messages?r=Z  hX
   Programmerr>Z  h
X   76r?Z  hX   FOLr@Z  hX   ELICIT-OFFER-OR-SUGGESTIONrAZ  h]rBZ  X   patternsrCZ  ahNuKW}rDZ  (hX   60rEZ  h	X   I am unsure,rFZ  hX   ApizarGZ  h
X   86rHZ  hX   UNCrIZ  hX   INFORMrJZ  hNhNuKX}rKZ  (hX   60rLZ  h	X"   they should be erroring by defaultrMZ  hX   ApizarNZ  h
X   86rOZ  hX   PARTrPZ  hX   INFORMrQZ  h]rRZ  X
   functionalityrSZ  ahNuKY}rTZ  (hX   61rUZ  h	X*   How to get ALLEGRO_ERROR messages printed?rVZ  hX
   ProgrammerrWZ  h
X   88rXZ  hX   FOLrYZ  hX   ELICIT-OFFER-OR-SUGGESTIONrZZ  h]r[Z  X   patternsr\Z  ahNuKZ}r]Z  (hX   62r^Z  h	X   I am unsurer_Z  hX   Apizar`Z  h
X   89raZ  hX   UNCrbZ  hX   INFORMrcZ  hNhNuK[}rdZ  (hX   63reZ  h	X$   How to enable debug mode for libraryrfZ  hX
   ProgrammerrgZ  h
NhNhX   ELICIT-OFFER-OR-SUGGESTIONrhZ  h]riZ  X   patternsrjZ  ahNuK\}rkZ  (hX   64rlZ  h	XI   I believe initializing allegro using al_init(void) will enable debug modermZ  hX   ApizarnZ  h
X   91roZ  hX   POSrpZ  hX   INFORMrqZ  h]rrZ  X
   functionalityrsZ  ah]rtZ  X   al_initruZ  auK]}rvZ  (hX   65rwZ  h	X(   I do not see error messages from libraryrxZ  hX
   ProgrammerryZ  h
NhNhX   INFORMrzZ  h]r{Z  X
   functionalityr|Z  ahNuK^}r}Z  (hX   65r~Z  h	X   how to fix it?rZ  hX
   ProgrammerrZ  h
X   93rZ  hX   CONTrZ  hX   ELICIT-OFFER-OR-SUGGESTIONrZ  h]rZ  X   patternsrZ  ahNuK_}rZ  (hX   66rZ  h	X   what do you see?rZ  hX   ApizarZ  h
X   94rZ  hX   FOLrZ  hX
   ELICIT-INFORMrZ  h]rZ  X
   functionalityrZ  ahNuK`}rZ  (hX   67rZ  h	X'   I want get error messages from library?rZ  hX
   ProgrammerrZ  h
X   95rZ  hX   NEGrZ  hX   INFORMrZ  h]rZ  X   patternsrZ  ahNuKa}rZ  (hX   68rZ  h	X   I am unsure,rZ  hX   ApizarZ  h
X   96rZ  hX   UNCrZ  hX   INFORMrZ  hNhNuKb}rZ  (hX   68rZ  h	X#   maybe they are not being triggered?rZ  hX   ApizarZ  h
X   96rZ  hX   PARTrZ  hX   INFORMrZ  h]rZ  X   controlrZ  ahNuKc}rZ  (hX   69rZ  h	X&   al_load_sample is not loading wav filerZ  hX
   ProgrammerrZ  h
NhNhX   INFORMrZ  h]rZ  X
   functionalityrZ  ah]rZ  X   al_load_samplerZ  auKd}rZ  (hX   70rZ  h	X5   is the file in the same directory as the source code?rZ  hX   ApizarZ  h
X   99rZ  hX   FOLrZ  hX
   ELICIT-INFORMrZ  h]rZ  X	   structurerZ  ah]rZ  X   al_load_samplerZ  auKe}rZ  (hX   71rZ  h	X   YesrZ  hX
   ProgrammerrZ  h
X   100rZ  hX   POSrZ  hX   INFORMrZ  hNh]rZ  X   al_load_samplerZ  auKf}rZ  (hX   72rZ  h	X#   what is al_load_sample() returning?rZ  hX   ApizarZ  h
X   101rZ  hX   FOLrZ  hX
   ELICIT-INFORMrZ  h]rZ  X
   functionalityrZ  ah]rZ  X   al_load_samplerZ  auKg}rZ  (hX   73rZ  h	X   NULLrZ  hX
   ProgrammerrZ  h
X   102rZ  hX   POSrZ  hX   INFORMrZ  h]rZ  X
   functionalityrZ  ah]rZ  X   al_load_samplerZ  auKh}rZ  (hX   74rZ  h	X6   is allegro initialized and the audio driver installed?rZ  hX   ApizarZ  h
X   103rZ  hX   FOLrZ  hX
   ELICIT-INFORMrZ  h]rZ  X   patternsrZ  ah]rZ  X   al_load_samplerZ  auKi}rZ  (hX   75rZ  h	X   How to install audio driver?rZ  hX
   ProgrammerrZ  h
X   104rZ  hX   FOLrZ  hX   ELICIT-OFFER-OR-SUGGESTIONrZ  h]rZ  X   patternsrZ  ahNuKj}rZ  (hX   76rZ  h	X$   function bool al_install_audio(void)rZ  hX   ApizarZ  h
X   105rZ  hX   POSrZ  hX   INFORMrZ  h]rZ  X   basicrZ  ah]rZ  X   al_install_audiorZ  auKk}rZ  (hX   77rZ  h	X2   allegro initialized and the audio driver installedrZ  hX
   ProgrammerrZ  h
NhNhX   INFORMrZ  h]rZ  X   patternsr [  ah]r[  X   al_load_sampler[  auKl}r[  (hX   77r[  h	X'   but al_load_sample cannot load wav filer[  hX
   Programmerr[  h
X   107r[  hX   CONTr[  hX   INFORMr	[  h]r
[  X
   functionalityr[  ah]r[  X   al_load_sampler
[  auKm}r[  (hX   78r[  h	X+   There are a few more steps that I can see: r[  hX   Apizar[  h
X   108r[  hX   POSr[  hX   INFORMr[  h]r[  X   patternsr[  ahNuKn}r[  (hX   78r[  h	X,   the first is to initialize the acodec table.r[  hX   Apizar[  h
X   109r[  hX   CONTr[  hX   SUGGESTr[  h]r[  X   patternsr[  ahNuKo}r [  (hX   78r![  h	X)    function bool al_init_acodec_addon(void)r"[  hX   Apizar#[  h
X   110r$[  hX   CONTr%[  hX   INFORMr&[  h]r'[  X   basicr([  ah]r)[  X   al_init_acodec_addonr*[  auuuK}r+[  (hj?>  h}r,[  (K }r-[  (hhh	X   Hellor.[  hX
   Programmerr/[  h
NhNhX   BE-POSITIVEr0[  hNhNuK}r1[  (hhh	X   Hello!r2[  hX   Apizar3[  h
hhX   POSr4[  hX   BE-POSITIVEr5[  hNhNuK}r6[  (hh+h	X#   Hey, how do I get key press events?r7[  hX
   Programmerr8[  h
NhNhX   ELICIT-OFFER-OR-SUGGESTIONr9[  h]r:[  X   patternsr;[  ahNuK}r<[  (hh5h	X,   Are you asking about the al_key_down method?r=[  hX   Apizar>[  h
hhX   POSr?[  hX
   ELICIT-INFORMr@[  h]rA[  X   basicrB[  ah]rC[  X   al_key_downrD[  auK}rE[  (hh<h	XS   This method returns true if the key specified was held down in the state specified.rF[  hX   ApizarG[  h
h+hX   CONTrH[  hX   INFORMrI[  h]rJ[  X
   functionalityrK[  ah]rL[  X   al_key_downrM[  auK}rN[  (hhFh	X5   I would like to know how to know if a key was pressedrO[  hX
   ProgrammerrP[  h
h5hX   FOLrQ[  hX
   ELICIT-INFORMrR[  h]rS[  X   patternsrT[  ahNuK}rU[  (hhQh	X3   can you give me details on how to use al_key_down ?rV[  hX
   ProgrammerrW[  h
h<hX   CONTrX[  hX
   ELICIT-INFORMrY[  h]rZ[  X   patternsr[[  ah]r\[  X   al_key_downr][  auK}r^[  (hhXh	XZ   The method signature is bool al_key_down(const ALLEGRO_KEYBOARD_STATE *state, int keycode)r_[  hX   Apizar`[  h
hFhX   POSra[  hX   INFORMrb[  h]rc[  X   basicrd[  ah]re[  X   al_key_downrf[  auK}rg[  (hhch	X4   Would you like to know about ALLEGRO_KEYBOARD_STATE?rh[  hX   Apizari[  h
hQhX   FOLrj[  hX
   ELICIT-INFORMrk[  h]rl[  X   basicrm[  ah]rn[  X   ALLEGRO_KEYBOARD_STATEro[  auK	}rp[  (hX   10rq[  h	X   yesrr[  hX
   Programmerrs[  h
hXhX   POSrt[  hX   INFORMru[  hNh]rv[  X   ALLEGRO_KEYBOARD_STATErw[  auK
}rx[  (hX   11ry[  h	Xf   This is a structure that is used to hold a "snapshot" of a keyboard\'s state at a particular instant. rz[  hX   Apizar{[  h
hchX   POSr|[  hX   INFORMr}[  h]r~[  X   purposer[  ah]r[  X   ALLEGRO_KEYBOARD_STATEr[  auK}r[  (hX   11r[  h	X   It contains the following publically readable fields: display - points to the display that had keyboard focus at the time the state was saved. If no display was focused, this points to NULL.r[  hX   Apizar[  h
X   10r[  hX   POSr[  hX   INFORMr[  h]r[  (X	   structurer[  X   conceptsr[  eh]r[  X   ALLEGRO_KEYBOARD_STATEr[  auK}r[  (hX   12r[  h	X&   how do I get a ALLEGRO_KEYBOARD_STATE?r[  hX
   Programmerr[  h
X   11r[  hX   FOLr[  hX   ELICIT-OFFER-OR-SUGGESTIONr[  h]r[  X   patternsr[  ah]r[  X   ALLEGRO_KEYBOARD_STATEr[  auK
}r[  (hX   13r[  h	X6   Are you asking about the method al_get_keyboard_state?r[  hX   Apizar[  h
X   12r[  hX   FOLr[  hX
   ELICIT-INFORMr[  h]r[  X   basicr[  ah]r[  X   al_get_keyboard_stater[  auK}r[  (hX   14r[  h	X   yesr[  hX
   Programmerr[  h
X   13r[  hX   POSr[  hX   INFORMr[  hNh]r[  X   al_get_keyboard_stater[  auK}r[  (hX   15r[  h	X   This method saves the state of the keyboard specified at the time the function is called into the structure pointed to by ret_state.r[  hX   Apizar[  h
X   14r[  hX   POSr[  hX   INFORMr[  h]r[  X
   functionalityr[  ah]r[  X   al_get_keyboard_stater[  auK}r[  (hX   16r[  h	X<   void al_get_keyboard_state(ALLEGRO_KEYBOARD_STATE *ret_stater[  hX   Apizar[  h
X   15r[  hX   CONTr[  hX   INFORMr[  h]r[  X   basicr[  ah]r[  X   al_get_keyboard_stater[  auK}r[  (hX   17r[  h	X(   what are the keycode for the arrow keys?r[  hX
   Programmerr[  h
NhNhX
   ELICIT-INFORMr[  h]r[  X	   structurer[  ahNuK}r[  (hX   18r[  h	X<   Are you asking about ALLEGRO_KEY_LEFT and ALLEGRO_KEY_RIGHT?r[  hX   Apizar[  h
X   17r[  hX   POSr[  hX
   ELICIT-INFORMr[  h]r[  X   basicr[  ahNuK}r[  (hX   19r[  h	X   yesr[  hX
   Programmerr[  h
X   18r[  hX   POSr[  hX   INFORMr[  hNhNuK}r[  (hX   20r[  h	X!   how do I initialize the keyboard?r[  hX
   Programmerr[  h
NhNhX   ELICIT-OFFER-OR-SUGGESTIONr[  h]r[  X   patternsr[  ahNuK}r[  (hX   21r[  h	X4   Are you asking about the method al_install_keyboard?r[  hX   Apizar[  h
X   20r[  hX   FOLr[  hX
   ELICIT-INFORMr[  h]r[  X   basicr[  ah]r[  X   al_install_keyboardr[  auK}r[  (hX   22r[  h	X   yesr[  hX
   Programmerr[  h
X   21r[  hX   POSr[  hX   INFORMr[  hNh]r[  X   al_install_keyboardr[  auK}r[  (hX   23r[  h	X'   The method installs a keyboard driver. r[  hX   Apizar[  h
X   22r[  hX   POSr[  hX   INFORMr[  h]r[  X
   functionalityr[  ah]r[  X   al_install_keyboardr[  auK}r \  (hX   23r\  h	Xd   Returns true if successful. If a driver was already installed, nothing happens and true is returned.r\  hX   Apizar\  h
X   23r\  hX   CONTr\  hX   INFORMr\  h]r\  X
   functionalityr\  ah]r	\  X   al_install_keyboardr
\  auK}r\  (hX   24r\  h	X   bool al_install_keyboard(void)r
\  hX   Apizar\  h
X   24r\  hX   CONTr\  hX   INFORMr\  h]r\  X   basicr\  ah]r\  X   al_install_keyboardr\  auK}r\  (hX   25r\  h	X   how do I play a sound ?r\  hX
   Programmerr\  h
NhNhX   ELICIT-OFFER-OR-SUGGESTIONr\  h]r\  X   patternsr\  ahNuK}r\  (hX   26r\  h	X-   Are you asking about al_play_sample_instance?r\  hX   Apizar \  h
X   26r!\  hX   FOLr"\  hX
   ELICIT-INFORMr#\  h]r$\  X   basicr%\  ah]r&\  X   al_play_sample_instancer'\  auK}r(\  (hX   27r)\  h	X   yesr*\  hX
   Programmerr+\  h
X   27r,\  hX   POSr-\  hX   INFORMr.\  hNh]r/\  X   al_play_sample_instancer0\  auK}r1\  (hX   28r2\  h	X&   The method plays the sample instance. r3\  hX   Apizar4\  h
X   28r5\  hX   POSr6\  hX   INFORMr7\  h]r8\  X
   functionalityr9\  ah]r:\  X   al_play_sample_instancer;\  auK}r<\  (hX   28r=\  h	X*   Returns true on success, false on failure.r>\  hX   Apizar?\  h
X   29r@\  hX   CONTrA\  hX   INFORMrB\  h]rC\  X
   functionalityrD\  ah]rE\  X   al_play_sample_instancerF\  auK}rG\  (hX   29rH\  h	X:   bool al_play_sample_instance(ALLEGRO_SAMPLE_INSTANCE *spl)rI\  hX   ApizarJ\  h
X   30rK\  hX   CONTrL\  hX   INFORMrM\  h]rN\  X   basicrO\  ah]rP\  X   al_play_sample_instancerQ\  auK }rR\  (hX   30rS\  h	X)   how do I get an ALLEGRO_SAMPLE_INSTANCE ?rT\  hX
   ProgrammerrU\  h
X   31rV\  hX   FOLrW\  hX   ELICIT-OFFER-OR-SUGGESTIONrX\  h]rY\  X   patternsrZ\  ah]r[\  X   ALLEGRO_SAMPLE_INSTANCEr\\  auK!}r]\  (hX   31r^\  h	X  An ALLEGRO_SAMPLE_INSTANCE object represents a playable instance of a predefined sound effect. It holds information about how the effect should be played: These playback parameters consist of the looping mode, loop start/end points, playing position, speed, gain, pan and the playmode. Whether a sample instance is currently playing or paused is also one of its properties.\n\nAn instance uses the data from an ALLEGRO_SAMPLE object. Multiple instances may be created from the same ALLEGRO_SAMPLE. An ALLEGRO_SAMPLE must not be destroyed while there are instances which reference it.\n\nTo actually produce audio output, an ALLEGRO_SAMPLE_INSTANCE must be attached to an ALLEGRO_MIXER which eventually reaches an ALLEGRO_VOICE object.r_\  hX   Apizar`\  h
X   32ra\  hX   PARTrb\  hX   INFORMrc\  h]rd\  (X   conceptsre\  X
   directivesrf\  X	   structurerg\  X   patternsrh\  eh]ri\  X   ALLEGRO_SAMPLE_INSTANCErj\  auK"}rk\  (hX   32rl\  h	X%   Are you interested in al_play_sample?rm\  hX   Apizarn\  h
X   33ro\  hX   FOLrp\  hX
   ELICIT-INFORMrq\  h]rr\  X   basicrs\  ah]rt\  X   al_play_sample_instanceru\  auK#}rv\  (hX   33rw\  h	X   yesrx\  hX
   Programmerry\  h
X   34rz\  hX   POSr{\  hX   INFORMr|\  hNh]r}\  X   al_play_sample_instancer~\  auK$}r\  (hX   34r\  h	XX   The method plays a sample on one of the sample instances created by al_reserve_samples. r\  hX   Apizar\  h
X   35r\  hX   POSr\  hX   INFORMr\  h]r\  X
   functionalityr\  ah]r\  X   al_play_sample_instancer\  auK%}r\  (hX   34r\  h	X+   Returns true on success, false on failure. r\  hX   Apizar\  h
X   36r\  hX   CONTr\  hX   INFORMr\  h]r\  X
   functionalityr\  ah]r\  X   al_play_sample_instancer\  auK&}r\  (hX   34r\  h	XO   Playback may fail because all the reserved sample instances are currently used.r\  hX   Apizar\  h
X   37r\  hX   CONTr\  hX   INFORMr\  h]r\  X
   functionalityr\  ah]r\  X   al_play_sample_instancer\  auK'}r\  (hX   35r\  h	X   bool al_play_sample(ALLEGRO_SAMPLE *spl, float gain, float pan, float speed,\n ALLEGRO_PLAYMODE loop, ALLEGRO_SAMPLE_ID *ret_id)r\  hX   Apizar\  h
X   38r\  hX   CONTr\  hX   INFORMr\  h]r\  X   basicr\  ah]r\  X   al_play_sample_instancer\  auK(}r\  (hX   36r\  h	X   how do I get an ALLEGRO_SAMPLEr\  hX
   Programmerr\  h
X   39r\  hX   FOLr\  hX   ELICIT-OFFER-OR-SUGGESTIONr\  h]r\  X   patternsr\  ah]r\  X   ALLEGRO_SAMPLEr\  auK)}r\  (hX   37r\  h	X(   Are you asking about al_get_sample_data?r\  hX   Apizar\  h
X   40r\  hX   FOLr\  hX
   ELICIT-INFORMr\  h]r\  X   basicr\  ah]r\  (X   al_get_sample_datar\  X   ALLEGRO_SAMPLEr\  euK*}r\  (hX   38r\  h	X   yesr\  hX
   Programmerr\  h
X   41r\  hX   POSr\  hX   INFORMr\  hNh]r\  X   al_get_sample_datar\  auK+}r\  (hX   39r\  h	X3   The method return a pointer to the raw sample data.r\  hX   Apizar\  h
X   42r\  hX   POSr\  hX   INFORMr\  h]r\  X
   functionalityr\  ah]r\  X   al_get_sample_datar\  auK,}r\  (hX   40r\  h	X3   void *al_get_sample_data(const ALLEGRO_SAMPLE *spl)r\  hX   Apizar\  h
X   43r\  hX   CONTr\  hX   INFORMr\  h]r\  X   basicr\  ah]r\  X   al_get_sample_datar\  auK-}r\  (hX   41r\  h	X$   how do I load a sample from a file ?r\  hX
   Programmerr\  h
X   44r\  hX   NEGr\  hX   ELICIT-OFFER-OR-SUGGESTIONr\  h]r\  X   patternsr\  ahNuK.}r\  (hX   42r\  h	X&   Are you asking about al_create_sample?r\  hX   Apizar\  h
X   45r\  hX   FOLr\  hX
   ELICIT-INFORMr\  h]r\  X   basicr\  ah]r\  X   al_create_sampler\  auK/}r\  (hX   43r\  h	X   yesr\  hX
   Programmerr\  h
X   46r\  hX   POSr\  hX   INFORMr\  hNh]r\  X   al_create_sampler\  auK0}r\  (hX   44r\  h	X@  The method creates a sample data structure from the supplied buffer. If free_buf is true then the buffer will be freed with al_free when the sample data structure is destroyed. For portability (especially Windows), the buffer should have been allocated with al_malloc. Otherwise you should free the sample data yourself.r ]  hX   Apizar]  h
X   47r]  hX   POSr]  hX   INFORMr]  h]r]  (X
   functionalityr]  X
   directivesr]  X   environmentr]  eh]r	]  X   al_create_sampler
]  auK1}r]  (hX   45r]  h	X   ALLEGRO_SAMPLE *al_create_sample(void *buf, unsigned int samples,\n unsigned int freq, ALLEGRO_AUDIO_DEPTH depth,\n ALLEGRO_CHANNEL_CONF chan_conf, bool free_buf)r
]  hX   Apizar]  h
X   48r]  hX   CONTr]  hX   INFORMr]  h]r]  X   basicr]  ah]r]  X   al_create_sampler]  auK2}r]  (hX   46r]  h	Xf  A sample that is referred to by the samples parameter refers to a sequence channel intensities. E.g. if you're making a stereo sample with the samples set to 4, then the layout of the data in buf will be: LRLRLRLR\nWhere L and R are the intensities for the left and right channels respectively. A single sample, then, refers to the LR pair in this example.\nr]  hX   Apizar]  h
X   49r]  hX   CONTr]  hX   INFORMr]  h]r]  (X   conceptsr]  X   patternsr]  eh]r ]  X   al_create_sampler!]  auK3}r"]  (hX   46r#]  h	X   To allocate a buffer of the correct size, you can use something like this:\nint sample_size = al_get_channel_count(chan_conf)\n * al_get_audio_depth_size(depth);\nint bytes = samples * sample_size;\nvoid *buffer = al_malloc(bytes);r$]  hX   Apizar%]  h
X   50r&]  hX   CONTr']  hX   INFORMr(]  h]r)]  X   examplesr*]  ah]r+]  X   al_create_sampler,]  auK4}r-]  (hX   47r.]  h	X   how to load a wav file?r/]  hX
   Programmerr0]  h
X   51r1]  hX   NEGr2]  hX   ELICIT-OFFER-OR-SUGGESTIONr3]  h]r4]  X   patternsr5]  ahNuK5}r6]  (hX   48r7]  h	X   I'm not sure I understandr8]  hX   Apizar9]  h
X   52r:]  hX   UNCr;]  hX   COMMENT-ABOUT-UNDERSTANDINGr<]  hNhNuK6}r=]  (hX   49r>]  h	X    how to load a sample from a wav?r?]  hX
   Programmerr@]  h
X   52rA]  hX   REPrB]  hX   ELICIT-OFFER-OR-SUGGESTIONrC]  h]rD]  X   patternsrE]  ahNuK7}rF]  (hX   50rG]  h	X#   Are you asking about al_get_sample?rH]  hX   ApizarI]  h
X   54rJ]  hX   FOLrK]  hX
   ELICIT-INFORMrL]  h]rM]  X   basicrN]  ah]rO]  X
   al_get_samplerP]  auK8}rQ]  (hX   51rR]  h	X   yesrS]  hX
   ProgrammerrT]  h
X   55rU]  hX   POSrV]  hX   INFORMrW]  hNh]rX]  X
   al_get_samplerY]  auK9}rZ]  (hX   52r[]  h	XD   The method returns the sample data that the sample instance plays.\nr\]  hX   Apizar]]  h
X   56r^]  hX   POSr_]  hX   INFORMr`]  h]ra]  X
   functionalityrb]  ah]rc]  X
   al_get_samplerd]  auK:}re]  (hX   52rf]  h	X]  Note this returns a pointer to an internal structure, not the ALLEGRO_SAMPLE that you may have passed to al_set_sample. However, the sample buffer of the returned ALLEGRO_SAMPLE will be the same as the one that was used to create the sample (passed to al_create_sample). You can use al_get_sample_data on the return value to retrieve and compare it.rg]  hX   Apizarh]  h
X   57ri]  hX   CONTrj]  hX   INFORMrk]  h]rl]  (X	   structurerm]  X   patternsrn]  eh]ro]  X
   al_get_samplerp]  auK;}rq]  (hX   53rr]  h	X;   ALLEGRO_SAMPLE *al_get_sample(ALLEGRO_SAMPLE_INSTANCE *spl)rs]  hX   Apizart]  h
X   58ru]  hX   CONTrv]  hX   INFORMrw]  h]rx]  X   basicry]  ah]rz]  X
   al_get_sampler{]  auK<}r|]  (hX   54r}]  h	X   how do I play a sound file ?r~]  hX
   Programmerr]  h
NhNhX   ELICIT-OFFER-OR-SUGGESTIONr]  h]r]  X   patternsr]  ahNuK=}r]  (hX   55r]  h	X$   Are you asking about al_play_sample?r]  hX   Apizar]  h
X   60r]  hX   FOLr]  hX
   ELICIT-INFORMr]  h]r]  X   basicr]  ah]r]  X   al_play_sampler]  auK>}r]  (hX   56r]  h	X   nor]  hX
   Programmerr]  h
X   61r]  hX   NEGr]  hX   INFORMr]  hNh]r]  X   al_play_sampler]  auK?}r]  (hX   57r]  h	X$   Are you asking about al_load_sample?r]  hX   Apizar]  h
X   62r]  hX   FOLr]  hX
   ELICIT-INFORMr]  h]r]  X   basicr]  ah]r]  X   al_load_sampler]  auK@}r]  (hX   58r]  h	X   yesr]  hX
   Programmerr]  h
X   63r]  hX   POSr]  hX   INFORMr]  hNh]r]  X   al_load_sampler]  auKA}r]  (hX   59r]  h	XO   The method loads a few different audio file formats based on their extension.\nr]  hX   Apizar]  h
X   64r]  hX   POSr]  hX   INFORMr]  h]r]  X
   functionalityr]  ah]r]  X   al_load_sampler]  auKB}r]  (hX   59r]  h	X   Note that this stores the entire file in memory at once, which may be time consuming. To read the file as it is needed, use al_load_audio_stream.\nr]  hX   Apizar]  h
X   65r]  hX   CONTr]  hX   INFORMr]  h]r]  (X   qualityr]  X   patternsr]  eh]r]  X   al_load_sampler]  auKC}r]  (hX   59r]  h	X/   Returns the sample on success, NULL on failure.r]  hX   Apizar]  h
X   66r]  hX   CONTr]  hX   INFORMr]  h]r]  X
   functionalityr]  ah]r]  X   al_load_sampler]  auKD}r]  (hX   60r]  h	X4   ALLEGRO_SAMPLE *al_load_sample(const char *filename)r]  hX   Apizar]  h
X   67r]  hX   CONTr]  hX   INFORMr]  h]r]  X   basicr]  ah]r]  X   al_load_sampler]  auKE}r]  (hX   61r]  h	X   how do I initialize audio?r]  hX
   Programmerr]  h
NhNhX   ELICIT-OFFER-OR-SUGGESTIONr]  h]r]  X   patternsr]  ahNuKF}r]  (hX   62r]  h	X*   Are you asking about al_init_acodec_addon?r]  hX   Apizar]  h
X   69r]  hX   FOLr]  hX
   ELICIT-INFORMr]  h]r]  X   basicr]  ah]r]  X   al_init_acodec_addonr]  auKG}r]  (hX   63r]  h	X   yesr]  hX
   Programmerr]  h
X   70r]  hX   POSr]  hX   INFORMr]  hNhNuKH}r]  (hX   64r]  h	Xz   The method registers all the known audio file type handlers for al_load_sample, al_save_sample, al_load_audio_stream, etc.r]  hX   Apizar]  h
X   71r]  hX   POSr]  hX   INFORMr]  h]r]  (X
   functionalityr]  X   patternsr]  ehNuKI}r]  (hX   65r]  h	X   bool al_init_acodec_addon(void)r]  hX   Apizar]  h
X   72r]  hX   CONTr ^  hX   INFORMr^  h]r^  X   basicr^  ahNuKJ}r^  (hX   66r^  h	X   why would al_load_sample crash?r^  hX
   Programmerr^  h
NhNhX
   ELICIT-INFORMr^  h]r	^  X
   functionalityr
^  ah]r^  X   al_load_sampler^  auKK}r
^  (hX   67r^  h	XM   the allegro_audio library does not support any audio file formats by default.r^  hX   Apizar^  h
X   74r^  hX   POSr^  hX   INFORMr^  h]r^  X
   directivesr^  ah]r^  X   al_load_sampler^  auKL}r^  (hX   67r^  h	XK   You must use the allegro_acodec addon, or register your own format handler.r^  hX   Apizar^  h
X   75r^  hX   CONTr^  hX   SUGGESTr^  h]r^  X
   directivesr ^  ah]r!^  (X   al_load_sampler"^  X   al_init_acodec_addonr#^  euKM}r$^  (hX   68r%^  h	X-   how do I initialize the allegro_acodec addon?r&^  hX
   Programmerr'^  h
X   76r(^  hX   FOLr)^  hX   ELICIT-OFFER-OR-SUGGESTIONr*^  h]r+^  X   patternsr,^  ahNuKN}r-^  (hX   69r.^  h	X*   Are you asking about al_init_acodec_addon?r/^  hX   Apizar0^  h
X   77r1^  hX   FOLr2^  hX
   ELICIT-INFORMr3^  h]r4^  X   basicr5^  ah]r6^  X   al_init_acodec_addonr7^  auKO}r8^  (hX   70r9^  h	X   yesr:^  hX
   Programmerr;^  h
X   78r<^  hX   POSr=^  hX   INFORMr>^  hNh]r?^  X   al_init_acodec_addonr@^  auKP}rA^  (hX   71rB^  h	X  The method registers all the known audio file type handlers for al_load_sample, al_save_sample, al_load_audio_stream, etc.\nDepending on what libraries are available, the full set of recognised extensions is: .wav, .flac, .ogg, .opus, .it, .mod, .s3m, .xm, .voc.rC^  hX   ApizarD^  h
X   79rE^  hX   POSrF^  hX   INFORMrG^  h]rH^  (X
   functionalityrI^  X
   directivesrJ^  X   purposerK^  eh]rL^  X   al_init_acodec_addonrM^  auKQ}rN^  (hX   72rO^  h	X7   Would you like to learn the limitations of this method?rP^  hX   ApizarQ^  h
X   80rR^  hX   FOLrS^  hX
   ELICIT-INFORMrT^  h]rU^  X
   directivesrV^  ah]rW^  X   al_init_acodec_addonrX^  auKR}rY^  (hX   73rZ^  h	X   yesr[^  hX
   Programmerr\^  h
X   81r]^  hX   POSr^^  hX   INFORMr_^  hNh]r`^  X   al_init_acodec_addonra^  auKS}rb^  (hX   74rc^  h	X-  Limitations:\n\nSaving is only supported for wav files.\n\nThe wav file loader currently only supports 8/16 bit little endian PCM files. 16 bits are used when saving wav files. Use flac files if more precision is required.\n\nModule files (.it, .mod, .s3m, .xm) are often composed with streaming in mind, and sometimes cannot be easily rendered into a finite length sample. Therefore they cannot be loaded with al_load_sample/al_load_sample_f and must be streamed with al_load_audio_stream or al_load_audio_stream_f.\n\n.voc file streaming is unimplemented.rd^  hX   Apizare^  h
X   82rf^  hX   POSrg^  hX   INFORMrh^  h]ri^  (X
   directivesrj^  X   purposerk^  eh]rl^  X   al_init_acodec_addonrm^  auKT}rn^  (hX   75ro^  h	X   tell me about ALLEGRO_PLAYMODErp^  hX
   Programmerrq^  h
X   39rr^  hX   FOLrs^  hX
   ELICIT-INFORMrt^  h]ru^  X   basicrv^  ah]rw^  X   ALLEGRO_PLAYMODErx^  auKU}ry^  (hX   76rz^  h	X$   Sample and stream playback mode.\n\nr{^  hX   Apizar|^  h
X   84r}^  hX   POSr~^  hX   INFORMr^  h]r^  X   conceptsr^  ah]r^  X   ALLEGRO_PLAYMODEr^  auKV}r^  (hX   76r^  h	XD   ALLEGRO_PLAYMODE_ONCE\nALLEGRO_PLAYMODE_LOOP\nALLEGRO_PLAYMODE_BIDIRr^  hX   Apizar^  h
X   85r^  hX   CONTr^  hX   INFORMr^  h]r^  X	   structurer^  ah]r^  X   ALLEGRO_PLAYMODEr^  auKW}r^  (hX   77r^  h	X!   tell me more about al_play_sampler^  hX
   Programmerr^  h
X   39r^  hX   FOLr^  hX
   ELICIT-INFORMr^  h]r^  X   basicr^  ah]r^  X   al_play_sampler^  auKX}r^  (hX   78r^  h	XX   The method plays a sample on one of the sample instances created by al_reserve_samples. r^  hX   Apizar^  h
X   87r^  hX   POSr^  hX   INFORMr^  h]r^  X
   functionalityr^  ah]r^  X   al_play_sampler^  auKY}r^  (hX   78r^  h	X*   Returns true on success, false on failure.r^  hX   Apizar^  h
X   88r^  hX   CONTr^  hX   INFORMr^  h]r^  X
   functionalityr^  ah]r^  X   al_play_sampler^  auKZ}r^  (hX   78r^  h	XO   Playback may fail because all the reserved sample instances are currently used.r^  hX   Apizar^  h
X   89r^  hX   CONTr^  hX   INFORMr^  h]r^  X
   functionalityr^  ah]r^  X   al_play_sampler^  auK[}r^  (hX   79r^  h	X   bool al_play_sample(ALLEGRO_SAMPLE *spl, float gain, float pan, float speed,\n ALLEGRO_PLAYMODE loop, ALLEGRO_SAMPLE_ID *ret_id)r^  hX   Apizar^  h
X   90r^  hX   CONTr^  hX   INFORMr^  h]r^  X   basicr^  ah]r^  X   al_play_sampler^  auK\}r^  (hX   80r^  h	X%   tell me more about al_reserve_samplesr^  hX
   Programmerr^  h
X   88r^  hX   FOLr^  hX
   ELICIT-INFORMr^  h]r^  X   basicr^  ah]r^  X   al_reserve_samplesr^  auK]}r^  (hX   81r^  h	X  The method reserves a number of sample instances, attaching them to the default mixer. If no default mixer is set when this function is called, then it will create one and attach it to the default voice. If no default voice has been set, it, too, will be created.\nIf you call this function a second time with a smaller number of samples, then the excess internal sample instances will be destroyed causing some sounds to stop and some instances returned by al_lock_sample_id to be invalidated.r^  hX   Apizar^  h
X   92r^  hX   POSr^  hX   INFORMr^  h]r^  (X
   functionalityr^  X   controlr^  X   patternsr^  eh]r^  X   al_reserve_samplesr^  auK^}r^  (hX   82r^  h	X,   bool al_reserve_samples(int reserve_samples)r^  hX   Apizar^  h
X   93r^  hX   CONTr^  hX   INFORMr^  h]r^  X   basicr^  ah]r^  X   al_reserve_samplesr^  auK_}r^  (hX   83r^  h	X   how do I draw text?r^  hX
   Programmerr^  h
NhNhX   ELICIT-OFFER-OR-SUGGESTIONr^  h]r^  X   patternsr^  ahNuK`}r^  (hX   84r^  h	X"   Are you asking about al_draw_text?r^  hX   Apizar^  h
X   95r^  hX   FOLr^  hX
   ELICIT-INFORMr^  h]r^  X   basicr^  ah]r^  X   al_draw_textr^  auKa}r^  (hX   85r^  h	X   yesr^  hX
   Programmerr^  h
X   96r^  hX   POSr _  hX   INFORMr_  hNh]r_  X   al_draw_textr_  auKb}r_  (hX   86r_  h	Xu   The method writes the NUL-terminated string text onto the target bitmap at position x, y, using the specified font.\nr_  hX   Apizar_  h
X   97r_  hX   POSr	_  hX   INFORMr
_  h]r_  X
   functionalityr_  ah]r
_  X   al_draw_textr_  auKc}r_  (hX   86r_  h	X  The flags parameter can be 0 or one of the following flags:\n\t•\tALLEGRO_ALIGN_LEFT - Draw the text left-aligned (same as 0).\n\t•\tALLEGRO_ALIGN_CENTRE - Draw the text centered around the given position.\n\t•\tALLEGRO_ALIGN_RIGHT - Draw the text right-aligned to the given position.\nIt can also be combined with this flag:\n\t•\tALLEGRO_ALIGN_INTEGER - Always draw text aligned to an integer pixel position. This was formerly the default behaviour. Since: 5.0.8, 5.1.4\nr_  hX   Apizar_  h
X   98r_  hX   CONTr_  hX   INFORMr_  h]r_  (X
   directivesr_  X   patternsr_  X   environmentr_  eh]r_  X   al_draw_textr_  auKd}r_  (hX   86r_  h	X{   This function does not support newline characters (\\n), but you can use al_draw_multiline_text for multi line text output.r_  hX   Apizar_  h
X   99r _  hX   CONTr!_  hX   INFORMr"_  h]r#_  (X
   directivesr$_  X   patternsr%_  eh]r&_  X   al_draw_textr'_  auKe}r(_  (hX   87r)_  h	Xs   void al_draw_text(const ALLEGRO_FONT *font,\n ALLEGRO_COLOR color, float x, float y, int flags,\n char const *text)r*_  hX   Apizar+_  h
X   100r,_  hX   CONTr-_  hX   INFORMr._  h]r/_  X   basicr0_  ah]r1_  X   al_draw_textr2_  auKf}r3_  (hX   88r4_  h	X   how do I load a font?r5_  hX
   Programmerr6_  h
NhNhX   ELICIT-OFFER-OR-SUGGESTIONr7_  h]r8_  X   patternsr9_  ahNuKg}r:_  (hX   89r;_  h	X"   Are you asking about al_load_font?r<_  hX   Apizar=_  h
X   102r>_  hX   FOLr?_  hX
   ELICIT-INFORMr@_  h]rA_  X   basicrB_  ah]rC_  X   al_load_fontrD_  auKh}rE_  (hX   90rF_  h	X   yesrG_  hX
   ProgrammerrH_  h
X   103rI_  hX   POSrJ_  hX   INFORMrK_  hNh]rL_  X   al_load_fontrM_  auKi}rN_  (hX   91rO_  h	X:  The method loads a font from disk. This will use al_load_bitmap_font_flagsif you pass the name of a known bitmap format, or else al_load_ttf_font.\nThe flags parameter is passed through to either of those functions. Bitmap and TTF fonts are also affected by the current bitmap flags at the time the font is loaded.rP_  hX   ApizarQ_  h
X   104rR_  hX   POSrS_  hX   INFORMrT_  h]rU_  (X
   functionalityrV_  X   controlrW_  eh]rX_  X   al_load_fontrY_  auKj}rZ_  (hX   92r[_  h	XE   ALLEGRO_FONT *al_load_font(char const *filename, int size, int flags)r\_  hX   Apizar]_  h
X   105r^_  hX   CONTr__  hX   INFORMr`_  h]ra_  X   basicrb_  ah]rc_  X   al_load_fontrd_  auKk}re_  (hX   93rf_  h	X   tell me about al_load_ttf_fontrg_  hX
   Programmerrh_  h
X   105ri_  hX   FOLrj_  hX
   ELICIT-INFORMrk_  h]rl_  X   basicrm_  ah]rn_  X   al_load_ttf_fontro_  auKl}rp_  (hX   94rq_  h	X  The method loads a TrueType font from a file using the FreeType library. Quoting from the FreeType FAQ this means support for many different font formats:\nTrueType, OpenType, Type1, CID, CFF, Windows FON/FNT, X11 PCF, and others\nThe size parameter determines the size the font will be rendered at, specified in pixels. The standard font size is measured in units per EM, if you instead want to specify the size as the total height of glyphs in pixels, pass it as a negative value.rr_  hX   Apizars_  h
X   107rt_  hX   POSru_  hX   INFORMrv_  h]rw_  (X
   functionalityrx_  X   patternsry_  eh]rz_  X   al_load_ttf_fontr{_  auKm}r|_  (hX   95r}_  h	XI   ALLEGRO_FONT *al_load_ttf_font(char const *filename, int size, int flags)r~_  hX   Apizar_  h
X   108r_  hX   CONTr_  hX   INFORMr_  h]r_  X   basicr_  ah]r_  X   al_load_ttf_fontr_  auKn}r_  (hX   96r_  h	X.   what's the flags parameter in al_load_ttf_fontr_  hX
   Programmerr_  h
X   109r_  hX   FOLr_  hX
   ELICIT-INFORMr_  h]r_  X
   functionalityr_  ah]r_  X   al_load_ttf_fontr_  auKo}r_  (hX   97r_  h	Xf  The following flags are supported:\n\nALLEGRO_TTF_NO_KERNING - Do not use any kerning even if the font file supports it.\n\nALLEGRO_TTF_MONOCHROME - Load as a monochrome font (which means no anti-aliasing of the font is done).\n\nALLEGRO_TTF_NO_AUTOHINT - Disable the Auto Hinter which is enabled by default in newer versions of FreeType. Since: 5.0.6, 5.1.2r_  hX   Apizar_  h
X   110r_  hX   POSr_  hX   INFORMr_  h]r_  (X   patternsr_  X
   directivesr_  eh]r_  X   al_load_ttf_fontr_  auKp}r_  (hX   98r_  h	X   how do I initialize fonts?r_  hX
   Programmerr_  h
NhNhX   ELICIT-OFFER-OR-SUGGESTIONr_  h]r_  X   patternsr_  ahNuKq}r_  (hX   99r_  h	X(   Are you asking about al_init_font_addon?r_  hX   Apizar_  h
X   112r_  hX   FOLr_  hX
   ELICIT-INFORMr_  h]r_  X   basicr_  ah]r_  X   al_init_font_addonr_  auKr}r_  (hX   100r_  h	X   yesr_  hX
   Programmerr_  h
X   113r_  hX   POSr_  hX   INFORMr_  hNh]r_  X   al_init_font_addonr_  auKs}r_  (hX   101r_  h	X(   The method initialises the font addon.\nr_  hX   Apizar_  h
X   114r_  hX   POSr_  hX   INFORMr_  h]r_  X   basicr_  ah]r_  X   al_init_font_addonr_  auKt}r_  (hX   101r_  h	X   Note that if you intend to load bitmap fonts, you will need to initialise allegro_image separately (unless you are using another library to load images).\nSimilarly, if you wish to load truetype-fonts, do not forget to also call al_init_ttf_addon.\nr_  hX   Apizar_  h
X   115r_  hX   CONTr_  hX   INFORMr_  h]r_  X   patternsr_  ah]r_  X   al_init_font_addonr_  auKu}r_  (hX   101r_  h	X+   Returns true on success, false on failure. r_  hX   Apizar_  h
X   116r_  hX   CONTr_  hX   INFORMr_  h]r_  X
   functionalityr_  ah]r_  X   al_init_font_addonr_  auKv}r_  (hX   101r_  h	X   On the 5.0 branch, this function has no return value. You may wish to avoid checking the return value if your code needs to be compatible with Allegro 5.0. Currently, the function will never return false.r_  hX   Apizar_  h
X   117r_  hX   CONTr_  hX   INFORMr_  h]r_  (X
   functionalityr_  X   patternsr_  X   environmentr_  eh]r_  X   al_init_font_addonr_  auKw}r_  (hX   102r_  h	X   bool al_init_font_addon(void)r_  hX   Apizar_  h
X   118r_  hX   CONTr_  hX   INFORMr_  h]r_  X   basicr_  ah]r_  X   al_init_font_addonr_  auKx}r_  (hX   103r_  h	X   how do I load png?r_  hX
   Programmerr_  h
NhNhX   ELICIT-OFFER-OR-SUGGESTIONr_  h]r_  X   patternsr_  ahNuKy}r_  (hX   104r_  h	X$   Are you asking about al_load_bitmap?r_  hX   Apizar_  h
X   120r_  hX   FOLr_  hX
   ELICIT-INFORMr_  h]r `  X   basicr`  ah]r`  X   al_load_bitmapr`  auKz}r`  (hX   105r`  h	X   yesr`  hX
   Programmerr`  h
X   121r`  hX   POSr	`  hX   INFORMr
`  hNh]r`  X   al_load_bitmapr`  auK{}r
`  (hX   106r`  h	X   The method loads an image file into a new ALLEGRO_BITMAP. The file type is determined by the extension, except if the file has no extension in which case al_identify_bitmap is used instead.\nr`  hX   Apizar`  h
X   122r`  hX   POSr`  hX   INFORMr`  h]r`  (X
   functionalityr`  X   controlr`  X	   structurer`  eh]r`  X   al_load_bitmapr`  auK|}r`  (hX   106r`  h	X   Returns NULL on error.\nr`  hX   Apizar`  h
X   123r`  hX   CONTr`  hX   INFORMr `  h]r!`  X
   functionalityr"`  ah]r#`  X   al_load_bitmapr$`  auK}}r%`  (hX   106r&`  h	XM   This is the same as calling al_load_bitmap_flags with a flags parameter of 0.r'`  hX   Apizar(`  h
X   124r)`  hX   CONTr*`  hX   INFORMr+`  h]r,`  X	   structurer-`  ah]r.`  X   al_load_bitmapr/`  auK~}r0`  (hX   107r1`  h	X4   ALLEGRO_BITMAP *al_load_bitmap(const char *filename)r2`  hX   Apizar3`  h
X   125r4`  hX   CONTr5`  hX   INFORMr6`  h]r7`  X   basicr8`  ah]r9`  X   al_load_bitmapr:`  auK}r;`  (hX   108r<`  h	X!   how do I initialize image loadersr=`  hX
   Programmerr>`  h
NhNhX   ELICIT-OFFER-OR-SUGGESTIONr?`  h]r@`  X   patternsrA`  ahNuK}rB`  (hX   109rC`  h	X/   Are you asking about al_register_bitmap_loader?rD`  hX   ApizarE`  h
X   127rF`  hX   FOLrG`  hX
   ELICIT-INFORMrH`  h]rI`  X   basicrJ`  ah]rK`  X   al_register_bitmap_loaderrL`  auK}rM`  (hX   110rN`  h	X   yesrO`  hX
   ProgrammerrP`  h
X   128rQ`  hX   POSrR`  hX   INFORMrS`  hNh]rT`  X   al_register_bitmap_loaderrU`  auK}rV`  (hX   111rW`  h	X4  The method registers a handler for al_load_bitmap. The given function will be used to handle the loading of bitmaps files with the given extension.\nThe extension should include the leading dot ('.') character. It will be matched case-insensitively.\nThe loader argument may be NULL to unregister an entry.\nrX`  hX   ApizarY`  h
X   129rZ`  hX   CONTr[`  hX   INFORMr\`  h]r]`  (X
   functionalityr^`  X
   directivesr_`  X   patternsr``  eh]ra`  X   al_register_bitmap_loaderrb`  auK}rc`  (hX   111rd`  h	Xd   Returns true on success, false on error. Returns false if unregistering an entry that doesn't exist.re`  hX   Apizarf`  h
X   130rg`  hX   CONTrh`  hX   INFORMri`  h]rj`  X
   functionalityrk`  ah]rl`  X   al_register_bitmap_loaderrm`  auK}rn`  (hX   112ro`  h	Xs   bool al_register_bitmap_loader(const char *extension,\n ALLEGRO_BITMAP *(*loader)(const char *filename, int flags))rp`  hX   Apizarq`  h
X   131rr`  hX   CONTrs`  hX   INFORMrt`  h]ru`  X   basicrv`  ah]rw`  X   al_register_bitmap_loaderrx`  auK}ry`  (hX   113rz`  h	X   initialize image addon?r{`  hX
   Programmerr|`  h
NhNhX   ELICIT-OFFER-OR-SUGGESTIONr}`  h]r~`  X   patternsr`  ahNuK}r`  (hX   114r`  h	X)   Are you asking about al_init_image_addon?r`  hX   Apizar`  h
X   133r`  hX   FOLr`  hX
   ELICIT-INFORMr`  h]r`  X   basicr`  ah]r`  X   al_init_image_addonr`  auK}r`  (hX   115r`  h	X   yesr`  hX
   Programmerr`  h
X   134r`  hX   POSr`  hX   INFORMr`  hNh]r`  X   al_init_image_addonr`  auK}r`  (hX   116r`  h	X~  The method initializes the image addon. This registers bitmap format handlers for al_load_bitmap, al_load_bitmap_f, al_save_bitmap, al_save_bitmap_f.\nThe following types are built into the Allegro image addon and guaranteed to be available: BMP, DDS, PCX, TGA. Every platform also supports JPEG and PNG via external dependencies.\nOther formats may be available depending on the operating system and installed libraries, but are not guaranteed and should not be assumed to be universally available.\nThe DDS format is only supported to load from, and only if the DDS file contains textures compressed in the DXT1, DXT3 and DXT5 formats. r`  hX   Apizar`  h
X   135r`  hX   POSr`  hX   INFORMr`  h]r`  (X
   functionalityr`  X
   directivesr`  X   patternsr`  X   environmentr`  eh]r`  X   al_init_image_addonr`  auK}r`  (hX   116r`  h	X   Note that when loading a DDS file, the created bitmap will always be a video bitmap and will have the pixel format matching the format in the file.r`  hX   Apizar`  h
X   136r`  hX   CONTr`  hX   INFORMr`  h]r`  X
   functionalityr`  ah]r`  X   al_init_image_addonr`  auK}r`  (hX   117r`  h	X   bool al_init_image_addon(void)r`  hX   Apizar`  h
X   137r`  hX   CONTr`  hX   INFORMr`  h]r`  X   basicr`  ah]r`  X   al_init_image_addonr`  auK}r`  (hX   118r`  h	X   how to scale a bitmap?r`  hX
   Programmerr`  h
NhNhX   ELICIT-OFFER-OR-SUGGESTIONr`  h]r`  X   patternsr`  ahNuK}r`  (hX   119r`  h	X+   Are you asking about al_draw_scaled_bitmap?r`  hX   Apizar`  h
X   139r`  hX   FOLr`  hX
   ELICIT-INFORMr`  h]r`  X   basicr`  ah]r`  X   al_draw_scaled_bitmapr`  auK}r`  (hX   120r`  h	X   yesr`  hX
   Programmerr`  h
X   140r`  hX   POSr`  hX   INFORMr`  hNh]r`  X   al_draw_scaled_bitmapr`  auK}r`  (hX   121r`  h	XM   The method draws a scaled version of the given bitmap to the target bitmap.\nr`  hX   Apizar`  h
X   141r`  hX   CONTr`  hX   INFORMr`  h]r`  X
   functionalityr`  ah]r`  X   al_draw_scaled_bitmapr`  auK}r`  (hX   121r`  h	X  \t•\tsx - source x\n\t•\tsy - source y\n\t•\tsw - source width\n\t•\tsh - source height\n\t•\tdx - destination x\n\t•\tdy - destination y\n\t•\tdw - destination width\n\t•\tdh - destination height\n\t•\tflags - same as for al_draw_bitmap\nr`  hX   Apizar`  h
X   142r`  hX   CONTr`  hX   INFORMr`  h]r`  X
   functionalityr`  ah]r`  X   al_draw_scaled_bitmapr`  auK}r`  (hX   121r`  h	XR   See al_draw_bitmap for a note on restrictions on which bitmaps can be drawn where.r`  hX   Apizar`  h
X   143r`  hX   CONTr`  hX   INFORMr`  hNh]r`  X   al_draw_scaled_bitmapr`  auK}r`  (hX   122r`  h	X   void al_draw_scaled_bitmap(ALLEGRO_BITMAP *bitmap,\n float sx, float sy, float sw, float sh,\n float dx, float dy, float dw, float dh, int flags)r`  hX   Apizar`  h
X   144r`  hX   CONTr`  hX   INFORMr`  h]r`  X   basicr`  ah]r`  X   al_draw_scaled_bitmapr`  auK}r`  (hX   123r`  h	X   rotate a bitmap?r`  hX
   Programmerr a  h
NhNhX   ELICIT-OFFER-OR-SUGGESTIONra  h]ra  X   patternsra  ahNuK}ra  (hX   124ra  h	X,   Are you asking about al_draw_rotated_bitmap?ra  hX   Apizara  h
X   146ra  hX   FOLr	a  hX
   ELICIT-INFORMr
a  h]ra  X   basicra  ah]r
a  X   al_draw_rotated_bitmapra  auK}ra  (hX   125ra  h	X   yesra  hX
   Programmerra  h
X   147ra  hX   POSra  hX   INFORMra  hNh]ra  X   al_draw_rotated_bitmapra  auK}ra  (hX   126ra  h	XO  The method draws a rotated version of the given bitmap to the target bitmap. The bitmap is rotated by 'angle' radians clockwise.\nThe point at cx/cy relative to the upper left corner of the bitmap will be drawn at dx/dy and the bitmap is rotated around this point. If cx,cy is 0,0 the bitmap will rotate around its upper left corner.\nra  hX   Apizara  h
X   148ra  hX   POSra  hX   INFORMra  h]ra  (X
   functionalityr a  X   patternsr!a  eh]r"a  X   al_draw_rotated_bitmapr#a  auK}r$a  (hX   126r%a  h	X   \t•\tcx - center x (relative to the bitmap)\n\t•\tcy - center y (relative to the bitmap)\n\t•\tdx - destination x\n\t•\tdy - destination y\n\t•\tangle - angle by which to rotate (radians)\n\t•\tflags - same as for al_draw_bitmapr&a  hX   Apizar'a  h
X   149r(a  hX   CONTr)a  hX   INFORMr*a  h]r+a  X
   functionalityr,a  ah]r-a  X   al_draw_rotated_bitmapr.a  auK}r/a  (hX   127r0a  h	Xu   void al_draw_rotated_bitmap(ALLEGRO_BITMAP *bitmap,\n float cx, float cy, float dx, float dy, float angle, int flags)r1a  hX   Apizar2a  h
X   150r3a  hX   CONTr4a  hX   INFORMr5a  h]r6a  X   basicr7a  ah]r8a  X   al_draw_rotated_bitmapr9a  auuuK}r:a  (hj?>  h}r;a  (K }r<a  (hhh	X   heyr=a  hX
   Programmerr>a  h
NhNhX   BE-POSITIVEr?a  hNhNuK}r@a  (hhh	X   Hello!rAa  hX   ApizarBa  h
hhX   POSrCa  hX   BE-POSITIVErDa  hNhNuK}rEa  (hh+h	X'   How can I see if the user pressed a keyrFa  hX
   ProgrammerrGa  h
NhNhX   ELICIT-OFFER-OR-SUGGESTIONrHa  h]rIa  X   patternsrJa  ahNuK}rKa  (hh5h	X!   Are you asking about al_key_down?rLa  hX   ApizarMa  h
hhX   FOLrNa  hX
   ELICIT-INFORMrOa  h]rPa  X   basicrQa  ah]rRa  X   al_key_downrSa  auK}rTa  (hh<h	X   yesrUa  hX
   ProgrammerrVa  h
h+hX   POSrWa  hX   INFORMrXa  hNh]rYa  X   al_key_downrZa  auK}r[a  (hhFh	X$   also what does al_wait_for_event do?r\a  hX
   Programmerr]a  h
NhNhX
   ELICIT-INFORMr^a  h]r_a  X
   functionalityr`a  ah]raa  X   al_wait_for_eventrba  auK}rca  (hhQh	X   what arguments does it take rda  hX
   Programmerrea  h
h<hX   CONTrfa  hX
   ELICIT-INFORMrga  h]rha  X   basicria  ah]rja  X   al_wait_for_eventrka  auK}rla  (hhQh	X   and what does it returnrma  hX
   Programmerrna  h
hFhX   CONTroa  hX
   ELICIT-INFORMrpa  h]rqa  X   basicrra  ah]rsa  X   al_wait_for_eventrta  auK}rua  (hhXh	XS   al_key_down returns true if the key specified was held down in the state specified.rva  hX   Apizarwa  h
h5hX   POSrxa  hX   INFORMrya  h]rza  X
   functionalityr{a  ah]r|a  X   al_key_downr}a  auK	}r~a  (hhch	XB   bool al_key_down(const ALLEGRO_KEYBOARD_STATE *state, int keycode)ra  hX   Apizara  h
hXhX   CONTra  hX   INFORMra  h]ra  X   basicra  ah]ra  X   al_key_downra  auK
}ra  (hX   10ra  h	X=   what are the keycodes for up, down, left, and right arrowkeysra  hX
   Programmerra  h
hchX   FOLra  hX
   ELICIT-INFORMra  h]ra  X	   structurera  ahNuK}ra  (hX   11ra  h	X   al_wait_for_event waits until the event queue specified is non-empty. If ret_eventis not NULL, the first event in the queue will be copied into ret_event and removed from the queue. If ret_event is NULL the first event is left at the head of the queue.ra  hX   Apizara  h
h<hX   POSra  hX   INFORMra  h]ra  (X
   functionalityra  X   controlra  eh]ra  X   al_wait_for_eventra  auK}ra  (hX   12ra  h	XL   void al_wait_for_event(ALLEGRO_EVENT_QUEUE *queue, ALLEGRO_EVENT *ret_event)ra  hX   Apizara  h
X   11ra  hX   CONTra  hX   INFORMra  h]ra  X   basicra  ah]ra  X   al_wait_for_eventra  auK
}ra  (hX   13ra  h	XE   ALLEGRO_KEY_LEFT, ALLEGRO_KEY_RIGHT, ALLEGRO_KEY_UP, ALLEGRO_KEY_DOWNra  hX   Apizara  h
X   10ra  hX   POSra  hX   INFORMra  h]ra  X	   structurera  ahNuK}ra  (hX   14ra  h	XN   when a user presses a key, is a corresponding event placed in the event queue?ra  hX
   Programmerra  h
NhNhX
   ELICIT-INFORMra  h]ra  X   controlra  ah]ra  X   ALLEGRO_EVENT_QUEUEra  auK}ra  (hX   15ra  h	X   I believe sora  hX   Apizara  h
X   14ra  hX   POSra  hX   INFORMra  h]ra  X   controlra  ah]ra  X   ALLEGRO_EVENT_QUEUEra  auK}ra  (hX   16ra  h	X+   Well I'll do an experiment and let you knowra  hX
   Programmerra  h
X   15ra  hX   POSra  hX   OFFERra  hNh]ra  X   ALLEGRO_EVENT_QUEUEra  auK}ra  (hX   16ra  h	X   :slightly_smiling_face:ra  hX
   Programmerra  h
X   16ra  hX   CONTra  hX   BE-POSITIVEra  hNhNuK}ra  (hX   17ra  h	X,   what states can allegro_keyboard_state be inra  hX
   Programmerra  h
hchX   FOLra  hX
   ELICIT-INFORMra  h]ra  X	   structurera  ah]ra  X   ALLEGRO_KEYBOARD_STATEra  auK}ra  (hX   18ra  h	Xx   ALLEGRO_KEYBOARD_STATE is a structure that is used to hold a "snapshot" of a keyboard\'s state at a particular instant. ra  hX   Apizara  h
X   18ra  hX   POSra  hX   INFORMra  h]ra  (X   basicra  X   purposera  eh]ra  X   ALLEGRO_KEYBOARD_STATEra  auK}ra  (hX   18ra  h	X   It contains the following publically readable fields: display - points to the display that had keyboard focus at the time the state was saved. If no display was focused, this points to NULL.\nra  hX   Apizara  h
X   19ra  hX   CONTra  hX   INFORMra  h]ra  (X	   structurera  X   conceptsra  X
   functionalityra  eh]ra  X   ALLEGRO_KEYBOARD_STATEra  auK}ra  (hX   18ra  h	XI   You cannot read the state of keys directly. Use the function al_key_down.ra  hX   Apizara  h
X   20ra  hX   CONTra  hX   INFORMra  h]ra  (X
   functionalityra  X   patternsra  eh]ra  (X   ALLEGRO_KEYBOARD_STATEr b  X   al_key_downrb  euK}rb  (hX   19rb  h	X%   what's the event type for a key pressrb  hX
   Programmerrb  h
NhNhX
   ELICIT-INFORMrb  h]rb  X	   structurerb  ahNuK}r	b  (hX   20r
b  h	X2   Are you asking about al_get_keyboard_event_source?rb  hX   Apizarb  h
X   22r
b  hX   FOLrb  hX
   ELICIT-INFORMrb  h]rb  X   basicrb  ah]rb  X   al_get_keyboard_event_sourcerb  auK}rb  (hX   21rb  h	X   I don't know. rb  hX
   Programmerrb  h
X   23rb  hX   UNCrb  hX   INFORMrb  hNhNuK}rb  (hX   21rb  h	X   What does that do?rb  hX
   Programmerrb  h
X   23rb  hX   FOLr b  hX
   ELICIT-INFORMr!b  h]r"b  X
   functionalityr#b  ah]r$b  X   al_get_keyboard_event_sourcer%b  auK}r&b  (hX   22r'b  h	Xi   The method retrieves the keyboard event source. All keyboard events are generated by this event source.\nr(b  hX   Apizar)b  h
X   25r*b  hX   POSr+b  hX   INFORMr,b  h]r-b  (X
   functionalityr.b  X   controlr/b  eh]r0b  X   al_get_keyboard_event_sourcer1b  auK}r2b  (hX   22r3b  h	X9   Returns NULL if the keyboard subsystem was not installed.r4b  hX   Apizar5b  h
X   26r6b  hX   CONTr7b  hX   INFORMr8b  h]r9b  (X
   functionalityr:b  X   controlr;b  eh]r<b  X   al_get_keyboard_event_sourcer=b  auK}r>b  (hX   23r?b  h	X8   ALLEGRO_EVENT_SOURCE *al_get_keyboard_event_source(void)r@b  hX   ApizarAb  h
X   27rBb  hX   CONTrCb  hX   INFORMrDb  h]rEb  X   basicrFb  ah]rGb  X   al_get_keyboard_event_sourcerHb  auK}rIb  (hX   24rJb  h	X&   what is the keyboard event type calledrKb  hX
   ProgrammerrLb  h
X   28rMb  hX   NEGrNb  hX
   ELICIT-INFORMrOb  h]rPb  X   basicrQb  ahNuK}rRb  (hX   25rSb  h	X*   Are you asking about one of the following?rTb  hX   ApizarUb  h
X   29rVb  hX   FOLrWb  hX
   ELICIT-INFORMrXb  h]rYb  X   basicrZb  ahNuK}r[b  (hX   25r\b  h	XD   ALLEGRO_EVENT_KEY_DOWN, ALLEGRO_EVENT_KEY_UP, ALLEGRO_EVENT_KEY_CHARr]b  hX   Apizar^b  h
X   30r_b  hX   CONTr`b  hX   INFORMrab  h]rbb  X   basicrcb  ahNuK }rdb  (hX   26reb  h	X   what is ALLEGRO_EVENT_KEY_LEFTrfb  hX
   Programmerrgb  h
X   31rhb  hX   FOLrib  hX
   ELICIT-INFORMrjb  h]rkb  X   basicrlb  ahNuK!}rmb  (hX   27rnb  h	X   I'm not sure I understandrob  hX   Apizarpb  h
X   32rqb  hX   UNCrrb  hX"   ELICIT-COMMENT-ABOUT-UNDERSTANDINGrsb  hNhNuK"}rtb  (hX   28rub  h	X   what is ALLEGRO_EVENT_KEY_DOWNrvb  hX
   Programmerrwb  h
X   33rxb  hX   FOLryb  hX
   ELICIT-INFORMrzb  h]r{b  X   basicr|b  ah]r}b  X   ALLEGRO_EVENT_KEY_DOWNr~b  auK#}rb  (hX   29rb  h	X=   ALLEGRO_EVENT_KEY_DOWN represents a keyboard key was pressed.rb  hX   Apizarb  h
X   34rb  hX   POSrb  hX   INFORMrb  h]rb  X   basicrb  ah]rb  X   ALLEGRO_EVENT_KEY_DOWNrb  auK$}rb  (hX   30rb  h	X   Note: this event is about the physical keys being pressed on the keyboard. Look for ALLEGRO_EVENT_KEY_CHAR events for character input.rb  hX   Apizarb  h
X   35rb  hX   CONTrb  hX   INFORMrb  h]rb  (X   conceptsrb  X	   structurerb  eh]rb  X   ALLEGRO_EVENT_KEY_DOWNrb  auK%}rb  (hX   31rb  h	X   what are the possible eventsrb  hX
   Programmerrb  h
NhNhX
   ELICIT-INFORMrb  h]rb  X	   structurerb  ahNuK&}rb  (hX   32rb  h	X  ALLEGRO_EVENT_JOYSTICK_AXIS\nALLEGRO_EVENT_JOYSTICK_BUTTON_DOWN\nALLEGRO_EVENT_JOYSTICK_BUTTON_UP\nALLEGRO_EVENT_JOYSTICK_CONFIGURATION\nALLEGRO_EVENT_KEY_DOWN\nALLEGRO_EVENT_KEY_UP\nALLEGRO_EVENT_KEY_CHAR\nALLEGRO_EVENT_MOUSE_AXES\nALLEGRO_EVENT_MOUSE_BUTTON_DOWN\nALLEGRO_EVENT_MOUSE_BUTTON_UP\nALLEGRO_EVENT_MOUSE_WARPED\nALLEGRO_EVENT_MOUSE_ENTER_DISPLAY\nALLEGRO_EVENT_MOUSE_LEAVE_DISPLAY\nALLEGRO_EVENT_TOUCH_BEGIN\nALLEGRO_EVENT_TOUCH_END\nALLEGRO_EVENT_TOUCH_MOVE\nALLEGRO_EVENT_TOUCH_CANCEL\nALLEGRO_EVENT_TIMER\nALLEGRO_EVENT_DISPLAY_EXPOSE\nALLEGRO_EVENT_DISPLAY_RESIZE\nALLEGRO_EVENT_DISPLAY_CLOSE\nALLEGRO_EVENT_DISPLAY_LOST\nALLEGRO_EVENT_DISPLAY_FOUND\nALLEGRO_EVENT_DISPLAY_SWITCH_OUT\nALLEGRO_EVENT_DISPLAY_SWITCH_IN\nALLEGRO_EVENT_DISPLAY_ORIENTATION\nALLEGRO_EVENT_DISPLAY_HALT_DRAWING\nALLEGRO_EVENT_DISPLAY_RESUME_DRAWING\nALLEGRO_EVENT_DISPLAY_CONNECTED\nALLEGRO_EVENT_DISPLAY_DISCONNECTEDrb  hX   Apizarb  h
X   37rb  hX   POSrb  hX   INFORMrb  h]rb  X	   structurerb  ahNuK'}rb  (hX   33rb  h	X   what is ALLEGRO_EVENTrb  hX
   Programmerrb  h
NhNhX
   ELICIT-INFORMrb  h]rb  X   basicrb  ah]rb  X
   ALLEGRO_EVENTrb  auK(}rb  (hX   34rb  h	X   An ALLEGRO_EVENT is a union of all builtin event structures, i.e. it is an object large enough to hold the data of any event type. rb  hX   Apizarb  h
X   39rb  hX   POSrb  hX   INFORMrb  h]rb  (X   basicrb  X   purposerb  eh]rb  X
   ALLEGRO_EVENTrb  auK)}rb  (hX   34rb  h	X  All events have the following fields in common:\n\ntype (ALLEGRO_EVENT_TYPE)\nIndicates the type of event.\nany.source (ALLEGRO_EVENT_SOURCE *)\nThe event source which generated the event.\nany.timestamp (double)\nWhen the event was generated.\nBy examining the type field you can then access type-specific fields. The any.source field tells you which event source generated that particular event. The any.timestamp field tells you when the event was generated. The time is referenced to the same starting point as al_get_time.\n\nrb  hX   Apizarb  h
X   40rb  hX   CONTrb  hX   INFORMrb  h]rb  (X	   structurerb  X   conceptsrb  eh]rb  X
   ALLEGRO_EVENTrb  auK*}rb  (hX   34rb  h	XJ   Each event is of one of the following types, with the usable fields given.rb  hX   Apizarb  h
X   41rb  hX   CONTrb  hX   INFORMrb  h]rb  X   qualityrb  ah]rb  X
   ALLEGRO_EVENTrb  auK+}rb  (hX   35rb  h	X$   tell me about ALLEGRO_EVENT_KEY_DOWNrb  hX
   Programmerrb  h
NhNhX
   ELICIT-INFORMrb  h]rb  X   basicrb  ah]rb  X   ALLEGRO_EVENT_KEY_DOWNrb  auK,}rb  (hX   36rb  h	X=   ALLEGRO_EVENT_KEY_DOWN represents a keyboard key was pressed.rb  hX   Apizarb  h
X   43rb  hX   POSrb  hX   INFORMrb  h]rb  X   basicrb  ah]rb  X   ALLEGRO_EVENT_KEY_DOWNrb  auK-}rb  (hX   37rb  h	Xn   if I have an ALLEGRO_EVENT called ev, should ev.type == ALLEGRO_EVENT_KEY_DOWN return true when I press a key?rb  hX
   Programmerrb  h
NhNhX
   ELICIT-INFORMrb  h]rb  X
   functionalityrb  ah]rb  (X
   ALLEGRO_EVENTrb  X   ALLEGRO_EVENT_KEY_DOWNrb  euK.}rb  (hX   38rb  h	X   I'm not sure I understandrb  hX   Apizarb  h
X   45rb  hX   UNCrb  hX"   ELICIT-COMMENT-ABOUT-UNDERSTANDINGrb  hNhNuK/}rb  (hX   39rb  h	X;   Are you interested in al_get_keyboard_state or al_key_down?rb  hX   Apizarb  h
X   46rb  hX   FOLrb  hX
   ELICIT-INFORMrb  h]rb  X   basicrb  ah]r c  (X   al_get_keyboard_staterc  X   al_key_downrc  euK0}rc  (hX   40rc  h	X   norc  hX
   Programmerrc  h
X   47rc  hX   NEGrc  hX   INFORMr	c  hNhNuK1}r
c  (hX   41rc  h	X#   tell me about al_get_keyboard_staterc  hX
   Programmerr
c  h
X   47rc  hX   FOLrc  hX
   ELICIT-INFORMrc  h]rc  X   basicrc  ah]rc  X   al_get_keyboard_staterc  auK2}rc  (hX   42rc  h	X   This method saves the state of the keyboard specified at the time the function is called into the structure pointed to by ret_state.rc  hX   Apizarc  h
X   49rc  hX   POSrc  hX   INFORMrc  h]rc  (X
   functionalityrc  X	   structurerc  eh]rc  X   al_get_keyboard_stater c  auK3}r!c  (hX   43r"c  h	X=   void al_get_keyboard_state(ALLEGRO_KEYBOARD_STATE *ret_state)r#c  hX   Apizar$c  h
X   50r%c  hX   CONTr&c  hX   INFORMr'c  h]r(c  X   basicr)c  ah]r*c  X   al_get_keyboard_stater+c  auK4}r,c  (hX   44r-c  h	X:   how can I check to see if my keyboard is generating eventsr.c  hX
   Programmerr/c  h
NhNhX   ELICIT-OFFER-OR-SUGGESTIONr0c  h]r1c  X   patternsr2c  ahNuK5}r3c  (hX   45r4c  h	X2   Are you asking about al_get_keyboard_event_source?r5c  hX   Apizar6c  h
X   52r7c  hX   FOLr8c  hX
   ELICIT-INFORMr9c  h]r:c  X   basicr;c  ah]r<c  X   al_get_keyboard_event_sourcer=c  auK6}r>c  (hX   46r?c  h	X   yesr@c  hX
   ProgrammerrAc  h
X   53rBc  hX   POSrCc  hX   INFORMrDc  hNh]rEc  X   al_get_keyboard_event_sourcerFc  auK7}rGc  (hX   47rHc  h	Xi   The method retrieves the keyboard event source. All keyboard events are generated by this event source.\nrIc  hX   ApizarJc  h
X   54rKc  hX   POSrLc  hX   INFORMrMc  h]rNc  (X
   functionalityrOc  X   controlrPc  eh]rQc  X   al_get_keyboard_event_sourcerRc  auK8}rSc  (hX   47rTc  h	X9   Returns NULL if the keyboard subsystem was not installed.rUc  hX   ApizarVc  h
X   55rWc  hX   CONTrXc  hX   INFORMrYc  h]rZc  X
   functionalityr[c  ah]r\c  X   al_get_keyboard_event_sourcer]c  auK9}r^c  (hX   48r_c  h	X8   ALLEGRO_EVENT_SOURCE *al_get_keyboard_event_source(void)r`c  hX   Apizarac  h
X   56rbc  hX   CONTrcc  hX   INFORMrdc  h]rec  X   basicrfc  ah]rgc  X   al_get_keyboard_event_sourcerhc  auK:}ric  (hX   49rjc  h	XS   when I call al_get_keyboard_event_source, the assertion 'new_keyboard_driver' failsrkc  hX
   Programmerrlc  h
NhNhX   INFORMrmc  h]rnc  X
   functionalityroc  ah]rpc  X   al_get_keyboard_event_sourcerqc  auK;}rrc  (hX   50rsc  h	X)   Are you asking about al_install_keyboard?rtc  hX   Apizaruc  h
X   58rvc  hX   FOLrwc  hX
   ELICIT-INFORMrxc  h]ryc  X   basicrzc  ah]r{c  (X   al_get_keyboard_event_sourcer|c  X   al_install_keyboardr}c  euK<}r~c  (hX   51rc  h	X   what is al_get_keyboardrc  hX
   Programmerrc  h
X   59rc  hX   FOLrc  hX
   ELICIT-INFORMrc  h]rc  X   basicrc  ah]rc  X   al_install_keyboardrc  auK=}rc  (hX   52rc  h	X   I'm not sure I understandrc  hX   Apizarc  h
X   60rc  hX   UNCrc  hX   COMMENT-ABOUT-UNDERSTANDINGrc  hNhNuK>}rc  (hX   53rc  h	X!   tell me about al_install_keyboardrc  hX
   Programmerrc  h
X   61rc  hX   FOLrc  hX
   ELICIT-INFORMrc  h]rc  X   basicrc  ah]rc  X   al_install_keyboardrc  auK?}rc  (hX   54rc  h	X(   This method installs a keyboard driver. rc  hX   Apizarc  h
X   62rc  hX   POSrc  hX   INFORMrc  h]rc  X
   functionalityrc  ah]rc  X   al_install_keyboardrc  auK@}rc  (hX   54rc  h	Xd   Returns true if successful. If a driver was already installed, nothing happens and true is returned.rc  hX   Apizarc  h
X   63rc  hX   CONTrc  hX   INFORMrc  h]rc  X
   functionalityrc  ah]rc  X   al_install_keyboardrc  auKA}rc  (hX   55rc  h	X   bool al_install_keyboard(void)rc  hX   Apizarc  h
X   64rc  hX   CONTrc  hX   INFORMrc  h]rc  X   basicrc  ah]rc  X   al_install_keyboardrc  auKB}rc  (hX   56rc  h	X)   what is they type of ALLEGRO_EVENT_SOURCErc  hX
   Programmerrc  h
NhNhX
   ELICIT-INFORMrc  h]rc  X   basicrc  ah]rc  X   ALLEGRO_EVENT_SOURCErc  auKC}rc  (hX   57rc  h	X9   typedef struct ALLEGRO_EVENT_SOURCE ALLEGRO_EVENT_SOURCE;rc  hX   Apizarc  h
X   66rc  hX   POSrc  hX   INFORMrc  h]rc  X   basicrc  ah]rc  X   ALLEGRO_EVENT_SOURCErc  auKD}rc  (hX   58rc  h	X+   what are the fields of ALLEGRO_EVENT_SOURCErc  hX
   Programmerrc  h
X   67rc  hX   FOLrc  hX
   ELICIT-INFORMrc  h]rc  X	   structurerc  ah]rc  X   ALLEGRO_EVENT_SOURCErc  auKE}rc  (hX   59rc  h	X!  An event source is any object which can generate events. For example, an ALLEGRO_DISPLAY can generate events, and you can get the ALLEGRO_EVENT_SOURCE pointer from an ALLEGRO_DISPLAY with al_get_display_event_source.\n\nYou may create your own "user" event sources that emit custom events.rc  hX   Apizarc  h
X   68rc  hX   POSrc  hX   INFORMrc  h]rc  (X   conceptsrc  X
   directivesrc  X   patternsrc  eh]rc  X   ALLEGRO_EVENT_SOURCErc  auKF}rc  (hX   60rc  h	X   what is ALLEGRO_KEYBOARDrc  hX
   Programmerrc  h
NhNhX
   ELICIT-INFORMrc  h]rc  X   basicrc  ahNuKG}rc  (hX   61rc  h	X,   Are you asking about ALLEGRO_KEYBOARD_STATE?rc  hX   Apizarc  h
X   70rc  hX   FOLrc  hX
   ELICIT-INFORMrc  h]rc  X   basicrc  ah]rc  X   ALLEGRO_KEYBOARD_STATErc  auKH}rc  (hX   62rc  h	X   norc  hX
   Programmerrc  h
X   71rc  hX   NEGrc  hX   INFORMr d  hNh]rd  X   ALLEGRO_KEYBOARD_STATErd  auKI}rd  (hX   63rd  h	X   tell me about al_keyboard_staterd  hX
   Programmerrd  h
NhNhX
   ELICIT-INFORMrd  h]rd  X   basicr	d  ahNuKJ}r
d  (hX   64rd  h	X	   nevermindrd  hX
   Programmerr
d  h
X   73rd  hX   NEGrd  hX   SUGGESTrd  hNhNuKK}rd  (hX   65rd  h	X   tell me about al_key_downrd  hX
   Programmerrd  h
NhNhX
   ELICIT-INFORMrd  h]rd  X   basicrd  ah]rd  X   al_key_downrd  auKL}rd  (hX   66rd  h	XG   Returns true if the key specified was held down in the state specified.rd  hX   Apizard  h
X   75rd  hX   POSrd  hX   INFORMr d  h]r!d  X
   functionalityr"d  ah]r#d  X   al_key_downr$d  auKM}r%d  (hX   67r&d  h	XB   bool al_key_down(const ALLEGRO_KEYBOARD_STATE *state, int keycode)r'd  hX   Apizar(d  h
X   76r)d  hX   CONTr*d  hX   INFORMr+d  h]r,d  X   basicr-d  ah]r.d  X   al_key_downr/d  auuuK}r0d  (hj?>  h}r1d  (K }r2d  (hhh	X   Hi Apizar3d  hX
   Programmerr4d  h
NhNhX   BE-POSITIVEr5d  hNhNuK}r6d  (hhh	X   Hi Programmer_25!r7d  hX   Apizar8d  h
hhX   POSr9d  hX   BE-POSITIVEr:d  hNhNuK}r;d  (hh+h	X$   How can i get arrow keys in Allegro?r<d  hX
   Programmerr=d  h
NhNhX   ELICIT-OFFER-OR-SUGGESTIONr>d  h]r?d  X   patternsr@d  ahNuK}rAd  (hh5h	Xn   The key codes for the arrow keys are:\n\nALLEGRO_KEY_LEFT\nALLEGRO_KEY_RIGHT\nALLEGRO_KEY_UP\nALLEGRO_KEY_DOWNrBd  hX   ApizarCd  h
hhX   PARTrDd  hX   INFORMrEd  h]rFd  X	   structurerGd  ahNuK}rHd  (hh<h	X   Are these boolean values?rId  hX
   ProgrammerrJd  h
h+hX   FOLrKd  hX
   ELICIT-INFORMrLd  h]rMd  X   basicrNd  ahNuK}rOd  (hhFh	X
   they are enumrPd  hX
   ProgrammerrQd  h
h5hX   POSrRd  hX   INFORMrSd  h]rTd  X   basicrUd  ahNuK}rVd  (hhFh	XA   So, How can I use ALLEGRO_KEY_LEFT to get the status of this key?rWd  hX
   ProgrammerrXd  h
h+hX   FOLrYd  hX   ELICIT-OFFER-OR-SUGGESTIONrZd  h]r[d  X   patternsr\d  ahNuK}r]d  (hhQh	X4   al_key_down will give you the status of a given key:r^d  hX   Apizar_d  h
hFhX   POSr`d  hX   SUGGESTrad  h]rbd  X   patternsrcd  ah]rdd  X   al_key_downred  auK}rfd  (hhQh	XF   \n\nbool al_key_down(const ALLEGRO_KEYBOARD_STATE *state, int keycode)rgd  hX   Apizarhd  h
hQhX   CONTrid  hX   INFORMrjd  h]rkd  X   basicrld  ah]rmd  X   al_key_downrnd  auK	}rod  (hhXh	X+   what is the type of ALLEGRO_KEYBOARD_STATE?rpd  hX
   Programmerrqd  h
hXhX   FOLrrd  hX
   ELICIT-INFORMrsd  h]rtd  X   basicrud  ah]rvd  (X   al_key_downrwd  X   ALLEGRO_KEYBOARD_STATErxd  euK
}ryd  (hhch	X[   ALLEGRO_KEYBOARD_STATE\n\ntypedef struct ALLEGRO_KEYBOARD_STATE ALLEGRO_KEYBOARD_STATE;\n\nrzd  hX   Apizar{d  h
hchX   POSr|d  hX   INFORMr}d  h]r~d  X	   structurerd  ah]rd  X   ALLEGRO_KEYBOARD_STATErd  auK}rd  (hhch	Xf   This is a structure that is used to hold a "snapshot" of a keyboard\'s state at a particular instant. rd  hX   Apizard  h
X   10rd  hX   CONTrd  hX   INFORMrd  h]rd  X   purposerd  ah]rd  X   ALLEGRO_KEYBOARD_STATErd  auK}rd  (hhch	X   It contains the following publically readable fields:\n • display - points to the display that had keyboard focus at the time the state was saved. If no display was focused, this points to NULL.rd  hX   Apizard  h
X   11rd  hX   CONTrd  hX   INFORMrd  h]rd  (X	   structurerd  X   conceptsrd  eh]rd  X   ALLEGRO_KEYBOARD_STATErd  auK
}rd  (hX   10rd  h	X#   where can I get the keyboard state?rd  hX
   Programmerrd  h
X   12rd  hX   FOLrd  hX
   ELICIT-INFORMrd  h]rd  X   patternsrd  ah]rd  X   ALLEGRO_KEYBOARD_STATErd  auK}rd  (hX   11rd  h	XC   al_get_keyboard_state will allow you to get the keyboard state:\n\nrd  hX   Apizard  h
X   13rd  hX   POSrd  hX   SUGGESTrd  h]rd  X   patternsrd  ah]rd  (X   ALLEGRO_KEYBOARD_STATErd  X   al_get_keyboard_staterd  euK}rd  (hX   11rd  h	XC   void al_get_keyboard_state(ALLEGRO_KEYBOARD_STATE *ret_state)\n\n\nrd  hX   Apizard  h
X   14rd  hX   CONTrd  hX   INFORMrd  h]rd  X   basicrd  ah]rd  X   al_get_keyboard_staterd  auK}rd  (hX   11rd  h	Xw   Save the state of the keyboard specified at the time the function is called into the structure pointed to by ret_state.rd  hX   Apizard  h
X   15rd  hX   CONTrd  hX   INFORMrd  h]rd  (X
   functionalityrd  X	   structurerd  eh]rd  X   al_get_keyboard_staterd  auK}rd  (hX   12rd  h	X   getting this errorrd  hX
   Programmerrd  h
X   16rd  hX   FOLrd  hX   INFORMrd  h]rd  X
   functionalityrd  ah]rd  X   al_get_keyboard_staterd  auK}rd  (hX   13rd  h	X   allegro_tasks: /build/allegro5-LWhWgt/allegro5-5.2.4.0/src/keybdnu.c:241: al_get_keyboard_state: Assertion `new_keyboard_driver' failed.rd  hX
   Programmerrd  h
X   17rd  hX   CONTrd  hX   INFORMrd  h]rd  X
   functionalityrd  ah]rd  X   al_get_keyboard_staterd  auK}rd  (hX   14rd  h	X   Have you called al_init()?rd  hX   Apizard  h
X   18rd  hX   FOLrd  hX
   ELICIT-INFORMrd  h]rd  X   patternsrd  ah]rd  (X   al_get_keyboard_staterd  X   al_initrd  euK}rd  (hX   15rd  h	X   yesrd  hX
   Programmerrd  h
X   19rd  hX   POSrd  hX   INFORMrd  hNh]rd  (X   al_get_keyboard_staterd  X   al_initrd  euK}rd  (hX   16rd  h	X4   can you write a short snippet to get the arrow keys?rd  hX
   Programmerrd  h
X   20rd  hX   FOLrd  hX   SUGGESTrd  h]rd  X   examplesrd  ah]rd  (X   al_get_keyboard_staterd  X   al_initrd  euK}rd  (hX   17rd  h	X'   What do you mean by get the arrow keys?rd  hX   Apizar e  h
X   21re  hX   FOLre  hX
   ELICIT-INFORMre  h]re  X   conceptsre  ahNuK}re  (hX   18re  h	X0   Get arrow keys when they are pressed on keyboardre  hX
   Programmerr	e  h
X   22r
e  hX   POSre  hX   INFORMre  h]r
e  X   patternsre  ahNuK}re  (hX   19re  h	X?   al_key_down should return true if the specified key is pressed:re  hX   Apizare  h
X   23re  hX   POSre  hX   INFORMre  h]re  X
   functionalityre  ah]re  X   al_key_downre  auK}re  (hX   19re  h	XJ   \n\nbool al_key_down(const ALLEGRO_KEYBOARD_STATE *state, int keycode)\n\nre  hX   Apizare  h
X   24re  hX   CONTre  hX   INFORMr e  h]r!e  X   basicr"e  ah]r#e  X   al_key_downr$e  auK}r%e  (hX   19r&e  h	XF   Return true if the key specified was held down in the state specified.r'e  hX   Apizar(e  h
X   25r)e  hX   CONTr*e  hX   INFORMr+e  h]r,e  X
   functionalityr-e  ah]r.e  X   al_key_downr/e  auK}r0e  (hX   20r1e  h	X$   The key codes for the arrow keys arer2e  hX   Apizar3e  h
X   26r4e  hX   CONTr5e  hX   INFORMr6e  h]r7e  X	   structurer8e  ahNuK}r9e  (hX   20r:e  h	XI   \n\nALLEGRO_KEY_LEFT\nALLEGRO_KEY_RIGHT\nALLEGRO_KEY_UP\nALLEGRO_KEY_DOWNr;e  hX   Apizar<e  h
X   27r=e  hX   CONTr>e  hX   INFORMr?e  h]r@e  X	   structurerAe  ahNuK}rBe  (hX   21rCe  h	X%   what is the function the play a soundrDe  hX
   ProgrammerrEe  h
NhNhX
   ELICIT-INFORMrFe  h]rGe  X   patternsrHe  ahNuK}rIe  (hX   22rJe  h	X  Use al_install_audio to initialize sound. To load any sample formats, you will need to initialise the acodec addon with al_init_acodec_addon.\n\nAfter that, you can simply use al_reserve_samples and pass the number of sound effects typically playing at the same time. Then load your sound effects with al_load_sample and play them with al_play_sample. To stream large pieces of music from disk, you can use al_load_audio_stream so the whole piece will not have to be pre-loaded into memory.\n\nIf the above sounds too simple and you can\'t help but think about clipping and latency issues, don\'t worry. Allegro gives you full control over how much or little you want its sound system to do. The al_reserve_samples function mentioned above only sets up a default mixer and a number of sample instances but you don\'t need to use it.\n\nInstead, to get a "direct connection" to the sound system you would use an ALLEGRO_VOICE (but depending on the platform only one such voice is guaranteed to be available and it might require a specific format of audio data). Therefore all sound can be first routed through an ALLEGRO_MIXER which is connected to such a voice (or another mixer) and will mix together all sample data fed to it.\n\nYou can then directly stream real-time sample data to a mixer or a voice using an ALLEGRO_AUDIO_STREAM or play complete sounds using an ALLEGRO_SAMPLE_INSTANCE. The latter simply points to an ALLEGRO_SAMPLE and will stream it for you.rKe  hX   ApizarLe  h
X   29rMe  hX   POSrNe  hX   INFORMrOe  h]rPe  (X
   functionalityrQe  X
   directivesrRe  X   qualityrSe  X   patternsrTe  eh]rUe  (X   al_install_audiorVe  X   al_init_acodec_addonrWe  X   al_reserve_samplesrXe  X   al_load_samplerYe  X   al_play_samplerZe  X   al_load_audio_streamr[e  X
   ALLEGRO_VOICEr\e  X
   ALLEGRO_MIXERr]e  X   ALLEGRO_AUDIO_STREAMr^e  X   ALLEGRO_SAMPLE_INSTANCEr_e  X   ALLEGRO_SAMPLEr`e  euK}rae  (hX   23rbe  h	X.   how can i get ALLEGRO_SAMPLE * from .wav file?rce  hX
   Programmerrde  h
X   30ree  hX   FOLrfe  hX   ELICIT-OFFER-OR-SUGGESTIONrge  h]rhe  X   patternsrie  ah]rje  X   ALLEGRO_SAMPLErke  auK }rle  (hX   24rme  h	X:   It looks like you'll want to use al_init_acodec_addon:\n\nrne  hX   Apizaroe  h
X   31rpe  hX   POSrqe  hX   SUGGESTrre  h]rse  X   patternsrte  ah]rue  (X   al_init_acodec_addonrve  X   ALLEGRO_SAMPLErwe  euK!}rxe  (hX   24rye  h	X#   bool al_init_acodec_addon(void)\n\nrze  hX   Apizar{e  h
X   32r|e  hX   CONTr}e  hX   INFORMr~e  h]re  X   basicre  ah]re  X   al_init_acodec_addonre  auK"}re  (hX   24re  h	X  This function registers all the known audio file type handlers for al_load_sample, al_save_sample, al_load_audio_stream, etc.\nDepending on what libraries are available, the full set of recognised extensions is: .wav, .flac, .ogg, .opus, .it, .mod, .s3m, .xm, .voc.\nre  hX   Apizare  h
X   33re  hX   CONTre  hX   INFORMre  h]re  (X
   functionalityre  X   purposere  X
   directivesre  eh]re  X   al_init_acodec_addonre  auK#}re  (hX   24re  h	X;  Limitations:\n • Saving is only supported for wav files.\n • The wav file loader currently only supports 8/16 bit little endian PCM files. 16 bits are used when saving wav files. Use flac files if more precision is required.\n • Module files (.it, .mod, .s3m, .xm) are often composed with streaming in mind, and sometimes cannot be easily rendered into a finite length sample. Therefore they cannot be loaded with al_load_sample/al_load_sample_f and must be streamed with al_load_audio_stream or al_load_audio_stream_f.\n • .voc file streaming is unimplemented.\nre  hX   Apizare  h
X   34re  hX   CONTre  hX   INFORMre  h]re  (X   qualityre  X
   directivesre  X   patternsre  eh]re  X   al_init_acodec_addonre  auK$}re  (hX   24re  h	X   Return true on success.re  hX   Apizare  h
X   35re  hX   CONTre  hX   INFORMre  h]re  X
   functionalityre  ah]re  X   al_init_acodec_addonre  auK%}re  (hX   25re  h	X   what is this error for ?re  hX
   Programmerre  h
NhNhX
   ELICIT-INFORMre  h]re  (X
   functionalityre  X   conceptsre  ehNuK&}re  (hX   25re  h	Xx   \n\nallegro_tasks: /build/allegro5-LWhWgt/allegro5-5.2.4.0/addons/font/text.c:79: al_draw_ustr: Assertion `font' failed.re  hX
   Programmerre  h
X   37re  hX   CONTre  hX   INFORMre  h]re  (X
   functionalityre  X   conceptsre  ehNuK'}re  (hX   26re  h	X=   Have you called al_init_font_addon() and al_init_ttf_addon()?re  hX   Apizare  h
X   38re  hX   FOLre  hX
   ELICIT-INFORMre  h]re  X   patternsre  ah]re  (X   al_init_font_addonre  X   al_init_ttf_addonre  euK(}re  (hX   27re  h	X   nore  hX
   Programmerre  h
X   39re  hX   POSre  hX   INFORMre  hNh]re  (X   al_init_font_addonre  X   al_init_ttf_addonre  euK)}re  (hX   28re  h	X3   You'll probably want to use al_init_font_addon:\n\nre  hX   Apizare  h
X   40re  hX   POSre  hX   SUGGESTre  h]re  X   patternsre  ah]re  X   al_init_font_addonre  auK*}re  (hX   28re  h	X!   bool al_init_font_addon(void)\n\nre  hX   Apizare  h
X   41re  hX   CONTre  hX   INFORMre  h]re  X   basicre  ah]re  X   al_init_font_addonre  auK+}re  (hX   28re  h	X  Initialise the font addon.\nNote that if you intend to load bitmap fonts, you will need to initialise allegro_image separately (unless you are using another library to load images).\nSimilarly, if you wish to load truetype-fonts, do not forget to also call al_init_ttf_addon.\nre  hX   Apizare  h
X   42re  hX   CONTre  hX   INFORMre  h]re  (X
   functionalityre  X
   directivesre  X   patternsre  eh]re  X   al_init_font_addonre  auK,}re  (hX   28re  h	X   Returns true on success, false on failure. On the 5.0 branch, this function has no return value. You may wish to avoid checking the return value if your code needs to be compatible with Allegro 5.0. Currently, the function will never return false.re  hX   Apizare  h
X   43re  hX   CONTre  hX   INFORMre  h]re  (X
   functionalityre  X   environmentre  eh]re  X   al_init_font_addonre  auK-}re  (hX   29r f  h	X   how can i use al_draw_text ?rf  hX
   Programmerrf  h
NhNhX   ELICIT-OFFER-OR-SUGGESTIONrf  h]rf  X   patternsrf  ah]rf  X   al_draw_textrf  auK.}rf  (hX   30r	f  h	X'   This should help with al_draw_text:\n\nr
f  hX   Apizarf  h
X   45rf  hX   POSr
f  hX   SUGGESTrf  hNh]rf  X   al_draw_textrf  auK/}rf  (hX   30rf  h	Xu   void al_draw_text(const ALLEGRO_FONT *font,\n ALLEGRO_COLOR color, float x, float y, int flags,\n char const *text)\nrf  hX   Apizarf  h
X   46rf  hX   CONTrf  hX   INFORMrf  h]rf  X   basicrf  ah]rf  X   al_draw_textrf  auK0}rf  (hX   30rf  h	Xj   Writes the NUL-terminated string text onto the target bitmap at position x, y, using the specified font.\nrf  hX   Apizarf  h
X   47r f  hX   CONTr!f  hX   INFORMr"f  h]r#f  X
   functionalityr$f  ah]r%f  X   al_draw_textr&f  auK1}r'f  (hX   30r(f  h	X  The flags parameter can be 0 or one of the following flags:\n • ALLEGRO_ALIGN_LEFT - Draw the text left-aligned (same as 0).\n • ALLEGRO_ALIGN_CENTRE - Draw the text centered around the given position.\n • ALLEGRO_ALIGN_RIGHT - Draw the text right-aligned to the given position.\nIt can also be combined with this flag:\n • ALLEGRO_ALIGN_INTEGER - Always draw text aligned to an integer pixel position. This was formerly the default behaviour. Since: 5.0.8, 5.1.4\nr)f  hX   Apizar*f  h
X   48r+f  hX   CONTr,f  hX   INFORMr-f  h]r.f  (X
   directivesr/f  X   patternsr0f  X   environmentr1f  eh]r2f  X   al_draw_textr3f  auK2}r4f  (hX   30r5f  h	X{   This function does not support newline characters (\\n), but you can use al_draw_multiline_text for multi line text output.r6f  hX   Apizar7f  h
X   49r8f  hX   CONTr9f  hX   INFORMr:f  h]r;f  (X
   functionalityr<f  X   patternsr=f  eh]r>f  X   al_draw_textr?f  auK3}r@f  (hX   31rAf  h	X   using al_load_font ?rBf  hX
   ProgrammerrCf  h
NhNhX   ELICIT-OFFER-OR-SUGGESTIONrDf  h]rEf  X   patternsrFf  ah]rGf  X   al_load_fontrHf  auK4}rIf  (hX   32rJf  h	X'   This should help with al_load_font:\n\nrKf  hX   ApizarLf  h
X   51rMf  hX   POSrNf  hX   SUGGESTrOf  hNh]rPf  X   al_load_fontrQf  auK5}rRf  (hX   32rSf  h	XI   ALLEGRO_FONT *al_load_font(char const *filename, int size, int flags)\n\nrTf  hX   ApizarUf  h
X   52rVf  hX   CONTrWf  hX   INFORMrXf  h]rYf  X   basicrZf  ah]r[f  X   al_load_fontr\f  auK6}r]f  (hX   32r^f  h	X2  Loads a font from disk. This will use al_load_bitmap_font_flags if you pass the name of a known bitmap format, or else al_load_ttf_font.\n\nThe flags parameter is passed through to either of those functions. Bitmap and TTF fonts are also affected by the current bitmap flags at the time the font is loaded.r_f  hX   Apizar`f  h
X   53raf  hX   CONTrbf  hX   INFORMrcf  h]rdf  (X
   functionalityref  X   controlrff  X   patternsrgf  X   basicrhf  eh]rif  X   al_load_fontrjf  auK7}rkf  (hX   33rlf  h	X   how to load a .png bitmaprmf  hX
   Programmerrnf  h
NhNhX   ELICIT-OFFER-OR-SUGGESTIONrof  h]rpf  X   patternsrqf  ahNuK8}rrf  (hX   34rsf  h	X9   It looks like you'll want to use al_init_image_addon:\n\nrtf  hX   Apizaruf  h
X   55rvf  hX   POSrwf  hX   SUGGESTrxf  h]ryf  X   patternsrzf  ah]r{f  X   al_init_image_addonr|f  auK9}r}f  (hX   34r~f  h	X"   bool al_init_image_addon(void)\n\nrf  hX   Apizarf  h
X   56rf  hX   CONTrf  hX   INFORMrf  h]rf  X   basicrf  ah]rf  X   al_init_image_addonrf  auK:}rf  (hX   34rf  h	Xy  Initializes the image addon. This registers bitmap format handlers for al_load_bitmap, al_load_bitmap_f, al_save_bitmap, al_save_bitmap_f.\n\nThe following types are built into the Allegro image addon and guaranteed to be available: BMP, DDS, PCX, TGA. Every platform also supports JPEG and PNG via external dependencies.\n\nOther formats may be available depending on the operating system and installed libraries, but are not guaranteed and should not be assumed to be universally available.\n\nThe DDS format is only supported to load from, and only if the DDS file contains textures compressed in the DXT1, DXT3 and DXT5 formats. rf  hX   Apizarf  h
X   57rf  hX   CONTrf  hX   INFORMrf  h]rf  (X
   functionalityrf  X
   directivesrf  X   environmentrf  eh]rf  X   al_init_image_addonrf  auK;}rf  (hX   34rf  h	X   Note that when loading a DDS file, the created bitmap will always be a video bitmap and will have the pixel format matching the format in the file.rf  hX   Apizarf  h
X   58rf  hX   CONTrf  hX   INFORMrf  h]rf  X
   functionalityrf  ah]rf  X   al_init_image_addonrf  auK<}rf  (hX   35rf  h	X%   can you guide me to use a PNG format?rf  hX
   Programmerrf  h
X   59rf  hX   FOLrf  hX   ELICIT-OFFER-OR-SUGGESTIONrf  h]rf  X   patternsrf  ahNuuuK}rf  (hj?>  h}rf  (K }rf  (hhh	X!   how to implement key press event?rf  hX
   Programmerrf  h
NhNhX   ELICIT-OFFER-OR-SUGGESTIONrf  h]rf  X   patternsrf  ahNuK}rf  (hhh	X)   Here is an example using keyboard events:rf  hX   Apizarf  h
hhX   POSrf  hX   INFORMrf  hNhNuK}rf  (hhh	XD   \r\n\r\n```\r\n#include <stdio.h>\r\n#include <allegro5/allegro.h>\rrf  hX   Apizarf  h
hhX   CONTrf  hX   INFORMrf  h]rf  X   examplesrf  ahNuK}rf  (hh+h	X   how to play soundrf  hX
   Programmerrf  h
NhNhX   ELICIT-OFFER-OR-SUGGESTIONrf  h]rf  X   patternsrf  ahNuK}rf  (hh5h	X&   Here is an example of using audio:\n\nrf  hX   Apizarf  h
h+hX   POSrf  hX   INFORMrf  h]rf  X   examplesrf  ahNuK}rf  (hh5h	X{  ```\n#include &lt;stdio.h&gt;\n#include &lt;allegro5/allegro.h&gt;\n#include &lt;allegro5/allegro_audio.h&gt;\n#include &lt;allegro5/allegro_acodec.h&gt;\n\nint main(int argc, char **argv){\n\n ALLEGRO_DISPLAY *display = NULL;\n ALLEGRO_SAMPLE *sample=NULL;\n \n if(!al_init()){\n fprintf(stderr, "failed to initialize allegro!\\n");\n return -1;\n }\n \n if(!al_install_audio()){\n fprintf(stderr, "failed to initialize audio!\\n");\n return -1;\n }\n\n if(!al_init_acodec_addon()){\n fprintf(stderr, "failed to initialize audio codecs!\\n");\n return -1;\n }\n \n if (!al_reserve_samples(1)){\n fprintf(stderr, "failed to reserve samples!\\n");\n return -1;\n }\n \n sample = al_load_sample( "footstep.wav" );\n\n if (!sample){\n printf( "Audio clip sample not loaded!\\n" ); \n return -1;\n }\n \n display = al_create_display(640, 480);\n \n if(!display){\n fprintf(stderr, "failed to create display!\\n");\n return -1;\n }\n\n /* Loop the sample until the display closes. */\n al_play_sample(sample, 1.0, 0.0,1.0,ALLEGRO_PLAYMODE_LOOP,NULL);\n\n al_rest(10.0);\n \n al_destroy_display(display);\n al_destroy_sample(sample);\n return 0;\n}\n```rf  hX   Apizarf  h
h5hX   CONTrf  hX   INFORMrf  h]rf  X   examplesrf  ahNuK}rf  (hh<h	X"   how to display text on the screen?rf  hX
   Programmerrf  h
NhNhX   ELICIT-OFFER-OR-SUGGESTIONrf  h]rf  X   patternsrf  ahNuK}rf  (hhFh	X*   Here is an example of displaying text:\n\nrf  hX   Apizarf  h
hFhX   POSrf  hX   INFORMrf  hNhNuK}rf  (hhFh	X  ```\n#include &lt;stdio.h&gt;\n#include &lt;allegro5/allegro.h&gt;\n#include &lt;allegro5/allegro_font.h&gt;\n#include &lt;allegro5/allegro_ttf.h&gt;\n\nint main(int argc, char **argv){\n\n if(!al_init()){\n fprintf(stderr, "Failed to initialize Allegro.\\n");\n return -1;\n }\n\n al_init_font_addon(); // initialize the font addon\n al_init_ttf_addon();// initialize the ttf (True Type Font) addon\n\n ALLEGRO_DISPLAY *display = al_create_display(640,480);\n \n if (!display){\n fprintf(stderr, "Failed to create display.\\n");\n return -1;\n }\n\n ALLEGRO_FONT *font = al_load_ttf_font("pirulen.ttf",72,0 );\n\n if (!font){\n fprintf(stderr, "Could not load \'pirulen.ttf\'.\\n");\n return -1;\n }\n\n al_clear_to_color(al_map_rgb(50,10,70));\n al_draw_text(font, al_map_rgb(255,255,255), 640/2, (480/4),ALLEGRO_ALIGN_CENTRE, "Your Text Here!");\n\n al_flip_display();\n\n al_rest(10.0);\n\n al_destroy_display(display);\n\n return 0;\n}\n```rf  hX   Apizarf  h
hQhX   CONTrf  hX   INFORMrf  h]rf  X   examplesrf  ahNuK	}rf  (hhQh	X   what is your name?rf  hX
   Programmerrf  h
NhNhX
   ELICIT-INFORMrf  hNhNuK
}rf  (hhXh	X   My name is Apiza.rf  hX   Apizarf  h
hchX   POSrf  hX   INFORMrf  hNhNuK}rf  (hhXh	X   Hello!rf  hX   Apizarf  h
NhNhX   BE-POSITIVErf  hNhNuK}rf  (hhch	X8   what is the interface / settings to play sound only oncerf  hX
   Programmerrf  h
NhNhX
   ELICIT-INFORMrf  h]rf  X   patternsrf  ahNuK
}rf  (hX   10rf  h	X   I do not need looprf  hX
   Programmerrf  h
X   12rf  hX   CONTrf  hX   INFORMrf  h]rf  X   patternsrf  ahNuK}rf  (hX   11r g  h	X!   Try using `ALLEGRO_PLAYMODE_ONCE`rg  hX   Apizarg  h
X   13rg  hX   POSrg  hX   SUGGESTrg  h]rg  X   patternsrg  ah]rg  X   ALLEGRO_PLAYMODEr	g  auK}r
g  (hX   12rg  h	X3   give me interface for al_play_sample all parametersrg  hX
   Programmerr
g  h
NhNhX
   ELICIT-INFORMrg  h]rg  X   basicrg  ah]rg  X   al_play_samplerg  auK}rg  (hX   13rg  h	X2   Here is the documentation on `al_play_sample`:\n\nrg  hX   Apizarg  h
X   15rg  hX   POSrg  hX   INFORMrg  hNh]rg  X   al_play_samplerg  auK}rg  (hX   13rg  h	X'  ```\nal_play_sample\n\nbool al_play_sample(ALLEGRO_SAMPLE *spl, float gain, float pan, float speed,\n ALLEGRO_PLAYMODE loop, ALLEGRO_SAMPLE_ID *ret_id)\n\nSource Code\n\nPlays a sample on one of the sample instances created by al_reserve_samples. Returns true on success, false on failure. Playback may fail because all the reserved sample instances are currently used.\n\nParameters:\n\n gain - relative volume at which the sample is played; 1.0 is normal.\n pan - 0.0 is centred, -1.0 is left, 1.0 is right, or ALLEGRO_AUDIO_PAN_NONE.\n speed - relative speed at which the sample is played; 1.0 is normal.\n loop - ALLEGRO_PLAYMODE_ONCE, ALLEGRO_PLAYMODE_LOOP, or ALLEGRO_PLAYMODE_BIDIR\n ret_id - if non-NULL the variable which this points to will be assigned an id representing the sample being played. If al_play_sample returns false, then the contents of ret_id are invalid and must not be used as argument to other functions.\n\nSee also: ALLEGRO_PLAYMODE, ALLEGRO_AUDIO_PAN_NONE, ALLEGRO_SAMPLE_ID, al_stop_sample, al_stop_samples, al_lock_sample_id.\n```rg  hX   Apizarg  h
X   16r g  hX   CONTr!g  hX   INFORMr"g  h]r#g  (X
   functionalityr$g  X   conceptsr%g  X
   directivesr&g  X	   structurer'g  X   basicr(g  eh]r)g  X   al_play_sampler*g  auuuK}r+g  (hj?>  h}r,g  (K }r-g  (hhh	X   How do I register key events?r.g  hX
   Programmerr/g  h
NhNhX   ELICIT-OFFER-OR-SUGGESTIONr0g  h]r1g  X   patternsr2g  ahNuK}r3g  (hhh	X4   You'll most likely want to be using al_key_down:\n\nr4g  hX   Apizar5g  h
hhX   POSr6g  hX   SUGGESTr7g  h]r8g  X   patternsr9g  ah]r:g  X   al_key_downr;g  auK}r<g  (hhh	XF   bool al_key_down(const ALLEGRO_KEYBOARD_STATE *state, int keycode)\n\nr=g  hX   Apizar>g  h
hhX   CONTr?g  hX   INFORMr@g  h]rAg  X   basicrBg  ah]rCg  X   al_key_downrDg  auK}rEg  (hhh	XF   Return true if the key specified was held down in the state specified.rFg  hX   ApizarGg  h
hhX   CONTrHg  hX   INFORMrIg  h]rJg  X
   functionalityrKg  ahNuK}rLg  (hh+h	X-   Can I use keyboard events as an event source?rMg  hX
   ProgrammerrNg  h
NhNhX
   ELICIT-INFORMrOg  h]rPg  X
   functionalityrQg  ahNuK}rRg  (hh5h	X   Yes, rSg  hX   ApizarTg  h
h5hX   POSrUg  hX   INFORMrVg  h]rWg  X
   functionalityrXg  ahNuK}rYg  (hh5h	X&   you'll want to use something like:\n\nrZg  hX   Apizar[g  h
h<hX   CONTr\g  hX   SUGGESTr]g  hNhNuK}r^g  (hh5h	XF   al_register_event_source(event_queue, al_get_keyboard_event_source());r_g  hX   Apizar`g  h
hFhX   CONTrag  hX   INFORMrbg  h]rcg  X   examplesrdg  ah]reg  X   al_register_event_sourcerfg  auK}rgg  (hh<h	X$   What event type is a keyboard event?rhg  hX
   Programmerrig  h
NhNhX
   ELICIT-INFORMrjg  h]rkg  X	   structurerlg  ahNuK	}rmg  (hhFh	X]   One of the following:\n\nALLEGRO_EVENT_KEY_DOWN\nALLEGRO_EVENT_KEY_UP\nALLEGRO_EVENT_KEY_CHARrng  hX   Apizarog  h
hXhX   POSrpg  hX   INFORMrqg  h]rrg  X	   structurersg  ahNuK
}rtg  (hhQh	X1   How do I access the keycode from an event object?rug  hX
   Programmerrvg  h
hchX   FOLrwg  hX   ELICIT-OFFER-OR-SUGGESTIONrxg  h]ryg  X   patternsrzg  ahNuK}r{g  (hhXh	X:   ev.keyboard.keycode will get you the keycode for event ev.r|g  hX   Apizar}g  h
X   10r~g  hX   POSrg  hX   SUGGESTrg  h]rg  X   patternsrg  ah]rg  X
   ALLEGRO_EVENTrg  auK}rg  (hhch	X3   What are the keycodes for up, down, left and right?rg  hX
   Programmerrg  h
X   11rg  hX   FOLrg  hX
   ELICIT-INFORMrg  h]rg  X   patternsrg  ahNuK
}rg  (hX   10rg  h	X6   The keycodes for the arrow keys are the following:\n\nrg  hX   Apizarg  h
X   12rg  hX   POSrg  hX   INFORMrg  h]rg  X   patternsrg  ahNuK}rg  (hX   10rg  h	XE   ALLEGRO_KEY_LEFT\nALLEGRO_KEY_RIGHT\nALLEGRO_KEY_UP\nALLEGRO_KEY_DOWNrg  hX   Apizarg  h
X   13rg  hX   CONTrg  hX   INFORMrg  h]rg  X   patternsrg  ahNuK}rg  (hX   11rg  h	XJ   al_get_keyboard is failing with "Assertion `new_keyboard_driver\' failed".rg  hX
   Programmerrg  h
hQhX   FOLrg  hX   INFORMrg  h]rg  X
   functionalityrg  ahNuK}rg  (hX   11rg  h	X    What might be the cause of this?rg  hX
   Programmerrg  h
X   15rg  hX   CONTrg  hX
   ELICIT-INFORMrg  h]rg  X
   functionalityrg  ahNuK}rg  (hX   12rg  h	X$   Have you called al_install_keyboard?rg  hX   Apizarg  h
X   16rg  hX   FOLrg  hX
   ELICIT-INFORMrg  h]rg  X   patternsrg  ah]rg  X   al_install_keyboardrg  auK}rg  (hX   13rg  h	X"   How do I call al_install_keyboard?rg  hX
   Programmerrg  h
X   17rg  hX   FOLrg  hX   ELICIT-OFFER-OR-SUGGESTIONrg  h]rg  X   patternsrg  ah]rg  X   al_install_keyboardrg  auK}rg  (hX   14rg  h	X&   al_install_keyboard() should work.\n\nrg  hX   Apizarg  h
X   18rg  hX   POSrg  hX   SUGGESTrg  h]rg  X   patternsrg  ah]rg  X   al_install_keyboardrg  auK}rg  (hX   14rg  h	X"   bool al_install_keyboard(void)\n\nrg  hX   Apizarg  h
X   19rg  hX   CONTrg  hX   INFORMrg  h]rg  X   basicrg  ah]rg  X   al_install_keyboardrg  auK}rg  (hX   14rg  h	X   Install a keyboard driver. rg  hX   Apizarg  h
X   20rg  hX   CONTrg  hX   INFORMrg  h]rg  X
   functionalityrg  ah]rg  X   al_install_keyboardrg  auK}rg  (hX   14rg  h	Xd   Returns true if successful. If a driver was already installed, nothing happens and true is returned.rg  hX   Apizarg  h
X   21rg  hX   CONTrg  hX   INFORMrg  h]rg  X
   functionalityrg  ah]rg  X   al_install_keyboardrg  auK}rg  (hX   15rg  h	X!   How do I play a sound in Allegro?rg  hX
   Programmerrg  h
NhNhX   ELICIT-OFFER-OR-SUGGESTIONrg  h]rg  X   patternsrg  ahNuK}rg  (hX   16rg  h	X;   You should be able to play a sound with al_play_sample:\n\nrg  hX   Apizarg  h
X   23rg  hX   POSrg  hX   SUGGESTrg  h]r h  X   patternsrh  ah]rh  X   al_play_samplerh  auK}rh  (hX   16rh  h	X   bool al_play_sample(ALLEGRO_SAMPLE *spl, float gain, float pan, float speed,\n ALLEGRO_PLAYMODE loop, ALLEGRO_SAMPLE_ID *ret_id)\n\nrh  hX   Apizarh  h
X   24rh  hX   CONTr	h  hX   INFORMr
h  h]rh  X   basicrh  ah]r
h  X   al_play_samplerh  auK}rh  (hX   16rh  h	XM   Plays a sample on one of the sample instances created by al_reserve_samples. rh  hX   Apizarh  h
X   25rh  hX   CONTrh  hX   INFORMrh  h]rh  (X
   functionalityrh  X   patternsrh  eh]rh  X   al_play_samplerh  auK}rh  (hX   16rh  h	X+   Returns true on success, false on failure. rh  hX   Apizarh  h
X   26rh  hX   CONTr h  hX   INFORMr!h  h]r"h  X
   functionalityr#h  ah]r$h  X   al_play_sampler%h  auK}r&h  (hX   16r'h  h	XS   Playback may fail because all the reserved sample instances are currently used.\n\nr(h  hX   Apizar)h  h
X   27r*h  hX   CONTr+h  hX   INFORMr,h  h]r-h  X
   functionalityr.h  ah]r/h  X   al_play_sampler0h  auK}r1h  (hX   16r2h  h	X*  Parameters:\n\ngain - relative volume at which the sample is played; 1.0 is normal.\npan - 0.0 is centred, -1.0 is left, 1.0 is right, or ALLEGRO_AUDIO_PAN_NONE.\nspeed - relative speed at which the sample is played; 1.0 is normal.\nloop - ALLEGRO_PLAYMODE_ONCE, ALLEGRO_PLAYMODE_LOOP, or ALLEGRO_PLAYMODE_BIDIR\nret_id - if non-NULL the variable which this points to will be assigned an id representing the sample being played. If al_play_sample returns false, then the contents of ret_id are invalid and must not be used as argument to other functions.r3h  hX   Apizar4h  h
X   28r5h  hX   CONTr6h  hX   INFORMr7h  h]r8h  (X   conceptsr9h  X   patternsr:h  X
   functionalityr;h  eh]r<h  X   al_play_sampler=h  auK}r>h  (hX   17r?h  h	X"   How do I load a sample in Allegro?r@h  hX
   ProgrammerrAh  h
X   29rBh  hX   FOLrCh  hX   ELICIT-OFFER-OR-SUGGESTIONrDh  h]rEh  X   patternsrFh  ahNuK}rGh  (hX   18rHh  h	X<   You should be able to load a sample with al_load_sample:\n\nrIh  hX   ApizarJh  h
X   30rKh  hX   POSrLh  hX   SUGGESTrMh  h]rNh  X   patternsrOh  ah]rPh  X   al_load_samplerQh  auK }rRh  (hX   18rSh  h	X8   ALLEGRO_SAMPLE *al_load_sample(const char *filename)\n\nrTh  hX   ApizarUh  h
X   31rVh  hX   CONTrWh  hX   INFORMrXh  h]rYh  X   basicrZh  ah]r[h  X   al_load_sampler\h  auK!}r]h  (hX   18r^h  h	XF   Loads a few different audio file formats based on their extension.\n\nr_h  hX   Apizar`h  h
X   32rah  hX   CONTrbh  hX   INFORMrch  h]rdh  X
   functionalityreh  ah]rfh  X   al_load_samplergh  auK"}rhh  (hX   18rih  h	X   Note that this stores the entire file in memory at once, which may be time consuming. To read the file as it is needed, use al_load_audio_stream.\n\nrjh  hX   Apizarkh  h
X   33rlh  hX   CONTrmh  hX   INFORMrnh  h]roh  (X   qualityrph  X   patternsrqh  eh]rrh  X   al_load_samplersh  auK#}rth  (hX   18ruh  h	X/   Returns the sample on success, NULL on failure.rvh  hX   Apizarwh  h
X   34rxh  hX   CONTryh  hX   INFORMrzh  h]r{h  X
   functionalityr|h  ah]r}h  X   al_load_sampler~h  auK$}rh  (hX   19rh  h	X:   How do I get more detailed error information from Allegro?rh  hX
   Programmerrh  h
NhNhX   ELICIT-OFFER-OR-SUGGESTIONrh  h]rh  X   patternsrh  ahNuK%}rh  (hX   20rh  h	XP   I don't think you can get more detailed information than you're already getting.rh  hX   Apizarh  h
X   36rh  hX   PARTrh  hX   INFORMrh  h]rh  X
   functionalityrh  ahNuK&}rh  (hX   20rh  h	X<   Is there any error in particular you're having trouble with?rh  hX   Apizarh  h
X   37rh  hX   FOLrh  hX
   ELICIT-INFORMrh  h]rh  X
   functionalityrh  ahNuK'}rh  (hX   21rh  h	X!   al_load_sample is returning NULL.rh  hX
   Programmerrh  h
X   38rh  hX   POSrh  hX   INFORMrh  h]rh  X
   functionalityrh  ah]rh  X   al_load_samplerh  auK(}rh  (hX   21rh  h	X!   Is there any way to find out why?rh  hX
   Programmerrh  h
X   39rh  hX   FOLrh  hX   ELICIT-OFFER-OR-SUGGESTIONrh  h]rh  X   patternsrh  ah]rh  X   al_load_samplerh  auK)}rh  (hX   22rh  h	X'   al_load_sample returns NULL on failure.rh  hX   Apizarh  h
X   40rh  hX   PARTrh  hX   INFORMrh  h]rh  X
   functionalityrh  ah]rh  X   al_load_samplerh  auK*}rh  (hX   22rh  h	X)   Have you called al_init_acodec_addon?\n\nrh  hX   Apizarh  h
X   41rh  hX   FOLrh  hX
   ELICIT-INFORMrh  h]rh  X   patternsrh  ah]rh  (X   al_load_samplerh  X   al_init_acodec_addonrh  euK+}rh  (hX   22rh  h	X#   bool al_init_acodec_addon(void)\n\nrh  hX   Apizarh  h
X   42rh  hX   FOLrh  hX   INFORMrh  h]rh  X   basicrh  ah]rh  X   al_init_acodec_addonrh  auK,}rh  (hX   22rh  h	X  This function registers all the known audio file type handlers for al_load_sample, al_save_sample, al_load_audio_stream, etc.\n\nDepending on what libraries are available, the full set of recognised extensions is: .wav, .flac, .ogg, .opus, .it, .mod, .s3m, .xm, .voc.\n\nrh  hX   Apizarh  h
X   43rh  hX   CONTrh  hX   INFORMrh  h]rh  (X
   functionalityrh  X   purposerh  X
   directivesrh  eh]rh  X   al_init_acodec_addonrh  auK-}rh  (hX   22rh  h	X-  Limitations:\n\nSaving is only supported for wav files.\n\nThe wav file loader currently only supports 8/16 bit little endian PCM files. 16 bits are used when saving wav files. Use flac files if more precision is required.\n\nModule files (.it, .mod, .s3m, .xm) are often composed with streaming in mind, and sometimes cannot be easily rendered into a finite length sample. Therefore they cannot be loaded with al_load_sample/al_load_sample_f and must be streamed with al_load_audio_stream or al_load_audio_stream_f.\n\n.voc file streaming is unimplemented.rh  hX   Apizarh  h
X   44rh  hX   CONTrh  hX   INFORMrh  h]rh  (X
   directivesrh  X   qualityrh  eh]rh  X   al_init_acodec_addonrh  auK.}rh  (hX   23rh  h	X"   Now al_load_sample is segfaulting.rh  hX
   Programmerrh  h
X   45rh  hX   FOLrh  hX   INFORMrh  h]rh  X
   functionalityrh  ah]rh  X   al_load_samplerh  auK/}rh  (hX   23rh  h	XB   Is there anything else I need to do before calling al_load_sample?rh  hX
   Programmerrh  h
X   46rh  hX   FOLrh  hX   ELICIT-OFFER-OR-SUGGESTIONrh  h]rh  X   patternsrh  ah]rh  X   al_load_samplerh  auK0}rh  (hX   24r i  h	X0   You'll also want to call al_reserve_samples:\n\nri  hX   Apizari  h
X   47ri  hX   POSri  hX   SUGGESTri  h]ri  X   patternsri  ah]ri  (X   al_load_sampler	i  X   al_reserve_samplesr
i  euK1}ri  (hX   24ri  h	X0   bool al_reserve_samples(int reserve_samples)\n\nr
i  hX   Apizari  h
X   48ri  hX   CONTri  hX   INFORMri  h]ri  X   basicri  ah]ri  X   al_reserve_samplesri  auK2}ri  (hX   24ri  h	X  Reserves a number of sample instances, attaching them to the default mixer. If no default mixer is set when this function is called, then it will create one and attach it to the default voice. If no default voice has been set, it, too, will be created.\n\nIf you call this function a second time with a smaller number of samples, then the excess internal sample instances will be destroyed causing some sounds to stop and some instances returned by al_lock_sample_id to be invalidated.\n\nThis diagram illustrates the structures that are set up:\n\n sample instance 1\n / sample instance 2\ndefault voice &lt;-- default mixer &lt;--- .\n \\ .\n sample instance N\n\nri  hX   Apizari  h
X   49ri  hX   CONTri  hX   INFORMri  h]ri  (X
   functionalityri  X   patternsri  eh]r i  X   al_reserve_samplesr!i  auK3}r"i  (hX   24r#i  h	X(   Returns true on success, false on error.r$i  hX   Apizar%i  h
X   50r&i  hX   CONTr'i  hX   INFORMr(i  h]r)i  X
   functionalityr*i  ah]r+i  X   al_reserve_samplesr,i  auK4}r-i  (hX   24r.i  h	X.    al_install_audio must have been called first.r/i  hX   Apizar0i  h
X   51r1i  hX   CONTr2i  hX   INFORMr3i  h]r4i  X
   directivesr5i  ah]r6i  (X   al_install_audior7i  X   al_reserve_samplesr8i  euK5}r9i  (hX   25r:i  h	X   How do I load a font?r;i  hX
   Programmerr<i  h
NhNhX   ELICIT-OFFER-OR-SUGGESTIONr=i  h]r>i  X   patternsr?i  ahNuK6}r@i  (hX   26rAi  h	X/   al_load_font will allow you to load a font:\n\nrBi  hX   ApizarCi  h
X   53rDi  hX   POSrEi  hX   SUGGESTrFi  h]rGi  X   patternsrHi  ah]rIi  X   al_load_fontrJi  auK7}rKi  (hX   26rLi  h	XI   ALLEGRO_FONT *al_load_font(char const *filename, int size, int flags)\n\nrMi  hX   ApizarNi  h
X   54rOi  hX   CONTrPi  hX   INFORMrQi  h]rRi  X   basicrSi  ah]rTi  X   al_load_fontrUi  auK8}rVi  (hX   26rWi  h	X2  Loads a font from disk. This will use al_load_bitmap_font_flags if you pass the name of a known bitmap format, or else al_load_ttf_font.\n\nThe flags parameter is passed through to either of those functions. Bitmap and TTF fonts are also affected by the current bitmap flags at the time the font is loaded.rXi  hX   ApizarYi  h
X   55rZi  hX   CONTr[i  hX   INFORMr\i  h]r]i  (X
   functionalityr^i  X   controlr_i  eh]r`i  X   al_load_fontrai  auK9}rbi  (hX   27rci  h	X)   What flags can be passed to al_load_font?rdi  hX
   Programmerrei  h
X   56rfi  hX   FOLrgi  hX
   ELICIT-INFORMrhi  h]rii  X
   directivesrji  ah]rki  X   al_load_fontrli  auK:}rmi  (hX   28rni  h	XV  It will take the following if you pass the name of a known bitmap format:\n\nALLEGRO_NO_PREMULTIPLIED_ALPHA\nBy default, Allegro pre-multiplies the alpha channel of an image with the images color data when it loads it. Typically that would look something like this:\n\nr = get_float_byte();\ng = get_float_byte();\nb = get_float_byte();\na = get_float_byte();\n\nr = r * a;\ng = g * a;\nb = b * a;\n\nset_image_pixel(x, y, r, g, b, a);\nThe reason for this can be seen in the Allegro example ex_premulalpha, ie, using pre-multiplied alpha gives more accurate color results in some cases. To use alpha blending with images loaded with pre-multiplied alpha, you would use the default blending mode, which is set with al_set_blender(ALLEGRO_ADD, ALLEGRO_ONE, ALLEGRO_INVERSE_ALPHA).\n\nThe ALLEGRO_NO_PREMULTIPLIED_ALPHA flag being set will ensure that images are not loaded with alpha pre-multiplied, but are loaded with color values direct from the image. That looks like this:\n\nr = get_float_byte();\ng = get_float_byte();\nb = get_float_byte();\na = get_float_byte();\n\nset_image_pixel(x, y, r, g, b, a);\nTo draw such an image using regular alpha blending, you would use al_set_blender(ALLEGRO_ADD, ALLEGRO_ALPHA, ALLEGRO_INVERSE_ALPHA) to set the correct blender. This has some caveats. First, as mentioned above, drawing such an image can result in less accurate color blending (when drawing an image with linear filtering on, the edges will be darker than they should be). Second, the behaviour is somewhat confusing, which is explained in the example below.\n\n// Load and create bitmaps with an alpha channel\nal_set_new_bitmap_format(ALLEGRO_PIXEL_FORMAT_ANY_32_WITH_ALPHA);\n// Load some bitmap with alpha in it\nbmp = al_load_bitmap("some_alpha_bitmap.png");\n// We will draw to this buffer and then draw this buffer to the screen\ntmp_buffer = al_create_bitmap(SCREEN_W, SCREEN_H);\n// Set the buffer as the target and clear it\nal_set_target_bitmap(tmp_buffer);\nal_clear_to_color(al_map_rgba_f(0, 0, 0, 1));\n// Draw the bitmap to the temporary buffer\nal_draw_bitmap(bmp, 0, 0, 0);\n// Finally, draw the buffer to the screen\n// The output will look incorrect (may take close inspection\n// depending on the bitmap -- it may also be very obvious)\nal_set_target_bitmap(al_get_backbuffer(display));\nal_draw_bitmap(tmp_buffer, 0, 0, 0);\nTo explain further, if you have a pixel with 0.5 alpha, and you\'re using (ALLEGRO_ADD, ALLEGRO_ALPHA, ALLEGRO_INVERSE_ALPHA) for blending, the formula is:\n\na = da * dst + sa * src\nExpands to:\n\nresult_a = dst_a * (1-0.5) + 0.5 * 0.5\nSo if you draw the image to the temporary buffer, it is blended once resulting in 0.75 alpha, then drawn again to the screen, blended in the same way, resulting in a pixel has 0.1875 as an alpha value.\n\nOtherwise it will use the following:\n\nALLEGRO_TTF_NO_KERNING - Do not use any kerning even if the font file supports it.\n\nALLEGRO_TTF_MONOCHROME - Load as a monochrome font (which means no anti-aliasing of the font is done).\n\nALLEGRO_TTF_NO_AUTOHINT - Disable the Auto Hinter which is enabled by default in newer versions of FreeType. Since: 5.0.6, 5.1.2roi  hX   Apizarpi  h
X   57rqi  hX   POSrri  hX   INFORMrsi  h]rti  (X
   directivesrui  X   purposervi  X   qualityrwi  X   patternsrxi  X   examplesryi  X   environmentrzi  eh]r{i  X   al_load_fontr|i  auK;}r}i  (hX   29r~i  h	X   How do I display text?ri  hX
   Programmerri  h
NhNhX   ELICIT-OFFER-OR-SUGGESTIONri  h]ri  X   patternsri  ahNuK<}ri  (hX   30ri  h	X2   al_draw_text should allow you to display text:\n\nri  hX   Apizari  h
X   59ri  hX   POSri  hX   SUGGESTri  h]ri  X   patternsri  ah]ri  X   al_draw_textri  auK=}ri  (hX   30ri  h	Xw   void al_draw_text(const ALLEGRO_FONT *font,\n ALLEGRO_COLOR color, float x, float y, int flags,\n char const *text)\n\nri  hX   Apizari  h
X   60ri  hX   CONTri  hX   INFORMri  h]ri  X   basicri  ah]ri  X   al_draw_textri  auK>}ri  (hX   30ri  h	Xl   Writes the NUL-terminated string text onto the target bitmap at position x, y, using the specified font.\n\nri  hX   Apizari  h
X   61ri  hX   CONTri  hX   INFORMri  h]ri  X
   functionalityri  ah]ri  X   al_draw_textri  auK?}ri  (hX   30ri  h	X  The flags parameter can be 0 or one of the following flags:\n\nALLEGRO_ALIGN_LEFT - Draw the text left-aligned (same as 0).\nALLEGRO_ALIGN_CENTRE - Draw the text centered around the given position.\nALLEGRO_ALIGN_RIGHT - Draw the text right-aligned to the given position.\nIt can also be combined with this flag:\n\nALLEGRO_ALIGN_INTEGER - Always draw text aligned to an integer pixel position. This was formerly the default behaviour. Since: 5.0.8, 5.1.4\nri  hX   Apizari  h
X   62ri  hX   CONTri  hX   INFORMri  h]ri  (X
   directivesri  X   patternsri  X   environmentri  eh]ri  X   al_draw_textri  auK@}ri  (hX   30ri  h	X{   This function does not support newline characters (\\n), but you can use al_draw_multiline_text for multi line text output.ri  hX   Apizari  h
X   63ri  hX   CONTri  hX   INFORMri  h]ri  (X
   directivesri  X   patternsri  eh]ri  X   al_draw_textri  auKA}ri  (hX   31ri  h	X   al_load_font is returning NULL.ri  hX
   Programmerri  h
NhNhX   INFORMri  h]ri  X
   functionalityri  ah]ri  X   al_load_fontri  auKB}ri  (hX   31ri  h	X   What are some possible reasons?ri  hX
   Programmerri  h
X   65ri  hX   CONTri  hX
   ELICIT-INFORMri  h]ri  X
   functionalityri  ah]ri  X   al_load_fontri  auKC}ri  (hX   32ri  h	X/   Are you sure the filename and size are correct?ri  hX   Apizari  h
X   66ri  hX   FOLri  hX
   ELICIT-INFORMri  h]ri  X
   directivesri  ah]ri  X   al_load_fontri  auKD}ri  (hX   33ri  h	X+   What is the size parameter in al_load_font?ri  hX
   Programmerri  h
X   67ri  hX   FOLri  hX
   ELICIT-INFORMri  h]ri  X   conceptsri  ah]ri  X   al_load_fontri  auKE}ri  (hX   34ri  h	X   The size parameter determines the size the font will be rendered at, specified in pixels. The standard font size is measured in units per EM, if you instead want to specify the size as the total height of glyphs in pixels, pass it as a negative value.ri  hX   Apizari  h
X   68ri  hX   POSri  hX   INFORMri  h]ri  X   conceptsri  ah]ri  X   al_load_fontri  auKF}ri  (hX   35ri  h	X7   Do I need to call anything before calling al_load_font?ri  hX
   Programmerri  h
X   69ri  hX   NEGri  hX   ELICIT-OFFER-OR-SUGGESTIONri  h]ri  X
   directivesri  ah]ri  X   al_load_fontri  auKG}ri  (hX   36ri  h	X   You may need to call al_init_font_addon and/or al_init_ttf_addon, along with al_create_display in order to display the font once it has loaded.r j  hX   Apizarj  h
X   70rj  hX   POSrj  hX   SUGGESTrj  h]rj  (X
   directivesrj  X   patternsrj  eh]rj  (X   al_load_fontr	j  X   al_init_font_addonr
j  X   al_init_ttf_addonrj  X   al_create_displayrj  euKH}r
j  (hX   37rj  h	X   How do I load an image?rj  hX
   Programmerrj  h
NhNhX   ELICIT-OFFER-OR-SUGGESTIONrj  h]rj  X   patternsrj  ahNuKI}rj  (hX   38rj  h	XH   You should be able to load an image from a file with al_load_bitmap:\n\nrj  hX   Apizarj  h
X   72rj  hX   POSrj  hX   SUGGESTrj  h]rj  X   patternsrj  ah]rj  X   al_load_bitmaprj  auKJ}rj  (hX   38r j  h	X8   ALLEGRO_BITMAP *al_load_bitmap(const char *filename)\n\nr!j  hX   Apizar"j  h
X   73r#j  hX   CONTr$j  hX   INFORMr%j  h]r&j  X   basicr'j  ah]r(j  X   al_load_bitmapr)j  auKK}r*j  (hX   38r+j  h	X!  Loads an image file into a new ALLEGRO_BITMAP. The file type is determined by the extension, except if the file has no extension in which case al_identify_bitmap is used instead.\n\nReturns NULL on error.\n\nThis is the same as calling al_load_bitmap_flags with a flags parameter of 0.\n\nr,j  hX   Apizar-j  h
X   74r.j  hX   CONTr/j  hX   INFORMr0j  h]r1j  (X
   functionalityr2j  X	   structurer3j  eh]r4j  X   al_load_bitmapr5j  auKL}r6j  (hX   38r7j  h	X   Note: the core Allegro library does not support any image file formats by default. You must use the allegro_image addon, or register your own format handler.r8j  hX   Apizar9j  h
X   75r:j  hX   CONTr;j  hX   INFORMr<j  h]r=j  (X
   directivesr>j  X   qualityr?j  eh]r@j  X   al_load_bitmaprAj  auKM}rBj  (hX   39rCj  h	X9   Do I need to call anything before calling al_load_bitmap?rDj  hX
   ProgrammerrEj  h
X   76rFj  hX   FOLrGj  hX   ELICIT-OFFER-OR-SUGGESTIONrHj  h]rIj  X
   directivesrJj  ah]rKj  X   al_load_bitmaprLj  auKN}rMj  (hX   40rNj  h	X5   You'll probably want to call al_init_image_addon:\n\nrOj  hX   ApizarPj  h
X   77rQj  hX   POSrRj  hX   SUGGESTrSj  h]rTj  X   patternsrUj  ah]rVj  (X   al_load_bitmaprWj  X   al_init_image_addonrXj  euKO}rYj  (hX   40rZj  h	X"   bool al_init_image_addon(void)\n\nr[j  hX   Apizar\j  h
X   78r]j  hX   CONTr^j  hX   INFORMr_j  h]r`j  X   basicraj  ah]rbj  X   al_init_image_addonrcj  auKP}rdj  (hX   40rej  h	Xx  Initializes the image addon. This registers bitmap format handlers for al_load_bitmap, al_load_bitmap_f, al_save_bitmap, al_save_bitmap_f.\n\nThe following types are built into the Allegro image addon and guaranteed to be available: BMP, DDS, PCX, TGA. Every platform also supports JPEG and PNG via external dependencies.\n\nOther formats may be available depending on the operating system and installed libraries, but are not guaranteed and should not be assumed to be universally available.\n\nThe DDS format is only supported to load from, and only if the DDS file contains textures compressed in the DXT1, DXT3 and DXT5 formats.rfj  hX   Apizargj  h
X   79rhj  hX   CONTrij  hX   INFORMrjj  h]rkj  (X
   functionalityrlj  X
   directivesrmj  X   environmentrnj  eh]roj  X   al_init_image_addonrpj  auKQ}rqj  (hX   40rrj  h	X    Note that when loading a DDS file, the created bitmap will always be a video bitmap and will have the pixel format matching the format in the file.rsj  hX   Apizartj  h
X   80ruj  hX   CONTrvj  hX   INFORMrwj  h]rxj  X
   functionalityryj  ah]rzj  X   al_init_image_addonr{j  auKR}r|j  (hX   41r}j  h	X   I need PNG support,r~j  hX
   Programmerrj  h
X   81rj  hX   FOLrj  hX   INFORMrj  h]rj  X   patternsrj  ahNuKS}rj  (hX   41rj  h	X   how do I load that?rj  hX
   Programmerrj  h
X   82rj  hX   CONTrj  hX   ELICIT-OFFER-OR-SUGGESTIONrj  h]rj  X   patternsrj  ahNuKT}rj  (hX   42rj  h	XR   As long as you've called al_init_image_addon you should already have PNG support. rj  hX   Apizarj  h
X   83rj  hX   POSrj  hX   INFORMrj  h]rj  (X
   functionalityrj  X   patternsrj  eh]rj  X   al_init_image_addonrj  auKU}rj  (hX   42rj  h	X*   Are you having trouble loading a PNG file?rj  hX   Apizarj  h
X   84rj  hX   FOLrj  hX
   ELICIT-INFORMrj  h]rj  X
   functionalityrj  ahNuKV}rj  (hX   43rj  h	X   I've loaded the bitmap,rj  hX
   Programmerrj  h
NhNhX   INFORMrj  h]rj  X   patternsrj  ahNuKW}rj  (hX   43rj  h	X%   how do I blit it onto another bitmap?rj  hX
   Programmerrj  h
X   86rj  hX   CONTrj  hX   ELICIT-OFFER-OR-SUGGESTIONrj  h]rj  X   patternsrj  ahNuKX}rj  (hX   44rj  h	X,   What do you want to do with the two bitmaps?rj  hX   Apizarj  h
X   87rj  hX   FOLrj  hX
   ELICIT-INFORMrj  h]rj  X   patternsrj  ahNuKY}rj  (hX   45rj  h	X&   I want to draw one bitmap over anotherrj  hX
   Programmerrj  h
X   88rj  hX   POSrj  hX   INFORMrj  h]rj  X   patternsrj  ahNuKZ}rj  (hX   46rj  h	XK   al_draw_bitmap should allow you to draw a second bitmap over the first:\n\nrj  hX   Apizarj  h
X   89rj  hX   POSrj  hX   SUGGESTrj  h]rj  X   patternsrj  ah]rj  X   al_draw_bitmaprj  auK[}rj  (hX   46rj  h	XN   void al_draw_bitmap(ALLEGRO_BITMAP *bitmap, float dx, float dy, int flags)\n\nrj  hX   Apizarj  h
X   90rj  hX   CONTrj  hX   INFORMrj  h]rj  X   basicrj  ah]rj  X   al_draw_bitmaprj  auK\}rj  (hX   46rj  h	Xv   Draws an unscaled, unrotated bitmap at the given position to the current target bitmap (see al_set_target_bitmap).\n\nrj  hX   Apizarj  h
X   91rj  hX   CONTrj  hX   INFORMrj  h]rj  X
   functionalityrj  ah]rj  X   al_draw_bitmaprj  auK]}rj  (hX   46rj  h	X   flags can be a combination of:\n\nALLEGRO_FLIP_HORIZONTAL - flip the bitmap about the y-axis\nALLEGRO_FLIP_VERTICAL - flip the bitmap about the x-axis\n\nrj  hX   Apizarj  h
X   92rj  hX   CONTrj  hX   INFORMrj  h]rj  (X
   directivesrj  X   patternsrj  eh]rj  X   al_draw_bitmaprj  auK^}rj  (hX   46rj  h	X7  Note: The current target bitmap must be a different bitmap. Drawing a bitmap to itself (or to a sub-bitmap of itself) or drawing a sub-bitmap to its parent (or another sub-bitmap of its parent) are not currently supported. To copy part of a bitmap into the same bitmap simply use a temporary bitmap instead.\n\nrj  hX   Apizarj  h
X   93rj  hX   CONTrj  hX   INFORMrj  h]rj  (X
   directivesrj  X   qualityrj  X
   functionalityrj  eh]rj  X   al_draw_bitmaprj  auK_}rj  (hX   46r k  h	XE  Note: The backbuffer (or a sub-bitmap thereof) can not be transformed, blended or tinted. If you need to draw the backbuffer draw it to a temporary bitmap first with no active transformation (except translation). Blending and tinting settings/parameters will be ignored. This does not apply when drawing into a memory bitmap.rk  hX   Apizark  h
X   94rk  hX   CONTrk  hX   INFORMrk  h]rk  (X
   functionalityrk  X
   directivesrk  X   qualityr	k  eh]r
k  X   al_draw_bitmaprk  auK`}rk  (hX   47r
k  h	X   How do I scale a bitmap?rk  hX
   Programmerrk  h
NhNhX   ELICIT-OFFER-OR-SUGGESTIONrk  h]rk  X   patternsrk  ahNuKa}rk  (hX   48rk  h	X=   al_draw_scaled_bitmap should allow you to scale a bitmap:\n\nrk  hX   Apizark  h
X   96rk  hX   POSrk  hX   SUGGESTrk  h]rk  X   patternsrk  ah]rk  X   al_draw_scaled_bitmaprk  auKb}rk  (hX   48rk  h	X   void al_draw_scaled_bitmap(ALLEGRO_BITMAP *bitmap,\n float sx, float sy, float sw, float sh,\n float dx, float dy, float dw, float dh, int flags)\n\nr k  hX   Apizar!k  h
X   97r"k  hX   CONTr#k  hX   INFORMr$k  h]r%k  X   basicr&k  ah]r'k  X   al_draw_scaled_bitmapr(k  auKc}r)k  (hX   48r*k  h	XD   Draws a scaled version of the given bitmap to the target bitmap.\n\nr+k  hX   Apizar,k  h
X   98r-k  hX   CONTr.k  hX   INFORMr/k  h]r0k  X
   functionalityr1k  ah]r2k  X   al_draw_scaled_bitmapr3k  auKd}r4k  (hX   48r5k  h	X   sx - source x\nsy - source y\nsw - source width\nsh - source height\ndx - destination x\ndy - destination y\ndw - destination width\ndh - destination height\nflags - same as for al_draw_bitmap\nr6k  hX   Apizar7k  h
X   99r8k  hX   CONTr9k  hX   INFORMr:k  h]r;k  X
   functionalityr<k  ah]r=k  X   al_draw_scaled_bitmapr>k  auKe}r?k  (hX   48r@k  h	XR   See al_draw_bitmap for a note on restrictions on which bitmaps can be drawn where.rAk  hX   ApizarBk  h
X   100rCk  hX   CONTrDk  hX   INFORMrEk  hNh]rFk  X   al_draw_scaled_bitmaprGk  auKf}rHk  (hX   49rIk  h	X)   How do I get a bitmap's width and height?rJk  hX
   ProgrammerrKk  h
NhNhX   ELICIT-OFFER-OR-SUGGESTIONrLk  h]rMk  X   patternsrNk  ahNuKg}rOk  (hX   50rPk  h	XM   al_get_bitmap_height and al_get_bitmap_width should allow you to do that:\n\nrQk  hX   ApizarRk  h
X   102rSk  hX   POSrTk  hX   SUGGESTrUk  h]rVk  X   patternsrWk  ah]rXk  (X   al_get_bitmap_heightrYk  X   al_get_bitmap_widthrZk  euKh}r[k  (hX   50r\k  h	X4   int al_get_bitmap_height(ALLEGRO_BITMAP *bitmap)\n\nr]k  hX   Apizar^k  h
X   103r_k  hX   CONTr`k  hX   INFORMrak  h]rbk  X   basicrck  ah]rdk  X   al_get_bitmap_heightrek  auKi}rfk  (hX   50rgk  h	X-   Returns the height of a bitmap in pixels.\n\nrhk  hX   Apizarik  h
X   104rjk  hX   CONTrkk  hX   INFORMrlk  h]rmk  X   basicrnk  ah]rok  X   al_get_bitmap_heightrpk  auKj}rqk  (hX   50rrk  h	X3   int al_get_bitmap_width(ALLEGRO_BITMAP *bitmap)\n\nrsk  hX   Apizartk  h
X   105ruk  hX   CONTrvk  hX   INFORMrwk  h]rxk  X   basicryk  ah]rzk  X   al_get_bitmap_widthr{k  auKk}r|k  (hX   50r}k  h	X(   Returns the width of a bitmap in pixels.r~k  hX   Apizark  h
X   106rk  hX   CONTrk  hX   INFORMrk  h]rk  X   basicrk  ah]rk  X   al_get_bitmap_widthrk  auKl}rk  (hX   51rk  h	X   How do I rotate a bitmap?rk  hX
   Programmerrk  h
NhNhX   ELICIT-OFFER-OR-SUGGESTIONrk  h]rk  X   patternsrk  ahNuKm}rk  (hX   52rk  h	X:   al_draw_rotated_bitmap should let you rotate a bitmap:\n\nrk  hX   Apizark  h
X   108rk  hX   POSrk  hX   SUGGESTrk  h]rk  X   patternsrk  ah]rk  X   al_draw_rotated_bitmaprk  auKn}rk  (hX   52rk  h	Xy   void al_draw_rotated_bitmap(ALLEGRO_BITMAP *bitmap,\n float cx, float cy, float dx, float dy, float angle, int flags)\n\nrk  hX   Apizark  h
X   109rk  hX   CONTrk  hX   INFORMrk  h]rk  X   basicrk  ah]rk  X   al_draw_rotated_bitmaprk  auKo}rk  (hX   52rk  h	XH  Draws a rotated version of the given bitmap to the target bitmap. The bitmap is rotated by 'angle' radians clockwise.\n\nThe point at cx/cy relative to the upper left corner of the bitmap will be drawn at dx/dy and the bitmap is rotated around this point. If cx,cy is 0,0 the bitmap will rotate around its upper left corner.\n\nrk  hX   Apizark  h
X   110rk  hX   CONTrk  hX   INFORMrk  h]rk  X
   functionalityrk  ah]rk  X   al_draw_rotated_bitmaprk  auKp}rk  (hX   52rk  h	X   cx - center x (relative to the bitmap)\ncy - center y (relative to the bitmap)\ndx - destination x\ndy - destination y\nangle - angle by which to rotate (radians)\nflags - same as for al_draw_bitmap\nrk  hX   Apizark  h
X   111rk  hX   CONTrk  hX   INFORMrk  h]rk  X
   functionalityrk  ah]rk  X   al_draw_rotated_bitmaprk  auKq}rk  (hX   52rk  h	X   Example\n\nfloat w = al_get_bitmap_width(bitmap);\nfloat h = al_get_bitmap_height(bitmap);\nal_draw_rotated_bitmap(bitmap, w / 2, h / 2, x, y, ALLEGRO_PI / 2, 0);\nThe above code draws the bitmap centered on x/y and rotates it 90° clockwise.\n\nrk  hX   Apizark  h
X   112rk  hX   CONTrk  hX   INFORMrk  h]rk  X   examplesrk  ah]rk  X   al_draw_rotated_bitmaprk  auKr}rk  (hX   52rk  h	XR   See al_draw_bitmap for a note on restrictions on which bitmaps can be drawn where.rk  hX   Apizark  h
X   113rk  hX   CONTrk  hX   INFORMrk  hNh]rk  X   al_draw_rotated_bitmaprk  auKs}rk  (hX   53rk  h	X   How do I capture mouse events?rk  hX
   Programmerrk  h
NhNhX   ELICIT-OFFER-OR-SUGGESTIONrk  h]rk  X   patternsrk  ahNuKt}rk  (hX   54rk  h	XC   al_get_mouse_event_source will give you the mouse event source:\n\nrk  hX   Apizark  h
X   115rk  hX   POSrk  hX   SUGGESTrk  h]rk  X   patternsrk  ah]rk  X   al_get_mouse_event_sourcerk  auKu}rk  (hX   54rk  h	X9   ALLEGRO_EVENT_SOURCE *al_get_mouse_event_source(void)\n\nrk  hX   Apizark  h
X   116rk  hX   CONTrk  hX   INFORMrk  h]rk  X   basicrk  ah]rk  X   al_get_mouse_event_sourcerk  auKv}rk  (hX   54rk  h	XY   Retrieve the mouse event source. All mouse events are generated by this event source.\n\nrk  hX   Apizark  h
X   117rk  hX   CONTrk  hX   INFORMrk  h]rk  X
   functionalityrk  ah]rk  X   al_get_mouse_event_sourcerk  auKw}rk  (hX   54rk  h	X6   Returns NULL if the mouse subsystem was not installed.rk  hX   Apizark  h
X   118rk  hX   CONTrk  hX   INFORMrk  h]rk  X
   functionalityrk  ah]rk  X   al_get_mouse_event_sourcer l  auKx}rl  (hX   55rl  h	X%   How do I install the mouse subsystem?rl  hX
   Programmerrl  h
NhNhX   ELICIT-OFFER-OR-SUGGESTIONrl  h]rl  X   patternsrl  ahNuKy}rl  (hX   56r	l  h	X$   al_install_mouse should do that:\n\nr
l  hX   Apizarl  h
X   120rl  hX   POSr
l  hX   SUGGESTrl  h]rl  X   patternsrl  ah]rl  X   al_install_mouserl  auKz}rl  (hX   56rl  h	X   bool al_install_mouse(void)\n\nrl  hX   Apizarl  h
X   121rl  hX   CONTrl  hX   INFORMrl  h]rl  X   basicrl  ah]rl  X   al_install_mouserl  auK{}rl  (hX   56rl  h	X   Install a mouse driver.\n\nr l  hX   Apizar!l  h
X   122r"l  hX   CONTr#l  hX   INFORMr$l  h]r%l  X
   functionalityr&l  ah]r'l  X   al_install_mouser(l  auK|}r)l  (hX   56r*l  h	Xd   Returns true if successful. If a driver was already installed, nothing happens and true is returned.r+l  hX   Apizar,l  h
X   123r-l  hX   CONTr.l  hX   INFORMr/l  h]r0l  X
   functionalityr1l  ah]r2l  X   al_install_mouser3l  auK}}r4l  (hX   57r5l  h	X(   What does a mouse click event look like?r6l  hX
   Programmerr7l  h
X   119r8l  hX   FOLr9l  hX
   ELICIT-INFORMr:l  h]r;l  X	   structurer<l  ahNuK~}r=l  (hX   58r>l  h	XY   ALLEGRO_MOUSE_STATE's buttons field will tell you whether or not it has been clicked:\n\nr?l  hX   Apizar@l  h
X   125rAl  hX   POSrBl  hX   SUGGESTrCl  h]rDl  X
   functionalityrEl  ah]rFl  X   ALLEGRO_MOUSE_STATErGl  auK}rHl  (hX   58rIl  h	X;   typedef struct ALLEGRO_MOUSE_STATE ALLEGRO_MOUSE_STATE;\n\nrJl  hX   ApizarKl  h
X   126rLl  hX   CONTrMl  hX   INFORMrNl  h]rOl  X   basicrPl  ah]rQl  X   ALLEGRO_MOUSE_STATErRl  auK}rSl  (hX   58rTl  h	XR  Public fields (read only):\n\nx - mouse x position\ny - mouse y position\nw, z - mouse wheel position (2D 'ball')\nbuttons - mouse buttons bitfield\n\nThe zeroth bit is set if the primary mouse button is held down, the first bit is set if the secondary mouse button is held down, and so on.\n\npressure - pressure, ranging from 0.0 to 1.0rUl  hX   ApizarVl  h
X   127rWl  hX   CONTrXl  hX   INFORMrYl  h]rZl  (X	   structurer[l  X
   directivesr\l  X
   functionalityr]l  eh]r^l  X   ALLEGRO_MOUSE_STATEr_l  auK}r`l  (hX   59ral  h	X(   What is the event type of a mouse click?rbl  hX
   Programmerrcl  h
X   128rdl  hX   FOLrel  hX
   ELICIT-INFORMrfl  h]rgl  X	   structurerhl  ahNuK}ril  (hX   60rjl  h	X#   ALLEGRO_EVENT_MOUSE_BUTTON_DOWN\n\nrkl  hX   Apizarll  h
X   129rml  hX   POSrnl  hX   INFORMrol  h]rpl  X   basicrql  ah]rrl  X   ALLEGRO_EVENT_MOUSE_BUTTON_DOWNrsl  auK}rtl  (hX   60rul  h	X   A mouse button was pressed.\n\nrvl  hX   Apizarwl  h
X   130rxl  hX   CONTryl  hX   INFORMrzl  h]r{l  X
   functionalityr|l  ah]r}l  X   ALLEGRO_EVENT_MOUSE_BUTTON_DOWNr~l  auK}rl  (hX   60rl  h	XE  mouse.x (int)\nx-coordinate\nmouse.y (int)\ny-coordinate\nmouse.z (int)\nz-coordinate\nmouse.w (int)\nw-coordinate\nmouse.button (unsigned)\nThe mouse button which was pressed, numbering from 1.\nmouse.pressure (float)\nPressure, ranging from 0.0 to 1.0.\nmouse.display (ALLEGRO_DISPLAY *)\nThe display which had mouse focus.rl  hX   Apizarl  h
X   131rl  hX   CONTrl  hX   INFORMrl  h]rl  (X	   structurerl  X
   directivesrl  X
   functionalityrl  eh]rl  X   ALLEGRO_EVENT_MOUSE_BUTTON_DOWNrl  auuuK}rl  (hj?>  h}rl  (K }rl  (hhh	X   hellorl  hX
   Programmerrl  h
NhNhX   BE-POSITIVErl  hNhNuK}rl  (hhh	X   Hello!rl  hX   Apizarl  h
hhX   POSrl  hX   BE-POSITIVErl  hNhNuK}rl  (hh+h	X   How are you?rl  hX
   Programmerrl  h
NhNhX
   ELICIT-INFORMrl  hNhNuK}rl  (hh5h	X	   I'm good,rl  hX   Apizarl  h
hhX   POSrl  hX   INFORMrl  hNhNuK}rl  (hh5h	X   how about you?rl  hX   Apizarl  h
h+hX   FOLrl  hX
   ELICIT-INFORMrl  hNhNuK}rl  (hh<h	X
   very well!rl  hX
   Programmerrl  h
h5hX   POSrl  hX   INFORMrl  hNhNuK}rl  (hhFh	X,   How do you handle keyboard input in Allegro?rl  hX
   Programmerrl  h
NhNhX   ELICIT-OFFER-OR-SUGGESTIONrl  h]rl  X   patternsrl  ahNuK}rl  (hhQh	XD   To get started, you'll probably want to use al_install_keyboard:\n\nrl  hX   Apizarl  h
hFhX   POSrl  hX   SUGGESTrl  h]rl  X   patternsrl  ah]rl  X   al_install_keyboardrl  auK}rl  (hhQh	X"   bool al_install_keyboard(void)\n\nrl  hX   Apizarl  h
hQhX   CONTrl  hX   INFORMrl  h]rl  X   basicrl  ah]rl  X   al_install_keyboardrl  auK	}rl  (hhQh	X   Install a keyboard driver. rl  hX   Apizarl  h
hXhX   CONTrl  hX   INFORMrl  h]rl  X
   functionalityrl  ah]rl  X   al_install_keyboardrl  auK
}rl  (hhQh	Xd   Returns true if successful. If a driver was already installed, nothing happens and true is returned.rl  hX   Apizarl  h
hchX   CONTrl  hX   INFORMrl  h]rl  X
   functionalityrl  ah]rl  X   al_install_keyboardrl  auK}rl  (hhXh	X   what's next?rl  hX
   Programmerrl  h
X   10rl  hX   FOLrl  hX   ELICIT-OFFER-OR-SUGGESTIONrl  h]rl  X   patternsrl  ahNuK}rl  (hhch	XA   You\'ll probably want to look at one of the following events:\n\nrl  hX   Apizarl  h
X   11rl  hX   PARTrl  hX   SUGGESTrl  h]rl  X   patternsrl  ahNuK
}rl  (hhch	X:  ALLEGRO_EVENT_KEY_DOWN\n\nA keyboard key was pressed.\n\nkeyboard.keycode (int)\nThe code corresponding to the physical key which was pressed. See the Key codes section for the list of ALLEGRO_KEY_* constants.\nkeyboard.display (ALLEGRO_DISPLAY *)\nThe display which had keyboard focus when the event occurred.\n\nrl  hX   Apizarl  h
X   12rl  hX   CONTrl  hX   INFORMrl  h]rl  (X   conceptsrl  X	   structurerl  eh]rl  X   ALLEGRO_EVENT_KEY_DOWNrl  auK}rl  (hhch	X:  ALLEGRO_EVENT_KEY_UP\n\nA keyboard key was released.\n\nkeyboard.keycode (int)\nThe code corresponding to the physical key which was released. See the Key codes section for the list of ALLEGRO_KEY_* constants.\nkeyboard.display (ALLEGRO_DISPLAY *)\nThe display which had keyboard focus when the event occurred.\n\nrl  hX   Apizarl  h
X   13rl  hX   CONTrl  hX   INFORMrl  h]rl  (X   conceptsrl  X	   structurerl  eh]rl  X   ALLEGRO_EVENT_KEY_UPrl  auK}rl  (hhch	XU  ALLEGRO_EVENT_KEY_CHAR\n\nA character was typed on the keyboard, or a character was auto-repeated.\n\nkeyboard.keycode (int)\nThe code corresponding to the physical key which was last pressed. See the Key codes section for the list of ALLEGRO_KEY_* constants.\nkeyboard.unichar (int)\nA Unicode code point (character). This may be zero or negative if the event was generated for a non-visible "character", such as an arrow or Function key. In that case you can act upon the keycode field.\n\nSome special keys will set the unichar field to their standard ASCII values: Tab=9, Return=13, Escape=27. In addition if you press the Control key together with A to Z the unichar field will have the values 1 to 26. For example Ctrl-A will set unichar to 1 and Ctrl-H will set it to 8.\n\nAs of Allegro 5.0.2 there are some inconsistencies in the treatment of Backspace (8 or 127) and Delete (127 or 0) keys on different platforms. These can be worked around by checking the keycode field.\n\nkeyboard.modifiers (unsigned)\nThis is a bitfield of the modifier keys which were pressed when the event occurred. See "Keyboard modifier flags" for the constants.\nkeyboard.repeat (bool)\nIndicates if this is a repeated character.\nkeyboard.display (ALLEGRO_DISPLAY *)\nThe display which had keyboard focus when the event occurred.\nNote: in many input methods, characters are not entered one-for-one with physical key presses. Multiple key presses can combine to generate a single character, e.g. apostrophe + e may produce \'é\'. Fewer key presses can also generate more characters, e.g. macro sequences expanding to common phrases.rl  hX   Apizarl  h
X   14rl  hX   CONTrl  hX   INFORMrl  h]r m  (X   conceptsrm  X
   directivesrm  X	   structurerm  X   environmentrm  eh]rm  X   ALLEGRO_EVENT_KEY_CHARrm  auK}rm  (hX   10rm  h	X"   how do you handle keyboard events?r	m  hX
   Programmerr
m  h
X   15rm  hX   FOLrm  hX   ELICIT-OFFER-OR-SUGGESTIONr
m  h]rm  (X   controlrm  X   patternsrm  ehNuK}rm  (hX   11rm  h	X=   You'll probably want to use al_get_keyboard_event_source:\n\nrm  hX   Apizarm  h
X   16rm  hX   POSrm  hX   SUGGESTrm  h]rm  X   patternsrm  ah]rm  X   al_get_keyboard_event_sourcerm  auK}rm  (hX   11rm  h	X<   ALLEGRO_EVENT_SOURCE *al_get_keyboard_event_source(void)\n\nrm  hX   Apizarm  h
X   17r m  hX   CONTr!m  hX   INFORMr"m  h]r#m  X   basicr$m  ah]r%m  X   al_get_keyboard_event_sourcer&m  auK}r'm  (hX   11r(m  h	X_   Retrieve the keyboard event source. All keyboard events are generated by this event source.\n\nr)m  hX   Apizar*m  h
X   18r+m  hX   CONTr,m  hX   INFORMr-m  h]r.m  (X
   functionalityr/m  X   controlr0m  eh]r1m  X   al_get_keyboard_event_sourcer2m  auK}r3m  (hX   11r4m  h	X9   Returns NULL if the keyboard subsystem was not installed.r5m  hX   Apizar6m  h
X   19r7m  hX   CONTr8m  hX   INFORMr9m  h]r:m  X
   functionalityr;m  ah]r<m  X   al_get_keyboard_event_sourcer=m  auK}r>m  (hX   12r?m  h	X"   how do you check key pressed stater@m  hX
   ProgrammerrAm  h
X   20rBm  hX   FOLrCm  hX   ELICIT-OFFER-OR-SUGGESTIONrDm  h]rEm  X   patternsrFm  ahNuK}rGm  (hX   13rHm  h	X(   You can check that with al_key_down:\n\nrIm  hX   ApizarJm  h
X   21rKm  hX   POSrLm  hX   SUGGESTrMm  h]rNm  X   patternsrOm  ah]rPm  X   al_key_downrQm  auK}rRm  (hX   13rSm  h	XF   bool al_key_down(const ALLEGRO_KEYBOARD_STATE *state, int keycode)\n\nrTm  hX   ApizarUm  h
X   22rVm  hX   CONTrWm  hX   INFORMrXm  h]rYm  X   basicrZm  ah]r[m  X   al_key_downr\m  auK}r]m  (hX   13r^m  h	XF   Return true if the key specified was held down in the state specified.r_m  hX   Apizar`m  h
X   23ram  hX   CONTrbm  hX   INFORMrcm  h]rdm  X
   functionalityrem  ah]rfm  X   al_key_downrgm  auK}rhm  (hX   14rim  h	X'   how do you use ALLEGRO_KEYBOARD_STATE ?rjm  hX
   Programmerrkm  h
X   24rlm  hX   FOLrmm  hX   ELICIT-OFFER-OR-SUGGESTIONrnm  h]rom  X   patternsrpm  ah]rqm  (X   al_key_downrrm  X   ALLEGRO_KEYBOARD_STATErsm  euK}rtm  (hX   15rum  h	X#   What would you like to do with it? rvm  hX   Apizarwm  h
X   25rxm  hX   FOLrym  hX
   ELICIT-INFORMrzm  h]r{m  X   patternsr|m  ah]r}m  X   ALLEGRO_KEYBOARD_STATEr~m  auK}rm  (hX   15rm  h	X#   Here\'s some basic information:\n\nrm  hX   Apizarm  h
X   25rm  hX   PARTrm  hX   INFORMrm  hNh]rm  X   ALLEGRO_KEYBOARD_STATErm  auK}rm  (hX   15rm  h	X[   ALLEGRO_KEYBOARD_STATE\n\ntypedef struct ALLEGRO_KEYBOARD_STATE ALLEGRO_KEYBOARD_STATE;\n\nrm  hX   Apizarm  h
X   27rm  hX   CONTrm  hX   INFORMrm  h]rm  X   basicrm  ah]rm  X   ALLEGRO_KEYBOARD_STATErm  auK}rm  (hX   15rm  h	Xf   This is a structure that is used to hold a "snapshot" of a keyboard\'s state at a particular instant. rm  hX   Apizarm  h
X   28rm  hX   CONTrm  hX   INFORMrm  h]rm  X   purposerm  ah]rm  X   ALLEGRO_KEYBOARD_STATErm  auK}rm  (hX   15rm  h	X   It contains the following publically readable fields:\n\ndisplay - points to the display that had keyboard focus at the time the state was saved. If no display was focused, this points to NULL.\nrm  hX   Apizarm  h
X   29rm  hX   CONTrm  hX   INFORMrm  h]rm  (X	   structurerm  X   conceptsrm  X
   functionalityrm  eh]rm  X   ALLEGRO_KEYBOARD_STATErm  auK}rm  (hX   15rm  h	XI   You cannot read the state of keys directly. Use the function al_key_down.rm  hX   Apizarm  h
X   30rm  hX   CONTrm  hX   INFORMrm  h]rm  (X
   directivesrm  X   patternsrm  eh]rm  X   ALLEGRO_KEYBOARD_STATErm  auK }rm  (hX   16rm  h	XH   how do you retrieve the current ALLEGRO_KEYBOARD_STATE for the keyboard?rm  hX
   Programmerrm  h
X   26rm  hX   POSrm  hX   ELICIT-OFFER-OR-SUGGESTIONrm  h]rm  X   patternsrm  ah]rm  X   ALLEGRO_KEYBOARD_STATErm  auK!}rm  (hX   17rm  h	XC   You can retrieve the keyboard state with al_get_keyboard_state:\n\nrm  hX   Apizarm  h
X   32rm  hX   POSrm  hX   SUGGESTrm  h]rm  X   patternsrm  ah]rm  (X   ALLEGRO_KEYBOARD_STATErm  X   al_get_keyboard_staterm  euK"}rm  (hX   17rm  h	XA   void al_get_keyboard_state(ALLEGRO_KEYBOARD_STATE *ret_state)\n\nrm  hX   Apizarm  h
X   33rm  hX   CONTrm  hX   INFORMrm  h]rm  X   basicrm  ah]rm  X   al_get_keyboard_staterm  auK#}rm  (hX   17rm  h	Xw   Save the state of the keyboard specified at the time the function is called into the structure pointed to by ret_state.rm  hX   Apizarm  h
X   34rm  hX   CONTrm  hX   INFORMrm  h]rm  X
   functionalityrm  ah]rm  X   al_get_keyboard_staterm  auK$}rm  (hX   18rm  h	X   great,rm  hX
   Programmerrm  h
X   35rm  hX   POSrm  hX   ASSESSrm  hNh]rm  X   al_get_keyboard_staterm  auK%}rm  (hX   18rm  h	X	    it worksrm  hX
   Programmerrm  h
X   36rm  hX   CONTrm  hX   INFORMrm  hNhNuK&}rm  (hX   19rm  h	X   Great!rm  hX   Apizarm  h
X   36rm  hX   POSrm  hX   BE-POSITIVErm  hNhNuK'}rm  (hX   20rm  h	X!   how do you play sounds in Allegrorm  hX
   Programmerrm  h
NhNhX   ELICIT-OFFER-OR-SUGGESTIONrm  h]r n  X   patternsrn  ahNuK(}rn  (hX   21rn  h	X8   You'll probably want to start with al_install_audio:\n\nrn  hX   Apizarn  h
X   39rn  hX   POSrn  hX   SUGGESTrn  h]r	n  X   patternsr
n  ah]rn  X   al_install_audiorn  auK)}r
n  (hX   21rn  h	X   bool al_install_audio(void)\n\nrn  hX   Apizarn  h
X   40rn  hX   CONTrn  hX   INFORMrn  h]rn  X   basicrn  ah]rn  X   al_install_audiorn  auK*}rn  (hX   21rn  h	X    Install the audio subsystem.\n\nrn  hX   Apizarn  h
X   41rn  hX   CONTrn  hX   INFORMrn  h]rn  X
   functionalityr n  ah]r!n  X   al_install_audior"n  auK+}r#n  (hX   21r$n  h	X.   Returns true on success, false on failure.\n\nr%n  hX   Apizar&n  h
X   42r'n  hX   CONTr(n  hX   INFORMr)n  h]r*n  X
   functionalityr+n  ah]r,n  X   al_install_audior-n  auK,}r.n  (hX   21r/n  h	XR   Note: most users will call al_reserve_samples and al_init_acodec_addon after this.r0n  hX   Apizar1n  h
X   43r2n  hX   CONTr3n  hX   INFORMr4n  h]r5n  X   patternsr6n  ah]r7n  X   al_install_audior8n  auK-}r9n  (hX   22r:n  h	X   describe al_reserve_samplesr;n  hX
   Programmerr<n  h
X   44r=n  hX   FOLr>n  hX
   ELICIT-INFORMr?n  h]r@n  X   basicrAn  ah]rBn  X   al_reserve_samplesrCn  auK.}rDn  (hX   23rEn  h	X2   Here's some information on al_reserve_samples:\n\nrFn  hX   ApizarGn  h
X   45rHn  hX   POSrIn  hX   INFORMrJn  hNh]rKn  X   al_reserve_samplesrLn  auK/}rMn  (hX   23rNn  h	X0   bool al_reserve_samples(int reserve_samples)\n\nrOn  hX   ApizarPn  h
X   46rQn  hX   CONTrRn  hX   INFORMrSn  h]rTn  X   basicrUn  ah]rVn  X   al_reserve_samplesrWn  auK0}rXn  (hX   23rYn  h	X  Reserves a number of sample instances, attaching them to the default mixer. If no default mixer is set when this function is called, then it will create one and attach it to the default voice. If no default voice has been set, it, too, will be created.\n\nIf you call this function a second time with a smaller number of samples, then the excess internal sample instances will be destroyed causing some sounds to stop and some instances returned by al_lock_sample_id to be invalidated.\n\nThis diagram illustrates the structures that are set up:\n\n sample instance 1\n / sample instance 2\ndefault voice &lt;-- default mixer &lt;--- .\n \\ .\n sample instance N\nrZn  hX   Apizar[n  h
X   47r\n  hX   CONTr]n  hX   INFORMr^n  h]r_n  (X
   functionalityr`n  X   patternsran  eh]rbn  X   al_reserve_samplesrcn  auK1}rdn  (hX   23ren  h	X)   Returns true on success, false on error. rfn  hX   Apizargn  h
X   48rhn  hX   CONTrin  hX   INFORMrjn  h]rkn  X
   functionalityrln  ah]rmn  X   al_reserve_samplesrnn  auK2}ron  (hX   23rpn  h	X-   al_install_audio must have been called first.rqn  hX   Apizarrn  h
X   49rsn  hX   CONTrtn  hX   INFORMrun  h]rvn  X
   directivesrwn  ah]rxn  X   al_reserve_samplesryn  auK3}rzn  (hX   24r{n  h	X-   how do you play a single wav file in Allegro?r|n  hX
   Programmerr}n  h
X   50r~n  hX   FOLrn  hX   ELICIT-OFFER-OR-SUGGESTIONrn  h]rn  X   patternsrn  ahNuK4}rn  (hX   25rn  h	XJ   You'll probably want to use al_load_sample followed by al_play_sample:\n\nrn  hX   Apizarn  h
X   51rn  hX   POSrn  hX   SUGGESTrn  h]rn  X   patternsrn  ah]rn  (X   al_load_samplern  X   al_play_samplern  euK5}rn  (hX   25rn  h	X8   ALLEGRO_SAMPLE *al_load_sample(const char *filename)\n\nrn  hX   Apizarn  h
X   52rn  hX   CONTrn  hX   INFORMrn  h]rn  X   basicrn  ah]rn  X   al_load_samplern  auK6}rn  (hX   25rn  h	X   Loads a few different audio file formats based on their extension.\n\nNote that this stores the entire file in memory at once, which may be time consuming. To read the file as it is needed, use al_load_audio_stream.\n\nrn  hX   Apizarn  h
X   53rn  hX   CONTrn  hX   INFORMrn  h]rn  (X
   functionalityrn  X   qualityrn  X   patternsrn  eh]rn  X   al_load_samplern  auK7}rn  (hX   25rn  h	X3   Returns the sample on success, NULL on failure.\n\nrn  hX   Apizarn  h
X   54rn  hX   CONTrn  hX   INFORMrn  h]rn  X
   functionalityrn  ah]rn  X   al_load_samplern  auK8}rn  (hX   25rn  h	X   Note: the allegro_audio library does not support any audio file formats by default. You must use the allegro_acodec addon, or register your own format handler.\n\nrn  hX   Apizarn  h
X   55rn  hX   CONTrn  hX   INFORMrn  h]rn  (X   qualityrn  X   patternsrn  eh]rn  X   al_load_samplern  auK9}rn  (hX   25rn  h	X   bool al_play_sample(ALLEGRO_SAMPLE *spl, float gain, float pan, float speed,\n ALLEGRO_PLAYMODE loop, ALLEGRO_SAMPLE_ID *ret_id)\n\nrn  hX   Apizarn  h
X   56rn  hX   CONTrn  hX   INFORMrn  h]rn  X   basicrn  ah]rn  X   al_play_samplern  auK:}rn  (hX   25rn  h	XL   Plays a sample on one of the sample instances created by al_reserve_samples.rn  hX   Apizarn  h
X   57rn  hX   CONTrn  hX   INFORMrn  h]rn  (X
   functionalityrn  X   patternsrn  eh]rn  X   al_play_samplern  auK;}rn  (hX   25rn  h	X,    Returns true on success, false on failure. rn  hX   Apizarn  h
X   58rn  hX   CONTrn  hX   INFORMrn  h]rn  X
   functionalityrn  ah]rn  X   al_play_samplern  auK<}rn  (hX   25rn  h	XS   Playback may fail because all the reserved sample instances are currently used.\n\nrn  hX   Apizarn  h
X   59rn  hX   CONTrn  hX   INFORMrn  h]rn  (X
   functionalityrn  X
   directivesrn  X   qualityrn  X   patternsrn  X   basicrn  eh]rn  X   al_play_samplern  auK=}rn  (hX   25rn  h	X*  Parameters:\n\ngain - relative volume at which the sample is played; 1.0 is normal.\npan - 0.0 is centred, -1.0 is left, 1.0 is right, or ALLEGRO_AUDIO_PAN_NONE.\nspeed - relative speed at which the sample is played; 1.0 is normal.\nloop - ALLEGRO_PLAYMODE_ONCE, ALLEGRO_PLAYMODE_LOOP, or ALLEGRO_PLAYMODE_BIDIR\nret_id - if non-NULL the variable which this points to will be assigned an id representing the sample being played. If al_play_sample returns false, then the contents of ret_id are invalid and must not be used as argument to other functions.rn  hX   Apizarn  h
X   60rn  hX   CONTrn  hX   INFORMrn  h]rn  (X
   functionalityrn  X
   directivesrn  eh]rn  X   al_play_samplern  auK>}rn  (hX   26rn  h	X;   how do you get the error message when al_load_sample fails?rn  hX
   Programmerrn  h
X   53rn  hX   FOLr o  hX   ELICIT-OFFER-OR-SUGGESTIONro  h]ro  X   patternsro  ah]ro  X   al_load_samplero  auK?}ro  (hX   27ro  h	X9   how do you use allegro_acodec to handle .wav audio files?ro  hX
   Programmerr	o  h
X   56r
o  hX   FOLro  hX   ELICIT-OFFER-OR-SUGGESTIONro  h]r
o  X   patternsro  ahNuK@}ro  (hX   28ro  h	X)   Have you called al_init_acodec_addon?\n\nro  hX   Apizaro  h
X   63ro  hX   FOLro  hX
   ELICIT-INFORMro  h]ro  X   patternsro  ah]ro  X   al_init_acodec_addonro  auKA}ro  (hX   28ro  h	X#   bool al_init_acodec_addon(void)\n\nro  hX   Apizaro  h
X   64ro  hX   FOLro  hX   INFORMr o  h]r!o  X   basicr"o  ah]r#o  X   al_init_acodec_addonr$o  auKB}r%o  (hX   28r&o  h	X  This function registers all the known audio file type handlers for al_load_sample, al_save_sample, al_load_audio_stream, etc.\n\nDepending on what libraries are available, the full set of recognised extensions is: .wav, .flac, .ogg, .opus, .it, .mod, .s3m, .xm, .voc.\n\nr'o  hX   Apizar(o  h
X   65r)o  hX   CONTr*o  hX   INFORMr+o  h]r,o  (X
   functionalityr-o  X   purposer.o  eh]r/o  X   al_init_acodec_addonr0o  auKC}r1o  (hX   28r2o  h	X1  Limitations:\n\nSaving is only supported for wav files.\n\nThe wav file loader currently only supports 8/16 bit little endian PCM files. 16 bits are used when saving wav files. Use flac files if more precision is required.\n\nModule files (.it, .mod, .s3m, .xm) are often composed with streaming in mind, and sometimes cannot be easily rendered into a finite length sample. Therefore they cannot be loaded with al_load_sample/al_load_sample_f and must be streamed with al_load_audio_stream or al_load_audio_stream_f.\n\n.voc file streaming is unimplemented.\n\nr3o  hX   Apizar4o  h
X   66r5o  hX   CONTr6o  hX   INFORMr7o  h]r8o  (X
   directivesr9o  X   patternsr:o  X   qualityr;o  eh]r<o  X   al_init_acodec_addonr=o  auKD}r>o  (hX   28r?o  h	X   Return true on success.r@o  hX   ApizarAo  h
X   67rBo  hX   CONTrCo  hX   INFORMrDo  h]rEo  X
   functionalityrFo  ah]rGo  X   al_init_acodec_addonrHo  auKE}rIo  (hX   29rJo  h	X   ok, rKo  hX
   ProgrammerrLo  h
X   68rMo  hX   POSrNo  hX   ASSESSrOo  hNhNuKF}rPo  (hX   29rQo  h	X   it worksrRo  hX
   ProgrammerrSo  h
X   69rTo  hX   CONTrUo  hX   INFORMrVo  hNhNuKG}rWo  (hX   30rXo  h	X   Great!rYo  hX   ApizarZo  h
X   70r[o  hX   CONTr\o  hX   BE-POSITIVEr]o  hNhNuKH}r^o  (hX   31r_o  h	X"   how do you draw text with Allegro?r`o  hX
   Programmerrao  h
NhNhX   ELICIT-OFFER-OR-SUGGESTIONrbo  h]rco  X   patternsrdo  ahNuKI}reo  (hX   32rfo  h	X:   You'll probably want to start with al_init_font_addon:\n\nrgo  hX   Apizarho  h
X   72rio  hX   POSrjo  hX   SUGGESTrko  h]rlo  X   patternsrmo  ah]rno  X   al_init_font_addonroo  auKJ}rpo  (hX   32rqo  h	X!   bool al_init_font_addon(void)\n\nrro  hX   Apizarso  h
X   73rto  hX   CONTruo  hX   INFORMrvo  h]rwo  X   basicrxo  ah]ryo  X   al_init_font_addonrzo  auKK}r{o  (hX   32r|o  h	X   Initialise the font addon.\n\nr}o  hX   Apizar~o  h
X   74ro  hX   CONTro  hX   INFORMro  h]ro  X
   functionalityro  ah]ro  X   al_init_font_addonro  auKL}ro  (hX   32ro  h	X   Note that if you intend to load bitmap fonts, you will need to initialise allegro_image separately (unless you are using another library to load images).\n\nSimilarly, if you wish to load truetype-fonts, do not forget to also call al_init_ttf_addon.\n\nro  hX   Apizaro  h
X   75ro  hX   CONTro  hX   INFORMro  h]ro  X
   directivesro  ah]ro  X   al_init_font_addonro  auKM}ro  (hX   32ro  h	X   Returns true on success, false on failure. On the 5.0 branch, this function has no return value. You may wish to avoid checking the return value if your code needs to be compatible with Allegro 5.0. Currently, the function will never return false.ro  hX   Apizaro  h
X   76ro  hX   CONTro  hX   INFORMro  h]ro  (X
   functionalityro  X   environmentro  X   patternsro  eh]ro  X   al_init_font_addonro  auKN}ro  (hX   33ro  h	X   what's next?ro  hX
   Programmerro  h
X   77ro  hX   FOLro  hX   ELICIT-OFFER-OR-SUGGESTIONro  h]ro  X   patternsro  ahNuKO}ro  (hX   34ro  h	X<   You'll probably want to use al_load_font to load a font:\n\nro  hX   Apizaro  h
X   78ro  hX   POSro  hX   SUGGESTro  h]ro  X   patternsro  ah]ro  X   al_load_fontro  auKP}ro  (hX   34ro  h	XI   ALLEGRO_FONT *al_load_font(char const *filename, int size, int flags)\n\nro  hX   Apizaro  h
X   79ro  hX   CONTro  hX   INFORMro  h]ro  X   basicro  ah]ro  X   al_load_fontro  auKQ}ro  (hX   34ro  h	X2  Loads a font from disk. This will use al_load_bitmap_font_flags if you pass the name of a known bitmap format, or else al_load_ttf_font.\n\nThe flags parameter is passed through to either of those functions. Bitmap and TTF fonts are also affected by the current bitmap flags at the time the font is loaded.ro  hX   Apizaro  h
X   80ro  hX   CONTro  hX   INFORMro  h]ro  (X
   functionalityro  X   controlro  eh]ro  X   al_load_fontro  auKR}ro  (hX   35ro  h	X    how do you use al_load_ttf_font?ro  hX
   Programmerro  h
X   81ro  hX   FOLro  hX   ELICIT-OFFER-OR-SUGGESTIONro  h]ro  X   patternsro  ah]ro  X   al_load_ttf_fontro  auKS}ro  (hX   36ro  h	X0   Here's some information on al_load_ttf_font:\n\nro  hX   Apizaro  h
X   82ro  hX   POSro  hX   INFORMro  hNh]ro  X   al_load_ttf_fontro  auKT}ro  (hX   36ro  h	XM   ALLEGRO_FONT *al_load_ttf_font(char const *filename, int size, int flags)\n\nro  hX   Apizaro  h
X   83ro  hX   CONTro  hX   INFORMro  h]ro  X   basicro  ah]ro  X   al_load_ttf_fontro  auKU}ro  (hX   36ro  h	X  Loads a TrueType font from a file using the FreeType library. Quoting from the FreeType FAQ this means support for many different font formats:\n\nTrueType, OpenType, Type1, CID, CFF, Windows FON/FNT, X11 PCF, and others\n\nThe size parameter determines the size the font will be rendered at, specified in pixels. The standard font size is measured in units per EM, if you instead want to specify the size as the total height of glyphs in pixels, pass it as a negative value.\n\nro  hX   Apizaro  h
X   84ro  hX   CONTro  hX   INFORMro  h]ro  (X
   functionalityro  X
   referencesro  X   patternsro  eh]ro  X   al_load_ttf_fontro  auKV}ro  (hX   36ro  h	Xu   Note: If you want to display text at multiple sizes, load the font multiple times with different size parameters.\n\nro  hX   Apizaro  h
X   85ro  hX   CONTro  hX   INFORMro  h]ro  X   patternsro  ah]ro  X   al_load_ttf_fontro  auKW}r p  (hX   36rp  h	Xf  The following flags are supported:\n\nALLEGRO_TTF_NO_KERNING - Do not use any kerning even if the font file supports it.\n\nALLEGRO_TTF_MONOCHROME - Load as a monochrome font (which means no anti-aliasing of the font is done).\n\nALLEGRO_TTF_NO_AUTOHINT - Disable the Auto Hinter which is enabled by default in newer versions of FreeType. Since: 5.0.6, 5.1.2rp  hX   Apizarp  h
X   86rp  hX   CONTrp  hX   INFORMrp  h]rp  (X
   directivesrp  X   patternsr	p  X   environmentr
p  eh]rp  X   al_load_ttf_fontrp  auKX}r
p  (hX   37rp  h	X6   what's next, to draw text once I have loaded the font?rp  hX
   Programmerrp  h
X   81rp  hX   FOLrp  hX   ELICIT-OFFER-OR-SUGGESTIONrp  h]rp  X   patternsrp  ahNuKY}rp  (hX   38rp  h	X:   To draw text you'll probably want to use al_draw_text:\n\nrp  hX   Apizarp  h
X   88rp  hX   POSrp  hX   SUGGESTrp  h]rp  X   patternsrp  ah]rp  X   al_draw_textr p  auKZ}r!p  (hX   38r"p  h	Xw   void al_draw_text(const ALLEGRO_FONT *font,\n ALLEGRO_COLOR color, float x, float y, int flags,\n char const *text)\n\nr#p  hX   Apizar$p  h
X   89r%p  hX   CONTr&p  hX   INFORMr'p  h]r(p  X   basicr)p  ah]r*p  X   al_draw_textr+p  auK[}r,p  (hX   38r-p  h	Xl   Writes the NUL-terminated string text onto the target bitmap at position x, y, using the specified font.\n\nr.p  hX   Apizar/p  h
X   90r0p  hX   CONTr1p  hX   INFORMr2p  h]r3p  X
   functionalityr4p  ah]r5p  X   al_draw_textr6p  auK\}r7p  (hX   38r8p  h	X  The flags parameter can be 0 or one of the following flags:\n\nALLEGRO_ALIGN_LEFT - Draw the text left-aligned (same as 0).\nALLEGRO_ALIGN_CENTRE - Draw the text centered around the given position.\nALLEGRO_ALIGN_RIGHT - Draw the text right-aligned to the given position.\nIt can also be combined with this flag:\n\nALLEGRO_ALIGN_INTEGER - Always draw text aligned to an integer pixel position. This was formerly the default behaviour. Since: 5.0.8, 5.1.4\nr9p  hX   Apizar:p  h
X   91r;p  hX   CONTr<p  hX   INFORMr=p  h]r>p  (X
   directivesr?p  X   patternsr@p  X   environmentrAp  eh]rBp  X   al_draw_textrCp  auK]}rDp  (hX   38rEp  h	X{   This function does not support newline characters (\\n), but you can use al_draw_multiline_text for multi line text output.rFp  hX   ApizarGp  h
X   92rHp  hX   CONTrIp  hX   INFORMrJp  h]rKp  (X
   directivesrLp  X   patternsrMp  eh]rNp  X   al_draw_textrOp  auK^}rPp  (hX   39rQp  h	X   how do you use ALLEGRO_COLOR?rRp  hX
   ProgrammerrSp  h
X   90rTp  hX   FOLrUp  hX   ELICIT-OFFER-OR-SUGGESTIONrVp  h]rWp  X   patternsrXp  ah]rYp  (X
   ALLEGRO_COLORrZp  X   al_draw_textr[p  euK_}r\p  (hX   40r]p  h	X;   al_map_rgb should allow you to create an ALLEGRO_COLOR:\n\nr^p  hX   Apizar_p  h
X   94r`p  hX   PARTrap  hX   SUGGESTrbp  h]rcp  X   patternsrdp  ah]rep  (X
   ALLEGRO_COLORrfp  X
   al_map_rgbrgp  euK`}rhp  (hX   40rip  h	XR   ALLEGRO_COLOR al_map_rgb(\n unsigned char r, unsigned char g, unsigned char b)\n\nrjp  hX   Apizarkp  h
X   95rlp  hX   CONTrmp  hX   INFORMrnp  h]rop  X   basicrpp  ah]rqp  X
   al_map_rgbrrp  auKa}rsp  (hX   40rtp  h	XP   Convert r, g, b (ranging from 0-255) into an ALLEGRO_COLOR, using 255 for alpha.rup  hX   Apizarvp  h
X   96rwp  hX   CONTrxp  hX   INFORMryp  h]rzp  X
   functionalityr{p  ah]r|p  X
   al_map_rgbr}p  auKb}r~p  (hX   41rp  h	XC   why would al_draw_text() produce the warning "VERR_BUFFER_OVERFLOW"rp  hX
   Programmerrp  h
X   90rp  hX   FOLrp  hX
   ELICIT-INFORMrp  h]rp  X
   functionalityrp  ah]rp  X   al_draw_textrp  auKc}rp  (hX   42rp  h	XF   It seems like that's most likely a problem with your virtual machine. rp  hX   Apizarp  h
X   98rp  hX   POSrp  hX   INFORMrp  h]rp  X   environmentrp  ah]rp  X   al_draw_textrp  auKd}rp  (hX   42rp  h	X    What size display are you using?rp  hX   Apizarp  h
X   98rp  hX   FOLrp  hX
   ELICIT-INFORMrp  h]rp  X   environmentrp  ah]rp  X   al_draw_textrp  auKe}rp  (hX   43rp  h	X   ok,rp  hX
   Programmerrp  h
X   101rp  hX   NEGrp  hX   ASSESSrp  hNhNuKf}rp  (hX   43rp  h	X	   nevermindrp  hX
   Programmerrp  h
X   102rp  hX   CONTrp  hX   SUGGESTrp  hNhNuKg}rp  (hX   44rp  h	X.   What to do if al_draw_text produces no result?rp  hX
   Programmerrp  h
X   90rp  hX   FOLrp  hX   ELICIT-OFFER-OR-SUGGESTIONrp  h]rp  (X
   functionalityrp  X   patternsrp  eh]rp  X   al_draw_textrp  auKh}rp  (hX   45rp  h	X	   nevermindrp  hX
   Programmerrp  h
X   103rp  hX   NEGrp  hX   SUGGESTrp  hNhNuKi}rp  (hX   46rp  h	X   ok,rp  hX
   Programmerrp  h
X   90rp  hX   POSrp  hX   ASSESSrp  hNhNuKj}rp  (hX   46rp  h	X   it worksrp  hX
   Programmerrp  h
X   105rp  hX   CONTrp  hX   INFORMrp  hNh]rp  X   al_draw_textrp  auKk}rp  (hX   47rp  h	X   Great!rp  hX   Apizarp  h
X   106rp  hX   POSrp  hX   BE-POSITIVErp  hNhNuKl}rp  (hX   48rp  h	X$   how do you load a .png into a bitmaprp  hX
   Programmerrp  h
NhNhX   ELICIT-OFFER-OR-SUGGESTIONrp  h]rp  X   patternsrp  ahNuuuK}rp  (hhh}rp  (K }rp  (hhh	X)   What function is used to create a sessionrp  hX
   Programmerrp  h
NhNhX
   ELICIT-INFORMrp  h]rp  X   patternsrp  ah]rp  X   ssh_sessionrp  auK}rp  (hhh	X   Are you asking about ssh_new?rp  hX   Apizarp  h
hhX   POSrp  hX
   ELICIT-INFORMrp  h]rp  X   patternsrp  ah]rp  X   ssh_newrp  auK}rp  (hh+h	X   Yes, rp  hX
   Programmerrp  h
hhX   POSrp  hX   INFORMrp  h]rp  X   basicrp  ah]rp  X   ssh_newrp  auK}rp  (hh+h	X   what arguments does it take?rp  hX
   Programmerrp  h
hhX   FOLrp  hX
   ELICIT-INFORMrp  h]rp  X   basicr q  ah]rq  X   ssh_newrq  auK}rq  (hh5h	X   It does not take any arguments.rq  hX   Apizarq  h
h5hX   POSrq  hX   INFORMrq  h]rq  X   basicr	q  ah]r
q  X   ssh_newrq  auK}rq  (hh<h	X*   does it have a return value or error code?r
q  hX
   Programmerrq  h
hhX   FOLrq  hX
   ELICIT-INFORMrq  h]rq  X   basicrq  ah]rq  X   ssh_newrq  auK}rq  (hhFh	X-   Would you like to see the function signature?rq  hX   Apizarq  h
h<hX   FOLrq  hX   OFFERrq  h]rq  X   basicrq  ah]rq  X   ssh_newrq  auK}rq  (hhQh	X   yesrq  hX
   Programmerr q  h
hQhX   POSr!q  hX   ASSESSr"q  h]r#q  X   basicr$q  ah]r%q  X   ssh_newr&q  auK}r'q  (hhXh	X   ssh_session ssh_new(void )r(q  hX   Apizar)q  h
h<hX   POSr*q  hX   INFORMr+q  h]r,q  X   basicr-q  ah]r.q  X   ssh_newr/q  auK	}r0q  (hhch	X    what is the type of ssh_session?r1q  hX
   Programmerr2q  h
hXhX   FOLr3q  hX
   ELICIT-INFORMr4q  h]r5q  X   basicr6q  ah]r7q  X   ssh_sessionr8q  auK
}r9q  (hX   10r:q  h	X   It is a structr;q  hX   Apizar<q  h
hchX   POSr=q  hX   INFORMr>q  h]r?q  X   basicr@q  ah]rAq  X   ssh_sessionrBq  auK}rCq  (hX   11rDq  h	X%   what is the declaration of the structrEq  hX
   ProgrammerrFq  h
X   10rGq  hX   FOLrHq  hX
   ELICIT-INFORMrIq  h]rJq  X   basicrKq  ah]rLq  X   ssh_sessionrMq  auK}rNq  (hX   12rOq  h	X   what are the data members?rPq  hX
   ProgrammerrQq  h
X   10rRq  hX   FOLrSq  hX
   ELICIT-INFORMrTq  h]rUq  X	   structurerVq  ah]rWq  X   ssh_sessionrXq  auK
}rYq  (hX   13rZq  h	X'   ssh_session contains many data members.r[q  hX   Apizar\q  h
X   12r]q  hX   PARTr^q  hX   INFORMr_q  h]r`q  X	   structureraq  ah]rbq  X   ssh_sessionrcq  auK}rdq  (hX   13req  h	X<   Can you give more information on what you are interested in?rfq  hX   Apizargq  h
X   12rhq  hX   FOLriq  hX
   ELICIT-INFORMrjq  h]rkq  X	   structurerlq  ah]rmq  X   ssh_sessionrnq  auK}roq  (hX   14rpq  h	X&   Or would you like me to list them all?rqq  hX   Apizarrq  h
X   12rsq  hX   FOLrtq  hX   OFFERruq  h]rvq  X	   structurerwq  ah]rxq  X   ssh_sessionryq  auK}rzq  (hX   15r{q  h	X:   how do I check if an ssh session was successfully created?r|q  hX
   Programmerr}q  h
NhNhX   ELICIT-OFFER-OR-SUGGESTIONr~q  h]rq  X
   functionalityrq  ah]rq  X   ssh_sessionrq  auK}rq  (hX   16rq  h	X+   The function ssh_new returns null on error.rq  hX   Apizarq  h
X   16rq  hX   POSrq  hX   INFORMrq  h]rq  X
   functionalityrq  ah]rq  (X   ssh_newrq  X   ssh_sessionrq  euK}rq  (hX   17rq  h	X"   what is the returned ptr a ptr to?rq  hX
   Programmerrq  h
X   17rq  hX   FOLrq  hX
   ELICIT-INFORMrq  h]rq  X
   functionalityrq  ah]rq  X   ssh_newrq  auK}rq  (hX   18rq  h	X9   ssh_new returns a new ssh_session pointer, NULL on error.rq  hX   Apizarq  h
X   18rq  hX   POSrq  hX   INFORMrq  h]rq  X
   functionalityrq  ah]rq  X   ssh_newrq  auK}rq  (hX   19rq  h	X   ssh_new is returning null,rq  hX
   Programmerrq  h
NhNhX   INFORMrq  h]rq  (X
   functionalityrq  X   patternsrq  eh]rq  X   ssh_newrq  auK}rq  (hX   19rq  h	X   how should i debugrq  hX
   Programmerrq  h
X   20rq  hX   FOLrq  hX   ELICIT-OFFER-OR-SUGGESTIONrq  h]rq  (X
   functionalityrq  X   patternsrq  eh]rq  X   ssh_newrq  auK}rq  (hX   20rq  h	X   I am unsure.rq  hX   Apizarq  h
X   21rq  hX   UNCrq  hX   INFORMrq  hNh]rq  X   ssh_newrq  auK}rq  (hX   21rq  h	X,   what are preconditions for calling ssh_new()rq  hX
   Programmerrq  h
NhNhX
   ELICIT-INFORMrq  h]rq  X
   directivesrq  ah]rq  X   ssh_newrq  auK}rq  (hX   22rq  h	X   There are none.rq  hX   Apizarq  h
X   23rq  hX   POSrq  hX   INFORMrq  h]rq  X
   directivesrq  ah]rq  X   ssh_newrq  auK}rq  (hX   23rq  h	X!   what could cause ssh_new to fail?rq  hX
   Programmerrq  h
NhNhX
   ELICIT-INFORMrq  h]rq  X
   functionalityrq  ah]rq  X   ssh_newrq  auK}rq  (hX   24rq  h	X   I am unsure.rq  hX   Apizarq  h
X   25rq  hX   UNCrq  hX   INFORMrq  hNh]rq  X   ssh_newrq  auK}rq  (hX   25rq  h	X:   how does one connect to a server using the libssh library?rq  hX
   Programmerrq  h
NhNhX
   ELICIT-INFORMrq  h]rq  X   patternsrq  ahNuK}rq  (hX   26rq  h	X!   Are you asking about ssh_connect?rq  hX   Apizarq  h
X   27rq  hX   POSrq  hX
   ELICIT-INFORMrq  h]rq  X   patternsrq  ah]rq  X   ssh_connectrq  auK}rq  (hX   27rq  h	X   yes,rq  hX
   Programmerrq  h
X   28r r  hX   POSrr  hX   INFORMrr  h]rr  X   basicrr  ah]rr  X   ssh_connectrr  auK}rr  (hX   27rr  h	X.   what is the function signature of ssh_connect?r	r  hX
   Programmerr
r  h
X   28rr  hX   FOLrr  hX
   ELICIT-INFORMr
r  h]rr  X   basicrr  ah]rr  X   ssh_connectrr  auK}rr  (hX   28rr  h	X$   int ssh_connect(ssh_session session)rr  hX   Apizarr  h
X   30rr  hX   POSrr  hX   INFORMrr  h]rr  X   basicrr  ah]rr  X   ssh_connectrr  auK }rr  (hX   29rr  h	X8   what is the meaning of the return value from ssh_connectrr  hX
   Programmerr r  h
X   31r!r  hX   FOLr"r  hX
   ELICIT-INFORMr#r  h]r$r  X
   functionalityr%r  ah]r&r  X   ssh_connectr'r  auK!}r(r  (hX   30r)r  h	X   The return value is SSH_OK on success, SSH_ERROR on error. SSH_AGAIN, if the session is in nonblocking mode, and call must be done again.r*r  hX   Apizar+r  h
X   32r,r  hX   POSr-r  hX   INFORMr.r  h]r/r  X
   functionalityr0r  ah]r1r  X   ssh_connectr2r  auK"}r3r  (hX   31r4r  h	X/   What is the integer value of these error codes?r5r  hX
   Programmerr6r  h
X   33r7r  hX   FOLr8r  hX
   ELICIT-INFORMr9r  h]r:r  X   basicr;r  ah]r<r  X   ssh_connectr=r  auK#}r>r  (hX   32r?r  h	X-   SSH_OK is 0, SSH_ERROR is -1, SSH_AGAIN is -2r@r  hX   ApizarAr  h
X   34rBr  hX   POSrCr  hX   INFORMrDr  h]rEr  X   basicrFr  ah]rGr  X   ssh_connectrHr  auK$}rIr  (hX   33rJr  h	X   what could cause SSH_ERROR ?rKr  hX
   ProgrammerrLr  h
X   33rMr  hX   FOLrNr  hX
   ELICIT-INFORMrOr  h]rPr  X
   functionalityrQr  ah]rRr  X   ssh_connectrSr  auK%}rTr  (hX   34rUr  h	Xd   You can get the English error string with ssh_get_error() in order to show the user what went wrong.rVr  hX   ApizarWr  h
X   36rXr  hX   PARTrYr  hX   SUGGESTrZr  h]r[r  X   patternsr\r  ah]r]r  X
   ssh_get_errorr^r  auK&}r_r  (hX   35r`r  h	X   what does ssh_get_error return?rar  hX
   Programmerrbr  h
X   37rcr  hX   FOLrdr  hX
   ELICIT-INFORMrer  h]rfr  X
   functionalityrgr  ah]rhr  X
   ssh_get_errorrir  auK'}rjr  (hX   36rkr  h	X%   A static string describing the error.rlr  hX   Apizarmr  h
X   38rnr  hX   POSror  hX   INFORMrpr  h]rqr  X
   functionalityrrr  ah]rsr  X
   ssh_get_errorrtr  auK(}rur  (hX   37rvr  h	X-   what functions does ssh_session have avaliblerwr  hX
   Programmerrxr  h
NhNhX
   ELICIT-INFORMryr  h]rzr  X	   structurer{r  ah]r|r  X   ssh_sessionr}r  auK)}r~r  (hX   38rr  h	X>   The following are some functions that utilize a ssh_session:\nrr  hX   Apizarr  h
X   40rr  hX   PARTrr  hX   INFORMrr  h]rr  X	   structurerr  ah]rr  X   ssh_sessionrr  auK*}rr  (hX   38rr  h	XY   ssh_event_new\nssh_free\nssh_message_get\nssh_new\nssh_options_copy\nssh_options_get_portrr  hX   Apizarr  h
X   41rr  hX   CONTrr  hX   INFORMrr  h]rr  X	   structurerr  ah]rr  X   ssh_sessionrr  auK+}rr  (hX   39rr  h	X,   what argument does the ssh_get_error() take?rr  hX
   Programmerrr  h
X   37rr  hX   FOLrr  hX
   ELICIT-INFORMrr  h]rr  X   basicrr  ah]rr  X
   ssh_get_errorrr  auK,}rr  (hX   40rr  h	X@   The function signature is const char* ssh_get_error(void *error)rr  hX   Apizarr  h
X   43rr  hX   POSrr  hX   INFORMrr  h]rr  X   basicrr  ah]rr  X
   ssh_get_errorrr  auK-}rr  (hX   41rr  h	X   how to authenticate?rr  hX
   Programmerrr  h
NhNhX   ELICIT-OFFER-OR-SUGGESTIONrr  h]rr  X   patternsrr  ahNuK.}rr  (hX   42rr  h	X9   There are many functions associated with authentication. rr  hX   Apizarr  h
X   45rr  hX   PARTrr  hX   INFORMrr  h]rr  X	   structurerr  ahNuK/}rr  (hX   42rr  h	X   Which are you interested in:\nrr  hX   Apizarr  h
X   46rr  hX   FOLrr  hX
   ELICIT-INFORMrr  h]rr  X	   structurerr  ahNuK0}rr  (hX   42rr  h	X  ssh_userauth_agent\nssh_userauth_gssapi\nssh_userauth_kbdint\nssh_userauth_kbdint_getanswer\nssh_userauth_kbdint_getinstruction\nssh_userauth_kbdint_getname\nssh_userauth_kbdint_getnanswers\nssh_userauth_kbdint_getnprompts\nssh_userauth_kbdint_getprompt\nssh_userauth_kbdint_setanswer\nssh_userauth_list\nssh_userauth_none\nssh_userauth_password\nssh_userauth_publickey\nssh_userauth_publickey_auto\nssh_userauth_try_publickeyrr  hX   Apizarr  h
X   47rr  hX   CONTrr  hX   INFORMrr  h]rr  X	   structurerr  ahNuK1}rr  (hX   43rr  h	X.   what is the signature of ssh_userauth_passwordrr  hX
   Programmerrr  h
X   48rr  hX   FOLrr  hX
   ELICIT-INFORMrr  h]rr  X   basicrr  ah]rr  X   ssh_userauth_passwordrr  auK2}rr  (hX   44rr  h	Xc   int ssh_userauth_password\t(ssh_session session, const char * \tusername, const char * \tpassword )rr  hX   Apizarr  h
X   49rr  hX   POSrr  hX   INFORMrr  h]rr  X   basicrr  ah]rr  X   ssh_userauth_passwordrr  auK3}rr  (hX   45rr  h	X-   what are the preconditions of ssh_connect() ?rr  hX
   Programmerrr  h
NhNhX
   ELICIT-INFORMrr  h]rr  X
   directivesrr  ah]rr  X   ssh_connectrr  auK4}rr  (hX   46rr  h	X-   You must have a valid ssh session to connect.rr  hX   Apizarr  h
X   51rr  hX   POSrr  hX   INFORMrr  h]rr  X
   directivesrr  ah]rr  X   ssh_connectrr  auK5}rr  (hX   47rr  h	X   is username the SERVER ?rr  hX
   Programmerrr  h
X   50rr  hX   FOLrr  hX
   ELICIT-INFORMrr  h]rr  X   conceptsrr  ah]rr  X   ssh_userauth_passwordr s  auK6}rs  (hX   48rs  h	X   I am unsure.rs  hX   Apizars  h
X   53rs  hX   UNCrs  hX   INFORMrs  hNh]rs  X   ssh_userauth_passwordr	s  auK7}r
s  (hX   49rs  h	X5   what are the preconditions of ssh_userauth_password ?rs  hX
   Programmerr
s  h
X   50rs  hX   FOLrs  hX
   ELICIT-INFORMrs  h]rs  X
   directivesrs  ah]rs  X   ssh_userauth_passwordrs  auK8}rs  (hX   50rs  h	XV   You must have a valid ssh session and the password to authenticate should be in UTF-8.rs  hX   Apizars  h
X   55rs  hX   POSrs  hX   INFORMrs  h]rs  X
   directivesrs  ah]rs  X   ssh_userauth_passwordrs  auK9}r s  (hX   51r!s  h	X#   How do you authenticate the server?r"s  hX
   Programmerr#s  h
NhNhX   ELICIT-OFFER-OR-SUGGESTIONr$s  h]r%s  X   patternsr&s  ahNuK:}r's  (hX   52r(s  h	X8   There are many functions associated with authentication.r)s  hX   Apizar*s  h
X   57r+s  hX   PARTr,s  hX   INFORMr-s  h]r.s  X	   structurer/s  ahNuK;}r0s  (hX   52r1s  h	X   Which are you interested in:\nr2s  hX   Apizar3s  h
X   58r4s  hX   FOLr5s  hX
   ELICIT-INFORMr6s  h]r7s  X	   structurer8s  ahNuK<}r9s  (hX   52r:s  h	X  ssh_userauth_agent\nssh_userauth_gssapi\nssh_userauth_kbdint\nssh_userauth_kbdint_getanswer\nssh_userauth_kbdint_getinstruction\nssh_userauth_kbdint_getname\nssh_userauth_kbdint_getnanswers\nssh_userauth_kbdint_getnprompts\nssh_userauth_kbdint_getprompt\nssh_userauth_kbdint_setanswer\nssh_userauth_list\nssh_userauth_none\nssh_userauth_password\nssh_userauth_publickey\nssh_userauth_publickey_auto\nssh_userauth_try_publickeyr;s  hX   Apizar<s  h
X   59r=s  hX   CONTr>s  hX   INFORMr?s  h]r@s  X	   structurerAs  ahNuK=}rBs  (hX   53rCs  h	X   is ssh_session a struct?rDs  hX
   ProgrammerrEs  h
NhNhX
   ELICIT-INFORMrFs  h]rGs  X   basicrHs  ah]rIs  X   ssh_sessionrJs  auK>}rKs  (hX   54rLs  h	X   yESrMs  hX   ApizarNs  h
X   61rOs  hX   POSrPs  hX   INFORMrQs  h]rRs  X   basicrSs  ah]rTs  X   ssh_sessionrUs  auK?}rVs  (hX   55rWs  h	X   It is a pointer to a struct.rXs  hX   ApizarYs  h
X   62rZs  hX   CONTr[s  hX   INFORMr\s  h]r]s  X   basicr^s  ah]r_s  X   ssh_sessionr`s  auK@}ras  (hX   56rbs  h	XD   is there any documentation around the use of ssh_userauth_password ?rcs  hX
   Programmerrds  h
NhNhX
   ELICIT-INFORMres  h]rfs  X   patternsrgs  ah]rhs  X   ssh_userauth_passwordris  auKA}rjs  (hX   57rks  h	X3   Here is the description of ssh_userauth_password:\nrls  hX   Apizarms  h
X   64rns  hX   POSros  hX   INFORMrps  h]rqs  (X
   functionalityrrs  X
   directivesrss  eh]rts  X   ssh_userauth_passwordrus  auKB}rvs  (hX   57rws  h	X  Try to authenticate by password.\nThis authentication method is normally disabled on SSHv2 server. You should use keyboard-interactive mode.\nThe 'password' value MUST be encoded UTF-8. It is up to the server how to interpret the password and validate it against the password database. However, if you read the password in some other encoding, you MUST convert the password to UTF-8.rxs  hX   Apizarys  h
X   65rzs  hX   CONTr{s  hX   INFORMr|s  h]r}s  (X
   functionalityr~s  X
   directivesrs  eh]rs  X   ssh_userauth_passwordrs  auKC}rs  (hX   58rs  h	X/   does ssh_userauth_password block on user input?rs  hX
   Programmerrs  h
NhNhX
   ELICIT-INFORMrs  h]rs  X
   functionalityrs  ah]rs  X   ssh_userauth_passwordrs  auKD}rs  (hX   59rs  h	X   I am unsure.rs  hX   Apizars  h
X   67rs  hX   UNCrs  hX   INFORMrs  hNh]rs  X   ssh_userauth_passwordrs  auKE}rs  (hX   60rs  h	X(   what is the description of ssh_connect ?rs  hX
   Programmerrs  h
NhNhX
   ELICIT-INFORMrs  h]rs  (X
   functionalityrs  X   basicrs  eh]rs  X   ssh_connectrs  auKF}rs  (hX   61rs  h	X   Connect to the ssh server.rs  hX   Apizars  h
X   69rs  hX   POSrs  hX   INFORMrs  h]rs  X
   functionalityrs  ah]rs  X   ssh_connectrs  auKG}rs  (hX   62rs  h	X.   what is the description of ssh_userauth_list ?rs  hX
   Programmerrs  h
X   60rs  hX   FOLrs  hX
   ELICIT-INFORMrs  h]rs  (X
   functionalityrs  X   basicrs  eh]rs  X   ssh_userauth_listrs  auKH}rs  (hX   63rs  h	X   Get available authentication methods from the server.\nThis requires the function ssh_userauth_none() to be called before the methods are available. The server MAY return a list of methods that may continue.rs  hX   Apizars  h
X   71rs  hX   POSrs  hX   INFORMrs  h]rs  (X
   functionalityrs  X
   directivesrs  eh]rs  X   ssh_userauth_listrs  auKI}rs  (hX   64rs  h	X   describe ssh_userauth_noners  hX
   Programmerrs  h
X   60rs  hX   FOLrs  hX
   ELICIT-INFORMrs  h]rs  X   basicrs  ah]rs  X   ssh_userauth_noners  auKJ}rs  (hX   65rs  h	X   Get available authentication methods from the server.\nThis requires the function ssh_userauth_none() to be called before the methods are available. The server MAY return a list of methods that may continue.rs  hX   Apizars  h
X   73rs  hX   POSrs  hX   INFORMrs  h]rs  X
   functionalityrs  ah]rs  X   ssh_userauth_listrs  auKK}rs  (hX   66rs  h	X-   what is the description of ssh_userauth_none?rs  hX
   Programmerrs  h
X   73rs  hX   REPrs  hX
   ELICIT-INFORMrs  h]rs  (X
   functionalityrs  X   basicrs  eh]rs  X   ssh_userauth_noners  auKL}rs  (hX   67rs  h	X.   Try to authenticate through the "none" method.rs  hX   Apizars  h
X   75rs  hX   POSrs  hX   INFORMrs  h]rs  X
   functionalityrs  ah]rs  X   ssh_userauth_noners  auKM}rs  (hX   68rs  h	X'   function signature of ssh_userauth_noners  hX
   Programmerrs  h
X   60rs  hX   FOLrs  hX
   ELICIT-INFORMrs  h]rs  X   basicrs  ah]rs  X   ssh_userauth_noners  auKN}rs  (hX   69rs  h	XA   int ssh_userauth_none(ssh_session session, const char * username)rs  hX   Apizars  h
X   77rs  hX   POSrs  hX   INFORMrs  h]r t  X   basicrt  ah]rt  X   ssh_userauth_nonert  auKO}rt  (hX   70rt  h	XF   is what order should ssh_connect and ssh_userauth_password be called ?rt  hX
   Programmerrt  h
NhNhX   ELICIT-OFFER-OR-SUGGESTIONrt  h]r	t  X
   directivesr
t  ah]rt  (X   ssh_userauth_nonert  X   ssh_connectr
t  euKP}rt  (hX   71rt  h	X   I am unsure.rt  hX   Apizart  h
X   79rt  hX   UNCrt  hX   INFORMrt  hNh]rt  (X   ssh_userauth_nonert  X   ssh_connectrt  euKQ}rt  (hX   72rt  h	X2   what could cause an error in ssh_userauth_passwordrt  hX
   Programmerrt  h
NhNhX
   ELICIT-INFORMrt  h]rt  X
   functionalityrt  ah]rt  X   ssh_userauth_passwordr t  auKR}r!t  (hX   73r"t  h	X>   is there any further information about ssh_userauth_password ?r#t  hX
   Programmerr$t  h
X   66r%t  hX   FOLr&t  hX
   ELICIT-INFORMr't  h]r(t  X   basicr)t  ah]r*t  X   ssh_userauth_passwordr+t  auKS}r,t  (hX   74r-t  h	X:   Would you like to know what ssh_userauth_password returns?r.t  hX   Apizar/t  h
X   82r0t  hX   FOLr1t  hX   OFFERr2t  h]r3t  X
   functionalityr4t  ah]r5t  X   ssh_userauth_passwordr6t  auKT}r7t  (hX   75r8t  h	X   nor9t  hX
   Programmerr:t  h
X   83r;t  hX   NEGr<t  hX   ASSESSr=t  h]r>t  X
   functionalityr?t  ah]r@t  X   ssh_userauth_passwordrAt  auKU}rBt  (hX   76rCt  h	X#   how can ssh_userauth_password fail?rDt  hX
   ProgrammerrEt  h
X   81rFt  hX   REPrGt  hX
   ELICIT-INFORMrHt  h]rIt  X
   functionalityrJt  ah]rKt  X   ssh_userauth_passwordrLt  auKV}rMt  (hX   77rNt  h	XJ   There are a couple different status codes that this function can return:\nrOt  hX   ApizarPt  h
X   85rQt  hX   PARTrRt  hX   INFORMrSt  h]rTt  X
   functionalityrUt  ah]rVt  X   ssh_userauth_passwordrWt  auKW}rXt  (hX   77rYt  h	X9  SSH_AUTH_ERROR: A serious error happened.\nSSH_AUTH_DENIED: Authentication failed: use another method\nSSH_AUTH_PARTIAL: You've been partially authenticated, you still have to use another method\nSSH_AUTH_SUCCESS: Authentication success\nSSH_AUTH_AGAIN: In nonblocking mode, you've got to call this again later.\nrZt  hX   Apizar[t  h
X   86r\t  hX   CONTr]t  hX   INFORMr^t  h]r_t  X
   functionalityr`t  ah]rat  X   ssh_userauth_passwordrbt  auKX}rct  (hX   77rdt  h	X   Note\nMost server implementations do not permit changing the username during authentication. The username should only be set with ssh_options_set() only before you connect to the server.ret  hX   Apizarft  h
X   87rgt  hX   CONTrht  hX   INFORMrit  h]rjt  X
   functionalityrkt  ah]rlt  X   ssh_userauth_passwordrmt  auKY}rnt  (hX   78rot  h	X%   function signature of ssh_options_setrpt  hX
   Programmerrqt  h
X   88rrt  hX   FOLrst  hX
   ELICIT-INFORMrtt  h]rut  X   basicrvt  ah]rwt  X   ssh_options_setrxt  auKZ}ryt  (hX   79rzt  h	XW   int ssh_options_set(ssh_session \tsession, enum ssh_options_e type, const void * value)r{t  hX   Apizar|t  h
X   89r}t  hX   POSr~t  hX   INFORMrt  h]rt  X   basicrt  ah]rt  X   ssh_options_setrt  auK[}rt  (hX   80rt  h	X+   what are possible values of ssh_options_e ?rt  hX
   Programmerrt  h
X   90rt  hX   FOLrt  hX
   ELICIT-INFORMrt  h]rt  X
   directivesrt  ah]rt  X   ssh_options_setrt  auK\}rt  (hX   81rt  h	Xf  SSH_OPTIONS_HOST,\n SSH_OPTIONS_PORT,\n SSH_OPTIONS_PORT_STR,\n SSH_OPTIONS_FD,\n SSH_OPTIONS_USER,\n SSH_OPTIONS_SSH_DIR,\n SSH_OPTIONS_IDENTITY,\n SSH_OPTIONS_ADD_IDENTITY,\n SSH_OPTIONS_KNOWNHOSTS,\n SSH_OPTIONS_TIMEOUT,\n SSH_OPTIONS_TIMEOUT_USEC,\n SSH_OPTIONS_SSH1,\n SSH_OPTIONS_SSH2,\n SSH_OPTIONS_LOG_VERBOSITY,\n SSH_OPTIONS_LOG_VERBOSITY_STR,\n SSH_OPTIONS_CIPHERS_C_S,\n SSH_OPTIONS_CIPHERS_S_C,\n SSH_OPTIONS_COMPRESSION_C_S,\n SSH_OPTIONS_COMPRESSION_S_C,\n SSH_OPTIONS_PROXYCOMMAND,\n SSH_OPTIONS_BINDADDR,\n SSH_OPTIONS_STRICTHOSTKEYCHECK,\n SSH_OPTIONS_COMPRESSION,\n SSH_OPTIONS_COMPRESSION_LEVELrt  hX   Apizart  h
X   91rt  hX   POSrt  hX   INFORMrt  h]rt  X
   directivesrt  ah]rt  X   ssh_options_setrt  auK]}rt  (hX   82rt  h	X/   what is documentation of SSH_OPTIONS_IDENTITY ?rt  hX
   Programmerrt  h
X   92rt  hX   FOLrt  hX
   ELICIT-INFORMrt  h]rt  X   basicrt  ahNuK^}rt  (hX   83rt  h	X   I am unsure.rt  hX   Apizart  h
X   93rt  hX   UNCrt  hX   INFORMrt  hNhNuK_}rt  (hX   84rt  h	X!   documentation for ssh_options_setrt  hX
   Programmerrt  h
NhNhX
   ELICIT-INFORMrt  h]rt  X   basicrt  ah]rt  X   ssh_options_setrt  auK`}rt  (hX   85rt  h	X/   This function can set all possible ssh options.rt  hX   Apizart  h
X   95rt  hX   PARTrt  hX   INFORMrt  h]rt  X
   functionalityrt  ah]rt  X   ssh_options_setrt  auKa}rt  (hX   86rt  h	X   how can ssh_options_set fail?rt  hX
   Programmerrt  h
NhNhX
   ELICIT-INFORMrt  h]rt  X
   functionalityrt  ah]rt  X   ssh_options_setrt  auKb}rt  (hX   87rt  h	X5   This function returns a value of &lt; 0 upon failure.rt  hX   Apizart  h
X   97rt  hX   POSrt  hX   INFORMrt  h]rt  X
   functionalityrt  ah]rt  X   ssh_options_setrt  auKc}rt  (hX   88rt  h	X!   error codes for ssh_options_set ?rt  hX
   Programmerrt  h
NhNhX
   ELICIT-INFORMrt  h]rt  X
   functionalityrt  ah]rt  X   ssh_options_setrt  auKd}rt  (hX   89rt  h	X   I am unsure.rt  hX   Apizart  h
X   99rt  hX   UNCrt  hX   INFORMrt  hNh]rt  X   ssh_options_setrt  auKe}rt  (hX   90rt  h	X!   description for ssh_options_set ?rt  hX
   Programmerrt  h
NhNhX
   ELICIT-INFORMrt  h]rt  X   basicrt  ah]rt  X   ssh_options_setrt  auKf}rt  (hX   91rt  h	X   ssh_options_set preconditions ?rt  hX
   Programmerrt  h
NhNhX
   ELICIT-INFORMrt  h]rt  X
   directivesrt  ah]rt  X   ssh_options_setrt  auKg}rt  (hX   92rt  h	X/   This function can set all possible ssh options.rt  hX   Apizart  h
X   101rt  hX   POSrt  hX   INFORMrt  h]rt  X
   functionalityrt  ah]rt  X   ssh_options_setr u  auKh}ru  (hX   93ru  h	X   ssh_options_set preconditions?ru  hX
   Programmerru  h
X   102ru  hX   REPru  hX
   ELICIT-INFORMru  h]ru  X
   directivesr	u  ah]r
u  X   ssh_options_setru  auKi}ru  (hX   94r
u  h	XB   Would you like to know more about the parameters of this function?ru  hX   Apizaru  h
NhNhX   OFFERru  h]ru  X
   functionalityru  ah]ru  X   ssh_options_setru  auKj}ru  (hX   95ru  h	X   yesru  hX
   Programmerru  h
X   105ru  hX   POSru  hX   ASSESSru  h]ru  X
   functionalityru  ah]ru  X   ssh_options_setru  auKk}r u  (hX   96r!u  h	Xk  session: An allocated SSH session structure.\ntype: The option type to set. This could be one of the following:\nSSH_OPTIONS_HOST: The hostname or ip address to connect to (const char *).\nSSH_OPTIONS_PORT: The port to connect to (unsigned int).\nSSH_OPTIONS_PORT_STR: The port to connect to (const char *).\nSSH_OPTIONS_FD: The file descriptor to use (socket_t).r"u  hX   Apizar#u  h
X   105r$u  hX   CONTr%u  hX   INFORMr&u  h]r'u  X
   functionalityr(u  ah]r)u  X   ssh_options_setr*u  auKl}r+u  (hX   97r,u  h	X   If you wish to open the socket yourself for a reason or another, set the file descriptor. Don't forget to set the hostname as the hostname is used as a key in the known_host mechanism.\nSSH_OPTIONS_BINDADDR: The address to bind the client to (const char *).\nSSH_OPTIONS_USER: The username for authentication (const char *).\n\nIf the value is NULL, the username is set to the default username.\nSSH_OPTIONS_SSH_DIR: Set the ssh directory (const char *,format string).\n\nIf the value is NULL, the directory is set to the default ssh directory.r-u  hX   Apizar.u  h
X   107r/u  hX   CONTr0u  hX   INFORMr1u  h]r2u  X
   functionalityr3u  ah]r4u  X   ssh_options_setr5u  auKm}r6u  (hX   98r7u  h	X  The ssh directory is used for files like known_hosts and identity (private and public key). It may include "%s" which will be replaced by the user home directory.\nSSH_OPTIONS_KNOWNHOSTS: Set the known hosts file name (const char *,format string).\n\nIf the value is NULL, the directory is set to the default known hosts file, normally ~/.ssh/known_hosts.\n\nThe known hosts file is used to certify remote hosts are genuine. It may include "%d" which will be replaced by the user home directory.\nSSH_OPTIONS_GLOBAL_KNOWNHOSTS: Set the global known hosts file name (const char *,format string).\n\nIf the value is NULL, the directory is set to the default global known hosts file, normally /etc/ssh/ssh_known_hosts.r8u  hX   Apizar9u  h
X   108r:u  hX   CONTr;u  hX   INFORMr<u  h]r=u  X
   functionalityr>u  ah]r?u  X   ssh_options_setr@u  auKn}rAu  (hX   99rBu  h	X  The known hosts file is used to certify remote hosts are genuine.\nSSH_OPTIONS_ADD_IDENTITY (or SSH_OPTIONS_IDENTITY): Add a new identity file (const char *, format string) to the identity list.\n\nBy default identity, id_dsa and id_rsa are checked.\n\nThe identity used to authenticate with public key will be prepended to the list. It may include "%s" which will be replaced by the user home directory.\nSSH_OPTIONS_TIMEOUT: Set a timeout for the connection in seconds (long).\nSSH_OPTIONS_TIMEOUT_USEC: Set a timeout for the connection in micro seconds (long).\nSSH_OPTIONS_SSH1: Allow or deny the connection to SSH1 servers (int, 0 is false).\nSSH_OPTIONS_SSH2: Allow or deny the connection to SSH2 servers (int, 0 is false).\nSSH_OPTIONS_LOG_VERBOSITY: Set the session logging verbosity (int).rCu  hX   ApizarDu  h
X   109rEu  hX   CONTrFu  hX   INFORMrGu  h]rHu  X
   functionalityrIu  ah]rJu  X   ssh_options_setrKu  auuuK}rLu  (hj?>  h}rMu  (K }rNu  (hhh	X(   How would I get key input from the user?rOu  hX
   ProgrammerrPu  h
NhNhX   ELICIT-OFFER-OR-SUGGESTIONrQu  h]rRu  X   patternsrSu  ahNuK}rTu  (hhh	X   Hi!rUu  hX   ApizarVu  h
NhNhX   BE-POSITIVErWu  hNhNuK}rXu  (hhh	XH   I'm Apiza, a virtual assistant designed to help you with api questions! rYu  hX   ApizarZu  h
NhNhX   INFORMr[u  hNhNuK}r\u  (hhh	X$   I look forward to helping you today.r]u  hX   Apizar^u  h
NhNhX   BE-POSITIVEr_u  hNhNuK}r`u  (hh+h	X   Okay, rau  hX
   Programmerrbu  h
h+hX   POSrcu  hX   ASSESSrdu  hNhNuK}reu  (hh+h	X(   how would I get key input from the user?rfu  hX
   Programmerrgu  h
hhX   REPrhu  hX   ELICIT-OFFER-OR-SUGGESTIONriu  h]rju  X   patternsrku  ahNuK}rlu  (hh5h	X   Hi!rmu  hX   Apizarnu  h
hhX   REProu  hX   BE-POSITIVErpu  hNhNuK}rqu  (hh5h	XG   I'm Apiza, a virtual assistant designed to help you with api questions!rru  hX   Apizarsu  h
hhX   REPrtu  hX   INFORMruu  hNhNuK}rvu  (hh5h	X$   I look forward to helping you today.rwu  hX   Apizarxu  h
h+hX   REPryu  hX   BE-POSITIVErzu  hNhNuK	}r{u  (hh<h	Xp   you can use the al_wait_for_event(ALLEGRO_EVENT_QUEUE* q, ALLEGRO_EVENT* ev) function to get input from the userr|u  hX   Apizar}u  h
h<hX   POSr~u  hX   INFORMru  h]ru  (X   patternsru  X   basicru  eh]ru  X   al_wait_for_eventru  auK
}ru  (hhFh	X(   What kind of data type does that return?ru  hX
   Programmerru  h
hchX   FOLru  hX
   ELICIT-INFORMru  h]ru  X   basicru  ah]ru  X   al_wait_for_eventru  auK}ru  (hhQh	Xq   al_wait_for_event(ALLEGRO_EVENT_QUEUE* q, ALLEGRO_EVENT* ev) will populate the ALLEGRO_EVENT* object upon successru  hX   Apizaru  h
X   10ru  hX   POSru  hX   INFORMru  h]ru  X
   functionalityru  ah]ru  X   al_wait_for_eventru  auK}ru  (hhXh	X3   What variables does the ALLEGRO_EVENT* object have?ru  hX
   Programmerru  h
X   11ru  hX   FOLru  hX
   ELICIT-INFORMru  h]ru  X	   structureru  ah]ru  X
   ALLEGRO_EVENTru  auK
}ru  (hhch	X,   would you like the entire union declaration?ru  hX   Apizaru  h
X   12ru  hX   FOLru  hX   OFFERru  h]ru  (X	   structureru  X   basicru  eh]ru  X
   ALLEGRO_EVENTru  auK}ru  (hX   10ru  h	X   Yesru  hX
   Programmerru  h
X   13ru  hX   POSru  hX   ASSESSru  hNh]ru  X
   ALLEGRO_EVENTru  auK}ru  (hX   11ru  h	X  union ALLEGRO_EVENT\n{\n /* This must be the same as the first field of _AL_EVENT_HEADER. */\n ALLEGRO_EVENT_TYPE type;\n /* `any' is to allow the user to access the other fields which are\n * common to all event types, without using some specific type\n * structure.\n */\n ALLEGRO_ANY_EVENT any;\n ALLEGRO_DISPLAY_EVENT display;\n ALLEGRO_JOYSTICK_EVENT joystick;\n ALLEGRO_KEYBOARD_EVENT keyboard;\n ALLEGRO_MOUSE_EVENT mouse;\n ALLEGRO_TIMER_EVENT timer;\n ALLEGRO_TOUCH_EVENT touch;\n ALLEGRO_USER_EVENT user;\n};ru  hX   Apizaru  h
X   14ru  hX   POSru  hX   INFORMru  h]ru  (X
   directivesru  X	   structureru  X   basicru  eh]ru  X
   ALLEGRO_EVENTru  auK}ru  (hX   12ru  h	XD   Can I have more information about the ALLEGRO_KEYBOARD_EVENT object?ru  hX
   Programmerru  h
X   15ru  hX   FOLru  hX
   ELICIT-INFORMru  h]ru  X   basicru  ahNuK}ru  (hX   13ru  h	X   Sure!ru  hX   Apizaru  h
X   16ru  hX   POSru  hX   INFORMru  hNhNuK}ru  (hX   13ru  h	X   ALLEGRO_KEYBOARD_EVENT is a struct that contains a display pointer, the keycode of the physical key pressed, and other informationru  hX   Apizaru  h
X   17ru  hX   CONTru  hX   INFORMru  h]ru  X   basicru  ah]ru  X
   ALLEGRO_EVENTru  auK}ru  (hX   14ru  h	X   Can I see the definition?ru  hX
   Programmerru  h
X   18ru  hX   FOLru  hX
   ELICIT-INFORMru  h]ru  X	   structureru  ah]ru  X
   ALLEGRO_EVENTru  auK}ru  (hX   15ru  h	Xn  typedef struct ALLEGRO_KEYBOARD_EVENT\n{\n _AL_EVENT_HEADER(struct ALLEGRO_KEYBOARD)\n struct ALLEGRO_DISPLAY *display; /* the window the key was pressed in */\n int keycode; /* the physical key pressed */\n int unichar; /* unicode character or negative */\n unsigned int modifiers; /* bitfield */\n bool repeat; /* auto-repeated or not */\n} ALLEGRO_KEYBOARD_EVENT;ru  hX   Apizaru  h
X   19ru  hX   POSru  hX   INFORMru  h]ru  X	   structureru  ah]ru  X
   ALLEGRO_EVENTru  auK}ru  (hX   16ru  h	X5   Do you know what the keycodes are for the arrow keys?ru  hX
   Programmerru  h
X   20ru  hX   FOLru  hX
   ELICIT-INFORMru  h]ru  X	   structureru  ah]ru  X
   ALLEGRO_EVENTru  auK}ru  (hX   17r v  h	X<   I believe allegro5 has predefined enum values for keycodes. rv  hX   Apizarv  h
X   21rv  hX   POSrv  hX   INFORMrv  h]rv  X	   structurerv  ah]rv  X
   ALLEGRO_EVENTr	v  auK}r
v  (hX   17rv  h	XE   For instance, you could compare ev.keyboard.keycode == ALLEGRO_KEY_UPrv  hX   Apizar
v  h
X   22rv  hX   CONTrv  hX   INFORMrv  h]rv  X   examplesrv  ah]rv  X
   ALLEGRO_EVENTrv  auK}rv  (hX   18rv  h	XS   It seems that the ALLEGRO_KEY_UP does not match ev.keyboard.keycode for some reasonrv  hX
   Programmerrv  h
X   23rv  hX   FOLrv  hX   INFORMrv  h]rv  X
   functionalityrv  ah]rv  X
   ALLEGRO_EVENTrv  auK}r v  (hX   19r!v  h	X   I am unsure,r"v  hX   Apizar#v  h
X   24r$v  hX   UNCr%v  hX   INFORMr&v  hNhNuK}r'v  (hX   19r(v  h	X   can you provide me an example?r)v  hX   Apizar*v  h
X   24r+v  hX   FOLr,v  hX
   ELICIT-INFORMr-v  h]r.v  X   examplesr/v  ah]r0v  X
   ALLEGRO_EVENTr1v  auK}r2v  (hX   20r3v  h	XO   ev.keyboard,keycode is returned large numbers, while ALLGRO_KEY_UP is simply 85r4v  hX
   Programmerr5v  h
X   26r6v  hX   POSr7v  hX   INFORMr8v  h]r9v  (X   examplesr:v  X
   functionalityr;v  eh]r<v  X
   ALLEGRO_EVENTr=v  auK}r>v  (hX   21r?v  h	XA   are you pressing the up arrow key and not getting ALLEGRO_KEY_UP?r@v  hX   ApizarAv  h
X   27rBv  hX   FOLrCv  hX
   ELICIT-INFORMrDv  h]rEv  X
   functionalityrFv  ah]rGv  X
   ALLEGRO_EVENTrHv  auK}rIv  (hX   22rJv  h	X   YesrKv  hX
   ProgrammerrLv  h
X   28rMv  hX   POSrNv  hX   INFORMrOv  hNhNuK}rPv  (hX   23rQv  h	X
   I am unsure. rRv  hX   ApizarSv  h
X   29rTv  hX   UNCrUv  hX   INFORMrVv  hNhNuK}rWv  (hX   23rXv  h	X:   What have you done to initialize the keyboard and allegro?rYv  hX   ApizarZv  h
X   29r[v  hX   FOLr\v  hX
   ELICIT-INFORMr]v  h]r^v  X   patternsr_v  ahNuK }r`v  (hX   24rav  h	X#   I have not initialized the keyboardrbv  hX
   Programmerrcv  h
X   31rdv  hX   POSrev  hX   INFORMrfv  h]rgv  X   patternsrhv  ahNuK!}riv  (hX   25rjv  h	X/   I believe that may have something to do with itrkv  hX   Apizarlv  h
X   32rmv  hX   POSrnv  hX   INFORMrov  h]rpv  X   patternsrqv  ah]rrv  X
   ALLEGRO_EVENTrsv  auK"}rtv  (hX   26ruv  h	X$   How would I initialize the keyboard?rvv  hX
   Programmerrwv  h
X   33rxv  hX   FOLryv  hX   ELICIT-OFFER-OR-SUGGESTIONrzv  h]r{v  X   patternsr|v  ahNuK#}r}v  (hX   27r~v  h	XY   you can use the function:\n\nbool al_install_keyboard(void)\n\nto initialize the keyboardrv  hX   Apizarv  h
X   34rv  hX   POSrv  hX   SUGGESTrv  h]rv  (X   patternsrv  X   basicrv  eh]rv  X   al_install_keyboardrv  auK$}rv  (hX   28rv  h	X'   It does not seem to have had any affectrv  hX
   Programmerrv  h
X   35rv  hX   NEGrv  hX   INFORMrv  h]rv  X
   functionalityrv  ah]rv  (X   al_install_keyboardrv  X
   ALLEGRO_EVENTrv  euK%}rv  (hX   29rv  h	X.   What else have you done to initialize allegro?rv  hX   Apizarv  h
X   36rv  hX   FOLrv  hX
   ELICIT-INFORMrv  h]rv  X   patternsrv  ahNuK&}rv  (hX   30rv  h	Xj   I have done al_init(), al_create_display(), al_create_event_queue(), al_create_timer, and al_create_bitmaprv  hX
   Programmerrv  h
X   37rv  hX   POSrv  hX   INFORMrv  h]rv  X   patternsrv  ahNuK'}rv  (hX   31rv  h	X   Great! rv  hX   Apizarv  h
X   38rv  hX   POSrv  hX   ASSESSrv  hNhNuK(}rv  (hX   31rv  h	X/   Have you connected the event queue and devices?rv  hX   Apizarv  h
X   38rv  hX   FOLrv  hX
   ELICIT-INFORMrv  h]rv  X   patternsrv  ahNuK)}rv  (hX   32rv  h	X   I don't think so,rv  hX
   Programmerrv  h
X   40rv  hX   POSrv  hX   INFORMrv  hNhNuK*}rv  (hX   32rv  h	X   what would that look like?rv  hX
   Programmerrv  h
X   40rv  hX   FOLrv  hX
   ELICIT-INFORMrv  h]rv  X   patternsrv  ahNuK+}rv  (hX   33rv  h	XQ   you can use al_register_event_source(ALLEGRO_EVENT_QUEUE* q, EVENT_SOURCE* src). rv  hX   Apizarv  h
X   42rv  hX   POSrv  hX   SUGGESTrv  h]rv  (X   patternsrv  X   basicrv  eh]rv  X   al_register_event_sourcerv  auK,}rv  (hX   33rv  h	X   Would you like an example?rv  hX   Apizarv  h
X   43rv  hX   FOLrv  hX   OFFERrv  h]rv  X   examplesrv  ah]rv  X   al_register_event_sourcerv  auK-}rv  (hX   34rv  h	X   Yesrv  hX
   Programmerrv  h
X   45rv  hX   POSrv  hX   ASSESSrv  hNhNuK.}rv  (hX   35rv  h	X   ALLEGRO_EVENT_QUEUE* q = NULL;\nal_init();\nq = al_create_event_queue();\nal_install_keyboard();\nal_register_event_source(q, al_get_keyboard_event_source());rv  hX   Apizarv  h
X   46rv  hX   POSrv  hX   INFORMrv  h]rv  X   examplesrv  ah]rv  X   al_register_event_sourcerv  auK/}rv  (hX   36rv  h	XC   How can I tell if the user isn't touching anything on the keyboard?rv  hX
   Programmerrv  h
NhNhX   ELICIT-OFFER-OR-SUGGESTIONrv  h]rv  X   patternsrv  ahNuK0}rv  (hX   37rv  h	X
   I am unsure. rv  hX   Apizarv  h
X   47rv  hX   UNCrv  hX   INFORMrv  hNhNuK1}rv  (hX   37rv  h	XP   I assume no events would be fired then and the event queue would be always emptyr w  hX   Apizarw  h
X   47rw  hX   POSrw  hX   INFORMrw  h]rw  X   controlrw  ahNuK2}rw  (hX   38rw  h	X.   How can I tell if the user is holding the key?r	w  hX
   Programmerr
w  h
NhNhX   ELICIT-OFFER-OR-SUGGESTIONrw  h]rw  X   patternsr
w  ahNuK3}rw  (hX   39rw  h	X   Sorry, rw  hX   Apizarw  h
X   50rw  hX   UNCrw  hX   BE-POSITIVErw  hNhNuK4}rw  (hX   39rw  h	X   please clarifyrw  hX   Apizarw  h
X   51rw  hX   CONTrw  hX   SUGGESTrw  hNhNuK5}rw  (hX   40rw  h	X   How can I play soudn?rw  hX
   Programmerrw  h
NhNhX   OTHERr w  h]r!w  X   patternsr"w  ahNuK6}r#w  (hX   41r$w  h	X   How can I play sound?r%w  hX
   Programmerr&w  h
X   53r'w  hX   REPr(w  hX   ELICIT-OFFER-OR-SUGGESTIONr)w  h]r*w  X   patternsr+w  ahNuK7}r,w  (hX   42r-w  h	X@   The first step to playing audio is to initialize an audio driverr.w  hX   Apizar/w  h
X   54r0w  hX   POSr1w  hX   SUGGESTr2w  h]r3w  X   patternsr4w  ahNuK8}r5w  (hX   43r6w  h	X$   How do I initialize an audio driver?r7w  hX
   Programmerr8w  h
X   55r9w  hX   FOLr:w  hX   ELICIT-OFFER-OR-SUGGESTIONr;w  h]r<w  X   patternsr=w  ahNuK9}r>w  (hX   44r?w  h	XY   You can use the function:\n\nbool al_install_audio(void)\n\nto initialize an audio driverr@w  hX   ApizarAw  h
X   56rBw  hX   POSrCw  hX   SUGGESTrDw  h]rEw  (X   patternsrFw  X   basicrGw  eh]rHw  X   al_install_audiorIw  auK:}rJw  (hX   45rKw  h	X   What's the next step?rLw  hX
   ProgrammerrMw  h
X   57rNw  hX   FOLrOw  hX   ELICIT-OFFER-OR-SUGGESTIONrPw  h]rQw  X   patternsrRw  ahNuK;}rSw  (hX   46rTw  h	X>   The second step to playing audio is to initialize audio codecsrUw  hX   ApizarVw  h
X   58rWw  hX   POSrXw  hX   SUGGESTrYw  h]rZw  X   patternsr[w  ahNuK<}r\w  (hX   47r]w  h	X!   How do I initialize audio codecs?r^w  hX
   Programmerr_w  h
X   59r`w  hX   FOLraw  hX   ELICIT-OFFER-OR-SUGGESTIONrbw  h]rcw  X   patternsrdw  ahNuK=}rew  (hX   48rfw  h	XF   You can do this using the function:\n\nbool al_init_acodec_addon(void)rgw  hX   Apizarhw  h
X   60riw  hX   POSrjw  hX   SUGGESTrkw  h]rlw  (X   patternsrmw  X   basicrnw  eh]row  X   al_init_acodec_addonrpw  auK>}rqw  (hX   49rrw  h	X   What's the next step?rsw  hX
   Programmerrtw  h
X   61ruw  hX   FOLrvw  hX   ELICIT-OFFER-OR-SUGGESTIONrww  h]rxw  X   patternsryw  ahNuK?}rzw  (hX   50r{w  h	X>   There are several branches at this point that a user can take.r|w  hX   Apizar}w  h
X   62r~w  hX   PARTrw  hX   INFORMrw  h]rw  X   patternsrw  ahNuK@}rw  (hX   50rw  h	Xl   What are you attempting to do?\n\n1) Play a pre-recorded sample\n2) Play a sample recorded from a microphonerw  hX   Apizarw  h
X   62rw  hX   FOLrw  hX
   ELICIT-INFORMrw  h]rw  X   patternsrw  ahNuKA}rw  (hX   51rw  h	X   Play a pre-recorded samplerw  hX
   Programmerrw  h
X   64rw  hX   POSrw  hX   INFORMrw  h]rw  X   patternsrw  ahNuKB}rw  (hX   52rw  h	XJ   The first step to playing a sound file is to reserve the sample in memory.rw  hX   Apizarw  h
X   65rw  hX   POSrw  hX   SUGGESTrw  h]rw  X   patternsrw  ahNuKC}rw  (hX   52rw  h	X   This can be done using two functions:\n\nbool al_reserve_samples(int num_samples);\nALLEGRO_SAMPLE* sample = al_load_sample(const char* filepath);rw  hX   Apizarw  h
X   66rw  hX   CONTrw  hX   INFORMrw  h]rw  (X   patternsrw  X   basicrw  eh]rw  (X   al_reserve_samplesrw  X   al_load_samplerw  euKD}rw  (hX   53rw  h	X!   What is the parameter num_samplesrw  hX
   Programmerrw  h
X   67rw  hX   FOLrw  hX
   ELICIT-INFORMrw  h]rw  (X
   functionalityrw  X   conceptsrw  eh]rw  X   al_reserve_samplesrw  auKE}rw  (hX   54rw  h	XY   int num_samples in reference to function:\n\nbool al_reserve_samples(int num_samples)\n\nrw  hX   Apizarw  h
X   68rw  hX   POSrw  hX   INFORMrw  h]rw  X   basicrw  ah]rw  X   al_reserve_samplesrw  auKF}rw  (hX   54rw  h	XA   refers to the number of sound files you want to load into memory.rw  hX   Apizarw  h
X   69rw  hX   CONTrw  hX   INFORMrw  h]rw  (X
   functionalityrw  X   conceptsrw  eh]rw  X   al_reserve_samplesrw  auKG}rw  (hX   55rw  h	X   Okay, rw  hX
   Programmerrw  h
X   70rw  hX   POSrw  hX   ASSESSrw  hNhNuKH}rw  (hX   55rw  h	X   what's the next step?rw  hX
   Programmerrw  h
X   67rw  hX   FOLrw  hX   ELICIT-OFFER-OR-SUGGESTIONrw  h]rw  X   patternsrw  ahNuKI}rw  (hX   56rw  h	X   The next step is to play the loaded ALLEGRO_SAMPLE* object using the function:\n\nbool al_play_sample(ALLEGRO_SAMPLE *spl, float gain, float pan, float speed,\n ALLEGRO_PLAYMODE loop, ALLEGRO_SAMPLE_ID *ret_id)rw  hX   Apizarw  h
X   72rw  hX   POSrw  hX   SUGGESTrw  h]rw  (X   patternsrw  X   basicrw  eh]rw  X   al_play_samplerw  auKJ}rw  (hX   57rw  h	X6   Can you explain to me the parameters of that function?rw  hX
   Programmerrw  h
X   73rw  hX   FOLrw  hX
   ELICIT-INFORMrw  h]rw  X
   functionalityrw  ah]rw  X   al_play_samplerw  auKK}rw  (hX   58rw  h	X   Sure!rw  hX   Apizarw  h
X   74rw  hX   POSrw  hX   INFORMrw  hNhNuKL}rw  (hX   58rw  h	X,   Here is a description of the parameters:\n\nrw  hX   Apizarw  h
X   74r x  hX   POSrx  hX   INFORMrx  hNh]rx  X   al_play_samplerx  auKM}rx  (hX   58rx  h	X3  ALLEGRO_SAMPLE* spl: The sample file data\nfloat gain: The gain of the played sample\nfloat pan: The pan of the played sample\nfloat speed: The speed to play the file\nALLEGRO_PLAYMODE loop: whether to loop the file or not\nALLEGRO_SAMPLE_ID* ret_id: Typically NULL, however this is the return id to be usedrx  hX   Apizarx  h
X   76r	x  hX   CONTr
x  hX   INFORMrx  h]rx  X
   functionalityr
x  ah]rx  X   al_play_samplerx  auKN}rx  (hX   59rx  h	X+   And you explain more about ALLEGRO_PLAYMODErx  hX
   Programmerrx  h
X   77rx  hX   FOLrx  hX
   ELICIT-INFORMrx  h]rx  (X   basicrx  X   conceptsrx  eh]rx  (X   al_play_samplerx  X   ALLEGRO_PLAYMODErx  euKO}rx  (hX   60rx  h	X.   Here are the options for ALLEGRO_PLAYMODE:\n\nrx  hX   Apizar x  h
X   78r!x  hX   POSr"x  hX   INFORMr#x  hNh]r$x  X   ALLEGRO_PLAYMODEr%x  auKP}r&x  (hX   60r'x  h	X$   Sample and stream playback mode.\n\nr(x  hX   Apizar)x  h
X   79r*x  hX   CONTr+x  hX   INFORMr,x  h]r-x  X   conceptsr.x  ah]r/x  X   ALLEGRO_PLAYMODEr0x  auKQ}r1x  (hX   60r2x  h	XJ   * ALLEGRO_PLAYMODE_ONCE\n* ALLEGRO_PLAYMODE_LOOP\n* ALLEGRO_PLAYMODE_BIDIRr3x  hX   Apizar4x  h
X   80r5x  hX   CONTr6x  hX   INFORMr7x  h]r8x  X	   structurer9x  ah]r:x  X   ALLEGRO_PLAYMODEr;x  auKR}r<x  (hX   61r=x  h	X   How would I display text?r>x  hX
   Programmerr?x  h
NhNhX   ELICIT-OFFER-OR-SUGGESTIONr@x  h]rAx  X   patternsrBx  ahNuKS}rCx  (hX   62rDx  h	X   I am sorry, rEx  hX   ApizarFx  h
X   82rGx  hX   NEGrHx  hX   BE-POSITIVErIx  hNhNuKT}rJx  (hX   62rKx  h	X&   there are multiple ways to show text, rLx  hX   ApizarMx  h
X   82rNx  hX   FOLrOx  hX   INFORMrPx  h]rQx  X   patternsrRx  ahNuKU}rSx  (hX   62rTx  h	X#   specifically to which do you refer?rUx  hX   ApizarVx  h
X   84rWx  hX   CONTrXx  hX
   ELICIT-INFORMrYx  h]rZx  X   patternsr[x  ahNuKV}r\x  (hX   63r]x  h	X;   I would like to display a score on the corner of the screenr^x  hX
   Programmerr_x  h
X   85r`x  hX   POSrax  hX   INFORMrbx  h]rcx  X   patternsrdx  ahNuKW}rex  (hX   64rfx  h	X   Would you like to draw a font?rgx  hX   Apizarhx  h
X   86rix  hX   FOLrjx  hX
   ELICIT-INFORMrkx  h]rlx  X   patternsrmx  ahNuKX}rnx  (hX   65rox  h	X   Yesrpx  hX
   Programmerrqx  h
X   87rrx  hX   POSrsx  hX   INFORMrtx  hNhNuKY}rux  (hX   66rvx  h	X   Great! rwx  hX   Apizarxx  h
X   88ryx  hX   POSrzx  hX   BE-POSITIVEr{x  hNhNuKZ}r|x  (hX   66r}x  h	X%   You can start by initializing fonts. r~x  hX   Apizarx  h
X   88rx  hX   POSrx  hX   SUGGESTrx  h]rx  X   patternsrx  ahNuK[}rx  (hX   66rx  h	Xd   This can be done via the functions:\n\nbool al_init_font_addon(void);\nbool al_init_ttf_addon(void);rx  hX   Apizarx  h
X   90rx  hX   CONTrx  hX   INFORMrx  h]rx  (X   patternsrx  X   basicrx  eh]rx  (X   al_init_font_addonrx  X   al_init_ttf_addonrx  euK\}rx  (hX   67rx  h	X   Then?rx  hX
   Programmerrx  h
X   91rx  hX   FOLrx  hX   ELICIT-OFFER-OR-SUGGESTIONrx  h]rx  X   patternsrx  ahNuK]}rx  (hX   68rx  h	X   Have you created a display?rx  hX   Apizarx  h
X   92rx  hX   FOLrx  hX
   ELICIT-INFORMrx  h]rx  X   patternsrx  ahNuK^}rx  (hX   69rx  h	X   Yesrx  hX
   Programmerrx  h
X   93rx  hX   POSrx  hX   INFORMrx  h]rx  X   patternsrx  ahNuK_}rx  (hX   70rx  h	X{   you can first load in a font using the function:\n\nALLEGRO_FONT* al_load_ttf_font(const char* fpath, int size, int flags);rx  hX   Apizarx  h
X   94rx  hX   POSrx  hX   INFORMrx  h]rx  (X   patternsrx  X   basicrx  eh]rx  X   al_load_ttf_fontrx  auK`}rx  (hX   71rx  h	X)   Can you elaborate on the flags parameter?rx  hX
   Programmerrx  h
X   95rx  hX   FOLrx  hX
   ELICIT-INFORMrx  h]rx  X
   functionalityrx  ah]rx  X   al_load_ttf_fontrx  auKa}rx  (hX   72rx  h	X   Here is flag information:\n\nrx  hX   Apizarx  h
X   96rx  hX   POSrx  hX   INFORMrx  hNh]rx  X   al_load_ttf_fontrx  auKb}rx  (hX   72rx  h	Xr  The following flags are supported:\n\n* ALLEGRO_TTF_NO_KERNING - Do not use any kerning even if the font file\n supports it.\n\n* ALLEGRO_TTF_MONOCHROME - Load as a monochrome font (which means no\n anti-aliasing of the font is done).\n\n* ALLEGRO_TTF_NO_AUTOHINT - Disable the Auto Hinter which is enabled by default\n in newer versions of FreeType. Since: 5.0.6, 5.1.2rx  hX   Apizarx  h
X   97rx  hX   CONTrx  hX   INFORMrx  h]rx  (X
   functionalityrx  X   conceptsrx  X
   directivesrx  X   environmentrx  eh]rx  X   al_load_ttf_fontrx  auKc}rx  (hX   73rx  h	X   Then?rx  hX
   Programmerrx  h
X   98rx  hX   FOLrx  hX   ELICIT-OFFER-OR-SUGGESTIONrx  h]rx  X   patternsrx  ahNuKd}rx  (hX   74rx  h	X3   You can draw text using the following function:\n\nrx  hX   Apizarx  h
X   99rx  hX   POSrx  hX   SUGGESTrx  h]rx  X   patternsrx  ah]rx  X   al_draw_textrx  auKe}rx  (hX   74rx  h	Xs   void al_draw_text(const ALLEGRO_FONT *font,\n ALLEGRO_COLOR color, float x, float y, int flags,\n char const *text)rx  hX   Apizarx  h
X   100rx  hX   CONTrx  hX   INFORMrx  h]rx  (X   patternsrx  X   basicrx  eh]rx  X   al_draw_textrx  auKf}rx  (hX   75rx  h	X:   Can you give me more information about the color parameterrx  hX
   Programmerrx  h
X   101rx  hX   FOLr y  hX
   ELICIT-INFORMry  h]ry  X   basicry  ah]ry  X   al_draw_textry  auKg}ry  (hX   76ry  h	X2   ALLEGRO_COLOR is a struct containing rgba values. ry  hX   Apizar	y  h
X   102r
y  hX   POSry  hX   INFORMry  h]r
y  X   basicry  ah]ry  (X   al_draw_textry  X
   ALLEGRO_COLORry  euKh}ry  (hX   76ry  h	X   Would you like the declarationry  hX   Apizary  h
X   103ry  hX   FOLry  hX
   ELICIT-INFORMry  h]ry  X	   structurery  ah]ry  X
   ALLEGRO_COLORry  auKi}ry  (hX   77ry  h	X   Yesry  hX
   Programmerr y  h
X   104r!y  hX   POSr"y  hX   INFORMr#y  hNhNuKj}r$y  (hX   78r%y  h	Xz   * Type: ALLEGRO_COLOR\n */\ntypedef struct ALLEGRO_COLOR ALLEGRO_COLOR;\n\nstruct ALLEGRO_COLOR\n{\n float r, g, b, a;\n};r&y  hX   Apizar'y  h
X   105r(y  hX   POSr)y  hX   INFORMr*y  h]r+y  X	   structurer,y  ah]r-y  X
   ALLEGRO_COLORr.y  auKk}r/y  (hX   79r0y  h	X=   Can you give more more information about the flags parameter?r1y  hX
   Programmerr2y  h
X   101r3y  hX   FOLr4y  hX
   ELICIT-INFORMr5y  h]r6y  X   basicr7y  ah]r8y  X   al_draw_textr9y  auKl}r:y  (hX   80r;y  h	X  The `flags` parameter can be 0 or one of the following flags:\n\n- ALLEGRO_ALIGN_LEFT - Draw the text left-aligned (same as 0).\n- ALLEGRO_ALIGN_CENTRE - Draw the text centered around the given position.\n- ALLEGRO_ALIGN_RIGHT - Draw the text right-aligned to the given position.r<y  hX   Apizar=y  h
X   107r>y  hX   POSr?y  hX   INFORMr@y  h]rAy  (X
   functionalityrBy  X
   directivesrCy  eh]rDy  X   al_draw_textrEy  auKm}rFy  (hX   81rGy  h	X,   What is a typical font size for ALLEGRO_FONTrHy  hX
   ProgrammerrIy  h
X   95rJy  hX   FOLrKy  hX
   ELICIT-INFORMrLy  h]rMy  X   patternsrNy  ah]rOy  (X   ALLEGRO_FONTrPy  X   al_load_ttf_fontrQy  euKn}rRy  (hX   82rSy  h	X   It depends on your screen. rTy  hX   ApizarUy  h
X   109rVy  hX   PARTrWy  hX   INFORMrXy  h]rYy  X   patternsrZy  ah]r[y  (X   ALLEGRO_FONTr\y  X   al_load_ttf_fontr]y  euKo}r^y  (hX   82r_y  h	XG   I would suggest trying a bunch of values. Typically, I would suggest 72r`y  hX   Apizaray  h
X   109rby  hX   POSrcy  hX   SUGGESTrdy  h]rey  X   patternsrfy  ah]rgy  (X   ALLEGRO_FONTrhy  X   al_load_ttf_fontriy  euKp}rjy  (hX   83rky  h	XF   How big are the numbers r, g, b, and a typically are for ALLEGRO_COLORrly  hX
   Programmerrmy  h
X   106rny  hX   FOLroy  hX
   ELICIT-INFORMrpy  h]rqy  X   patternsrry  ah]rsy  X
   ALLEGRO_COLORrty  auKq}ruy  (hX   84rvy  h	X"   rgb are typically within [0,255]. rwy  hX   Apizarxy  h
X   112ryy  hX   POSrzy  hX   INFORMr{y  h]r|y  (X
   directivesr}y  X   patternsr~y  eh]ry  X
   ALLEGRO_COLORry  auKr}ry  (hX   84ry  h	XY   Allegro5 supports utility functions to map rbg values to an ALLEGRO_COLOR struct instancery  hX   Apizary  h
X   113ry  hX   FOLry  hX   INFORMry  h]ry  X
   functionalityry  ah]ry  X
   ALLEGRO_COLORry  auKs}ry  (hX   85ry  h	X&   Can you show my the utility functions?ry  hX
   Programmerry  h
X   114ry  hX   FOLry  hX
   ELICIT-INFORMry  h]ry  X	   structurery  ahNuKt}ry  (hX   86ry  h	XK   One such utility is:\n\nALLEGRO_COLOR al_map_rgb(float r, float g, float b)ry  hX   Apizary  h
X   115ry  hX   POSry  hX   INFORMry  h]ry  X	   structurery  ah]ry  X
   al_map_rgbry  auKu}ry  (hX   87ry  h	X   My al_draw_text is not drawingry  hX
   Programmerry  h
NhNhX   INFORMry  h]ry  X
   functionalityry  ah]ry  X   al_draw_textry  auKv}ry  (hX   88ry  h	X
   I am unsure, ry  hX   Apizary  h
X   117ry  hX   UNCry  hX   INFORMry  hNhNuKw}ry  (hX   88ry  h	X   please specifyry  hX   Apizary  h
X   118ry  hX   CONTry  hX   SUGGESTry  hNhNuuuu.