---
name: Feature Request
about: Request a new or modified feature
title: "[FEATURE] <feature request>"
labels: ''
assignees: ''

---

**Steps to follow in requesting a feature with `osmdata`**

1. Please ensure that what you are requesting is compatible with the underlying structure of Open Street Map (OSM) itself, for example by searching the [OSM wiki](https://wiki.openstreetmap.org/wiki/Main_Page) or the overview of the [overpass Query Language](https://wiki.openstreetmap.org/wiki/Overpass_API/Overpass_QL) for all relevant information. Please include links to any relevant pages in your issue.
2. Please provide reproducible code generated by the [`reprex` package](https://reprex.tidyverse.org) to demonstrate current behaviour of `osmdata` which you would like changed or improved, including the following lines in your `reprex`:
``` r
# <your reprex code here>

packageVersion("osmdata")
R.Version()$version.string
#sessionInfo()
```
3. Please use the results of the preceding step to explain precisely what you would like modified from or added to the results as given.


Thanks! :smile:
