# Simulations of 2B-7AGNRs structures #

- We study the magnetic properties induced upon inserting boron pairs (2B) on the backbone of 7-carbon-atom wide armchair graphene nanoribbons (2B-7AGNR) via spin-polarized density functional theory (DFT) calculations performed with [SIESTA][siesta] package.

- The input files are the pseudo-potentials (`B.blyp.vps`, `C.blyp.psf`, `H.opt88.psf` for free-standing calculations and also `Au.blyp.psf`, `Au_s.blyp.psf`, `Au_t.blyp.psf` for calculations with Au slab and tip) and the fdf input from [SIESTA][siesta] (`RUN.fdf`). The output files are the relaxed geometry (*system_name*`.XV` and *system_name*`.xyz`) and the main output file from [SIESTA][siesta] (`RUN.out`), which contains the date of the simulation and [SIESTA][siesta] version used.

## Map of the content (folders)

### pseudopotentials

- All pseudo-potentials used in the calculations.

    **note:** `Au.blyp.psf`, `Au_s.blyp.psf`, and `Au_t.blyp.psf` are the same pseudo-potential, but referred in the fdf input files with different basis set.

### 2B-7AGNR

- **with_Au_surf_and_tip**

    2B-7AGNR suspended between a model gold tip and the surface of a Au(111) slab (Fig. 4).

    - **2B_close**

        With the 2B lying on the surface (Fig. 4a).

    - **2B_transition**

        With one B from the pair lying on the surface and the other suspended (Fig. 4b).

    - **2B_far**

        With the 2B fully suspended (Fig. 4c).

- **free-standing**

    - **long_7AGNR_with_2B_unit**

       7AGNR with 17-unit cells long and with a boron pair inserted in its center (SM Fig. 3).

    - **same_struct_as_on_Au**

       Free-standing 2B-7AGNRs with geometries corresponding to the 2B-7AGNRs structures on Au (dashed lines PDOS plots on Fig. 4 and SM Fig. 4). The center carbon atom from one of the terminations is double hydrogen passivated to mimic the effect of chemical bonding with the Au tip.

        - **2B_close**

        - **2B_transition**

        - **2B_far**
    
    - **sp3_7AGNR2B_sp3**

       13-unit cells long 7AGNR with a boron pair inserted in its center and having the center carbon atoms from the terminations with a double hydrogen passivation (spin polarization density map from Fig. 1).

### 2x2B-7AGNR

- **with_Au_surf_and_tip**

    7AGNR having two consecutive 2B moieties suspended between a model gold tip and the surface of a Au(111) slab, with one 2B lying on the surface of the Au slab while the other 2B is fully suspended (Fig. 5f).

- **free-standing**

    Free-standing 2x2B-7AGNRs with geometry corresponding to the 2x2B-7AGNR structure on Au and having the center carbon atom from one of the terminations double passivated with hydrogen atoms to mimic the effect of chemical bonding with the Au tip (spin polarization density map from Fig. 5b).

<!---
Links to external and internal sites.
-->
[siesta]: https://gitlab.com/siesta-project/siesta
