#------------------------------------------------------
#
#    October 2020
#    Script associated to publication:
#    "Sensitivity of precipitation and temperature over Mount Kenya area to 
#     physics parameterization options in a high-resolution modelsimulation 
#     performed with WRFV3.8.1"
#    Authors: M. Messmer, S.J. Gonzlez-Roj, C.C. Raible and T.F. Stocker
#
#
#    Creative Commons License: Attribution-NonCommercial 4.0 International (CC BY-NC 4.0)
#------------------------------------------------------

# Scripts to plot large table of WRF Configuration spatial patterns #
# Scatter plots with table #

#### OBSERVATIONS ####

WRF.2.27.4 <- read.table(paste0(idir,"DataCors_SetUp27km_4Doms_d04_usingSpearman.txt"), header = TRUE, sep = ";", dec = ".")
WRF.2.25.3 <- read.table(paste0(idir,"DataCors_SetUp25km_3Doms_d03_usingSpearman.txt"), header = TRUE, sep = ";", dec = ".")
WRF.2.9.3  <- read.table(paste0(idir,"DataCors_SetUp9km_3Doms_d03_usingSpearman.txt"), header = TRUE, sep = ";", dec = ".")
WRF.2.5.2  <- read.table(paste0(idir,"DataCors_SetUp5km_2Doms_d02_usingSpearman.txt"), header = TRUE, sep = ";", dec = ".")
d.WRF <- NULL
d.set.WRF <- c("WRF.2.27.4","WRF.2.25.3","WRF.2.9.3","WRF.2.5.2")
#d.set.names <- c("27 km (D4)","25 km (D3)","9 km (D3)","5 km (D2)")
d.set.names <- c("27km_D04","25km_D03","9km_D03","5km_D02")
shape_array <- c(0,1,2,3)
color_array <- c("#f1c40f", "#3394d5","#7c3b97", "#2abf69")
for (i_set in 1:length(d.set.WRF)){
  d.dat <- get(d.set.WRF[i_set])
  for (i_col in 2:ncol(d.dat)){
    d.WRF.1 <- d.dat[,c(1,i_col)]
    d.WRF.1 <- cbind(d.WRF.1,names(d.dat)[i_col],"setup"=d.set.WRF[i_set],"name"=d.set.names[i_set],"shape"=shape_array[i_set],"color"=color_array[i_set])
    names(d.WRF.1) <- c("Month","correlation","parameterization","setup","name","shape","color")
    d.WRF <- rbind(d.WRF,d.WRF.1)
  }
}
d.WRF[d.WRF$parameterization == "ERA5",]
# start plotting #
corr_limit <- 0.5
# str(d.WRF)
d.WRF$shape <- as.factor(d.WRF$shape)
d.WRF$Month <- as.factor(d.WRF$Month)
d.WRF$Month <- factor(d.WRF$Month,levels=c(unique(d.WRF[order(d.WRF$Month,decreasing=T),]$Month)))
param <- c("Martina","Marcelo","Cumulus3","Cumulus3OneWay","NoCumulus", "ERA5", "IMERG", "TRMM", "CHIRPS")
params_title <- c("Europe","South America","Cumulus3","Cumulus3 1-way","No Cumulus", "ERA5", "IMERG", "TRMM", "CHIRPS")
color_bg <- as.data.frame(cbind(param, c("#ffad09","#87d633","#19d5de","#2f93a5","#827dc8","#808b96","#fc9fca","#b92d5b","#572a5b")))
for.title <- as.data.frame(cbind(param,params_title,"color_bg"=as.character(color_bg[,2])))
d.WRF <- merge(d.WRF,for.title,by.x = c("parameterization"),by.y=c("param"))
levels(d.WRF$parameterization)
levels(d.WRF$params_title)
levels(d.WRF$color)

j <- 1
plots <- list()
i_par <- 1
for (i_par in 1:length(param)){
  bp.1 <- ggplot(d.WRF[d.WRF$parameterization == param[i_par],], aes(x=correlation, y=Month))+
    geom_point(color = d.WRF[d.WRF$parameterization == param[i_par],]$color, size = 4, shape = d.WRF[d.WRF$parameterization == param[i_par],]$shape, stroke = 2)+
    geom_vline(xintercept=corr_limit)+
    xlim(-0.1,1)+
    # ggtitle(paste(params_title[i_par]))+
    theme_bw()+ 
    theme(axis.title.x=element_blank(),axis.title.y=element_blank(),axis.text.y = element_blank(), axis.ticks.y = element_blank(), 
          panel.border = element_blank(), axis.line.x.bottom = element_line(), axis.text=element_text(size=18), axis.text.x = element_text(angle = 90, vjust = 0.5, hjust=1))+
    facet_grid(. ~ params_title)+
    theme(strip.placement = "outside",strip.background = element_rect(color = "white",fill=as.character(color_bg[which(color_bg$param == param[i_par]),]$V2)),
          strip.text = element_text(size=15, colour="white", face = "bold"))+
    geom_hline(yintercept = Inf, color = "white", size = 4)
  
  #Compute descriptive statistics by groups
  sig.correlation <- d.WRF[d.WRF$parameterization == param[i_par],][d.WRF[d.WRF$parameterization == param[i_par],]$correlation > corr_limit,]
  stable <- aggregate(correlation ~ name*shape,sig.correlation,length)
  if (nrow(stable) != length(unique(d.WRF[d.WRF$parameterization == param[i_par],]$setup))){
    missing <- unique(d.WRF[d.WRF$parameterization == param[i_par],]$name)[-which(unique(d.WRF[d.WRF$parameterization == param[i_par],]$name) %in% stable$name)]
    missing <- as.character(missing)
    stable <- rbind(stable, cbind("name"= missing,"shape" = 2, "correlation" = 0))
  }
  # str(stable)
  names(stable) <- c("Setup","Symbol","# months")
  #stable <- desc_statby(d.WRF[d.WRF$parameterization == param[i_par],], measure.var = "correlation",
  #                      grps = "setup")
  #stable <- stable[, c("Species", "length", "mean", "sd")]
  # Summary table plot, medium orange theme
  stable.p <- ggtexttable(stable, rows = NULL, 
                          theme = ttheme("mBlack"))
  bp <- ggarrange(bp.1, stable.p, ncol = 1, nrow = 2, heights = c(1, 0.2))
  
  plot_name <- paste0("bp",j)
  plots[[plot_name]] <- bp
  j <- j+1
  
}
#c(rep("green",12),rep("#fc9fca",12),rep("#b92d5b",12),rep("#572a5b",12))
d.WRF.2 <- d.WRF
d.WRF.2$description <- "AAA"
d.WRF.2[d.WRF.2$parameterization %in% c("ERA5", "IMERG", "TRMM","CHIRPS"),]$description <- "ERA5, IMERG, TRMM & CHIRPS"

bp.1 <- ggplot(d.WRF.2[d.WRF$parameterization %in% c("ERA5", "IMERG", "TRMM","CHIRPS") & d.WRF.2$setup == "WRF.2.27.4",], aes(x=correlation, y=Month))+
  geom_point(color = d.WRF.2[d.WRF.2$parameterization %in% c("ERA5", "IMERG", "TRMM","CHIRPS") & d.WRF.2$setup == "WRF.2.27.4",]$color_bg, size = 5, shape = 16)+
  geom_vline(xintercept=corr_limit)+
  xlim(-0.1,1)+
  # ggtitle(paste("ERA5, IMERG, TRMM and CHIRPS"))+
  theme_bw()+ 
  theme(axis.title.x=element_blank(),axis.title.y=element_blank(),axis.text.y = element_blank(), axis.ticks.y = element_blank(), 
        panel.border = element_blank(), axis.line.x.bottom = element_line(), axis.text=element_text(size=18), axis.text.x = element_text(angle = 90, vjust = 0.5, hjust=1))+
  facet_grid(. ~ description)+
  theme(strip.placement = "outside",strip.background = element_rect(color = "white",fill="white"),
        strip.text = element_text(size=15, colour="black"))+
  geom_hline(yintercept = Inf, color = "white", size = 4)

#Compute descriptive statistics by groups
sig.correlation <- d.WRF[d.WRF$parameterization %in% c("ERA5", "IMERG", "TRMM","CHIRPS")  & d.WRF$setup == "WRF.2.27.4",][d.WRF[d.WRF$parameterization %in% c("ERA5", "IMERG", "TRMM","CHIRPS") & d.WRF$setup == "WRF.2.27.4",]$correlation > corr_limit,]
stable <- aggregate(correlation ~ parameterization*shape,sig.correlation,length)
str(stable)
names(stable) <- c("Dataset","Symbol","# months")

stable.p <- ggtexttable(stable, rows = NULL, 
                        theme = ttheme("mBlack"))
bp <- ggarrange(bp.1, stable.p, ncol = 1, nrow = 2, heights = c(1, 0.2))
plot_name <- paste0("bp",j)
plots[[plot_name]] <- bp


# put plots together and save in file #
n <- length(plots)
nCol <- floor(sqrt(n))
do.call("grid.arrange", c(plots, ncol=nCol))
plot.zusammen <- do.call("arrangeGrob", c(plots, ncol=nCol))
#ggarrange(plots[[1]],plots[[2]],plots[[3]],plots[[4]],plots[[5]],plots[[6]],plots[[7]],plots[[8]], ncol = 4, nrow = 2)

#speichern
ggsave(file =  paste0(odir, ts_done, "/","scatter_WRF_spatial_corr_station.pdf"), 
       ggarrange(plots[[1]],plots[[2]],plots[[3]],plots[[4]],plots[[5]],plots[[10]], ncol = 6, nrow = 1),
       height = 10, width = 20, dpi = 300)


#### WRF SIMULATIONS AGAINST CHIRPS ####

WRF.2.27.4 <- read.table(paste0(idir,"DataCors_CHIRPSasRef_SetUp27km_4Doms_d04.txt"), header = TRUE, sep = ";", dec = ".")
WRF.2.25.3 <- read.table(paste0(idir,"DataCors_CHIRPSasRef_SetUp25km_3Doms_d03.txt"), header = TRUE, sep = ";", dec = ".")
WRF.2.9.3  <- read.table(paste0(idir,"DataCors_CHIRPSasRef_SetUp9km_3Doms_d03.txt"), header = TRUE, sep = ";", dec = ".")
WRF.2.5.2  <- read.table(paste0(idir,"DataCors_CHIRPSasRef_SetUp5km_2Doms_d02.txt"), header = TRUE, sep = ";", dec = ".")
d.WRF <- NULL
d.set.WRF <- c("WRF.2.27.4","WRF.2.25.3","WRF.2.9.3","WRF.2.5.2")
#d.set.names <- c("27 km (D4)","25 km (D3)","9 km (D3)","5 km (D2)")
d.set.names <- c("27km_D04","25km_D03","9km_D03","5km_D02")
shape_array <- c(0,1,2,3)
#color_array <- c("#F9AB0F", "#07A8B0","#4407B0", "#076701")
for (i_set in 1:length(d.set.WRF)){
  d.dat <- get(d.set.WRF[i_set])
  for (i_col in 2:ncol(d.dat)){
    d.WRF.1 <- d.dat[,c(1,i_col)]
    d.WRF.1 <- cbind(d.WRF.1,names(d.dat)[i_col],"setup"=d.set.WRF[i_set],"name"=d.set.names[i_set],"shape"=shape_array[i_set],"color"=color_array[i_set])
    names(d.WRF.1) <- c("Month","correlation","parameterization","setup","name","shape","color")
    d.WRF <- rbind(d.WRF,d.WRF.1)
  }
}
# start plotting #
# str(d.WRF)
d.WRF$shape <- as.factor(d.WRF$shape)
d.WRF$Month <- as.factor(d.WRF$Month)
d.WRF$Month <- factor(d.WRF$Month,levels=c(unique(d.WRF[order(d.WRF$Month,decreasing=T),]$Month)))
d.WRF <- merge(d.WRF,for.title,by.x = c("parameterization"),by.y=c("param"))
# param <- c("Martina","Marcelo","Cumulus3","Cumulus3OneWay","NoCumulus") #, "ERA5", "IMERG", "TRMM")
# params_title <- c("Europe","S. America","Cumulus3","Cumulus3 1-Way","No Cumulus")

j <- 1
plots <- list()
for (i_par in 1:length(param)){
  bp.1 <- ggplot(d.WRF[d.WRF$parameterization == param[i_par],], aes(x=correlation, y=Month))+
    geom_point(color = d.WRF[d.WRF$parameterization == param[i_par],]$color, size = 4, shape = d.WRF[d.WRF$parameterization == param[i_par],]$shape, stroke = 2)+
    geom_vline(xintercept=corr_limit)+
    xlim(-0.1,1)+
    # ggtitle(paste(params_title[i_par]))+
    theme_bw()+ 
    theme(axis.title.x=element_blank(),axis.title.y=element_blank(),axis.text.y = element_blank(), axis.ticks.y = element_blank(), 
          panel.border = element_blank(), axis.line.x.bottom = element_line(), axis.text=element_text(size=18), axis.text.x = element_text(angle = 90, vjust = 0.5, hjust=1))+
    facet_grid(. ~ params_title)+
    theme(strip.placement = "outside",strip.background = element_rect(color = "white",fill=as.character(color_bg[which(color_bg$param == param[i_par]),]$V2)),
          strip.text = element_text(size=15, colour="white", face = "bold"))+
    geom_hline(yintercept = Inf, color = "white", size = 4)
  
  #Compute descriptive statistics by groups
  sig.correlation <- d.WRF[d.WRF$parameterization == param[i_par],][d.WRF[d.WRF$parameterization == param[i_par],]$correlation > corr_limit,]
  stable <- aggregate(correlation ~ name*shape,sig.correlation,length)
  if (nrow(stable) != length(unique(d.WRF[d.WRF$parameterization == param[i_par],]$setup))){
    missing <- unique(d.WRF[d.WRF$parameterization == param[i_par],]$name)[-which(unique(d.WRF[d.WRF$parameterization == param[i_par],]$name) %in% stable$name)]
    missing <- as.character(missing)
    stable <- rbind(stable, cbind("name"= missing,"shape" = 2, "correlation" = 0))
  }
  # str(stable)
  names(stable) <- c("Setup","Symbol","# months")
  #stable <- desc_statby(d.WRF[d.WRF$parameterization == param[i_par],], measure.var = "correlation",
  #                      grps = "setup")
  #stable <- stable[, c("Species", "length", "mean", "sd")]
  # Summary table plot, medium orange theme
  stable.p <- ggtexttable(stable, rows = NULL, 
                          theme = ttheme("mBlack"))
  bp <- ggarrange(bp.1, stable.p, ncol = 1, nrow = 2, heights = c(1, 0.2))
  
  plot_name <- paste0("bp",j)
  plots[[plot_name]] <- bp
  j <- j+1
  
}

d.WRF.2 <- d.WRF
d.WRF.2$description <- "AAA"
d.WRF.2[d.WRF.2$parameterization %in% c("ERA5", "IMERG", "TRMM"),]$description <- "ERA5, IMERG & TRMM"

bp.1 <- ggplot(d.WRF.2[d.WRF.2$parameterization %in% c("ERA5", "IMERG", "TRMM") & d.WRF.2$setup == "WRF.2.27.4",], aes(x=correlation, y=Month))+
  geom_point(color = d.WRF.2[d.WRF.2$parameterization %in% c("ERA5", "IMERG", "TRMM") & d.WRF.2$setup == "WRF.2.27.4",]$color_bg, size = 5, shape = 16)+
  geom_vline(xintercept=corr_limit)+
  xlim(-0.1,1)+
  # ggtitle(paste("ERA5, IMERG and TRMM"))+
  theme_bw()+ 
  theme(axis.title.x=element_blank(),axis.title.y=element_blank(),axis.text.y = element_blank(), axis.ticks.y = element_blank(), 
        panel.border = element_blank(), axis.line.x.bottom = element_line(), axis.text=element_text(size=18), axis.text.x = element_text(angle = 90, vjust = 0.5, hjust=1))+
  facet_grid(. ~ description)+
  theme(strip.placement = "outside",strip.background = element_rect(color = "white",fill="white"),
        strip.text = element_text(size=15, colour="black"))+
  geom_hline(yintercept = Inf, color = "white", size = 4)

#Compute descriptive statistics by groups
sig.correlation <- d.WRF[d.WRF$parameterization %in% c("ERA5", "IMERG", "TRMM")  & d.WRF$setup == "WRF.2.27.4",][d.WRF[d.WRF$parameterization %in% c("ERA5", "IMERG", "TRMM") & d.WRF$setup == "WRF.2.27.4",]$correlation > corr_limit,]
stable <- aggregate(correlation ~ parameterization*shape,sig.correlation,length)
str(stable)
names(stable) <- c("Dataset","Symbol","# months")


stable.p <- ggtexttable(stable, rows = NULL, 
                        theme = ttheme("mBlack"))

bp <- ggarrange(bp.1, stable.p, ncol = 1, nrow = 2, heights = c(1, 0.2))
plot_name <- paste0("bp",j)
plots[[plot_name]] <- bp


# put plots together and save in file #
n <- length(plots)
nCol <- floor(sqrt(n))
do.call("grid.arrange", c(plots, ncol=nCol))
plot.zusammen <- do.call("arrangeGrob", c(plots, ncol=nCol))
#ggarrange(plots[[1]],plots[[2]],plots[[3]],plots[[4]],plots[[5]],plots[[6]],plots[[7]],plots[[8]], ncol = 4, nrow = 2)
#speichern
ggsave(file =  paste0(odir, ts_done, "/","scatter_WRF_spatial_corr_simulations_againstCHIRPS.pdf"), 
       ggarrange(plots[[1]],plots[[2]],plots[[3]],plots[[4]],plots[[5]],plots[[9]], ncol = 6, nrow = 1),
       height = 10, width = 20, dpi = 300)
