#------------------------------------------------------
#
#    October 2020
#    Script associated to publication:
#    "Sensitivity of precipitation and temperature over Mount Kenya area to 
#     physics parameterization options in a high-resolution modelsimulation 
#     performed with WRFV3.8.1"
#    Authors: M. Messmer, S.J. Gonzlez-Roj, C.C. Raible and T.F. Stocker
#
#
#    Creative Commons License: Attribution-NonCommercial 4.0 International (CC BY-NC 4.0)
#------------------------------------------------------

#-----------------------------------------------------
#   DOMAIN D03
#-----------------------------------------------------


#-----------------------------------------------------
#   Read all the monthly values
#-----------------------------------------------------

library(RNetCDF)

post <- open.nc("/Volumes/ELEMENTS/Cosas_Berna/Post/ERA5-Kenya-MonthlySums-IMERG-TRMM-Grides/RR-D03-ERA5-Kenya-Present-Marcelo-3Doms-2008-monthlysum_CHIRPSgrid.nc", write=FALSE)
PrecMarcelo <- var.get.nc(post,'prc')
close.nc(post)

post <- open.nc("/Volumes/ELEMENTS/Cosas_Berna/Post/ERA5-Kenya-MonthlySums-IMERG-TRMM-Grides/RR-D03-ERA5-Kenya-Present-Martina-3Doms-2008-monthlysum_CHIRPSgrid.nc", write=FALSE)
PrecMartina <- var.get.nc(post,'prc')
close.nc(post)

post <- open.nc("/Volumes/ELEMENTS/Cosas_Berna/Post/ERA5-Kenya-MonthlySums-IMERG-TRMM-Grides/RR-D03-ERA5-Kenya-Present-Cumulus3-3Doms-2008-monthlysum_CHIRPSgrid.nc", write=FALSE)
PrecCumulus3 <- var.get.nc(post,'prc')
close.nc(post)

post <- open.nc("/Volumes/ELEMENTS/Cosas_Berna/Post/ERA5-Kenya-MonthlySums-IMERG-TRMM-Grides/RR-D03-ERA5-Kenya-Present-Cumulus3-1Way-3Doms-2008-monthlysum_CHIRPSgrid.nc", write=FALSE)
PrecCumulus3OneWay <- var.get.nc(post,'prc')
close.nc(post)

post <- open.nc("/Volumes/ELEMENTS/Cosas_Berna/Post/ERA5-Kenya-MonthlySums-IMERG-TRMM-Grides/ERA5_RR-2008_monsum_CHIRPSgrid.nc", write=FALSE)
PrecERA5 <- var.get.nc(post,'var1')
close.nc(post)

post <- open.nc("/Volumes/ELEMENTS/Cosas_Berna/Post/ERA5-Kenya-MonthlySums-IMERG-TRMM-Grides/IMERG_RR-2008_monsum_CHIRPSgrid.nc", write=FALSE)
PrecIMERG <- var.get.nc(post,'PR')
close.nc(post)

post <- open.nc("/Volumes/ELEMENTS/Cosas_Berna/Post/ERA5-Kenya-MonthlySums-IMERG-TRMM-Grides/TRMM_RR-2008_monsum_CHIRPSgrid.nc", write=FALSE)
PrecTRMM <- var.get.nc(post,'PR')
close.nc(post)

post <- open.nc("/Volumes/ELEMENTS/Cosas_Berna/Post/ERA5-Kenya-MonthlySums-IMERG-TRMM-Grides/RR-D03-ERA5-Kenya-Present-NoCumulus-3Doms-2008-monthlysum_CHIRPSgrid.nc", write=FALSE)
PrecNoCumulus <- var.get.nc(post,'prc')
close.nc(post)

post <- open.nc("/Volumes/ELEMENTS/Cosas_Berna/Post/ERA5-Kenya-MonthlySums-IMERG-TRMM-Grides/CHIRPS_2008_monsum_rec.nc", write=FALSE)
PrecCHIRPS <- var.get.nc(post,'precip')
close.nc(post)

# Calculate the pattern correlations
dataCor <- data.frame(Month=integer(),
                      Martina=double(),Marcelo=double(),Cumulus3=double(),Cumulus3OneWay=double(),
                      NoCumulus=double(),ERA5=double(),IMERG=double(),TRMM=double())
dataPvalue <-data.frame(Month=integer(),
                        Martina=double(),Marcelo=double(),Cumulus3=double(),Cumulus3OneWay=double(),
                        NoCumulus=double(),ERA5=double(),IMERG=double(),TRMM=double())

library(reshape2)

for (i in 1:12) {
  
  # i=1  
  
  #Save the Month
  dataCor[i,'Month'] <- i
  dataPvalue[i,'Month'] <- i
  
  # reshape the data with melt
  
  meltMartina <- melt(PrecMartina[,,i])
  meltMarcelo <- melt(PrecMarcelo[,,i])
  meltCumulus3 <- melt(PrecCumulus3[,,i])
  meltCumulus3OneWay <- melt(PrecCumulus3OneWay[,,i])
  meltNoCumulus <- melt(PrecNoCumulus[,,i])
  meltERA5 <- melt(PrecERA5[,,i])
  meltIMERG <- melt(PrecIMERG[,,i])
  meltTRMM <- melt(PrecTRMM[,,i])
  meltCHIRPS <- melt(PrecCHIRPS[,,i])
  
  # check that everything is melted in the same way
  # identical(meltMartina[,1:2],meltMarcelo[,1:2])
  # identical(meltMartina[,1:2],meltCumulus3[,1:2])
  # identical(meltMartina[,1:2],meltCumulus3OneWay[,1:2])
  # identical(meltMartina[,1:2],meltNoCumulus[,1:2])
  # identical(meltMartina[,1:2],meltERA5[,1:2])
  # identical(meltMartina[,1:2],meltTRMM[,1:2])
  # TRUE
  
  # Copy the NA structure from any WRF dataset to the others
  indexNA <- is.na(meltMartina$value)
  is.na(meltMarcelo$value[indexNA])<- TRUE
  is.na(meltCumulus3$value[indexNA])<- TRUE
  is.na(meltCumulus3OneWay$value[indexNA])<- TRUE
  is.na(meltIMERG$value[indexNA])<- TRUE
  is.na(meltTRMM$value[indexNA])<- TRUE
  is.na(meltERA5$value[indexNA])<- TRUE
  is.na(meltNoCumulus$value[indexNA])<- TRUE
  is.na(meltCHIRPS$value[indexNA])<- TRUE
  
  #-----------------------------------------------------
  #   WE Choose IMERG as REFERENCE
  #-----------------------------------------------------
  
  
  #Save the Cor and P-value for Martina
  test <- cor.test(x = meltCHIRPS$value,y=meltMartina$value )
  dataCor[i,'Martina'] <- test$estimate
  dataPvalue[i,'Martina'] <- test$p.value
  
  #Save the Cor and P-value for Marcelo
  test <- cor.test(x = meltCHIRPS$value,y=meltMarcelo$value )
  dataCor[i,'Marcelo'] <- test$estimate
  dataPvalue[i,'Marcelo'] <- test$p.value
  
  #Save the Cor and P-value for Cumulus3
  test <- cor.test(x = meltCHIRPS$value,y=meltCumulus3$value )
  dataCor[i,'Cumulus3'] <- test$estimate
  dataPvalue[i,'Cumulus3'] <- test$p.value
  
  #Save the Cor and P-value for Cumulus3OneWay
  test <- cor.test(x = meltCHIRPS$value,y=meltCumulus3OneWay$value )
  dataCor[i,'Cumulus3OneWay'] <- test$estimate
  dataPvalue[i,'Cumulus3OneWay'] <- test$p.value
  
  #Save the Cor and P-value for NoCumulus
  test <- cor.test(x = meltCHIRPS$value,y=meltNoCumulus$value )
  dataCor[i,'NoCumulus'] <- test$estimate
  dataPvalue[i,'NoCumulus'] <- test$p.value
  
  #Save the Cor and P-value for ERA5
  test <- cor.test(x = meltCHIRPS$value,y=meltERA5$value )
  dataCor[i,'ERA5'] <- test$estimate
  dataPvalue[i,'ERA5'] <- test$p.value
  
  #Save the Cor and P-value for IMERG
  test <- cor.test(x = meltCHIRPS$value,y=meltIMERG$value )
  dataCor[i,'IMERG'] <- test$estimate
  dataPvalue[i,'IMERG'] <- test$p.value
  
  #Save the Cor and P-value for CHIRPS
  test <- cor.test(x = meltCHIRPS$value,y=meltTRMM$value )
  dataCor[i,'TRMM'] <- test$estimate
  dataPvalue[i,'TRMM'] <- test$p.value
}


# Save both tables

write.table(x = dataCor,file = "./PatternCorrelationGridded_MtKenyaDomain_inTRMM_IMERG_grids/DataCors_CHIRPSasRef_SetUp9km_3Doms_d03.txt",row.names = F,col.names = T,sep = ";")
write.table(x = dataPvalue,file = "./PatternCorrelationGridded_MtKenyaDomain_inTRMM_IMERG_grids/DataPValues_CHIRPSasRef_SetUp9km_3Doms_d03.txt",row.names = F,col.names = T,sep = ";")


