#------------------------------------------------------
#
#    October 2020
#    Script associated to publication:
#    "Sensitivity of precipitation and temperature over Mount Kenya area to 
#     physics parameterization options in a high-resolution modelsimulation 
#     performed with WRFV3.8.1"
#    Authors: M. Messmer, S.J. Gonzlez-Roj, C.C. Raible and T.F. Stocker
#
#
#    Creative Commons License: Attribution-NonCommercial 4.0 International (CC BY-NC 4.0)
#------------------------------------------------------

#--------------------------------
#
#   BW
#
#--------------------------------


#--------------------------------
#
#   Read the Index values for Set-Up 
#
#--------------------------------

CorsSetUp27km <- read.table("./ScoresData/RawCorData_SetUp27km_4Doms.txt", header = T,sep = ";",stringsAsFactors = F)
CorsSetUp25km <- read.table("./ScoresData/RawCorData_SetUp25km_3Doms.txt", header = T,sep = ";",stringsAsFactors = F)
CorsSetUp5km <- read.table("./ScoresData/RawCorData_SetUp5km_2Doms.txt", header = T,sep = ";",stringsAsFactors = F)
CorsSetUp9km <- read.table("./ScoresData/RawCorData_SetUp9km_3Doms.txt", header = T,sep = ";",stringsAsFactors = F)

RmseSetUp27km <- read.table("./ScoresData/RawRMSEData_SetUp27km_4Doms.txt", header = T,sep = ";",stringsAsFactors = F)
RmseSetUp25km <- read.table("./ScoresData/RawRMSEData_SetUp25km_3Doms.txt", header = T,sep = ";",stringsAsFactors = F)
RmseSetUp5km <- read.table("./ScoresData/RawRMSEData_SetUp5km_2Doms.txt", header = T,sep = ";",stringsAsFactors = F)
RmseSetUp9km <- read.table("./ScoresData/RawRMSEData_SetUp9km_3Doms.txt", header = T,sep = ";",stringsAsFactors = F)

RmseNormSetUp27km <- read.table("./ScoresData/RawRMSENormData_SetUp27km_4Doms.txt", header = T,sep = ";",stringsAsFactors = F)
RmseNormSetUp25km <- read.table("./ScoresData/RawRMSENormData_SetUp25km_3Doms.txt", header = T,sep = ";",stringsAsFactors = F)
RmseNormSetUp5km <- read.table("./ScoresData/RawRMSENormData_SetUp5km_2Doms.txt", header = T,sep = ";",stringsAsFactors = F)
RmseNormSetUp9km <- read.table("./ScoresData/RawRMSENormData_SetUp9km_3Doms.txt", header = T,sep = ";",stringsAsFactors = F)

SdSetUp27km <- read.table("./ScoresData/RawSDData_SetUp27km_4Doms.txt", header = T,sep = ";",stringsAsFactors = F)
SdSetUp25km <- read.table("./ScoresData/RawSDData_SetUp25km_3Doms.txt", header = T,sep = ";",stringsAsFactors = F)
SdSetUp5km <- read.table("./ScoresData/RawSDData_SetUp5km_2Doms.txt", header = T,sep = ";",stringsAsFactors = F)
SdSetUp9km <- read.table("./ScoresData/RawSDData_SetUp9km_3Doms.txt", header = T,sep = ";",stringsAsFactors = F)

SdNormSetUp27km <- read.table("./ScoresData/RawSDNormData_SetUp27km_4Doms.txt", header = T,sep = ";",stringsAsFactors = F)
SdNormSetUp25km <- read.table("./ScoresData/RawSDNormData_SetUp25km_3Doms.txt", header = T,sep = ";",stringsAsFactors = F)
SdNormSetUp5km <- read.table("./ScoresData/RawSDNormData_SetUp5km_2Doms.txt", header = T,sep = ";",stringsAsFactors = F)
SdNormSetUp9km <- read.table("./ScoresData/RawSDNormData_SetUp9km_3Doms.txt", header = T,sep = ";",stringsAsFactors = F)


# reshape the data because they have different number of stations
library(reshape2)
CorsSetUp27kmMelt <- melt(CorsSetUp27km,id.vars = c("Set.Up","EXP"))
CorsSetUp25kmMelt <- melt(CorsSetUp25km,id.vars = c("Set.Up","EXP"))
CorsSetUp9kmMelt <- melt(CorsSetUp9km,id.vars = c("Set.Up","EXP"))
CorsSetUp5kmMelt <- melt(CorsSetUp5km,id.vars = c("Set.Up","EXP"))

RmseSetUp27kmMelt <- melt(RmseSetUp27km,id.vars = c("Set.Up","EXP"))
RmseSetUp25kmMelt <- melt(RmseSetUp25km,id.vars = c("Set.Up","EXP"))
RmseSetUp9kmMelt <- melt(RmseSetUp9km,id.vars = c("Set.Up","EXP"))
RmseSetUp5kmMelt <- melt(RmseSetUp5km,id.vars = c("Set.Up","EXP"))

RmseNormSetUp27kmMelt <- melt(RmseNormSetUp27km,id.vars = c("Set.Up","EXP"))
RmseNormSetUp25kmMelt <- melt(RmseNormSetUp25km,id.vars = c("Set.Up","EXP"))
RmseNormSetUp9kmMelt <- melt(RmseNormSetUp9km,id.vars = c("Set.Up","EXP"))
RmseNormSetUp5kmMelt <- melt(RmseNormSetUp5km,id.vars = c("Set.Up","EXP"))

SdSetUp27kmMelt <- melt(SdSetUp27km,id.vars = c("Set.Up","EXP"))
SdSetUp25kmMelt <- melt(SdSetUp25km,id.vars = c("Set.Up","EXP"))
SdSetUp9kmMelt <- melt(SdSetUp9km,id.vars = c("Set.Up","EXP"))
SdSetUp5kmMelt <- melt(SdSetUp5km,id.vars = c("Set.Up","EXP"))

SdNormSetUp27kmMelt <- melt(SdNormSetUp27km,id.vars = c("Set.Up","EXP"))
SdNormSetUp25kmMelt <- melt(SdNormSetUp25km,id.vars = c("Set.Up","EXP"))
SdNormSetUp9kmMelt <- melt(SdNormSetUp9km,id.vars = c("Set.Up","EXP"))
SdNormSetUp5kmMelt <- melt(SdNormSetUp5km,id.vars = c("Set.Up","EXP"))


# Merge the data
CorsInput <-rbind(CorsSetUp27kmMelt,CorsSetUp25kmMelt,CorsSetUp5kmMelt, CorsSetUp9kmMelt)
RmseInput <-rbind(RmseSetUp27kmMelt,RmseSetUp25kmMelt,RmseSetUp5kmMelt, RmseSetUp9kmMelt)
RmseNormInput <-rbind(RmseNormSetUp27kmMelt,RmseNormSetUp25kmMelt,RmseNormSetUp5kmMelt, RmseNormSetUp9kmMelt)
SdInput <-rbind(SdSetUp27kmMelt,SdSetUp25kmMelt,SdSetUp5kmMelt, SdSetUp9kmMelt)
SdNormInput <-rbind(SdNormSetUp27kmMelt,SdNormSetUp25kmMelt,SdNormSetUp5kmMelt, SdNormSetUp9kmMelt)

# Change columns' names
colnames(CorsInput) <- c("Set-Up","Exp", "Station","Cor")
colnames(RmseInput) <- c("Set-Up","Exp", "Station","Rmse")
colnames(SdInput) <- c("Set-Up","Exp", "Station","Sd")
colnames(SdNormInput) <- c("Set-Up","Exp", "Station","Sd")
colnames(RmseNormInput) <- c("Set-Up","Exp", "Station","Rmse")

# Change name of the experiments
for (i in 1:length(CorsInput$Exp)) {
  if (CorsInput$Exp[i]=="Marcelo") {CorsInput$Exp[i] <- "South America"
  } else if (CorsInput$Exp[i]=="Martina"){CorsInput$Exp[i] <- "Europe"
  } else if (CorsInput$Exp[i]=="Cum3"){CorsInput$Exp[i] <- "Cumulus3"
  } else if (CorsInput$Exp[i]=="Cum3-1W"){CorsInput$Exp[i] <- "Cumulus3 1-Way"
  } else if (CorsInput$Exp[i]=="NoCum"){CorsInput$Exp[i] <- "No Cumulus"
  }
}
for (i in 1:length(RmseInput$Exp)) {
  if (RmseInput$Exp[i]=="Marcelo") {RmseInput$Exp[i] <- "South America"
  } else if (RmseInput$Exp[i]=="Martina"){RmseInput$Exp[i] <- "Europe"
  } else if (RmseInput$Exp[i]=="Cum3"){RmseInput$Exp[i] <- "Cumulus3"
  } else if (RmseInput$Exp[i]=="Cum3-1W"){RmseInput$Exp[i] <- "Cumulus3 1-Way"
  } else if (RmseInput$Exp[i]=="NoCum"){RmseInput$Exp[i] <- "No Cumulus"
  }
}
for (i in 1:length(SdInput$Exp)) {
  if (SdInput$Exp[i]=="Marcelo") {SdInput$Exp[i] <- "South America"
  } else if (SdInput$Exp[i]=="Martina"){SdInput$Exp[i] <- "Europe"
  } else if (SdInput$Exp[i]=="Cum3"){SdInput$Exp[i] <- "Cumulus3"
  } else if (SdInput$Exp[i]=="Cum3-1W"){SdInput$Exp[i] <- "Cumulus3 1-Way"
  } else if (SdInput$Exp[i]=="Obs"){SdInput$Exp[i] <- "Observations"
  } else if (SdInput$Exp[i]=="NoCum"){SdInput$Exp[i] <- "No Cumulus"
  }
}
for (i in 1:length(RmseNormInput$Exp)) {
  if (RmseNormInput$Exp[i]=="Marcelo") {RmseNormInput$Exp[i] <- "South America"
  } else if (RmseNormInput$Exp[i]=="Martina"){RmseNormInput$Exp[i] <- "Europe"
  } else if (RmseNormInput$Exp[i]=="Cum3"){RmseNormInput$Exp[i] <- "Cumulus3"
  } else if (RmseNormInput$Exp[i]=="Cum3-1W"){RmseNormInput$Exp[i] <- "Cumulus3 1-Way"
  } else if (RmseNormInput$Exp[i]=="NoCum"){RmseNormInput$Exp[i] <- "No Cumulus"
  }
}
for (i in 1:length(SdNormInput$Exp)) {
  if (SdNormInput$Exp[i]=="Marcelo") {SdNormInput$Exp[i] <- "South America"
  } else if (SdNormInput$Exp[i]=="Martina"){SdNormInput$Exp[i] <- "Europe"
  } else if (SdNormInput$Exp[i]=="Cum3"){SdNormInput$Exp[i] <- "Cumulus3"
  } else if (SdNormInput$Exp[i]=="Cum3-1W"){SdNormInput$Exp[i] <- "Cumulus3 1-Way"
  } else if (SdNormInput$Exp[i]=="Obs"){SdNormInput$Exp[i] <- "Observations"
  } else if (SdNormInput$Exp[i]=="NoCum"){SdNormInput$Exp[i] <- "No Cumulus"
  }
}




  # Order the factors
  
  CorsInput$Exp <- ordered(CorsInput$Exp, 
                           levels=c("Europe", "South America", "Cumulus3","Cumulus3 1-Way","No Cumulus", "ERA5", "CHIRPS","IMERG","TRMM"))
  CorsInput$`Set-Up` <- ordered(CorsInput$`Set-Up`, 
                                levels=c("27km_4Doms","25km_3Doms","9km_3Doms","5km_2Doms"))
  
  RmseInput$Exp <- ordered(RmseInput$Exp, 
                           levels=c("Europe", "South America", "Cumulus3","Cumulus3 1-Way","No Cumulus","ERA5", "CHIRPS","IMERG","TRMM"))
  RmseInput$`Set-Up` <- ordered(RmseInput$`Set-Up`, 
                                levels=c("27km_4Doms","25km_3Doms","9km_3Doms","5km_2Doms"))
  
  RmseNormInput$Exp <- ordered(RmseNormInput$Exp, 
                               levels=c("Europe", "South America", "Cumulus3","Cumulus3 1-Way","No Cumulus","ERA5", "CHIRPS","IMERG","TRMM"))
  RmseNormInput$`Set-Up` <- ordered(RmseNormInput$`Set-Up`, 
                                    levels=c("27km_4Doms","25km_3Doms","9km_3Doms","5km_2Doms"))
  
  SdInput$Exp <- ordered(SdInput$Exp, 
                         levels=c("Observations", "Europe", "South America", "Cumulus3", "Cumulus3 1-Way","No Cumulus", "ERA5", "CHIRPS","IMERG","TRMM"))
  SdInput$`Set-Up` <- ordered(SdInput$`Set-Up`, 
                              levels=c("27km_4Doms","25km_3Doms","9km_3Doms","5km_2Doms"))
  
  SdNormInput$Exp <- ordered(SdNormInput$Exp, 
                             levels=c("Observations", "Europe", "South America", "Cumulus3", "Cumulus3 1-Way","No Cumulus", "ERA5", "CHIRPS","IMERG","TRMM"))
  SdNormInput$`Set-Up` <- ordered(SdNormInput$`Set-Up`, 
                                  levels=c("27km_4Doms","25km_3Doms","9km_3Doms","5km_2Doms"))
  
  
  # Print the Cors results
  
  setEPS()
  name=sprintf("Box_Whiskers/BW_Cors_Monthly_LimitedTo0-1.eps")
  postscript(name,height = 5, width = 10)
  
  library(ggplot2)
  ggplot(aes(y = Cor, x = `Set-Up`, fill = Exp), data = CorsInput) +
    scale_fill_manual(values=c("#ffad09","#87d633","#19d5de","#2f93a5","#827dc8","#808b96","#572a5b","#fc9fca","#b92d5b")) +
    ylab("Correlation") + ggtitle("Correlations - Monthly data") + theme_bw() + 
    stat_boxplot(geom ='errorbar') + geom_boxplot() + ylim(0,1) + 
    theme(axis.text.x = element_text(size = 10, angle = 0))
  
  dev.off()
  
  # Print the Rmse results
  setEPS()
  name=sprintf("Box_Whiskers/BW_Rmse_Monthly.eps")
  postscript(name,height = 5, width = 10)
  
  library(ggplot2)
  ggplot(aes(y = Rmse, x = `Set-Up`, fill = Exp), data = RmseInput) +
    scale_fill_manual(values=c("#ffad09","#87d633","#19d5de","#2f93a5","#827dc8","#808b96", "#572a5b","#fc9fca","#b92d5b")) +
    ylab("Rmse (mm)") + ggtitle("Rmse - Monthly data") + theme_bw() + 
    stat_boxplot(geom ='errorbar') + geom_boxplot() + 
    theme(axis.text.x = element_text(size = 10, angle = 0))
  
  dev.off()
  
  
  # Print the Sds results
  setEPS()
  name=sprintf("Box_Whiskers/BW_Sds_Monthly.eps")
  postscript(name,height = 5, width = 10)
  
  library(ggplot2)
  ggplot(aes(y = Sd, x = `Set-Up`, fill = Exp), data = SdInput) +
    scale_fill_manual(values=c("grey","#ffad09","#87d633","#19d5de","#2f93a5","#827dc8","#808b96","#572a5b", "#fc9fca","#b92d5b")) +
    ylab("Standard Deviation") + ggtitle("Standard Deviations - Monthly data") + theme_bw() + 
    stat_boxplot(geom ='errorbar') + geom_boxplot() + 
    theme(axis.text.x = element_text(size = 10, angle = 0))
  
  dev.off()
  
  
  

