#------------------------------------------------------
#
#    October 2020
#    Script associated to publication:
#    "Sensitivity of precipitation and temperature over Mount Kenya area to 
#     physics parameterization options in a high-resolution modelsimulation 
#     performed with WRFV3.8.1"
#    Authors: M. Messmer, S.J. Gonzlez-Roj, C.C. Raible and T.F. Stocker
#
#
#    Creative Commons License: Attribution-NonCommercial 4.0 International (CC BY-NC 4.0)
#------------------------------------------------------

#-----------------------------------------------------
#
#
#   DOMAIN D01
#
#
#-----------------------------------------------------

#-----------------------------------------------------
#
#   SetUp 5-1km - Marcelo
#
#-----------------------------------------------------

#-----------------------------------------------------
#   Leemos los datos 
#-----------------------------------------------------

library(RNetCDF)

post <- open.nc("/Volumes/ELEMENTS/Cosas_Berna/Post/ERA5-Kenya-5-Present-Marcelo-2Doms/RR-D01-ERA5-Kenya-5-Present-Marcelo-2Doms-2008_daily.nc", write=FALSE)

Prec <- var.get.nc(post,'tp')
ntimes=length(Prec[1,1,])

#--------------------------------
#   Cogemos los datos temporales y los pasamos a modo tabla
#--------------------------------

tvals=var.get.nc(post,"time")
iyear=c()
imonth=c()
# This does NOT work unless you have already installed udunits2!!
utinit.nc()
tstring=att.get.nc(post,"time","units")
tdates=utcal.nc(tstring,tvals)

#--------------------------------
#   Read nearest Data
#--------------------------------

nearest<-read.table(file="./nearest_SetUp5km_2Doms_d01.dat",header=T, sep = ";")

rows <- nearest$igridlon
cols <- nearest$igridlat
call <- cbind(rows,cols) 

PrecNearests <- array()
for(i in 1:ntimes){  
  Prectarget=Prec[,,i]
  PrecNearests<-cbind(PrecNearests,Prectarget[call])
}
PrecNearests<-PrecNearests[,-1]

PrecNearests<-t(PrecNearests)

#--------------------------------
#   Creamos la tabla y la guardamos
#--------------------------------

tableWRF=cbind(tdates[,1:3],PrecNearests)
tableWRF=as.data.frame(tableWRF)


names <- sprintf("V%01d", 1:length(nearest$stID));
colnames(tableWRF)<-c("year","month","day",names)

write.table(tableWRF,file="DataTables/ERA5-Kenya-5-Present-Marcelo-2Doms/DataTable_RR_Daily_D01.txt",append=FALSE,quote=FALSE,sep=";",row.names=FALSE,col.names=TRUE)


# Cerrar los ficheros de datos
close.nc(post)



#-----------------------------------------------------
#
#   SetUp 5-1km - Martina
#
#-----------------------------------------------------

#-----------------------------------------------------
#   Leemos los datos 
#-----------------------------------------------------

library(RNetCDF)

post <- open.nc("/Volumes/ELEMENTS/Cosas_Berna/Post/ERA5-Kenya-5-Present-Martina-2Doms/RR-D01-ERA5-Kenya-5-Present-Martina-2Doms-2008_daily.nc", write=FALSE)

Prec <- var.get.nc(post,'tp')
ntimes=length(Prec[1,1,])

#--------------------------------
#   Cogemos los datos temporales y los pasamos a modo tabla
#--------------------------------

tvals=var.get.nc(post,"time")
iyear=c()
imonth=c()
# This does NOT work unless you have already installed udunits2!!
utinit.nc()
tstring=att.get.nc(post,"time","units")
tdates=utcal.nc(tstring,tvals)

#--------------------------------
#   Read nearest Data
#--------------------------------

nearest<-read.table(file="./nearest_SetUp5km_2Doms_d01.dat",header=T, sep = ";")

rows <- nearest$igridlon
cols <- nearest$igridlat
call <- cbind(rows,cols) 

PrecNearests <- array()
for(i in 1:ntimes){  
  Prectarget=Prec[,,i]
  PrecNearests<-cbind(PrecNearests,Prectarget[call])
}
PrecNearests<-PrecNearests[,-1]

PrecNearests<-t(PrecNearests)

#--------------------------------
#   Creamos la tabla y la guardamos
#--------------------------------

tableWRF=cbind(tdates[,1:3],PrecNearests)
tableWRF=as.data.frame(tableWRF)


names <- sprintf("V%01d", 1:length(nearest$stID));
colnames(tableWRF)<-c("year","month","day",names)

write.table(tableWRF,file="DataTables/ERA5-Kenya-5-Present-Martina-2Doms/DataTable_RR_Daily_D01.txt",append=FALSE,quote=FALSE,sep=";",row.names=FALSE,col.names=TRUE)


# Cerrar los ficheros de datos
close.nc(post)



#-----------------------------------------------------
#
#   SetUp 5-1km - Cumulus3
#
#-----------------------------------------------------

#-----------------------------------------------------
#   Leemos los datos 
#-----------------------------------------------------

library(RNetCDF)

post <- open.nc("/Volumes/ELEMENTS/Cosas_Berna/Post/ERA5-Kenya-5-Present-Cumulus3-2Doms/RR-D01-ERA5-Kenya-5-Present-Cumulus3-2Doms-2008_daily.nc", write=FALSE)

Prec <- var.get.nc(post,'tp')
ntimes=length(Prec[1,1,])

#--------------------------------
#   Cogemos los datos temporales y los pasamos a modo tabla
#--------------------------------

tvals=var.get.nc(post,"time")
iyear=c()
imonth=c()
# This does NOT work unless you have already installed udunits2!!
utinit.nc()
tstring=att.get.nc(post,"time","units")
tdates=utcal.nc(tstring,tvals)

#--------------------------------
#   Read nearest Data
#--------------------------------

nearest<-read.table(file="./nearest_SetUp5km_2Doms_d01.dat",header=T, sep = ";")

rows <- nearest$igridlon
cols <- nearest$igridlat
call <- cbind(rows,cols) 

PrecNearests <- array()
for(i in 1:ntimes){  
  Prectarget=Prec[,,i]
  PrecNearests<-cbind(PrecNearests,Prectarget[call])
}
PrecNearests<-PrecNearests[,-1]

PrecNearests<-t(PrecNearests)

#--------------------------------
#   Creamos la tabla y la guardamos
#--------------------------------

tableWRF=cbind(tdates[,1:3],PrecNearests)
tableWRF=as.data.frame(tableWRF)


names <- sprintf("V%01d", 1:length(nearest$stID));
colnames(tableWRF)<-c("year","month","day",names)

write.table(tableWRF,file="DataTables/ERA5-Kenya-5-Present-Cumulus3-2Doms/DataTable_RR_Daily_D01.txt",append=FALSE,quote=FALSE,sep=";",row.names=FALSE,col.names=TRUE)


# Cerrar los ficheros de datos
close.nc(post)



#-----------------------------------------------------
#
#   SetUp 5-1km - Cumulus3 1Way
#
#-----------------------------------------------------

#-----------------------------------------------------
#   Leemos los datos 
#-----------------------------------------------------

library(RNetCDF)

post <- open.nc("/Volumes/ELEMENTS/Cosas_Berna/Post/ERA5-Kenya-5-Present-Cumulus3-1Way-2Doms/RR-D01-ERA5-Kenya-5-Present-Cumulus3-1Way-2Doms-2008_daily.nc", write=FALSE)

Prec <- var.get.nc(post,'tp')
ntimes=length(Prec[1,1,])

#--------------------------------
#   Cogemos los datos temporales y los pasamos a modo tabla
#--------------------------------

tvals=var.get.nc(post,"time")
iyear=c()
imonth=c()
# This does NOT work unless you have already installed udunits2!!
utinit.nc()
tstring=att.get.nc(post,"time","units")
tdates=utcal.nc(tstring,tvals)

#--------------------------------
#   Read nearest Data
#--------------------------------

nearest<-read.table(file="./nearest_SetUp5km_2Doms_d01.dat",header=T, sep = ";")

rows <- nearest$igridlon
cols <- nearest$igridlat
call <- cbind(rows,cols) 

PrecNearests <- array()
for(i in 1:ntimes){  
  Prectarget=Prec[,,i]
  PrecNearests<-cbind(PrecNearests,Prectarget[call])
}
PrecNearests<-PrecNearests[,-1]

PrecNearests<-t(PrecNearests)

#--------------------------------
#   Creamos la tabla y la guardamos
#--------------------------------

tableWRF=cbind(tdates[,1:3],PrecNearests)
tableWRF=as.data.frame(tableWRF)


names <- sprintf("V%01d", 1:length(nearest$stID));
colnames(tableWRF)<-c("year","month","day",names)

write.table(tableWRF,file="DataTables/ERA5-Kenya-5-Present-Cumulus3-1Way-2Doms/DataTable_RR_Daily_D01.txt",append=FALSE,quote=FALSE,sep=";",row.names=FALSE,col.names=TRUE)


# Cerrar los ficheros de datos
close.nc(post)


#-----------------------------------------------------
#
#   SetUp 5-1km - ERA5
#
#-----------------------------------------------------

#-----------------------------------------------------
#   Leemos los datos 
#-----------------------------------------------------

library(RNetCDF)

post <- open.nc("/Volumes/ELEMENTS/Cosas_Berna/Post/ERA5-Kenya-5-Present-ERA5-2Doms/ERA5_RR-2008_daysum_D01.nc", write=FALSE)

Prec <- var.get.nc(post,'var1')
ntimes=length(Prec[1,1,])

#--------------------------------
#   Cogemos los datos temporales y los pasamos a modo tabla
#--------------------------------

tvals=var.get.nc(post,"time")
iyear=c()
imonth=c()
# This does NOT work unless you have already installed udunits2!!
utinit.nc()
tstring=att.get.nc(post,"time","units")
tdates=utcal.nc(tstring,tvals)

#--------------------------------
#   Read nearest Data
#--------------------------------

nearest<-read.table(file="./nearest_SetUp5km_2Doms_d01.dat",header=T, sep = ";")

rows <- nearest$igridlon
cols <- nearest$igridlat
call <- cbind(rows,cols) 

PrecNearests <- array()
for(i in 1:ntimes){  
  Prectarget=Prec[,,i]
  PrecNearests<-cbind(PrecNearests,Prectarget[call])
}
PrecNearests<-PrecNearests[,-1]

PrecNearests<-t(PrecNearests)

#--------------------------------
#   Creamos la tabla y la guardamos
#--------------------------------

tableWRF=cbind(tdates[,1:3],PrecNearests)
tableWRF=as.data.frame(tableWRF)


names <- sprintf("V%01d", 1:length(nearest$stID));
colnames(tableWRF)<-c("year","month","day",names)

write.table(tableWRF,file="DataTables/ERA5-Kenya-5-Present-ERA5-2Doms/DataTable_RR_Daily_D01.txt",append=FALSE,quote=FALSE,sep=";",row.names=FALSE,col.names=TRUE)


# Cerrar los ficheros de datos
close.nc(post)




#-----------------------------------------------------
#
#   SetUp 5-1km - IMERG
#
#-----------------------------------------------------

#-----------------------------------------------------
#   Leemos los datos 
#-----------------------------------------------------

library(RNetCDF)

post <- open.nc("/Volumes/ELEMENTS/Cosas_Berna/Post/ERA5-Kenya-5-Present-IMERG-2Doms/IMERG_RR-2008_daysum_D01.nc", write=FALSE)

Prec <- var.get.nc(post,'Band1')
ntimes=length(Prec[1,1,])

#--------------------------------
#   Cogemos los datos temporales y los pasamos a modo tabla
#--------------------------------

tvals=var.get.nc(post,"time")
iyear=c()
imonth=c()
# This does NOT work unless you have already installed udunits2!!
utinit.nc()
tstring=att.get.nc(post,"time","units")
tdates=utcal.nc(tstring,tvals)

#--------------------------------
#   Read nearest Data
#--------------------------------

nearest<-read.table(file="./nearest_SetUp5km_2Doms_d01.dat",header=T, sep = ";")

rows <- nearest$igridlon
cols <- nearest$igridlat
call <- cbind(rows,cols) 

PrecNearests <- array()
for(i in 1:ntimes){  
  Prectarget=Prec[,,i]
  # If we want to obtain mm/day
  Prectarget = Prectarget * 24 * 0.1  
  PrecNearests<-cbind(PrecNearests,Prectarget[call])
}
PrecNearests<-PrecNearests[,-1]

PrecNearests<-t(PrecNearests)

#--------------------------------
#   Creamos la tabla y la guardamos
#--------------------------------

tableWRF=cbind(tdates[,1:3],PrecNearests)
tableWRF=as.data.frame(tableWRF)


names <- sprintf("V%01d", 1:length(nearest$stID));
colnames(tableWRF)<-c("year","month","day",names)

write.table(tableWRF,file="DataTables/ERA5-Kenya-5-Present-IMERG-2Doms/DataTable_RR_Daily_D01.txt",append=FALSE,quote=FALSE,sep=";",row.names=FALSE,col.names=TRUE)


# Cerrar los ficheros de datos
close.nc(post)


#-----------------------------------------------------
#
#   SetUp 5-1km - IMERG - New
#
#-----------------------------------------------------

#-----------------------------------------------------
#   Leemos los datos 
#-----------------------------------------------------

library(RNetCDF)

post <- open.nc("/Volumes/ELEMENTS/Cosas_Berna/Post/ERA5-Kenya-5-Present-IMERG-2Doms-New/IMERG_RR-2008_daysum_D01.nc", write=FALSE)

Prec <- var.get.nc(post,'PR')
ntimes=length(Prec[1,1,])

#--------------------------------
#   Cogemos los datos temporales y los pasamos a modo tabla
#--------------------------------

tvals=var.get.nc(post,"time")
iyear=c()
imonth=c()
# This does NOT work unless you have already installed udunits2!!
utinit.nc()
tstring=att.get.nc(post,"time","units")
tdates=utcal.nc(tstring,tvals)

#--------------------------------
#   Read nearest Data
#--------------------------------

nearest<-read.table(file="./nearest_SetUp5km_2Doms_d01.dat",header=T, sep = ";")

rows <- nearest$igridlon
cols <- nearest$igridlat
call <- cbind(rows,cols) 

PrecNearests <- array()
for(i in 1:ntimes){  
  Prectarget=Prec[,,i]
  PrecNearests<-cbind(PrecNearests,Prectarget[call])
}
PrecNearests<-PrecNearests[,-1]

PrecNearests<-t(PrecNearests)

#--------------------------------
#   Creamos la tabla y la guardamos
#--------------------------------

tableWRF=cbind(tdates[,1:3],PrecNearests)
tableWRF=as.data.frame(tableWRF)


names <- sprintf("V%01d", 1:length(nearest$stID));
colnames(tableWRF)<-c("year","month","day",names)

write.table(tableWRF,file="DataTables/ERA5-Kenya-5-Present-IMERG-2Doms-New/DataTable_RR_Daily_D01.txt",append=FALSE,quote=FALSE,sep=";",row.names=FALSE,col.names=TRUE)


# Cerrar los ficheros de datos
close.nc(post)



#-----------------------------------------------------
#
#   SetUp 5-1km - TRMM
#
#-----------------------------------------------------

#-----------------------------------------------------
#   Leemos los datos 
#-----------------------------------------------------

library(RNetCDF)

post <- open.nc("/Volumes/ELEMENTS/Cosas_Berna/Post/ERA5-Kenya-5-Present-TRMM-2Doms/TRMM_RR-2008_daysum_D01.nc", write=FALSE)

Prec <- var.get.nc(post,'pcp')
ntimes=length(Prec[1,1,])

#--------------------------------
#   Cogemos los datos temporales y los pasamos a modo tabla
#--------------------------------

tvals=var.get.nc(post,"time")
iyear=c()
imonth=c()
# This does NOT work unless you have already installed udunits2!!
utinit.nc()
tstring=att.get.nc(post,"time","units")
tdates=utcal.nc(tstring,tvals)

#--------------------------------
#   Read nearest Data
#--------------------------------

nearest<-read.table(file="./nearest_SetUp5km_2Doms_d01.dat",header=T, sep = ";")

rows <- nearest$igridlon
cols <- nearest$igridlat
call <- cbind(rows,cols) 

PrecNearests <- array()
for(i in 1:ntimes){  
  Prectarget=Prec[,,i]
  PrecNearests<-cbind(PrecNearests,Prectarget[call])
}
PrecNearests<-PrecNearests[,-1]

PrecNearests<-t(PrecNearests)

#--------------------------------
#   Creamos la tabla y la guardamos
#--------------------------------

tableWRF=cbind(tdates[,1:3],PrecNearests)
tableWRF=as.data.frame(tableWRF)


names <- sprintf("V%01d", 1:length(nearest$stID));
colnames(tableWRF)<-c("year","month","day",names)

write.table(tableWRF,file="DataTables/ERA5-Kenya-5-Present-TRMM-2Doms/DataTable_RR_Daily_D01.txt",append=FALSE,quote=FALSE,sep=";",row.names=FALSE,col.names=TRUE)


# Cerrar los ficheros de datos
close.nc(post)


#-----------------------------------------------------
#
#   SetUp 5-1km - TRMM - New
#
#-----------------------------------------------------

#-----------------------------------------------------
#   Leemos los datos 
#-----------------------------------------------------

library(RNetCDF)

post <- open.nc("/Volumes/ELEMENTS/Cosas_Berna/Post/ERA5-Kenya-5-Present-TRMM-2Doms-New/TRMM_RR-2008_daysum_D01.nc", write=FALSE)

Prec <- var.get.nc(post,'PR')
ntimes=length(Prec[1,1,])

#--------------------------------
#   Cogemos los datos temporales y los pasamos a modo tabla
#--------------------------------

tvals=var.get.nc(post,"time")
iyear=c()
imonth=c()
# This does NOT work unless you have already installed udunits2!!
utinit.nc()
tstring=att.get.nc(post,"time","units")
tdates=utcal.nc(tstring,tvals)

#--------------------------------
#   Read nearest Data
#--------------------------------

nearest<-read.table(file="./nearest_SetUp5km_2Doms_d01.dat",header=T, sep = ";")

rows <- nearest$igridlon
cols <- nearest$igridlat
call <- cbind(rows,cols) 

PrecNearests <- array()
for(i in 1:ntimes){  
  Prectarget=Prec[,,i]
  PrecNearests<-cbind(PrecNearests,Prectarget[call])
}
PrecNearests<-PrecNearests[,-1]

PrecNearests<-t(PrecNearests)

#--------------------------------
#   Creamos la tabla y la guardamos
#--------------------------------

tableWRF=cbind(tdates[,1:3],PrecNearests)
tableWRF=as.data.frame(tableWRF)


names <- sprintf("V%01d", 1:length(nearest$stID));
colnames(tableWRF)<-c("year","month","day",names)

write.table(tableWRF,file="DataTables/ERA5-Kenya-5-Present-TRMM-2Doms-New/DataTable_RR_Daily_D01.txt",append=FALSE,quote=FALSE,sep=";",row.names=FALSE,col.names=TRUE)


# Cerrar los ficheros de datos
close.nc(post)


#-----------------------------------------------------
#
#   SetUp 5-1km - CHIRPS
#
#-----------------------------------------------------

#-----------------------------------------------------
#   Leemos los datos 
#-----------------------------------------------------

library(RNetCDF)

post <- open.nc("/Volumes/ELEMENTS/Cosas_Berna/Post/ERA5-Kenya-5-Present-CHIRPS-2Doms/CHIRPS_RR-2008_daysum_D01.nc", write=FALSE)

Prec <- var.get.nc(post,'precip')
ntimes=length(Prec[1,1,])

#--------------------------------
#   Cogemos los datos temporales y los pasamos a modo tabla
#--------------------------------

tvals=var.get.nc(post,"time")
iyear=c()
imonth=c()
# This does NOT work unless you have already installed udunits2!!
utinit.nc()
tstring=att.get.nc(post,"time","units")
tdates=utcal.nc(tstring,tvals)

#--------------------------------
#   Read nearest Data
#--------------------------------

nearest<-read.table(file="./nearest_SetUp5km_2Doms_d01.dat",header=T, sep = ";")

rows <- nearest$igridlon
cols <- nearest$igridlat
call <- cbind(rows,cols) 

PrecNearests <- array()
for(i in 1:ntimes){  
  Prectarget=Prec[,,i]
  PrecNearests<-cbind(PrecNearests,Prectarget[call])
}
PrecNearests<-PrecNearests[,-1]

PrecNearests<-t(PrecNearests)

#--------------------------------
#   Creamos la tabla y la guardamos
#--------------------------------

tableWRF=cbind(tdates[,1:3],PrecNearests)
tableWRF=as.data.frame(tableWRF)


names <- sprintf("V%01d", 1:length(nearest$stID));
colnames(tableWRF)<-c("year","month","day",names)

write.table(tableWRF,file="DataTables/ERA5-Kenya-5-Present-CHIRPS-2Doms/DataTable_RR_Daily_D01.txt",append=FALSE,quote=FALSE,sep=";",row.names=FALSE,col.names=TRUE)


# Cerrar los ficheros de datos
close.nc(post)





#-----------------------------------------------------
#
#
#   DOMAIN D02
#
#
#-----------------------------------------------------

#-----------------------------------------------------
#
#   SetUp 5-1km - Marcelo
#
#-----------------------------------------------------

#-----------------------------------------------------
#   Leemos los datos 
#-----------------------------------------------------

library(RNetCDF)

post <- open.nc("/Volumes/ELEMENTS/Cosas_Berna/Post/ERA5-Kenya-5-Present-Marcelo-2Doms/RR-D02-ERA5-Kenya-5-Present-Marcelo-2Doms-2008_daily.nc", write=FALSE)

Prec <- var.get.nc(post,'tp')
ntimes=length(Prec[1,1,])

#--------------------------------
#   Cogemos los datos temporales y los pasamos a modo tabla
#--------------------------------

tvals=var.get.nc(post,"time")
iyear=c()
imonth=c()
# This does NOT work unless you have already installed udunits2!!
utinit.nc()
tstring=att.get.nc(post,"time","units")
tdates=utcal.nc(tstring,tvals)

#--------------------------------
#   Read nearest Data
#--------------------------------

nearest<-read.table(file="./nearest_SetUp5km_2Doms_d02.dat",header=T, sep = ";")

rows <- nearest$igridlon
cols <- nearest$igridlat
call <- cbind(rows,cols) 

PrecNearests <- array()
for(i in 1:ntimes){  
  Prectarget=Prec[,,i]
  PrecNearests<-cbind(PrecNearests,Prectarget[call])
}
PrecNearests<-PrecNearests[,-1]

PrecNearests<-t(PrecNearests)

#--------------------------------
#   Creamos la tabla y la guardamos
#--------------------------------

tableWRF=cbind(tdates[,1:3],PrecNearests)
tableWRF=as.data.frame(tableWRF)


names <- sprintf("V%01d", 1:length(nearest$stID));
colnames(tableWRF)<-c("year","month","day",names)

write.table(tableWRF,file="DataTables/ERA5-Kenya-5-Present-Marcelo-2Doms/DataTable_RR_Daily_D02.txt",append=FALSE,quote=FALSE,sep=";",row.names=FALSE,col.names=TRUE)


# Cerrar los ficheros de datos
close.nc(post)



#-----------------------------------------------------
#
#   SetUp 5-1km - Martina
#
#-----------------------------------------------------

#-----------------------------------------------------
#   Leemos los datos 
#-----------------------------------------------------

library(RNetCDF)

post <- open.nc("/Volumes/ELEMENTS/Cosas_Berna/Post/ERA5-Kenya-5-Present-Martina-2Doms/RR-D02-ERA5-Kenya-5-Present-Martina-2Doms-2008_daily.nc", write=FALSE)

Prec <- var.get.nc(post,'tp')
ntimes=length(Prec[1,1,])

#--------------------------------
#   Cogemos los datos temporales y los pasamos a modo tabla
#--------------------------------

tvals=var.get.nc(post,"time")
iyear=c()
imonth=c()
# This does NOT work unless you have already installed udunits2!!
utinit.nc()
tstring=att.get.nc(post,"time","units")
tdates=utcal.nc(tstring,tvals)

#--------------------------------
#   Read nearest Data
#--------------------------------

nearest<-read.table(file="./nearest_SetUp5km_2Doms_d02.dat",header=T, sep = ";")

rows <- nearest$igridlon
cols <- nearest$igridlat
call <- cbind(rows,cols) 

PrecNearests <- array()
for(i in 1:ntimes){  
  Prectarget=Prec[,,i]
  PrecNearests<-cbind(PrecNearests,Prectarget[call])
}
PrecNearests<-PrecNearests[,-1]

PrecNearests<-t(PrecNearests)

#--------------------------------
#   Creamos la tabla y la guardamos
#--------------------------------

tableWRF=cbind(tdates[,1:3],PrecNearests)
tableWRF=as.data.frame(tableWRF)


names <- sprintf("V%01d", 1:length(nearest$stID));
colnames(tableWRF)<-c("year","month","day",names)

write.table(tableWRF,file="DataTables/ERA5-Kenya-5-Present-Martina-2Doms/DataTable_RR_Daily_D02.txt",append=FALSE,quote=FALSE,sep=";",row.names=FALSE,col.names=TRUE)


# Cerrar los ficheros de datos
close.nc(post)



#-----------------------------------------------------
#
#   SetUp 5-1km - Cumulus3
#
#-----------------------------------------------------

#-----------------------------------------------------
#   Leemos los datos 
#-----------------------------------------------------

library(RNetCDF)

post <- open.nc("/Volumes/ELEMENTS/Cosas_Berna/Post/ERA5-Kenya-5-Present-Cumulus3-2Doms/RR-D02-ERA5-Kenya-5-Present-Cumulus3-2Doms-2008_daily.nc", write=FALSE)

Prec <- var.get.nc(post,'tp')
ntimes=length(Prec[1,1,])

#--------------------------------
#   Cogemos los datos temporales y los pasamos a modo tabla
#--------------------------------

tvals=var.get.nc(post,"time")
iyear=c()
imonth=c()
# This does NOT work unless you have already installed udunits2!!
utinit.nc()
tstring=att.get.nc(post,"time","units")
tdates=utcal.nc(tstring,tvals)

#--------------------------------
#   Read nearest Data
#--------------------------------

nearest<-read.table(file="./nearest_SetUp5km_2Doms_d02.dat",header=T, sep = ";")

rows <- nearest$igridlon
cols <- nearest$igridlat
call <- cbind(rows,cols) 

PrecNearests <- array()
for(i in 1:ntimes){  
  Prectarget=Prec[,,i]
  PrecNearests<-cbind(PrecNearests,Prectarget[call])
}
PrecNearests<-PrecNearests[,-1]

PrecNearests<-t(PrecNearests)

#--------------------------------
#   Creamos la tabla y la guardamos
#--------------------------------

tableWRF=cbind(tdates[,1:3],PrecNearests)
tableWRF=as.data.frame(tableWRF)


names <- sprintf("V%01d", 1:length(nearest$stID));
colnames(tableWRF)<-c("year","month","day",names)

write.table(tableWRF,file="DataTables/ERA5-Kenya-5-Present-Cumulus3-2Doms/DataTable_RR_Daily_D02.txt",append=FALSE,quote=FALSE,sep=";",row.names=FALSE,col.names=TRUE)


# Cerrar los ficheros de datos
close.nc(post)



#-----------------------------------------------------
#
#   SetUp 5-1km - Cumulus3 1Way
#
#-----------------------------------------------------

#-----------------------------------------------------
#   Leemos los datos 
#-----------------------------------------------------

library(RNetCDF)

post <- open.nc("/Volumes/ELEMENTS/Cosas_Berna/Post/ERA5-Kenya-5-Present-Cumulus3-1Way-2Doms/RR-D02-ERA5-Kenya-5-Present-Cumulus3-1Way-2Doms-2008_daily.nc", write=FALSE)

Prec <- var.get.nc(post,'tp')
ntimes=length(Prec[1,1,])

#--------------------------------
#   Cogemos los datos temporales y los pasamos a modo tabla
#--------------------------------

tvals=var.get.nc(post,"time")
iyear=c()
imonth=c()
# This does NOT work unless you have already installed udunits2!!
utinit.nc()
tstring=att.get.nc(post,"time","units")
tdates=utcal.nc(tstring,tvals)

#--------------------------------
#   Read nearest Data
#--------------------------------

nearest<-read.table(file="./nearest_SetUp5km_2Doms_d02.dat",header=T, sep = ";")

rows <- nearest$igridlon
cols <- nearest$igridlat
call <- cbind(rows,cols) 

PrecNearests <- array()
for(i in 1:ntimes){  
  Prectarget=Prec[,,i]
  PrecNearests<-cbind(PrecNearests,Prectarget[call])
}
PrecNearests<-PrecNearests[,-1]

PrecNearests<-t(PrecNearests)

#--------------------------------
#   Creamos la tabla y la guardamos
#--------------------------------

tableWRF=cbind(tdates[,1:3],PrecNearests)
tableWRF=as.data.frame(tableWRF)


names <- sprintf("V%01d", 1:length(nearest$stID));
colnames(tableWRF)<-c("year","month","day",names)

write.table(tableWRF,file="DataTables/ERA5-Kenya-5-Present-Cumulus3-1Way-2Doms/DataTable_RR_Daily_D02.txt",append=FALSE,quote=FALSE,sep=";",row.names=FALSE,col.names=TRUE)


# Cerrar los ficheros de datos
close.nc(post)


#-----------------------------------------------------
#
#   SetUp 5-1km - ERA5
#
#-----------------------------------------------------

#-----------------------------------------------------
#   Leemos los datos 
#-----------------------------------------------------

library(RNetCDF)

post <- open.nc("/Volumes/ELEMENTS/Cosas_Berna/Post/ERA5-Kenya-5-Present-ERA5-2Doms/ERA5_RR-2008_daysum_D02.nc", write=FALSE)

Prec <- var.get.nc(post,'var1')
ntimes=length(Prec[1,1,])

#--------------------------------
#   Cogemos los datos temporales y los pasamos a modo tabla
#--------------------------------

tvals=var.get.nc(post,"time")
iyear=c()
imonth=c()
# This does NOT work unless you have already installed udunits2!!
utinit.nc()
tstring=att.get.nc(post,"time","units")
tdates=utcal.nc(tstring,tvals)

#--------------------------------
#   Read nearest Data
#--------------------------------

nearest<-read.table(file="./nearest_SetUp5km_2Doms_d02.dat",header=T, sep = ";")

rows <- nearest$igridlon
cols <- nearest$igridlat
call <- cbind(rows,cols) 

PrecNearests <- array()
for(i in 1:ntimes){  
  Prectarget=Prec[,,i]
  PrecNearests<-cbind(PrecNearests,Prectarget[call])
}
PrecNearests<-PrecNearests[,-1]

PrecNearests<-t(PrecNearests)

#--------------------------------
#   Creamos la tabla y la guardamos
#--------------------------------

tableWRF=cbind(tdates[,1:3],PrecNearests)
tableWRF=as.data.frame(tableWRF)


names <- sprintf("V%01d", 1:length(nearest$stID));
colnames(tableWRF)<-c("year","month","day",names)

write.table(tableWRF,file="DataTables/ERA5-Kenya-5-Present-ERA5-2Doms/DataTable_RR_Daily_D02.txt",append=FALSE,quote=FALSE,sep=";",row.names=FALSE,col.names=TRUE)


# Cerrar los ficheros de datos
close.nc(post)



#-----------------------------------------------------
#
#   SetUp 5-1km - IMERG
#
#-----------------------------------------------------

#-----------------------------------------------------
#   Leemos los datos 
#-----------------------------------------------------

library(RNetCDF)

post <- open.nc("/Volumes/ELEMENTS/Cosas_Berna/Post/ERA5-Kenya-5-Present-IMERG-2Doms/IMERG_RR-2008_daysum_D02.nc", write=FALSE)

Prec <- var.get.nc(post,'Band1')
ntimes=length(Prec[1,1,])

#--------------------------------
#   Cogemos los datos temporales y los pasamos a modo tabla
#--------------------------------

tvals=var.get.nc(post,"time")
iyear=c()
imonth=c()
# This does NOT work unless you have already installed udunits2!!
utinit.nc()
tstring=att.get.nc(post,"time","units")
tdates=utcal.nc(tstring,tvals)

#--------------------------------
#   Read nearest Data
#--------------------------------

nearest<-read.table(file="./nearest_SetUp5km_2Doms_d02.dat",header=T, sep = ";")

rows <- nearest$igridlon
cols <- nearest$igridlat
call <- cbind(rows,cols) 

PrecNearests <- array()
for(i in 1:ntimes){  
  Prectarget=Prec[,,i]
  # If we want to obtain mm/day
  Prectarget = Prectarget * 24 * 0.1  
  PrecNearests<-cbind(PrecNearests,Prectarget[call])
}
PrecNearests<-PrecNearests[,-1]

PrecNearests<-t(PrecNearests)

#--------------------------------
#   Creamos la tabla y la guardamos
#--------------------------------

tableWRF=cbind(tdates[,1:3],PrecNearests)
tableWRF=as.data.frame(tableWRF)


names <- sprintf("V%01d", 1:length(nearest$stID));
colnames(tableWRF)<-c("year","month","day",names)

write.table(tableWRF,file="DataTables/ERA5-Kenya-5-Present-IMERG-2Doms/DataTable_RR_Daily_D02.txt",append=FALSE,quote=FALSE,sep=";",row.names=FALSE,col.names=TRUE)


# Cerrar los ficheros de datos
close.nc(post)


#-----------------------------------------------------
#
#   SetUp 5-1km - IMERG  - New
#
#-----------------------------------------------------

#-----------------------------------------------------
#   Leemos los datos 
#-----------------------------------------------------

library(RNetCDF)

post <- open.nc("/Volumes/ELEMENTS/Cosas_Berna/Post/ERA5-Kenya-5-Present-IMERG-2Doms-New/IMERG_RR-2008_daysum_D02.nc", write=FALSE)

Prec <- var.get.nc(post,'PR')
ntimes=length(Prec[1,1,])

#--------------------------------
#   Cogemos los datos temporales y los pasamos a modo tabla
#--------------------------------

tvals=var.get.nc(post,"time")
iyear=c()
imonth=c()
# This does NOT work unless you have already installed udunits2!!
utinit.nc()
tstring=att.get.nc(post,"time","units")
tdates=utcal.nc(tstring,tvals)

#--------------------------------
#   Read nearest Data
#--------------------------------

nearest<-read.table(file="./nearest_SetUp5km_2Doms_d02.dat",header=T, sep = ";")

rows <- nearest$igridlon
cols <- nearest$igridlat
call <- cbind(rows,cols) 

PrecNearests <- array()
for(i in 1:ntimes){  
  Prectarget=Prec[,,i]
  PrecNearests<-cbind(PrecNearests,Prectarget[call])
}
PrecNearests<-PrecNearests[,-1]

PrecNearests<-t(PrecNearests)

#--------------------------------
#   Creamos la tabla y la guardamos
#--------------------------------

tableWRF=cbind(tdates[,1:3],PrecNearests)
tableWRF=as.data.frame(tableWRF)


names <- sprintf("V%01d", 1:length(nearest$stID));
colnames(tableWRF)<-c("year","month","day",names)

write.table(tableWRF,file="DataTables/ERA5-Kenya-5-Present-IMERG-2Doms-New/DataTable_RR_Daily_D02.txt",append=FALSE,quote=FALSE,sep=";",row.names=FALSE,col.names=TRUE)


# Cerrar los ficheros de datos
close.nc(post)


#-----------------------------------------------------
#
#   SetUp 5-1km - TRMM
#
#-----------------------------------------------------

#-----------------------------------------------------
#   Leemos los datos 
#-----------------------------------------------------

library(RNetCDF)

post <- open.nc("/Volumes/ELEMENTS/Cosas_Berna/Post/ERA5-Kenya-5-Present-TRMM-2Doms/TRMM_RR-2008_daysum_D02.nc", write=FALSE)

Prec <- var.get.nc(post,'pcp')
ntimes=length(Prec[1,1,])

#--------------------------------
#   Cogemos los datos temporales y los pasamos a modo tabla
#--------------------------------

tvals=var.get.nc(post,"time")
iyear=c()
imonth=c()
# This does NOT work unless you have already installed udunits2!!
utinit.nc()
tstring=att.get.nc(post,"time","units")
tdates=utcal.nc(tstring,tvals)

#--------------------------------
#   Read nearest Data
#--------------------------------

nearest<-read.table(file="./nearest_SetUp5km_2Doms_d02.dat",header=T, sep = ";")

rows <- nearest$igridlon
cols <- nearest$igridlat
call <- cbind(rows,cols) 

PrecNearests <- array()
for(i in 1:ntimes){  
  Prectarget=Prec[,,i]
  PrecNearests<-cbind(PrecNearests,Prectarget[call])
}
PrecNearests<-PrecNearests[,-1]

PrecNearests<-t(PrecNearests)

#--------------------------------
#   Creamos la tabla y la guardamos
#--------------------------------

tableWRF=cbind(tdates[,1:3],PrecNearests)
tableWRF=as.data.frame(tableWRF)


names <- sprintf("V%01d", 1:length(nearest$stID));
colnames(tableWRF)<-c("year","month","day",names)

write.table(tableWRF,file="DataTables/ERA5-Kenya-5-Present-TRMM-2Doms/DataTable_RR_Daily_D02.txt",append=FALSE,quote=FALSE,sep=";",row.names=FALSE,col.names=TRUE)


# Cerrar los ficheros de datos
close.nc(post)



#-----------------------------------------------------
#
#   SetUp 5-1km - TRMM  - New
#
#-----------------------------------------------------

#-----------------------------------------------------
#   Leemos los datos 
#-----------------------------------------------------

library(RNetCDF)

post <- open.nc("/Volumes/ELEMENTS/Cosas_Berna/Post/ERA5-Kenya-5-Present-TRMM-2Doms-New/TRMM_RR-2008_daysum_D02.nc", write=FALSE)

Prec <- var.get.nc(post,'PR')
ntimes=length(Prec[1,1,])

#--------------------------------
#   Cogemos los datos temporales y los pasamos a modo tabla
#--------------------------------

tvals=var.get.nc(post,"time")
iyear=c()
imonth=c()
# This does NOT work unless you have already installed udunits2!!
utinit.nc()
tstring=att.get.nc(post,"time","units")
tdates=utcal.nc(tstring,tvals)

#--------------------------------
#   Read nearest Data
#--------------------------------

nearest<-read.table(file="./nearest_SetUp5km_2Doms_d02.dat",header=T, sep = ";")

rows <- nearest$igridlon
cols <- nearest$igridlat
call <- cbind(rows,cols) 

PrecNearests <- array()
for(i in 1:ntimes){  
  Prectarget=Prec[,,i]
  PrecNearests<-cbind(PrecNearests,Prectarget[call])
}
PrecNearests<-PrecNearests[,-1]

PrecNearests<-t(PrecNearests)

#--------------------------------
#   Creamos la tabla y la guardamos
#--------------------------------

tableWRF=cbind(tdates[,1:3],PrecNearests)
tableWRF=as.data.frame(tableWRF)


names <- sprintf("V%01d", 1:length(nearest$stID));
colnames(tableWRF)<-c("year","month","day",names)

write.table(tableWRF,file="DataTables/ERA5-Kenya-5-Present-TRMM-2Doms-New/DataTable_RR_Daily_D02.txt",append=FALSE,quote=FALSE,sep=";",row.names=FALSE,col.names=TRUE)


# Cerrar los ficheros de datos
close.nc(post)


#-----------------------------------------------------
#
#   SetUp 5-1km - CHIRPS
#
#-----------------------------------------------------

#-----------------------------------------------------
#   Leemos los datos 
#-----------------------------------------------------

library(RNetCDF)

post <- open.nc("/Volumes/ELEMENTS/Cosas_Berna/Post/ERA5-Kenya-5-Present-CHIRPS-2Doms/CHIRPS_RR-2008_daysum_D02.nc", write=FALSE)

Prec <- var.get.nc(post,'precip')
ntimes=length(Prec[1,1,])

#--------------------------------
#   Cogemos los datos temporales y los pasamos a modo tabla
#--------------------------------

tvals=var.get.nc(post,"time")
iyear=c()
imonth=c()
# This does NOT work unless you have already installed udunits2!!
utinit.nc()
tstring=att.get.nc(post,"time","units")
tdates=utcal.nc(tstring,tvals)

#--------------------------------
#   Read nearest Data
#--------------------------------

nearest<-read.table(file="./nearest_SetUp5km_2Doms_d02.dat",header=T, sep = ";")

rows <- nearest$igridlon
cols <- nearest$igridlat
call <- cbind(rows,cols) 

PrecNearests <- array()
for(i in 1:ntimes){  
  Prectarget=Prec[,,i]
  PrecNearests<-cbind(PrecNearests,Prectarget[call])
}
PrecNearests<-PrecNearests[,-1]

PrecNearests<-t(PrecNearests)

#--------------------------------
#   Creamos la tabla y la guardamos
#--------------------------------

tableWRF=cbind(tdates[,1:3],PrecNearests)
tableWRF=as.data.frame(tableWRF)


names <- sprintf("V%01d", 1:length(nearest$stID));
colnames(tableWRF)<-c("year","month","day",names)

write.table(tableWRF,file="DataTables/ERA5-Kenya-5-Present-CHIRPS-2Doms/DataTable_RR_Daily_D02.txt",append=FALSE,quote=FALSE,sep=";",row.names=FALSE,col.names=TRUE)


# Cerrar los ficheros de datos
close.nc(post)