#------------------------------------------------------
#
#    October 2020
#    Script associated to publication:
#    "Sensitivity of precipitation and temperature over Mount Kenya area to 
#     physics parameterization options in a high-resolution modelsimulation 
#     performed with WRFV3.8.1"
#    Authors: M. Messmer, S.J. Gonzlez-Roj, C.C. Raible and T.F. Stocker
#
#
#    Creative Commons License: Attribution-NonCommercial 4.0 International (CC BY-NC 4.0)
#------------------------------------------------------

#-----------------------------------------------------
#
#
#   DOMAIN D02
#
#
#-----------------------------------------------------

#-----------------------------------------------------
#
#   SetUp 25-5-1km - Marcelo
#
#-----------------------------------------------------

#-----------------------------------------------------
#   Leemos los datos 
#-----------------------------------------------------

library(RNetCDF)

post <- open.nc("/Volumes/ELEMENTS/Cosas_Berna/Post/ERA5-Kenya-25-Present-Marcelo-3Doms/RR-D02-ERA5-Kenya-25-Present-Marcelo-3Doms-2008_daily.nc", write=FALSE)

Prec <- var.get.nc(post,'tp')
ntimes=length(Prec[1,1,])

#--------------------------------
#   Cogemos los datos temporales y los pasamos a modo tabla
#--------------------------------

tvals=var.get.nc(post,"time")
iyear=c()
imonth=c()
# This does NOT work unless you have already installed udunits2!!
utinit.nc()
tstring=att.get.nc(post,"time","units")
tdates=utcal.nc(tstring,tvals)

#--------------------------------
#   Read nearest Data
#--------------------------------

nearest<-read.table(file="./nearest_SetUp25km_3Doms_d02.dat",header=T, sep = ";")

rows <- nearest$igridlon
cols <- nearest$igridlat
call <- cbind(rows,cols) 

PrecNearests <- array()
for(i in 1:ntimes){  
  Prectarget=Prec[,,i]
  PrecNearests<-cbind(PrecNearests,Prectarget[call])
}
PrecNearests<-PrecNearests[,-1]

PrecNearests<-t(PrecNearests)

#--------------------------------
#   Creamos la tabla y la guardamos
#--------------------------------

tableWRF=cbind(tdates[,1:3],PrecNearests)
tableWRF=as.data.frame(tableWRF)


names <- sprintf("V%01d", 1:length(nearest$stID));
colnames(tableWRF)<-c("year","month","day",names)

write.table(tableWRF,file="DataTables/ERA5-Kenya-25-Present-Marcelo-3Doms/DataTable_RR_Daily_D02.txt",append=FALSE,quote=FALSE,sep=";",row.names=FALSE,col.names=TRUE)


# Cerrar los ficheros de datos
close.nc(post)



#-----------------------------------------------------
#
#   SetUp 25-5-1km - Martina
#
#-----------------------------------------------------

#-----------------------------------------------------
#   Leemos los datos 
#-----------------------------------------------------

library(RNetCDF)

post <- open.nc("/Volumes/ELEMENTS/Cosas_Berna/Post/ERA5-Kenya-25-Present-Martina-3Doms/RR-D02-ERA5-Kenya-25-Present-Martina-3Doms-2008_daily.nc", write=FALSE)

Prec <- var.get.nc(post,'tp')
ntimes=length(Prec[1,1,])

#--------------------------------
#   Cogemos los datos temporales y los pasamos a modo tabla
#--------------------------------

tvals=var.get.nc(post,"time")
iyear=c()
imonth=c()
# This does NOT work unless you have already installed udunits2!!
utinit.nc()
tstring=att.get.nc(post,"time","units")
tdates=utcal.nc(tstring,tvals)

#--------------------------------
#   Read nearest Data
#--------------------------------

nearest<-read.table(file="./nearest_SetUp25km_3Doms_d02.dat",header=T, sep = ";")

rows <- nearest$igridlon
cols <- nearest$igridlat
call <- cbind(rows,cols) 

PrecNearests <- array()
for(i in 1:ntimes){  
  Prectarget=Prec[,,i]
  PrecNearests<-cbind(PrecNearests,Prectarget[call])
}
PrecNearests<-PrecNearests[,-1]

PrecNearests<-t(PrecNearests)

#--------------------------------
#   Creamos la tabla y la guardamos
#--------------------------------

tableWRF=cbind(tdates[,1:3],PrecNearests)
tableWRF=as.data.frame(tableWRF)


names <- sprintf("V%01d", 1:length(nearest$stID));
colnames(tableWRF)<-c("year","month","day",names)

write.table(tableWRF,file="DataTables/ERA5-Kenya-25-Present-Martina-3Doms/DataTable_RR_Daily_D02.txt",append=FALSE,quote=FALSE,sep=";",row.names=FALSE,col.names=TRUE)


# Cerrar los ficheros de datos
close.nc(post)




#-----------------------------------------------------
#
#   SetUp 25-5-1km - Cumulus3
#
#-----------------------------------------------------

#-----------------------------------------------------
#   Leemos los datos 
#-----------------------------------------------------

library(RNetCDF)

post <- open.nc("/Volumes/ELEMENTS/Cosas_Berna/Post/ERA5-Kenya-25-Present-Cumulus3-3Doms/RR-D02-ERA5-Kenya-25-Present-Cumulus3-3Doms-2008_daily.nc", write=FALSE)

Prec <- var.get.nc(post,'tp')
ntimes=length(Prec[1,1,])

#--------------------------------
#   Cogemos los datos temporales y los pasamos a modo tabla
#--------------------------------

tvals=var.get.nc(post,"time")
iyear=c()
imonth=c()
# This does NOT work unless you have already installed udunits2!!
utinit.nc()
tstring=att.get.nc(post,"time","units")
tdates=utcal.nc(tstring,tvals)

#--------------------------------
#   Read nearest Data
#--------------------------------

nearest<-read.table(file="./nearest_SetUp25km_3Doms_d02.dat",header=T, sep = ";")

rows <- nearest$igridlon
cols <- nearest$igridlat
call <- cbind(rows,cols) 

PrecNearests <- array()
for(i in 1:ntimes){  
  Prectarget=Prec[,,i]
  PrecNearests<-cbind(PrecNearests,Prectarget[call])
}
PrecNearests<-PrecNearests[,-1]

PrecNearests<-t(PrecNearests)

#--------------------------------
#   Creamos la tabla y la guardamos
#--------------------------------

tableWRF=cbind(tdates[,1:3],PrecNearests)
tableWRF=as.data.frame(tableWRF)


names <- sprintf("V%01d", 1:length(nearest$stID));
colnames(tableWRF)<-c("year","month","day",names)

write.table(tableWRF,file="DataTables/ERA5-Kenya-25-Present-Cumulus3-3Doms/DataTable_RR_Daily_D02.txt",append=FALSE,quote=FALSE,sep=";",row.names=FALSE,col.names=TRUE)


# Cerrar los ficheros de datos
close.nc(post)



#-----------------------------------------------------
#
#   SetUp 25-5-1km - Cumulus3 1Way
#
#-----------------------------------------------------

#-----------------------------------------------------
#   Leemos los datos 
#-----------------------------------------------------

library(RNetCDF)

post <- open.nc("/Volumes/ELEMENTS/Cosas_Berna/Post/ERA5-Kenya-25-Present-Cumulus3-1Way-3Doms/RR-D02-ERA5-Kenya-25-Present-Cumulus3-1Way-3Doms-2008_daily.nc", write=FALSE)

Prec <- var.get.nc(post,'tp')
ntimes=length(Prec[1,1,])

#--------------------------------
#   Cogemos los datos temporales y los pasamos a modo tabla
#--------------------------------

tvals=var.get.nc(post,"time")
iyear=c()
imonth=c()
# This does NOT work unless you have already installed udunits2!!
utinit.nc()
tstring=att.get.nc(post,"time","units")
tdates=utcal.nc(tstring,tvals)

#--------------------------------
#   Read nearest Data
#--------------------------------

nearest<-read.table(file="./nearest_SetUp25km_3Doms_d02.dat",header=T, sep = ";")

rows <- nearest$igridlon
cols <- nearest$igridlat
call <- cbind(rows,cols) 

PrecNearests <- array()
for(i in 1:ntimes){  
  Prectarget=Prec[,,i]
  PrecNearests<-cbind(PrecNearests,Prectarget[call])
}
PrecNearests<-PrecNearests[,-1]

PrecNearests<-t(PrecNearests)

#--------------------------------
#   Creamos la tabla y la guardamos
#--------------------------------

tableWRF=cbind(tdates[,1:3],PrecNearests)
tableWRF=as.data.frame(tableWRF)


names <- sprintf("V%01d", 1:length(nearest$stID));
colnames(tableWRF)<-c("year","month","day",names)

write.table(tableWRF,file="DataTables/ERA5-Kenya-25-Present-Cumulus3-1Way-3Doms/DataTable_RR_Daily_D02.txt",append=FALSE,quote=FALSE,sep=";",row.names=FALSE,col.names=TRUE)


# Cerrar los ficheros de datos
close.nc(post)


#-----------------------------------------------------
#
#   SetUp 25-5-1km - ERA5
#
#-----------------------------------------------------

#-----------------------------------------------------
#   Leemos los datos 
#-----------------------------------------------------

library(RNetCDF)

post <- open.nc("/Volumes/ELEMENTS/Cosas_Berna/Post/ERA5-Kenya-25-Present-ERA5-3Doms/ERA5_RR-2008_daysum_D02.nc", write=FALSE)

Prec <- var.get.nc(post,'var1')
ntimes=length(Prec[1,1,])

#--------------------------------
#   Cogemos los datos temporales y los pasamos a modo tabla
#--------------------------------

tvals=var.get.nc(post,"time")
iyear=c()
imonth=c()
# This does NOT work unless you have already installed udunits2!!
utinit.nc()
tstring=att.get.nc(post,"time","units")
tdates=utcal.nc(tstring,tvals)

#--------------------------------
#   Read nearest Data
#--------------------------------

nearest<-read.table(file="./nearest_SetUp25km_3Doms_d02.dat",header=T, sep = ";")

rows <- nearest$igridlon
cols <- nearest$igridlat
call <- cbind(rows,cols) 

PrecNearests <- array()
for(i in 1:ntimes){  
  Prectarget=Prec[,,i]
  PrecNearests<-cbind(PrecNearests,Prectarget[call])
}
PrecNearests<-PrecNearests[,-1]

PrecNearests<-t(PrecNearests)

#--------------------------------
#   Creamos la tabla y la guardamos
#--------------------------------

tableWRF=cbind(tdates[,1:3],PrecNearests)
tableWRF=as.data.frame(tableWRF)


names <- sprintf("V%01d", 1:length(nearest$stID));
colnames(tableWRF)<-c("year","month","day",names)

write.table(tableWRF,file="DataTables/ERA5-Kenya-25-Present-ERA5-3Doms/DataTable_RR_Daily_D02.txt",append=FALSE,quote=FALSE,sep=";",row.names=FALSE,col.names=TRUE)


# Cerrar los ficheros de datos
close.nc(post)


#-----------------------------------------------------
#
#   SetUp 25-5-1km - IMERG
#
#-----------------------------------------------------

#-----------------------------------------------------
#   Leemos los datos 
#-----------------------------------------------------

library(RNetCDF)

post <- open.nc("/Volumes/ELEMENTS/Cosas_Berna/Post/ERA5-Kenya-25-Present-IMERG-3Doms/IMERG_RR-2008_daysum_D02.nc", write=FALSE)

Prec <- var.get.nc(post,'Band1')
ntimes=length(Prec[1,1,])

#--------------------------------
#   Cogemos los datos temporales y los pasamos a modo tabla
#--------------------------------

tvals=var.get.nc(post,"time")
iyear=c()
imonth=c()
# This does NOT work unless you have already installed udunits2!!
utinit.nc()
tstring=att.get.nc(post,"time","units")
tdates=utcal.nc(tstring,tvals)

#--------------------------------
#   Read nearest Data
#--------------------------------

nearest<-read.table(file="./nearest_SetUp25km_3Doms_d02.dat",header=T, sep = ";")

rows <- nearest$igridlon
cols <- nearest$igridlat
call <- cbind(rows,cols) 

PrecNearests <- array()
for(i in 1:ntimes){  
  Prectarget=Prec[,,i]
  # If we want to obtain mm/day
  Prectarget = Prectarget * 24 * 0.1 
  PrecNearests<-cbind(PrecNearests,Prectarget[call])
}
PrecNearests<-PrecNearests[,-1]

PrecNearests<-t(PrecNearests)

#--------------------------------
#   Creamos la tabla y la guardamos
#--------------------------------

tableWRF=cbind(tdates[,1:3],PrecNearests)
tableWRF=as.data.frame(tableWRF)


names <- sprintf("V%01d", 1:length(nearest$stID));
colnames(tableWRF)<-c("year","month","day",names)

write.table(tableWRF,file="DataTables/ERA5-Kenya-25-Present-IMERG-3Doms/DataTable_RR_Daily_D02.txt",append=FALSE,quote=FALSE,sep=";",row.names=FALSE,col.names=TRUE)


# Cerrar los ficheros de datos
close.nc(post)


#-----------------------------------------------------
#
#   SetUp 25-5-1km - IMERG  -  New
#
#-----------------------------------------------------

#-----------------------------------------------------
#   Leemos los datos 
#-----------------------------------------------------

library(RNetCDF)

post <- open.nc("/Volumes/ELEMENTS/Cosas_Berna/Post/ERA5-Kenya-25-Present-IMERG-3Doms-New/IMERG_RR-2008_daysum_D02.nc", write=FALSE)

Prec <- var.get.nc(post,'PR')
ntimes=length(Prec[1,1,])

#--------------------------------
#   Cogemos los datos temporales y los pasamos a modo tabla
#--------------------------------

tvals=var.get.nc(post,"time")
iyear=c()
imonth=c()
# This does NOT work unless you have already installed udunits2!!
utinit.nc()
tstring=att.get.nc(post,"time","units")
tdates=utcal.nc(tstring,tvals)

#--------------------------------
#   Read nearest Data
#--------------------------------

nearest<-read.table(file="./nearest_SetUp25km_3Doms_d02.dat",header=T, sep = ";")

rows <- nearest$igridlon
cols <- nearest$igridlat
call <- cbind(rows,cols) 

PrecNearests <- array()
for(i in 1:ntimes){  
  Prectarget=Prec[,,i]
  PrecNearests<-cbind(PrecNearests,Prectarget[call])
}
PrecNearests<-PrecNearests[,-1]

PrecNearests<-t(PrecNearests)

#--------------------------------
#   Creamos la tabla y la guardamos
#--------------------------------

tableWRF=cbind(tdates[,1:3],PrecNearests)
tableWRF=as.data.frame(tableWRF)


names <- sprintf("V%01d", 1:length(nearest$stID));
colnames(tableWRF)<-c("year","month","day",names)

write.table(tableWRF,file="DataTables/ERA5-Kenya-25-Present-IMERG-3Doms-New/DataTable_RR_Daily_D02.txt",append=FALSE,quote=FALSE,sep=";",row.names=FALSE,col.names=TRUE)


# Cerrar los ficheros de datos
close.nc(post)



#-----------------------------------------------------
#
#   SetUp 25-5-1km - TRMM
#
#-----------------------------------------------------

#-----------------------------------------------------
#   Leemos los datos 
#-----------------------------------------------------

library(RNetCDF)

post <- open.nc("/Volumes/ELEMENTS/Cosas_Berna/Post/ERA5-Kenya-25-Present-TRMM-3Doms/TRMM_RR-2008_daysum_D02.nc", write=FALSE)

Prec <- var.get.nc(post,'pcp')
ntimes=length(Prec[1,1,])

#--------------------------------
#   Cogemos los datos temporales y los pasamos a modo tabla
#--------------------------------

tvals=var.get.nc(post,"time")
iyear=c()
imonth=c()
# This does NOT work unless you have already installed udunits2!!
utinit.nc()
tstring=att.get.nc(post,"time","units")
tdates=utcal.nc(tstring,tvals)

#--------------------------------
#   Read nearest Data
#--------------------------------

nearest<-read.table(file="./nearest_SetUp25km_3Doms_d02.dat",header=T, sep = ";")

rows <- nearest$igridlon
cols <- nearest$igridlat
call <- cbind(rows,cols) 

PrecNearests <- array()
for(i in 1:ntimes){  
  Prectarget=Prec[,,i]
  PrecNearests<-cbind(PrecNearests,Prectarget[call])
}
PrecNearests<-PrecNearests[,-1]

PrecNearests<-t(PrecNearests)

#--------------------------------
#   Creamos la tabla y la guardamos
#--------------------------------

tableWRF=cbind(tdates[,1:3],PrecNearests)
tableWRF=as.data.frame(tableWRF)


names <- sprintf("V%01d", 1:length(nearest$stID));
colnames(tableWRF)<-c("year","month","day",names)

write.table(tableWRF,file="DataTables/ERA5-Kenya-25-Present-TRMM-3Doms/DataTable_RR_Daily_D02.txt",append=FALSE,quote=FALSE,sep=";",row.names=FALSE,col.names=TRUE)


# Cerrar los ficheros de datos
close.nc(post)


#-----------------------------------------------------
#
#   SetUp 25-5-1km - TRMM  -  New
#
#-----------------------------------------------------

#-----------------------------------------------------
#   Leemos los datos 
#-----------------------------------------------------

library(RNetCDF)

post <- open.nc("/Volumes/ELEMENTS/Cosas_Berna/Post/ERA5-Kenya-25-Present-TRMM-3Doms-New/TRMM_RR-2008_daysum_D02.nc", write=FALSE)

Prec <- var.get.nc(post,'PR')
ntimes=length(Prec[1,1,])

#--------------------------------
#   Cogemos los datos temporales y los pasamos a modo tabla
#--------------------------------

tvals=var.get.nc(post,"time")
iyear=c()
imonth=c()
# This does NOT work unless you have already installed udunits2!!
utinit.nc()
tstring=att.get.nc(post,"time","units")
tdates=utcal.nc(tstring,tvals)

#--------------------------------
#   Read nearest Data
#--------------------------------

nearest<-read.table(file="./nearest_SetUp25km_3Doms_d02.dat",header=T, sep = ";")

rows <- nearest$igridlon
cols <- nearest$igridlat
call <- cbind(rows,cols) 

PrecNearests <- array()
for(i in 1:ntimes){  
  Prectarget=Prec[,,i]
  PrecNearests<-cbind(PrecNearests,Prectarget[call])
}
PrecNearests<-PrecNearests[,-1]

PrecNearests<-t(PrecNearests)

#--------------------------------
#   Creamos la tabla y la guardamos
#--------------------------------

tableWRF=cbind(tdates[,1:3],PrecNearests)
tableWRF=as.data.frame(tableWRF)


names <- sprintf("V%01d", 1:length(nearest$stID));
colnames(tableWRF)<-c("year","month","day",names)

write.table(tableWRF,file="DataTables/ERA5-Kenya-25-Present-TRMM-3Doms-New/DataTable_RR_Daily_D02.txt",append=FALSE,quote=FALSE,sep=";",row.names=FALSE,col.names=TRUE)


# Cerrar los ficheros de datos
close.nc(post)


#-----------------------------------------------------
#
#   SetUp 25-5-1km - No Cumulus
#
#-----------------------------------------------------

#-----------------------------------------------------
#   Leemos los datos 
#-----------------------------------------------------

library(RNetCDF)

post <- open.nc("/Volumes/ELEMENTS/Cosas_Berna/Post/ERA5-Kenya-25-Present-NoCumulus-3Doms/RR-D02-ERA5-Kenya-25-Present-NoCumulus-3Doms-2008_daily.nc", write=FALSE)

Prec <- var.get.nc(post,'tp')
ntimes=length(Prec[1,1,])

#--------------------------------
#   Cogemos los datos temporales y los pasamos a modo tabla
#--------------------------------

tvals=var.get.nc(post,"time")
iyear=c()
imonth=c()
# This does NOT work unless you have already installed udunits2!!
utinit.nc()
tstring=att.get.nc(post,"time","units")
tdates=utcal.nc(tstring,tvals)

#--------------------------------
#   Read nearest Data
#--------------------------------

nearest<-read.table(file="./nearest_SetUp25km_3Doms_d02.dat",header=T, sep = ";")

rows <- nearest$igridlon
cols <- nearest$igridlat
call <- cbind(rows,cols) 

PrecNearests <- array()
for(i in 1:ntimes){  
  Prectarget=Prec[,,i]
  PrecNearests<-cbind(PrecNearests,Prectarget[call])
}
PrecNearests<-PrecNearests[,-1]

PrecNearests<-t(PrecNearests)

#--------------------------------
#   Creamos la tabla y la guardamos
#--------------------------------

tableWRF=cbind(tdates[,1:3],PrecNearests)
tableWRF=as.data.frame(tableWRF)


names <- sprintf("V%01d", 1:length(nearest$stID));
colnames(tableWRF)<-c("year","month","day",names)

write.table(tableWRF,file="DataTables/ERA5-Kenya-25-Present-NoCumulus-3Doms/DataTable_RR_Daily_D02.txt",append=FALSE,quote=FALSE,sep=";",row.names=FALSE,col.names=TRUE)


# Cerrar los ficheros de datos
close.nc(post)


#-----------------------------------------------------
#
#   SetUp 25-5-1km - CHIRPS
#
#-----------------------------------------------------

#-----------------------------------------------------
#   Leemos los datos 
#-----------------------------------------------------

library(RNetCDF)

post <- open.nc("/Volumes/ELEMENTS/Cosas_Berna/Post/ERA5-Kenya-25-Present-CHIRPS-3Doms/CHIRPS_RR-2008_daysum_D02.nc", write=FALSE)

Prec <- var.get.nc(post,'precip')
ntimes=length(Prec[1,1,])

#--------------------------------
#   Cogemos los datos temporales y los pasamos a modo tabla
#--------------------------------

tvals=var.get.nc(post,"time")
iyear=c()
imonth=c()
# This does NOT work unless you have already installed udunits2!!
utinit.nc()
tstring=att.get.nc(post,"time","units")
tdates=utcal.nc(tstring,tvals)

#--------------------------------
#   Read nearest Data
#--------------------------------

nearest<-read.table(file="./nearest_SetUp25km_3Doms_d02.dat",header=T, sep = ";")

rows <- nearest$igridlon
cols <- nearest$igridlat
call <- cbind(rows,cols) 

PrecNearests <- array()
for(i in 1:ntimes){  
  Prectarget=Prec[,,i]
  PrecNearests<-cbind(PrecNearests,Prectarget[call])
}
PrecNearests<-PrecNearests[,-1]

PrecNearests<-t(PrecNearests)

#--------------------------------
#   Creamos la tabla y la guardamos
#--------------------------------

tableWRF=cbind(tdates[,1:3],PrecNearests)
tableWRF=as.data.frame(tableWRF)


names <- sprintf("V%01d", 1:length(nearest$stID));
colnames(tableWRF)<-c("year","month","day",names)

write.table(tableWRF,file="DataTables/ERA5-Kenya-25-Present-CHIRPS-3Doms/DataTable_RR_Daily_D02.txt",append=FALSE,quote=FALSE,sep=";",row.names=FALSE,col.names=TRUE)


# Cerrar los ficheros de datos
close.nc(post)







#-----------------------------------------------------
#
#
#   DOMAIN D03
#
#
#-----------------------------------------------------

#-----------------------------------------------------
#
#   SetUp 25-5-1km - Marcelo
#
#-----------------------------------------------------

#-----------------------------------------------------
#   Leemos los datos 
#-----------------------------------------------------

library(RNetCDF)

post <- open.nc("/Volumes/ELEMENTS/Cosas_Berna/Post/ERA5-Kenya-25-Present-Marcelo-3Doms/RR-D03-ERA5-Kenya-25-Present-Marcelo-3Doms-2008_daily.nc", write=FALSE)

Prec <- var.get.nc(post,'tp')
ntimes=length(Prec[1,1,])

#--------------------------------
#   Cogemos los datos temporales y los pasamos a modo tabla
#--------------------------------

tvals=var.get.nc(post,"time")
iyear=c()
imonth=c()
# This does NOT work unless you have already installed udunits2!!
utinit.nc()
tstring=att.get.nc(post,"time","units")
tdates=utcal.nc(tstring,tvals)

#--------------------------------
#   Read nearest Data
#--------------------------------

nearest<-read.table(file="./nearest_SetUp25km_3Doms_d03.dat",header=T, sep = ";")

rows <- nearest$igridlon
cols <- nearest$igridlat
call <- cbind(rows,cols) 

PrecNearests <- array()
for(i in 1:ntimes){  
  Prectarget=Prec[,,i]
  PrecNearests<-cbind(PrecNearests,Prectarget[call])
}
PrecNearests<-PrecNearests[,-1]

PrecNearests<-t(PrecNearests)

#--------------------------------
#   Creamos la tabla y la guardamos
#--------------------------------

tableWRF=cbind(tdates[,1:3],PrecNearests)
tableWRF=as.data.frame(tableWRF)


names <- sprintf("V%01d", 1:length(nearest$stID));
colnames(tableWRF)<-c("year","month","day",names)

write.table(tableWRF,file="DataTables/ERA5-Kenya-25-Present-Marcelo-3Doms/DataTable_RR_Daily_D03.txt",append=FALSE,quote=FALSE,sep=";",row.names=FALSE,col.names=TRUE)


# Cerrar los ficheros de datos
close.nc(post)



#-----------------------------------------------------
#
#   SetUp 25-5-1km - Martina
#
#-----------------------------------------------------

#-----------------------------------------------------
#   Leemos los datos 
#-----------------------------------------------------

library(RNetCDF)

post <- open.nc("/Volumes/ELEMENTS/Cosas_Berna/Post/ERA5-Kenya-25-Present-Martina-3Doms/RR-D03-ERA5-Kenya-25-Present-Martina-3Doms-2008_daily.nc", write=FALSE)

Prec <- var.get.nc(post,'tp')
ntimes=length(Prec[1,1,])

#--------------------------------
#   Cogemos los datos temporales y los pasamos a modo tabla
#--------------------------------

tvals=var.get.nc(post,"time")
iyear=c()
imonth=c()
# This does NOT work unless you have already installed udunits2!!
utinit.nc()
tstring=att.get.nc(post,"time","units")
tdates=utcal.nc(tstring,tvals)

#--------------------------------
#   Read nearest Data
#--------------------------------

nearest<-read.table(file="./nearest_SetUp25km_3Doms_d03.dat",header=T, sep = ";")

rows <- nearest$igridlon
cols <- nearest$igridlat
call <- cbind(rows,cols) 

PrecNearests <- array()
for(i in 1:ntimes){  
  Prectarget=Prec[,,i]
  PrecNearests<-cbind(PrecNearests,Prectarget[call])
}
PrecNearests<-PrecNearests[,-1]

PrecNearests<-t(PrecNearests)

#--------------------------------
#   Creamos la tabla y la guardamos
#--------------------------------

tableWRF=cbind(tdates[,1:3],PrecNearests)
tableWRF=as.data.frame(tableWRF)


names <- sprintf("V%01d", 1:length(nearest$stID));
colnames(tableWRF)<-c("year","month","day",names)

write.table(tableWRF,file="DataTables/ERA5-Kenya-25-Present-Martina-3Doms/DataTable_RR_Daily_D03.txt",append=FALSE,quote=FALSE,sep=";",row.names=FALSE,col.names=TRUE)


# Cerrar los ficheros de datos
close.nc(post)




#-----------------------------------------------------
#
#   SetUp 25-5-1km - Cumulus3
#
#-----------------------------------------------------

#-----------------------------------------------------
#   Leemos los datos 
#-----------------------------------------------------

library(RNetCDF)

post <- open.nc("/Volumes/ELEMENTS/Cosas_Berna/Post/ERA5-Kenya-25-Present-Cumulus3-3Doms/RR-D03-ERA5-Kenya-25-Present-Cumulus3-3Doms-2008_daily.nc", write=FALSE)

Prec <- var.get.nc(post,'tp')
ntimes=length(Prec[1,1,])

#--------------------------------
#   Cogemos los datos temporales y los pasamos a modo tabla
#--------------------------------

tvals=var.get.nc(post,"time")
iyear=c()
imonth=c()
# This does NOT work unless you have already installed udunits2!!
utinit.nc()
tstring=att.get.nc(post,"time","units")
tdates=utcal.nc(tstring,tvals)

#--------------------------------
#   Read nearest Data
#--------------------------------

nearest<-read.table(file="./nearest_SetUp25km_3Doms_d03.dat",header=T, sep = ";")

rows <- nearest$igridlon
cols <- nearest$igridlat
call <- cbind(rows,cols) 

PrecNearests <- array()
for(i in 1:ntimes){  
  Prectarget=Prec[,,i]
  PrecNearests<-cbind(PrecNearests,Prectarget[call])
}
PrecNearests<-PrecNearests[,-1]

PrecNearests<-t(PrecNearests)

#--------------------------------
#   Creamos la tabla y la guardamos
#--------------------------------

tableWRF=cbind(tdates[,1:3],PrecNearests)
tableWRF=as.data.frame(tableWRF)


names <- sprintf("V%01d", 1:length(nearest$stID));
colnames(tableWRF)<-c("year","month","day",names)

write.table(tableWRF,file="DataTables/ERA5-Kenya-25-Present-Cumulus3-3Doms/DataTable_RR_Daily_D03.txt",append=FALSE,quote=FALSE,sep=";",row.names=FALSE,col.names=TRUE)


# Cerrar los ficheros de datos
close.nc(post)



#-----------------------------------------------------
#
#   SetUp 25-5-1km - Cumulus3 1Way
#
#-----------------------------------------------------

#-----------------------------------------------------
#   Leemos los datos 
#-----------------------------------------------------

library(RNetCDF)

post <- open.nc("/Volumes/ELEMENTS/Cosas_Berna/Post/ERA5-Kenya-25-Present-Cumulus3-1Way-3Doms/RR-D03-ERA5-Kenya-25-Present-Cumulus3-1Way-3Doms-2008_daily.nc", write=FALSE)

Prec <- var.get.nc(post,'tp')
ntimes=length(Prec[1,1,])

#--------------------------------
#   Cogemos los datos temporales y los pasamos a modo tabla
#--------------------------------

tvals=var.get.nc(post,"time")
iyear=c()
imonth=c()
# This does NOT work unless you have already installed udunits2!!
utinit.nc()
tstring=att.get.nc(post,"time","units")
tdates=utcal.nc(tstring,tvals)

#--------------------------------
#   Read nearest Data
#--------------------------------

nearest<-read.table(file="./nearest_SetUp25km_3Doms_d03.dat",header=T, sep = ";")

rows <- nearest$igridlon
cols <- nearest$igridlat
call <- cbind(rows,cols) 

PrecNearests <- array()
for(i in 1:ntimes){  
  Prectarget=Prec[,,i]
  PrecNearests<-cbind(PrecNearests,Prectarget[call])
}
PrecNearests<-PrecNearests[,-1]

PrecNearests<-t(PrecNearests)

#--------------------------------
#   Creamos la tabla y la guardamos
#--------------------------------

tableWRF=cbind(tdates[,1:3],PrecNearests)
tableWRF=as.data.frame(tableWRF)


names <- sprintf("V%01d", 1:length(nearest$stID));
colnames(tableWRF)<-c("year","month","day",names)

write.table(tableWRF,file="DataTables/ERA5-Kenya-25-Present-Cumulus3-1Way-3Doms/DataTable_RR_Daily_D03.txt",append=FALSE,quote=FALSE,sep=";",row.names=FALSE,col.names=TRUE)


# Cerrar los ficheros de datos
close.nc(post)



#-----------------------------------------------------
#
#   SetUp 25-5-1km - ERA5
#
#-----------------------------------------------------

#-----------------------------------------------------
#   Leemos los datos 
#-----------------------------------------------------

library(RNetCDF)

post <- open.nc("/Volumes/ELEMENTS/Cosas_Berna/Post/ERA5-Kenya-25-Present-ERA5-3Doms/ERA5_RR-2008_daysum_D03.nc", write=FALSE)

Prec <- var.get.nc(post,'var1')
ntimes=length(Prec[1,1,])

#--------------------------------
#   Cogemos los datos temporales y los pasamos a modo tabla
#--------------------------------

tvals=var.get.nc(post,"time")
iyear=c()
imonth=c()
# This does NOT work unless you have already installed udunits2!!
utinit.nc()
tstring=att.get.nc(post,"time","units")
tdates=utcal.nc(tstring,tvals)

#--------------------------------
#   Read nearest Data
#--------------------------------

nearest<-read.table(file="./nearest_SetUp25km_3Doms_d03.dat",header=T, sep = ";")

rows <- nearest$igridlon
cols <- nearest$igridlat
call <- cbind(rows,cols) 

PrecNearests <- array()
for(i in 1:ntimes){  
  Prectarget=Prec[,,i]
  PrecNearests<-cbind(PrecNearests,Prectarget[call])
}
PrecNearests<-PrecNearests[,-1]

PrecNearests<-t(PrecNearests)

#--------------------------------
#   Creamos la tabla y la guardamos
#--------------------------------

tableWRF=cbind(tdates[,1:3],PrecNearests)
tableWRF=as.data.frame(tableWRF)


names <- sprintf("V%01d", 1:length(nearest$stID));
colnames(tableWRF)<-c("year","month","day",names)

write.table(tableWRF,file="DataTables/ERA5-Kenya-25-Present-ERA5-3Doms/DataTable_RR_Daily_D03.txt",append=FALSE,quote=FALSE,sep=";",row.names=FALSE,col.names=TRUE)


# Cerrar los ficheros de datos
close.nc(post)



#-----------------------------------------------------
#
#   SetUp 25-5-1km - IMERG
#
#-----------------------------------------------------

#-----------------------------------------------------
#   Leemos los datos 
#-----------------------------------------------------

library(RNetCDF)

post <- open.nc("/Volumes/ELEMENTS/Cosas_Berna/Post/ERA5-Kenya-25-Present-IMERG-3Doms/IMERG_RR-2008_daysum_D03.nc", write=FALSE)

Prec <- var.get.nc(post,'Band1')
ntimes=length(Prec[1,1,])

#--------------------------------
#   Cogemos los datos temporales y los pasamos a modo tabla
#--------------------------------

tvals=var.get.nc(post,"time")
iyear=c()
imonth=c()
# This does NOT work unless you have already installed udunits2!!
utinit.nc()
tstring=att.get.nc(post,"time","units")
tdates=utcal.nc(tstring,tvals)

#--------------------------------
#   Read nearest Data
#--------------------------------

nearest<-read.table(file="./nearest_SetUp25km_3Doms_d03.dat",header=T, sep = ";")

rows <- nearest$igridlon
cols <- nearest$igridlat
call <- cbind(rows,cols) 

PrecNearests <- array()
for(i in 1:ntimes){  
  Prectarget=Prec[,,i]
  # If we want to obtain mm/day
  Prectarget = Prectarget * 24 * 0.1 
  PrecNearests<-cbind(PrecNearests,Prectarget[call])
}
PrecNearests<-PrecNearests[,-1]

PrecNearests<-t(PrecNearests)

#--------------------------------
#   Creamos la tabla y la guardamos
#--------------------------------

tableWRF=cbind(tdates[,1:3],PrecNearests)
tableWRF=as.data.frame(tableWRF)


names <- sprintf("V%01d", 1:length(nearest$stID));
colnames(tableWRF)<-c("year","month","day",names)

write.table(tableWRF,file="DataTables/ERA5-Kenya-25-Present-IMERG-3Doms/DataTable_RR_Daily_D03.txt",append=FALSE,quote=FALSE,sep=";",row.names=FALSE,col.names=TRUE)


# Cerrar los ficheros de datos
close.nc(post)


#-----------------------------------------------------
#
#   SetUp 25-5-1km - IMERG  -  New
#
#-----------------------------------------------------

#-----------------------------------------------------
#   Leemos los datos 
#-----------------------------------------------------

library(RNetCDF)

post <- open.nc("/Volumes/ELEMENTS/Cosas_Berna/Post/ERA5-Kenya-25-Present-IMERG-3Doms-New/IMERG_RR-2008_daysum_D03.nc", write=FALSE)

Prec <- var.get.nc(post,'PR')
ntimes=length(Prec[1,1,])

#--------------------------------
#   Cogemos los datos temporales y los pasamos a modo tabla
#--------------------------------

tvals=var.get.nc(post,"time")
iyear=c()
imonth=c()
# This does NOT work unless you have already installed udunits2!!
utinit.nc()
tstring=att.get.nc(post,"time","units")
tdates=utcal.nc(tstring,tvals)

#--------------------------------
#   Read nearest Data
#--------------------------------

nearest<-read.table(file="./nearest_SetUp25km_3Doms_d03.dat",header=T, sep = ";")

rows <- nearest$igridlon
cols <- nearest$igridlat
call <- cbind(rows,cols) 

PrecNearests <- array()
for(i in 1:ntimes){  
  Prectarget=Prec[,,i]
  PrecNearests<-cbind(PrecNearests,Prectarget[call])
}
PrecNearests<-PrecNearests[,-1]

PrecNearests<-t(PrecNearests)

#--------------------------------
#   Creamos la tabla y la guardamos
#--------------------------------

tableWRF=cbind(tdates[,1:3],PrecNearests)
tableWRF=as.data.frame(tableWRF)


names <- sprintf("V%01d", 1:length(nearest$stID));
colnames(tableWRF)<-c("year","month","day",names)

write.table(tableWRF,file="DataTables/ERA5-Kenya-25-Present-IMERG-3Doms-New/DataTable_RR_Daily_D03.txt",append=FALSE,quote=FALSE,sep=";",row.names=FALSE,col.names=TRUE)


# Cerrar los ficheros de datos
close.nc(post)


#-----------------------------------------------------
#
#   SetUp 25-5-1km - TRMM
#
#-----------------------------------------------------

#-----------------------------------------------------
#   Leemos los datos 
#-----------------------------------------------------

library(RNetCDF)

post <- open.nc("/Volumes/ELEMENTS/Cosas_Berna/Post/ERA5-Kenya-25-Present-TRMM-3Doms/TRMM_RR-2008_daysum_D03.nc", write=FALSE)

Prec <- var.get.nc(post,'pcp')
ntimes=length(Prec[1,1,])

#--------------------------------
#   Cogemos los datos temporales y los pasamos a modo tabla
#--------------------------------

tvals=var.get.nc(post,"time")
iyear=c()
imonth=c()
# This does NOT work unless you have already installed udunits2!!
utinit.nc()
tstring=att.get.nc(post,"time","units")
tdates=utcal.nc(tstring,tvals)

#--------------------------------
#   Read nearest Data
#--------------------------------

nearest<-read.table(file="./nearest_SetUp25km_3Doms_d03.dat",header=T, sep = ";")

rows <- nearest$igridlon
cols <- nearest$igridlat
call <- cbind(rows,cols) 

PrecNearests <- array()
for(i in 1:ntimes){  
  Prectarget=Prec[,,i]
  PrecNearests<-cbind(PrecNearests,Prectarget[call])
}
PrecNearests<-PrecNearests[,-1]

PrecNearests<-t(PrecNearests)

#--------------------------------
#   Creamos la tabla y la guardamos
#--------------------------------

tableWRF=cbind(tdates[,1:3],PrecNearests)
tableWRF=as.data.frame(tableWRF)


names <- sprintf("V%01d", 1:length(nearest$stID));
colnames(tableWRF)<-c("year","month","day",names)

write.table(tableWRF,file="DataTables/ERA5-Kenya-25-Present-TRMM-3Doms/DataTable_RR_Daily_D03.txt",append=FALSE,quote=FALSE,sep=";",row.names=FALSE,col.names=TRUE)


# Cerrar los ficheros de datos
close.nc(post)



#-----------------------------------------------------
#
#   SetUp 25-5-1km - TRMM  -  New
#
#-----------------------------------------------------

#-----------------------------------------------------
#   Leemos los datos 
#-----------------------------------------------------

library(RNetCDF)

post <- open.nc("/Volumes/ELEMENTS/Cosas_Berna/Post/ERA5-Kenya-25-Present-TRMM-3Doms-New/TRMM_RR-2008_daysum_D03.nc", write=FALSE)

Prec <- var.get.nc(post,'PR')
ntimes=length(Prec[1,1,])

#--------------------------------
#   Cogemos los datos temporales y los pasamos a modo tabla
#--------------------------------

tvals=var.get.nc(post,"time")
iyear=c()
imonth=c()
# This does NOT work unless you have already installed udunits2!!
utinit.nc()
tstring=att.get.nc(post,"time","units")
tdates=utcal.nc(tstring,tvals)

#--------------------------------
#   Read nearest Data
#--------------------------------

nearest<-read.table(file="./nearest_SetUp25km_3Doms_d03.dat",header=T, sep = ";")

rows <- nearest$igridlon
cols <- nearest$igridlat
call <- cbind(rows,cols) 

PrecNearests <- array()
for(i in 1:ntimes){  
  Prectarget=Prec[,,i]
  PrecNearests<-cbind(PrecNearests,Prectarget[call])
}
PrecNearests<-PrecNearests[,-1]

PrecNearests<-t(PrecNearests)

#--------------------------------
#   Creamos la tabla y la guardamos
#--------------------------------

tableWRF=cbind(tdates[,1:3],PrecNearests)
tableWRF=as.data.frame(tableWRF)


names <- sprintf("V%01d", 1:length(nearest$stID));
colnames(tableWRF)<-c("year","month","day",names)

write.table(tableWRF,file="DataTables/ERA5-Kenya-25-Present-TRMM-3Doms-New/DataTable_RR_Daily_D03.txt",append=FALSE,quote=FALSE,sep=";",row.names=FALSE,col.names=TRUE)


# Cerrar los ficheros de datos
close.nc(post)


#-----------------------------------------------------
#
#   SetUp 25-5-1km - No Cumulus
#
#-----------------------------------------------------

#-----------------------------------------------------
#   Leemos los datos 
#-----------------------------------------------------

library(RNetCDF)

post <- open.nc("/Volumes/ELEMENTS/Cosas_Berna/Post/ERA5-Kenya-25-Present-NoCumulus-3Doms/RR-D03-ERA5-Kenya-25-Present-NoCumulus-3Doms-2008_daily.nc", write=FALSE)

Prec <- var.get.nc(post,'tp')
ntimes=length(Prec[1,1,])

#--------------------------------
#   Cogemos los datos temporales y los pasamos a modo tabla
#--------------------------------

tvals=var.get.nc(post,"time")
iyear=c()
imonth=c()
# This does NOT work unless you have already installed udunits2!!
utinit.nc()
tstring=att.get.nc(post,"time","units")
tdates=utcal.nc(tstring,tvals)

#--------------------------------
#   Read nearest Data
#--------------------------------

nearest<-read.table(file="./nearest_SetUp25km_3Doms_d03.dat",header=T, sep = ";")

rows <- nearest$igridlon
cols <- nearest$igridlat
call <- cbind(rows,cols) 

PrecNearests <- array()
for(i in 1:ntimes){  
  Prectarget=Prec[,,i]
  PrecNearests<-cbind(PrecNearests,Prectarget[call])
}
PrecNearests<-PrecNearests[,-1]

PrecNearests<-t(PrecNearests)

#--------------------------------
#   Creamos la tabla y la guardamos
#--------------------------------

tableWRF=cbind(tdates[,1:3],PrecNearests)
tableWRF=as.data.frame(tableWRF)


names <- sprintf("V%01d", 1:length(nearest$stID));
colnames(tableWRF)<-c("year","month","day",names)

write.table(tableWRF,file="DataTables/ERA5-Kenya-25-Present-NoCumulus-3Doms/DataTable_RR_Daily_D03.txt",append=FALSE,quote=FALSE,sep=";",row.names=FALSE,col.names=TRUE)


# Cerrar los ficheros de datos
close.nc(post)

#-----------------------------------------------------
#
#   SetUp 25-5-1km - CHIRPS
#
#-----------------------------------------------------

#-----------------------------------------------------
#   Leemos los datos 
#-----------------------------------------------------

library(RNetCDF)

post <- open.nc("/Volumes/ELEMENTS/Cosas_Berna/Post/ERA5-Kenya-25-Present-CHIRPS-3Doms/CHIRPS_RR-2008_daysum_D03.nc", write=FALSE)

Prec <- var.get.nc(post,'precip')
ntimes=length(Prec[1,1,])

#--------------------------------
#   Cogemos los datos temporales y los pasamos a modo tabla
#--------------------------------

tvals=var.get.nc(post,"time")
iyear=c()
imonth=c()
# This does NOT work unless you have already installed udunits2!!
utinit.nc()
tstring=att.get.nc(post,"time","units")
tdates=utcal.nc(tstring,tvals)

#--------------------------------
#   Read nearest Data
#--------------------------------

nearest<-read.table(file="./nearest_SetUp25km_3Doms_d03.dat",header=T, sep = ";")

rows <- nearest$igridlon
cols <- nearest$igridlat
call <- cbind(rows,cols) 

PrecNearests <- array()
for(i in 1:ntimes){  
  Prectarget=Prec[,,i]
  PrecNearests<-cbind(PrecNearests,Prectarget[call])
}
PrecNearests<-PrecNearests[,-1]

PrecNearests<-t(PrecNearests)

#--------------------------------
#   Creamos la tabla y la guardamos
#--------------------------------

tableWRF=cbind(tdates[,1:3],PrecNearests)
tableWRF=as.data.frame(tableWRF)


names <- sprintf("V%01d", 1:length(nearest$stID));
colnames(tableWRF)<-c("year","month","day",names)

write.table(tableWRF,file="DataTables/ERA5-Kenya-25-Present-CHIRPS-3Doms/DataTable_RR_Daily_D03.txt",append=FALSE,quote=FALSE,sep=";",row.names=FALSE,col.names=TRUE)


# Cerrar los ficheros de datos
close.nc(post)
