#------------------------------------------------------
#
#    October 2020
#    Script associated to publication:
#    "Sensitivity of precipitation and temperature over Mount Kenya area to 
#     physics parameterization options in a high-resolution modelsimulation 
#     performed with WRFV3.8.1"
#    Authors: M. Messmer, S.J. Gonzlez-Roj, C.C. Raible and T.F. Stocker
#
#
#    Creative Commons License: Attribution-NonCommercial 4.0 International (CC BY-NC 4.0)
#------------------------------------------------------

nearests <- read.table(file = "./ChosenStations_For2008.txt",header = T,sep = ";")

####################################################
#
# 
#   Set-Up 25-5-1 km (3 Doms)
# 
#
####################################################

####################################################
#               WRF GRID 02
####################################################

deg2rad=acos(-1.0)/180.0

library(RNetCDF)
wrfout <- open.nc("/Volumes/ELEMENTS/Cosas_Berna/Post/ERA5-Kenya-25-Present-Cumulus3-1Way-3Doms/RR-D02-ERA5-Kenya-25-Present-Cumulus3-1Way-3Doms-2008_daily.nc",write=FALSE)
xlon <- var.get.nc(wrfout, 'lon')
xlat <- var.get.nc(wrfout, 'lat')

WE <- length(xlon[,1])
SN <- length(xlon[1,])

xlon=deg2rad*xlon[]
xlat=deg2rad*xlat[]


Tabla <- rep(NA, 8)
for (stat in 1:length(nearests$StatID)) {
  
  stID=as.character(nearests$StatID[stat])
  Name=as.character(nearests$Name[stat])
  rlatdeg=nearests$lat[stat]
  rlondeg=nearests$lon[stat]
  relev=nearests$elev[stat]
  
  # radians
  rlat=deg2rad*rlatdeg
  rlon=deg2rad*rlondeg
  
  rpoint <- c(cos(rlat)*cos(rlon),cos(rlat)*sin(rlon),sin(rlat))
  closest=-2.0
  
  for(j in 1:SN){    
    for(i in 1:WE){
      gpoint <- c(cos(xlat[i,j])*cos(xlon[i,j]),cos(xlat[i,j])*sin(xlon[i,j]),sin(xlat[i,j]))
      thecos <- drop(gpoint%*%rpoint)
      
      if(thecos>closest){
          targetlat=xlat[i,j]
          targetlon=xlon[i,j]
          igridlon=i    
          igridlat=j
          closest=thecos
      }
    }   
  }
  
  Exp <- data.frame(stID,Name,rlatdeg,rlondeg,targetlat,targetlon,igridlon,igridlat)
  
  Tabla <- rbind(Tabla,Exp)


}

Tabla <- Tabla[-1,]


#       Guardamos los datos en un archivo
Tabla$targetlat <- Tabla$targetlat/deg2rad
Tabla$targetlon <- Tabla$targetlon/deg2rad

# Delete the rows that are not close to the domain
indexDelete <- (  (Tabla$igridlon == 1) | (Tabla$igridlat == 1) | (Tabla$igridlat == length(xlon[1,])) | (Tabla$igridlon == length(xlon[,1])) )
Tabla <- Tabla[!indexDelete,]

write.table(Tabla,file="nearest_SetUp25km_3Doms_d02.dat",
            append=FALSE,quote=FALSE,sep=";",row.names=FALSE,col.names=TRUE)

####################################################
#               Repeat for WRF GRID 03
####################################################


wrfout <- open.nc("/Volumes/ELEMENTS/Cosas_Berna/Post/ERA5-Kenya-25-Present-Cumulus3-1Way-3Doms/RR-D03-ERA5-Kenya-25-Present-Cumulus3-1Way-3Doms-2008_daily.nc",write=FALSE)
xlon <- var.get.nc(wrfout, 'lon')
xlat <- var.get.nc(wrfout, 'lat')

WE <- length(xlon[,1])
SN <- length(xlon[1,])

xlon=deg2rad*xlon[]
xlat=deg2rad*xlat[]

Tabla <- rep(NA, 8)
for (stat in 1:length(nearests$StatID)) {
  
  stID=as.character(nearests$StatID[stat])
  Name=as.character(nearests$Name[stat])
  rlatdeg=nearests$lat[stat]
  rlondeg=nearests$lon[stat]
  relev=nearests$elev[stat]
  
  # radians
  rlat=deg2rad*rlatdeg
  rlon=deg2rad*rlondeg
  
  rpoint <- c(cos(rlat)*cos(rlon),cos(rlat)*sin(rlon),sin(rlat))
  closest=-2.0
  
  for(j in 1:SN){    
    for(i in 1:WE){
      gpoint <- c(cos(xlat[i,j])*cos(xlon[i,j]),cos(xlat[i,j])*sin(xlon[i,j]),sin(xlat[i,j]))
      thecos <- drop(gpoint%*%rpoint)
      
      if(thecos>closest){
        targetlat=xlat[i,j]
        targetlon=xlon[i,j]
        igridlon=i    
        igridlat=j
        closest=thecos
      }
    }   
  }
  
  Exp <- data.frame(stID,Name,rlatdeg,rlondeg,targetlat,targetlon,igridlon,igridlat)
  
  Tabla <- rbind(Tabla,Exp)
  
  
}

Tabla <- Tabla[-1,]

#       Guardamos los datos en un archivo

Tabla$targetlat <- Tabla$targetlat/deg2rad
Tabla$targetlon <- Tabla$targetlon/deg2rad

# Delete the rows that are not close to the domain
indexDelete <- (  (Tabla$igridlon == 1) | (Tabla$igridlat == 1) | (Tabla$igridlat == length(xlon[1,])) | (Tabla$igridlon == length(xlon[,1])) )
Tabla <- Tabla[!indexDelete,]

write.table(Tabla,file="nearest_SetUp25km_3Doms_d03.dat",append=FALSE,quote=FALSE,sep=";",row.names=FALSE,col.names=TRUE)




####################################################
#
# 
#   Set-Up 27-9-3-1 km (4 Doms)
# 
#
####################################################

####################################################
#               WRF GRID 02
####################################################

deg2rad=acos(-1.0)/180.0

library(RNetCDF)
wrfout <- open.nc("/Volumes/ELEMENTS/Cosas_Berna/Post/ERA5-Kenya-Present-Cumulus3-1Way-4Doms/RR-D02-ERA5-Kenya-Present-Cumulus3-1Way-4Doms-2008_daily.nc",write=FALSE)
xlon <- var.get.nc(wrfout, 'lon')
xlat <- var.get.nc(wrfout, 'lat')

WE <- length(xlon[,1])
SN <- length(xlon[1,])

xlon=deg2rad*xlon[]
xlat=deg2rad*xlat[]


Tabla <- rep(NA, 8)
for (stat in 1:length(nearests$StatID)) {
  
  stID=as.character(nearests$StatID[stat])
  Name=as.character(nearests$Name[stat])
  rlatdeg=nearests$lat[stat]
  rlondeg=nearests$lon[stat]
  relev=nearests$elev[stat]
  
  # radians
  rlat=deg2rad*rlatdeg
  rlon=deg2rad*rlondeg
  
  rpoint <- c(cos(rlat)*cos(rlon),cos(rlat)*sin(rlon),sin(rlat))
  closest=-2.0
  
  for(j in 1:SN){    
    for(i in 1:WE){
      gpoint <- c(cos(xlat[i,j])*cos(xlon[i,j]),cos(xlat[i,j])*sin(xlon[i,j]),sin(xlat[i,j]))
      thecos <- drop(gpoint%*%rpoint)
      
      if(thecos>closest){
        targetlat=xlat[i,j]
        targetlon=xlon[i,j]
        igridlon=i    
        igridlat=j
        closest=thecos
      }
    }   
  }
  
  Exp <- data.frame(stID,Name,rlatdeg,rlondeg,targetlat,targetlon,igridlon,igridlat)
  
  Tabla <- rbind(Tabla,Exp)
  
  
}

Tabla <- Tabla[-1,]


#       Guardamos los datos en un archivo
Tabla$targetlat <- Tabla$targetlat/deg2rad
Tabla$targetlon <- Tabla$targetlon/deg2rad

# Delete the rows that are not close to the domain
indexDelete <- (  (Tabla$igridlon == 1) | (Tabla$igridlat == 1) | (Tabla$igridlat == length(xlon[1,])) | (Tabla$igridlon == length(xlon[,1])) )
Tabla <- Tabla[!indexDelete,]

write.table(Tabla,file="nearest_SetUp27km_4Doms_d02.dat",
            append=FALSE,quote=FALSE,sep=";",row.names=FALSE,col.names=TRUE)

####################################################
#               Repeat for WRF GRID 03
####################################################


wrfout <- open.nc("/Volumes/ELEMENTS/Cosas_Berna/Post/ERA5-Kenya-Present-Cumulus3-1Way-4Doms/RR-D03-ERA5-Kenya-Present-Cumulus3-1Way-4Doms-2008_daily.nc",write=FALSE)
xlon <- var.get.nc(wrfout, 'lon')
xlat <- var.get.nc(wrfout, 'lat')

WE <- length(xlon[,1])
SN <- length(xlon[1,])

xlon=deg2rad*xlon[]
xlat=deg2rad*xlat[]


Tabla <- rep(NA, 8)
for (stat in 1:length(nearests$StatID)) {
  
  stID=as.character(nearests$StatID[stat])
  Name=as.character(nearests$Name[stat])
  rlatdeg=nearests$lat[stat]
  rlondeg=nearests$lon[stat]
  relev=nearests$elev[stat]
  
  # radians
  rlat=deg2rad*rlatdeg
  rlon=deg2rad*rlondeg
  
  rpoint <- c(cos(rlat)*cos(rlon),cos(rlat)*sin(rlon),sin(rlat))
  closest=-2.0
  
  for(j in 1:SN){    
    for(i in 1:WE){
      gpoint <- c(cos(xlat[i,j])*cos(xlon[i,j]),cos(xlat[i,j])*sin(xlon[i,j]),sin(xlat[i,j]))
      thecos <- drop(gpoint%*%rpoint)
      
      if(thecos>closest){
        targetlat=xlat[i,j]
        targetlon=xlon[i,j]
        igridlon=i    
        igridlat=j
        closest=thecos
      }
    }   
  }
  
  Exp <- data.frame(stID,Name,rlatdeg,rlondeg,targetlat,targetlon,igridlon,igridlat)
  
  Tabla <- rbind(Tabla,Exp)
  
  
}

Tabla <- Tabla[-1,]

#       Guardamos los datos en un archivo

Tabla$targetlat <- Tabla$targetlat/deg2rad
Tabla$targetlon <- Tabla$targetlon/deg2rad

# Delete the rows that are not close to the domain
indexDelete <- (  (Tabla$igridlon == 1) | (Tabla$igridlat == 1) | (Tabla$igridlat == length(xlon[1,])) | (Tabla$igridlon == length(xlon[,1])) )
Tabla <- Tabla[!indexDelete,]

write.table(Tabla,file="nearest_SetUp27km_4Doms_d03.dat",append=FALSE,quote=FALSE,sep=";",row.names=FALSE,col.names=TRUE)



####################################################
#               Repeat for WRF GRID 04
####################################################


wrfout <- open.nc("/Volumes/ELEMENTS/Cosas_Berna/Post/ERA5-Kenya-Present-Cumulus3-1Way-4Doms/RR-D04-ERA5-Kenya-Present-Cumulus3-1Way-4Doms-2008_daily.nc",write=FALSE)
xlon <- var.get.nc(wrfout, 'lon')
xlat <- var.get.nc(wrfout, 'lat')

WE <- length(xlon[,1])
SN <- length(xlon[1,])

xlon=deg2rad*xlon[]
xlat=deg2rad*xlat[]


Tabla <- rep(NA, 8)
for (stat in 1:length(nearests$StatID)) {
  
  stID=as.character(nearests$StatID[stat])
  Name=as.character(nearests$Name[stat])
  rlatdeg=nearests$lat[stat]
  rlondeg=nearests$lon[stat]
  relev=nearests$elev[stat]
  
  # radians
  rlat=deg2rad*rlatdeg
  rlon=deg2rad*rlondeg
  
  rpoint <- c(cos(rlat)*cos(rlon),cos(rlat)*sin(rlon),sin(rlat))
  closest=-2.0
  
  for(j in 1:SN){    
    for(i in 1:WE){
      gpoint <- c(cos(xlat[i,j])*cos(xlon[i,j]),cos(xlat[i,j])*sin(xlon[i,j]),sin(xlat[i,j]))
      thecos <- drop(gpoint%*%rpoint)
      
      if(thecos>closest){
        targetlat=xlat[i,j]
        targetlon=xlon[i,j]
        igridlon=i    
        igridlat=j
        closest=thecos
      }
    }   
  }
  
  Exp <- data.frame(stID,Name,rlatdeg,rlondeg,targetlat,targetlon,igridlon,igridlat)
  
  Tabla <- rbind(Tabla,Exp)
  
  
}

Tabla <- Tabla[-1,]

#       Guardamos los datos en un archivo

Tabla$targetlat <- Tabla$targetlat/deg2rad
Tabla$targetlon <- Tabla$targetlon/deg2rad

# Delete the rows that are not close to the domain
indexDelete <- (  (Tabla$igridlon == 1) | (Tabla$igridlat == 1) | (Tabla$igridlat == length(xlon[1,])) | (Tabla$igridlon == length(xlon[,1])) )
Tabla <- Tabla[!indexDelete,]

write.table(Tabla,file="nearest_SetUp27km_4Doms_d04.dat",append=FALSE,quote=FALSE,sep=";",row.names=FALSE,col.names=TRUE)












####################################################
#
# 
#   Set-Up 5-1 km (2 Doms)
# 
#
####################################################

####################################################
#               WRF GRID 01
####################################################

deg2rad=acos(-1.0)/180.0

library(RNetCDF)
wrfout <- open.nc("/Volumes/ELEMENTS/Cosas_Berna/Post/ERA5-Kenya-5-Present-Cumulus3-1Way-2Doms/RR-D01-ERA5-Kenya-5-Present-Cumulus3-1Way-2Doms-2008_daily.nc",write=FALSE)
xlon <- var.get.nc(wrfout, 'lon')
xlat <- var.get.nc(wrfout, 'lat')

WE <- length(xlon[,1])
SN <- length(xlon[1,])

xlon=deg2rad*xlon[]
xlat=deg2rad*xlat[]


Tabla <- rep(NA, 8)
for (stat in 1:length(nearests$StatID)) {
  
  stID=as.character(nearests$StatID[stat])
  Name=as.character(nearests$Name[stat])
  rlatdeg=nearests$lat[stat]
  rlondeg=nearests$lon[stat]
  relev=nearests$elev[stat]
  
  # radians
  rlat=deg2rad*rlatdeg
  rlon=deg2rad*rlondeg
  
  rpoint <- c(cos(rlat)*cos(rlon),cos(rlat)*sin(rlon),sin(rlat))
  closest=-2.0
  
  for(j in 1:SN){    
    for(i in 1:WE){
      gpoint <- c(cos(xlat[i,j])*cos(xlon[i,j]),cos(xlat[i,j])*sin(xlon[i,j]),sin(xlat[i,j]))
      thecos <- drop(gpoint%*%rpoint)
      
      if(thecos>closest){
        targetlat=xlat[i,j]
        targetlon=xlon[i,j]
        igridlon=i    
        igridlat=j
        closest=thecos
      }
    }   
  }
  
  Exp <- data.frame(stID,Name,rlatdeg,rlondeg,targetlat,targetlon,igridlon,igridlat)
  
  Tabla <- rbind(Tabla,Exp)
  
  
}

Tabla <- Tabla[-1,]


# Guardamos los datos en un archivo
Tabla$targetlat <- Tabla$targetlat/deg2rad
Tabla$targetlon <- Tabla$targetlon/deg2rad

# Delete the rows that are not close to the domain
indexDelete <- (  (Tabla$igridlon == 1) | (Tabla$igridlat == 1) | (Tabla$igridlat == length(xlon[1,])) | (Tabla$igridlon == length(xlon[,1])) )
Tabla <- Tabla[!indexDelete,]

write.table(Tabla,file="nearest_SetUp5km_2Doms_d01.dat",
            append=FALSE,quote=FALSE,sep=";",row.names=FALSE,col.names=TRUE)

####################################################
#               Repeat for WRF GRID 02
####################################################


wrfout <- open.nc("/Volumes/ELEMENTS/Cosas_Berna/Post/ERA5-Kenya-5-Present-Cumulus3-1Way-2Doms/RR-D02-ERA5-Kenya-5-Present-Cumulus3-1Way-2Doms-2008_daily.nc",write=FALSE)
xlon <- var.get.nc(wrfout, 'lon')
xlat <- var.get.nc(wrfout, 'lat')

WE <- length(xlon[,1])
SN <- length(xlon[1,])

xlon=deg2rad*xlon[]
xlat=deg2rad*xlat[]

Tabla <- rep(NA, 8)
for (stat in 1:length(nearests$StatID)) {
  
  stID=as.character(nearests$StatID[stat])
  Name=as.character(nearests$Name[stat])
  rlatdeg=nearests$lat[stat]
  rlondeg=nearests$lon[stat]
  relev=nearests$elev[stat]
  
  # radians
  rlat=deg2rad*rlatdeg
  rlon=deg2rad*rlondeg
  
  rpoint <- c(cos(rlat)*cos(rlon),cos(rlat)*sin(rlon),sin(rlat))
  closest=-2.0
  
  for(j in 1:SN){    
    for(i in 1:WE){
      gpoint <- c(cos(xlat[i,j])*cos(xlon[i,j]),cos(xlat[i,j])*sin(xlon[i,j]),sin(xlat[i,j]))
      thecos <- drop(gpoint%*%rpoint)
      
      if(thecos>closest){
        targetlat=xlat[i,j]
        targetlon=xlon[i,j]
        igridlon=i    
        igridlat=j
        closest=thecos
      }
    }   
  }
  
  Exp <- data.frame(stID,Name,rlatdeg,rlondeg,targetlat,targetlon,igridlon,igridlat)
  
  Tabla <- rbind(Tabla,Exp)
  
  
}

Tabla <- Tabla[-1,]

#       Guardamos los datos en un archivo

Tabla$targetlat <- Tabla$targetlat/deg2rad
Tabla$targetlon <- Tabla$targetlon/deg2rad

# Delete the rows that are not close to the domain
indexDelete <- (  (Tabla$igridlon == 1) | (Tabla$igridlat == 1) | (Tabla$igridlat == length(xlon[1,])) | (Tabla$igridlon == length(xlon[,1])) )
Tabla <- Tabla[!indexDelete,]

write.table(Tabla,file="nearest_SetUp5km_2Doms_d02.dat",append=FALSE,quote=FALSE,sep=";",row.names=FALSE,col.names=TRUE)














####################################################
#
# 
#   Set-Up 9-3-1 km (3 Doms)
# 
#
####################################################

####################################################
#               WRF GRID 02
####################################################

deg2rad=acos(-1.0)/180.0

library(RNetCDF)
wrfout <- open.nc("/Volumes/ELEMENTS/Cosas_Berna/Post/ERA5-Kenya-Present-Cumulus3-1Way-3Doms/RR-D02-ERA5-Kenya-Present-Cumulus3-1Way-3Doms-2008_daily.nc",write=FALSE)
xlon <- var.get.nc(wrfout, 'lon')
xlat <- var.get.nc(wrfout, 'lat')

WE <- length(xlon[,1])
SN <- length(xlon[1,])

xlon=deg2rad*xlon[]
xlat=deg2rad*xlat[]


Tabla <- rep(NA, 8)
for (stat in 1:length(nearests$StatID)) {
  
  stID=as.character(nearests$StatID[stat])
  Name=as.character(nearests$Name[stat])
  rlatdeg=nearests$lat[stat]
  rlondeg=nearests$lon[stat]
  relev=nearests$elev[stat]
  
  # radians
  rlat=deg2rad*rlatdeg
  rlon=deg2rad*rlondeg
  
  rpoint <- c(cos(rlat)*cos(rlon),cos(rlat)*sin(rlon),sin(rlat))
  closest=-2.0
  
  for(j in 1:SN){    
    for(i in 1:WE){
      gpoint <- c(cos(xlat[i,j])*cos(xlon[i,j]),cos(xlat[i,j])*sin(xlon[i,j]),sin(xlat[i,j]))
      thecos <- drop(gpoint%*%rpoint)
      
      if(thecos>closest){
        targetlat=xlat[i,j]
        targetlon=xlon[i,j]
        igridlon=i    
        igridlat=j
        closest=thecos
      }
    }   
  }
  
  Exp <- data.frame(stID,Name,rlatdeg,rlondeg,targetlat,targetlon,igridlon,igridlat)
  
  Tabla <- rbind(Tabla,Exp)
  
  
}

Tabla <- Tabla[-1,]


#       Guardamos los datos en un archivo
Tabla$targetlat <- Tabla$targetlat/deg2rad
Tabla$targetlon <- Tabla$targetlon/deg2rad

# Delete the rows that are not close to the domain
indexDelete <- (  (Tabla$igridlon == 1) | (Tabla$igridlat == 1) | (Tabla$igridlat == length(xlon[1,])) | (Tabla$igridlon == length(xlon[,1])) )
Tabla <- Tabla[!indexDelete,]

write.table(Tabla,file="nearest_SetUp9km_3Doms_d02.dat",
            append=FALSE,quote=FALSE,sep=";",row.names=FALSE,col.names=TRUE)

####################################################
#               Repeat for WRF GRID 03
####################################################


wrfout <- open.nc("/Volumes/ELEMENTS/Cosas_Berna/Post/ERA5-Kenya-Present-Cumulus3-1Way-3Doms/RR-D03-ERA5-Kenya-Present-Cumulus3-1Way-3Doms-2008_daily.nc",write=FALSE)
xlon <- var.get.nc(wrfout, 'lon')
xlat <- var.get.nc(wrfout, 'lat')

WE <- length(xlon[,1])
SN <- length(xlon[1,])

xlon=deg2rad*xlon[]
xlat=deg2rad*xlat[]


Tabla <- rep(NA, 8)
for (stat in 1:length(nearests$StatID)) {
  
  stID=as.character(nearests$StatID[stat])
  Name=as.character(nearests$Name[stat])
  rlatdeg=nearests$lat[stat]
  rlondeg=nearests$lon[stat]
  relev=nearests$elev[stat]
  
  # radians
  rlat=deg2rad*rlatdeg
  rlon=deg2rad*rlondeg
  
  rpoint <- c(cos(rlat)*cos(rlon),cos(rlat)*sin(rlon),sin(rlat))
  closest=-2.0
  
  for(j in 1:SN){    
    for(i in 1:WE){
      gpoint <- c(cos(xlat[i,j])*cos(xlon[i,j]),cos(xlat[i,j])*sin(xlon[i,j]),sin(xlat[i,j]))
      thecos <- drop(gpoint%*%rpoint)
      
      if(thecos>closest){
        targetlat=xlat[i,j]
        targetlon=xlon[i,j]
        igridlon=i    
        igridlat=j
        closest=thecos
      }
    }   
  }
  
  Exp <- data.frame(stID,Name,rlatdeg,rlondeg,targetlat,targetlon,igridlon,igridlat)
  
  Tabla <- rbind(Tabla,Exp)
  
  
}

Tabla <- Tabla[-1,]

#       Guardamos los datos en un archivo

Tabla$targetlat <- Tabla$targetlat/deg2rad
Tabla$targetlon <- Tabla$targetlon/deg2rad

# Delete the rows that are not close to the domain
indexDelete <- (  (Tabla$igridlon == 1) | (Tabla$igridlat == 1) | (Tabla$igridlat == length(xlon[1,])) | (Tabla$igridlon == length(xlon[,1])) )
Tabla <- Tabla[!indexDelete,]

write.table(Tabla,file="nearest_SetUp9km_3Doms_d03.dat",append=FALSE,quote=FALSE,sep=";",row.names=FALSE,col.names=TRUE)



