;--------------------------------------------------------------------------------------
;
;  October 2020
;  Script associated to publication:
;  "Sensitivity of precipitation and temperature over Mount Kenya area to
;   physics parameterization options in a high-resolution model simulation
;   performed with WRFV3.8.1"
;  Authors: M. Messmer, S.j. González-Rojí, C.C. Raible and T.F. Stocker
;
;
;  Creative Commons Licence: Attribution-NonCommercial 4.0 International (CC BY-NC 4.0)
;--------------------------------------------------------------------------------------
begin

  region = "Kenya"
  in = addfile("rr_diff_clim_1979-2018_"+region+".nc","r")
  diff = in->rr_diff

  diff_pl_tmp = dim_avg_n(diff,(/1,2/))
  std = stddev(diff_pl_tmp)
  diff_pl = new((/3,dimsizes(diff_pl_tmp)/),typeof(diff_pl_tmp))
  diff_pl(0,:) = diff_pl_tmp
  diff_pl(1,:) = -0.5*std
  diff_pl(2,:) = 0.5*std

  printVarSummary(diff_pl)
  date = ispan(1979,2018,1)
  printVarSummary(date)

  wks   = gsn_open_wks ("pdf", "clim_"+region)
  res   = True
  res@gsnDraw  = False
  res@gsnFrame = False
  res@gsnScale = True  
  res@vpHeightF = 0.43        ; Changes the aspect ratio
  res@vpWidthF  = 0.85
  res@gsnMaximize = True
  res@trYMinF   = min(diff_pl)+0.05*min(diff_pl)    ; min value on x-axis
  res@trYMaxF   = max(diff_pl)+0.05*max(diff_pl)
  res@gsnYRefLine           = 0.              ; reference line
  res@gsnXYBarChart         = True            ; create bar chart
  res@gsnAboveYRefLineColor = "blue"          ; above ref line fill red
  res@gsnBelowYRefLineColor = "red"           ; below ref line fill blue
  res@xyLineColors = (/"blue","red"/)         ; colors for the above/blow
  res@tmXBLabelStride = 1
  res@tmXBLabelAngleF = 90.0
  res@tmXBLabelFontHeightF = 0.01
  res@tmXTLabelJust        = "CenterCenter"
  res@tmXBTickSpacingF     = 1
  res@tmXBMode = "Explicit"
  res@tmXBValues = ispan(1979,2018,1)
  res@tmXBLabels = ispan(1979,2018,1)
  plot = gsn_csm_xy (wks,date,diff_pl(0,:),res)
  delete(res@gsnAboveYRefLineColor)
  delete(res@gsnBelowYRefLineColor)
  delete(res@xyLineColors)
  res@xyLineColor = "black"
  res@gsnXYBarChart = False
  plota = gsn_csm_xy(wks,date,diff_pl(1:2,:),res)
  overlay(plot,plota)
  draw(plot)
  frame(wks)
end 
