
;--------------------------------------------------------------------------------------
;
;  October 2020
;  Script associated to publication:
;  "Sensitivity of precipitation and temperature over Mount Kenya area to
;   physics parameterization options in a high-resolution model simulation
;   performed with WRFV3.8.1"
;  Authors: M. Messmer, S.j. González-Rojí, C.C. Raible and T.F. Stocker
;
;
;  Creative Commons Licence: Attribution-NonCommercial 4.0 International (CC BY-NC 4.0)
;--------------------------------------------------------------------------------------

begin

  region = "Kenya"

  kk = addfile("wrfout_d01_"+region+".nc","r")
  kk2 = addfile("wrfout_d04_"+region+".nc","r") ; for 3 domain setting choose d03 here
  
  files = systemfunc("ls geo_em.d0*."+region+".nc")
  a = addfile(files(0),"r")
  b = addfile(files(1),"r")
  c = addfile(files(2),"r")
  d = addfile(files(3),"r")
  dim_d1 = dimsizes(a->LANDMASK(0,:,:))
  lsm1   = a->LANDMASK(0,:,:)
  topo1  = a->HGT_M(0,:,:)
  topo1  = where(topo1 .le. 0, 1, topo1)
  topo1  = where(lsm1 .eq. 0, -1, topo1)
  print(""+min(topo1))
  XLAT   = a->XLAT_M(0,:,:)
  XLONG  = a->XLONG_M(0,:,:)

  lat_right_d1 = a->XLAT_M(0,0,dim_d1(1)-1)
  lat_left_d1  = a->XLAT_M(0,dim_d1(0)-1,0)
  lon_right_d1 = a->XLONG_M(0,0,dim_d1(1)-1)
  lon_left_d1  = a->XLONG_M(0,dim_d1(0)-1,0)

  dim_d2 = dimsizes(b->LANDMASK(0,:,:))
  lsm2   = b->LANDMASK(0,:,:)
  topo2  = b->HGT_M(0,:,:)
  topo2  = where(topo2 .le. 0, 1, topo2)
  topo2  = where(lsm2 .eq. 0, -1, topo2)
  XLAT2  = b->XLAT_M(0,:,:)
  XLONG2 = b->XLONG_M(0,:,:)

  dim_d3 = dimsizes(c->LANDMASK(0,:,:))
  lsm3   = c->LANDMASK(0,:,:)
  topo3  = c->HGT_M(0,:,:)
  topo3  = where(topo3 .le. 0, 1, topo3)
  topo3  = where(lsm3 .eq. 0, -1, topo3)
  XLAT3  = c->XLAT_M(0,:,:)
  XLONG3 = c->XLONG_M(0,:,:)

  dim_d4 = dimsizes(d->LANDMASK(0,:,:))
  lsm4   = d->LANDMASK(0,:,:)
  topo4  = d->HGT_M(0,:,:)
  topo4  = where(topo4 .le. 0, 1, topo4)
  topo4  = where(lsm4 .eq. 0, -1, topo4)
  XLAT4  = d->XLAT_M(0,:,:)
  XLONG4 = d->XLONG_M(0,:,:)

  wks    = gsn_open_wks("pdf","WRF_domains"+region+"")
  gsn_merge_colormaps(wks,"gsdtol","precip2_15lev")
  gsn_draw_colormap(wks)


  cnres                       = True
  cnres@cnLinesOn             = False
  cnres@cnLineLabelsOn        = False
  cnres@cnInfoLabelOn         = False

  cnres@cnFillOn              = True
  cnres@cnFillMode            = "AreaFill"    ; This is the default.
  cnres@lbLabelFontHeightF    = 0.009
  cnres@lbLabelStride         = 1
  cnres@lbTitleString         = "meters a.s.l."
  cnres@lbTitleFontHeightF    = 0.015
  cnres@lbOrientation         = "Vertical"

  cnres@cnLevelSelectionMode  = "ExplicitLevels"
  cnres@cnLevels              = (/0, 200, 400, 600, 800, 1000, 1200, 1600, 2000,
                               2400, 2800, 3200, 3600, 4000, 4400, 4800/)
  cnres@cnFillColors          = (/39,12,13,15,16,18,19,21,22,24,25,26,27,
                                28,29,30,0/)

  cnres@gsnDraw               = False                         ; don't draw
  cnres@gsnFrame              = False                         ; don't advance frame
  cnres@gsnPaperOrientation   = "Portrait"
  cnres@gsnMaximize           = True
  cnres@gsnLeftString   = ""
  cnres@gsnCenterString = ""
  cnres@gsnRightString  = ""

  res = cnres   ; Copy contour resources for 1st plot.
  res@mpFillOn                = False
  res@mpPerimOn               = True
  res@mpOutlineBoundarySets   = "National"
  res@pmTickMarkDisplayMode   = "Always"
  res@mpGridAndLimbDrawOrder  = "PostDraw"
  res@mpNationalLineColor     = 11+31
  res@mpGeophysicalLineColor  =  8+31
  res@mpGridAndLimbOn         = True
  res@mpGridLatSpacingF       = 30
  res@mpGridLonSpacingF       = 30
  res = wrf_map_resources(kk,res)
  res@tfDoNDCOverlay          = True

  topo1@lat2d = XLAT
  topo1@lon2d = XLONG

  map  = gsn_csm_contour_map(wks, topo1, res)

  rese = cnres   ; Copy contour resources for 1st plot.
  rese= wrf_map_resources(kk2,rese)
  rese@tfDoNDCOverlay          = True
  map2 = gsn_csm_contour_map(wks, topo4, rese)
 
  res2              = cnres  ; Copy contour resources.
  res2@lbLabelBarOn = False  ; Labelbar already created in 1st plot
  res2@gsnMaximize  = False  ; Use maximization from original plot

  topo2@lat2d = XLAT2    ; Special method for setting 2D lat/lon coords
  topo2@lon2d = XLONG2

  plot2 = gsn_csm_contour(wks, topo2, res2)

  res3              = cnres  ; Copy contour resources.
  res3@gsnMaximize  = False  ; Use maximization from original plot
  res3@lbLabelBarOn = False  ; Labelbar already created in 1st plot

  topo3@lat2d = XLAT3    ; Special method for setting 2D lat/lon coords
  topo3@lon2d = XLONG3

  plot3 = gsn_csm_contour(wks, topo3, res3)

  res4              = cnres  ; Copy contour resources.
  res4@gsnMaximize  = False  ; Use maximization from original plot
  res4@lbLabelBarOn = False  ; Labelbar already created in 1st plot

  topo4@lat2d = XLAT4    ; Special method for setting 2D lat/lon coords
  topo4@lon2d = XLONG4

  plot4 = gsn_csm_contour(wks, topo4, res4)

  overlay(map, plot2)
  overlay(map, plot3)
  overlay(map, plot4)

  draw(map)

  pres                  = True               ; polyline resources
  pres@gsLineThicknessF = 2.0                ; line thickness
  pres@gsLineColor      = 14+31

  latbox2 = new(2*dim_d2(0)+2*dim_d2(1),typeof(XLAT2))
  lonbox2 = new(2*dim_d2(0)+2*dim_d2(1),typeof(XLONG2))
  latbox3 = new(2*dim_d3(0)+2*dim_d3(1),typeof(XLAT3))
  lonbox3 = new(2*dim_d3(0)+2*dim_d3(1),typeof(XLONG3))
  latbox4 = new(2*dim_d4(0)+2*dim_d4(1),typeof(XLAT4))
  lonbox4 = new(2*dim_d4(0)+2*dim_d4(1),typeof(XLONG4))

  do i = 0,dim_d2(0)-1
     latbox2(dim_d2(1)+i) = XLAT2(i,dim_d2(1)-1)
     lonbox2(dim_d2(1)+i) = XLONG2(i,dim_d2(1)-1)
     latbox2(dim_d2(0)+2*dim_d2(1)+i) = XLAT2(dim_d2(0)-1-i,0)
     lonbox2(dim_d2(0)+2*dim_d2(1)+i) = XLONG2(dim_d2(0)-1-i,0)
  end do

  do j = 0,dim_d2(1)-1
     lonbox2(j) = XLONG2(0,j)
     latbox2(j) = XLAT2(0,j)
     lonbox2(dim_d2(0)+dim_d2(1)+j) = XLONG2(dim_d2(0)-1,dim_d2(1)-1-j)
     latbox2(dim_d2(0)+dim_d2(1)+j) = XLAT2(dim_d2(0)-1,dim_d2(1)-1-j)
  end do

  do i = 0,dim_d3(0)-1
     latbox3(dim_d3(1)+i) = XLAT3(i,dim_d3(1)-1)
     lonbox3(dim_d3(1)+i) = XLONG3(i,dim_d3(1)-1)
     latbox3(dim_d3(0)+2*dim_d3(1)+i) = XLAT3(dim_d3(0)-1-i,0)
     lonbox3(dim_d3(0)+2*dim_d3(1)+i) = XLONG3(dim_d3(0)-1-i,0)
end do

  do j = 0,dim_d3(1)-1
     lonbox3(j) = XLONG3(0,j)
     latbox3(j) = XLAT3(0,j)
     lonbox3(dim_d3(0)+dim_d3(1)+j) = XLONG3(dim_d3(0)-1,dim_d3(1)-1-j)
     latbox3(dim_d3(0)+dim_d3(1)+j) = XLAT3(dim_d3(0)-1,dim_d3(1)-1-j)
  end do

  do i = 0,dim_d4(0)-1
     latbox4(dim_d4(1)+i) = XLAT4(i,dim_d4(1)-1)
     lonbox4(dim_d4(1)+i) = XLONG4(i,dim_d4(1)-1)
     latbox4(dim_d4(0)+2*dim_d4(1)+i) = XLAT4(dim_d4(0)-1-i,0)
     lonbox4(dim_d4(0)+2*dim_d4(1)+i) = XLONG4(dim_d4(0)-1-i,0)
  end do

  do j = 0,dim_d4(1)-1
     lonbox4(j) = XLONG4(0,j)
     latbox4(j) = XLAT4(0,j)
     lonbox4(dim_d4(0)+dim_d4(1)+j) = XLONG4(dim_d4(0)-1,dim_d4(1)-1-j)
     latbox4(dim_d4(0)+dim_d4(1)+j) = XLAT4(dim_d4(0)-1,dim_d4(1)-1-j)
  end do

  xndc2 = new(dimsizes(lonbox2),float)
  yndc2 = new(dimsizes(latbox2),float)
  xndc3 = new(dimsizes(lonbox3),float)
  yndc3 = new(dimsizes(latbox3),float)
  xndc4 = new(dimsizes(lonbox4),float)
  yndc4 = new(dimsizes(latbox4),float)

  datatondc(map, lonbox2,latbox2 , xndc2, yndc2)
  datatondc(map, lonbox3,latbox3 , xndc3, yndc3)
  datatondc(map, lonbox4,latbox4 , xndc4, yndc4)

  gsn_polyline_ndc(wks,xndc2,yndc2,pres)
  gsn_polyline_ndc(wks,xndc3,yndc3,pres)
  gsn_polyline_ndc(wks,xndc4,yndc4,pres)

  frame(wks)
  draw(map2)

  frame(wks)

end

}
