#------------------------------------------------------
#
#    October 2020
#    Script associated to publication:
#    "Sensitivity of precipitation and temperature over Mount Kenya area to 
#     physics parameterization options in a high-resolution modelsimulation 
#     performed with WRFV3.8.1"
#    Authors: M. Messmer, S.J. Gonzlez-Roj, C.C. Raible and T.F. Stocker
#
#
#    Creative Commons License: Attribution-NonCommercial 4.0 International (CC BY-NC 4.0)
#------------------------------------------------------

#--------------------------------
#
#
#               Domain 
#
#
#--------------------------------


#--------------------------------
#   Abrimos el archivo .nc
#--------------------------------

library(RNetCDF)
ERA5 <- open.nc("/Volumes/ELEMENTS/Cosas_Berna/Test_ERA5_Kenya/test2.nc", write=FALSE)

Prec <- var.get.nc(ERA5,'tp')*100

#--------------------------------
#   Cogemos los datos temporales y los pasamos a modo tabla
#--------------------------------

tvals=var.get.nc(ERA5,"time")
year=c()
imonth=c()
# This does NOT work unless you have already installed udunits2!!
utinit.nc()
tstring=att.get.nc(ERA5,"time","units")
tdates=utcal.nc(tstring,tvals)
tdates=tdates[,-c(3,4,5,6)]

#--------------------------------
# Calculate the sums of prec for Kenya
#--------------------------------

PrecSum <- vector()
for(n in 1:482){
  PrecSum[n]<- sum(Prec[,,n])
}

sumPrec <- cbind(tdates,PrecSum)


#--------------------------------
#   temporal mean for period1981 - 2010
#--------------------------------

sumPrec <- as.data.frame(sumPrec)

indexPeriod <- ( (sumPrec$year >= 1981) & (sumPrec$year <= 2010) )

SumPrecMonthlyRef <- aggregate(sumPrec[indexPeriod,-c(1:2)],
                               list(month=sumPrec$month[indexPeriod]),
                               mean, na.rm=TRUE) 
setEPS()
postscript("TS_1981-2010_Kenya.eps",width=12, height=8.5)

plot(SumPrecMonthlyRef$x,type = "l", xaxt="n", ylab="Precip (mm)", xlab="Months", 
     main = "Kenya", ylim=c(0,350))


MonthPrec2008 <- sumPrec[(sumPrec$year==2008),3]

lines(MonthPrec2008, col="blue")
legend("topleft",c("2008","1981-2010"),col = c("blue","black"),pch = 16)
abline(v=c(2.5, 5.5, 9.5, 11.5),col="grey80")
axis(side = 1, at=c(1:12), labels = c("J","F","M","A","M","J","J","A","S","O","N","D"))

dev.off()

#--------------------------------
#   BW
#--------------------------------

Matrix <- sumPrec

setEPS()
postscript("BW_1981-2010_Kenya.eps",width=12, height=8)

boxplot(Matrix$PrecSum[indexPeriod]~Matrix$month[indexPeriod], ylab="Precipitation (mm)", xlab="Months", xaxt="n", 
        ylim=c(0,700), main="Accumulated precipitation (Kenya)", cex.axis=1.5, cex.lab=1.5, cex.main=1.5)
grid()
axis(side = 1, at=c(1:12), labels = c("J","F","M","A","M","J","J","A","S","O","N","D"), cex.axis=1.5)

x=1:12
segments(x0=x-0.5*0.8, x1=x+0.5*0.8,y0=as.numeric(as.character(MonthPrec2008)), 
         y1=as.numeric(as.character(MonthPrec2008)), col="blue",lty=1,lwd = 3)


legend("topleft",ncol = 2, c("2008","1981-2010"), col = c("blue","black"),
       lty = c(1,1),lwd = c(3,3), bg = "white", cex=1.5)

dev.off()

