% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/uni-cox.R
\name{uni.cox}
\alias{uni.cox}
\title{uni.cox
Performs univariate cox proportional hazard model on every feature}
\usage{
uni.cox(X, surv.dat, surv.formula, filter = 0, genes = NULL)
}
\arguments{
\item{X}{Matrix/surv.datframe of genomic features, continuous or binary (note cannot handle categorical surv.dat for the moment).}

\item{surv.dat}{a surv.dat frame containing the survival information. This can be made of 2 or 3 columns. 1 or 2 for time,
and one for status (where 1 is event and 0 is no event).}

\item{surv.formula}{a survival formula with names matching those in surv.dat eg: Surv(time,status)~.}

\item{filter}{a numeric value between 0 and 1 (1 not included) that is the lower bound for the proportion of patients
having a genetic event (only for binary features). All features with an event rate lower than that value will be removed.
Default is 0 (all features included).}

\item{genes}{a character vector of gene names that will be the only ones to be kept. Default is NULL, all genes are used.}
}
\value{
tab A table of all the fits performed sorted by adjusted pvalues.

p An interactive plot of log(pvalue) by hazard ration.

KM List of survival plots of the top 10 most significant genes
}
\description{
uni.cox
Performs univariate cox proportional hazard model on every feature
}
\examples{
library(gnomeR)
library(dplyr)
library(dtplyr)
patients <- as.character(unique(mut$Tumor_Sample_Barcode))[1:200]
gen.dat <- binmat(patients = patients,maf = mut)
surv.dat <- clin.patients \%>\%
filter(X.Patient.Identifier \%in\%
abbreviate(patients,strict = TRUE, minlength = 9)) \%>\%
  select(X.Patient.Identifier,Overall.Survival..Months.,
   Overall.Survival.Status) \%>\%
  rename(DMPID = X.Patient.Identifier,
   time = Overall.Survival..Months.,
   status = Overall.Survival.Status) \%>\%
  mutate(time = as.numeric(as.character(time)),
         status = ifelse(status == "LIVING",0,1)) \%>\%
  filter(!is.na(time))
X <- gen.dat[match(surv.dat$DMPID,
abbreviate(rownames(gen.dat),strict = TRUE, minlength = 9)),]
uni.cox(X = X, surv.dat = surv.dat,
surv.formula = Surv(time,status)~.,filter = 0.05)
}
