% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gnomer_color_palette.R
\name{scale_fill_pancan}
\alias{scale_fill_pancan}
\title{Fill scale creator to add gnomeR colors in ggplot}
\usage{
scale_fill_pancan(palette = "sunset", discrete = TRUE, reverse = FALSE, ...)
}
\arguments{
\item{palette}{Character name of palette in msk_palettes, supplied in quotes.
Options include "main", "pancan", "sunset" (default).}

\item{discrete}{Boolean indicating whether color aesthetic is discrete or not.
Default is TRUE.}

\item{reverse}{Boolean indicating whether the palette should be reversed.
Default is FALSE.}

\item{...}{Additional arguments passed to discrete_scale() or
scale_color_gradientn(), used respectively when discrete is TRUE or FALSE}
}
\description{
This fill scale generator will interpolate between the colors
in the palette provided
}
\examples{

library(ggplot2)

# use a fill color
# alternative use that involves interpolation
ggplot(iris, aes(x = Sepal.Length, fill = Species)) +
geom_histogram(bins = 20, position = "dodge") +
scale_fill_pancan()
}
