% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gnomer_color_palette.R
\name{scale_color_pancan}
\alias{scale_color_pancan}
\title{Color scale creator to add gnomeR colors in ggplot}
\usage{
scale_color_pancan(palette = "main", discrete = TRUE, reverse = FALSE, ...)
}
\arguments{
\item{palette}{Character name of palette in msk_palettes, supplied in quotes.
Options include "main" (default), "pancan", "sunset".}

\item{discrete}{Boolean indicating whether color aesthetic is discrete.
Default is TRUE.}

\item{reverse}{Boolean indicating whether the palette should be reversed.
Default is FALSE.}

\item{...}{Additional arguments passed to discrete_scale() or
scale_color_gradientn(), used respectively when discrete is TRUE or FALSE}
}
\description{
This color scale generator will interpolate between colors,
even when discrete scales are provided.
To use exact discrete colors, see examples in \code{gnomer_palette}
}
\examples{

library(ggplot2)

# use a discrete color scale
ggplot(iris, aes(Sepal.Width, Sepal.Length, color = Species)) +
geom_point(size = 4) +
scale_color_pancan("pancan")

# use a continuous color scale
ggplot(iris, aes(Sepal.Width, Sepal.Length, color = Sepal.Length)) +
geom_point(size = 4, alpha = .6) +
scale_color_pancan(palette = "sunset", discrete = FALSE)
}
