% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/maf-viz.R
\name{maf_viz}
\alias{maf_viz}
\title{Creates a set of plot summarising a maf file.}
\usage{
maf_viz(maf, ...)
}
\arguments{
\item{maf}{Raw maf dataframe containing alteration data}

\item{...}{any argument belonging to the binmat method}
}
\value{
Returns a list of the following plots:

varclass Barplot of counts of each variant classification

vartype Barplot of counts of each variant type

snvclass Histogram of counts of each SNV class

samplevar Histogram of counts variants per patient

topgenes Barplot of counts of top variant genes

genecor Correlation heatmap of the top 10 genes
}
\description{
Creates a set of plot summarising a maf file.
}
\examples{
library(gnomeR)
library(dplyr)
library(dtplyr)
patients <- as.character(unique(mut$Tumor_Sample_Barcode))[1:200]
all.plots <- maf_viz(maf=mut \%>\% filter(Tumor_Sample_Barcode \%in\% patients))
all.plots <- maf_viz(maf=mut \%>\%
filter(Tumor_Sample_Barcode \%in\% patients),specify.plat = TRUE)
}
