% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gnomer_color_palette.R
\name{gnomer_palette}
\alias{gnomer_palette}
\title{Access the colors in a gnomeR color palette}
\usage{
gnomer_palette(name = "pancan", n, type = c("discrete", "continuous"))
}
\arguments{
\item{name}{Name of desired palette, supplied in quotes. Choices are:
"pancan" (default) (best for discrete), "main" (better for discrete), "sunset" (continuous)}

\item{n}{Number of colors desired. If omitted, uses all colors,
or the needed number of colors if less than the total.}

\item{type}{Either "continuous" or "discrete". Use continuous if you want
to automatically interpolate between colours.
  @importFrom graphics rgb rect par image text
  @importFrom grDevices colorRampPalette}
}
\value{
A vector of colours.
}
\description{
gnomeR colors can be accessed and used in plotting
}
\examples{

library(ggplot2)

# Print a plot showing the colors in a palette, in order
gnomer_palette("pancan")

# use a single brand color from a palette
# here using the fourth color from the "pancan" palette
ggplot(mtcars, aes(hp, mpg)) +
geom_point(size = 4, color = gnomer_palette("pancan")[4])

# use a discrete color scale - uses fixed colors from the requested palette
ggplot(iris, aes(Sepal.Width, Sepal.Length, color = Species)) +
geom_point(size = 4) +
scale_color_manual(values = gnomer_palette("pancan"))

# use a continuous color scale - interpolates between colors
ggplot(iris, aes(Sepal.Width, Sepal.Length, color = Sepal.Length)) +
geom_point(size = 4, alpha = .6) +
scale_color_gradientn(colors = gnomer_palette("sunset", type = "continuous"))

# use a fill color
ggplot(iris, aes(x = Sepal.Length, fill = Species)) +
geom_histogram(bins = 20, position = "dodge") +
scale_fill_manual(values = gnomer_palette("pancan"))

}
\keyword{colors}
