% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_tmb.R
\name{get_tmb}
\alias{get_tmb}
\title{get_tmb
Function to calculate the tumor mutation burden of individual patients in a MAF file. Note that this can only be applied to
samples sequenced using one of the IMPACT panels. Other samples will be annotated as missing.}
\usage{
get_tmb(
  patients = NULL,
  maf = NULL,
  mut.type = "SOMATIC",
  col.names = c(Tumor_Sample_Barcode = NULL, Hugo_Symbol = NULL, Variant_Classification
    = NULL, Mutation_Status = NULL, Variant_Type = NULL),
  ...
)
}
\arguments{
\item{patients}{a character vector that let's the user specify the patients to be used to create the matrix.
Default is NULL is which case all patients in the MAF file will be used.}

\item{maf}{A MAF file of interest.}

\item{mut.type}{The mutation type to be used. Options are "SOMATIC", "GERMLINE" or "ALL". Note "ALL" will
keep all mutations regardless of status (not recommended). Default is SOMATIC.}

\item{col.names}{character vector of the necessary columns to be used. By default: col.names = c(Tumor_Sample_Barcode = NULL,
Hugo_Symbol = NULL, Variant_Classification = NULL, Mutation_Status = NULL, Variant_Type = NULL).}

\item{...}{Further arguments passed belonging to the binmat function.}
}
\value{
TMB A single column dataframe containing the calculated tumor mutation burden of all samples specified adjusted
 for the IMPACT panel used for sequencing.
}
\description{
get_tmb
Function to calculate the tumor mutation burden of individual patients in a MAF file. Note that this can only be applied to
samples sequenced using one of the IMPACT panels. Other samples will be annotated as missing.
}
\examples{
library(gnomeR)
TMB <- get_tmb(maf = mut)
}
