% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gen-summary.R
\name{gen.summary}
\alias{gen.summary}
\title{gen.summary}
\usage{
gen.summary(gen.dat, outcome, filter = 0, paired = F, cont = F, rank = T)
}
\arguments{
\item{gen.dat}{A matrix or dataframe, with patients as rows and features as columns.}

\item{outcome}{A leveled vector of length equal to the number of rows in gen.dat.}

\item{filter}{a numeric value between 0 and 1 (1 not included) that is the lower bound for the proportion of patients
having a genetic event (only for binary features). All features with an event rate lower than that value will be removed.
Default is 0 (all features included).}

\item{paired}{Boolean if the data are paired. Default is FALSE.}

\item{cont}{Should the outcome be treated as a continuous value. Default is FALSE treated as categorical.}

\item{rank}{Should the table returned be ordered by Pvalue. Boolean, default is T}
}
\value{
fits : a table of odds ratio and pvalues.

forest.plot : A forest plot of the top 10 hits.
}
\description{
Creates a summary table of the distribution of the genetic features by a specific outcome/covariate of interest. The difference
is tested using Fisher's exact test and further adjusted for multiple comparisons. Note that continuous genetic factors
are dichotomized at their median.
}
\examples{
library(gnomeR)
patients <- as.character(unique(mut$Tumor_Sample_Barcode))
## binary outcome ##
outcome <- as.character(clin.sample$Sample.Type[match(patients,clin.sample$Sample.Identifier)])
gen.dat <- binmat(patients = patients,maf = mut)
gen.summary(gen.dat = gen.dat,
        outcome = outcome,
        filter = 0.05,paired = FALSE,
        cont = FALSE,rank = TRUE)
## Continuous outcome ##
set.seed(1)
outcome <-  rnorm(n = nrow(gen.dat))
tab.out <- gen.summary(gen.dat = gen.dat,
                   outcome = outcome,
                   filter = 0.05,paired = FALSE,
                   cont = TRUE,rank = TRUE)
tab.out$fits
tab.out$vPlot
}
