% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/facets-dat.R
\name{facets.dat}
\alias{facets.dat}
\title{facets.dat}
\usage{
facets.dat(
  seg = NULL,
  filenames = NULL,
  path = NULL,
  patients = NULL,
  min.purity = 0.3,
  epsilon = 0.005,
  adaptive = FALSE
)
}
\arguments{
\item{seg}{a segmentation file containing the segmentation information of multiple patients}

\item{filenames}{the names of the segment files to be loaded and processed (Note must end in ".Rdata").}

\item{path}{the relative path to the files folder from your current directory}

\item{patients}{the names of the patients of the respective filenames. Default simply 1 to number of files.}

\item{min.purity}{the minimum purity of the sample required to be kept in the final dataset. Default is 0.3.}

\item{epsilon}{level of unions when aggregating segments between. Default is 0.005.}

\item{adaptive}{CNregions option to create adaptive segments. Default is FALSE.}
}
\value{
out.cn : a matrix of the union of all segment files with patients as rows and segments as columns

ploidy : a vector of the ploidy values for the patients in out.cn

purity : a vector of the purity values for the patients in out.cn

FGAs : a vector of the fragment of genome altered values for the patients in out.cn
}
\description{
Creates a copy number alteration matrix from segment files.
}
\examples{
library(gnomeR)
library(dplyr)
library(dtplyr)
patients <- as.character(unique(mut$Tumor_Sample_Barcode))[1:1000]
patients.seg <- as.character(unlist(clin.sample \%>\%
filter(Sample.Identifier \%in\% patients,
as.numeric(as.character(Tumor.Purity)) > 30) \%>\%
 select(Sample.Identifier)))
facet <- facets.dat(seg = seg, patients=patients.seg[0:100])
}
