% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/make-oncoprint-dat.R
\name{dat.oncoPrint}
\alias{dat.oncoPrint}
\title{dat.oncoPrint
Enables creation of a matrix used to generate an OncoPrint heatmap.}
\usage{
dat.oncoPrint(gen.dat, clin.dat = NULL)
}
\arguments{
\item{gen.dat}{A binary matrix or dataframe, with patients as rows and features as columns. Note that the names of the
columns must end in ".Del" or ".Amp" to recognize copy number alterations. (see create.bin.matrix for more details on this format).}

\item{clin.dat}{An optional clinical file, including only the features the user wishes to add to the plot. Default is NULL.}
}
\value{
mat : a matrix ready to be plotted using plot.Oncoprint().
}
\description{
dat.oncoPrint
Enables creation of a matrix used to generate an OncoPrint heatmap.
}
\examples{
library(gnomeR)
patients <- as.character(unique(mut$Tumor_Sample_Barcode))
bin.mut <- binmat(patients = patients,maf = mut,mut.type = "SOMATIC",
SNP.only = FALSE,include.silent = FALSE, specify.plat = FALSE)
gen.dat <- bin.mut[1:500,
names(sort(apply(bin.mut,2, sum),decreasing = TRUE))[1:15]]
dat <- dat.oncoPrint(gen.dat)
## adding clinical ##
clin.patients.dat <-
clin.patients[match(abbreviate(rownames(gen.dat),
strict = TRUE, minlength = 9),
clin.patients$X.Patient.Identifier),] \%>\%
dplyr::rename(DMPID = X.Patient.Identifier,
 Smoker = Smoking.History) \%>\%
  dplyr::select(DMPID, Sex,Smoker) \%>\%
  dplyr::filter(!is.na(DMPID)) \%>\%
  dplyr::distinct(DMPID,.keep_all = TRUE)
gen.dat <- gen.dat[match(clin.patients.dat$DMPID,
abbreviate(rownames(gen.dat),strict = TRUE, minlength = 9)),]
clin.patients.dat <- clin.patients.dat \%>\%
dplyr::mutate(DMPID = as.character(DMPID)) \%>\%
  tibble::column_to_rownames('DMPID')
rownames(gen.dat) <- rownames(clin.patients.dat)
dat <- dat.oncoPrint(gen.dat = gen.dat,clin.dat = clin.patients.dat)
}
