% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/make-custom-pathway.R
\name{custom_pathway}
\alias{custom_pathway}
\title{custom_pathway
Enables creation of a custom pathway binary matrix from a binmat() `object`}
\usage{
custom_pathway(mat, pathway)
}
\arguments{
\item{mat}{a binmat() binary matrix}

\item{pathway}{a dataframe/tibble with first column the name of the genes, and second column their corresponding
pathway}
}
\value{
pathway_dat : a binary matrix of pathway level alterations
}
\description{
custom_pathway
Enables creation of a custom pathway binary matrix from a binmat() `object`
}
\examples{
library(gnomeR)
patients <- as.character(unique(mut$Tumor_Sample_Barcode))[1:200]
bin.mut <- binmat(patients = patients,maf = mut)
pathway <- as.data.frame(cbind(c("PIK3CA","KRAS","TERT","TP53"),c("path1","path1","path2","path3")))
custom_pathway(mat = bin.mut, pathway = pathway)
}
