% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mod-CNregions.R
\name{CNregions.mod}
\alias{CNregions.mod}
\title{CNregions.mod
Modified CNregions function from the facets package to handle small sample sizes.}
\usage{
CNregions.mod(
  seg,
  epsilon = 0.005,
  adaptive = FALSE,
  rmCNV = FALSE,
  cnv = NULL,
  frac.overlap = 0.5,
  rmSmallseg = TRUE,
  nProbes = 15
)
}
\arguments{
\item{seg}{a segmentation file containing the segmentation information of multiple patients}

\item{epsilon}{the maximum Euclidean distance between adjacent probes tolerated for denying a nonredundant region. epsilon=0 is equivalent to taking the union of all unique break points across the n samples.}

\item{adaptive}{Vector of length-m lasso penalty terms.}

\item{rmCNV}{If TRUE, remove germline CNV.}

\item{cnv}{A data frame containing germline CNV data.}

\item{frac.overlap}{A parameter needed to be explain.}

\item{rmSmallseg}{If TRUE, remove small segment.}

\item{nProbes}{The segment length threshold below which the segment will be removed if rmSmallseq = TRUE.}
}
\value{
reducedM : A matrix ready for plotting.
}
\description{
CNregions.mod
Modified CNregions function from the facets package to handle small sample sizes.
}
\examples{
library(gnomeR)
library(dplyr)
samples <-
as.character(unique(mut$Tumor_Sample_Barcode))[
sample(1:length(unique(mut$Tumor_Sample_Barcode)), 100, replace=FALSE)]
CNregions.mod(seg \%>\% filter(ID \%in\% samples))
}
