import re
from pymongo import MongoClient

def get_smell_term_list(filepath):
    smell_term_list = []
    f = open(filepath)
    line = f.readline()
    while line:
        smell_term_list.append(line.strip('\n'))
        line = f.readline()
    f.close()
    return smell_term_list


def query_comment(filepath, changes_comments_set):
    smell_term_list = get_smell_term_list(filepath)
    for smell_term in smell_term_list:
        num = 0
        for change_comment in changes_comments_set.find():
            if re.search(smell_term.lower().replace(' ', '(-| )'), change_comment['message'].lower()):
                print(change_comment['message'])
                print('https://review.opendev.org/#/q/' + change_comment['change_id'].replace('%2F', '/'))
                print('-' * 500)
                num += 1
        if num != 0:
            print('smell term = ' + smell_term + ', num = ' + str(num))
            print("==============" * 50)


# search
conn = MongoClient('127.0.0.1', 27017)
db = conn.nova_changes_db
changes_comments_set = db.changes_comments_set_14

# query_comment('./smell-term/general_smell_terms.txt', changes_comments_set)
query_comment('./smell-term/specific_smell_terms.txt', changes_comments_set)